Welcome to the manual for **libctl**, a Guile-based library implementing flexible control files for scientific simulations. This documentation is divided into the following sections, which you should read roughly in order if you are new to libctl:

-   [Introduction](/Introduction) &mdash; Motivation, history, and high-level structure of libctl.
-   [Installation](/Installation) &mdash; Instructions for installing libctl on Unix-like systems such as Linux and macOS
-   [Basic User Experience](/Basic_User_Experience) &mdash; Features of a basic **ctl** control file.
-   [Advanced User Experience](/Advanced_User_Experience) &mdash; The ctl file is actually a Scheme program running in a full interpreter (called Guile) which enables a broad range of functionality.
-   [User Reference](/libctl_User_Reference ) &mdash; Compact listing of the various functions provided for the user.
-   [Developer Experience](/Developer_Experience) &mdash; By specifying an abstract **specification file** that describes the information that is exchanged with the ctl file, nearly everything else can be automated.
-   [Guile and Scheme Information](/Guile_and_Scheme_links) &mdash; Guile is a standard GNU program for adding scripting and extensibility to software. It implements an embeddable interpreter for the Scheme language. There are many places that you can go to learn more about Guile and Scheme, and we link to a few of them here.
-   [License and Copyright](/License_and_Copyright) &mdash; libctl is free and open-source software under the [GNU General Public License](http://www.gnu.org/copyleft/gpl.html) (GNU LGPL).

Feedback
--------

For questions, bug reports, and feature requests, please file a [GitHub issue](https://github.com/stevengj/libctl/issues).
