/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;

public class HTML5CaseBlindCollator
implements StringCollator,
SubstringMatcher {
    private static final HTML5CaseBlindCollator theInstance = new HTML5CaseBlindCollator();

    public static HTML5CaseBlindCollator getInstance() {
        return theInstance;
    }

    @Override
    public String getCollationURI() {
        return "http://www.w3.org/2005/xpath-functions/collation/html-ascii-case-insensitive";
    }

    @Override
    public int compareStrings(UnicodeString a, UnicodeString b) {
        return this.compareCS(a, b);
    }

    private int compareCS(UnicodeString a, UnicodeString b) {
        int nextb;
        int nexta;
        int c;
        long alen = a.length();
        long blen = b.length();
        long i = 0L;
        long j = 0L;
        do {
            if (i == alen) {
                if (j == blen) {
                    return 0;
                }
                return -1;
            }
            if (j == blen) {
                return 1;
            }
            nexta = a.codePointAt(i++);
            nextb = b.codePointAt(j++);
            if (nexta >= 97 && nexta <= 122) {
                nexta -= 32;
            }
            if (nextb < 97 || nextb > 122) continue;
            nextb -= 32;
        } while ((c = nexta - nextb) == 0);
        return c;
    }

    @Override
    public boolean comparesEqual(UnicodeString s1, UnicodeString s2) {
        return this.compareCS(s1, s2) == 0;
    }

    @Override
    public boolean contains(UnicodeString s1, UnicodeString s2) {
        return this.normalize(s1).indexOf(this.normalize(s2), 0L) >= 0L;
    }

    @Override
    public boolean endsWith(UnicodeString s1, UnicodeString s2) {
        return this.normalize(s1).hasSubstring(this.normalize(s2), s1.length() - s2.length());
    }

    @Override
    public boolean startsWith(UnicodeString s1, UnicodeString s2) {
        return this.normalize(s1).hasSubstring(this.normalize(s2), 0L);
    }

    @Override
    public UnicodeString substringAfter(UnicodeString s1, UnicodeString s2) {
        long i = this.normalize(s1).indexOf(this.normalize(s2), 0L);
        if (i < 0L) {
            return EmptyUnicodeString.getInstance();
        }
        return s1.substring(i + s2.length(), s1.length());
    }

    @Override
    public UnicodeString substringBefore(UnicodeString s1, UnicodeString s2) {
        long j = this.normalize(s1).indexOf(this.normalize(s2), 0L);
        if (j < 0L) {
            return EmptyUnicodeString.getInstance();
        }
        return s1.prefix(j);
    }

    @Override
    public AtomicMatchKey getCollationKey(UnicodeString s2) {
        return this.normalize(s2);
    }

    private UnicodeString normalize(UnicodeString cs) {
        UnicodeBuilder sb = new UnicodeBuilder(cs.length32());
        IntIterator iter = cs.codePoints();
        while (iter.hasNext()) {
            int c = iter.next();
            if (97 <= c && c <= 122) {
                sb.append((char)(c + 65 - 97));
                continue;
            }
            sb.append(c);
        }
        return sb.toUnicodeString();
    }
}

