#
# PySNMP MIB module SMON-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/SMON-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:28:37 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, Integer, OctetString, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "Integer", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueRangeConstraint, SingleValueConstraint, ValueSizeConstraint, ConstraintsIntersection, ConstraintsUnion, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueRangeConstraint", "SingleValueConstraint", "ValueSizeConstraint", "ConstraintsIntersection", "ConstraintsUnion")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( OwnerString, rmon, ) = mibBuilder.importSymbols("RMON-MIB", "OwnerString", "rmon")
( rmonConformance, LastCreateTime, DataSource, probeConfig, ) = mibBuilder.importSymbols("RMON2-MIB", "rmonConformance", "LastCreateTime", "DataSource", "probeConfig")
( ModuleCompliance, ObjectGroup, NotificationGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup", "NotificationGroup")
( ModuleIdentity, iso, TimeTicks, Gauge32, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, Bits, Integer32, Counter32, Unsigned32, Counter64, ObjectIdentity, IpAddress, NotificationType, ) = mibBuilder.importSymbols("SNMPv2-SMI", "ModuleIdentity", "iso", "TimeTicks", "Gauge32", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Bits", "Integer32", "Counter32", "Unsigned32", "Counter64", "ObjectIdentity", "IpAddress", "NotificationType")
( RowStatus, DisplayString, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "DisplayString", "TextualConvention")
switchRMON = ModuleIdentity((1, 3, 6, 1, 2, 1, 16, 22))
if mibBuilder.loadTexts: switchRMON.setLastUpdated('9812160000Z')
if mibBuilder.loadTexts: switchRMON.setOrganization('IETF RMON MIB Working Group')
if mibBuilder.loadTexts: switchRMON.setContactInfo('IETF RMONMIB WG Mailing list: rmonmib@cisco.com\n\n                Rich Waterman\n                Allot Networks Inc.\n                Tel:  +1-408-559-0253\n                Email: rich@allot.com\n\n                Bill Lahaye\n                Xylan Corp.\n                Tel: +1-800-995-2612\n                Email:  lahaye@ctron.com\n\n                Dan Romascanu\n                Lucent Technologies\n                Tel:  +972-3-645-8414\n                Email: dromasca@lucent.com\n\n                Steven Waldbusser\n                International Network Services\n                Tel: +1-415-254-4251\n                Email: waldbusser@ins.com')
if mibBuilder.loadTexts: switchRMON.setDescription('The MIB module for managing remote monitoring device\n                 implementations for Switched Networks')
smonMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1))
dataSourceCaps = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1, 1))
smonStats = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1, 2))
portCopyConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1, 3))
smonRegistrationPoints = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1, 4))
class SmonDataSource(ObjectIdentifier, TextualConvention):
    pass

smonCapabilities = MibScalar((1, 3, 6, 1, 2, 1, 16, 19, 15), Bits().clone(namedValues=NamedValues(("smonVlanStats", 0), ("smonPrioStats", 1), ("dataSource", 2), ("smonUnusedBit", 3), ("portCopy", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonCapabilities.setDescription('An indication of the SMON MIB groups supported\n         by this agent.')
dataSourceCapsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1), )
if mibBuilder.loadTexts: dataSourceCapsTable.setDescription("This table describes RMON data sources and port copy\n        capabilities. An NMS MAY use this table to discover the\n        identity and attributes of the data sources on a given agent\n        implementation. Similar to the probeCapabilities object,\n        actual row-creation operations will succeed or fail based on\n        the resources available and parameter values used in each\n        row-creation operation.\n\n        Upon restart of the RMON agent, the dataSourceTable, ifTable,\n        and perhaps entPhysicalTable are initialized for the available\n        dataSources.\n\n        For each dataSourceCapsEntry representing a VLAN or\n        entPhysicalEntry the agent MUST create an associated ifEntry\n        with a ifType value of 'propVirtual(53)'. This ifEntry will be\n        used as the actual value in RMON control table dataSource\n        objects. The assigned ifIndex value is copied into the\n        associated dataSourceCapsIfIndex object.\n        It is understood that dataSources representing VLANs may not\n        always be instantiated immediately upon restart, but rather as\n        VLAN usage is detected by the agent. The agent SHOULD attempt\n        to create dataSource and interface entries for all dataSources\n        as soon as possible.")
dataSourceCapsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1, 1), ).setIndexNames((1, "SMON-MIB", "dataSourceCapsObject"))
if mibBuilder.loadTexts: dataSourceCapsEntry.setDescription('Entries per data source containing descriptions of data\n         source and port copy capabilities. This table is populated by\n         the SMON agent with one entry for each supported data\n         source.')
dataSourceCapsObject = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1, 1, 1), SmonDataSource())
if mibBuilder.loadTexts: dataSourceCapsObject.setDescription('Defines an object that can be a SMON data source or a\n          source or a destination for a port copy operation.')
dataSourceRmonCaps = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1, 1, 2), Bits().clone(namedValues=NamedValues(("countErrFrames", 0), ("countAllGoodFrames", 1), ("countAnyRmonTables", 2), ("babyGiantsCountAsGood", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dataSourceRmonCaps.setDescription(" General attributes of the specified dataSource. Note that\n        these are static attributes, which SHOULD NOT be adjusted\n        because of current resources or configuration.\n\n      - countErrFrames(0)\n          The agent sets this bit for the dataSource if errored frames\n          received on this dataSource can actually be monitored by the\n          agent The agent clears this bit if any errored frames are\n          not visible to the RMON data collector.\n\n      - countAllGoodFrames(1)\n          The agent sets this bit for the dataSource if all good\n          frames received on this dataSource can actually be monitored\n          by the agent. The agent clears this bit if any good frames\n          are not visible for RMON collection, e.g., the dataSource is\n          a non-promiscuous interface or an internal switch interface\n          which may not receive frames which were switched in hardware\n          or dropped by the bridge forwarding function.\n\n      - countAnyRmonTables(2)\n          The agent sets this bit if this dataSource can actually be\n          used in any of the implemented RMON tables, resources\n          notwithstanding. The agent clears this bit if this\n          dataSourceCapsEntry is present simply to identify a\n          dataSource that may only be used as portCopySource and/or a\n          portCopyDest, but not the source of an actual RMON data\n          collection.\n\n      - babyGiantsCountAsGood(3)\n          The agent sets this bit if it can distinguish, for counting\n          purposes, between true giant frames and frames that exceed\n          Ethernet maximum frame size 1518 due to VLAN tagging ('baby\n          giants'). Specifically, this BIT means that frames up to\n          1522 octets are counted as good.\n\n          Agents not capable of detecting 'baby giants' will clear\n          this bit and will view all frames less than or equal to 1518\n          octets as 'good frames' and all frames larger than 1518\n          octets as 'bad frames' for the purpose of counting in the\n          smonVlanIdStats and smonPrioStats tables.\n\n          Agents capable of detecting 'baby giants' SHALL consider\n          them as 'good frames' for the purpose of counting in the\n          smonVlanIdStats and smonPrioStats tables.")
dataSourceCopyCaps = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1, 1, 3), Bits().clone(namedValues=NamedValues(("copySourcePort", 0), ("copyDestPort", 1), ("copySrcTxTraffic", 2), ("copySrcRxTraffic", 3), ("countDestDropEvents", 4), ("copyErrFrames", 5), ("copyUnalteredFrames", 6), ("copyAllGoodFrames", 7),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dataSourceCopyCaps.setDescription('PortCopy function capabilities of the specified dataSource.\n    Note that these are static capabilities, which SHOULD NOT be\n    adjusted because of current resources or configuration.\n\n      - copySourcePort(0)\n          The agent sets this bit if this dataSource is capable of\n          acting as a source of a portCopy operation. The agent clears\n          this bit otherwise.\n\n      - copyDestPort(1)\n          The agent sets this bit if this dataSource is capable of\n          acting as a destination of a portCopy operation. The agent\n          clears this bit otherwise.\n\n     - copySrcTxTraffic(2)\n          If the copySourcePort bit is set:\n                The agent sets this bit if this dataSource is capable of\n              copying frames transmitted out this portCopy source. The\n              agent clears this bit otherwise. This function is needed\n              to support full-duplex ports.\n           Else:\n               this bit SHOULD be cleared.\n\n      - copySrcRxTraffic(3)\n          If the copySourcePort bit is set:\n            The agent sets this bit if this dataSource is capable of\n            copying frames received on this portCopy source. The agent\n            clears this bit otherwise. This function is needed to\n            support full-duplex ports.\n          Else:\n            this bit SHOULD be cleared.\n\n      - countDestDropEvents(4)\n          If the copyDestPort bit is set:\n              The agent sets this bit if it is capable of incrementing\n              portCopyDestDropEvents, when this dataSource is the\n              target of a portCopy operation and a frame destined to\n              this dataSource is dropped (for RMON counting purposes).\n          Else:\n              this BIT SHOULD be cleared.\n\n      - copyErrFrames(5)\n          If the copySourcePort bit is set:\n              The agent sets this bit if it is capable of copying all\n              errored frames from this portCopy source-port, for\n              errored frames received on this dataSource.\n          Else:\n              this BIT SHOULD be cleared.\n\n      - copyUnalteredFrames(6)\n          If the copySourcePort bit is set:\n              The agent sets the copyUnalteredFrames bit If it is\n              capable of copying all frames from this portCopy\n              source-port without alteration in any way;\n          Else:\n              this bit SHOULD be cleared.\n\n      - copyAllGoodFrames(7)\n          If the copySourcePort bit is set:\n              The agent sets this bit for the dataSource if all good\n              frames received on this dataSource are normally capable\n              of being copied by the agent. The agent clears this bit\n              if any good frames are not visible for the RMON portCopy\n              operation, e.g., the dataSource is a non-promiscuous\n              interface or an internal switch interface which may not\n              receive frames which were switched in hardware or\n              dropped by the bridge forwarding function.\n           Else:\n              this bit SHOULD be cleared.')
dataSourceCapsIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1, 1, 4), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dataSourceCapsIfIndex.setDescription("This object contains the ifIndex value of the ifEntry\n         associated with this smonDataSource. The agent MUST create\n         'propVirtual' ifEntries for each dataSourceCapsEntry of type\n         VLAN or entPhysicalEntry.")
smonVlanStatsControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1), )
if mibBuilder.loadTexts: smonVlanStatsControlTable.setDescription('Controls the setup of VLAN statistics tables.\n\n         The statistics collected represent a distribution based on\n         the IEEE 802.1Q VLAN-ID (VID), for each good frame attributed\n         to the data source for the collection.')
smonVlanStatsControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1), ).setIndexNames((0, "SMON-MIB", "smonVlanStatsControlIndex"))
if mibBuilder.loadTexts: smonVlanStatsControlEntry.setDescription('A conceptual row in the smonVlanStatsControlTable.')
smonVlanStatsControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)))
if mibBuilder.loadTexts: smonVlanStatsControlIndex.setDescription('A unique arbitrary index for this smonVlanStatsControlEntry.')
smonVlanStatsControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1, 2), DataSource()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonVlanStatsControlDataSource.setDescription('The source of data for this set of VLAN statistics.\n\n        This object MAY NOT be modified if the associated\n        smonVlanStatsControlStatus object is equal to active(1).')
smonVlanStatsControlCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1, 3), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanStatsControlCreateTime.setDescription('The value of sysUpTime when this control entry was last\n        activated. This object allows to a management station to\n        detect deletion and recreation cycles between polls.')
smonVlanStatsControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1, 4), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonVlanStatsControlOwner.setDescription('Administratively assigned named of the owner of this entry.\n        It usually defines the entity that created this entry and is\n        therefore using the resources assigned to it, though there is\n        no enforcement mechanism, nor assurance that rows created are\n        ever used.')
smonVlanStatsControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonVlanStatsControlStatus.setDescription('The status of this row.\n\n        An entry MAY NOT exist in the active state unless all\n        objects in the entry have an appropriate value.\n\n        If this object is not equal to active(1), all associated\n        entries in the smonVlanIdStatsTable SHALL be deleted.')
smonVlanIdStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2), )
if mibBuilder.loadTexts: smonVlanIdStatsTable.setDescription('Contains the VLAN statistics data.\n         The statistics collected represent a distribution based\n         on the IEEE 802.1Q VLAN-ID (VID), for each good frame\n         attributed to the data source for the collection.\n\n         This function applies the same rules for attributing frames\n         to VLAN-based collections. RMON VLAN statistics are collected\n         after the Ingress Rules defined in section 3.13 of the VLAN\n         Specification [20] are applied.\n\n         It is possible that entries in this table will be\n         garbage-collected, based on agent resources, and VLAN\n         configuration. Agents are encouraged to support all 4094\n         index values and not garbage collect this table.')
smonVlanIdStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1), ).setIndexNames((0, "SMON-MIB", "smonVlanStatsControlIndex"), (0, "SMON-MIB", "smonVlanIdStatsId"))
if mibBuilder.loadTexts: smonVlanIdStatsEntry.setDescription('A conceptual row in smonVlanIdStatsTable.')
smonVlanIdStatsId = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,4094)))
if mibBuilder.loadTexts: smonVlanIdStatsId.setDescription('The unique identifier of the VLAN monitored for\n         this specific statistics collection.\n\n        Tagged packets match the VID for the range between 1 and 4094.\n        An external RMON probe MAY detect VID=0 on an Inter Switch\n        Link, in which case the packet belongs to a VLAN determined by\n        the PVID of the ingress port. The VLAN to which such a packet\n        belongs can be determined only by a RMON probe internal to the\n        switch.')
smonVlanIdStatsTotalPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 2), Counter32()).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalPkts.setDescription('The total number of packets counted on this VLAN.')
smonVlanIdStatsTotalOverflowPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 3), Counter32()).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalOverflowPkts.setDescription('The number of times the associated smonVlanIdStatsTotalPkts\n         counter has overflowed.')
smonVlanIdStatsTotalHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 4), Counter64()).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalHCPkts.setDescription('The total number of packets counted on this VLAN.')
smonVlanIdStatsTotalOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 5), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalOctets.setDescription('The total number of octets counted on this VLAN.')
smonVlanIdStatsTotalOverflowOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 6), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalOverflowOctets.setDescription('The number of times the associated smonVlanIdStatsTotalOctets\n         counter has overflowed.')
smonVlanIdStatsTotalHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 7), Counter64()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalHCOctets.setDescription('The total number of octets counted on this VLAN.')
smonVlanIdStatsNUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 8), Counter32()).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastPkts.setDescription('The total number of non-unicast packets counted on this\n         VLAN.')
smonVlanIdStatsNUcastOverflowPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 9), Counter32()).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastOverflowPkts.setDescription('The number of times the associated smonVlanIdStatsNUcastPkts\n         counter has overflowed.')
smonVlanIdStatsNUcastHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 10), Counter64()).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastHCPkts.setDescription('The total number of non-unicast packets counted on\n         this VLAN.')
smonVlanIdStatsNUcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 11), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastOctets.setDescription('The total number of non-unicast octets counted on\n         this VLAN.')
smonVlanIdStatsNUcastOverflowOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 12), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastOverflowOctets.setDescription('The number of times the associated\n         smonVlanIdStatsNUcastOctets counter has overflowed.')
smonVlanIdStatsNUcastHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 13), Counter64()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastHCOctets.setDescription('The total number of Non-unicast octets counted on\n         this VLAN.')
smonVlanIdStatsCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 14), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsCreateTime.setDescription('The value of sysUpTime when this entry was last\n        activated. This object allows to a management station to\n        detect deletion and recreation cycles between polls.')
smonPrioStatsControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3), )
if mibBuilder.loadTexts: smonPrioStatsControlTable.setDescription('Controls the setup of priority statistics tables.\n\n         The smonPrioStatsControlTable allows configuration of\n         collections based on the value of the 3-bit user priority\n         field encoded in the Tag Control Information (TCI) field\n         according to [19],[20].\n\n         Note that this table merely reports priority as encoded in\n         the VLAN headers, not the priority (if any) given to the\n         frame for the actual switching purposes.')
smonPrioStatsControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1), ).setIndexNames((0, "SMON-MIB", "smonPrioStatsControlIndex"))
if mibBuilder.loadTexts: smonPrioStatsControlEntry.setDescription('A conceptual row in the smonPrioStatsControlTable.')
smonPrioStatsControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)))
if mibBuilder.loadTexts: smonPrioStatsControlIndex.setDescription('A unique arbitrary index for this smonPrioStatsControlEntry.')
smonPrioStatsControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1, 2), DataSource()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonPrioStatsControlDataSource.setDescription('The source of data for this set of VLAN statistics.\n\n        This object MAY NOT be modified if the associated\n        smonPrioStatsControlStatus object is equal to active(1).')
smonPrioStatsControlCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1, 3), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsControlCreateTime.setDescription('The value of sysUpTime when this entry was created.\n        This object allows to a management station to\n        detect deletion and recreation cycles between polls.')
smonPrioStatsControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1, 4), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonPrioStatsControlOwner.setDescription('Administratively assigned named of the owner of this entry.\n        It usually defines the entity that created this entry and is\n        therefore using the resources assigned to it, though there is\n        no enforcement mechanism, nor assurance that rows created are\n        ever used.')
smonPrioStatsControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonPrioStatsControlStatus.setDescription('The status of this row.\n        An entry MAY NOT exist in the active state unless all\n        objects in the entry have an appropriate value.\n\n        If this object is not equal to active(1), all associated\n        entries in the smonPrioStatsTable SHALL be deleted.')
smonPrioStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4), )
if mibBuilder.loadTexts: smonPrioStatsTable.setDescription('Contains the priority statistics. The collections are based\n         on the value of the 3-bit user priority field encoded in the\n         Tag Control Information (TCI) field according to [19], [20].\n         Note that this table merely reports priority as encoded in\n         the VLAN headers, not the priority (if any) given to the\n         frame for the actual switching purposes.\n\n         No garbage collection is designed for this table, as there\n         always are at most eight rows per statistical set, and the\n         low memory requirements do not justify the implementation of\n         such a mechanism.')
smonPrioStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1), ).setIndexNames((0, "SMON-MIB", "smonPrioStatsControlIndex"), (0, "SMON-MIB", "smonPrioStatsId"))
if mibBuilder.loadTexts: smonPrioStatsEntry.setDescription('A conceptual row in smonPrioStatsTable.')
smonPrioStatsId = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,7)))
if mibBuilder.loadTexts: smonPrioStatsId.setDescription('The unique identifier of the priority level monitored for\n         this specific statistics collection.')
smonPrioStatsPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 2), Counter32()).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsPkts.setDescription('The total number of packets counted on\n         this priority level.')
smonPrioStatsOverflowPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 3), Counter32()).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsOverflowPkts.setDescription('The number of times the associated smonPrioStatsPkts\n         counter has overflowed.')
smonPrioStatsHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 4), Counter64()).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsHCPkts.setDescription('The total number of packets counted on\n         this priority level.')
smonPrioStatsOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 5), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsOctets.setDescription('The total number of octets counted on\n         this priority level.')
smonPrioStatsOverflowOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 6), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsOverflowOctets.setDescription('The number of times the associated smonPrioStatsOctets\n         counter has overflowed.')
smonPrioStatsHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 7), Counter64()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsHCOctets.setDescription('The total number of octets counted on\n         this priority level.')
portCopyTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1), )
if mibBuilder.loadTexts: portCopyTable.setDescription(" Port Copy provides the ability to copy all frames from a\n         specified source to specified destination within a switch.\n         Source and destinations MUST be ifEntries, as defined by [22].\n         One to one, one to many, many to one and many to many source to\n         destination relationships may be configured.\n\n         Applicable counters on the destination will increment for all\n         packets transiting the port, be it by normal bridging/switching\n         or due to packet copy.\n         Note that this table manages no RMON data collection by itself,\n         and an agent may possibly implement no RMON objects except\n         objects related to the port copy operation defined by the\n         portCopyCompliance conformance macro. That allows for a switch\n         with no other embedded RMON capability to perform port copy\n         operations to a destination port at which a different external\n         RMON probe is connected.\n\n         One to one, many to one and one to many source to destination\n         relationships may be configured.\n\n         Each row that exists in this table defines such a\n         relationship. By disabling a row in this table the port copy\n         relationship no longer exists.\n\n         The number of entries and the types of port copies (1-1,\n         many-1, 1-many) are implementation specific and could\n         possibly be dynamic due to changing resource availability.\n\n         In order to configure a source to destination portCopy\n         relationship, both source and destination interfaces MUST be\n         present as an ifEntry in the ifTable and their respective\n         ifAdminStatus and ifOperStatus values MUST be equal to\n         'up(1)'. If the value of any of those two objects changes\n         after the portCopyEntry is activated, portCopyStatus will\n         transition to 'notReady(3)'.\n\n         The capability of an interface to be source or destination of\n         a port copy operation is described by the 'copySourcePort(0)'\n         and 'copyDestPort(1)' bits in dataSourceCopyCaps. Those bits\n         SHOULD be appropriately set by the agent, in order to allow\n         for a portCopyEntry to be created.\n\n         Applicable counters on the destination will increment for all\n         packets transmitted, be it by normal bridging/switching or\n         due to packet copy.")
portCopyEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1), ).setIndexNames((0, "SMON-MIB", "portCopySource"), (0, "SMON-MIB", "portCopyDest"))
if mibBuilder.loadTexts: portCopyEntry.setDescription('Describes a particular port copy entry.')
portCopySource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: portCopySource.setDescription('The ifIndex of the source which will have all packets\n         redirected to the destination as defined by portCopyDest.')
portCopyDest = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1, 2), InterfaceIndex())
if mibBuilder.loadTexts: portCopyDest.setDescription('Defines the ifIndex destination for the copy operation.')
portCopyDestDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1, 3), Counter32()).setUnits('events').setMaxAccess("readonly")
if mibBuilder.loadTexts: portCopyDestDropEvents.setDescription('The total number of events in which port copy packets were\n         dropped by the switch at the destination port due to lack of\n         resources.\n\n         Note that this number is not necessarily the number of\n         packets dropped; it is just the number of times this\n         condition has been detected.\n\n         A single dropped event counter is maintained for each\n         portCopyDest. Thus all instances associated with a given\n         portCopyDest will have the same portCopyDestDropEvents\n         value.')
portCopyDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("copyRxOnly", 1), ("copyTxOnly", 2), ("copyBoth", 3),)).clone('copyBoth')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: portCopyDirection.setDescription("This object affects the way traffic is copied from a switch\n          source port, for the indicated port copy operation.\n\n\n         If this object has the value 'copyRxOnly(1)', then only\n         traffic received on the indicated source port will be copied\n         to the indicated destination port.\n\n         If this object has the value 'copyTxOnly(2)', then only\n         traffic transmitted out the indicated source port will be\n         copied to the indicated destination port.\n\n         If this object has the value 'copyBoth(3)', then all traffic\n         received or transmitted on the indicated source port will be\n         copied to the indicated destination port.\n\n         The creation and deletion of instances of this object is\n         controlled by the portCopyRowStatus object. Note that there\n         is no guarantee that changes in the value of this object\n         performed while the associated portCopyRowStatus object is\n         equal to active will not cause traffic discontinuities in the\n         packet stream.")
portCopyStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: portCopyStatus.setDescription("Defines the status of the port copy entry.\n\n         In order to configure a source to destination portCopy\n         relationship, both source and destination interfaces MUST be\n         present as an ifEntry in the ifTable and their respective\n         ifAdminStatus and ifOperStatus values MUST be equal to\n         'up(1)'. If the value of any of those two objects changes\n         after the portCopyEntry is activated, portCopyStatus will\n         transition to 'notReady(3)'.\n\n         The capability of an interface to be source or destination of\n         a port copy operation is described by the 'copySourcePort(0)'\n         and 'copyDestPort(1)' bits in dataSourceCopyCaps. Those bits\n         SHOULD be appropriately set by the agent, in order to allow\n         for a portCopyEntry to be created.")
smonVlanDataSource = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1, 4, 1))
smonMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 20, 3))
smonMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 20, 4))
smonMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 20, 3, 1)).setObjects(*(("SMON-MIB", "dataSourceCapsGroup"), ("SMON-MIB", "smonVlanStatsGroup"), ("SMON-MIB", "smonPrioStatsGroup"), ("SMON-MIB", "portCopyConfigGroup"), ("SMON-MIB", "smonInformationGroup"), ("SMON-MIB", "smonHcTo100mbGroup"), ("SMON-MIB", "smonHc100mbPlusGroup"),))
if mibBuilder.loadTexts: smonMIBCompliance.setDescription('Describes the requirements for full conformance with the SMON\n        MIB')
smonMIBVlanStatsCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 20, 3, 2)).setObjects(*(("SMON-MIB", "dataSourceCapsGroup"), ("SMON-MIB", "smonVlanStatsGroup"), ("SMON-MIB", "smonInformationGroup"), ("SMON-MIB", "hcVlanTo100mbGroup"), ("SMON-MIB", "hcVlan100mbPlusGroup"),))
if mibBuilder.loadTexts: smonMIBVlanStatsCompliance.setDescription('Describes the requirements for conformance with the SMON MIB\n         with support for VLAN Statistics. Mandatory for a SMON probe\n         in environment where IEEE 802.1Q bridging is implemented.')
smonMIBPrioStatsCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 20, 3, 3)).setObjects(*(("SMON-MIB", "dataSourceCapsGroup"), ("SMON-MIB", "smonPrioStatsGroup"), ("SMON-MIB", "smonInformationGroup"), ("SMON-MIB", "hcPrioTo100mbGroup"), ("SMON-MIB", "hcPrio100mbPlusGroup"),))
if mibBuilder.loadTexts: smonMIBPrioStatsCompliance.setDescription('Describes the requirements for conformance with the SMON MIB\n         with support for priority level Statistics. Mandatory for a\n         SMON probe in a environment where IEEE 802.1p\n         priority-switching is implemented.')
portCopyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 20, 3, 4)).setObjects(*(("SMON-MIB", "dataSourceCapsGroup"), ("SMON-MIB", "portCopyConfigGroup"), ("SMON-MIB", "smonInformationGroup"),))
if mibBuilder.loadTexts: portCopyCompliance.setDescription('Describes the requirements for conformance with the port copy\n         functionality defined by the SMON MIB')
dataSourceCapsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 1)).setObjects(*(("SMON-MIB", "dataSourceRmonCaps"), ("SMON-MIB", "dataSourceCopyCaps"), ("SMON-MIB", "dataSourceCapsIfIndex"),))
if mibBuilder.loadTexts: dataSourceCapsGroup.setDescription('Defines the objects that describe the capabilities of RMON\n         data sources.')
smonVlanStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 2)).setObjects(*(("SMON-MIB", "smonVlanStatsControlDataSource"), ("SMON-MIB", "smonVlanStatsControlCreateTime"), ("SMON-MIB", "smonVlanStatsControlOwner"), ("SMON-MIB", "smonVlanStatsControlStatus"), ("SMON-MIB", "smonVlanIdStatsTotalPkts"), ("SMON-MIB", "smonVlanIdStatsTotalOctets"), ("SMON-MIB", "smonVlanIdStatsNUcastPkts"), ("SMON-MIB", "smonVlanIdStatsCreateTime"),))
if mibBuilder.loadTexts: smonVlanStatsGroup.setDescription('Defines the switch monitoring specific statistics - per VLAN\n         Id on interfaces of 10MB or less.')
smonPrioStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 3)).setObjects(*(("SMON-MIB", "smonPrioStatsControlDataSource"), ("SMON-MIB", "smonPrioStatsControlCreateTime"), ("SMON-MIB", "smonPrioStatsControlOwner"), ("SMON-MIB", "smonPrioStatsControlStatus"), ("SMON-MIB", "smonPrioStatsPkts"), ("SMON-MIB", "smonPrioStatsOctets"),))
if mibBuilder.loadTexts: smonPrioStatsGroup.setDescription('Defines the switch monitoring specific statistics - per VLAN\n         Id on interface.')
smonHcTo100mbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 4)).setObjects(*(("SMON-MIB", "smonVlanIdStatsTotalOverflowOctets"), ("SMON-MIB", "smonVlanIdStatsTotalHCOctets"), ("SMON-MIB", "smonPrioStatsOverflowOctets"), ("SMON-MIB", "smonPrioStatsHCOctets"),))
if mibBuilder.loadTexts: smonHcTo100mbGroup.setDescription('Defines the additional high capacity statistics needed to be\n         kept on interfaces with ifSpeed greater than 10MB/sec and\n         less than or equal to 100MB/sec.')
smonHc100mbPlusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 5)).setObjects(*(("SMON-MIB", "smonVlanIdStatsTotalOverflowPkts"), ("SMON-MIB", "smonVlanIdStatsTotalHCPkts"), ("SMON-MIB", "smonVlanIdStatsTotalOverflowOctets"), ("SMON-MIB", "smonVlanIdStatsTotalHCOctets"), ("SMON-MIB", "smonVlanIdStatsNUcastOverflowPkts"), ("SMON-MIB", "smonVlanIdStatsNUcastHCPkts"), ("SMON-MIB", "smonPrioStatsOverflowPkts"), ("SMON-MIB", "smonPrioStatsHCPkts"), ("SMON-MIB", "smonPrioStatsOverflowOctets"), ("SMON-MIB", "smonPrioStatsHCOctets"),))
if mibBuilder.loadTexts: smonHc100mbPlusGroup.setDescription('Defines the additional high capacity statistics needed to be\n         kept on interfaces with ifSpeed of more than 100MB/sec. These\n         statistics MUST also be kept on smonDataSources of type VLAN\n         or entPhysicalEntry.')
hcVlanTo100mbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 6)).setObjects(*(("SMON-MIB", "smonVlanIdStatsTotalOverflowOctets"), ("SMON-MIB", "smonVlanIdStatsTotalHCOctets"),))
if mibBuilder.loadTexts: hcVlanTo100mbGroup.setDescription('Defines the additional high capacity VLAN statistics\n         needed to be kept on interfaces with ifSpeed greater than\n         10MB/sec and less than or equal to 100MB/sec.')
hcVlan100mbPlusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 7)).setObjects(*(("SMON-MIB", "smonVlanIdStatsTotalOverflowPkts"), ("SMON-MIB", "smonVlanIdStatsTotalHCPkts"), ("SMON-MIB", "smonVlanIdStatsTotalOverflowOctets"), ("SMON-MIB", "smonVlanIdStatsTotalHCOctets"), ("SMON-MIB", "smonVlanIdStatsNUcastOverflowPkts"), ("SMON-MIB", "smonVlanIdStatsNUcastHCPkts"),))
if mibBuilder.loadTexts: hcVlan100mbPlusGroup.setDescription('Defines the additional high capacity VLAN statistics\n         needed to be kept on interfaces with ifSpeed of more than\n         100MB/sec.  These statistics MUST also be kept on\n         smonDataSources of type VLAN or entPhysicalEntry.')
hcPrioTo100mbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 8)).setObjects(*(("SMON-MIB", "smonPrioStatsOverflowOctets"), ("SMON-MIB", "smonPrioStatsHCOctets"),))
if mibBuilder.loadTexts: hcPrioTo100mbGroup.setDescription('Defines the additional high capacity VLAN priority\n         statistics needed to be kept on interfaces with\n         ifSpeed of greater than 10MB/sec and less than or equal\n         to 100MB/sec.')
hcPrio100mbPlusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 9)).setObjects(*(("SMON-MIB", "smonPrioStatsOverflowPkts"), ("SMON-MIB", "smonPrioStatsHCPkts"), ("SMON-MIB", "smonPrioStatsOverflowOctets"), ("SMON-MIB", "smonPrioStatsHCOctets"),))
if mibBuilder.loadTexts: hcPrio100mbPlusGroup.setDescription('Defines the additional high capacity VLAN priority\n         statistics needed to be kept on interfaces with\n         ifSpeed of greater than 100MB/sec. These statistics MUST\n         also be kept on smonDataSources of type VLAN or\n         entPhysicalEntry.')
smonVlanStatsExtGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 10)).setObjects(*(("SMON-MIB", "smonVlanIdStatsNUcastOctets"), ("SMON-MIB", "smonVlanIdStatsNUcastOverflowOctets"), ("SMON-MIB", "smonVlanIdStatsNUcastHCOctets"),))
if mibBuilder.loadTexts: smonVlanStatsExtGroup.setDescription('Defines the switch monitoring specific statistics for systems\n         capable of counting non-unicast octets for a given dataSource\n         (as described in the dataSourceRmonCaps object).')
smonInformationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 11)).setObjects(*(("SMON-MIB", "smonCapabilities"),))
if mibBuilder.loadTexts: smonInformationGroup.setDescription('An indication of the SMON capabilities supported by this\n        agent.')
portCopyConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 12)).setObjects(*(("SMON-MIB", "portCopyDestDropEvents"), ("SMON-MIB", "portCopyDirection"), ("SMON-MIB", "portCopyStatus"),))
if mibBuilder.loadTexts: portCopyConfigGroup.setDescription('Defines the control objects for copy port operations.')
mibBuilder.exportSymbols("SMON-MIB", smonVlanIdStatsNUcastOverflowOctets=smonVlanIdStatsNUcastOverflowOctets, smonVlanIdStatsTotalHCPkts=smonVlanIdStatsTotalHCPkts, portCopyDestDropEvents=portCopyDestDropEvents, dataSourceCapsGroup=dataSourceCapsGroup, smonMIBCompliance=smonMIBCompliance, smonPrioStatsControlDataSource=smonPrioStatsControlDataSource, hcVlan100mbPlusGroup=hcVlan100mbPlusGroup, smonVlanIdStatsTotalOverflowOctets=smonVlanIdStatsTotalOverflowOctets, dataSourceCaps=dataSourceCaps, smonMIBVlanStatsCompliance=smonMIBVlanStatsCompliance, smonVlanStatsControlDataSource=smonVlanStatsControlDataSource, smonPrioStatsControlIndex=smonPrioStatsControlIndex, smonVlanStatsControlIndex=smonVlanStatsControlIndex, smonInformationGroup=smonInformationGroup, PYSNMP_MODULE_ID=switchRMON, portCopyEntry=portCopyEntry, smonMIBCompliances=smonMIBCompliances, portCopyDest=portCopyDest, smonMIBObjects=smonMIBObjects, smonVlanStatsControlOwner=smonVlanStatsControlOwner, smonVlanStatsControlStatus=smonVlanStatsControlStatus, smonPrioStatsOverflowPkts=smonPrioStatsOverflowPkts, smonPrioStatsControlTable=smonPrioStatsControlTable, portCopyDirection=portCopyDirection, smonHcTo100mbGroup=smonHcTo100mbGroup, smonPrioStatsControlEntry=smonPrioStatsControlEntry, smonMIBPrioStatsCompliance=smonMIBPrioStatsCompliance, smonVlanIdStatsTotalPkts=smonVlanIdStatsTotalPkts, smonVlanIdStatsId=smonVlanIdStatsId, smonPrioStatsTable=smonPrioStatsTable, portCopyStatus=portCopyStatus, hcPrioTo100mbGroup=hcPrioTo100mbGroup, portCopyConfig=portCopyConfig, dataSourceCopyCaps=dataSourceCopyCaps, smonPrioStatsId=smonPrioStatsId, smonVlanIdStatsTotalHCOctets=smonVlanIdStatsTotalHCOctets, portCopySource=portCopySource, portCopyTable=portCopyTable, dataSourceCapsIfIndex=dataSourceCapsIfIndex, smonVlanStatsControlEntry=smonVlanStatsControlEntry, dataSourceCapsObject=dataSourceCapsObject, smonVlanStatsExtGroup=smonVlanStatsExtGroup, portCopyConfigGroup=portCopyConfigGroup, smonVlanStatsControlCreateTime=smonVlanStatsControlCreateTime, smonVlanIdStatsNUcastOverflowPkts=smonVlanIdStatsNUcastOverflowPkts, smonVlanIdStatsTable=smonVlanIdStatsTable, hcPrio100mbPlusGroup=hcPrio100mbPlusGroup, dataSourceRmonCaps=dataSourceRmonCaps, smonRegistrationPoints=smonRegistrationPoints, smonCapabilities=smonCapabilities, smonMIBGroups=smonMIBGroups, smonVlanIdStatsTotalOverflowPkts=smonVlanIdStatsTotalOverflowPkts, smonHc100mbPlusGroup=smonHc100mbPlusGroup, dataSourceCapsEntry=dataSourceCapsEntry, smonPrioStatsPkts=smonPrioStatsPkts, smonPrioStatsHCPkts=smonPrioStatsHCPkts, smonStats=smonStats, smonVlanDataSource=smonVlanDataSource, smonPrioStatsOctets=smonPrioStatsOctets, smonVlanStatsControlTable=smonVlanStatsControlTable, smonVlanIdStatsTotalOctets=smonVlanIdStatsTotalOctets, SmonDataSource=SmonDataSource, smonPrioStatsEntry=smonPrioStatsEntry, smonVlanIdStatsNUcastOctets=smonVlanIdStatsNUcastOctets, smonVlanIdStatsNUcastHCOctets=smonVlanIdStatsNUcastHCOctets, smonVlanIdStatsCreateTime=smonVlanIdStatsCreateTime, hcVlanTo100mbGroup=hcVlanTo100mbGroup, smonPrioStatsOverflowOctets=smonPrioStatsOverflowOctets, smonPrioStatsHCOctets=smonPrioStatsHCOctets, smonPrioStatsControlOwner=smonPrioStatsControlOwner, dataSourceCapsTable=dataSourceCapsTable, smonPrioStatsControlStatus=smonPrioStatsControlStatus, switchRMON=switchRMON, smonVlanStatsGroup=smonVlanStatsGroup, smonVlanIdStatsNUcastPkts=smonVlanIdStatsNUcastPkts, smonPrioStatsControlCreateTime=smonPrioStatsControlCreateTime, smonPrioStatsGroup=smonPrioStatsGroup, smonVlanIdStatsEntry=smonVlanIdStatsEntry, smonVlanIdStatsNUcastHCPkts=smonVlanIdStatsNUcastHCPkts, portCopyCompliance=portCopyCompliance)
