from typing import Optional, Union, Tuple, Iterable, List

have_idna_2008: bool

class Name:
    def is_subdomain(self, o : Name) -> bool: ...
    def is_superdomain(self, o : Name) -> bool: ...
    def __init__(self, labels : Iterable[Union[bytes,str]]) -> None:
        self.labels : List[bytes]
    def is_absolute(self) -> bool: ...
    def is_wild(self) -> bool: ...
    def fullcompare(self, other) -> Tuple[int,int,int]: ...
    def canonicalize(self) -> Name: ...
    def __lt__(self, other : Name): ...
    def __le__(self, other : Name): ...
    def __ge__(self, other : Name): ...
    def __gt__(self, other : Name): ...
    def to_text(self, omit_final_dot=False) -> str: ...
    def to_unicode(self, omit_final_dot=False, idna_codec=None) -> str: ...
    def to_digestable(self, origin=None) -> bytes: ...
    def to_wire(self, file=None, compress=None, origin=None,
                canonicalize=False) -> Optional[bytes]: ...
    def __add__(self, other : Name): ...
    def __sub__(self, other : Name): ...
    def split(self, depth) -> List[Tuple[str,str]]: ...
    def concatenate(self, other : Name) -> Name: ...
    def relativize(self, origin): ...
    def derelativize(self, origin): ...
    def choose_relativity(self, origin : Optional[Name] = None, relativize=True): ...
    def parent(self) -> Name: ...

class IDNACodec:
    pass

def from_text(text, origin : Optional[Name] = Name('.'), idna_codec : Optional[IDNACodec] = None) -> Name:
    ...

empty : Name
