;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
  ;; CHECK-TEXT:      (type $0 (func (result i32)))
  ;; CHECK-BIN:      (type $0 (func (result i32)))
  ;; CHECK-BIN-NODEBUG:      (type $0 (func (result i32)))
  (type $0 (func (result i32)))
  ;; CHECK-TEXT:      (memory $0 4096 4096)
  ;; CHECK-BIN:      (memory $0 4096 4096)
  ;; CHECK-BIN-NODEBUG:      (memory $0 4096 4096)
  (memory $0 4096 4096)
  (data (i32.const 1026) "\14\00")

  ;; CHECK-TEXT:      (data $0 (i32.const 1026) "\14\00")

  ;; CHECK-TEXT:      (func $kitchensink (type $0) (result i32)
  ;; CHECK-TEXT-NEXT:  (block $block0 (result i32)
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.add
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.sub
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.mul
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.div_s
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.div_u
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.rem_s
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.rem_u
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.and
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.or
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.xor
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.shl
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.shr_u
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.shr_s
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.eq
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.ne
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.lt_s
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.le_s
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.lt_u
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.le_u
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.gt_s
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.ge_s
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.gt_u
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.ge_u
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.clz
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.ctz
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.popcnt
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.add
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.sub
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.mul
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.div_s
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.div_u
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.rem_s
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.rem_u
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.and
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.or
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.xor
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.shl
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.shr_u
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.shr_s
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.eq
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.ne
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.lt_s
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.le_s
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.lt_u
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.le_u
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.gt_s
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.ge_s
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.gt_u
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.ge_u
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.clz
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.ctz
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.popcnt
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.add
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.sub
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.mul
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.div
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.min
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.max
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.abs
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.neg
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.copysign
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.ceil
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.floor
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.trunc
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.nearest
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.sqrt
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.eq
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.ne
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.lt
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.le
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.gt
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.ge
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.add
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.sub
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.mul
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.div
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.min
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.max
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.abs
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.neg
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.copysign
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.ceil
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.floor
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.trunc
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.nearest
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.sqrt
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.eq
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.ne
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.lt
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.le
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.gt
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.ge
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.trunc_f32_s
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.trunc_f64_s
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.trunc_f32_u
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.trunc_f64_u
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.trunc_sat_f32_s
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.trunc_sat_f32_u
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.trunc_sat_f64_s
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.trunc_sat_f64_u
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.wrap_i64
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.trunc_f32_s
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.trunc_f64_s
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.trunc_f32_u
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.trunc_f64_u
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.trunc_sat_f32_s
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.trunc_sat_f32_u
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.trunc_sat_f64_s
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.trunc_sat_f64_u
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.extend_i32_s
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.extend_i32_u
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.convert_i32_s
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.convert_i32_u
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.convert_i64_s
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.convert_i64_u
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.demote_f64
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.reinterpret_i32
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.convert_i32_s
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.convert_i32_u
  ;; CHECK-TEXT-NEXT:     (i32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.convert_i64_s
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.convert_i64_u
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.promote_f32
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f64.reinterpret_i64
  ;; CHECK-TEXT-NEXT:     (i64.const 100)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.reinterpret_f32
  ;; CHECK-TEXT-NEXT:     (f32.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i64.reinterpret_f64
  ;; CHECK-TEXT-NEXT:     (f64.const 10)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (i32.const 0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (data $0 (i32.const 1026) "\14\00")

  ;; CHECK-BIN:      (func $kitchensink (type $0) (result i32)
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.add
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.sub
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.mul
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.div_s
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.div_u
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.rem_s
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.rem_u
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.and
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.or
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.xor
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.shl
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.shr_u
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.shr_s
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.eq
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.ne
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.lt_s
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.le_s
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.lt_u
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.le_u
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.gt_s
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.ge_s
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.gt_u
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.ge_u
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.clz
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.ctz
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.popcnt
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.add
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.sub
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.mul
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.div_s
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.div_u
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.rem_s
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.rem_u
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.and
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.or
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.xor
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.shl
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.shr_u
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.shr_s
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.eq
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.ne
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.lt_s
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.le_s
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.lt_u
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.le_u
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.gt_s
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.ge_s
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.gt_u
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.ge_u
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.clz
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.ctz
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.popcnt
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.add
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.sub
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.mul
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.div
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.min
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.max
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.abs
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.neg
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.copysign
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.ceil
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.floor
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.trunc
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.nearest
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.sqrt
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.eq
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.ne
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.lt
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.le
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.gt
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.ge
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.add
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.sub
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.mul
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.div
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.min
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.max
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.abs
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.neg
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.copysign
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.ceil
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.floor
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.trunc
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.nearest
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.sqrt
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.eq
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.ne
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.lt
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.le
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.gt
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.ge
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.trunc_f32_s
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.trunc_f64_s
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.trunc_f32_u
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.trunc_f64_u
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.trunc_sat_f32_s
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.trunc_sat_f32_u
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.trunc_sat_f64_s
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.trunc_sat_f64_u
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.wrap_i64
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.trunc_f32_s
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.trunc_f64_s
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.trunc_f32_u
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.trunc_f64_u
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.trunc_sat_f32_s
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.trunc_sat_f32_u
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.trunc_sat_f64_s
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.trunc_sat_f64_u
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.extend_i32_s
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.extend_i32_u
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.convert_i32_s
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.convert_i32_u
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.convert_i64_s
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.convert_i64_u
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.demote_f64
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.reinterpret_i32
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.convert_i32_s
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.convert_i32_u
  ;; CHECK-BIN-NEXT:    (i32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.convert_i64_s
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.convert_i64_u
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.promote_f32
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f64.reinterpret_i64
  ;; CHECK-BIN-NEXT:    (i64.const 100)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.reinterpret_f32
  ;; CHECK-BIN-NEXT:    (f32.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i64.reinterpret_f64
  ;; CHECK-BIN-NEXT:    (f64.const 10)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (i32.const 0)
  ;; CHECK-BIN-NEXT: )
  (func $kitchensink (type $0) (result i32)
    (block $block0 (result i32)
      (drop
        (i32.add
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.sub
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.mul
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.div_s
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.div_u
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.rem_s
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.rem_u
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.and
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.or
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.xor
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.shl
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.shr_u
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.shr_s
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.eq
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.ne
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.lt_s
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.le_s
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.lt_u
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.le_u
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.gt_s
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.ge_s
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.gt_u
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.ge_u
          (i32.const 10)
          (i32.const 10)
        )
      )
      (drop
        (i32.clz
          (i32.const 10)
        )
      )
      (drop
        (i32.ctz
          (i32.const 10)
        )
      )
      (drop
        (i32.popcnt
          (i32.const 10)
        )
      )
      (drop
        (i64.add
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.sub
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.mul
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.div_s
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.div_u
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.rem_s
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.rem_u
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.and
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.or
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.xor
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.shl
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.shr_u
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.shr_s
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.eq
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.ne
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.lt_s
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.le_s
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.lt_u
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.le_u
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.gt_s
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.ge_s
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.gt_u
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.ge_u
          (i64.const 100)
          (i64.const 100)
        )
      )
      (drop
        (i64.clz
          (i64.const 100)
        )
      )
      (drop
        (i64.ctz
          (i64.const 100)
        )
      )
      (drop
        (i64.popcnt
          (i64.const 100)
        )
      )
      (drop
        (f32.add
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.sub
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.mul
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.div
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.min
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.max
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.abs
          (f32.const 10)
        )
      )
      (drop
        (f32.neg
          (f32.const 10)
        )
      )
      (drop
        (f32.copysign
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.ceil
          (f32.const 10)
        )
      )
      (drop
        (f32.floor
          (f32.const 10)
        )
      )
      (drop
        (f32.trunc
          (f32.const 10)
        )
      )
      (drop
        (f32.nearest
          (f32.const 10)
        )
      )
      (drop
        (f32.sqrt
          (f32.const 10)
        )
      )
      (drop
        (f32.eq
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.ne
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.lt
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.le
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.gt
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f32.ge
          (f32.const 10)
          (f32.const 10)
        )
      )
      (drop
        (f64.add
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.sub
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.mul
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.div
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.min
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.max
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.abs
          (f64.const 10)
        )
      )
      (drop
        (f64.neg
          (f64.const 10)
        )
      )
      (drop
        (f64.copysign
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.ceil
          (f64.const 10)
        )
      )
      (drop
        (f64.floor
          (f64.const 10)
        )
      )
      (drop
        (f64.trunc
          (f64.const 10)
        )
      )
      (drop
        (f64.nearest
          (f64.const 10)
        )
      )
      (drop
        (f64.sqrt
          (f64.const 10)
        )
      )
      (drop
        (f64.eq
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.ne
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.lt
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.le
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.gt
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (f64.ge
          (f64.const 10)
          (f64.const 10)
        )
      )
      (drop
        (i32.trunc_f32_s
          (f32.const 10)
        )
      )
      (drop
        (i32.trunc_f64_s
          (f64.const 10)
        )
      )
      (drop
        (i32.trunc_f32_u
          (f32.const 10)
        )
      )
      (drop
        (i32.trunc_f64_u
          (f64.const 10)
        )
      )
      (drop
        (i32.trunc_sat_f32_s
          (f32.const 10)
        )
      )
      (drop
        (i32.trunc_sat_f32_u
          (f32.const 10)
        )
      )
      (drop
        (i32.trunc_sat_f64_s
          (f64.const 10)
        )
      )
      (drop
        (i32.trunc_sat_f64_u
          (f64.const 10)
        )
      )
      (drop
        (i32.wrap_i64
          (i64.const 100)
        )
      )
      (drop
        (i64.trunc_f32_s
          (f32.const 10)
        )
      )
      (drop
        (i64.trunc_f64_s
          (f64.const 10)
        )
      )
      (drop
        (i64.trunc_f32_u
          (f32.const 10)
        )
      )
      (drop
        (i64.trunc_f64_u
          (f64.const 10)
        )
      )
      (drop
        (i64.trunc_sat_f32_s
          (f32.const 10)
        )
      )
      (drop
        (i64.trunc_sat_f32_u
          (f32.const 10)
        )
      )
      (drop
        (i64.trunc_sat_f64_s
          (f64.const 10)
        )
      )
      (drop
        (i64.trunc_sat_f64_u
          (f64.const 10)
        )
      )
      (drop
        (i64.extend_i32_s
          (i32.const 10)
        )
      )
      (drop
        (i64.extend_i32_u
          (i32.const 10)
        )
      )
      (drop
        (f32.convert_i32_s
          (i32.const 10)
        )
      )
      (drop
        (f32.convert_i32_u
          (i32.const 10)
        )
      )
      (drop
        (f32.convert_i64_s
          (i64.const 100)
        )
      )
      (drop
        (f32.convert_i64_u
          (i64.const 100)
        )
      )
      (drop
        (f32.demote_f64
          (f64.const 10)
        )
      )
      (drop
        (f32.reinterpret_i32
          (i32.const 10)
        )
      )
      (drop
        (f64.convert_i32_s
          (i32.const 10)
        )
      )
      (drop
        (f64.convert_i32_u
          (i32.const 10)
        )
      )
      (drop
        (f64.convert_i64_s
          (i64.const 100)
        )
      )
      (drop
        (f64.convert_i64_u
          (i64.const 100)
        )
      )
      (drop
        (f64.promote_f32
          (f32.const 10)
        )
      )
      (drop
        (f64.reinterpret_i64
          (i64.const 100)
        )
      )
      (drop
        (i32.reinterpret_f32
          (f32.const 10)
        )
      )
      (drop
        (i64.reinterpret_f64
          (f64.const 10)
        )
      )
      (i32.const 0)
    )
  )
)
;; CHECK-BIN-NODEBUG:      (data $0 (i32.const 1026) "\14\00")

;; CHECK-BIN-NODEBUG:      (func $0 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.add
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.sub
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.mul
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.div_s
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.div_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.rem_s
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.rem_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.and
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.or
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.xor
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.shl
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.shr_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.shr_s
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.eq
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.ne
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.lt_s
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.le_s
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.lt_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.le_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.gt_s
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.ge_s
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.gt_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.ge_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.clz
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.ctz
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.popcnt
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.add
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.sub
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.mul
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.div_s
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.div_u
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.rem_s
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.rem_u
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.and
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.or
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.xor
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.shl
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.shr_u
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.shr_s
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.eq
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.ne
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.lt_s
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.le_s
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.lt_u
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.le_u
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.gt_s
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.ge_s
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.gt_u
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.ge_u
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.clz
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.ctz
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.popcnt
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.add
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.sub
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.mul
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.div
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.min
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.max
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.abs
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.neg
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.copysign
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.ceil
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.floor
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.trunc
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.nearest
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.sqrt
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.eq
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.ne
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.lt
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.le
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.gt
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.ge
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.add
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.sub
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.mul
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.div
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.min
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.max
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.abs
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.neg
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.copysign
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.ceil
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.floor
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.trunc
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.nearest
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.sqrt
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.eq
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.ne
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.lt
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.le
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.gt
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.ge
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.trunc_f32_s
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.trunc_f64_s
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.trunc_f32_u
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.trunc_f64_u
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.trunc_sat_f32_s
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.trunc_sat_f32_u
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.trunc_sat_f64_s
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.trunc_sat_f64_u
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.wrap_i64
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.trunc_f32_s
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.trunc_f64_s
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.trunc_f32_u
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.trunc_f64_u
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.trunc_sat_f32_s
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.trunc_sat_f32_u
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.trunc_sat_f64_s
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.trunc_sat_f64_u
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.extend_i32_s
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.extend_i32_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.convert_i32_s
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.convert_i32_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.convert_i64_s
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.convert_i64_u
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.demote_f64
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.reinterpret_i32
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.convert_i32_s
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.convert_i32_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.convert_i64_s
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.convert_i64_u
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.promote_f32
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f64.reinterpret_i64
;; CHECK-BIN-NODEBUG-NEXT:    (i64.const 100)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.reinterpret_f32
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.reinterpret_f64
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 10)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT: )
