// Initializes the cookie dialog
function webdeveloper_initializeCookie()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the first argument equals add
    if(window.arguments[0] == "add")
    {
        var url           = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURL);
        var windowContent = window.opener.getBrowser();

        document.title = stringBundle.getString("webdeveloper_addCookie");
        url.spec       = windowContent.browsers[windowContent.mTabBox.selectedIndex].contentDocument.documentURI;

        document.getElementById("webdeveloper-cookie-expires").value = new Date().toUTCString();
        document.getElementById("webdeveloper-cookie-host").value    = url.host;
        document.getElementById("webdeveloper-cookie-path").value    = url.path;
    }
    else
    {
        document.title = stringBundle.getString("webdeveloper_editCookie");

        document.getElementById("webdeveloper-cookie-name").value  = window.arguments[1];
        document.getElementById("webdeveloper-cookie-value").value = window.arguments[2];
        document.getElementById("webdeveloper-cookie-host").value  = window.arguments[3];
        document.getElementById("webdeveloper-cookie-path").value  = window.arguments[4];
        
		// If the cookie is a session cookie
		if(window.arguments[5] == stringBundle.getString("webdeveloper_viewCookieInformationSession"))
		{
		    document.getElementById("webdeveloper-cookie-expires").disabled = true;			
    		document.getElementById("webdeveloper-cookie-session").checked  = true;
		}
		else
		{
	        document.getElementById("webdeveloper-cookie-expires").value = window.arguments[5];
		}

        // If the cookie is secure
        if(window.arguments[6] == "true")
        {
            document.getElementById("webdeveloper-cookie-secure").checked = true;
        }
    }
}

// Saves the cookie
function webdeveloper_saveCookie()
{
    var host         = document.getElementById("webdeveloper-cookie-host").value.trim();
    var errors       = "";
    var expires      = document.getElementById("webdeveloper-cookie-expires").value.trim();
    var expiresDate  = new Date(expires);
    var name         = document.getElementById("webdeveloper-cookie-name").value.trim();
    var path         = document.getElementById("webdeveloper-cookie-path").value.trim();
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the name is empty
    if(!name)
    {
        errors += stringBundle.getString("webdeveloper_emptyName") + "\n";
    }

    // If the host is empty
    if(!host)
    {
        errors += stringBundle.getString("webdeveloper_emptyHost") + "\n";
    }

    // If the path is empty
    if(!path)
    {
        errors += stringBundle.getString("webdeveloper_emptyPath") + "\n";
    }

    // If this is not a session cookie
    if(!document.getElementById("webdeveloper-cookie-session").checked)
    {
        // If the expires is empty
        if(!expires)
        {
            errors += stringBundle.getString("webdeveloper_emptyExpires") + "\n";
        }
        else if(expiresDate && expiresDate == "Invalid Date")
        {
            errors += stringBundle.getString("webdeveloper_invalidExpires") + "\n";
        }
    }

    // If there are errors
    if(errors)
    {
        webdeveloper_error(errors.trim());

        return false;
    }
    else
    {
        var cookie        = name + "=" + document.getElementById("webdeveloper-cookie-value").value.trim() + ";";
        var cookieService = Components.classes["@mozilla.org/cookieService;1"].getService().QueryInterface(Components.interfaces.nsICookieService);
        var scheme        = "http://";
        var secure        = document.getElementById("webdeveloper-cookie-secure").checked;
        var session       = document.getElementById("webdeveloper-cookie-session").checked;
        var uri           = null;

        // If the first argument equals edit
        if(window.arguments[0] == "edit")
        {
            Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager).remove(window.arguments[3], window.arguments[1], window.arguments[4], false);
        }

        // If the host is a domain
        if(host.charAt(0) == ".")
        {
            cookie += "domain=" + host + ";";
        }

        cookie += "path=" + path + ";";

        // If this is not a session cookie
        if(!session)
        {
            cookie += "expires=" + expiresDate + ";";
        }

        // If the cookie is secure
        if(secure)
        {
            cookie += "secure;";
            scheme  = "https://";
        }

        uri = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService).newURI(scheme + host + path, null, null);

        cookieService.setCookieString(uri, null, cookie, null);
    }

    return true;
}

// Updates the expiry status
function webdeveloper_updateExpiryStatus()
{
    var disabled = false;
    var expires  = new Date();

    // If session cookie is checked
    if(document.getElementById("webdeveloper-cookie-session").checked)
    {
        disabled = true;
        expires  = "";
    }

    document.getElementById("webdeveloper-cookie-expires").disabled = disabled;
    document.getElementById("webdeveloper-cookie-expires").value    = expires;
}