var webdeveloper_currentTableSortColumn  = 0;
var webdeveloper_previousTableSortColumn = 0;
var webdeveloper_sortAscending           = false;

// Makes all tables on the page with a sortable class sortable
function webdeveloper_makeTablesSortable()
{
    var table             = null;
    var tableHeaderLength = null;
    var tableHeaderList   = null;
    var tableList         = document.getElementsByTagName("table");
    var tableLength       = tableList.length;

    // Loop through the tables
    for(var i = 0; i < tableLength; i++)
    {
        table = tableList[i];

        // If the table has a sortable attribute
        if(table.hasAttribute("class") && table.getAttribute("class") == "sortable")
        {
            tableHeaderList   = table.getElementsByTagName("th");
            tableHeaderLength = tableHeaderList.length;

            // Loop through the table headers
            for(var j = 0; j < tableHeaderLength; j++)
            {
                tableHeaderList[j].addEventListener("click", webdeveloper_sortTable, true);
            }
        }
    }
}

// Sorts a table
function webdeveloper_sortTable(event)
{
    // If the event is set
    if(event)
    {
        var newTableRowList = new Array();
        var tableHeader     = event.target;
        var node            = tableHeader;
        var styleSheet      = tableHeader.ownerDocument.getElementById("webdeveloper-generated-content-stylesheet");
        var tableHeaderRow  = tableHeader.parentNode;
        var table           = tableHeaderRow.parentNode;
        var tableRow        = null;
        var tableRowList    = table.childNodes;
        var tableRowLength  = tableRowList.length;

        webdeveloper_currentTableSortColumn = 0;

        // Loop through the previous siblings
        while((node = node.previousSibling) != null)
        {
            webdeveloper_currentTableSortColumn++;
        }

        // If the current sort column is the same as the previous sort column
        if(webdeveloper_currentTableSortColumn == webdeveloper_previousTableSortColumn)
        {
            webdeveloper_sortAscending = !webdeveloper_sortAscending;
        }
        else
        {
            var previousTableHeader = tableHeaderRow.cells[webdeveloper_previousTableSortColumn];

            webdeveloper_previousTableSortColumn = webdeveloper_currentTableSortColumn;
            webdeveloper_sortAscending           = true;

            // If the previous table header has a class attribute
            if(previousTableHeader.hasAttribute("class"))
            {
                previousTableHeader.removeAttribute("class");
            }
        }

        // If sorting in ascending order
        if(webdeveloper_sortAscending)
        {
            tableHeader.setAttribute("class", "sort-ascending");
        }
        else
        {
            tableHeader.setAttribute("class", "sort-descending");
        }

        // Loop through the table rows excluding the header row
        for(var i = 1; i < tableRowLength; i++)
        {
            newTableRowList[i - 1] = tableRowList[i];
        }

        newTableRowList.sort(webdeveloper_sortTableRows);
        webdeveloper_removeAllChildNodes(table);
        table.appendChild(tableHeaderRow);

        // Loop through the sorted table rows
        for(i = 0; i < newTableRowList.length; i++)
        {
            tableRow = newTableRowList[i];

            // If this is an even row
            if(i % 2 == 0)
            {
                // If this row has a class attribute
                if(tableRow.hasAttribute("class"))
                {
                    tableRow.removeAttribute("class");
                }
            }
            else
            {
                tableRow.setAttribute("class", "shaded");
            }

            table.appendChild(tableRow);
        }

        // Disable and enable the style sheet to force the styles to reapply
        if(styleSheet)
        {
            styleSheet.disabled = true;
            styleSheet.disabled = false;
        }
    }
}

// Sorts two table rows
function webdeveloper_sortTableRows(rowOne, rowTwo)
{
    var sortValue = 1;

    // If row one and row two are set
    if(rowOne && rowTwo)
    {
        var columnOne = webdeveloper_getElementText(rowOne.cells[webdeveloper_currentTableSortColumn]);
        var columnTwo = webdeveloper_getElementText(rowTwo.cells[webdeveloper_currentTableSortColumn]);

        // If the columns are equal
        if(columnOne == columnTwo)
        {
            return 0;
        }
        else if(columnOne < columnTwo)
        {
            sortValue = -1;
        }
    }

    // If sorting in descending order
    if(!webdeveloper_sortAscending)
    {
        sortValue = sortValue * -1;
    }

    return sortValue;
}

webdeveloper_makeTablesSortable();