;;; tc-is20.el --- T-Code isearch modification for Emacs 20.*.

;; Copyright (C) 1994,97-2001 Kaoru Maeda, Mikihiko Nakao and KITAJIMA Akira

;; Author: Kaoru Maeda <maeda@src.ricoh.co.jp>
;;	Mikihiko Nakao
;;	KITAJIMA Akira <kitajima@isc.osakac.ac.jp>
;; Maintainer: KITAJIMA Akira
;; Create: 27 Jun (Sat), 1998

;; $Id: tc-is20.el,v 1.10 2002/03/19 07:25:10 kitajima Exp $

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.

;;; Code:

(if (< (string-to-int emacs-version) 20)
    (error "tc-is20 cannot run on NEmacs/Mule.  Use Emacs 20 or later!"))

;;;
;;;  User Variables
;;;
(defvar tcode-isearch-start-state nil
  "*󥯥󥿥륵ϻTɥ⡼ɤꤹ롣
	nil: ХåեTɥ⡼ɤƱ(ǥե)
	t:   ХåեTɥ⡼ɤΩϻϥХåեƱ
	0:   ХåեΩ˾Tɥ⡼ɥ鳫ϡ
	1:   ХåեΩ˾Tɥ⡼ɥ鳫ϡ
Хåեѿ")
(make-variable-buffer-local 'tcode-isearch-start-state)
(setq-default tcode-isearch-start-state nil)

(defcustom tcode-isearch-enable-wrapped-search t
  "*2ХʸǥȤˡԤ̵뤹롣"
  :type 'boolean :group 'tcode)

(defcustom tcode-isearch-ignore-regexp "[\n \t]*"
  "* 2Хʸ֤ɽ
`tcode-isearch-enable-wrapped-search'  t ΤȤΤͭ"
  :type 'regexp :group 'tcode)

(defcustom tcode-isearch-special-function-alist
  '((tcode-bushu-henkan . tcode-isearch-bushu-henkan-command)
    (tcode-bushu-another-henkan . tcode-isearch-bushu-henkan-command)
    (tcode-mazegaki-alternative-start . tcode-isearch-prefix-mazegaki)
    (tcode-mazegaki-start . tcode-isearch-postfix-mazegaki))
  "*isearchǤüʥޥɤϤФإޥɤ alist"
  :group 'tcode)

;;;
;;; Default key binding
;;;
(when (tcode-xemacs-p)
  (define-key isearch-mode-map "\C-\\" 'isearch-toggle-tcode)
  (put 'isearch-toggle-tcode 'isearch-command t)) ; for XEmacs

;;;
;;; patch to original functions in isearch.el of Emacs 20.2.96
;;;
(defun isearch-search ()
  ;; Do the search with the current search string.
  (isearch-message nil t)
  (if (and (eq isearch-case-fold-search t) search-upper-case)
      (setq isearch-case-fold-search
	    (if (tcode-xemacs-p)
 		(isearch-no-upper-case-p isearch-string)
 	      (isearch-no-upper-case-p isearch-string isearch-regexp))))
  (condition-case lossage
      (let ((inhibit-point-motion-hooks search-invisible)
	    (inhibit-quit nil)
	    (case-fold-search isearch-case-fold-search)
	    (retry t))
	(if isearch-regexp (setq isearch-invalid-regexp nil))
	(setq isearch-within-brackets nil)
	(while retry
	  (setq isearch-success
		(funcall
		 (cond (isearch-word
			(if isearch-forward
			    'word-search-forward 'word-search-backward))
		       ((or isearch-regexp
			    (and (boundp 'tcode-isearch-enable-wrapped-search)
				 tcode-isearch-enable-wrapped-search))
			(if isearch-forward
			    're-search-forward 're-search-backward))
		       (t
			(if isearch-forward 'search-forward 'search-backward)))
		 isearch-string nil t))
	  ;; Clear RETRY unless we matched some invisible text
	  ;; and we aren't supposed to do that.
	  (if (or (eq search-invisible t)
		  (not isearch-success)
		  (bobp) (eobp)
		  (= (match-beginning 0) (match-end 0))
		  (not (isearch-range-invisible
			(match-beginning 0) (match-end 0))))
	      (setq retry nil)))
	(setq isearch-just-started nil)
	(if isearch-success
	    (setq isearch-other-end
		  (if isearch-forward (match-beginning 0) (match-end 0)))))

    (quit (isearch-unread ?\C-g)
	  (setq isearch-success nil))

    (invalid-regexp
     (setq isearch-invalid-regexp (car (cdr lossage)))
     (setq isearch-within-brackets (string-match "\\`Unmatched \\["
						 isearch-invalid-regexp))
     (if (string-match
	  "\\`Premature \\|\\`Unmatched \\|\\`Invalid "
	  isearch-invalid-regexp)
	 (setq isearch-invalid-regexp "incomplete input")))
    (error
     ;; stack overflow in regexp search.
     (setq isearch-invalid-regexp (car (cdr lossage)))))

  (if isearch-success
      nil
    ;; Ding if failed this time after succeeding last time.
    (and (nth 3 (car isearch-cmds))
	 (ding))
    (goto-char (nth 2 (car isearch-cmds)))))

(defun isearch-printing-char ()
  "Add this ordinary printing character to the search string and search."
  (interactive)
  (let ((char (isearch-last-command-char)))
    (if (and (boundp 'tcode-mode) tcode-mode)
	;; isearch for T-Code
	(let ((action (tcode-get-action-from-table
		       (isearch-last-command-char) t))
	      (prev (tcode-isearch-bushu)))
	  (cond ((null action)
		 (ding))
		((stringp action)
		 (setq action
		       (mapconcat 'char-to-string
				  (tcode-apply-filters 
				   (tcode-string-to-char-list action))
				  ""))
		 (tcode-isearch-process-string action prev))
		((char-or-string-p action)
		 (tcode-isearch-process-string 
		  (char-to-string (car (tcode-apply-filters (list action))))
		  prev))
		((and (not (tcode-function-p action))
		      (consp action))
		 (tcode-isearch-process-string (mapconcat 'identity action "")
					       prev))
		((tcode-function-p action)
		 (let ((function
			(cdr (assq action
				   tcode-isearch-special-function-alist))))
		   (if function
		       (funcall function)
		     (ding))))
		(t
		 (ding))))
      ;; original behaviour
      (if (= char ?\S-\ )
	  (setq char ?\ ))
      (if (and enable-multibyte-characters
	       (>= char ?\200)
	       (<= char ?\377))
	  (isearch-process-search-char (+ char nonascii-insert-offset))
	(if current-input-method
	    (isearch-process-search-multibyte-characters char)
	  (isearch-process-search-char char))))))

(defadvice isearch-process-search-char (around tcode-handling activate)
  "Extention for T-code"
  (if (and (not isearch-regexp)
	   (boundp 'tcode-isearch-enable-wrapped-search)
	   tcode-isearch-enable-wrapped-search
	   (memq char '(?$ ?* ?+ ?. ?? ?[ ?\\ ?] ?^)))
      (let ((s (char-to-string char)))
	(isearch-process-search-string (concat "\\" s) s))
    ad-do-it))

(defun isearch-yank-word ()
  "Pull next word from buffer into search string."
  (interactive)
  (isearch-yank-string
   (save-excursion
     (and (not isearch-forward) isearch-other-end
	  (goto-char isearch-other-end))
     (buffer-substring (point)
		       (progn (if (= (tcode-char-width
				      (tcode-char-after (point)))
				     2)
				  (forward-char 1)
				(forward-word 1))
			      (point))))))

(defun isearch-yank-string (string)
  "Pull STRING into search string."
  ;; Downcase the string if not supposed to case-fold yanked strings.
  (if (and isearch-case-fold-search
	   (eq 'not-yanks search-upper-case))
      (setq string (downcase string)))
  (if isearch-regexp (setq string (regexp-quote string)))
  (setq isearch-string (concat isearch-string
			       (tcode-isearch-make-string-for-wrapping string))
	isearch-message
	(concat isearch-message
		(mapconcat 'isearch-text-char-description
			   string ""))
	;; Don't move cursor in reverse search.
	isearch-yank-flag t)
  (isearch-search-and-update))

(defun isearch-repeat (direction)
  ;; Utility for isearch-repeat-forward and -backward.
  (if (eq isearch-forward (eq direction 'forward))
      ;; C-s in forward or C-r in reverse.
      (if (equal isearch-string "")
	  ;; If search string is empty, use last one.
	  (setq isearch-string
		(or (if isearch-regexp
			(car regexp-search-ring)
		      (car search-ring))
		    "")
		isearch-message
		(mapconcat 'isearch-text-char-description
			   (tcode-isearch-remove-ignore-regexp isearch-string)
			   ""))
	;; If already have what to search for, repeat it.
	(or isearch-success
	    (progn
	      (goto-char (if isearch-forward (point-min) (point-max)))
	      (setq isearch-wrapped t))))
    ;; C-s in reverse or C-r in forward, change direction.
    (setq isearch-forward (not isearch-forward)))

  (setq isearch-barrier (point)) ; For subsequent \| if regexp.

  (if (equal isearch-string "")
      (setq isearch-success t)
    (if (and isearch-success (equal (match-end 0) (match-beginning 0))
	     (not isearch-just-started))
	;; If repeating a search that found
	;; an empty string, ensure we advance.
	(if (if isearch-forward (eobp) (bobp))
	    ;; If there's nowhere to advance to, fail (and wrap next time).
	    (progn
	      (setq isearch-success nil)
	      (ding))
	  (forward-char (if isearch-forward 1 -1))
	  (isearch-search))
      (isearch-search)))

  (isearch-push-state)
  (isearch-update))

(defun tcode-isearch-read-string ()
  "󥯥󥿥륵ʸɤ߹ࡣ"
  (let* (overriding-terminal-local-map
	 (minibuffer-setup-hook (lambda ()
				  (tcode-activate tcode-mode)))
	 (string (read-string (concat "Isearch read: " isearch-message)
			      nil nil nil t)))
    (unless (string= string "")
      (tcode-isearch-process-string string nil))))

(defun tcode-isearch-prefix-mazegaki ()
  "󥯥󥿥륵ַθ򤼽ѴԤ"
  (let* (overriding-terminal-local-map
	 (minibuffer-setup-hook (lambda ()
				  (tcode-activate tcode-mode)
				  (tcode-start-fixed-mazegaki)))
	 (string (read-string (concat "Isearch read: " isearch-message)
			      nil nil nil t)))
    (unless (string= string "")
      (tcode-isearch-process-string string nil))))

(defun tcode-isearch-postfix-mazegaki ()
  "󥯥󥿥륵˸ַθ򤼽ѴԤ"
  (let ((orig-isearch-cmds isearch-cmds)
	normal-end)
    (unwind-protect
	(let ((current-string isearch-message))
	  ;; clear isearch states
	  (while (cdr isearch-cmds)
	    (isearch-pop-state))
	  (let* (overriding-terminal-local-map
		 (minibuffer-setup-hook (lambda ()
					  (tcode-activate tcode-mode)
					  (tcode-mazegaki-start nil)))
		 (string (read-string "Isearch read: "
				      current-string nil nil t)))
	    (unless (string= string "")
	      (tcode-isearch-process-string string nil)
	      (setq normal-end t))))
      (unless normal-end
	(setq isearch-cmds orig-isearch-cmds)
	(isearch-top-state)))))

(defun isearch-toggle-tcode ()
  "󥯥󥿥륵Tɥ⡼ɤȥ뤹롣
󥯥󥿥륵 prefix/postfix ѴȤޤ"
  (interactive)
  (if tcode-isearch-start-state
      ()
    (toggle-input-method))
  (isearch-update))

(defun tcode-isearch-bushu-henkan (c1 c2)
  ;; 󥯥󥿥륵 C1  C2 ȤѴ롣
  (let ((c (tcode-bushu-compose (tcode-string-to-char c1)
				(tcode-string-to-char c2))))
    (if c
	(let ((s (char-to-string c)))
	  (isearch-delete-char)
	  (isearch-delete-char)
	  (isearch-process-search-string
	   (tcode-isearch-make-string-for-wrapping s) s))
      (ding)
      (isearch-update))))

(defun tcode-isearch-process-string (str prev)
  "ʸ STR 򸡺ʸ˲äƸ롣
PREV ȹǤȤϤιʸǸ롣"
  (if (stringp prev)
      (tcode-isearch-bushu-henkan prev str)
    (isearch-process-search-string
       (if prev
	   ""
	 (tcode-isearch-make-string-for-wrapping str)) str)))

(defun tcode-isearch-remove-ignore-regexp (str)
  "ѿ `tcode-isearch-enable-wrapped-search'  nil ǤʤȤ
STR  `tcode-isearch-ignore-regexp' "
  (if (or (not tcode-isearch-enable-wrapped-search)
	  isearch-regexp)
      str
    (let (idx
	  (regexp-len (length tcode-isearch-ignore-regexp)))
      (while (setq idx (string-match
			(regexp-quote tcode-isearch-ignore-regexp)
			str))
	(setq str (concat (substring str 0 idx)
			  (substring str (+ idx regexp-len) nil))))
      (mapconcat 'char-to-string
		 (delq ?\\ (string-to-list str))
		 nil))))

(defun tcode-isearch-make-string-for-wrapping (string)
  (let ((string-list (and string
			  (tcode-string-to-char-list string))))
    (if (and tcode-isearch-enable-wrapped-search
	     (not isearch-regexp)
	     string-list)
	(mapconcat
	 (lambda (a)
	   (let ((s (char-to-string a)))
	     (cond ((and (string-match tcode-isearch-ignore-regexp s)
			 (> (match-end 0) 0))
		    tcode-isearch-ignore-regexp)
		   ((= (char-width a) 2)
		    (concat tcode-isearch-ignore-regexp s))
		   (t
		    (regexp-quote (char-to-string a))))))
	 string-list
	 "")
      string)))

(defun tcode-isearch-start-bushu ()
  "Tɥ⡼ɥ󥯥󥿥륵 prefix ѴϤ롣"
  (tcode-bushu-init 2)
  (setq isearch-message (concat isearch-message ""))
  (isearch-push-state)
  (isearch-update))

(defun tcode-isearch-postfix-bushu ()
  "Tɥ⡼ɥ󥯥󥿥륵  postfix Ѵ"
  (let ((p1 (string-match "..$" isearch-message))
	(p2 (string-match ".$"  isearch-message)))
    (if (null p1)
	(ding)
      (tcode-bushu-init 2)
      (tcode-isearch-bushu-henkan (substring isearch-message p1 p2)
				  (substring isearch-message p2)))))

(defun tcode-isearch-bushu ()
  "isearch-messageʸĴ٤롣"
  (cond
   ((string-match "$" isearch-message)
    t)
   ((string-match ".$" isearch-message)
    (substring isearch-message (string-match ".$" isearch-message)))
   (t
    nil)))

(defun tcode-isearch-bushu-henkan-command ()
  "isearchѴϤ롣"
  (interactive)
  (if (not tcode-use-postfix-bushu-as-default)
      (tcode-isearch-start-bushu)
    (tcode-isearch-postfix-bushu)))

(defun tcode-isearch-init ()
  "Tɥ⡼ɥ󥯥󥿥륵νԤ"
  (setq tcode-mode (if (numberp tcode-isearch-start-state)
		       (if (zerop tcode-isearch-start-state) nil t)
		     (and (boundp 'tcode-mode)
			  tcode-mode)))
  (isearch-update))

(add-hook 'isearch-mode-hook 'tcode-isearch-init)

(provide 'tc-is20)

;;; tc-is20.el ends here
