#!/usr/bin/python

"""
__version__ = "$Revision: 1.1 $"
__date__ = "$Date: 2004/07/20 18:22:35 $"
"""

from PythonCard import dialog, model
import pyfi

class MyBackground(model.Background):

    def on_initialize(self, event):
        # if you have any initialization
        # including sizer setup, do it here
        self.on_Calculate_mouseClick(None)

    def on_Calculate_mouseClick(self, event):
        comp = self.components
        try:
            principal = float(comp.Principal.text)
            interestRate = float(comp.InterestRate.text)
            if interestRate > 1:
                interestRate = interestRate / 100.0
            payment15 = pyfi.amortization(principal, interestRate, 12, 15 * 12)
            payment30 = pyfi.amortization(principal, interestRate, 12, 30 * 12)
            comp.Result.text = "15 year monthly payment: %.2f\n30 year monthly payment: %.2f" % (payment15, payment30)
        except:
            dialog.alertDialog(self, 'Please enter valid values', 'Input Value(s) Error')


if __name__ == '__main__':
    app = model.Application(MyBackground)
    app.MainLoop()
