#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
DVER=$(dpkg-parsechangelog | egrep '^Version:' | cut -f 2 -d ' ' | sed 's/\-[^-]*$//')
TAR=python-scipy_$DVER.orig.tar.gz
DIR=scipy-$2.orig

# extract upstream tar ball
tar xzf $3
mv scipy-$2 $DIR
rm $3

# add cython source files
(cd $DIR/scipy/spatial/;\
svn export http://svn.scipy.org/svn/scipy/tags/$2/scipy/spatial/ckdtree.pyx)
(cd $DIR/scipy/stats/;\
svn export http://svn.scipy.org/svn/scipy/tags/$2/scipy/stats/vonmises_cython.pyx)

# create tar ball
GZIP=--best tar czf $TAR $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi
