# $Id: __init__.py,v 1.5 2000/11/02 13:13:43 rliebscher Exp $
import sys
import OpenGL
if OpenGL._numeric:
    from Numeric import ArrayType
    try:
        import OpenGL.dynload._glu_num
        #print OpenGL.dynload._glu_num
        _glu = OpenGL.dynload._glu_num
    except ImportError:
        import OpenGL.dynload._glu
        #print OpenGL.dynload._glu
        _glu = OpenGL.dynload._glu
else:
    import OpenGL.dynload._glu
    #print OpenGL.dynload._glu
    _glu = OpenGL.dynload._glu

from gluconst import *
from OpenGL.GL import Error, CarefulFunction

origdict = _glu.__dict__.copy()
sys.modules['OpenGL.GLU'].__dict__.update(origdict)

carefuldict = {}
for name, func in origdict.items():
    if callable(func):
        carefuldict[name] = CarefulFunction(name, func)
# These do the same sorts of things that the C versions would

def careful():
    cd = carefuldict.copy()
    if cd.has_key('error'): del cd['error']
    sys.modules['OpenGL.GLU'].__dict__.update(cd)

import string
def fast():
    cd = origdict.copy()
    if cd.has_key('error'): del cd['error']
    if cd.has_key('glconst'): del cd['glconst']
    sys.modules['OpenGL.GLU'].__dict__.update(cd)
