"""config.py

Configurable options for compilation of PyOpenGL.

"""

## created 2000/11/10, Rene Liebscher <R.Liebscher@gmx.de>

import sys

#######################################################################
## platform specific stuff

# user configurable part
# gl_libs       : OpenGL libraries
# glu_libs      : GLU libraries
# glut_libs     : glut libraries
# include_dirs  : include directories for everything
# gl_lib_dirs   : OpenGL library search paths
# glu_lib_dirs  : GLU -----------------------
# glut_lib_dirs : glut ----------------------

# Togl specific parts, (TK and TCL are added automatically)
# togl_libs         : libraries
# togl_lib_dirs     : library search paths
# togl_include_dirs : header files search paths


# if Tkinter is not available for Python, Togl is not build in any case
TRY_TO_BUILD_TOGL = 1


if sys.platform == "win32":
    # libraries have different names on win32
    gl_libs = ["opengl32"]
    glu_libs = ["glu32"] + gl_libs
    glut_libs = ["glut32"] + glu_libs
    # no special directories for most windows compilers
    include_dirs = ["src"]
    gl_lib_dirs = []
    glu_lib_dirs = []
    glut_lib_dirs = []
    togl_libs = glu_libs + ["gdi32","user32"]
    togl_lib_dirs = []
    togl_include_dirs = []

elif sys.platform[0:4] == "beos": # Python2.0 uses "beos5", Python1.5 "beos" 
    # not really working with BeOS 5 Personal Edition + DevTools 
    # - _opengl,openglutils compiles without problems
    # - no library for GLU => no _glu module
    # - no glut => no _glut module
    # but with Mesa3D it works
    gl_libs = ["GL"]
    glu_libs = ["GLU"] + gl_libs 
    glut_libs = ["glut"] + glu_libs 
    include_dirs = ["src","/boot/home/config/include"]
    gl_lib_dirs = ["/boot/home/config/lib"]
    glu_lib_dirs = gl_lib_dirs 
    glut_lib_dirs = glu_lib_dirs 
    # does TK run on BeOS ?
    togl_libs = []
    togl_lib_dirs = []
    togl_include_dirs = []


elif sys.platform == "mac": # ???????
    # At the time of writing this (2000/12/06), the necessary Mac fixes for
    # distutils weren't included in distutils 1.0.1. They get probably
    # in distutils in any version >1.0.1.
    # The following stuff was kindly provided by Jack Jansen. 
    #
    # Here you should fill in the path to the root of Apple's OpenGL SDK.
    # Also note that you have to create a subfolder GL in Headers, and
    # Copy the following files:
    # :Headers:GL/gl.h -> :Headers:GL:gl.h
    # :Headers:GL/glu.h -> :Headers:GL:glu.h
    # :Headers:GL/glut.h -> :Headers:GL:glut.h
    # This is because Python extension modules need the CodeWarrior setting
    # "interpret dos/unix paths", so the nifty trick Apple used to circumvene
    # the slash-problem backfires on us.
    #
    MAC_GL_ROOT_FOLDER="Macintosh HD:SWDev:Jack:OpenGL SDK"
    TRY_TO_BUILD_TOGL = 0
    gl_libs = ["OpenGLLibraryStub"] 
    glu_libs = ["OpenGLUtilityStub"] + gl_libs
    # XXXX Not sure about glut.rsrc. It contains about dialogs and such
    glut_libs = ["glut.lib", "glut.rsrc"] + glu_libs 
    include_dirs = ["src", MAC_GL_ROOT_FOLDER + ":Headers"]
    gl_lib_dirs = [MAC_GL_ROOT_FOLDER+":Libraries",MAC_GL_ROOT_FOLDER+":Resources"]
    glu_lib_dirs = gl_lib_dirs 
    glut_lib_dirs = glu_lib_dirs 
    togl_libs = glu_libs + []
    togl_lib_dirs = glu_lib_dirs
    togl_include_dirs = include_dirs

else: # anything else, Unix-like OS
    gl_libs = ["GL","X11","Xext"] # some Mesa versions need X11 here
    glu_libs = ["GLU"] + gl_libs 
    glut_libs = ["glut","Xi","Xmu"] + glu_libs # + ['cvt'] SGI IRIX6
    include_dirs = ["src","/usr/local/include","/usr/X11/include","/usr/X11R6/include","/usr/include"]
    gl_lib_dirs = ["/usr/local/lib","/usr/X11/lib","/usr/X11R6/lib","/usr/lib"]
    # special case for IRIX #########
    # you may have to specify your own paths here
    if sys.platform[0:4] == "irix": gl_lib_dirs = []
    #################################
    glu_lib_dirs = gl_lib_dirs 
    glut_lib_dirs = glu_lib_dirs 
    togl_libs = glu_libs + ["Xmu","Xt","m"]
    togl_lib_dirs = glu_lib_dirs
    togl_include_dirs = include_dirs

## end of user configurable part
