/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "SphereObjPy.h"

using namespace boost::python;

void exportSphereObj ()
{
  // Check that Boost 1.34.0 or higher is being used.
  // If so, disable auto-generation of C++ signatures for Epydoc
  // (which stumbles over indentation in the auto-generated strings).
  #if ((BOOST_VERSION / 100000 >= 1) \
      && (BOOST_VERSION / 100 % 1000 >= 34)) \
      || (BOOST_VERSION / 100000 >= 2)
    boost::python::docstring_options no_autogen(true,false);
  #endif

      class_<SphereObj>(
        "SphereObj",
        "A 3D sphere shape to be inserted in a shape list.",
        init<>()
      )
      .def(
        "setBias",
        &::dot,
        ( arg("i") ),
        "Sets the bias of the sphere shape (how often it should occur)\n"
        "@type i: int\n"
        "@kwarg i: the bias as any integer\n"
      )
      ;
}
