# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .artifact_properties import ArtifactProperties


class ArtifactContentPropertiesDefinition(ArtifactProperties):
    """The artifact content properties definition.

    :param created_time: The artifact creation time.
    :type created_time: datetime
    :param changed_time: The artifact changed time.
    :type changed_time: datetime
    :param metadata:
    :type metadata: object
    :param content:
    :type content: object
    :param content_type: The content type.
    :type content_type: str
    :param content_link: The content link.
    :type content_link: ~azure.mgmt.logic.models.ContentLink
    """

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'content': {'key': 'content', 'type': 'object'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'content_link': {'key': 'contentLink', 'type': 'ContentLink'},
    }

    def __init__(self, **kwargs):
        super(ArtifactContentPropertiesDefinition, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)
        self.content_type = kwargs.get('content_type', None)
        self.content_link = kwargs.get('content_link', None)
