# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.batch_account_operations import BatchAccountOperations
from .operations.application_package_operations import ApplicationPackageOperations
from .operations.application_operations import ApplicationOperations
from .operations.location_operations import LocationOperations
from .operations.operations import Operations
from .operations.certificate_operations import CertificateOperations
from .operations.pool_operations import PoolOperations
from . import models


class BatchManagementClientConfiguration(AzureConfiguration):
    """Configuration for BatchManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The Azure subscription ID. This is a
     GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(BatchManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-mgmt-batch/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class BatchManagementClient(object):
    """BatchManagementClient

    :ivar config: Configuration for client.
    :vartype config: BatchManagementClientConfiguration

    :ivar batch_account: BatchAccount operations
    :vartype batch_account: azure.mgmt.batch.operations.BatchAccountOperations
    :ivar application_package: ApplicationPackage operations
    :vartype application_package: azure.mgmt.batch.operations.ApplicationPackageOperations
    :ivar application: Application operations
    :vartype application: azure.mgmt.batch.operations.ApplicationOperations
    :ivar location: Location operations
    :vartype location: azure.mgmt.batch.operations.LocationOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.batch.operations.Operations
    :ivar certificate: Certificate operations
    :vartype certificate: azure.mgmt.batch.operations.CertificateOperations
    :ivar pool: Pool operations
    :vartype pool: azure.mgmt.batch.operations.PoolOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The Azure subscription ID. This is a
     GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = BatchManagementClientConfiguration(credentials, subscription_id, base_url)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2017-09-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.batch_account = BatchAccountOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.application_package = ApplicationPackageOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.application = ApplicationOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.location = LocationOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.certificate = CertificateOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.pool = PoolOperations(
            self._client, self.config, self._serialize, self._deserialize)
