# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EdifactFramingSettings(Model):
    """EdifactFramingSettings.

    :param service_code_list_directory_version: The service code list
     directory version.
    :type service_code_list_directory_version: str
    :param character_encoding: The character encoding.
    :type character_encoding: str
    :param protocol_version: The protocol version.
    :type protocol_version: int
    :param data_element_separator: The data element separator.
    :type data_element_separator: int
    :param component_separator: The component separator.
    :type component_separator: int
    :param segment_terminator: The segment terminator.
    :type segment_terminator: int
    :param release_indicator: The release indicator.
    :type release_indicator: int
    :param repetition_separator: The repetition separator.
    :type repetition_separator: int
    :param character_set: The EDIFACT frame setting characterSet. Possible
     values include: 'NotSpecified', 'UNOB', 'UNOA', 'UNOC', 'UNOD', 'UNOE',
     'UNOF', 'UNOG', 'UNOH', 'UNOI', 'UNOJ', 'UNOK', 'UNOX', 'UNOY', 'KECA'
    :type character_set: str or :class:`EdifactCharacterSet
     <azure.mgmt.logic.models.EdifactCharacterSet>`
    :param decimal_point_indicator: The EDIFACT frame setting decimal
     indicator. Possible values include: 'NotSpecified', 'Comma', 'Decimal'
    :type decimal_point_indicator: str or :class:`EdifactDecimalIndicator
     <azure.mgmt.logic.models.EdifactDecimalIndicator>`
    :param segment_terminator_suffix: The EDIFACT frame setting segment
     terminator suffix. Possible values include: 'NotSpecified', 'None',
     'CR', 'LF', 'CRLF'
    :type segment_terminator_suffix: str or :class:`SegmentTerminatorSuffix
     <azure.mgmt.logic.models.SegmentTerminatorSuffix>`
    """ 

    _attribute_map = {
        'service_code_list_directory_version': {'key': 'serviceCodeListDirectoryVersion', 'type': 'str'},
        'character_encoding': {'key': 'characterEncoding', 'type': 'str'},
        'protocol_version': {'key': 'protocolVersion', 'type': 'int'},
        'data_element_separator': {'key': 'dataElementSeparator', 'type': 'int'},
        'component_separator': {'key': 'componentSeparator', 'type': 'int'},
        'segment_terminator': {'key': 'segmentTerminator', 'type': 'int'},
        'release_indicator': {'key': 'releaseIndicator', 'type': 'int'},
        'repetition_separator': {'key': 'repetitionSeparator', 'type': 'int'},
        'character_set': {'key': 'characterSet', 'type': 'EdifactCharacterSet'},
        'decimal_point_indicator': {'key': 'decimalPointIndicator', 'type': 'EdifactDecimalIndicator'},
        'segment_terminator_suffix': {'key': 'segmentTerminatorSuffix', 'type': 'SegmentTerminatorSuffix'},
    }

    def __init__(self, service_code_list_directory_version=None, character_encoding=None, protocol_version=None, data_element_separator=None, component_separator=None, segment_terminator=None, release_indicator=None, repetition_separator=None, character_set=None, decimal_point_indicator=None, segment_terminator_suffix=None):
        self.service_code_list_directory_version = service_code_list_directory_version
        self.character_encoding = character_encoding
        self.protocol_version = protocol_version
        self.data_element_separator = data_element_separator
        self.component_separator = component_separator
        self.segment_terminator = segment_terminator
        self.release_indicator = release_indicator
        self.repetition_separator = repetition_separator
        self.character_set = character_set
        self.decimal_point_indicator = decimal_point_indicator
        self.segment_terminator_suffix = segment_terminator_suffix
