from Ft.Rdf.Parsers import Versa
from Ft.Rdf.Parsers.Versa import Traversal

import test_helper

def test_forward(tester,model):

    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }


    con = Versa.CreateContext(model = model,
                              nsMapping = nsMap)

    exp = "all()-dc:Title->*"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    tester.compare(1,isinstance(exp,Traversal.ForwardTraversal))
    res = exp.evaluate(con)
    tester.compare(3, len(res))
    tester.compareIn(res,"Mike Olson")
    tester.compareIn(res,"Jessica Olson")
    tester.compareIn(res,"Fourthought, Inc.")
    tester.testDone()


    exp = "all()-ft:spouse->*-dc:Title->*"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    tester.compare(1,isinstance(exp,Traversal.ForwardTraversal))
    res = exp.evaluate(con)
    tester.compare(1, len(res))
    tester.compareIn(res,"Jessica Olson")
    tester.testDone()


    

def Test(tester):

    model = test_helper.init(tester)
    test_forward(tester,model)


if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)
