<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    This stylesheet creates a new game.

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:import href='../common/cards.xslt'/>

  <xsl:output method='html'/>

  <xsl:param name='name'/>
  <xsl:param name='type'/>
  <xsl:param name='diff'/>

  <xsl:template match='/'>
    <!-- Create a new game -->

    <xsl:variable name='deck'>
      <xsl:call-template name='shuffle-cards'>
        <xsl:with-param name='num-decks' select='1'/>
      </xsl:call-template>
    </xsl:variable>

    <!-- Determine the cut -->
    <xsl:variable name='p1Cut' select='f:random(51,1)+1'/>
    <xsl:variable name='p2Cut'>
      <xsl:call-template name='second-player-cut'>
        <xsl:with-param name='first-player-cut' select='$p1Cut'/>
        <xsl:with-param name='deck' select='$deck'/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:message>
      P1 Cut <xsl:value-of select='$p1Cut'/>
      P2 Cut <xsl:value-of select='$p2Cut'/>
    </xsl:message>
    <xsl:variable name='p1CutCard' select='exslt:node-set($deck)/Card[number($p1Cut)]'/>
    <xsl:variable name='p2CutCard' select='exslt:node-set($deck)/Card[number($p2Cut)]'/>

    <!-- now deal em -->
    <xsl:variable name='dealt'>
      <xsl:apply-templates select='exslt:node-set($deck)/Card[1]' mode='deal'/>
    </xsl:variable>

    <xsl:variable name='new-id' select='f:generate-uuid()'/>

    <fcore:create-document base-path='games' path='{$new-id}'>
      <cribbage>
        <player-info>
          <player ID='1' level='{$diff}'>
            <scores>
              <score>0</score>
              <score>0</score>
            </scores>
            <name>Computer</name>
            <cards>
              <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="P1"]'/>
            </cards>
            <playing-cards>
              <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="P1"]'/>
            </playing-cards>
            <played-cards/>
            <in-go>0</in-go>
          </player>
          <player ID='2'>
            <scores>
              <score>0</score>
              <score>0</score>
            </scores>
            <name><xsl:value-of select='$name'/></name>
            <cards>
              <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="P2"]'/>
            </cards>
            <playing-cards>
              <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="P2"]'/>
            </playing-cards>
            <played-cards/>
            <in-go>0</in-go>
          </player>
        </player-info>
        <draw-info>
          <player-one>
            <xsl:copy-of select='$p1CutCard'/>
          </player-one>
          <player-two>
            <xsl:copy-of select='$p2CutCard'/>
          </player-two>
        </draw-info>
        <game-info type='{$type}'>
          <cur-count>
            <score>0</score>
          </cur-count>
          <xsl:choose>
            <xsl:when test='number($p1CutCard/@value-int) &lt; number($p2CutCard/@value-int)'>
              <cur-dealer IDREF='1'/>
              <cur-player IDREF='2'/>
            </xsl:when>
            <xsl:otherwise>
              <cur-dealer IDREF='2'/>
              <cur-player IDREF='1'/>
            </xsl:otherwise>
          </xsl:choose>
          <!--  <first-go/> -->

          <!--Just use 15 cause its easier, still random -->
          <cut-card>
            <xsl:copy-of select='exslt:node-set($deck)/Card[position() = 15]'/>
          </cut-card>
          <!--  <played/> -->
          <cur-played/>
          <all-played/>
        </game-info>
        <log>
        </log>
        <cur-log>
          <log-entry>Computer Draws <xsl:value-of select='$p1CutCard/@formal-name'/></log-entry>
          <log-entry><xsl:value-of select='$name'/> Draws <xsl:value-of select='$p2CutCard/@formal-name'/></log-entry>
        </cur-log>
        <crib-info/>
        <changes/>
      </cribbage>
    </fcore:create-document>

    <fcore:mark-temporary path='games/{$new-id}' time-to-live='500'/>

    <fhttp:response-uri uri="games/{$new-id}?xslt=../draw.xsl"/>

  </xsl:template>


  <xsl:template name='second-player-cut'>
    <xsl:param name='first-player-cut'/>
    <xsl:param name='deck'/>
    <xsl:variable name='p2Cut' select='f:random(51,1)+1'/>
    <xsl:choose>
      <xsl:when test='$first-player-cut = $p2Cut or number(exslt:node-set($deck)/Card[number($first-player-cut)]/@value-int) = number(exslt:node-set($deck)/Card[number($p2Cut)]/@value-int)'>
        <xsl:call-template name='second-player-cut'>
          <xsl:with-param name='first-player-cut' select='$first-player-cut'/>
          <xsl:with-param name='deck' select='$deck'/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select='$p2Cut'/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template match='Card' mode='deal'>
    <xsl:param name='cur-pos' select='1'/>
    <xsl:param name='total' select='0'/>

    <xsl:variable name='next-pos'>
      <xsl:choose>
        <xsl:when test='$cur-pos = 1'>2</xsl:when>
        <xsl:otherwise>1</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <Card>
      <xsl:copy-of select='@*'/>
      <xsl:attribute name='position'>
        <xsl:value-of select='concat("P",$cur-pos)'/>
      </xsl:attribute>
    </Card>
    <xsl:if test='$total != 11'>
      <xsl:apply-templates select='following-sibling::Card[1]' mode='deal'>
        <xsl:with-param name='cur-pos' select='normalize-space($next-pos)'/>
        <xsl:with-param name='total' select='$total + 1'/>
      </xsl:apply-templates>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
