__revision__ = '$Id: __init__.py,v 1.4 2002/07/18 18:15:59 molson Exp $'

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)
    
    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    ignored_files = ['test_helper',
                     'GetCoreFunctionList',
                     'test_coverage_start',
                     'test_coverage_end',
                     ]
    RemoveTests(files, ignored_files)

    ordered_files = ['test_get_repository',
                     'test_basic_resource_metadata',
                     'test_container',
                     'test_basic_rawfile',
                     'test_raw_file',
                     'test_xml_document',
                     'test_documentdefinition',
                     'test_meta_document',
                     ]
    SortTests(files, ordered_files)

    ignored_dirs = []
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = []
    SortTests(dirs, ordered_dirs)

    return (dirs, files)


CoverageModule = 'Ft.Server.Client.Core'
