########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Xml/__init__.py,v 1.38 2005/04/12 06:32:17 mbrown Exp $
"""
Things commonly needed by many modules in Ft.Xml

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__all__ = [# constants
           'EMPTY_NAMESPACE',
           'EMPTY_PREFIX',
           'XML_NAMESPACE',
           'XMLNS_NAMESPACE',
           'XHTML_NAMESPACE',
           'READ_EXTERNAL_DTD',
           'HAS_PYEXPAT',
           # classes
           'ReaderException', 'XIncludeException',
           # functions
           'SplitQName', 'ApplyXUpdate',
           # modules
           'MarkupWriter',
           ]


EMPTY_NAMESPACE = None
EMPTY_PREFIX = None
XML_NAMESPACE = u"http://www.w3.org/XML/1998/namespace"
XMLNS_NAMESPACE = u"http://www.w3.org/2000/xmlns/"
XHTML_NAMESPACE = u"http://www.w3.org/1999/xhtml"

# Defined here to ensure that all readers operate the same.
READ_EXTERNAL_DTD = True

from Ft import FtException, __version__

class ReaderException(FtException):
    """
    Exception class for errors specific to XML reading
    (at a level above standard, non-namespace-aware parsing)
    """
    XML_PARSE_ERROR = 100
    RECURSIVE_PARSE_ERROR = 101
    XMLNS_UNKNOWN_PREFIX = 200
    INVALID_XMLNS = 201
    XMLNS_DUPLICATE_ATTRS = 202

    def __init__(self, errorCode, *args):
        FtException.__init__(self, errorCode, MessageSource.READER, args)
        return

class XIncludeException(FtException):
    """
    Exception class for errors specific to XInclude processing
    """
    MISSING_HREF = 10
    INVALID_PARSE_ATTR = 11

    def __init__(self, errorCode, *args):
        FtException.__init__(self, errorCode, MessageSource.XINCLUDE, args)

import MessageSource

from Ft.Xml.Lib.XmlString import SplitQName


#Wrap this so that we can import it later
def ApplyXUpdate(*args, **kw_args):
    import Ft.Xml.XUpdate
    return XUpdate.ApplyXUpdate(*args, **kw_args)

#Good ol' backward compatibility for creative spellings
def ApplyXupdate(*args, **kw_args):
    import Ft.Xml.XUpdate
    return XUpdate.ApplyXupdate(*args, **kw_args)


from distutils import version
pyxml_required = version.StrictVersion('0.8.0')
def CheckVersion(feature=None):
    """
    PyXML is required by some features of 4Suite (e.g., validating parsing,
    and 4XSLT's SaxWriter). This is a common function to test whether a
    correct version of PyXML is installed. It raises a SystemExit if the
    test result is negative, and returns None otherwise.

    The feature argument is a string indicating which feature in 4Suite
    requires PyXML. It is output as part of the SystemExit message.
    """
    try:
        import _xmlplus
        xml_version = version.StrictVersion(_xmlplus.__version__)
    except:
        xml_version = version.StrictVersion('0.0.0')

    if xml_version < pyxml_required:
        import sys
        if feature:
            feature_string = "%s in " % feature
        else:
            feature_string = "this feature in "
        print """
        PyXML v%s is required for %s4Suite.
        It is available at http://sourceforge.net/projects/pyxml.
        """ % (str(pyxml_required), feature_string)
        sys.exit(1)

HAS_PYEXPAT = True
try:
    from xml.parsers import expat
    expat.ParserCreate
    del expat
except (ImportError, AttributeError):
    HAS_PYEXPAT = False

from MarkupWriter import MarkupWriter
