<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    Counting routines

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:import href='common.xsl'/>

  <xsl:template name='count-hand'>
    <!-- Count a single hand, with a possible draw card if there is a draw card, it must be in the cards list and the draw param-->
    <xsl:param name='cards'/>
    <xsl:param name='draw' select="/.."/>
    <xsl:param name='is-crib'/>



    <!-- The results are a RTF with information about the counting -->

    <!-- sort the cards into anew RTF -->
    <xsl:variable name='non-ns-sorted-cards'>
      <xsl:for-each select='exslt:node-set($cards)'>
          <xsl:sort select='@value-int' data-type='number'/>
          <xsl:copy-of select='.'/>
      </xsl:for-each>
    </xsl:variable>

    <xsl:variable name='sorted-cards' select='exslt:node-set($non-ns-sorted-cards)'/>

    <xsl:variable name='temp-res'>
      <TempResults>
        <!-- One card results, knobs -->
        <xsl:for-each select='$cards[@short-name != $draw/@short-name]'>
          <!--<one-card-set>
            <xsl:copy-of select='.'/>
          </one-card-set>-->
          <xsl:call-template name='count-one-cards'>
            <xsl:with-param name='card1' select='.'/>
            <xsl:with-param name='draw' select='$draw'/>
          </xsl:call-template>
        </xsl:for-each>

        <!-- Two card results, pairs and fifteens -->
        <xsl:for-each select='$sorted-cards/Card'>
          <xsl:variable name='card1-pos' select='position()'/>
          <xsl:variable name='card1' select='.'/>
          <xsl:for-each select='$sorted-cards/Card[position() > $card1-pos]'>
            <!--<two-card-set>
              <xsl:copy-of select='$card1'/>
              <xsl:copy-of select='.'/>
            </two-card-set>-->
            <xsl:call-template name='count-two-cards'>
              <xsl:with-param name='card1' select='$card1'/>
              <xsl:with-param name='card2' select='.'/>
            </xsl:call-template>
          </xsl:for-each>
        </xsl:for-each>

        <!-- Now, do the five card results first,  if, we get a run or a flush then don't look for them later -->
        <!-- Five card results, runs and fifteens -->
        <xsl:variable name='five-card-res'>
          <xsl:if test='count($sorted-cards/Card) = 5'>
            <xsl:call-template name='count-five-cards'>
              <xsl:with-param name='card1' select='$sorted-cards/Card[1]'/>
              <xsl:with-param name='card2' select='$sorted-cards/Card[2]'/>
              <xsl:with-param name='card3' select='$sorted-cards/Card[3]'/>
              <xsl:with-param name='card4' select='$sorted-cards/Card[4]'/>
              <xsl:with-param name='card5' select='$sorted-cards/Card[5]'/>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>

        <xsl:for-each select='exslt:node-set($five-card-res)/*'>
          <xsl:copy-of select='.'/>
        </xsl:for-each>

        <!-- Do the four card stuff, same rules apply to the three card -->

        <xsl:variable name = 'four-card-res'>
          <xsl:if test='count($sorted-cards/Card) > 3'>
            <xsl:for-each select='$sorted-cards/Card'>
              <xsl:variable name='card1-pos' select='position()'/>
              <xsl:variable name='card1' select='.'/>
              <xsl:for-each select='$sorted-cards/Card'>
                <xsl:if test='position() > $card1-pos'>
                  <xsl:variable name='card2-pos' select='position()'/>
                  <xsl:variable name='card2' select='.'/>
                  <xsl:for-each select='$sorted-cards/Card'>
                    <xsl:if test='position() > $card2-pos'>
                      <xsl:variable name='card3-pos' select='position()'/>
                      <xsl:variable name='card3' select='.'/>
                      <xsl:for-each select='$sorted-cards/Card[position() > $card3-pos]'>
                        <!--<four-card-set>
                          <xsl:copy-of select='$card1'/>
                          <xsl:copy-of select='$card2'/>
                          <xsl:copy-of select='$card3'/>
                          <xsl:copy-of select='.'/>
                          <xsl:copy-of select='$draw'/>
                        </four-card-set>-->

                        <xsl:call-template name='count-four-cards'>
                          <xsl:with-param name='card1' select='$card1'/>
                          <xsl:with-param name='card2' select='$card2'/>
                          <xsl:with-param name='card3' select='$card3'/>
                          <xsl:with-param name='card4' select='.'/>
                          <xsl:with-param name='count-run' select='not(count(exslt:node-set($five-card-res)/Run))'/>
                          <!-- Count a 4 carded flush if
                               1.  it is not the crib
                               2.  none of the four cards are the draw card
                               3.  We did not find a five carded flush
                               -->
                          <xsl:with-param name='count-flush' select='not($is-crib) and not($draw/@short-name = ./@short-name or $draw/@short-name = $card1/@short-name or $draw/@short-name = $card2/@short-name or $draw/@short-name = $card3/@short-name) and not(count(exslt:node-set($five-card-res)/Flush))'/>
                        </xsl:call-template>
                      </xsl:for-each>
                    </xsl:if>
                  </xsl:for-each>
                </xsl:if>
              </xsl:for-each>
            </xsl:for-each>
          </xsl:if>
        </xsl:variable>
        <xsl:for-each select='exslt:node-set($four-card-res)/*'>
          <xsl:copy-of select='.'/>
        </xsl:for-each>

        <!-- Lastly look for any three card results -->
        <xsl:if test='count($sorted-cards/Card) > 2'>
          <xsl:for-each select='$sorted-cards/Card'>
            <xsl:variable name='card1-pos' select='position()'/>
            <xsl:variable name='card1' select='.'/>
            <xsl:for-each select='$sorted-cards/Card'>
              <xsl:if test='position() > $card1-pos'>
                <xsl:variable name='card2-pos' select='position()'/>
                <xsl:variable name='card2' select='.'/>
                <xsl:for-each select='$sorted-cards/Card[position() > $card2-pos]'>
                  <!--<three-card-set>
                    <xsl:copy-of select='$card1'/>
                    <xsl:copy-of select='$card2'/>
                    <xsl:copy-of select='.'/>
                  </three-card-set>-->
                  <xsl:call-template name='count-three-cards'>
                    <xsl:with-param name='card1' select='$card1'/>
                    <xsl:with-param name='card2' select='$card2'/>
                    <xsl:with-param name='card3' select='.'/>
                    <xsl:with-param name='count-run' select='not(count(exslt:node-set($five-card-res)/Run) + count(exslt:node-set($four-card-res)/Run))'/>
                  </xsl:call-template>
                </xsl:for-each>
              </xsl:if>
            </xsl:for-each>
          </xsl:for-each>
        </xsl:if>
      </TempResults>
    </xsl:variable>

    <xsl:variable name='fifteens' select='count(exslt:node-set($temp-res)/TempResults/Fifteen)'/>
    <xsl:variable name='pairs' select='count(exslt:node-set($temp-res)/TempResults/Pair)'/>
    <xsl:variable name='five-card-runs' select='count(exslt:node-set($temp-res)/TempResults/Run[count(Card) = 5])'/>
    <xsl:variable name='four-card-runs' select='count(exslt:node-set($temp-res)/TempResults/Run[count(Card) = 4])'/>
    <xsl:variable name='three-card-runs' select='count(exslt:node-set($temp-res)/TempResults/Run[count(Card) = 3])'/>
    <xsl:variable name='five-card-flushes' select='count(exslt:node-set($temp-res)/TempResults/Flush[count(Card) = 5])'/>
    <xsl:variable name='four-card-flushes' select='count(exslt:node-set($temp-res)/TempResults/Flush[count(Card) = 4])'/>
    <xsl:variable name='knobs' select='count(exslt:node-set($temp-res)/TempResults/Knobs)'/>

    <CribbageCount fifteens='{$fifteens}' pairs = '{$pairs}' runs = '{$five-card-runs + $four-card-runs + $three-card-runs}' flushes = '{$five-card-flushes + $four-card-flushes}' knobs = '{$knobs}'>
      <xsl:attribute name='total'>
        <xsl:value-of select = '$fifteens*2 + $pairs*2 + $five-card-runs*5 + $four-card-runs*4 + $three-card-runs*3 + $knobs + $five-card-flushes*5 + $four-card-flushes*4'/>
      </xsl:attribute>
      <OriginalHand>
        <xsl:for-each select='$cards'>
          <xsl:copy-of select='.'/>
        </xsl:for-each>
      </OriginalHand>
      <Draw>
        <xsl:copy-of select='$draw'/>
      </Draw>
      <xsl:for-each select='exslt:node-set($temp-res)/TempResults/node()'>
        <xsl:copy-of select='.'/>
      </xsl:for-each>
    </CribbageCount>


  </xsl:template>


  <xsl:template name='count-stack'>
    <xsl:param name='played'/>
    <xsl:param name='next-card'/>
    <xsl:param name='cur-count'/>
    <!--
         Do some basic point counting to see how many points are on the stack when the current card is played
         The stack can have runs and pairs.  All cards that are used in the stack must be in order from the
         back to the front starting with next-card, then played[-1], played[-2], etc.  There are also points for
         cur-count+next-card = 15 or 31.
         -->

    <!--sort the played cards -->
    <xsl:variable name='sorted-played'>
      <sorted>
        <xsl:for-each select='exslt:node-set($played)'>
          <xsl:copy-of select='.'/>
        </xsl:for-each>
        <xsl:copy-of select='$next-card'/>
      </sorted>
    </xsl:variable>

    <!--<xsl:message>
      Starting Count Stack!!
      Original Cards:
      <xsl:apply-templates select='exslt:node-set($sorted-played)/sorted/Card' mode='serialize'/>
    </xsl:message>-->


    <xsl:variable name='temp-res'>
      <TempResults>
        <xsl:if test='number($cur-count) + number($next-card/@point) = 15'>
          <Fifteen/>
        </xsl:if>
        <xsl:if test='number($cur-count) + number($next-card/@point) = 31'>
          <ThirtyOne/>
        </xsl:if>

        <!--
          Look for pairs, could be as far as four back, and runs up to seven back!!!
        -->
        <xsl:variable name='sets'>
          <xsl:for-each select='exslt:node-set($sorted-played)/sorted/Card'>
            <set>
              <xsl:for-each select='.|following-sibling::*'>
                <xsl:sort select='@value-int' data-type='number'/>
                <xsl:copy-of select='.'/>
              </xsl:for-each>
            </set>
          </xsl:for-each>
        </xsl:variable>

        <xsl:apply-templates select='exslt:node-set($sets)/set[count(Card) > 1][1]' mode='count-stack-pair'/>
        <xsl:apply-templates select='exslt:node-set($sets)/set[count(Card) > 2][1]' mode='count-stack-run'/>

      </TempResults>
    </xsl:variable>


    <!--<xsl:message>
      Done Counting Stack!!
      Results:
      <xsl:for-each select='exslt:node-set($temp-res)/TempResults/*'>
        <xsl:value-of select='local-name()'/>/
      </xsl:for-each>
    </xsl:message>-->


    <StackCountResults>
      <xsl:attribute name='total'>
        <xsl:value-of select='count(exslt:node-set($temp-res)/TempResults/Fifteen)*2 + count(exslt:node-set($temp-res)/TempResults/ThirtyOne)*2 + sum(exslt:node-set($temp-res)/TempResults/Pair/@points) + count(exslt:node-set($temp-res)/TempResults/Run/Card)'/>
      </xsl:attribute>
      <xsl:for-each select='exslt:node-set($temp-res)/TempResults/*'>
        <xsl:copy-of select='.'/>
      </xsl:for-each>
      <PlayedCards>
        <xsl:for-each select='exslt:node-set($played)'>
          <xsl:copy-of select='.'/>
        </xsl:for-each>
      </PlayedCards>
      <NextCard>
        <xsl:copy-of select='$next-card'/>
      </NextCard>
    </StackCountResults>

  </xsl:template>


  <xsl:template match='set' mode='serialize'>
    @@Start Set@@
    <xsl:apply-templates select='Card' mode='serialize'/>
    @@END SET@@
  </xsl:template>

  <xsl:template match='set' mode='count-stack-pair'>
    <!--See if this stack has any points in it-->

    <!-- see if they all have the same value-int (check for pairs) -->
    <xsl:variable name = 'same-count'>
      <xsl:for-each select='Card[position() > 1]'>
        <xsl:if test='number(@value-int) = number(preceding-sibling::Card[1]/@value-int)'>
          <xsl:text>1</xsl:text>
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test='string-length($same-count) +1 = count(Card)'>
        <Pair points="{(f:fact(count(Card)) div f:fact(count(Card)-2))}">
          <xsl:copy-of select='Card'/>
        </Pair>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select='following-sibling::set[count(Card) &gt; 1][1]' mode = 'count-stack-pair'/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template match='set' mode='count-stack-run'>
    <!--See if this stack has any points in it-->

    <!-- see if they all have the same value-int +1(check for runs) -->
    <xsl:variable name = 'same-count'>
      <xsl:for-each select='Card[position() > 1]'>
        <xsl:if test='number(@value-int) = number(preceding-sibling::Card[1]/@value-int + 1)'>
          <xsl:text>1</xsl:text>
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test='string-length($same-count) +1 = count(Card)'>
        <Run>
          <xsl:copy-of select='Card'/>
        </Run>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select='following-sibling::set[count(Card) &gt; 2][1]' mode = 'count-stack-run'/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name='count-one-cards'>
    <xsl:param name='card1'/>
    <xsl:param name='draw'/>

    <xsl:if test='$draw and $card1/@value-int = 11 and $card1/@suite = $draw/@suite'>
      <Knobs>
        <xsl:copy-of select='$card1'/>
      </Knobs>
    </xsl:if>

  </xsl:template>


  <xsl:template name='count-two-cards'>
    <xsl:param name='card1'/>
    <xsl:param name='card2'/>

    <xsl:if test='$card1/@point + $card2/@point = 15'>
      <Fifteen>
        <xsl:copy-of select='$card1'/>
        <xsl:copy-of select='$card2'/>
      </Fifteen>
    </xsl:if>
    <xsl:if test='$card1/@value-int = $card2/@value-int'>
      <Pair>
        <xsl:copy-of select='$card1'/>
        <xsl:copy-of select='$card2'/>
      </Pair>
    </xsl:if>

  </xsl:template>


  <xsl:template name='count-three-cards'>
    <xsl:param name='card1'/>
    <xsl:param name='card2'/>
    <xsl:param name='card3'/>
    <xsl:param name='count-run'/>

    <xsl:if test='$card1/@point + $card2/@point + $card3/@point = 15'>
      <Fifteen>
        <xsl:copy-of select='$card1'/>
        <xsl:copy-of select='$card2'/>
        <xsl:copy-of select='$card3'/>
      </Fifteen>
    </xsl:if>

    <xsl:if test='$count-run'>
      <!-- Check for run -->
      <xsl:if test='$card1/@value-int +1 = $card2/@value-int'>
        <xsl:if test='$card2/@value-int +1 = $card3/@value-int'>

          <Run>
            <xsl:copy-of select='$card1'/>
            <xsl:copy-of select='$card2'/>
            <xsl:copy-of select='$card3'/>
          </Run>
        </xsl:if>
      </xsl:if>
    </xsl:if>

  </xsl:template>


  <xsl:template name='count-four-cards'>
    <xsl:param name='card1'/>
    <xsl:param name='card2'/>
    <xsl:param name='card3'/>
    <xsl:param name='card4'/>
    <xsl:param name='count-run'/>
    <xsl:param name='count-flush'/>

    <xsl:if test='$card1/@point + $card2/@point + $card3/@point + $card4/@point  = 15'>
      <Fifteen>
        <xsl:copy-of select='$card1'/>
        <xsl:copy-of select='$card2'/>
        <xsl:copy-of select='$card3'/>
        <xsl:copy-of select='$card4'/>
      </Fifteen>
    </xsl:if>

    <xsl:if test='$count-run'>
      <!-- Check for run -->
      <xsl:if test='$card1/@value-int +1 = $card2/@value-int'>
        <xsl:if test='$card2/@value-int +1 = $card3/@value-int'>
          <xsl:if test='$card3/@value-int +1 = $card4/@value-int'>
            <Run>
              <xsl:copy-of select='$card1'/>
              <xsl:copy-of select='$card2'/>
              <xsl:copy-of select='$card3'/>
              <xsl:copy-of select='$card4'/>
            </Run>
          </xsl:if>
        </xsl:if>
      </xsl:if>
    </xsl:if>

    <!-- Check for flush -->
    <xsl:if test='$count-flush'>
      <xsl:if test='$card1/@suite = $card2/@suite'>
        <xsl:if test='$card2/@suite = $card3/@suite'>
          <xsl:if test='$card3/@suite = $card4/@suite'>
            <Flush>
              <xsl:copy-of select='$card1'/>
              <xsl:copy-of select='$card2'/>
              <xsl:copy-of select='$card3'/>
              <xsl:copy-of select='$card4'/>
            </Flush>
          </xsl:if>
        </xsl:if>
      </xsl:if>
    </xsl:if>


  </xsl:template>

  <xsl:template name='count-five-cards'>
    <xsl:param name='card1'/>
    <xsl:param name='card2'/>
    <xsl:param name='card3'/>
    <xsl:param name='card4'/>
    <xsl:param name='card5'/>

    <xsl:if test='$card1/@point + $card2/@point + $card3/@point + $card4/@point + $card5/@point = 15'>
      <Fifteen>
        <xsl:copy-of select='$card1'/>
        <xsl:copy-of select='$card2'/>
        <xsl:copy-of select='$card3'/>
        <xsl:copy-of select='$card4'/>
        <xsl:copy-of select='$card5'/>
      </Fifteen>
    </xsl:if>

    <!-- Check for run -->
    <xsl:if test='$card1/@value-int +1 = $card2/@value-int'>
      <xsl:if test='$card2/@value-int +1 = $card3/@value-int'>
        <xsl:if test='$card3/@value-int +1 = $card4/@value-int'>
          <xsl:if test='$card4/@value-int +1 = $card5/@value-int'>
            <Run>
              <xsl:copy-of select='$card1'/>
              <xsl:copy-of select='$card2'/>
              <xsl:copy-of select='$card3'/>
              <xsl:copy-of select='$card4'/>
              <xsl:copy-of select='$card5'/>
            </Run>
          </xsl:if>
        </xsl:if>
      </xsl:if>
    </xsl:if>

    <!-- Check for flush -->
    <xsl:if test='$card1/@suite = $card2/@suite'>
      <xsl:if test='$card2/@suite = $card3/@suite'>
        <xsl:if test='$card3/@suite = $card4/@suite'>
          <xsl:if test='$card4/@suite = $card5/@suite'>
            <Flush>
              <xsl:copy-of select='$card1'/>
              <xsl:copy-of select='$card2'/>
              <xsl:copy-of select='$card3'/>
              <xsl:copy-of select='$card4'/>
              <xsl:copy-of select='$card5'/>
            </Flush>
          </xsl:if>
        </xsl:if>
      </xsl:if>
    </xsl:if>

  </xsl:template>



  <!--These templates will apply point to people based on counting results -->
  <xsl:template match='Fifteen' mode ='award-points'>
    <xsl:param name='player'/>

    <xsl:variable name='message'>
      <xsl:for-each select='Card'>
        <xsl:value-of select='@short-name'/>
        <xsl:if test='position() != last()'>
          <xsl:text>, </xsl:text>
        </xsl:if>
      </xsl:for-each>
      <xsl:text> Fifteen for 2</xsl:text>
    </xsl:variable>

    <xsl:call-template name='award-points'>
      <xsl:with-param name='player' select='$player'/>
      <xsl:with-param name='amount' select='2'/>
      <xsl:with-param name='message' select='$message'/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match='ThirtyOne' mode ='award-points'>
    <xsl:param name='player'/>
    <xsl:call-template name='award-points'>
      <xsl:with-param name='player' select='$player'/>
      <xsl:with-param name='amount' select='2'/>
      <xsl:with-param name='message' select='"Thirty-One for 2"'/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match='Knobs' mode ='award-points'>
    <xsl:param name='player'/>
    <xsl:call-template name='award-points'>
      <xsl:with-param name='player' select='$player'/>
      <xsl:with-param name='amount' select='1'/>
      <xsl:with-param name='message' select='"Knobs for 1"'/>
    </xsl:call-template>
  </xsl:template>


  <xsl:template match='Pair|Run|Flush' mode ='award-points'>
    <xsl:param name='player'/>

    <xsl:variable name='points'>
      <xsl:choose>
        <xsl:when test='local-name() = "Pair"'>
          <xsl:choose>
            <xsl:when test='count(Card) = 4'>
              12
            </xsl:when>
            <xsl:when test='count(Card) = 3'>
              6
            </xsl:when>
            <xsl:otherwise>
              2
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select='count(Card)'/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name='message'>
      <xsl:for-each select='Card'>
        <xsl:value-of select='@short-name'/>
        <xsl:if test='position() != last()'>
          <xsl:text>, </xsl:text>
        </xsl:if>
      </xsl:for-each>
      <xsl:text>: </xsl:text><xsl:value-of select='local-name()'/><xsl:text> for </xsl:text><xsl:value-of select='number($points)'/>
    </xsl:variable>
    <xsl:call-template name='award-points'>
      <xsl:with-param name='player' select='$player'/>
      <xsl:with-param name='amount' select='number($points)'/>
      <xsl:with-param name='message' select='$message'/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match='PlayedCard' mode ='award-points'>
    <xsl:param name='player'/>
  </xsl:template>

  <xsl:template match='OriginalHand' mode ='award-points'>
    <xsl:param name='player'/>
  </xsl:template>

  <xsl:template match='NextCard' mode ='award-points'>
    <xsl:param name='player'/>
  </xsl:template>


  <!-- These templates will serialize a CribbageCount Element -->

  <xsl:template match='CribbageCount' mode ='serialize'>
    **Start Counting Results for index: <xsl:value-of select='position()'/>**
    <xsl:for-each select='@*'>
      <xsl:value-of select='local-name()'/><xsl:text> = </xsl:text><xsl:value-of select='string(.)'/>,
    </xsl:for-each>
    <xsl:apply-templates select='*|comment()' mode='serialize'/>
    **End Counting Results**
  </xsl:template>

  <xsl:template match='StackCountResults' mode ='serialize'>
    **Start Counting Results of play stack**
    <xsl:for-each select='@*'>
      <xsl:value-of select='local-name()'/><xsl:text> = </xsl:text><xsl:value-of select='string(.)'/>,
    </xsl:for-each>
    <xsl:apply-templates select='*|comment()' mode='serialize'/>
    **End Counting Results**
  </xsl:template>


  <xsl:template match='ThirtyOne' mode ='serialize'>
    Thirty One
  </xsl:template>

  <xsl:template match='Knobs' mode ='serialize'>
    Knobs
  </xsl:template>


  <xsl:template match='Fifteen|Pair|Run|Flush' mode ='serialize'>
    <xsl:variable name='points'>
      <xsl:choose>
        <xsl:when test='local-name() = "Pair"'>
          <xsl:choose>
            <xsl:when test='count(Card) = 4'>
              12
            </xsl:when>
            <xsl:when test='count(Card) = 3'>
              6
            </xsl:when>
            <xsl:otherwise>
              2
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test='local-name() = "Fifteen"'>
          2
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select='count(Card)'/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select='local-name()'/>
    <xsl:text>: </xsl:text>
    <xsl:for-each select='Card'>
      <xsl:value-of select='@short-name'/>
      <xsl:if test='position() != last()'>
        <xsl:text>, </xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:text> for </xsl:text><xsl:value-of select='number($points)'/>,
  </xsl:template>

  <xsl:template match='OriginalHand' mode ='serialize'>
    <xsl:text>Original Hand: </xsl:text>
    <xsl:for-each select='Card'>
      <xsl:value-of select='@short-name'/>,
    </xsl:for-each>,
  </xsl:template>

  <xsl:template match='Draw' mode ='serialize'>
    <xsl:text>Draw Card:</xsl:text>
    <xsl:apply-templates select='Card' mode='serialize'/>
  </xsl:template>

  <xsl:template match='PlayedCards' mode ='serialize'>
    <xsl:text>Played Cards: </xsl:text>
    <xsl:for-each select='Card'>
      <xsl:value-of select='@short-name'/>,
    </xsl:for-each>,
  </xsl:template>

  <xsl:template match='NextCard' mode ='serialize'>
    <xsl:text>Next Card:</xsl:text>
    <xsl:apply-templates select='Card' mode='serialize'/>
  </xsl:template>

  <xsl:template match='CribCount' mode ='serialize'>
    Crib Count:
    <xsl:apply-templates select='CribbageCount' mode='serialize'/>
  </xsl:template>

</xsl:stylesheet>
