def PreprocessFiles(tester, dirs, files):
    ordered = ['Core', 'Borrowed']
    position = 0
    for dir in ordered:
        if dir in dirs:
            dirs.remove(dir)
            dirs.insert(position, dir)
            position = position + 1

    ignored = ['test_harness']
    for file in ignored:
        if file in files:
            files.remove(file)

    return (dirs, files)

from Ft.Lib.TestSuite import TestWalker
class _CyclopsMode(TestWalker.TestMode):
    def __init__(self):
        TestWalker.TestMode.__init__(self,'Cyclops',0)

    def _init(self, tester):
        return 1

    def _pre(self, tester):
        tester.test_data['source'] = 'default'
        tester.test_data['stylesheet'] = 'default'
        tester.test_data['cyclops'] = 1

    def _post(self, tester):
        del tester.test_data['cyclops']

def _combined_init(self, tester):
    return 1

def _combined_badinit(self, tester):
    tester.warning("%s not supported in test harness" % self.name)
    return 0

def _combined_pre(self, tester):
    tester.test_data['source'] = self.source
    tester.test_data['stylesheet'] = self.stylesheet

def _combined__init__(self):
    TestWalker.TestMode.__init__(self,"%s-%s" % (self.source,self.stylesheet),self.default)

def _combined(source, stylesheet):
    import new
    dict = {'source' : source,
            'stylesheet' : stylesheet,
            }
    if source == 'default' and stylesheet == 'default':
        dict['default'] = 1
    else:
        dict['default'] = 0

    classobj = new.classobj('_%s_%s_Mode' % (source, stylesheet), (TestWalker.TestMode,), dict)
    dict['__init__'] = new.instancemethod(_combined__init__, None, classobj)
    if source == 'minidom' or stylesheet == 'minidom':
        dict['_init'] = new.instancemethod(_combined_badinit, None, classobj)
    else:
        dict['_init'] = new.instancemethod(_combined_init, None, classobj)
    dict['_pre'] = new.instancemethod(_combined_pre, None, classobj)
    return classobj



# minidom does not support comments and namespaces 
# We cannot use it for either source or stylesheet
# only used in XPath/XPattern expressions

_doms = ['default', 'pDomlette', 'cDomlette', '4DOM', 'minidom']

MODES = []
for source in _doms:
    for stylesheet in _doms:
        klass = _combined(source,stylesheet)
        MODES.append(klass())
MODES.append(_CyclopsMode())

