#Uche Ogbuji tries out some wickedness with namespace 

from Xslt import test_harness

sheet_1 = """\
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exslt="http://exslt.org/common"
  xmlns:ora="http://www.oracle.com/XSL/Transform/java/"
  xmlns:u="http://uche.ogbuji.net/tmp/20010717"
  >

  <xsl:variable name="this" select="document('')"/>
  <xsl:variable name="exslt-ns" select="'http://exslt.org/common'"/>
  <xsl:variable name="ora-ns" select="'http://www.oracle.com/XSL/Transform/java/'"/>

  <xsl:param name="from" select="$exslt-ns"/>
  <xsl:param name="to">
    <xsl:choose>
      <xsl:when test="$from=$exslt-ns"><xsl:value-of select="$ora-ns"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$exslt-ns"/></xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:template match="/">
    <xsl:apply-templates mode="convert"/>
  </xsl:template> 

  <xsl:template match="@*|node()" mode="convert">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" mode="convert"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="/*" mode="convert" priority="10">
    <xsl:copy>
      <xsl:attribute name="exslt:dummy" namespace="{$to}"/>
      <xsl:apply-templates select="@*|node()" mode="convert"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
"""

source_1 = """\
<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template name='sestina'>

    <script language="JavaScript">

      <!--
        Hang it all Robert Browning... '<' &#34; '&lt;'.
      -->
      <xsl:text>&lt;!--</xsl:text>

      <xsl:text><![CDATA[There can be but the one Sordello
  //if (Montovana() == "si fo") {
]]></xsl:text>

      <xsl:text>//--&gt;</xsl:text>

    </script>
  </xsl:template>

  <xsl:template match='*' mode="roundel">
    <xsl:text>&lt;</xsl:text><xsl:value-of select='local-name()'/><xsl:apply-templates select='@*' mode='roundel'/><xsl:text>&gt;</xsl:text><xsl:apply-templates select='node()' mode='roundel'/><xsl:text>&lt;/</xsl:text><xsl:value-of select='local-name()'/><xsl:text>&gt;</xsl:text>
  </xsl:template>

  <xsl:template match='text()' mode="roundel">
    <xsl:call-template name='replace'>
      <xsl:with-param name='from' select='"&#174;"'/>
      <xsl:with-param name='to' select='"&amp;reg;"'/>
      <xsl:with-param name = 'value'>
        <xsl:call-template name='replace'>
          <xsl:with-param name = 'value' select='translate(.,"&#10;&#13;","  ")'/>
          <xsl:with-param name='from' select='"&#160;"'/>
          <xsl:with-param name='to' select='"&amp;nbsp;"'/>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match='@*' mode="roundel">
    <xsl:if test='not(starts-with(local-name(),"xmlns"))'>
      <xsl:text> </xsl:text><xsl:value-of select='local-name()'/><xsl:text>=\"</xsl:text><xsl:value-of select='.'/><xsl:text>\"</xsl:text>      
    </xsl:if>
  </xsl:template>

  <xsl:template name="replace">
    <xsl:param name="value" />
    <xsl:param name="from" />
    <xsl:param name="to" />
    <xsl:choose>
       <xsl:when test="contains($value,$from)">
          <xsl:value-of select="substring-before($value,$from)" />
          <xsl:value-of select="$to" />
          <xsl:call-template name="replace">
             <xsl:with-param name="value" 
                             select="substring-after($value,$from)" />
             <xsl:with-param name="from" select="$from" />
             <xsl:with-param name="to" select="$to" />
          </xsl:call-template>
       </xsl:when>
       <xsl:otherwise>
          <xsl:value-of select="$value" />
       </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>
"""

expected_1 = """\
"""


sheet_2 = """\
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exslt="http://exslt.org/common"
  xmlns:ora="http://www.oracle.com/XSL/Transform/java/"
  xmlns:u="http://uche.ogbuji.net/tmp/20010717"
  >

  <!-- Just for documentation of which files need it right now -->
  <u:files>
    <u:file>heroic</u:file>
    <u:file>couplets</u:file>
  </u:files>

  <xsl:variable name="this" select="document('')"/>
  <xsl:variable name="exslt-ns" select="$this/*/namespace::exslt"/>
  <xsl:variable name="ora-ns" select="$this/*/namespace::ora"/>

  <xsl:variable name="files" select="$this/*/u:files/u:file"/>

  <xsl:param name="file"/>
  <xsl:param name="from" select="$exslt-ns"/>
  <xsl:param name="to">
    <xsl:choose>
      <xsl:when test="$from=$exslt-ns"><xsl:value-of select="$ora-ns"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$exslt-ns"/></xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:template match="/">
    <xsl:apply-templates mode="convert"/>
    <!--
    <xsl:for-each select="$files">
      <xsl:message>
        Processing: <xsl:value-of select="."/>
      </xsl:message>
      <xsl:apply-templates select="document(.)" mode="convert"/>
    </xsl:for-each>
    -->
  </xsl:template> 

  <xsl:template match="@*|node()" mode="convert">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" mode="convert"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="/*" mode="convert" priority="10">
    <xsl:copy>
      <xsl:attribute name="exslt:dummy" namespace="{$to}"/>
      <xsl:apply-templates select="@*|node()" mode="convert"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
"""

source_2 = """\
"""

expected_2 = """\
"""


sheet_3 = """\
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exslt="http://exslt.org/common"
  xmlns:ora="http://www.oracle.com/XSL/Transform/java/"
  xmlns:u="http://uche.ogbuji.net/tmp/20010717"
  >

  <!-- Just for documentation of which files need it right now -->
  <u:files>
    <u:file>claimstatus/javascript.xsl</u:file>
    <u:file>claimstatus/defaults.xsl</u:file>
    <u:file>claimstatus/main.xsl</u:file>
    <u:file>claimstatus/summary-defaults.xsl</u:file>
    <u:file>claimstatus/cigna/cigna-x12-277.xsl</u:file>
    <u:file>eligibility/group-content/oxford-x12-271-copay.xsl</u:file>
    <u:file>eligibility/group-content/oxford-x12-271-coverage.xsl</u:file>
    <u:file>eligibility/group-content/oxford-x12-271-medical.xsl</u:file>
    <u:file>eligibility/group-content/x12-271-copay.xsl</u:file>
    <u:file>eligibility/group-content/x12-271-coverage.xsl</u:file>
    <u:file>eligibility/group-content/x12-271-medical.xsl</u:file>
    <u:file>eligibility/group-content/x12-271-provider.xsl</u:file>
    <u:file>eligibility/group-content/cigna-x12-271-copay.xsl</u:file>
    <u:file>eligibility/group-content/cigna-x12-271-coverage.xsl</u:file>
    <u:file>eligibility/group-content/cigna-x12-271-medical.xsl</u:file>
    <u:file>eligibility/group-content/cigna-x12-271-provider.xsl</u:file>
    <u:file>include/collapse-names.xsl</u:file>
    <u:file>include/global-common.xsl</u:file>
    <u:file>include/javascript-claimstatus.xsl</u:file>
    <u:file>include/javascript-eligibility.xsl</u:file>
    <!--
    <u:file></u:file>
    -->
  </u:files>

  <xsl:variable name="this" select="document('')"/>
  <!--
  <xsl:variable name="exslt-ns" select="$this/*/namespace::exslt"/>
  <xsl:variable name="ora-ns" select="$this/*/namespace::ora"/>
  -->
  <xsl:variable name="exslt-ns" select="'http://exslt.org/common'"/>
  <xsl:variable name="ora-ns" select="'http://www.oracle.com/XSL/Transform/java/'"/>
  <!--
  <xsl:variable name="files" select="$this/*/u:files/u:file"/>
  <xsl:param name="base-uri"/>
  -->

  <xsl:param name="file"/>
  <xsl:param name="from" select="$exslt-ns"/>
  <xsl:param name="to">
    <xsl:choose>
      <xsl:when test="$from=$exslt-ns"><xsl:value-of select="$ora-ns"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$exslt-ns"/></xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:template match="/">
    <!--
    <xsl:message>
      Conversion from <xsl:value-of select="$from"/> to <xsl:value-of select="$to"/>
    </xsl:message>
    <xsl:apply-templates select="document($file)" mode="convert"/>
    -->
    <xsl:apply-templates mode="convert"/>
    <!--
    <xsl:for-each select="$files">
      <xsl:message>
        Processing: <xsl:value-of select="."/>
      </xsl:message>
      <xsl:apply-templates select="document(.)" mode="convert"/>
    </xsl:for-each>
    -->
  </xsl:template> 

  <xsl:template match="@*|node()" mode="convert">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" mode="convert"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="/*" mode="convert" priority="10">
    <xsl:copy>
      <xsl:attribute name="exslt:dummy" namespace="{$to}"/>
      <xsl:apply-templates select="@*|node()" mode="convert"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
"""

source_3 = """\
"""

expected_3 = """\
"""


def Test(tester):
    tester.warning('No expected results for comparision')
    return
    tester.startGroup("")
    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("xsl:text in xml mode")
    source = test_harness.FileInfo(string=source_2)
    sty = test_harness.FileInfo(string=sheet_2)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_2,
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("problems with pre")
    source = test_harness.FileInfo(string=source_3)
    sty = test_harness.FileInfo(string=sheet_3)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_3,
                                    )
    xtest.test(tester)
    tester.groupDone()

    return

