import os

#
#Note: While testing it might be useful to use
#
#export TRACEOUT=4ODS:4Suite.PgDatabase
#export TRACEOUT_FLAGS=LABEL
#
#Requires the database to be set up with the schema from varsity1.odl or varsity2.odl
#
#Typical test process:
#
#python ../Tools/4odb_destroy.py test
#python ../Tools/4odb_create.py test
#python test_constants.py
#

import os,sys, test_util
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import Database

odl_string = '''
const string TOP_LEVEL = "A String";
module Test {
  const boolean MODULE_LEVEL = true;
  class Student
  {
    attribute string name;
    const short CLASS_LEVEL = 15;
    const float CLASS_LEVEL_FLOAT = 3.14;
    const boolean CLASS_LEVEL_REFERENCE = Test::MODULE_LEVEL;
    const string CLASS_LEVEL_GLOBAL_REFERENCE = ::TOP_LEVEL;
  };
};

'''

DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')
        if os.path.exists('ODSGlobalDef.py'):
            os.unlink('ODSGlobalDef.py')
        if os.path.exists('ODSGlobalDef.pyc'):
            os.unlink('ODSGlobalDef.pyc')
        pass

def _Test(tester):

    tester.startGroup("Constants %s Driver" % tester.ods_driver_name)

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        import Test
        from Test import Student
        import ODSGlobalDef
        reload(Test)
        reload(Student)
        reload(ODSGlobalDef)
    except:
        tester.error('Error in syntax', 1)


    tester.testDone()

    
    db = Database.Database()
    db.open(DBNAME)

    tx = db.new()
    tx.begin()
    tester.startTest("Test Constant Values")
    tester.testResults("A String",ODSGlobalDef.TOP_LEVEL,done=0,msg="Invalid Top Level Constant")
    tester.testResults(1,Test.MODULE_LEVEL,done=0,msg="Invalid Module Level Constant")
    tester.testResults(15,Student.CLASS_LEVEL,done=0,msg="Invalid Class Level Constant")
    tester.testResults(3.14,Student.CLASS_LEVEL_FLOAT,done=0,msg="Invalid Class Level Float Constant")
    tester.testResults(Test.MODULE_LEVEL,Student.CLASS_LEVEL_REFERENCE,done=0,msg="Invalid Class Level Reference Constant")
    tester.testResults(ODSGlobalDef.TOP_LEVEL,Student.CLASS_LEVEL_GLOBAL_REFERENCE,done=0,msg="Invalid Class Level Global Reference Constant")

    tx.abort()
    db.close()
    tester.testDone()
    tester.groupDone()
    return

if __name__ == '__main__':


    from Ft.Lib import TestSuite
    tester = TestSuite.TestSuite(1, 1)
    from Ft.Ods.StorageManager import Adapters
    tester.ods_driver_name = Adapters.g_driverName

    retVal = Test(tester)
    sys.exit(retVal)

