// formantfilter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// FormantFilter implements a time-varying All-Pass filter which gets its
// coefficients from an LPCData member stored in the LPC_Filter base class.
// This class is used for mapping LPC-related formants onto arbitrary sounds.

#ifndef FORMANTFILTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define FORMANTFILTER_H

#include "lpcfilter.h"
#include "iofunction.h"

class Controller;
class Requester;
class LPCData;

class FormantFilter : private LPC_Filter, public SimpleInputOutputFunction {
	enum QSize { lpcQueueSize = 1024 };
	friend class FormantRequester;
public:
	FormantFilter(Data* input, Data* output, Data* lpcdata, double amp);
	FormantFilter(Data* input, Data* output, Data* lpcdata);
	static Modifier* create(class DataEditor *);
	redefined Status configure(Controller *c);
	redefined void restoreState();
	redefined const char* message() { return "Formant Filtering..."; }
protected:
	redefined Requester* createRequester();
	redefined void initialize();
	redefined void saveConfig();
	redefined int doProcessing();
	redefined int doSimpleProcess(double *, int);
private:
	double gain;
	double warpFactor;
	ChoiceValue interpMode;
private:
	static double _savedGain;
	static double _savedWarpFactor;
	static ChoiceValue _savedInterpMode;
};

#endif

