// dialog_ctor.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// The DialogConstructor class is primarily a grouping of a set of routines
// for converting a Request for communication with the user (be it an alert or
// a querying for parameters) into a DialogBox subclass instance, which will
// be displayed on the screen.

#ifndef DIALOG_CTOR_H
#ifdef __GNUG__
#pragma interface
#endif
#define DIALOG_CTOR_H

class Interactor;
class Scene;
class ButtonState;
class Controller;
class DialogBox;
class InputDialog;
class Request;
struct QueryList;
struct ValueList;
struct ChoiceList;
class QueryFile;
struct ButtonList;

class DialogConstructor {
public:
	static DialogConstructor* getInstance();
	static void destroyInstance();
public:
	DialogBox *createDialog(Interactor*, Request &);
protected:
	DialogConstructor() {}
	Scene* messageBox(QueryList *);
	Scene* fileSelector(QueryFile*, ButtonState *);
	Scene* textInputBox(InputDialog *, ValueList *, ButtonState *);
	Scene* choiceButtonBox(ChoiceList *, ButtonState *);
	Scene* buttonBox(ButtonList *, ButtonState *);
private:
	static DialogConstructor* ctorInstance;
};

#endif

	
