/*
 * Copyright (C) 2014-2016 Stichting Mapcode Foundation (http://www.mapcode.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __INTERNAL_DATA_H__
#define __INTERNAL_DATA_H__

#ifdef __cplusplus
extern "C" {
#endif

// *** GENERATED FILE (coords.cpp), DO NOT CHANGE OR PRETTIFY ***

#define MAPCODE_DATA_VERSION "2.3.0" // coords 2.0.2

static const char *ISO3166_ALPHA[_TERRITORY_MAX - _TERRITORY_MIN - 1] = {
        "VAT", "MCO", "GIB", "TKL", "CCK", "BLM", "NRU", "TUV", "MAC", "SXM",
        "MAF", "NFK", "PCN", "BVT", "BMU", "IOT", "SMR", "GGY", "AIA", "MSR",
        "JEY", "CXR", "WLF", "VGB", "LIE", "ABW", "MHL", "ASM", "COK", "SPM",
        "NIU", "KNA", "CYM", "BES", "MDV", "SHN", "MLT", "GRD", "VIR", "MYT",
        "SJM", "VCT", "HMD", "BRB", "ATG", "CUW", "SYC", "PLW", "MNP", "AND",
        "GUM", "IMN", "LCA", "FSM", "SGP", "TON", "DMA", "BHR", "KIR", "TCA",
        "STP", "HKG", "MTQ", "FRO", "GLP", "COM", "MUS", "REU", "LUX", "WSM",
        "SGS", "PYF", "CPV", "TTO", "BRN", "ATF", "PRI", "CYP", "LBN", "JAM",
        "GMB", "QAT", "FLK", "VUT", "MNE", "BHS", "TLS", "SWZ", "KWT", "FJI",
        "NCL", "SVN", "ISR", "PSE", "SLV", "BLZ", "DJI", "MKD", "RWA", "HTI",
        "BDI", "GNQ", "ALB", "SLB", "ARM", "LSO", "BEL", "MDA", "GNB", "TWN",
        "BTN", "CHE", "NLD", "DNK", "EST", "DOM", "SVK", "CRI", "BIH", "HRV",
        "TGO", "LVA", "LTU", "LKA", "GEO", "IRL", "SLE", "PAN", "CZE", "GUF",
        "ARE", "AUT", "AZE", "SRB", "JOR", "PRT", "HUN", "KOR", "ISL", "GTM",
        "CUB", "BGR", "LBR", "HND", "BEN", "ERI", "MWI", "PRK", "NIC", "GRC",
        "TJK", "BGD", "NPL", "TUN", "SUR", "URY", "KHM", "SYR", "SEN", "KGZ",
        "BLR", "GUY", "LAO", "ROU", "GHA", "UGA", "GBR", "GIN", "ECU", "ESH",
        "GAB", "NZL", "BFA", "PHL", "ITA", "OMN", "POL", "CIV", "NOR", "MYS",
        "VNM", "FIN", "COG", "DEU", "JPN", "ZWE", "PRY", "IRQ", "MAR", "UZB",
        "SWE", "PNG", "CMR", "TKM", "ESP", "THA", "YEM", "FRA", "ALA", "KEN",
        "BWA", "MDG", "UKR", "SSD", "CAF", "SOM", "AFG", "MMR", "ZMB", "CHL",
        "TUR", "PAK", "MOZ", "NAM", "VEN", "NGA", "TZA", "EGY", "MRT", "BOL",
        "ETH", "COL", "ZAF", "MLI", "AGO", "NER", "TCD", "PER", "MNG", "IRN",
        "LBY", "SDN", "IDN", "MX-DIF", "MX-TLA",
        "MX-MOR", "MX-AGU", "MX-CL", "MX-QUE", "MX-HID",
        "MX-MX", "MX-TAB", "MX-NAY", "MX-GUA", "MX-PUE",
        "MX-YUC", "MX-ROO", "MX-SIN", "MX-CAM", "MX-MIC",
        "MX-SLP", "MX-GRO", "MX-NLE", "MX-BCN", "MX-VER",
        "MX-CHP", "MX-BCS", "MX-ZAC", "MX-JAL", "MX-TAM",
        "MX-OAX", "MX-DUR", "MX-COA", "MX-SON", "MX-CHH",
        "GRL", "SAU", "COD", "DZA", "KAZ",
        "ARG", "IN-DD", "IN-DN", "IN-CH", "IN-AN",
        "IN-LD", "IN-DL", "IN-ML", "IN-NL", "IN-MN",
        "IN-TR", "IN-MZ", "IN-SK", "IN-PB", "IN-HR",
        "IN-AR", "IN-AS", "IN-BR", "IN-UT", "IN-GA",
        "IN-KL", "IN-TN", "IN-HP", "IN-JK", "IN-CT",
        "IN-JH", "IN-KA", "IN-RJ", "IN-OR", "IN-GJ",
        "IN-WB", "IN-MP", "IN-TG", "IN-AP", "IN-MH",
        "IN-UP", "IN-PY", "AU-NSW", "AU-ACT", "AU-JBT",
        "AU-NT", "AU-SA", "AU-TAS", "AU-VIC", "AU-WA",
        "AU-QLD", "BR-DF", "BR-SE", "BR-AL", "BR-RJ",
        "BR-ES", "BR-RN", "BR-PB", "BR-SC", "BR-PE",
        "BR-AP", "BR-CE", "BR-AC", "BR-PR", "BR-RR",
        "BR-RO", "BR-SP", "BR-PI", "BR-TO", "BR-RS",
        "BR-MA", "BR-GO", "BR-MS", "BR-BA", "BR-MG",
        "BR-MT", "BR-PA", "BR-AM", "US-DC", "US-RI",
        "US-DE", "US-CT", "US-NJ", "US-NH", "US-VT",
        "US-MA", "US-HI", "US-MD", "US-WV", "US-SC",
        "US-ME", "US-IN", "US-KY", "US-TN", "US-VA",
        "US-OH", "US-PA", "US-MS", "US-LA", "US-AL",
        "US-AR", "US-NC", "US-NY", "US-IA", "US-IL",
        "US-GA", "US-WI", "US-FL", "US-MO", "US-OK",
        "US-ND", "US-WA", "US-SD", "US-NE", "US-KS",
        "US-ID", "US-UT", "US-MN", "US-MI", "US-WY",
        "US-OR", "US-CO", "US-NV", "US-AZ", "US-NM",
        "US-MT", "US-CA", "US-TX", "US-AK", "CA-BC",
        "CA-AB", "CA-ON", "CA-QC", "CA-SK", "CA-MB",
        "CA-NL", "CA-NB", "CA-NS", "CA-PE", "CA-YT",
        "CA-NT", "CA-NU", "IND", "AUS", "BRA",
        "USA", "MEX", "RU-MOW", "RU-SPE", "RU-KGD",
        "RU-IN", "RU-AD", "RU-SE", "RU-KB", "RU-KC",
        "RU-CE", "RU-CU", "RU-IVA", "RU-LIP", "RU-ORL",
        "RU-TUL", "RU-BE", "RU-VLA", "RU-KRS", "RU-KLU",
        "RU-TT", "RU-BRY", "RU-YAR", "RU-RYA", "RU-AST",
        "RU-MOS", "RU-SMO", "RU-DA", "RU-VOR", "RU-NGR",
        "RU-PSK", "RU-KOS", "RU-STA", "RU-KDA", "RU-KL",
        "RU-TVE", "RU-LEN", "RU-ROS", "RU-VGG", "RU-VLG",
        "RU-MUR", "RU-KR", "RU-NEN", "RU-KO", "RU-ARK",
        "RU-MO", "RU-NIZ", "RU-PNZ", "RU-KI", "RU-ME",
        "RU-ORE", "RU-ULY", "RU-PM", "RU-BA", "RU-UD",
        "RU-TA", "RU-SAM", "RU-SAR", "RU-YAN", "RU-KM",
        "RU-SVE", "RU-TYU", "RU-KGN", "RU-CH", "RU-BU",
        "RU-ZAB", "RU-IRK", "RU-NVS", "RU-TOM", "RU-OMS",
        "RU-KK", "RU-KEM", "RU-AL", "RU-ALT", "RU-TY",
        "RU-KYA", "RU-MAG", "RU-CHU", "RU-KAM", "RU-SAK",
        "RU-PO", "RU-YEV", "RU-KHA", "RU-AMU", "RU-SA",
        "CAN", "RUS", "CN-SH", "CN-TJ", "CN-BJ",
        "CN-HI", "CN-NX", "CN-CQ", "CN-ZJ", "CN-JS",
        "CN-FJ", "CN-AH", "CN-LN", "CN-SD", "CN-SX",
        "CN-JX", "CN-HA", "CN-GZ", "CN-GD", "CN-HB",
        "CN-JL", "CN-HE", "CN-SN", "CN-NM", "CN-HL",
        "CN-HN", "CN-GX", "CN-SC", "CN-YN", "CN-XZ",
        "CN-GS", "CN-QH", "CN-XJ", "CHN", "UMI",
        "CPT", "ATA", "AAA"
};


// index of first rectangle record for x-th territory
static const int DATA_START[_TERRITORY_MAX - _TERRITORY_MIN] = {
        0, 3, 6, 10, 14, 17, 19, 20, 31, 32,
        34, 36, 38, 43, 45, 48, 52, 59, 63, 65,
        67, 71, 73, 81, 87, 95, 97, 132, 139, 149,
        151, 153, 156, 161, 173, 181, 188, 190, 192, 197,
        200, 207, 212, 214, 216, 220, 222, 229, 235, 239,
        243, 246, 250, 252, 281, 283, 290, 292, 297, 317,
        325, 329, 333, 335, 340, 348, 353, 364, 368, 373,
        377, 386, 400, 404, 409, 413, 429, 435, 440, 448,
        456, 472, 476, 480, 487, 498, 535, 539, 565, 571,
        589, 601, 637, 703, 738, 777, 789, 798, 826, 842,
        876, 892, 926, 962, 991, 1015, 1026, 1081, 1139, 1153,
        1215, 1239, 1268, 1336, 1414, 1467, 1546, 1631, 1683, 1758,
        1835, 1896, 1938, 1963, 2011, 2054, 2099, 2160, 2246, 2333,
        2384, 2447, 2532, 2623, 2708, 2767, 2882, 2985, 3078, 3162,
        3260, 3322, 3426, 3492, 3587, 3683, 3769, 3857, 3947, 4054,
        4200, 4302, 4406, 4437, 4474, 4551, 4587, 4621, 4657, 4709,
        4773, 4824, 4839, 4874, 5021, 5107, 5157, 5233, 5258, 5326,
        5383, 5418, 5500, 5551, 5624, 5717, 5752, 5830, 5889, 5955,
        6012, 6065, 6122, 6159, 6250, 6382, 6432, 6462, 6514, 6610,
        6643, 6724, 6772, 6852, 6895, 6989, 7023, 7068, 7175, 7179,
        7251, 7295, 7381, 7421, 7448, 7505, 7591, 7665, 7704, 7791,
        7867, 7975, 8053, 8127, 8197, 8254, 8336, 8418, 8477, 8504,
        8542, 8596, 8672, 8785, 8865, 8929, 8986, 9040, 9120, 9191,
        9277, 9327, 9391, 9535, 9539, 9544, 9549, 9554, 9560, 9565,
        9573, 9581, 9592, 9600, 9615, 9624, 9635, 9668, 9677, 9685,
        9700, 9710, 9720, 9728, 9736, 9752, 9760, 9770, 9781, 9791,
        9801, 9810, 9819, 9830, 9871, 9912, 9930, 10027, 10179, 10270,
        10352, 10547, 10550, 10553, 10556, 10566, 10571, 10574, 10586, 10599,
        10610, 10626, 10635, 10641, 10675, 10703, 10722, 10792, 10885, 10900,
        10904, 10940, 11027, 11038, 11056, 11073, 11137, 11169, 11210, 11230,
        11335, 11415, 11479, 11533, 11592, 11648, 11708, 11715, 11757, 11761,
        11764, 11774, 11789, 11800, 11838, 11901, 11947, 11952, 11959, 11964,
        11983, 11993, 12000, 12008, 12022, 12038, 12045, 12053, 12062, 12110,
        12119, 12130, 12180, 12191, 12201, 12220, 12236, 12249, 12261, 12280,
        12314, 12323, 12335, 12347, 12351, 12357, 12363, 12375, 12386, 12395,
        12401, 12415, 12435, 12446, 12488, 12539, 12589, 12645, 12658, 12671,
        12734, 12794, 12855, 12920, 12991, 13056, 13125, 13200, 13268, 13347,
        13424, 13438, 13453, 13498, 13511, 13539, 13553, 13566, 13582, 13598,
        13610, 13652, 13664, 13675, 13710, 13725, 13737, 13754, 13762, 13800,
        13813, 13828, 13948, 13996, 14040, 14080, 14104, 14145, 14184, 14204,
        14220, 14238, 14250, 14264, 14272, 14283, 14300, 14313, 14369, 14370,
        14371, 14372, 14413, 14419, 14424, 14429, 14434, 14440, 14447, 14453,
        14462, 14468, 14476, 14482, 14489, 14498, 14506, 14515, 14527, 14536,
        14544, 14555, 14566, 14575, 14585, 14592, 14642, 14676, 14685, 14697,
        14708, 14747, 14758, 14772, 14789, 14801, 14814, 14828, 14843, 14856,
        14877, 14885, 14904, 14913, 14925, 14936, 14950, 14965, 14978, 14992,
        15005, 15019, 15034, 15052, 15072, 15084, 15104, 15117, 15132, 15146,
        15164, 15180, 15194, 15207, 15224, 15244, 15261, 15279, 15294, 15308,
        15324, 15335, 15351, 15364, 15379, 15394, 15440, 15454, 15463, 15473,
        15486, 15500, 15511, 15524, 15540, 15555, 15556, 15583, 15589, 15597,
        15603, 15619, 15656, 15673, 15697, 15720, 15737, 15757, 15783, 15809,
        15828, 15845, 15898, 15939, 15961, 15988, 16008, 16029, 16047, 16078,
        16104, 16124, 16145, 16163, 16181, 16200, 16216, 16232, 16287, 16313,
        16320, 16322, 16324, 16356
};

#define MAPCODE_BOUNDARY_MAX 16356

typedef struct {
    int minx;
    int miny;
    int maxx;
    int maxy;
    int flags;
} TerritoryBoundary;

#ifndef MAKE_SOURCE_DIGITAL
static const TerritoryBoundary TERRITORY_BOUNDARIES[MAPCODE_BOUNDARY_MAX + 1] = {
        {12433114,   41851944,  12548434,   41938434,  0x001000b}, // VAT
        {5850000,    35450000,  18560000,   55080000,  0x50a0216},
        {12444000,   41899000,  12460000,   41908000,  0x003021c},
        {7404110,    43723932,  7444472,    43752762,  0x001000b}, // MCO
        {-5200000,   41310000,  9600000,    53557000,  0x0010216},
        {7404110,    43723932,  7444472,    43752762,  0x003021c},
        {-5384925,   36107682,  -5321499,   36159576,  0x001000b}, // GIB
        {-5734540,   35987080,  -5161660,   36478120,  0x001888c},
        {-6703000,   35867000,  -3426000,   38475972,  0x0a63291},
        {-5384925,   36107682,  -5321499,   36159576,  0x003021c},
        {-172537866, -8601181,  -172450415, -8514691,  0x001000a}, // TKL
        {-171996267, -9340159,  -171646464, -8994200,  0xf04004b},
        {-171498626, -9550077,  -171160016, -9215188,  0xe89004b},
        {-172560193, -9660193,  -171160016, -8289807,  0x0a70011},
        {96815429,   -12208160, 96866396,   -12133320, 0x2a7044a}, // CCK
        {96888084,   -12195000, 96931231,   -12106697, 0x2a7044a},
        {96629848,   -12244608, 97088152,   -11775392, 0x001000c},
        {-62877167,  17860755,  -62786833,  17947245,  0x001000b}, // BLM
        {-62951784,  17783968,  -62707008,  18029488,  0x001000c},
        {166898560,  -564440,   166976401,  -486599,   0x001000b}, // NRU
        {179163000,  -8543596,  179227000,  -8430000,  0x029000a}, // TUV
        {179009264,  -8661830,  179243000,  -8416310,  0x004010b},
        {179794020,  -9443960,  179883000,  -9329384,  0x004010b},
        {178286164,  -8086652,  178463000,  -7901148,  0x004010b},
        {178634028,  -7530304,  178727000,  -7432096,  0x004010b},
        {177115628,  -7270404,  177209000,  -7172196,  0x004010b},
        {176273728,  -6336404,  176367000,  -6238196,  0x004010b},
        {177270120,  -6165560,  177379000,  -6050984,  0x004010b},
        {176037912,  -5719816,  176157000,  -5594000,  0x004010b},
        {179424320,  -10788660, 179533000,  -10674084, 0x004010b},
        {176030000,  -10996000, 179940000,  -5594000,  0x0010016},
        {113528000,  22109440,  113600000,  22217700,  0x027000b}, // MAC
        {-63110167,  18003755,  -63019833,  18090245,  0x001000a}, // SXM
        {-63158744,  17963792,  -62966048,  18143000,  0x001000c},
        {-63110167,  18003755,  -63019833,  18090245,  0x001000a}, // MAF
        {-63158744,  17963792,  -62966048,  18143000,  0x001000c},
        {167902989,  -29077245, 168001011,  -28990755, 0x001000a}, // NFK
        {167809760,  -29202312, 168127448,  -28907688, 0x001000c},
        {-130134215, -25095292, -130079370, -25045433, 0x22a004a}, // PCN
        {-130771365, -23953826, -130716936, -23903967, 0x22a004a},
        {-124812713, -24704785, -124757868, -24654926, 0x22a004a},
        {-128526171, -24571661, -128119947, -24178829, 0x001000c},
        {-130800000, -25100000, -124700000, -23890000, 0x04e0011},
        {3280000,    -54460000, 3436320,    -54385000, 0x01c000b}, // BVT
        {3176640,    -54572312, 3650568,    -54277688, 0x001000c},
        {-64817896,  32283000,  -64708081,  32323000,  0x2a7044a}, // BMU
        {-64887829,  32246750,  -64766566,  32283000,  0x2a7044a},
        {-65034230,  32140084,  -64596758,  32532916,  0x001000c},
        {72348074,   -7341184,  72434564,   -7254694,  0x001000a}, // IOT
        {72307352,   -7475728,  72588584,   -7181104,  0x001000c},
        {71712684,   -5499289,  71993916,   -5204665,  0x0b00010},
        {70504498,   -7827595,  73185688,   -5146405,  0x0a80011},
        {12402340,   43893500,  12465083,   43975400,  0x2a7044a}, // SMR
        {12465083,   43895000,  12517906,   43992200,  0x2a7044a},
        {12486204,   43652480,  13131996,   44143520,  0x0014088},
        {8822749,    43227805,  12487042,   45908995,  0x0010015},
        {9750000,    42200000,  13400000,   44780000,  0x01e188d},
        {5850000,    35450000,  18560000,   55080000,  0x50a0216},
        {12402340,   43893500,  12517000,   43992200,  0x003021c},
        {-2619780,   49416000,  -2500000,   49510519,  0x022000a}, // GGY
        {-2704183,   49374669,  -2058391,   49816605,  0x001000c},
        {-10700000,  49122422,  1889648,    60875000,  0x0010216},
        {-2704183,   49374669,  -2058391,   49816605,  0x003021c},
        {-63109000,  18167000,  -62998270,  18236000,  0x019000a}, // AIA
        {-63432000,  18147000,  -62910000,  18600000,  0x01c000c},
        {-62241268,  16693000,  -62178000,  16812970,  0x02b000a}, // MSR
        {-62330844,  16591156,  -62039196,  16885780,  0x001000c},
        {-2246000,   49162000,  -2016000,   49206000,  0x010000b}, // JEY
        {-2275397,   49122422,  -1994165,   49318838,  0x001000c},
        {-10700000,  49122422,  1889648,    60875000,  0x0010216},
        {-2275397,   49122080,  -1994165,   49318496,  0x003021c},
        {105631382,  -10495516, 105718833,  -10409026, 0x001000a}, // CXR
        {105490182,  -10633774, 105771414,  -10339150, 0x001000c},
        {-176223924, -13250561, -176175640, -13218890, 0x1ad044a}, // WLF
        {-176226867, -13274200, -176162211, -13250561, 0x1ad044a},
        {-176226867, -13300000, -176167576, -13274200, 0x1ad044a},
        {-176250390, -13321601, -176179814, -13300000, 0x1ad044a},
        {-176225180, -13352287, -176175324, -13321601, 0x1ad044a},
        {-178226240, -14468224, -177908552, -14146320, 0x001000c},
        {-176341581, -13435263, -176023893, -13113359, 0x0b00010},
        {-178252267, -14838976, -176017942, -12664233, 0x0a80211},
        {-64640000,  18411419,  -64559180,  18460000,  0x2a7044a}, // VGB
        {-64717380,  18380572,  -64612398,  18418000,  0x2a7044a},
        {-64852000,  18305500,  -64494413,  18547000,  0xc730447},
        {-64494413,  18305500,  -64221498,  18593000,  0xbde0447},
        {-64600000,  18593000,  -64219959,  18800000,  0xbde0447},
        {-64852000,  18305500,  -64210000,  18800000,  0x0970211},
        {9473847,    47053018,  9530152,    47091627,  0x1ad004a}, // LIE
        {9511847,    47091627,  9568152,    47130236,  0x1ad004a},
        {9503847,    47130236,  9560152,    47168845,  0x1ad004a},
        {9481847,    47168845,  9538152,    47207454,  0x1ad004a},
        {9497579,    47207454,  9554420,    47246063,  0x1ad004a},
        {9469000,    47044000,  9643000,    47274000,  0x001000c},
        {5850000,    35450000,  18560000,   55080000,  0x50a0216},
        {9469000,    47044000,  9643000,    47274000,  0x003021c},
        {-70063165,  12481492,  -69974753,  12567982,  0x001000a}, // ABW
        {-70114256,  12358320,  -69827816,  12652944,  0x001000c},
        {167709000,  8713000,   167757000,  8867000,   0x037000a}, // MHL
        {170962845,  6870363,   171431565,  7361403,   0x001000c},
        {168544027,  7270280,   169012747,  7761320,   0x0b10010},
        {168732832,  14415080,  169211968,  14906120,  0x001008c},
        {168480677,  4519311,   168949397,  5010351,   0x001088c},
        {160665840,  9576480,   161139768,  10067520,  0x001108c},
        {166601440,  11097380,  167075368,  11588420,  0x001188c},
        {166377624,  18845980,  166867176,  19337020,  0x001208c},
        {169350000,  5785780,   169791760,  6312000,   0x021288c},
        {171707598,  5845594,   172176318,  6336634,   0x001308c},
        {171499552,  6877265,   171968272,  7368305,   0x001388c},
        {167883840,  5370380,   168352560,  5861420,   0x001408c},
        {166105640,  10904780,  166579568,  11395820,  0x001488c},
        {169696640,  10074780,  170170568,  10565820,  0x001508c},
        {170846081,  7968670,   171314801,  8459710,   0x001588c},
        {162001340,  11249980,  162475268,  11741020,  0x001608c},
        {165170340,  11350580,  165644268,  11841620,  0x001688c},
        {168886340,  5397780,   169355060,  5888820,   0x001708c},
        {166002340,  8692680,   166476268,  9183720,   0x001788c},
        {167146640,  8067780,   167615360,  8558820,   0x001808c},
        {166809963,  9069124,   167283891,  9560164,   0x001888c},
        {167283891,  9069124,   167757819,  9560164,   0x001908c},
        {167378676,  8578084,   167852604,  9069124,   0x001988c},
        {168894640,  9669180,   169368568,  10160220,  0x001a08c},
        {170806724,  8459019,   171280652,  8950059,   0x001a88c},
        {170635940,  10042280,  171109868,  10533320,  0x001b08c},
        {167920645,  7739474,   168389365,  8230514,   0x001b88c},
        {167219240,  11105180,  167693168,  11596220,  0x001c08c},
        {165411940,  8829380,   165885868,  9320420,   0x001c88c},
        {169484440,  10978580,  169958368,  11469620,  0x001d08c},
        {165725040,  9858480,   166198968,  10349520,  0x001d88c},
        {169784163,  9311096,   170258091,  9802136,   0x001e08c},
        {169784163,  8820055,   170258091,  9311095,   0x001e88c},
        {169864212,  12013976,  170338140,  12505016,  0x001f08c},
        {160595398,  4506265,   172402954,  19352930,  0x0010016},
        {-170756000, -14358000, -170674500, -14265950, 0x021000a}, // ASM
        {-171102112, -11080370, -171051284, -11030511, 0x004010b},
        {-170860000, -14378000, -170540000, -14229000, 0x004010b},
        {-169701004, -14300981, -169403687, -14150000, 0x004010b},
        {-168235531, -14618875, -168086700, -14472514, 0x004010b},
        {-171102200, -14378100, -169403600, -11030500, 0x0ef0011},
        {-171102200, -14732000, -167913000, -11030500, 0x0010216},
        {-159832000, -21273000, -159723500, -21198400, 0x01a000b}, // COK
        {-161271860, -10480061, -160797932, -9989021,  0x001000c},
        {-158183360, -9316420,  -157709432, -8825380,  0x0b00010},
        {-159960141, -21417476, -157159787, -18736286, 0x0a90011},
        {-165952460, -11164220, -165478532, -10673180, 0x001b888},
        {-165651360, -11803620, -165177432, -11312580, 0x001a088},
        {-163382468, -13580320, -162903332, -13089280, 0x001c088},
        {-158196284, -21992220, -157696316, -21501180, 0x0019888},
        {-163406876, -18306520, -162917324, -17815480, 0x001a888},
        {-165960000, -21999000, -157154000, -8610000,  0x0010016},
        {-56246890,  46742755,  -56120999,  46829245,  0x001000a}, // SPM
        {-56602272,  46735356,  -55987728,  47177292,  0x001000c},
        {-169949167, -19117044, -169857872, -19030554, 0x001000b}, // NIU
        {-170002824, -19193312, -169705968, -18898688, 0x001000c},
        {-62743846,  17279490,  -62680021,  17340599,  0x2a7004a}, // KNA
        {-62632976,  17105911,  -62569151,  17167020,  0x2a7004a},
        {-62907696,  17073584,  -62517096,  17466416,  0x001000c},
        {-81395252,  19264490,  -81330748,  19325599,  0x2a7004a}, // CYM
        {-81419752,  19336490,  -81355248,  19397599,  0x2a7004a},
        {-81484770,  19230000,  -81046143,  19431629,  0x004010b},
        {-80143890,  19618658,  -79652000,  19805000,  0x004010b},
        {-81484800,  19230000,  -79651900,  19805100,  0x0610011},
        {-68311245,  12115916,  -68224755,  12200484,  0x001000a}, // BES
        {-68432676,  12257247,  -68350030,  12337971,  0x001088b},
        {-68350030,  12257247,  -68267384,  12337971,  0x001108b},
        {-68432676,  12176523,  -68350030,  12257247,  0x001188b},
        {-68350030,  12176523,  -68267384,  12257247,  0x001208b},
        {-68267384,  12176523,  -68184738,  12257247,  0x001288b},
        {-68350030,  12095799,  -68267384,  12176523,  0x001308b},
        {-68267384,  12095799,  -68184738,  12176523,  0x001388b},
        {-68292178,  12015075,  -68209532,  12095799,  0x001408b},
        {-63007557,  17459404,  -62935482,  17528596,  0x001c88b},
        {-63274557,  17595404,  -63202482,  17664596,  0x001c08b},
        {-68480000,  12000000,  -62923000,  17680000,  0x0010216},
        {73470755,   4165728,   73557245,   4252218,   0x001000a}, // MDV
        {73036128,   -710000,   73504848,   -218960,   0x001000c},
        {72835640,   6523792,   73304360,   7014832,   0x0b10010},
        {72500000,   5600000,   73510000,   7135000,   0x004018c},
        {72660000,   1750000,   73790000,   5600000,   0x004018c},
        {72900000,   160000,    73650000,   950000,    0x004010c},
        {73026128,   -720000,   73514848,   -208960,   0x004010c},
        {71500000,   -1000000,  75500000,   7500000,   0x0010216},
        {-5761206,   -15983245, -5671833,   -15896755, 0x001000a}, // SHN
        {-14424756,  -7996255,  -14288000,  -7882857,  0x004010b},
        {-5805000,   -16040000, -5617000,   -15896000, 0x004010b},
        {-12372000,  -37183000, -12204000,  -37046000, 0x004010b},
        {-12747000,  -37459000, -12452000,  -37271000, 0x004010b},
        {-10060000,  -40400000, -9800000,   -40250000, 0x004010b},
        {-14530000,  -40500000, -5540000,   -7777000,  0x0010217},
        {14419556,   35855000,  14548000,   35930000,  0x01a000a}, // MLT
        {14165848,   35753584,  14624152,   36146416,  0x001000c},
        {-61799362,  11987132,  -61711911,  12073622,  0x001000a}, // GRD
        {-61803000,  11983000,  -61375000,  12531000,  0x022000c},
        {-64989026,  18309620,  -64863850,  18373000,  0x016000a}, // VIR
        {-65068846,  18260000,  -64576690,  18422000,  0x004010b},
        {-64940000,  17660000,  -64550000,  17820000,  0x004010b},
        {-65087000,  18225000,  -64640000,  18422000,  0x0750010},
        {-65093994,  17636170,  -64550000,  18426851,  0x0d00211},
        {45200476,   -12817650, 45242633,   -12727106, 0x2a7044a}, // MYT
        {45242386,   -12819750, 45301886,   -12755553, 0x2a7044a},
        {44900000,   -13033000, 45360000,   -12590000, 0x001000c},
        {15485616,   78200711,  15782507,   78261820,  0x2a7004a}, // SJM
        {14043750,   78045711,  14328250,   78106820,  0x2a7004a},
        {-9164930,   70754480,  -7779602,   71245520,  0x001000c},
        {10400000,   76889405,  22024500,   79500000,  0x0a50011},
        {-9154000,   68600000,  33625000,   80843100,  0x0970012},
        {10000000,   74300000,  33624989,   80843000,  0x0010016},
        {-9165000,   70754400,  33625000,   80843100,  0x003021c},
        {-61257000,  13122000,  -61139000,  13183000,  0x016000a}, // VCT
        {-61300000,  13100000,  -61100000,  13390000,  0x004010b},
        {-61300000,  12770000,  -61100000,  13100000,  0x004010b},
        {-61500000,  12530000,  -61200000,  12770000,  0x004010b},
        {-61500000,  12530000,  -61000000,  13400000,  0x0e00211},
        {73395835,   -53117885, 73539024,   -53031395, 0x001000b}, // HMD
        {72580000,   -53200000, 73870000,   -52900000, 0x06a0010},
        {-59642289,  13077029,  -59553877,  13163519,  0x001000a}, // BRB
        {-59716656,  13022864,  -59383344,  13366592,  0x001000c},
        {-61865167,  17086755,  -61774833,  17173245,  0x001000a}, // ATG
        {-61949413,  17488858,  -61657765,  17783482,  0x0b10010},
        {-61959724,  16936995,  -61636828,  17258899,  0x001000c},
        {-62413512,  16917821,  -61489991,  17811551,  0x0a90011},
        {-68973785,  12083106,  -68885373,  12169596,  0x001000a}, // CUW
        {-69166000,  11974341,  -68632450,  12395419,  0x01b000c},
        {55404000,   -4650226,  55483000,   -4560000,  0x021000a}, // SYC
        {55180679,   -4855520,  55649399,   -4364480,  0x001000c},
        {55527952,   -4662728,  55996672,   -4171688,  0x0b00010},
        {53216000,   -5800000,  56000000,   -3690000,  0x0930011},
        {46070000,   -10307000, 51235000,   -9160000,  0x00e000d},
        {52640000,   -7200000,  56380000,   -5800000,  0x24d0015},
        {46000000,   -10500000, 56500000,   -3690000,  0x0010016},
        {134435755,  7299755,   134522245,  7386245,   0x001000a}, // PLW
        {134329233,  7134620,   134655304,  7765423,   0x02a000c},
        {134030000,  6780415,   134422000,  7311000,   0x0c90010},
        {132129405,  5539405,   134810595,  8220595,   0x0a90011},
        {130959405,  2759404,   133640595,  5440594,   0x001000d},
        {130900000,  2700000,   134818730,  8222400,   0x0010216},
        {145692200,  15112000,  145761100,  15220000,  0x027000a}, // MNP
        {145400432,  14814480,  145884776,  15305520,  0x001000c},
        {145610000,  18000000,  145840000,  18840000,  0x1520010},
        {144875000,  14080000,  146076000,  20560000,  0x18d0011},
        {1482182,    42461955,  1598463,    42548445,  0x001000a}, // AND
        {1404864,    42394488,  1795464,    42694568,  0x001000c},
        {348000,     40191933,  3820000,    42873123,  0x0a90291},
        {1404864,    42394488,  1795464,    42694568,  0x003021c},
        {144826158,  13521379,  144888964,  13582488,  0x2a7004a}, // GUM
        {144737755,  13449545,  144800561,  13510654,  0x2a7004a},
        {144534432,  13215480,  145013568,  13706520,  0x001000c},
        {-4563036,   54131248,  -4416003,   54217738,  0x001000a}, // IMN
        {-4920600,   53990480,  -4134192,   54481520,  0x001000c},
        {-10700000,  49122422,  1889648,    60875000,  0x0010216},
        {-4920600,   53990480,  -4134192,   54481520,  0x003021c},
        {-61016523,  13981053,  -60928111,  14067543,  0x001000a}, // LCA
        {-61100000,  13690000,  -60830000,  14118000,  0x001000c},
        {151555130,  7315679,   151641620,  7402169,   0x001000a}, // FSM
        {157759000,  6718000,   158372000,  7091000,   0x017000c},
        {137891594,  9269744,   138365522,  9760784,   0x0b00010},
        {137142440,  8207480,   137611160,  8698520,   0x0010088},
        {139544140,  9687280,   140018068,  10178320,  0x0010888},
        {140282640,  9517880,   140756568,  10008920,  0x0011088},
        {143637140,  7116980,   144105860,  7608020,   0x0011888},
        {144342740,  7130180,   144811460,  7621220,   0x0012088},
        {144277940,  8342280,   144746660,  8833320,   0x0012888},
        {145145940,  8982480,   145619868,  9473520,   0x0013088},
        {145625740,  7448080,   146094460,  7939120,   0x0013888},
        {145993640,  7242280,   146462360,  7733320,   0x0014088},
        {149072540,  7234780,   149541260,  7725820,   0x0014888},
        {149427440,  8342380,   149896160,  8833420,   0x0015088},
        {150001640,  8528580,   150475568,  9019620,   0x0015888},
        {152905440,  5668680,   153374160,  6159720,   0x0016088},
        {153407940,  5210880,   153876660,  5701920,   0x0016888},
        {154040940,  7853779,   154509660,  8344819,   0x0017088},
        {155051640,  7270980,   155520360,  7762020,   0x0017888},
        {157021840,  5565880,   157490560,  6056920,   0x0018088},
        {159523340,  6440880,   159992060,  6931920,   0x0018888},
        {160462640,  5966080,   160931360,  6457120,   0x0019088},
        {160673440,  9554480,   161147368,  10045520,  0x0019888},
        {162638740,  5219280,   163107460,  5710320,   0x001a088},
        {146678969,  6573900,   149360159,  9255090,   0x0010015},
        {150700754,  6573900,   153381944,  9255090,   0x0a90011},
        {137000000,  5210000,   163120000,  10200000,  0x19a0016},
        {152000000,  1000000,   157000000,  5210000,   0x09e0012},
        {137000000,  1000000,   163120000,  10200000,  0x0010217},
        {103796755,  1261728,   103883245,  1348218,   0x001000a}, // SGP
        {103570000,  1160000,   104130000,  1482000,   0x016000c},
        {-175250128, -21210543, -175157872, -21124053, 0x001000a}, // TON
        {-175364984, -21477340, -174865016, -20986300, 0x001000c},
        {-174258388, -19031068, -173768836, -18540028, 0x0b10010},
        {-175738000, -21493000, -173674000, -17900000, 0x0e30011},
        {-176214000, -17900000, -173674000, -15542000, 0x001000d},
        {-176214000, -22350000, -173674000, -19500000, 0x4180015},
        {-176214000, -22350000, -173674000, -15542000, 0x0010216},
        {-61395587,  15258755,  -61306214,  15345245,  0x001000a}, // DMA
        {-61598068,  15182121,  -61113724,  15673161,  0x001000c},
        {50511077,   26194782,  50575813,   26258600,  0x2a7044a}, // BHR
        {50575813,   26194782,  50623592,   26281272,  0x2a7044a},
        {50310000,   25788000,  50745000,   26338000,  0x023000c},
        {50448000,   25557000,  50825000,   25967000,  0x0bd0010},
        {50300000,   25557000,  50825000,   26338000,  0x0d80211},
        {172918000,  1324000,   173080000,  1365000,   0x00f000a}, // KIR
        {172750000,  1690000,   173123949,  2010000,   0xf040447},
        {172860000,  1315000,   173194709,  1650000,   0xe890447},
        {-157502976, 1911168,   -157353217, 2060927,   0x680004b},
        {172908912,  3266656,   173059087,  3416415,   0x680044b},
        {172739000,  3038000,   172935649,  3152000,   0x680044b},
        {174382200,  -815000,   174483629,  -594000,   0x680044b},
        {175905120,  -1396909,  176054879,  -1247150,  0x680044b},
        {174657000,  -1260000,  174800639,  -1104000,  0x680044b},
        {173195120,  1937680,   173344879,  2087439,   0x680044b},
        {172967000,  835000,    173079589,  1034000,   0x680044b},
        {175500000,  -1956000,  175627349,  -1780000,  0x680044b},
        {176393000,  -1417000,  176520709,  -1300000,  0x54f044b},
        {-160455000, 4640000,   -160305186, 4740000,   0x54f044b},
        {172594000,  69000,     173976000,  3415000,   0x1060011},
        {174181028,  -2888514,  176862218,  -207324,   0x001000d},
        {-173318525, -4688133,  -170637335, -2006943,  0x0010015},
        {166790000,  -4736000,  189387000,  3644400,   0x23b0016},
        {197000000,  -11500000, 210000000,  4750000,   0x0c00012},
        {157830000,  -11500000, 210000000,  4750000,   0x0010017},
        {-71169000,  21417755,  -71108000,  21519000,  0x029000a}, // TCA
        {-72500000,  21610000,  -72400000,  21725000,  0x004010b},
        {-71730000,  21275000,  -71605500,  21374852,  0x004010b},
        {-72370000,  21720000,  -72057000,  21906781,  0x004010b},
        {-71259727,  21172423,  -71077938,  21521497,  0x004010b},
        {-72075000,  21770000,  -71838000,  21975000,  0x004010b},
        {-71917362,  21440000,  -71454000,  21860000,  0x0aa0010},
        {-72500000,  21000000,  -70900000,  22000000,  0x08a0011},
        {6666755,    299756,    6753245,    386246,    0x001000a}, // STP
        {6377221,    -34742,    6845941,    456298,    0x001000c},
        {7107412,    1306789,   7576132,    1797829,   0x0b00010},
        {5896479,    -62362,    7773312,    1814471,   0x0a80211},
        {114145854,  22262781,  114239071,  22349271,  0x001000a}, // HKG
        {113835000,  22153500,  114442000,  22564000,  0x0930010},
        {112200000,  20400000,  118000000,  26400500,  0x0b5ba92},
        {113835000,  22153500,  114442000,  22564000,  0x003021c},
        {-61100206,  14589000,  -60983000,  14650000,  0x016000a}, // MTQ
        {-61239568,  14388000,  -60760432,  14879000,  0x001000c},
        {-6892690,   61974015,  -6710100,   62060505,  0x001000a}, // FRO
        {-7700000,   61928000,  -6950000,   62355000,  0x001000c},
        {-6950000,   61928000,  -6244000,   62406580,  0x0ce0010},
        {-7100000,   61300000,  -6510000,   61928000,  0x02cc08c},
        {-7770000,   61300000,  -6180000,   62410000,  0x0010216},
        {-61600000,  16214000,  -61493000,  16283000,  0x019000a}, // GLP
        {-61810000,  15940000,  -61550000,  16366000,  0x004010b},
        {-61550000,  16194000,  -61350000,  16515000,  0x004010b},
        {-61350000,  16230000,  -61160000,  16340000,  0x004010b},
        {-61666000,  15820000,  -61555000,  15895000,  0x004010b},
        {-61102000,  16288000,  -60996000,  16365000,  0x004010b},
        {-61512968,  15704256,  -61028624,  16195296,  0x0b00010},
        {-61882549,  15696598,  -60899446,  16649910,  0x0a90011},
        {44365794,   -12193245, 44454206,   -12106755, 0x001000a}, // COM
        {43196000,   -11952895, 43540000,   -11350000, 0x028000c},
        {44190000,   -12390000, 44560667,   -12060000, 0xf04044b},
        {43575000,   -12460000, 43991759,   -12185000, 0xe89044b},
        {43165016,   -12554984, 44624775,   -11125016, 0x0a80011},
        {57456000,   -20192000, 57545700,   -20108813, 0x001000a}, // MUS
        {57496000,   -20122000, 57756000,   -19979500, 0x004010b},
        {57300000,   -20490000, 57374000,   -20401000, 0x004010b},
        {57356000,   -20530000, 57822000,   -20122000, 0x004010b},
        {63226096,   -19911416, 63621904,   -19518584, 0x0b10010},
        {59343432,   -16851520, 59827776,   -16360480, 0x001588c},
        {56494384,   -10570312, 56775616,   -10275688, 0x001a08c},
        {54330304,   -16089416, 54715696,   -15696584, 0x001c88c},
        {57450224,   -19965312, 57944984,   -19474272, 0x001688c},
        {59454176,   -16347312, 59745824,   -16052688, 0x001e08c},
        {54300000,   -20800000, 63700000,   -10270000, 0x0010216},
        {55434000,   -20939000, 55522965,   -20871000, 0x001000b}, // REU
        {55210000,   -21389870, 55672500,   -20870000, 0x021000c},
        {55517000,   -21410000, 55850000,   -20870000, 0x0e30010},
        {54847807,   -21782402, 56247984,   -20441807, 0x0aa0211},
        {6047691,    49561514,  6180309,    49648004,  0x001000a}, // LUX
        {5812948,    49447980,  6531652,    49939020,  0x001000c},
        {5733648,    49694480,  6452352,    50185520,  0x0b00010},
        {-5200000,   41310000,  9600000,    53557000,  0x0010216},
        {5733648,    49447980,  6531652,    50185520,  0x003021c},
        {-171837000, -13871000, -171715794, -13812702, 0x015000a}, // WSM
        {-172158000, -14078000, -171397000, -13777100, 0x013000c},
        {-172803500, -13805000, -172171000, -13440000, 0x0840010},
        {-172830000, -14100000, -171397000, -13390000, 0x0780011},
        {-36582036,  -54324245, -36435003,  -54237755, 0x001000a}, // SGS
        {-36993903,  -54547416, -36197079,  -54056376, 0x001000c},
        {-36524348,  -54863306, -35727524,  -54372266, 0x0b00010},
        {-38369968,  -55334148, -35510032,  -53636061, 0x0a80011},
        {-27700000,  -59600000, -26000000,  -56200000, 0x03a000d},
        {-41820000,  -53910992, -41320032,  -53600000, 0x0b0a890},
        {-39207461,  -54097034, -38707493,  -53786042, 0x0b0b090},
        {-34927700,  -55178035, -34412108,  -54867043, 0x0b0b890},
        {-41820000,  -59600000, -26000000,  -53600000, 0x0010216},
        {-149574753, -17567930, -149522540, -17518071, 0x22a004a}, // PYF
        {-149626107, -17591935, -149573894, -17542076, 0x22a004a},
        {-149626107, -17641794, -149573894, -17591935, 0x22a004a},
        {-149982860, -17678752, -149691212, -17384128, 0x0b10010},
        {-149622848, -17941882, -149122880, -17445386, 0x01e000c},
        {-152311000, -18000000, -149116323, -15792905, 0x08e0011},
        {-141110738, -10590563, -138310384, -7820000,  0x01e000d},
        {-152059920, -11666322, -151585992, -11175282, 0x0b10090},
        {-152547440, -10307684, -152073512, -9816644,  0x0b00890},
        {-150439610, -10156375, -149965682, -9665335,  0x0b01090},
        {-144626240, -27851191, -144100232, -27360151, 0x0b01890},
        {-143759690, -27960000, -143233682, -27468960, 0x0b02090},
        {-154821400, -23960000, -134290000, -13860000, 0x29b0016},
        {-154821400, -27960000, -134290000, -7820000,  0x0010217},
        {-25024000,  16862000,  -24902000,  16923380,  0x016000a}, // CPV
        {-23865667,  14884990,  -23381323,  15376030,  0x001000c},
        {-25366000,  16756115,  -24856000,  17220000,  0x0a80010},
        {-25400386,  14639405,  -22659614,  17320595,  0x0a90011},
        {-61550000,  10639900,  -61471037,  10687900,  0x2a7044a}, // TTO
        {-61471037,  10629000,  -61392074,  10677000,  0x2a7044a},
        {-61710000,  10125000,  -61373664,  10795000,  0x02b000c},
        {-61373664,  10236600,  -60975903,  10824000,  0x0d30010},
        {-61974357,  9966514,   -60365643,  11575228,  0x0aa0011},
        {114873081,  4867204,   114959571,  4953694,   0x001000a}, // BRN
        {114171000,  4394000,   114681000,  4847000,   0x0a20010},
        {114681000,  4649000,   115223000,  5057000,   0x01a000c},
        {114060000,  4000000,   115390000,  5166660,   0x09e0011},
        {70153022,   -49392248, 70285640,   -49305758, 0x001000b}, // ATF
        {77466060,   -37908368, 77655339,   -37758609, 0x001000c},
        {77439572,   -38788972, 77606228,   -38652572, 0x0b00010},
        {68507921,   -49884000, 70617161,   -48452324, 0x004010c},
        {50155880,   -46150560, 50312120,   -46035984, 0x004010c},
        {50336296,   -46467104, 50471704,   -46368896, 0x004010c},
        {50375166,   -45993638, 50479326,   -45917254, 0x004010c},
        {51622176,   -46519664, 51919032,   -46306880, 0x004010c},
        {52078592,   -46535208, 52349408,   -46338792, 0x004010c},
        {47254880,   -11631840, 47416328,   -11468160, 0x004010c},
        {42662127,   -17116110, 42789872,   -16993801, 0x004010c},
        {39626543,   -21542110, 39757685,   -21419801, 0x004010c},
        {40297089,   -22423110, 40428911,   -22300801, 0x004010c},
        {54501168,   -15912824, 54548040,   -15863720, 0x004010c},
        {46373486,   -12414110, 46498513,   -12291801, 0x004010c},
        {39626500,   -50020000, 77655400,   -11468100, 0x0010217},
        {-66121525,  18385157,  -66031191,  18471647,  0x001000a}, // PRI
        {-66259000,  18133300,  -65588800,  18477700,  0x016000c},
        {-67216000,  17924000,  -66530000,  18274000,  0x07e0010},
        {-67960177,  17830000,  -65180000,  18550000,  0x0570011},
        {172300000,  17821000,  295454000,  71425000,  0x2880217},
        {-67960177,  17830000,  -65180000,  18550000,  0x003021c},
        {33327717,   35135490,  33402406,   35196599,  0x2a7004a}, // CYP
        {32995942,   34647379,  33070121,   34708488,  0x2a7004a},
        {33098768,   34884480,  33666440,   35375520,  0x001000c},
        {32326000,   34555000,  33137000,   34894000,  0x07a0010},
        {32190000,   34540000,  34740000,   35725000,  0x07e0011},
        {35467106,   33823755,  35570894,   33910245,  0x001000a}, // LBN
        {35448768,   33724480,  36011232,   34215520,  0x001000c},
        {35650707,   34213000,  35969126,   34525059,  0xc73044b},
        {35257988,   33416709,  35546811,   33725000,  0xbde044b},
        {35153000,   33143290,  35478824,   33416709,  0xbde044b},
        {34800000,   33040000,  36630000,   34700000,  0x0af0011},
        {34217000,   28520000,  48790000,   37390000,  0x0010216},
        {34800000,   33040000,  36630000,   34700000,  0x003021c},
        {-76839167,  17962755,  -76748833,  18049245,  0x001000a}, // JAM
        {-76920109,  17875610,  -76679891,  18104389,  0x9ee004b},
        {-77134581,  17838404,  -76912224,  18050173,  0x931004b},
        {-77356644,  17796050,  -77134875,  18007819,  0x931004b},
        {-77578707,  17880758,  -77356350,  18092527,  0x931004b},
        {-76687500,  18115000,  -76315455,  18241500,  0x931044b},
        {-78370000,  18193000,  -77646000,  18530000,  0x015000c},
        {-78450000,  17650000,  -76150000,  18600000,  0x06e0011},
        {-16741984,  13402431,  -16653572,  13488921,  0x001000a}, // GMB
        {-14420000,  13226000,  -13795000,  13590000,  0x017000c},
        {-16662000,  13289000,  -16539439,  13477000,  0x680044b},
        {-16815160,  13264220,  -16661241,  13413979,  0x680004b},
        {-16791000,  13085000,  -16662774,  13264250,  0x680044b},
        {-16663000,  13162000,  -16481701,  13289000,  0x680044b},
        {-16553960,  13442520,  -16400041,  13592279,  0x680004b},
        {-16502853,  13328490,  -16377147,  13450799,  0x54f004b},
        {-15672853,  13472190,  -15547147,  13594499,  0x54f004b},
        {-15621653,  13372190,  -15495947,  13494499,  0x54f004b},
        {-16247653,  13458590,  -16121947,  13580899,  0x54f004b},
        {-16121947,  13458590,  -15996241,  13580899,  0x54f004b},
        {-14936353,  13581190,  -14810647,  13703499,  0x54f004b},
        {-14839553,  13483390,  -14713847,  13605699,  0x54f004b},
        {-14712853,  13368890,  -14587147,  13491199,  0x54f004b},
        {-17000000,  13040000,  -13792000,  13850000,  0x0550011},
        {51467667,   25248970,  51562806,   25335460,  0x001000b}, // QAT
        {51164000,   25076000,  51630400,   25593000,  0x021000c},
        {51147359,   24554270,  51630400,   25076000,  0x0bb0010},
        {50700000,   24450000,  51700000,   26200000,  0x0e90011},
        {-57898434,  -51722000, -57709000,  -51672000, 0x014000b}, // FLK
        {-58397827,  -51826680, -57658291,  -51335640, 0x001000c},
        {-59573376,  -51886520, -58823424,  -51395480, 0x0b00010},
        {-61500000,  -52960000, -57500000,  -50900000, 0x0980011},
        {168274650,  -17778525, 168364984,  -17692035, 0x001000a}, // VUT
        {168111791,  -17866416, 168601343,  -17375376, 0x001000c},
        {166817936,  -15757079, 167302280,  -15266039, 0x0b00010},
        {166377845,  -17307674, 169118617,  -14626484, 0x0a90011},
        {166330000,  -14628000, 169100000,  -13050000, 0x017000d},
        {168000000,  -20320000, 170300000,  -17303000, 0x4660015},
        {166330000,  -20320000, 170300000,  -13050000, 0x0010016},
        {19206340,   42397755,  19322621,   42484245,  0x001000a}, // MNE
        {19539467,   42896760,  19826532,   43108529,  0x931004b},
        {18839272,   42676640,  19101327,   42869959,  0x864004b},
        {19227898,   43263340,  19492101,   43456659,  0x864004b},
        {18744950,   42194400,  18930442,   42465059,  0x864044b},
        {18979172,   42491737,  19241227,   42685056,  0x864004b},
        {18485046,   42355440,  18744953,   42548759,  0x864004b},
        {18930442,   41847000,  19394122,   42493000,  0x029000c},
        {18433000,   41840000,  20382000,   43563000,  0x0b70011},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {18433000,   41840000,  20382000,   43563000,  0x003021c},
        {-77363700,  25015200,  -77255000,  25087289,  0x01a000a}, // BHS
        {-78997600,  26489000,  -77989600,  26742440,  0x010000c},
        {-77989622,  26694793,  -77893283,  26781282,  0x3c1004b},
        {-77989622,  26608304,  -77893283,  26694793,  0x3c1004b},
        {-77893283,  26608304,  -77796944,  26694793,  0x3c1004b},
        {-77900027,  26521815,  -77803688,  26608304,  0x3c1004b},
        {-75488694,  24268219,  -75394037,  24354708,  0x3c1004b},
        {-77543110,  26820100,  -77446291,  26906589,  0x3c1004b},
        {-77553963,  24980500,  -77458825,  25066989,  0x3c1004b},
        {-77458825,  25015182,  -77363687,  25101671,  0x3c1004b},
        {-77458825,  24967000,  -77288348,  25015200,  0x3c1044b},
        {-77130000,  26487850,  -77036869,  26577300,  0x3c1044b},
        {-76306000,  24744800,  -76163441,  24802400,  0x3c1044b},
        {-77848669,  24685600,  -77753531,  24772089,  0x3c1004b},
        {-75071300,  23078200,  -74929857,  23135600,  0x3c1044b},
        {-75748000,  24604700,  -75615814,  24666600,  0x3c1044b},
        {-76711309,  25436400,  -76615691,  25522889,  0x3c1004b},
        {-75833768,  23454800,  -75739832,  23541289,  0x3c1004b},
        {-76222669,  24848100,  -76127531,  24934589,  0x3c1004b},
        {-76222669,  24934589,  -76127531,  25021078,  0x3c1004b},
        {-79310000,  25686200,  -79222242,  25780400,  0x3c1044b},
        {-73686828,  20909200,  -73594573,  20995689,  0x3c1004b},
        {-73914908,  22526000,  -73821692,  22612489,  0x3c1004b},
        {-77901829,  25712600,  -77805971,  25799089,  0x3c1004b},
        {-74539609,  24013900,  -74445192,  24100389,  0x3c1004b},
        {-78100000,  25108700,  -77988824,  25182600,  0x3c1044b},
        {-74270248,  22732400,  -74176552,  22818889,  0x3c1004b},
        {-73140608,  22372300,  -73047392,  22458789,  0x3c1004b},
        {-75758910,  22149900,  -75689556,  22266000,  0x3c1044b},
        {-74880909,  23632600,  -74786492,  23719089,  0x3c1004b},
        {-74384208,  22539600,  -74290992,  22626089,  0x3c1004b},
        {-78345010,  27163800,  -78248191,  27250289,  0x3c1004b},
        {-73027108,  22338100,  -72933892,  22424589,  0x3c1004b},
        {-76940000,  22820000,  -74390000,  25580000,  0x021000d},
        {-79000000,  23636000,  -76940000,  27252000,  0x0e90011},
        {-75919000,  20900000,  -72708460,  23137000,  0x33c0015},
        {-80500000,  20900000,  -72708460,  27269069,  0x0010016},
        {125497000,  -8590000,  125630000,  -8537500,  0x013000a}, // TLS
        {125339640,  -8981294,  125813568,  -8490254,  0x001000c},
        {126152992,  -8900316,  126626920,  -8409276,  0x0b00010},
        {124030000,  -9510000,  127360000,  -8100000,  0x06e0011},
        {31067077,   -26348500, 31167000,   -26270000, 0x01d000a}, // SWZ
        {30994808,   -26665520, 31510400,   -26174480, 0x0b10010},
        {31209120,   -26032010, 31344679,   -25909701, 0x54f0047},
        {31086820,   -26023910, 31222379,   -25901601, 0x54f0047},
        {31663820,   -26048610, 31799379,   -25926301, 0x54f0047},
        {31780420,   -26108510, 31915979,   -25986201, 0x54f0047},
        {31912720,   -26071810, 32048279,   -25949501, 0x54f0047},
        {31879881,   -26502210, 32016119,   -26379901, 0x54f0047},
        {30946241,   -27039810, 31083159,   -26917501, 0x54f0047},
        {31639881,   -26746710, 31776119,   -26624401, 0x54f0047},
        {31052530,   -26743300, 31148869,   -26656811, 0x3c10047},
        {31258490,   -26998400, 31355309,   -26911911, 0x3c10047},
        {31147890,   -27152400, 31244709,   -27065911, 0x3c10047},
        {31818890,   -27317418, 31915709,   -27230929, 0x3c10047},
        {31899971,   -26273200, 31995829,   -26186711, 0x3c10047},
        {31899971,   -26186711, 31995829,   -26100222, 0x3c10047},
        {31917790,   -26829900, 32014609,   -26743411, 0x3c10047},
        {31820971,   -26916389, 31917790,   -26829900, 0x3c10047},
        {31917790,   -26916389, 32014609,   -26829900, 0x3c10047},
        {31500471,   -26093300, 31596329,   -26006811, 0x3c10047},
        {31596329,   -26093300, 31692187,   -26006811, 0x3c10047},
        {31500471,   -26179789, 31596329,   -26093300, 0x3c10047},
        {31596329,   -26179789, 31692187,   -26093300, 0x3c10047},
        {31500471,   -26266278, 31596329,   -26179789, 0x3c10047},
        {31596329,   -26266278, 31692187,   -26179789, 0x3c10047},
        {30790904,   -27317418, 32134741,   -25717939, 0x0c10011},
        {47930226,   29305755,  48028248,   29392245,  0x001000a}, // KWT
        {47641894,   28920824,  48173110,   29411864,  0x001000c},
        {47775243,   28524609,  48431159,   28920823,  0x08f0010},
        {46541500,   28520000,  48790000,   30105000,  0x0960011},
        {34217000,   28520000,  48790000,   37390000,  0x0010216},
        {46541500,   28520000,  48790000,   30105000,  0x003021c},
        {178420966,  -18164596, 178466230,  -18078106, 0x2a7044a}, // FJI
        {178466230,  -18133505, 178519432,  -18059946, 0x2a7044a},
        {178005528,  -18271000, 178653000,  -17910000, 0x017000c},
        {177373149,  -17720079, 177629319,  -17475460, 0xa9e004b},
        {177232255,  -17964698, 177488425,  -17720079, 0xa9e004b},
        {177629319,  -17671155, 177885489,  -17426536, 0xa9e004b},
        {179260844,  -16584390, 179499155,  -16355611, 0x9ee004b},
        {176834000,  -18313000, 180054000,  -16123000, 0x08d0011},
        {179708000,  -19265000, 181787000,  -15940000, 0x027000d},
        {177380224,  -18775020, 177869776,  -18283980, 0x0b19090},
        {177857824,  -18771320, 178347376,  -18280280, 0x0b19890},
        {177940000,  -19220000, 178540000,  -18856600, 0x0898890},
        {178356724,  -18848520, 178846276,  -18357480, 0x0b15090},
        {-178669776, -20050120, -178175016, -19559080, 0x0b1d090},
        {-179054884, -21067720, -178554916, -20576680, 0x0b0e090},
        {176909832,  -12947620, 177388968,  -12456580, 0x0b0b890},
        {-180193468, -15930020, -179709124, -15438980, 0x0b0c890},
        {176834000,  -21080000, 181831000,  -12455000, 0x0010216},
        {166406184,  -22311215, 166499401,  -22224725, 0x001000a}, // NCL
        {166245013,  -22351326, 166744981,  -21860286, 0x001000c},
        {167800087,  -21653000, 167970505,  -21371000, 0x931044b},
        {167970000,  -21662000, 168132022,  -21414771, 0x864044b},
        {167161896,  -21013660, 167368103,  -20820341, 0x864004b},
        {165251296,  -21126560, 165457503,  -20933241, 0x864004b},
        {165337859,  -21663660, 165545140,  -21470341, 0x864004b},
        {164762896,  -21156660, 164969103,  -20963341, 0x864004b},
        {164163788,  -22711839, 166993933,  -20030649, 0x0a90011},
        {166666000,  -23050000, 168960000,  -20650000, 0x001000d},
        {162700000,  -20835000, 164724000,  -17857000, 0x4aa0015},
        {158147000,  -23050000, 168960000,  -17850000, 0x0010016},
        {14437596,   46016155,  14560604,   46102645,  0x001000a}, // SVN
        {14114488,   45887480,  14781112,   46378520,  0x001000c},
        {15580335,   46492100,  15705264,   46578589,  0x3c1004b},
        {15213735,   46209400,  15338664,   46295889,  0x3c1004b},
        {15020535,   46326600,  15145464,   46413089,  0x3c1004b},
        {13683237,   45497900,  13805763,   45584389,  0x3c1004b},
        {13562137,   45461500,  13684663,   45547989,  0x3c1004b},
        {15103236,   45760400,  15226963,   45846889,  0x3c1004b},
        {15782000,   46384800,  15949569,   46449200,  0x3c1044b},
        {14952400,   46117300,  15117199,   46182100,  0x3c1044b},
        {13995835,   46360800,  14120764,   46447289,  0x3c1004b},
        {13621136,   45891200,  13744863,   45977689,  0x3c1004b},
        {16087535,   46616800,  16212464,   46703289,  0x3c1004b},
        {14798737,   45606800,  14921263,   45693289,  0x3c1004b},
        {14185236,   45758400,  14308963,   45844889,  0x3c1004b},
        {14842000,   46503770,  14989809,   46576820,  0x3c1044b},
        {15017535,   46476800,  15142464,   46563289,  0x3c1004b},
        {15409536,   45906600,  15533263,   45993089,  0x3c1004b},
        {15497535,   46356800,  15622464,   46443289,  0x3c1004b},
        {15518136,   45878900,  15684093,   45943289,  0x3c1044b},
        {14771536,   46021900,  14895263,   46108389,  0x3c1004b},
        {13838136,   45846800,  13961863,   45933289,  0x3c1004b},
        {13961236,   45962400,  14084963,   46048889,  0x3c1004b},
        {15114737,   45526300,  15237263,   45612789,  0x3c1004b},
        {13868035,   46239900,  13992964,   46326389,  0x3c1004b},
        {15275998,   45984300,  15534398,   46025659,  0x3c1044b},
        {15094135,   46196700,  15219064,   46283189,  0x3c1004b},
        {14181737,   45531300,  14304263,   45617789,  0x3c1004b},
        {13802636,   45675600,  13926363,   45762089,  0x3c1004b},
        {15357835,   46315800,  15482764,   46402289,  0x3c1004b},
        {15577535,   46196800,  15702464,   46283289,  0x3c1004b},
        {15337535,   46176800,  15462464,   46263289,  0x3c1004b},
        {15457535,   46496800,  15582464,   46583289,  0x3c1004b},
        {13375500,   45421510,  16610484,   46876647,  0x0860011},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {13375500,   45421510,  16610484,   46876647,  0x003021c},
        {35164982,   31732430,  35265887,   31818920,  0x001000a}, // ISR
        {34777130,   32113289,  34878995,   32199778,  0x3c1004b},
        {34878995,   32113289,  34980860,   32199778,  0x3c1004b},
        {34736384,   32026800,  34838249,   32113289,  0x3c1004b},
        {34838249,   32026800,  34940114,   32113289,  0x3c1004b},
        {34716252,   31940311,  34817636,   32026800,  0x3c1004b},
        {34817636,   31940311,  34919020,   32026800,  0x3c1004b},
        {34685836,   31853822,  34787220,   31940311,  0x3c1004b},
        {34787220,   31853822,  34888604,   31940311,  0x3c1004b},
        {34611108,   31762800,  34712492,   31849289,  0x3c1004b},
        {34938707,   32750853,  35041292,   32837342,  0x3c1004b},
        {35041292,   32742204,  35143877,   32828693,  0x3c1004b},
        {35041292,   32828693,  35143877,   32915182,  0x3c1004b},
        {35143907,   32789824,  35246492,   32876313,  0x3c1004b},
        {34753548,   31211500,  34875452,   31283000,  0x3c1044b},
        {34832867,   32278900,  34934732,   32365389,  0x3c1004b},
        {34509708,   31619700,  34611092,   31706189,  0x3c1004b},
        {35255607,   32668600,  35358192,   32755089,  0x3c1004b},
        {34874567,   32410100,  34976432,   32496589,  0x3c1004b},
        {34976432,   32381700,  35058263,   32489300,  0x3c1044b},
        {34930708,   31705400,  35032092,   31791889,  0x3c1004b},
        {35081000,   32988000,  35163837,   33095000,  0x3c1044b},
        {34709308,   31566800,  34810692,   31653289,  0x3c1004b},
        {35066307,   32902500,  35168892,   32988989,  0x3c1004b},
        {35168907,   32902500,  35271492,   32988989,  0x3c1004b},
        {35271307,   32898549,  35373892,   32985038,  0x3c1004b},
        {34900989,   29528900,  35000211,   29615389,  0x3c1004b},
        {35451407,   32764400,  35553992,   32850889,  0x3c1004b},
        {35071867,   32471400,  35173732,   32557889,  0x3c1004b},
        {35271000,   32594000,  35400486,   32662400,  0x3c1044b},
        {34933973,   32222475,  35035838,   32308964,  0x3c1004b},
        {34970248,   31026600,  35071152,   31113089,  0x3c1004b},
        {34411000,   31541466,  34571675,   31596000,  0x3c10447},
        {34366148,   31455000,  34467052,   31541489,  0x3c10047},
        {34467052,   31455000,  34567956,   31541489,  0x3c10047},
        {34258180,   31368511,  34359084,   31455000,  0x3c10047},
        {34359084,   31368511,  34459988,   31455000,  0x3c10047},
        {34177457,   31282022,  34278361,   31368511,  0x3c10047},
        {34278361,   31282022,  34379265,   31368511,  0x3c10047},
        {34225000,   31216000,  34357089,   31282000,  0x3c10447},
        {35164208,   31819000,  35265592,   31905489,  0x3c10047},
        {35164208,   31905489,  35265592,   31991978,  0x3c10047},
        {35265608,   31741100,  35366992,   31827589,  0x3c10047},
        {34938408,   31536900,  35039792,   31623389,  0x3c10047},
        {35039792,   31536900,  35141176,   31623389,  0x3c10047},
        {35141176,   31536900,  35242560,   31623389,  0x3c10047},
        {34908232,   31450411,  35009136,   31536900,  0x3c10047},
        {35009136,   31450411,  35110040,   31536900,  0x3c10047},
        {35110040,   31450411,  35210944,   31536900,  0x3c10047},
        {34928413,   31363922,  35029317,   31450411,  0x3c10047},
        {35029317,   31363922,  35130221,   31450411,  0x3c10047},
        {35130221,   31363922,  35231125,   31450411,  0x3c10047},
        {35207367,   32174100,  35309232,   32260589,  0x3c10047},
        {35010067,   32273300,  35111932,   32359789,  0x3c10047},
        {34956767,   32123900,  35058632,   32210389,  0x3c10047},
        {35414908,   31816600,  35516292,   31903089,  0x3c10047},
        {35127767,   32433200,  35229632,   32519689,  0x3c10047},
        {35229632,   32433200,  35331497,   32519689,  0x3c10047},
        {35129508,   31647100,  35230892,   31733589,  0x3c10047},
        {35194367,   32087600,  35296232,   32174089,  0x3c10047},
        {35006408,   31860800,  35107792,   31947289,  0x3c10047},
        {35150067,   32312500,  35251932,   32398989,  0x3c10047},
        {35257567,   32339700,  35359432,   32426189,  0x3c10047},
        {34217000,   29486000,  35933000,   33426000,  0x1110011},
        {34217000,   28520000,  48790000,   37390000,  0x0010216},
        {34217000,   29486000,  35933000,   33426000,  0x003021c},
        {35164982,   31732430,  35265887,   31818920,  0x001000a}, // PSE
        {34411000,   31541466,  34571675,   31596000,  0x3c10447},
        {34366148,   31455000,  34467052,   31541489,  0x3c10047},
        {34467052,   31455000,  34567956,   31541489,  0x3c10047},
        {34258180,   31368511,  34359084,   31455000,  0x3c10047},
        {34359084,   31368511,  34459988,   31455000,  0x3c10047},
        {34177457,   31282022,  34278361,   31368511,  0x3c10047},
        {34278361,   31282022,  34379265,   31368511,  0x3c10047},
        {34225000,   31216000,  34357089,   31282000,  0x3c10447},
        {35164208,   31819000,  35265592,   31905489,  0x3c10047},
        {35164208,   31905489,  35265592,   31991978,  0x3c10047},
        {35265608,   31741100,  35366992,   31827589,  0x3c10047},
        {34938408,   31536900,  35039792,   31623389,  0x3c10047},
        {35039792,   31536900,  35141176,   31623389,  0x3c10047},
        {35141176,   31536900,  35242560,   31623389,  0x3c10047},
        {34908232,   31450411,  35009136,   31536900,  0x3c10047},
        {35009136,   31450411,  35110040,   31536900,  0x3c10047},
        {35110040,   31450411,  35210944,   31536900,  0x3c10047},
        {34928413,   31363922,  35029317,   31450411,  0x3c10047},
        {35029317,   31363922,  35130221,   31450411,  0x3c10047},
        {35130221,   31363922,  35231125,   31450411,  0x3c10047},
        {35207367,   32174100,  35309232,   32260589,  0x3c10047},
        {35010067,   32273300,  35111932,   32359789,  0x3c10047},
        {34956767,   32123900,  35058632,   32210389,  0x3c10047},
        {35414908,   31816600,  35516292,   31903089,  0x3c10047},
        {35127767,   32433200,  35229632,   32519689,  0x3c10047},
        {35229632,   32433200,  35331497,   32519689,  0x3c10047},
        {35129508,   31647100,  35230892,   31733589,  0x3c10047},
        {35194367,   32087600,  35296232,   32174089,  0x3c10047},
        {35006408,   31860800,  35107792,   31947289,  0x3c10047},
        {35150067,   32312500,  35251932,   32398989,  0x3c10047},
        {35257567,   32339700,  35359432,   32426189,  0x3c10047},
        {34217000,   29486000,  35933000,   33426000,  0x1110011},
        {34217000,   28520000,  48790000,   37390000,  0x0010216},
        {34217000,   31217000,  35575500,   32552500,  0x003021c},
        {-89248047,  13650755,  -89159635,  13737245,  0x001000a}, // SLV
        {-89381654,  13444480,  -88902518,  13935520,  0x001000c},
        {-89599246,  13955600,  -89510355,  14042089,  0x3c1004b},
        {-88224446,  13431400,  -88135555,  13517889,  0x3c1004b},
        {-89781846,  13673400,  -89692955,  13759889,  0x3c1004b},
        {-88921646,  13796800,  -88832755,  13883289,  0x3c1004b},
        {-88484446,  13296800,  -88395555,  13383289,  0x3c1004b},
        {-88906846,  13462800,  -88817955,  13549289,  0x3c1004b},
        {-88842546,  13622300,  -88753655,  13708789,  0x3c1004b},
        {-89893446,  13893200,  -89804555,  13979689,  0x3c1004b},
        {-89708630,  13962900,  -89599019,  14033000,  0x3c1044b},
        {-89234446,  13916800,  -89145555,  14003289,  0x3c1004b},
        {-87893446,  13275100,  -87804555,  13361589,  0x3c1004b},
        {-89872146,  13555400,  -89783255,  13641889,  0x3c1004b},
        {-88614446,  13730600,  -88525555,  13817089,  0x3c1004b},
        {-89494566,  14286800,  -89405435,  14373289,  0x3c1004b},
        {-88396846,  13361600,  -88307955,  13448089,  0x3c1004b},
        {-88674446,  13836800,  -88585555,  13923289,  0x3c1004b},
        {-89016846,  13995600,  -88927955,  14082089,  0x3c1004b},
        {-88605946,  13260700,  -88517055,  13347189,  0x3c1004b},
        {-89536346,  13700900,  -89447455,  13787389,  0x3c1004b},
        {-88129846,  13653600,  -88040955,  13740089,  0x3c1004b},
        {-88489446,  13432200,  -88400555,  13518689,  0x3c1004b},
        {-87906846,  13560300,  -87817955,  13646789,  0x3c1004b},
        {-89470146,  13779800,  -89381255,  13866289,  0x3c1004b},
        {-89793846,  13807600,  -89704955,  13894089,  0x3c1004b},
        {-88572146,  13462600,  -88483255,  13549089,  0x3c1004b},
        {-89804946,  13925100,  -89716055,  14011589,  0x3c1004b},
        {-88410346,  13480900,  -88321455,  13567389,  0x3c1004b},
        {-89593446,  13814700,  -89504555,  13901189,  0x3c1004b},
        {-89536412,  13877150,  -89472588,  13939249,  0x2b2004b},
        {-88395995,  13301940,  -88334206,  13362059,  0x29c004b},
        {-89323112,  14095950,  -89259288,  14158049,  0x2b2004b},
        {-88302495,  13729340,  -88240706,  13789459,  0x29c004b},
        {-89779412,  13751350,  -89715588,  13813449,  0x2b2004b},
        {-89694595,  13716040,  -89632806,  13776159,  0x29c004b},
        {-90131000,  13000000,  -87682000,  14451660,  0x0830011},
        {-92236000,  7190000,   -77140000,  18500000,  0x3300216},
        {-90131000,  13000000,  -87682000,  14451660,  0x003021c},
        {-88243497,  17474790,  -88179503,  17535899,  0x2a7004a}, // BLZ
        {-88807813,  17220290,  -88743988,  17281399,  0x2a7004a},
        {-89157164,  16967080,  -88667612,  17458120,  0x001000c},
        {-88399185,  17409360,  -88177416,  17621129,  0x931004b},
        {-88684893,  17992140,  -88481908,  18185459,  0x864004b},
        {-88414756,  16831440,  -88212845,  17024759,  0x864004b},
        {-88496393,  18305240,  -88293408,  18498559,  0x864004b},
        {-88028500,  17872100,  -87864071,  18110600,  0x864044b},
        {-88949319,  16018340,  -88748482,  16211659,  0x864004b},
        {-89230000,  15880000,  -87430000,  18500000,  0x0cf0011},
        {-92236000,  7190000,   -77140000,  18500000,  0x3300216},
        {-89230000,  15880000,  -87430000,  18500000,  0x003021c},
        {43056793,   11536680,  43130467,   11588258,  0x2a7044a}, // DJI
        {43130467,   11538377,  43175056,   11623696,  0x2a7044a},
        {42798247,   11133644,  43272175,   11624684,  0x001000c},
        {42577086,   11054310,  42810313,   11283089,  0x9ee004b},
        {42781757,   11744760,  42997643,   11956529,  0x931004b},
        {43204357,   11940460,  43420243,   12152229,  0x931004b},
        {42262351,   11004160,  42477649,   11215929,  0x931004b},
        {42441162,   12070460,  42657637,   12282229,  0x931004b},
        {41747000,   10900000,  43425000,   12725000,  0x0b10011},
        {21390638,   41966800,  21514420,   42047600,  0x01d000a}, // MKD
        {21183760,   41789032,  21808720,   42280072,  0x001000c},
        {21264540,   40972490,  21426260,   41094799,  0x54f004b},
        {21452040,   41281290,  21613760,   41403599,  0x54f004b},
        {20863160,   41941390,  21026239,   42063699,  0x54f004b},
        {21026239,   41941390,  21189318,   42063699,  0x54f004b},
        {21025560,   42063699,  21189998,   42186008,  0x54f004b},
        {21703560,   41655890,  21866639,   41778199,  0x54f004b},
        {20717640,   41092790,  20879360,   41215099,  0x54f004b},
        {20838460,   41738890,  21001539,   41861199,  0x54f004b},
        {22123040,   41707300,  22238359,   41793789,  0x3c1004b},
        {22602821,   41386800,  22717179,   41473289,  0x3c1004b},
        {21952821,   41396800,  22067179,   41483289,  0x3c1004b},
        {20606921,   41136800,  20721279,   41223289,  0x3c1004b},
        {22330840,   41852200,  22446159,   41938689,  0x3c1004b},
        {20912140,   41473200,  21027459,   41559689,  0x3c1004b},
        {22437140,   41575100,  22552459,   41661589,  0x3c1004b},
        {22271860,   42168200,  22388140,   42254689,  0x3c1004b},
        {22470021,   41106800,  22584379,   41193289,  0x3c1004b},
        {22065440,   41456800,  22180759,   41543289,  0x3c1004b},
        {21854340,   41821700,  21969659,   41908189,  0x3c1004b},
        {20481340,   41474500,  20596659,   41560989,  0x3c1004b},
        {22442340,   41856800,  22557659,   41943289,  0x3c1004b},
        {20954221,   41050400,  21068579,   41136889,  0x3c1004b},
        {21192321,   41325700,  21306679,   41412189,  0x3c1004b},
        {20452518,   40853783,  23035000,   42373406,  0x0940011},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {20452518,   40853783,  23035000,   42373406,  0x003021c},
        {30031755,   -1995245,  30118245,   -1908755,  0x001000a}, // RWA
        {29825640,   -2185520,  30294360,   -1694480,  0x001000c},
        {29540120,   -1574880,  29689879,   -1425121,  0x680004b},
        {29662620,   -2664880,  29812379,   -2515121,  0x680004b},
        {29241820,   -1739980,  29391579,   -1590221,  0x680004b},
        {29985120,   -1654880,  30134879,   -1505121,  0x680004b},
        {30414920,   -2033580,  30564679,   -1883821,  0x680004b},
        {28869745,   -2545210,  28992054,   -2422901,  0x54f004b},
        {29691045,   -2411110,  29813354,   -2288801,  0x54f004b},
        {29702545,   -2131110,  29824854,   -2008801,  0x54f004b},
        {29518845,   -2561110,  29641154,   -2438801,  0x54f004b},
        {30475345,   -2221110,  30597654,   -2098801,  0x54f004b},
        {29317145,   -2108910,  29439454,   -1986601,  0x54f004b},
        {29298798,   -1986601,  29421107,   -1864292,  0x54f004b},
        {28930045,   -2715310,  29052354,   -2593001,  0x54f004b},
        {28850000,   -2839000,  30901000,   -1047470,  0x09d0011},
        {-72375267,  18509755,  -72284933,  18596245,  0x001000a}, // HTI
        {-72672000,  18418000,  -72028200,  18788000,  0x017000c},
        {-72255187,  19703700,  -72163413,  19790189,  0x3c1004b},
        {-72722087,  19406800,  -72630313,  19493289,  0x3c1004b},
        {-72727847,  19059700,  -72636553,  19146189,  0x3c1004b},
        {-73810207,  18179000,  -73719394,  18265489,  0x3c1004b},
        {-72499947,  19012700,  -72408653,  19099189,  0x3c1004b},
        {-72553047,  19076800,  -72461753,  19163289,  0x3c1004b},
        {-72867487,  19870900,  -72775713,  19957389,  0x3c1004b},
        {-72775887,  19863800,  -72684113,  19950289,  0x3c1004b},
        {-74173927,  18583500,  -74082874,  18669989,  0x3c1004b},
        {-72577607,  18193300,  -72486794,  18279789,  0x3c1004b},
        {-72428087,  19674200,  -72336313,  19760689,  0x3c1004b},
        {-72670647,  19260200,  -72579353,  19346689,  0x3c1004b},
        {-72579353,  19234253,  -72488059,  19320742,  0x3c1004b},
        {-72039947,  19114800,  -71948653,  19201289,  0x3c1004b},
        {-72375647,  19326800,  -72284353,  19413289,  0x3c1004b},
        {-72033687,  19583500,  -71941913,  19669989,  0x3c1004b},
        {-71789987,  19503900,  -71698213,  19590389,  0x3c1004b},
        {-71767043,  19417411,  -71675269,  19503900,  0x3c1004b},
        {-72905527,  18360900,  -72814474,  18447389,  0x3c1004b},
        {-72145527,  18786800,  -72054474,  18873289,  0x3c1004b},
        {-72227387,  19550500,  -72135613,  19636989,  0x3c1004b},
        {-74463627,  18480300,  -74372574,  18566789,  0x3c1004b},
        {-71856087,  19588800,  -71764313,  19675289,  0x3c1004b},
        {-72725887,  19636800,  -72634113,  19723289,  0x3c1004b},
        {-72160147,  19276500,  -72068853,  19362989,  0x3c1004b},
        {-73121827,  18379500,  -73030774,  18465989,  0x3c1004b},
        {-74460927,  18393000,  -74369874,  18479489,  0x3c1004b},
        {-72245647,  19386800,  -72154353,  19473289,  0x3c1004b},
        {-73415507,  18247900,  -73324694,  18334389,  0x3c1004b},
        {-71985527,  18786800,  -71894474,  18873289,  0x3c1004b},
        {-72913827,  18763000,  -72822774,  18849489,  0x3c1004b},
        {-74480000,  18000000,  -71613000,  20113000,  0x0940011},
        {29337000,   -3431020,  29406200,   -3325000,  0x026000a}, // BDI
        {29209384,   -3492760,  29678104,   -3001720,  0x001000c},
        {29821812,   -3509180,  29971987,   -3359421,  0x680004b},
        {30252120,   -2943680,  30401879,   -2793921,  0x680004b},
        {29755520,   -2984280,  29905279,   -2834521,  0x680004b},
        {30164912,   -3544880,  30315087,   -3395121,  0x680004b},
        {29545120,   -2994880,  29694879,   -2845121,  0x680004b},
        {29582176,   -4009510,  29704824,   -3887201,  0x54f004b},
        {29912276,   -3997310,  30034924,   -3875001,  0x54f004b},
        {29742476,   -4204710,  29865124,   -4082401,  0x54f004b},
        {29058845,   -2961110,  29181154,   -2838801,  0x54f004b},
        {29162807,   -3023487,  29285116,   -2901178,  0x54f004b},
        {30117045,   -3144310,  30239354,   -3022001,  0x54f004b},
        {30478676,   -3271110,  30601324,   -3148801,  0x54f004b},
        {30038845,   -2641110,  30161154,   -2518801,  0x54f004b},
        {28987490,   -4470000,  30853880,   -2290000,  0x0b60011},
        {8751000,    3710000,   8819498,    3764600,   0x2a7044a}, // GNQ
        {9741445,    1820491,   9802554,    1881600,   0x2a7004a},
        {8510000,    3275000,   8940000,    3790000,   0x021000c},
        {9722144,    1781121,   9871903,    1930880,   0x680004b},
        {11184820,   2021620,   11334579,   2171379,   0x680004b},
        {9566096,    1505121,   9715855,    1654880,   0x680004b},
        {10808920,   1213220,   10958679,   1362979,   0x680004b},
        {10694120,   1791120,   10843879,   1940879,   0x680004b},
        {10468820,   1354920,   10618579,   1504679,   0x680004b},
        {11194020,   1547920,   11343779,   1697679,   0x680004b},
        {10587020,   996720,    10736779,   1146479,   0x680004b},
        {10538520,   2025220,   10688279,   2174979,   0x680004b},
        {10757445,   1518590,   10879754,   1640899,   0x54f004b},
        {11198845,   1068890,   11321154,   1191199,   0x54f004b},
        {5581011,    -1500854,  5703320,    -1378545,  0x001008c},
        {8336477,    3457937,   8664581,    3801665,   0x001088c},
        {8664581,    3457937,   8992685,    3801665,   0x001108c},
        {8336477,    3114209,   8664581,    3457937,   0x001188c},
        {8664581,    3114209,   8992685,    3457937,   0x001208c},
        {9478995,    1864952,   9947715,    2355992,   0x001508c},
        {9947715,    1717640,   10416435,   2208680,   0x001588c},
        {10416435,   1717640,   10885155,   2208680,   0x001608c},
        {10885155,   1717640,   11353875,   2208680,   0x001688c},
        {9010274,    1373912,   9478994,    1864952,   0x001708c},
        {9478994,    1373912,   9947714,    1864952,   0x001788c},
        {9947714,    1373912,   10416434,   1864952,   0x001808c},
        {10416434,   1373912,   10885154,   1864952,   0x001888c},
        {10885154,   1373912,   11353874,   1864952,   0x001908c},
        {9010274,    882872,    9478994,    1373912,   0x001a88c},
        {9478994,    882872,    9947714,    1373912,   0x001b08c},
        {9947714,    882872,    10416434,   1373912,   0x001b88c},
        {10416434,   981080,    10885154,   1472120,   0x001c08c},
        {10885154,   981080,    11353874,   1472120,   0x001c88c},
        {5581000,    -1501000,  11370000,   3810000,   0x0010216},
        {19756439,   41295355,  19870798,   41381845,  0x001000a}, // ALB
        {19382650,   41130380,  20002402,   41621420,  0x001000c},
        {20007021,   41062700,  20121379,   41149189,  0x3c1004b},
        {19482360,   42041400,  19598640,   42127889,  0x3c1004b},
        {19439681,   40437100,  19553318,   40523589,  0x3c1004b},
        {20729281,   40580600,  20842918,   40667089,  0x3c1004b},
        {19518981,   40678900,  19632618,   40765389,  0x3c1004b},
        {19902981,   40678600,  20016618,   40765089,  0x3c1004b},
        {19655581,   40867700,  19769218,   40954189,  0x3c1004b},
        {20638881,   40827600,  20752518,   40914089,  0x3c1004b},
        {19626940,   41605000,  19742259,   41691489,  0x3c1004b},
        {20113162,   40019200,  20225838,   40105689,  0x3c1004b},
        {19713981,   40554200,  19827618,   40640689,  0x3c1004b},
        {19849981,   40764600,  19963618,   40851089,  0x3c1004b},
        {20341360,   42022800,  20457640,   42109289,  0x3c1004b},
        {19578640,   41754400,  19693959,   41840889,  0x3c1004b},
        {19979642,   39834500,  20091357,   39920989,  0x3c1004b},
        {20341940,   41646800,  20457259,   41733289,  0x3c1004b},
        {19983840,   41565400,  20099159,   41651889,  0x3c1004b},
        {19946821,   40982600,  20061179,   41069089,  0x3c1004b},
        {20190681,   40443300,  20304318,   40529789,  0x3c1004b},
        {20272021,   41135400,  20386379,   41221889,  0x3c1004b},
        {19966462,   40267800,  20079138,   40354289,  0x3c1004b},
        {20015881,   40550100,  20129518,   40636589,  0x3c1004b},
        {20151681,   40813700,  20265318,   40900189,  0x3c1004b},
        {20198840,   41456300,  20314159,   41542789,  0x3c1004b},
        {20293762,   40199400,  20406438,   40285889,  0x3c1004b},
        {19491921,   40958100,  19606279,   41044589,  0x3c1004b},
        {19822340,   41726800,  19937659,   41813289,  0x3c1004b},
        {19408581,   40573500,  19522218,   40659989,  0x3c1004b},
        {19404481,   40715600,  19518118,   40802089,  0x3c1004b},
        {19546681,   40812800,  19660318,   40899289,  0x3c1004b},
        {19386260,   42171100,  19502540,   42257589,  0x3c1004b},
        {19200000,   39600000,  21100000,   42700000,  0x0f40011},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {19200000,   39600000,  21100000,   42700000,  0x003021c},
        {159914000,  -9458000,  160053000,  -9405000,  0x013000a}, // SLB
        {160644000,  -8930000,  161112100,  -8440000,  0x001000c},
        {159909999,  -9564924,  160084900,  -9391945,  0x782004b},
        {160084900,  -9564924,  160259801,  -9391945,  0x782004b},
        {156745348,  -8169192,  156919768,  -7996213,  0x782004b},
        {159532790,  -8298383,  159707210,  -8125404,  0x782004b},
        {160062549,  -9144000,  160254194,  -8986213,  0x782044b},
        {160236000,  -9193788,  160414086,  -9024000,  0x782044b},
        {161792069,  -10612979, 161967931,  -10440000, 0x782004b},
        {168750360,  -12355846, 168903447,  -12206087, 0x680004b},
        {155880000,  -8846000,  158750000,  -6570000,  0x01b000d},
        {158750000,  -9964000,  161591000,  -7474400,  0x09e0011},
        {155470000,  -7433255,  155938720,  -6942215,  0x0b10090},
        {159110983,  -5491040,  159579703,  -5000000,  0x0b00890},
        {159345343,  -5687420,  159814063,  -5196380,  0x0b01090},
        {159748247,  -11756057, 160222175,  -11265017, 0x0b11890},
        {160222175,  -11952473, 160696103,  -11461433, 0x0b12090},
        {161171712,  -10621684, 161645640,  -10130644, 0x0b12890},
        {161588768,  -10835412, 162062696,  -10344372, 0x0b13090},
        {162062696,  -10935412, 162536624,  -10444372, 0x0b13890},
        {161728710,  -10112070, 162202638,  -9621030,  0x0b04090},
        {161655639,  -10372580, 162129567,  -9881540,  0x0b04890},
        {166943521,  -10113021, 167417449,  -9621981,  0x0b05090},
        {165524550,  -10464480, 165998478,  -9973440,  0x0b15890},
        {165998478,  -10464480, 166472406,  -9973440,  0x0b16090},
        {165714122,  -10955520, 166188050,  -10464480, 0x0b16890},
        {166282835,  -11495664, 166756763,  -11004624, 0x0b17090},
        {166658951,  -11892376, 167132879,  -11401336, 0x0b17890},
        {155470000,  -12355900, 168903500,  -5000000,  0x0010016},
        {44452394,   40135449,  44565070,   40221938,  0x001000a}, // ARM
        {44143000,   40026600,  44713000,   40540000,  0x020000c},
        {44703650,   40470890,  44864350,   40593199,  0x54f004b},
        {44864350,   40470890,  45025050,   40593199,  0x54f004b},
        {44704329,   40348581,  44863670,   40470890,  0x54f004b},
        {44492129,   39913590,  44651470,   40035899,  0x54f004b},
        {44579409,   39806190,  44737391,   39928499,  0x54f004b},
        {46295609,   39438190,  46453591,   39560499,  0x54f004b},
        {44397750,   40838890,  44558450,   40961199,  0x54f004b},
        {43853850,   40556290,  44014550,   40678599,  0x54f004b},
        {45080050,   40827390,  45240750,   40949699,  0x54f004b},
        {45981909,   39460890,  46139891,   39583199,  0x54f004b},
        {44600721,   41042600,  44715079,   41129089,  0x3c1004b},
        {44830181,   40730900,  45012758,   40784689,  0x3c1044b},
        {44332821,   40966800,  44447179,   41053289,  0x3c1004b},
        {45673162,   40149900,  45785838,   40236389,  0x3c1004b},
        {43971562,   40106800,  44084238,   40193289,  0x3c1004b},
        {44353000,   39962433,  44497099,   40030000,  0x3c1044b},
        {45296342,   39719100,  45408057,   39805589,  0x3c1004b},
        {43801581,   40754100,  43915218,   40840589,  0x3c1004b},
        {44414300,   40775000,  44550286,   40847200,  0x3c1044b},
        {46349000,   39167600,  46483787,   39238700,  0x3c1044b},
        {45096800,   40279100,  45186495,   40387700,  0x3c1044b},
        {43440000,   38830000,  46645000,   41305000,  0x0a70011},
        {27455206,   -29379245, 27553228,   -29292755, 0x001000a}, // LSO
        {27383756,   -29555520, 27914972,   -29064480, 0x001000c},
        {27179077,   -29927190, 27377522,   -29754211, 0x782004b},
        {27745158,   -29031490, 27942642,   -28858511, 0x782004b},
        {27990938,   -28982490, 28187461,   -28809511, 0x782004b},
        {27364797,   -30256990, 27564203,   -30084011, 0x782004b},
        {28932558,   -29367190, 29130042,   -29194211, 0x782004b},
        {28518277,   -29614690, 28716722,   -29441711, 0x782004b},
        {28598297,   -30144390, 28797703,   -29971411, 0x782004b},
        {27603980,   -30464680, 27776619,   -30314921, 0x680004b},
        {27011000,   -30678000, 29457000,   -28570000, 0x0a60011},
        {4309240,    50817496,  4404978,    50878605,  0x2a7004a}, // BEL
        {4371622,    51182571,  4468378,    51243680,  0x2a7004a},
        {3985000,    50740000,  4645000,    51270000,  0x021000c},
        {3623172,    50988890,  3816828,    51111199,  0x54f004b},
        {3133172,    51141590,  3326828,    51263899,  0x54f004b},
        {4760591,    50408890,  4952209,    50531199,  0x54f004b},
        {4307091,    50358890,  4498709,    50481199,  0x54f004b},
        {4498709,    50358890,  4690327,    50481199,  0x54f004b},
        {4644445,    50836800,  4779945,    50923289,  0x3c1004b},
        {3836350,    50395400,  3971850,    50481889,  0x3c1004b},
        {5137829,    51006800,  5274770,    51093289,  0x3c1004b},
        {5247829,    50886800,  5384770,    50973289,  0x3c1004b},
        {2851529,    51176800,  2988470,    51263289,  0x3c1004b},
        {3312250,    50582700,  3447750,    50669189,  0x3c1004b},
        {5431529,    50948400,  5568470,    51034889,  0x3c1004b},
        {3093029,    50898200,  3229970,    50984689,  0x3c1004b},
        {5822550,    50545400,  5958050,    50631889,  0x3c1004b},
        {3179350,    50709620,  3331065,    50786800,  0x3c1044b},
        {3202250,    50786800,  3337750,    50873289,  0x3c1004b},
        {4162250,    50429500,  4297750,    50515989,  0x3c1004b},
        {5541750,    50627600,  5677250,    50714089,  0x3c1004b},
        {5406250,    50627600,  5541750,    50714089,  0x3c1004b},
        {5406250,    50541111,  5541750,    50627600,  0x3c1004b},
        {5541750,    50541111,  5677250,    50627600,  0x3c1004b},
        {4863729,    51275200,  5000670,    51361689,  0x3c1004b},
        {4642700,    51037600,  4779641,    51124089,  0x3c1004b},
        {5098650,    50789100,  5234150,    50875589,  0x3c1004b},
        {5055229,    51142200,  5192170,    51228689,  0x3c1004b},
        {4390000,    51269200,  4577671,    51332200,  0x3c1044b},
        {4846014,    49606348,  5444934,    50015548,  0x001c88c},
        {5325150,    49463128,  5924070,    49872328,  0x001d08c},
        {4110123,    49933708,  4719459,    50342908,  0x001a88c},
        {4719459,    49872328,  5328795,    50281528,  0x001b08c},
        {5328795,    49872328,  5938131,    50281528,  0x001b88c},
        {5694397,    49872328,  6303733,    50281528,  0x001c08c},
        {3226586,    50281528,  3835922,    50690728,  0x001688c},
        {3835922,    50281528,  4445258,    50690728,  0x001708c},
        {4445258,    50281528,  5054594,    50690728,  0x001788c},
        {5054594,    50281528,  5663930,    50690728,  0x001808c},
        {5663930,    50281528,  6273266,    50690728,  0x001888c},
        {5816264,    50281528,  6425600,    50690728,  0x001908c},
        {2520642,    50690728,  3135186,    51099928,  0x001388c},
        {3135186,    50690728,  3749730,    51099928,  0x001408c},
        {3749730,    50690728,  4364274,    51099928,  0x001488c},
        {4364274,    50690728,  4978818,    51099928,  0x001508c},
        {4978818,    50690728,  5593362,    51099928,  0x001588c},
        {5531907,    50690728,  6146451,    51099928,  0x001608c},
        {2514496,    51099928,  3134248,    51509128,  0x001088c},
        {3134248,    50977168,  3754000,    51386368,  0x001108c},
        {3754000,    50977168,  4373752,    51386368,  0x001188c},
        {4373752,    51099928,  4993504,    51509128,  0x001208c},
        {4993504,    51099928,  5613256,    51509128,  0x001288c},
        {5241405,    50895328,  5861157,    51304528,  0x001308c},
        {-5200000,   41310000,  9600000,    53557000,  0x0010216},
        {2495000,    49463000,  6426400,    51509200,  0x003021c},
        {28780035,   46980755,  28905926,   47067245,  0x001000a}, // MDA
        {28503980,   46778480,  29186228,   47269520,  0x001000c},
        {29558135,   46811100,  29684265,   46897589,  0x3c1004b},
        {27839934,   47718400,  27968466,   47804889,  0x3c1004b},
        {29449335,   46786900,  29575465,   46873389,  0x3c1004b},
        {28916434,   47732900,  29044966,   47819389,  0x3c1004b},
        {28146736,   45878000,  28270463,   45964489,  0x3c1004b},
        {28203634,   48113300,  28332166,   48199789,  0x3c1004b},
        {27746935,   47166800,  27873065,   47253289,  0x3c1004b},
        {29061534,   47239400,  29188865,   47325889,  0x3c1004b},
        {28743634,   47333800,  28870965,   47420289,  0x3c1004b},
        {28595635,   46271400,  28720564,   46357889,  0x3c1004b},
        {28757036,   46039300,  28880763,   46125789,  0x3c1004b},
        {27787834,   48018800,  27916366,   48105289,  0x3c1004b},
        {29322535,   46596800,  29447464,   46683289,  0x3c1004b},
        {27204334,   48148400,  27332866,   48234889,  0x3c1004b},
        {27624534,   47536800,  27751865,   47623289,  0x3c1004b},
        {28787234,   47669800,  28914565,   47756289,  0x3c1004b},
        {29591235,   46725600,  29717365,   46812089,  0x3c1004b},
        {28253934,   47224200,  28381265,   47310689,  0x3c1004b},
        {28204634,   47829000,  28333166,   47915489,  0x3c1004b},
        {28362936,   45636800,  28486663,   45723289,  0x3c1004b},
        {27451534,   47916600,  27580066,   48003089,  0x3c1004b},
        {28717035,   46503100,  28841964,   46589589,  0x3c1004b},
        {28148435,   47046800,  28274565,   47133289,  0x3c1004b},
        {28576536,   45850100,  28700263,   45936589,  0x3c1004b},
        {29817935,   46569200,  29942864,   46655689,  0x3c1004b},
        {28660734,   47957900,  28789266,   48044389,  0x3c1004b},
        {27558434,   48188700,  27686966,   48275189,  0x3c1004b},
        {27427134,   47757300,  27555666,   47843789,  0x3c1004b},
        {27452425,   48376250,  27545574,   48438349,  0x2b2004b},
        {26998628,   48183940,  27087972,   48244059,  0x29c004b},
        {28210350,   46448550,  28300049,   46510649,  0x2b2004b},
        {29260063,   47108440,  29347737,   47168559,  0x29c004b},
        {29685919,   46666350,  29776480,   46728449,  0x2b2004b},
        {28329945,   47469640,  28418454,   47529759,  0x29c004b},
        {26582604,   48008960,  27275268,   48500000,  0x001008c},
        {27275268,   48008960,  27967932,   48500000,  0x001088c},
        {27967932,   48008960,  28660596,   48500000,  0x001108c},
        {28660596,   48008960,  29353260,   48500000,  0x001188c},
        {26582604,   47517920,  27270060,   48008960,  0x001208c},
        {27270060,   47517920,  27957516,   48008960,  0x001288c},
        {27957516,   47517920,  28644972,   48008960,  0x001308c},
        {28644972,   47517920,  29332428,   48008960,  0x001388c},
        {27275268,   47026880,  27957516,   47517920,  0x001408c},
        {27957516,   47026880,  28639764,   47517920,  0x001488c},
        {28639764,   47026880,  29322012,   47517920,  0x001508c},
        {29322012,   47026880,  30004260,   47517920,  0x001588c},
        {27957516,   46535840,  28634556,   47026880,  0x001608c},
        {28634556,   46535840,  29311596,   47026880,  0x001688c},
        {29311596,   46535840,  29988636,   47026880,  0x001708c},
        {27962724,   46044800,  28629348,   46535840,  0x001788c},
        {28629348,   46044800,  29295972,   46535840,  0x001808c},
        {29295972,   46300000,  30183000,   46535840,  0x012888c},
        {28070000,   45460000,  28562685,   46044800,  0x027908c},
        {28562685,   45553760,  29224101,   46044800,  0x001988c},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {26580000,   45460000,  30183000,   48500000,  0x003021c},
        {-15655500,  11833600,  -15573000,  11920000,  0x001000a}, // GNB
        {-15969000,  11733300,  -15360432,  12117500,  0x018000c},
        {-14792712,  12067010,  -14615889,  12239989,  0x782004b},
        {-14262512,  12176310,  -14085689,  12349289,  0x782004b},
        {-15513012,  12143510,  -15336189,  12316489,  0x782004b},
        {-15634000,  11501000,  -15413067,  11639000,  0x782044b},
        {-16109336,  11992120,  -15956665,  12141879,  0x680004b},
        {-15910236,  11186920,  -15757565,  11336679,  0x680004b},
        {-15313836,  11207120,  -15161165,  11356879,  0x680004b},
        {-15375936,  11998620,  -15223265,  12148379,  0x680004b},
        {-15088036,  11510320,  -14935365,  11660079,  0x680004b},
        {-16860000,  10800000,  -13600000,  12700000,  0x0810011},
        {-16860000,  4340000,   4000000,    15120000,  0x2a30216},
        {-16860000,  10800000,  -13600000,  12700000,  0x003021c},
        {121449531,  25006800,  121544669,  25093289,  0x001000a}, // TWN
        {121150000,  24816000,  121813000,  25190000,  0x017000c},
        {120912730,  24758890,  121047270,  24881199,  0x54f004b},
        {120246552,  22596800,  120340248,  22683289,  0x3c1004b},
        {120340248,  22596800,  120433944,  22683289,  0x3c1004b},
        {120368596,  22510311,  120461812,  22596800,  0x3c1004b},
        {120275380,  22510311,  120368596,  22596800,  0x3c1004b},
        {120651571,  24193300,  120746228,  24279789,  0x3c1004b},
        {120642225,  24106811,  120736642,  24193300,  0x3c1004b},
        {120642225,  24020322,  120736642,  24106811,  0x3c1004b},
        {121651631,  24708400,  121746769,  24794889,  0x3c1004b},
        {121737255,  24751644,  121832393,  24838133,  0x3c1004b},
        {121604302,  24621911,  121698959,  24708400,  0x3c1004b},
        {121698959,  24621911,  121793616,  24708400,  0x3c1004b},
        {121746047,  24665155,  121841185,  24751644,  0x3c1004b},
        {121793856,  24578666,  121888513,  24665155,  0x3c1004b},
        {120152552,  22956800,  120246248,  23043289,  0x3c1004b},
        {120246248,  22956800,  120339944,  23043289,  0x3c1004b},
        {120396532,  23432100,  120490468,  23518589,  0x3c1004b},
        {120501191,  24036000,  120595608,  24122489,  0x3c1004b},
        {120442752,  22627700,  120536448,  22714189,  0x3c1004b},
        {121086852,  22721000,  121180548,  22807489,  0x3c1004b},
        {120508991,  23902000,  120603408,  23988489,  0x3c1004b},
        {120527399,  23673325,  120621816,  23759814,  0x3c1004b},
        {120506271,  24190500,  120600928,  24276989,  0x3c1004b},
        {121555191,  23950700,  121649608,  24037189,  0x3c1004b},
        {120635091,  23935700,  120729508,  24022189,  0x3c1004b},
        {120635091,  23849211,  120729508,  23935700,  0x3c1004b},
        {120228652,  22742200,  120322348,  22828689,  0x3c1004b},
        {120842431,  24647100,  120937569,  24733589,  0x3c1004b},
        {120776471,  24523500,  120871128,  24609989,  0x3c1004b},
        {120912791,  23926800,  121007208,  24013289,  0x3c1004b},
        {120518196,  24818960,  121033788,  25310000,  0x001008c},
        {121033788,  24818960,  121549380,  25310000,  0x001088c},
        {121549380,  24818960,  122064972,  25310000,  0x001108c},
        {120415077,  24327920,  120925461,  24818960,  0x001188c},
        {120925461,  24327920,  121435845,  24818960,  0x001208c},
        {121435845,  24327920,  121946229,  24818960,  0x001288c},
        {119904693,  23836880,  120415077,  24327920,  0x001308c},
        {120415077,  23836880,  120925461,  24327920,  0x001388c},
        {120925461,  23836880,  121435845,  24327920,  0x001408c},
        {121435845,  23836880,  121946229,  24327920,  0x001488c},
        {120088536,  23345840,  120593712,  23836880,  0x001508c},
        {120593712,  23345840,  121098888,  23836880,  0x001588c},
        {121098888,  23345840,  121604064,  23836880,  0x001608c},
        {120012759,  22854800,  120517935,  23345840,  0x001688c},
        {120517935,  22854800,  121023111,  23345840,  0x001708c},
        {121023111,  22854800,  121528287,  23345840,  0x001788c},
        {120012759,  22363760,  120517935,  22854800,  0x001808c},
        {120517935,  22363760,  121023111,  22854800,  0x001888c},
        {121023111,  22363760,  121528287,  22854800,  0x001908c},
        {120012759,  21872720,  120512727,  22363760,  0x001988c},
        {120512727,  21872720,  121012695,  22363760,  0x001a08c},
        {121262679,  21872720,  121762647,  22363760,  0x001b88c},
        {119281266,  23378875,  119786442,  23869915,  0x001a88c},
        {119281266,  22887835,  119786442,  23378875,  0x001b08c},
        {118122940,  24320194,  118492355,  24542126,  0x001c08c},
        {119392453,  24925751,  119491405,  25023959,  0x001d88c},
        {119888306,  25920379,  120083313,  26306957,  0x001e08c},
        {121868618,  25370388,  122175890,  25665012,  0x001e88c},
        {120099346,  25907927,  120614938,  26398967,  0x001f08c},
        {118122500,  21750000,  122500000,  26400500,  0x0010216},
        {89603000,   27430000,  89671500,   27547000,  0x02a000a}, // BTN
        {89457280,   27227180,  89978080,   27718220,  0x001000c},
        {89311541,   26786690,  89448459,   26908999,  0x54f004b},
        {91436341,   26789590,  91573259,   26911899,  0x54f004b},
        {90181541,   26808890,  90318459,   26931199,  0x54f004b},
        {89316801,   27378890,  89454398,   27501199,  0x54f004b},
        {91501201,   27268890,  91638798,   27391199,  0x54f004b},
        {89811541,   27008890,  89948459,   27131199,  0x54f004b},
        {90437601,   27440890,  90575198,   27563199,  0x54f004b},
        {90055641,   26946590,  90192559,   27068899,  0x54f004b},
        {91110701,   27588890,  91248298,   27711199,  0x54f004b},
        {90674301,   27503890,  90811898,   27626199,  0x54f004b},
        {91339990,   26996000,  91436809,   27082489,  0x3c1004b},
        {89680910,   27863200,  89778690,   27949689,  0x3c1004b},
        {89224450,   27352800,  89321750,   27439289,  0x3c1004b},
        {91190590,   27232400,  91287409,   27318889,  0x3c1004b},
        {89516290,   27020500,  89613109,   27106989,  0x3c1004b},
        {90642390,   27100200,  90739209,   27186689,  0x3c1004b},
        {90442190,   26832300,  90539009,   26918789,  0x3c1004b},
        {89474890,   26879500,  89571709,   26965989,  0x3c1004b},
        {89490990,   27125600,  89587809,   27212089,  0x3c1004b},
        {90388090,   27006400,  90484909,   27092889,  0x3c1004b},
        {90880350,   27445300,  90977650,   27531789,  0x3c1004b},
        {88730000,   26698900,  92135000,   28370000,  0x07c0011},
        {8508200,    47358400,  8571799,    47401599,  0x1e0004a}, // CHE
        {6108800,    46179800,  6171199,    46222999,  0x1e0004a},
        {7561200,    47521400,  7624799,    47564599,  0x1e0004a},
        {7414800,    46928400,  7477799,    46971599,  0x1e0004a},
        {8153000,    47150000,  8926000,    47572700,  0x01b000c},
        {7517067,    47461490,  7697133,    47583799,  0x54f004b},
        {7350816,    46888890,  7529183,    47011199,  0x54f004b},
        {6105665,    46152590,  6282334,    46274899,  0x54f004b},
        {5952215,    46126890,  6127185,    46249199,  0x54f004b},
        {6459100,    46491000,  6716109,    46575000,  0x54f044b},
        {9229667,    47377590,  9409733,    47499899,  0x54f004b},
        {8210816,    46980590,  8389183,    47102899,  0x54f004b},
        {7187616,    47053790,  7365983,    47176099,  0x54f004b},
        {7545816,    46676990,  7724183,    46799299,  0x54f004b},
        {6709316,    47019890,  6887683,    47142199,  0x54f004b},
        {8556334,    47645200,  8683665,    47731689,  0x3c1004b},
        {7076935,    46766800,  7203065,    46853289,  0x3c1004b},
        {9444235,    46825400,  9570365,    46911889,  0x3c1004b},
        {6829235,    46936500,  6955365,    47022989,  0x3c1004b},
        {7279535,    46184000,  7404464,    46270489,  0x3c1004b},
        {8870636,    45968200,  8994363,    46054689,  0x3c1004b},
        {6814635,    46408900,  6939564,    46495389,  0x3c1004b},
        {8920736,    45827000,  9044463,    45913489,  0x3c1004b},
        {6602735,    46741400,  6728865,    46827889,  0x3c1004b},
        {7971000,    47344400,  8133709,    47412000,  0x3c1044b},
        {6162835,    46350700,  6287764,    46437189,  0x3c1004b},
        {5920000,    45800000,  10495000,   47820000,  0x0860011},
        {5850000,    35450000,  18560000,   55080000,  0x50a0216},
        {5920000,    45800000,  10495000,   47820000,  0x003021c},
        {4865037,    52348840,  4927562,    52387449,  0x1ad004a}, // NLD
        {4448737,    51910740,  4511262,    51949349,  0x1ad004a},
        {4276537,    52056640,  4339062,    52095249,  0x1ad004a},
        {5078737,    52080740,  5141262,    52119349,  0x1ad004a},
        {5446459,    51420740,  5508341,    51459349,  0x1ad004a},
        {4557401,    52041272,  5312561,    52532312,  0x001000c},
        {6826868,    52168200,  6966932,    52254689,  0x3c1004b},
        {5839968,    51925200,  5980032,    52011689,  0x3c1004b},
        {4700688,    51545400,  4839311,    51631889,  0x3c1004b},
        {4513588,    51875900,  4652211,    51962389,  0x3c1004b},
        {4289968,    51969100,  4430032,    52055589,  0x3c1004b},
        {5309968,    52121100,  5450032,    52207589,  0x3c1004b},
        {6489666,    53169500,  6633334,    53255989,  0x3c1004b},
        {4182268,    52036800,  4322332,    52123289,  0x3c1004b},
        {5247588,    51656800,  5386211,    51743289,  0x3c1004b},
        {4600688,    51774100,  4739311,    51860589,  0x3c1004b},
        {5746466,    53153800,  5890134,    53240289,  0x3c1004b},
        {5635750,    50815400,  5771250,    50901889,  0x3c1004b},
        {5752988,    51779500,  5891611,    51865989,  0x3c1004b},
        {5903768,    52159500,  6043832,    52245989,  0x3c1004b},
        {4153920,    51896000,  4375487,    51950000,  0x3c1044b},
        {4375288,    51867300,  4513911,    51953789,  0x3c1004b},
        {4250688,    51806800,  4389311,    51893289,  0x3c1004b},
        {4986888,    51509500,  5125511,    51595989,  0x3c1004b},
        {5386888,    51405400,  5525511,    51491889,  0x3c1004b},
        {5589668,    51952000,  5704955,    52057000,  0x3c1044b},
        {4320000,    52055000,  4440971,    52155000,  0x3c1044b},
        {4426868,    51996500,  4566932,    52082989,  0x3c1004b},
        {4419968,    52126800,  4560032,    52213289,  0x3c1004b},
        {6019127,    52459400,  6160873,    52545889,  0x3c1004b},
        {5776629,    50947300,  5913570,    51033789,  0x3c1004b},
        {5902829,    50866200,  6039770,    50952689,  0x3c1004b},
        {4714627,    52609300,  4856373,    52695789,  0x3c1004b},
        {6100829,    51338200,  6237770,    51424689,  0x3c1004b},
        {6090168,    52206300,  6230232,    52292789,  0x3c1004b},
        {5607434,    51454350,  5706965,    51516449,  0x2b2004b},
        {6737320,    52243240,  6834680,    52303359,  0x29c004b},
        {4410634,    51500750,  4510165,    51562849,  0x2b2004b},
        {6602720,    52324840,  6700080,    52384959,  0x29c004b},
        {5573755,    50743216,  6219547,    51174240,  0x001f08c},
        {5586670,    51174240,  6237670,    51605264,  0x001e88c},
        {4935670,    51174240,  5586670,    51605264,  0x001e08c},
        {4284670,    51174240,  4935670,    51605264,  0x001d08c},
        {3633670,    51174240,  4284670,    51605264,  0x001c88c},
        {2982670,    51174240,  3633670,    51605264,  0x001c08c},
        {6219442,    51605264,  6875650,    52036288,  0x001b88c},
        {5563234,    51605264,  6219442,    52036288,  0x001b08c},
        {4907026,    51605264,  5563234,    52036288,  0x001a88c},
        {4250818,    51605264,  4907026,    52036288,  0x001908c},
        {3594610,    51605264,  4250818,    52036288,  0x001888c},
        {6509528,    52036288,  7176152,    52467312,  0x001788c},
        {5842904,    52036288,  6509528,    52467312,  0x001708c},
        {5176280,    52036288,  5842904,    52467312,  0x001688c},
        {4509656,    52036288,  5176280,    52467312,  0x001608c},
        {3843032,    52036288,  4509656,    52467312,  0x001588c},
        {6509528,    52467312,  7181360,    52898336,  0x001508c},
        {5837696,    52467312,  6509528,    52898336,  0x001488c},
        {5165864,    52467312,  5837696,    52898336,  0x001408c},
        {4494032,    52467312,  5165864,    52898336,  0x001388c},
        {6576711,    52898336,  7248543,    53329360,  0x001308c},
        {5904879,    52898336,  6576711,    53329360,  0x001288c},
        {5233047,    52898336,  5904879,    53329360,  0x001208c},
        {4561215,    52898336,  5233047,    53329360,  0x001188c},
        {6269179,    53125976,  6951427,    53557000,  0x001108c},
        {5586931,    53125976,  6269179,    53557000,  0x001088c},
        {4904683,    53125976,  5586931,    53557000,  0x001008c},
        {-5200000,   41310000,  9600000,    53557000,  0x0010216},
        {3350000,    50747000,  7236000,    53557000,  0x003021c},
        {12481681,   55638755,  12634480,   55725245,  0x001000a}, // DNK
        {11866628,   55429584,  12684284,   55920624,  0x001000c},
        {12215381,   55921600,  12368419,   56008089,  0x3c1004b},
        {10083081,   56093400,  10236119,   56179889,  0x3c1004b},
        {10158520,   56179900,  10313480,   56266389,  0x3c1004b},
        {10319462,   55336900,  10470338,   55423389,  0x3c1004b},
        {9859339,    57002400,  10016461,   57088889,  0x3c1004b},
        {8364762,    55449000,  8515638,    55535489,  0x3c1004b},
        {9962120,    56411800,  10117080,   56498289,  0x3c1004b},
        {9416862,    55446800,  9567738,    55533289,  0x3c1004b},
        {9777381,    55809600,  9930419,    55896089,  0x3c1004b},
        {11681562,   55186500,  11832438,   55272989,  0x3c1004b},
        {9480120,    56125400,  9635080,    56211889,  0x3c1004b},
        {9651762,    55515200,  9802638,    55601689,  0x3c1004b},
        {12473081,   55968300,  12626119,   56054789,  0x3c1004b},
        {9332520,    56399500,  9487480,    56485989,  0x3c1004b},
        {8527220,    56316800,  8682180,    56403289,  0x3c1004b},
        {8885881,    56095400,  9038919,    56181889,  0x3c1004b},
        {10403137,   57415400,  10562662,   57501889,  0x3c1004b},
        {9481681,    55666800,  9634719,    55753289,  0x3c1004b},
        {11294362,   55366800,  11445238,   55453289,  0x3c1004b},
        {8942520,    56526800,  9097480,    56613289,  0x3c1004b},
        {10558525,   55034250,  10665474,   55096349,  0x2b2004b},
        {9734930,    54887540,  9838469,    54947659,  0x29c004b},
        {9936030,    57428050,  10050569,   57490149,  0x2b2004b},
        {11656311,   55688240,  11762689,   55748359,  0x29c004b},
        {9428935,    55222450,  9537264,    55284549,  0x2b2004b},
        {11751162,   55417640,  11856037,   55477759,  0x29c004b},
        {11816525,   54738950,  11923474,   54801049,  0x2b2004b},
        {9367330,    55013540,  9470869,    55073659,  0x29c004b},
        {11027959,   55647950,  11137840,   55710049,  0x2b2004b},
        {10736562,   55289740,  10841437,   55349859,  0x29c004b},
        {11091335,   55311150,  11199664,   55373249,  0x2b2004b},
        {9101843,    56104740,  9209557,    56164859,  0x29c004b},
        {10828069,   56383650,  10939330,   56445749,  0x2b2004b},
        {11090630,   54806340,  11194169,   54866459,  0x29c004b},
        {14681835,   55080950,  14790164,   55143049,  0x2b2004b},
        {9701962,    55458340,  9806837,    55518459,  0x29c004b},
        {9883659,    56010450,  9993540,    56072549,  0x2b2004b},
        {8643691,    56942440,  8752908,    57002559,  0x29c004b},
        {8431059,    55587150,  8540940,    55649249,  0x2b2004b},
        {11937711,   55958740,  12044089,   56018859,  0x29c004b},
        {9899630,    57243750,  10014169,   57305849,  0x2b2004b},
        {8531243,    56460940,  8638957,    56521059,  0x29c004b},
        {8067764,    54800231,  8875004,    55291271,  0x001008c},
        {8875004,    54800231,  9682244,    55291271,  0x001088c},
        {9682244,    54800231,  10489484,   55291271,  0x001108c},
        {8062556,    55291271,  8880212,    55782311,  0x001288c},
        {8880212,    55291271,  9697868,    55782311,  0x001308c},
        {9697868,    55291271,  10515524,   55782311,  0x001388c},
        {8057348,    55782311,  8885420,    56273351,  0x001588c},
        {8885420,    55782311,  9713492,    56273351,  0x001608c},
        {9713492,    55782311,  10541564,   56273351,  0x001688c},
        {8052140,    56273351,  8890628,    56764391,  0x001888c},
        {8890628,    56273351,  9729116,    56764391,  0x001908c},
        {9729116,    56273351,  10567604,   56764391,  0x001988c},
        {8046932,    56764391,  8895836,    57255431,  0x001a88c},
        {8895836,    56764391,  9744740,    57255431,  0x001b08c},
        {9744740,    56764391,  10593644,   57255431,  0x001b88c},
        {9055200,    57255431,  9919728,    57746471,  0x001c08c},
        {9919728,    57255431,  10700000,   57760000,  0x021c88c},
        {10479068,   56086810,  11307140,   56577850,  0x001a08c},
        {10479068,   55595770,  11307140,   56086810,  0x001708c},
        {10484276,   55104730,  11301932,   55595770,  0x001408c},
        {10489484,   54613690,  11296724,   55104730,  0x001188c},
        {11296724,   54559675,  12103964,   55050715,  0x001208c},
        {11291516,   55050715,  12109172,   55541755,  0x001488c},
        {11291516,   55541755,  12109172,   56032795,  0x001788c},
        {11981315,   55652239,  12809387,   56143279,  0x001808c},
        {11986523,   55161199,  12804179,   55652239,  0x001508c},
        {11991731,   54670159,  12798971,   55161199,  0x001d08c},
        {11461157,   56048697,  11955917,   56343321,  0x001d88c},
        {10776112,   57119823,  11286496,   57414447,  0x001e08c},
        {11418030,   56614292,  11751342,   56810708,  0x001e88c},
        {14631144,   54973254,  15224856,   55333350,  0x001f08c},
        {11690000,   54550000,  12170000,   55000000,  0x001f088},
        {4490000,    54544000,  31600000,   68600000,  0x3770216},
        {8000000,    54544000,  15198000,   57780000,  0x003021c},
        {24636000,   59396800,  24854000,   59460000,  0x017000a}, // EST
        {24032000,   59283800,  25510000,   59572000,  0x012000c},
        {26605576,   58307190,  26837624,   58429499,  0x54f004b},
        {27980908,   59327090,  28220091,   59449399,  0x54f004b},
        {27129308,   59333690,  27368491,   59455999,  0x54f004b},
        {24471576,   58327490,  24703624,   58449799,  0x54f004b},
        {25483976,   58308890,  25716024,   58431199,  0x54f004b},
        {26250308,   59286490,  26489491,   59408799,  0x54f004b},
        {27676708,   59297290,  27915891,   59419599,  0x54f004b},
        {22366176,   58211990,  22598224,   58334299,  0x54f004b},
        {26895675,   57788890,  27124325,   57911199,  0x54f004b},
        {25935675,   57718890,  26164325,   57841199,  0x54f004b},
        {23501954,   58896500,  23668446,   58982989,  0x3c1004b},
        {27365832,   59293400,  27534967,   59379889,  0x3c1004b},
        {25518854,   58852100,  25685346,   58938589,  0x3c1004b},
        {26896232,   59302100,  27065367,   59388589,  0x3c1004b},
        {25881554,   59219600,  26048046,   59306089,  0x3c1004b},
        {26990556,   58013500,  27152243,   58099989,  0x3c1004b},
        {26333455,   58701000,  26497544,   58787489,  0x3c1004b},
        {25346754,   58776800,  25513246,   58863289,  0x3c1004b},
        {26319156,   58186800,  26480843,   58273289,  0x3c1004b},
        {24716754,   58966800,  24883246,   59053289,  0x3c1004b},
        {25847155,   58628000,  26011244,   58714489,  0x3c1004b},
        {23340000,   59225960,  24450605,   59616000,  0x018088c},
        {24450605,   59225960,  25351589,   59717000,  0x001108c},
        {25351589,   59225960,  26252573,   59717000,  0x001188c},
        {26252573,   59225960,  27153557,   59717000,  0x001208c},
        {27153557,   59225960,  28230000,   59600000,  0x018288c},
        {21702604,   58734920,  22603588,   59225960,  0x001308c},
        {22603587,   58734920,  23504571,   59225960,  0x001388c},
        {23504571,   58734920,  24405555,   59225960,  0x001408c},
        {24405555,   58734920,  25306539,   59225960,  0x001488c},
        {25306539,   58734920,  26207523,   59225960,  0x001508c},
        {26207523,   58734920,  27108507,   59225960,  0x001588c},
        {27108507,   58734920,  28009491,   59225960,  0x001608c},
        {21707811,   58243880,  22593171,   58734920,  0x001688c},
        {22593171,   58243880,  23478531,   58734920,  0x001708c},
        {23478531,   58243880,  24363891,   58734920,  0x001788c},
        {24363891,   58243880,  25249251,   58734920,  0x001808c},
        {25249251,   58243880,  26134611,   58734920,  0x001888c},
        {26134611,   58243880,  27019971,   58734920,  0x001908c},
        {27019971,   58243880,  27905331,   58734920,  0x001988c},
        {21713020,   57752840,  22587964,   58243880,  0x001a08c},
        {22587964,   57752840,  23462908,   58243880,  0x001a88c},
        {23462908,   57752840,  24337852,   58243880,  0x001b08c},
        {24337852,   57752840,  25212796,   58243880,  0x001b88c},
        {25212796,   57752840,  26087740,   58243880,  0x001c08c},
        {26087740,   57752840,  26962684,   58243880,  0x001c88c},
        {26962684,   57752840,  27837628,   58243880,  0x001d08c},
        {26120000,   57500000,  27555000,   57752840,  0x011d88c},
        {25351589,   59717000,  27153557,   59822030,  0x00ae08c},
        {14105000,   48990000,  32794200,   59822030,  0x0010216},
        {21700000,   57500000,  28250000,   59822030,  0x003021c},
        {-69936000,  18456428,  -69828000,  18523000,  0x018000a}, // DOM
        {-70219200,  18229000,  -69589555,  18605000,  0x017000c},
        {-70759175,  19412800,  -70667401,  19499289,  0x3c1004b},
        {-70667401,  19421449,  -70575627,  19507938,  0x3c1004b},
        {-69045127,  18392700,  -68954074,  18479189,  0x3c1004b},
        {-69340827,  18422100,  -69249774,  18508589,  0x3c1004b},
        {-70737587,  19748800,  -70645813,  19835289,  0x3c1004b},
        {-70310247,  19256600,  -70218953,  19343089,  0x3c1004b},
        {-70575547,  19180400,  -70484253,  19266889,  0x3c1004b},
        {-70453647,  18891900,  -70362353,  18978389,  0x3c1004b},
        {-71155607,  18173600,  -71064794,  18260089,  0x3c1004b},
        {-71275527,  18766800,  -71184474,  18853289,  0x3c1004b},
        {-68764027,  18573300,  -68672974,  18659789,  0x3c1004b},
        {-70571347,  19357700,  -70480053,  19444189,  0x3c1004b},
        {-70386507,  18233600,  -70295694,  18320089,  0x3c1004b},
        {-70778927,  18411000,  -70687874,  18497489,  0x3c1004b},
        {-71134487,  19507800,  -71042713,  19594289,  0x3c1004b},
        {-70186575,  19024050,  -70121026,  19086149,  0x2b2004b},
        {-71017497,  19558040,  -70953704,  19618159,  0x29c004b},
        {-70202688,  18638950,  -70137312,  18701049,  0x2b2004b},
        {-69877130,  19338040,  -69813671,  19398159,  0x29c004b},
        {-69278188,  18723450,  -69212812,  18785549,  0x2b2004b},
        {-70533746,  18534540,  -70470454,  18594659,  0x29c004b},
        {-70896847,  19520450,  -70830953,  19582549,  0x2b2004b},
        {-71551646,  18839940,  -71488354,  18900059,  0x29c004b},
        {-70672775,  19088950,  -70607226,  19151049,  0x2b2004b},
        {-70763330,  18876940,  -70699871,  18937059,  0x29c004b},
        {-69332688,  18528950,  -69267312,  18591049,  0x2b2004b},
        {-71451646,  18459940,  -71388354,  18520059,  0x29c004b},
        {-69061588,  18728450,  -68996212,  18790549,  0x2b2004b},
        {-71363497,  19451340,  -71299704,  19511459,  0x29c004b},
        {-69806275,  18919750,  -69740726,  18981849,  0x2b2004b},
        {-70447630,  19345140,  -70384171,  19405259,  0x29c004b},
        {-69672688,  18728950,  -69607312,  18791049,  0x2b2004b},
        {-71741897,  19519940,  -71678104,  19580059,  0x29c004b},
        {-69822688,  18778950,  -69757312,  18841049,  0x2b2004b},
        {-69441646,  18529940,  -69378354,  18590059,  0x29c004b},
        {-71232602,  18215550,  -71167398,  18277649,  0x2b2004b},
        {-71681897,  19819940,  -71618104,  19880059,  0x29c004b},
        {-70231075,  19161050,  -70165526,  19223149,  0x2b2004b},
        {-71231346,  18359340,  -71168054,  18419459,  0x29c004b},
        {-69426275,  19020350,  -69360726,  19082449,  0x2b2004b},
        {-69650430,  19195640,  -69586971,  19255759,  0x29c004b},
        {-70150875,  19158350,  -70085326,  19220449,  0x2b2004b},
        {-71481897,  19709940,  -71418104,  19770059,  0x29c004b},
        {-71215402,  18261450,  -71150198,  18323549,  0x2b2004b},
        {-69373330,  19188440,  -69309871,  19248559,  0x29c004b},
        {-71732688,  18838950,  -71667312,  18901049,  0x2b2004b},
        {-71776763,  18017740,  -71713638,  18077859,  0x29c004b},
        {-72017395,  19448960,  -71522635,  19940000,  0x001008c},
        {-71522635,  19448960,  -71027875,  19940000,  0x001088c},
        {-71027875,  19448960,  -70533115,  19940000,  0x001108c},
        {-70533115,  19448960,  -70038355,  19940000,  0x001188c},
        {-70038355,  19448960,  -69543595,  19940000,  0x001208c},
        {-72017395,  18957920,  -71522635,  19448960,  0x001288c},
        {-71522635,  18957920,  -71027875,  19448960,  0x001308c},
        {-71027875,  18957920,  -70533115,  19448960,  0x001388c},
        {-70533115,  18957920,  -70038355,  19448960,  0x001408c},
        {-70038355,  18957920,  -69543595,  19448960,  0x001488c},
        {-69543595,  18957920,  -69048835,  19448960,  0x001508c},
        {-69048836,  18957920,  -68554076,  19448960,  0x001588c},
        {-72017395,  18466880,  -71527843,  18957920,  0x001608c},
        {-71527844,  18466880,  -71038292,  18957920,  0x001688c},
        {-71038292,  18466880,  -70548740,  18957920,  0x001708c},
        {-70548740,  18466880,  -70059188,  18957920,  0x001788c},
        {-70059188,  18466880,  -69569636,  18957920,  0x001808c},
        {-69569636,  18466880,  -69080084,  18957920,  0x001888c},
        {-69080084,  18466880,  -68590532,  18957920,  0x001908c},
        {-72017396,  17975840,  -71527844,  18466880,  0x001a08c},
        {-71527844,  17975840,  -71038292,  18466880,  0x001a88c},
        {-71038292,  17975840,  -70548740,  18466880,  0x001b08c},
        {-70548740,  17975840,  -70059188,  18466880,  0x001b88c},
        {-70059188,  17975840,  -69569636,  18466880,  0x001c08c},
        {-69569636,  17975840,  -69080084,  18466880,  0x001c88c},
        {-71900000,  17450000,  -71527844,  17975840,  0x024e08c},
        {-71527844,  17484800,  -71038292,  17975840,  0x001e88c},
        {-68590532,  18317000,  -68311001,  18835000,  0x02af08c},
        {-69080084,  18030000,  -68550000,  18466880,  0x01cd08c},
        {-72020000,  17440000,  -68310000,  20000000,  0x0010216},
        {17066574,   48103781,  17194387,   48190271,  0x001000a}, // SVK
        {16959437,   47968494,  17652101,   48459534,  0x001000c},
        {21188633,   48676100,  21318367,   48762589,  0x3c1004b},
        {18015133,   48266800,  18144867,   48353289,  0x3c1004b},
        {21164112,   48963000,  21295287,   49049489,  0x3c1004b},
        {18689612,   49166800,  18820787,   49253289,  0x3c1004b},
        {19087033,   48690700,  19216767,   48777189,  0x3c1004b},
        {18857412,   49034600,  18988587,   49121089,  0x3c1004b},
        {17965212,   48830900,  18096387,   48917389,  0x3c1004b},
        {20221612,   49025000,  20352787,   49111489,  0x3c1004b},
        {18551833,   48746500,  18681567,   48832989,  0x3c1004b},
        {19093425,   48555650,  19186574,   48617749,  0x2b2004b},
        {18401809,   49091540,  18492990,   49151659,  0x29c004b},
        {18099457,   47954050,  18191743,   48016149,  0x2b2004b},
        {20495509,   48919340,  20586690,   48979459,  0x29c004b},
        {21863225,   48724150,  21956374,   48786249,  0x2b2004b},
        {18070028,   47747440,  18159372,   47807559,  0x29c004b},
        {18531557,   48195550,  18623843,   48257649,  0x2b2004b},
        {21864409,   48899940,  21955590,   48960059,  0x29c004b},
        {21243508,   49266650,  21337692,   49328749,  0x2b2004b},
        {19564409,   49049940,  19655590,   49110059,  0x29c004b},
        {17781625,   48567250,  17874774,   48629349,  0x2b2004b},
        {19267609,   49042240,  19358790,   49102359,  0x29c004b},
        {18113425,   48538950,  18206574,   48601049,  0x2b2004b},
        {19610310,   48315340,  19700489,   48375459,  0x29c004b},
        {18728590,   49420450,  18823809,   49482549,  0x2b2004b},
        {18134409,   48939940,  18225590,   49000059,  0x29c004b},
        {19973425,   48358950,  20066574,   48421049,  0x2b2004b},
        {18347510,   48609240,  18437689,   48669359,  0x29c004b},
        {17810557,   48120750,  17902843,   48182849,  0x2b2004b},
        {17744310,   48415240,  17834489,   48475359,  0x29c004b},
        {19592708,   48773150,  19686892,   48835249,  0x2b2004b},
        {21644409,   48859940,  21735590,   48920059,  0x29c004b},
        {21672625,   48605650,  21765774,   48667749,  0x2b2004b},
        {17787610,   48723740,  17877789,   48783859,  0x29c004b},
        {17316825,   48652350,  17409974,   48714449,  0x2b2004b},
        {22092809,   48952140,  22183990,   49012259,  0x29c004b},
        {20367608,   49109050,  20461792,   49171149,  0x2b2004b},
        {18204910,   48689940,  18295089,   48750059,  0x29c004b},
        {19252908,   49188950,  19347092,   49251049,  0x2b2004b},
        {18814910,   48559940,  18905089,   48620059,  0x29c004b},
        {20482325,   48611850,  20575474,   48673949,  0x2b2004b},
        {18274409,   49089940,  18365590,   49150059,  0x29c004b},
        {18713425,   48698950,  18806574,   48761049,  0x2b2004b},
        {17701210,   48250340,  17791389,   48310459,  0x29c004b},
        {18732908,   49268950,  18827092,   49331049,  0x2b2004b},
        {17714328,   48148640,  17803672,   48208759,  0x29c004b},
        {20642908,   49268950,  20737092,   49331049,  0x2b2004b},
        {18354910,   48359940,  18445089,   48420059,  0x29c004b},
        {19347425,   48533850,  19440574,   48595949,  0x2b2004b},
        {17184409,   48819940,  17275590,   48880059,  0x29c004b},
        {20068025,   48664050,  20161174,   48726149,  0x2b2004b},
        {18059809,   48923940,  18150990,   48984059,  0x29c004b},
        {19303857,   48168950,  19396143,   48231049,  0x2b2004b},
        {17524910,   48739940,  17615089,   48800059,  0x29c004b},
        {17649945,   49178064,  18358233,   49669104,  0x001008c},
        {18358233,   49178064,  19066521,   49669104,  0x001088c},
        {19066521,   49178064,  19774809,   49669104,  0x001108c},
        {19774809,   49178064,  20483097,   49669104,  0x001188c},
        {20483097,   49178064,  21191385,   49669104,  0x001208c},
        {21191385,   49178064,  21899673,   49669104,  0x001288c},
        {21899673,   49178064,  22607961,   49669104,  0x001308c},
        {16946865,   48687024,  17649945,   49178064,  0x001388c},
        {17649945,   48687024,  18353025,   49178064,  0x001408c},
        {18353025,   48687024,  19056105,   49178064,  0x001488c},
        {19056105,   48687024,  19759185,   49178064,  0x001508c},
        {19759185,   48687024,  20462265,   49178064,  0x001588c},
        {20462265,   48687024,  21165345,   49178064,  0x001608c},
        {21165345,   48687024,  21868425,   49178064,  0x001688c},
        {21868425,   48687024,  22571505,   49178064,  0x001708c},
        {16811457,   48195984,  17504121,   48687024,  0x001788c},
        {17504121,   48195984,  18196785,   48687024,  0x001808c},
        {18196785,   48195984,  18889449,   48687024,  0x001888c},
        {18889449,   48195984,  19582113,   48687024,  0x001908c},
        {19582113,   48195984,  20274777,   48687024,  0x001988c},
        {20274777,   48195984,  20967441,   48687024,  0x001a08c},
        {20967441,   48195984,  21660105,   48687024,  0x001a88c},
        {21660105,   48195984,  22352769,   48687024,  0x001b08c},
        {16811457,   47704944,  17498913,   48195984,  0x001b88c},
        {17498913,   47704944,  18186369,   48195984,  0x001c08c},
        {18186369,   47704944,  18873825,   48195984,  0x001c88c},
        {18873825,   47704944,  19561281,   48195984,  0x001d08c},
        {19561281,   47704944,  20248737,   48195984,  0x001d88c},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {16820000,   47723000,  22570000,   49620000,  0x003021c},
        {-84123845,  9886800,   -84036155,  9973289,   0x001000a}, // CRI
        {-84405000,  9735000,   -83856000,  10145000,  0x01a000c},
        {-83108904,  9908190,   -82984897,  10030499,  0x54f004b},
        {-85498274,  10546290,  -85373927,  10668599,  0x54f004b},
        {-84859804,  9943390,   -84735797,  10065699,  0x54f004b},
        {-84735797,  9943390,   -84611790,  10065699,  0x54f004b},
        {-83772534,  9309090,   -83648866,  9431399,   0x54f004b},
        {-85029374,  10454790,  -84905027,  10577099,  0x54f004b},
        {-83734604,  9812690,   -83610597,  9934999,   0x54f004b},
        {-84378374,  10346890,  -84254027,  10469199,  0x54f004b},
        {-85162174,  10368890,  -85037827,  10491199,  0x54f004b},
        {-83840774,  10148690,  -83716427,  10270999,  0x54f004b},
        {-83716427,  10148690,  -83592080,  10270999,  0x54f004b},
        {-83579474,  10051290,  -83455127,  10173599,  0x54f004b},
        {-83376674,  10039490,  -83252327,  10161799,  0x54f004b},
        {-85508274,  10099190,  -85383927,  10221499,  0x54f004b},
        {-84489965,  10036500,  -84402035,  10122989,  0x3c1004b},
        {-84047545,  9611300,   -83959855,  9697789,   0x3c1004b},
        {-83391425,  9125500,   -83303975,  9211989,   0x3c1004b},
        {-84081684,  10733959,  -83300000,  10979479,  0x011288c},
        {-85977396,  10733959,  -85503468,  11224999,  0x001088c},
        {-85503468,  10733959,  -85029540,  11224999,  0x001108c},
        {-85029540,  10733959,  -84555612,  11224999,  0x001188c},
        {-84555612,  10733959,  -84081684,  11224999,  0x001208c},
        {-85977396,  10242919,  -85503468,  10733959,  0x001308c},
        {-85503468,  10242919,  -85029540,  10733959,  0x001388c},
        {-85029540,  10242919,  -84555612,  10733959,  0x001408c},
        {-84555612,  10242919,  -84081684,  10733959,  0x001488c},
        {-84081684,  10242919,  -83607756,  10733959,  0x001508c},
        {-83607756,  10242919,  -83133828,  10733959,  0x001588c},
        {-85977396,  9751879,   -85503468,  10242919,  0x001608c},
        {-85503468,  9751879,   -85029540,  10242919,  0x001688c},
        {-85029540,  9751879,   -84555612,  10242919,  0x001708c},
        {-84555612,  9751879,   -84081684,  10242919,  0x001788c},
        {-84081684,  9751879,   -83607756,  10242919,  0x001808c},
        {-83607756,  9751879,   -83133828,  10242919,  0x001888c},
        {-83133828,  9751879,   -82659900,  10242919,  0x001908c},
        {-85361289,  9260839,   -84887361,  9751879,   0x001988c},
        {-84887361,  9260839,   -84413433,  9751879,   0x001a08c},
        {-84413433,  9260839,   -83939505,  9751879,   0x001a88c},
        {-83939505,  9260839,   -83465577,  9751879,   0x001b08c},
        {-83465577,  9260839,   -82991649,  9751879,   0x001b88c},
        {-82991649,  9260839,   -82517721,  9751879,   0x001c08c},
        {-84105380,  8769800,   -83631452,  9260840,   0x001c88c},
        {-83631452,  8769800,   -83157524,  9260840,   0x001d08c},
        {-83157524,  8769800,   -82683596,  9260840,   0x001d88c},
        {-83986898,  8278760,   -83518178,  8769800,   0x001e08c},
        {-83518178,  8278760,   -83049458,  8769800,   0x001e88c},
        {-83049458,  7975000,   -82815000,  8769800,   0x037f08c},
        {-87250000,  5180000,   -86900000,  5628708,   0x001008c},
        {-92236000,  7190000,   -77140000,  18500000,  0x3300216},
        {-87250000,  5180000,   -82540000,  11225000,  0x003021c},
        {18297000,   43818400,  18449000,   43881200,  0x017000a}, // BIH
        {17831076,   43761612,  18476868,   44252652,  0x001000c},
        {17134037,   44743700,  17255362,   44830189,  0x3c1004b},
        {18597018,   44498600,  18717382,   44585089,  0x3c1004b},
        {17750899,   43296800,  17869101,   43383289,  0x3c1004b},
        {15809337,   44776800,  15930662,   44863289,  0x3c1004b},
        {18726837,   44805500,  18848162,   44891989,  0x3c1004b},
        {19159337,   44716800,  19280662,   44803289,  0x3c1004b},
        {16649337,   44936800,  16770662,   45023289,  0x3c1004b},
        {17390418,   44016800,  17509581,   44103289,  0x3c1004b},
        {18281379,   42666800,  18398620,   42753289,  0x3c1004b},
        {17609818,   44186800,  17730182,   44273289,  0x3c1004b},
        {18029337,   44686800,  18150662,   44773289,  0x3c1004b},
        {15879337,   44926800,  16000662,   45013289,  0x3c1004b},
        {18920418,   43626800,  19039581,   43713289,  0x3c1004b},
        {15762237,   45137000,  15884763,   45223489,  0x3c1004b},
        {17900418,   43606800,  18019581,   43693289,  0x3c1004b},
        {18619218,   44405200,  18739582,   44491689,  0x3c1004b},
        {18438718,   44500000,  18559082,   44586489,  0x3c1004b},
        {17730118,   44112500,  17850482,   44198989,  0x3c1004b},
        {16107944,   44855650,  16195055,   44917749,  0x2b2004b},
        {18738918,   43479940,  18821081,   43540059,  0x29c004b},
        {18266444,   44668950,  18353555,   44731049,  0x2b2004b},
        {18387833,   44849940,  18472167,   44910059,  0x29c004b},
        {17205813,   45105150,  17293787,   45167249,  0x2b2004b},
        {18107367,   44414440,  18191033,   44474559,  0x29c004b},
        {16612944,   44736050,  16700055,   44798149,  0x2b2004b},
        {17046567,   44384740,  17130233,   44444859,  0x29c004b},
        {18384210,   42839050,  18468389,   42901149,  0x2b2004b},
        {16952784,   43799040,  17035615,   43859159,  0x29c004b},
        {17853844,   44951350,  17940955,   45013449,  0x2b2004b},
        {16767515,   45132940,  16852684,   45193059,  0x29c004b},
        {18286444,   44978950,  18373555,   45041049,  0x2b2004b},
        {17958915,   45093040,  18044084,   45153159,  0x29c004b},
        {17615289,   44130050,  17701710,   44192149,  0x2b2004b},
        {17038167,   44249940,  17121833,   44310059,  0x29c004b},
        {17226789,   44308950,  17313210,   44371049,  0x2b2004b},
        {16337833,   45019940,  16422167,   45080059,  0x29c004b},
        {17567220,   43788950,  17652779,   43851049,  0x2b2004b},
        {19073067,   44377840,  19156733,   44437959,  0x29c004b},
        {17507565,   43168950,  17592434,   43231049,  0x2b2004b},
        {17548918,   43349940,  17631081,   43410059,  0x29c004b},
        {17837565,   43378950,  17922434,   43441049,  0x2b2004b},
        {17358167,   44109940,  17441833,   44170059,  0x29c004b},
        {18757220,   43908950,  18842779,   43971049,  0x2b2004b},
        {17998167,   44399940,  18081833,   44460059,  0x29c004b},
        {15721000,   44929816,  16377208,   45420856,  0x001008c},
        {16377208,   44929816,  17033416,   45420856,  0x001088c},
        {17033416,   44929816,  17689624,   45420856,  0x001108c},
        {17689624,   44929816,  18345832,   45420856,  0x001188c},
        {18345832,   44929816,  19002040,   45420856,  0x001208c},
        {15726208,   44438776,  16377208,   44929816,  0x001288c},
        {16377208,   44438776,  17028208,   44929816,  0x001308c},
        {17028208,   44438776,  17679208,   44929816,  0x001388c},
        {17679208,   44438776,  18330208,   44929816,  0x001408c},
        {18330208,   44438776,  18981208,   44929816,  0x001488c},
        {18981208,   44438776,  19632208,   44929816,  0x001508c},
        {16051708,   43947736,  16697500,   44438776,  0x001588c},
        {16697500,   43947736,  17343292,   44438776,  0x001608c},
        {17343292,   43947736,  17989084,   44438776,  0x001688c},
        {17989084,   43947736,  18634876,   44438776,  0x001708c},
        {18634876,   43947736,  19280668,   44438776,  0x001788c},
        {19280668,   43947736,  19926460,   44438776,  0x001808c},
        {16379812,   43456696,  17020396,   43947736,  0x001888c},
        {17020396,   43456696,  17660980,   43947736,  0x001908c},
        {17660980,   43456696,  18301564,   43947736,  0x001988c},
        {18301564,   43456696,  18942148,   43947736,  0x001a08c},
        {18942148,   43456696,  19582732,   43947736,  0x001a88c},
        {17212571,   42965656,  17847947,   43456696,  0x001b08c},
        {17847947,   42965656,  18483323,   43456696,  0x001c08c},
        {18483323,   42965656,  19118699,   43456696,  0x001c88c},
        {17530259,   42474616,  18165635,   42965656,  0x001d08c},
        {18165635,   42474616,  18801011,   42965656,  0x001d88c},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {15721782,   42554500,  19622881,   45276696,  0x003021c},
        {15908136,   45756800,  16031863,   45843289,  0x001000a}, // HRV
        {15462000,   45650000,  16343660,   46010000,  0x017000c},
        {16312699,   43496800,  16430901,   43583289,  0x3c1004b},
        {16430899,   43496800,  16549101,   43583289,  0x3c1004b},
        {14375037,   45311000,  14497563,   45397489,  0x3c1004b},
        {18618737,   45506800,  18741263,   45593289,  0x3c1004b},
        {15193318,   44077900,  15313682,   44164389,  0x3c1004b},
        {13801837,   44824900,  13923162,   44911389,  0x3c1004b},
        {17948737,   45116800,  18071263,   45203289,  0x3c1004b},
        {15478737,   45456800,  15601263,   45543289,  0x3c1004b},
        {16267535,   46266800,  16392464,   46353289,  0x3c1004b},
        {15830418,   43696800,  15949581,   43783289,  0x3c1004b},
        {16298737,   45436800,  16421263,   45523289,  0x3c1004b},
        {18738737,   45246800,  18861263,   45333289,  0x3c1004b},
        {18011379,   42616800,  18128620,   42703289,  0x3c1004b},
        {18928737,   45306800,  19051263,   45393289,  0x3c1004b},
        {16778136,   45866800,  16901863,   45953289,  0x3c1004b},
        {16768136,   46116800,  16891863,   46203289,  0x3c1004b},
        {18348737,   45266800,  18471263,   45353289,  0x3c1004b},
        {17618737,   45296800,  17741263,   45383289,  0x3c1004b},
        {16357535,   46346800,  16482464,   46433289,  0x3c1004b},
        {17328136,   45796800,  17451863,   45883289,  0x3c1004b},
        {16718737,   45436800,  16841263,   45523289,  0x3c1004b},
        {17570899,   43006800,  17689101,   43093289,  0x3c1004b},
        {16220537,   45398100,  16343063,   45484589,  0x3c1004b},
        {18639337,   45026800,  18760662,   45113289,  0x3c1004b},
        {13579337,   45046800,  13700662,   45133289,  0x3c1004b},
        {16960899,   43256800,  17079101,   43343289,  0x3c1004b},
        {17318737,   45216800,  17441263,   45303289,  0x3c1004b},
        {16478136,   45976800,  16601863,   46063289,  0x3c1004b},
        {16580418,   43656800,  16699581,   43743289,  0x3c1004b},
        {16140418,   43996800,  16259581,   44083289,  0x3c1004b},
        {17648136,   45656800,  17771863,   45743289,  0x3c1004b},
        {15580000,   46021560,  16123000,   46410000,  0x001008c},
        {16123000,   46021560,  16798607,   46560000,  0x020088c},
        {16798607,   46021560,  17333000,   46410000,  0x001108c},
        {14470632,   45530520,  15132048,   46021560,  0x001188c},
        {15132047,   45530520,  15793463,   46021560,  0x001208c},
        {15793463,   45530520,  16454879,   46021560,  0x001288c},
        {16454879,   45530520,  17116295,   46021560,  0x001308c},
        {17116295,   45530520,  17777711,   46021560,  0x001388c},
        {17777711,   45530520,  18439127,   46021560,  0x001408c},
        {18439127,   45530520,  19100543,   46021560,  0x001488c},
        {13478508,   45039480,  14134716,   45530520,  0x001508c},
        {14134716,   45039480,  14790924,   45530520,  0x001588c},
        {14790924,   45039480,  15447132,   45530520,  0x001608c},
        {15447132,   45039480,  16103340,   45530520,  0x001688c},
        {16103340,   45039480,  16759548,   45530520,  0x001708c},
        {16759548,   45039480,  17415756,   45530520,  0x001788c},
        {17415756,   45039480,  18071964,   45530520,  0x001808c},
        {18071964,   45039480,  18728172,   45530520,  0x001888c},
        {18728172,   45150000,  19455000,   45530520,  0x01a908c},
        {18733380,   44830000,  19180000,   45150000,  0x001988c},
        {13485904,   44548479,  14136904,   45039480,  0x001a08c},
        {14136904,   44548479,  14787904,   45039480,  0x001a88c},
        {14787904,   44548479,  15438904,   45039480,  0x001b08c},
        {15438904,   44548479,  16089904,   45039480,  0x001b88c},
        {13843954,   44057439,  14494954,   44548479,  0x001c08c},
        {14494954,   44057439,  15145954,   44548479,  0x001c88c},
        {15145954,   44057439,  15796954,   44548479,  0x001d08c},
        {15796954,   44057439,  16447954,   44548479,  0x001d88c},
        {14494954,   43566399,  15140746,   44057439,  0x001e08c},
        {15140746,   43566399,  15786538,   44057439,  0x001e88c},
        {15786538,   43566399,  16432330,   44057439,  0x001f08c},
        {16432330,   43566399,  17078122,   44057439,  0x0010088},
        {15824035,   43075359,  16464619,   43566399,  0x0010888},
        {16464619,   43075359,  17105203,   43566399,  0x0011088},
        {17105203,   43075359,  17745787,   43566399,  0x0011888},
        {15695918,   42633423,  16331294,   43124463,  0x0012088},
        {16331294,   42584319,  16966670,   43075359,  0x0012888},
        {16966670,   42584319,  17602046,   43075359,  0x0013088},
        {17602046,   42584319,  18237422,   43075359,  0x0013888},
        {18167520,   42374480,  18797688,   42865520,  0x0014088},
        {15961931,   42374480,  16592099,   42865520,  0x0014888},
        {18680000,   44988000,  18920000,   45167000,  0x001f088},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {13489000,   42370000,  19455000,   46555000,  0x003021c},
        {1198545,    6112424,   1242617,    6197433,   0x2a7044a}, // TGO
        {1242617,    6128600,   1297097,    6197433,   0x2a7044a},
        {1020000,    6143500,   1700000,    6470000,   0x015000c},
        {1088167,    8928891,   1211835,    9051200,   0x54f004b},
        {568337,     6838891,   691665,     6961200,   0x54f004b},
        {1048263,    7468983,   1171591,    7591292,   0x54f004b},
        {1127997,    9488891,   1252004,    9611200,   0x54f004b},
        {125826,     10807890,  250173,     10930199,  0x54f004b},
        {746276,     9216801,   833726,     9303290,   0x3c1004b},
        {1126396,    6906801,   1213605,    6993290,   0x3c1004b},
        {1366276,    8976801,   1453726,    9063290,   0x3c1004b},
        {406035,     10306800,  493965,     10393289,  0x3c1004b},
        {556396,     7546801,   643605,     7633290,   0x3c1004b},
        {1066156,    9726801,   1153846,    9813290,   0x3c1004b},
        {1196276,    9296801,   1283726,    9383290,   0x3c1004b},
        {936276,     8516801,   1023726,    8603290,   0x3c1004b},
        {946396,     8276801,   1033605,    8363290,   0x3c1004b},
        {486035,     10586800,  573965,     10673289,  0x3c1004b},
        {1156396,    7716801,   1243605,    7803290,   0x3c1004b},
        {1351939,    6589102,   1438908,    6675591,   0x3c1004b},
        {1216396,    8026801,   1303605,    8113290,   0x3c1004b},
        {1480566,    6576632,   1567535,    6663121,   0x3c1004b},
        {872986,     7414223,   960195,     7500712,   0x3c1004b},
        {566156,     9646801,   653846,     9733290,   0x3c1004b},
        {768491,     9412804,   855941,     9499293,   0x3c1004b},
        {1266961,    9622121,   1354651,    9708610,   0x3c1004b},
        {995976,     9904412,   1083666,    9990901,   0x3c1004b},
        {1126516,    6626801,   1213485,    6713290,   0x3c1004b},
        {1276156,    9706801,   1363846,    9793290,   0x3c1004b},
        {-160000,    10526200,  201748,     11140000,  0x027008c},
        {201748,     10526200,  563496,     11140000,  0x027088c},
        {563496,     10526200,  1037424,    11017240,  0x001108c},
        {89568,      10035160,  563496,     10526200,  0x001188c},
        {563496,     10035160,  1037424,    10526200,  0x001208c},
        {1037424,    10035160,  1511352,    10526200,  0x001288c},
        {208049,     9544120,   681977,     10035160,  0x001308c},
        {681977,     9544120,   1155905,    10035160,  0x001388c},
        {1155905,    9544120,   1629833,    10035160,  0x001408c},
        {208049,     9053080,   681977,     9544120,   0x001488c},
        {681977,     9053080,   1155905,    9544120,   0x001508c},
        {1155905,    9053080,   1629833,    9544120,   0x001588c},
        {350228,     8562040,   824156,     9053080,   0x001608c},
        {824156,     8562040,   1298084,    9053080,   0x001688c},
        {1298084,    8562040,   1772012,    9053080,   0x001708c},
        {350228,     8071000,   818948,     8562040,   0x001788c},
        {818948,     8071000,   1287668,    8562040,   0x001808c},
        {1287668,    8071000,   1756388,    8562040,   0x001888c},
        {350228,     7579960,   818948,     8071000,   0x001908c},
        {818948,     7579960,   1287668,    8071000,   0x001988c},
        {1287668,    7579960,   1756388,    8071000,   0x001a08c},
        {350228,     7088920,   818948,     7579960,   0x001a88c},
        {818948,     7088920,   1287668,    7579960,   0x001b08c},
        {1287668,    7088920,   1756388,    7579960,   0x001b88c},
        {350228,     6597880,   818948,     7088920,   0x001c08c},
        {818948,     6597880,   1287668,    7088920,   0x001c88c},
        {1287668,    6597880,   1756388,    7088920,   0x001d08c},
        {584588,     6106840,   1053308,    6597880,   0x001d88c},
        {1053308,    6106840,   1522028,    6597880,   0x001e08c},
        {1522028,    6106840,   1990748,    6597880,   0x001e88c},
        {-16860000,  4340000,   4000000,    15120000,  0x2a30216},
        {-150000,    6106800,   1813000,    11140000,  0x003021c},
        {24059059,   56896355,  24215702,   56982845,  0x001000a}, // LVA
        {23594820,   56606720,  24433308,   57097760,  0x001000c},
        {26463781,   55836800,  26616819,   55923289,  0x3c1004b},
        {20984620,   56472900,  21139580,   56559389,  0x3c1004b},
        {21139580,   56472900,  21294540,   56559389,  0x3c1004b},
        {21504137,   57350800,  21663662,   57437289,  0x3c1004b},
        {27242520,   56466800,  27397480,   56553289,  0x3c1004b},
        {25792720,   56463400,  25947680,   56549889,  0x3c1004b},
        {25333537,   57485800,  25493062,   57572289,  0x3c1004b},
        {24525539,   56760200,  24682661,   56846689,  0x3c1004b},
        {23078839,   56926600,  23235961,   57013089,  0x3c1004b},
        {25213037,   57274500,  25372562,   57360989,  0x3c1004b},
        {21871439,   56936800,  22028561,   57023289,  0x3c1004b},
        {22429439,   56629100,  22586561,   56715589,  0x3c1004b},
        {22510237,   57206800,  22669762,   57293289,  0x3c1004b},
        {24102520,   56366800,  24257480,   56453289,  0x3c1004b},
        {27069581,   55864100,  27222619,   55950589,  0x3c1004b},
        {24767539,   57110900,  24924661,   57197389,  0x3c1004b},
        {23204620,   56587100,  23359580,   56673589,  0x3c1004b},
        {27614920,   56508200,  27769880,   56594689,  0x3c1004b},
        {26099320,   56318000,  26254280,   56404489,  0x3c1004b},
        {26664639,   57125500,  26821761,   57211989,  0x3c1004b},
        {26142439,   56805900,  26299561,   56892389,  0x3c1004b},
        {24629137,   57464300,  24788662,   57550789,  0x3c1004b},
        {26679520,   56270700,  26834480,   56357189,  0x3c1004b},
        {25153920,   56553000,  25308880,   56639489,  0x3c1004b},
        {27172039,   57097200,  27329161,   57183689,  0x3c1004b},
        {25826937,   57389100,  25986462,   57475589,  0x3c1004b},
        {25950456,   57735300,  26112143,   57821789,  0x3c1004b},
        {24694139,   56696700,  24851261,   56783189,  0x3c1004b},
        {21521339,   56681000,  21678461,   56767489,  0x3c1004b},
        {25307856,   57837600,  25469543,   57924089,  0x3c1004b},
        {24451439,   57066800,  24608561,   57153289,  0x3c1004b},
        {20900000,   56055000,  21620000,   57480000,  0x004018c},
        {21620000,   56244000,  23255000,   57763000,  0x004018c},
        {23255000,   56244000,  24323000,   57200000,  0x004018c},
        {24323000,   56133000,  25670000,   58100000,  0x004010c},
        {25670000,   57635000,  26255000,   57925000,  0x004018c},
        {25670000,   56885000,  27877000,   57635000,  0x004018c},
        {25670000,   55650000,  28265000,   56885000,  0x004018c},
        {14105000,   48990000,  32794200,   59822030,  0x0010216},
        {20900000,   55650000,  28265000,   58100000,  0x003021c},
        {25192555,   54645755,  25341510,   54732245,  0x001000a}, // LTU
        {24878192,   54443480,  25675016,   54934520,  0x001000c},
        {23846778,   54851090,  24057422,   54973399,  0x54f004b},
        {21067290,   55640000,  21254885,   55781000,  0x54f044b},
        {23211790,   55868890,  23428209,   55991199,  0x54f004b},
        {24257490,   55679190,  24473909,   55801499,  0x54f004b},
        {23933537,   54348690,  24141463,   54470999,  0x54f004b},
        {23258837,   54498690,  23466763,   54620999,  0x54f004b},
        {22249031,   56244490,  22468168,   56366799,  0x54f004b},
        {24207978,   54990390,  24418622,   55112699,  0x54f004b},
        {23908819,   55238590,  24122181,   55360899,  0x54f004b},
        {25493319,   55438890,  25706681,   55561199,  0x54f004b},
        {22121790,   55928890,  22338209,   56051199,  0x54f004b},
        {24653319,   55198890,  24866681,   55321199,  0x54f004b},
        {22173319,   55188890,  22386681,   55311199,  0x54f004b},
        {26409824,   55557000,  26610312,   55622000,  0x3c1044b},
        {21773481,   55866800,  21926519,   55953289,  0x3c1004b},
        {21394562,   55306800,  21545438,   55393289,  0x3c1004b},
        {21130481,   55855400,  21283519,   55941889,  0x3c1004b},
        {23471181,   55762500,  23624219,   55848989,  0x3c1004b},
        {20950000,   55015000,  22583000,   56437000,  0x004010c},
        {22583000,   53893000,  25880000,   56452000,  0x004018c},
        {25880000,   54920000,  26850000,   56009000,  0x004018c},
        {14105000,   48990000,  32794200,   59822030,  0x0010216},
        {19569000,   53893000,  26850000,   56452000,  0x003021c},
        {79840675,   6862160,   79900000,   6981272,   0x02c000a}, // LKA
        {79816600,   6420000,   80043000,   7402500,   0x03f000c},
        {80040215,   6808500,   80127184,   6894989,   0x3c1004b},
        {79984355,   9645600,   80072045,   9732089,   0x3c1004b},
        {80586395,   7246800,   80673604,   7333289,   0x3c1004b},
        {80116555,   9635700,   80204245,   9722189,   0x3c1004b},
        {81770295,   7386200,   81857504,   7472689,   0x3c1004b},
        {80169415,   6022300,   80256384,   6108789,   0x3c1004b},
        {81159875,   8545100,   81247325,   8631589,   0x3c1004b},
        {81648495,   7693500,   81735704,   7779989,   0x3c1004b},
        {80096155,   9742000,   80183845,   9828489,   0x3c1004b},
        {80183845,   9750649,   80271535,   9837138,   0x3c1004b},
        {80606395,   7806800,   80693604,   7893289,   0x3c1004b},
        {80366395,   8276800,   80453604,   8363289,   0x3c1004b},
        {80446275,   8716800,   80533725,   8803289,   0x3c1004b},
        {80336515,   6656800,   80423484,   6743289,   0x3c1004b},
        {80489700,   5918600,   80621648,   5975500,   0x3c1044b},
        {79841075,   8965800,   79928525,   9052289,   0x3c1004b},
        {81006395,   6946800,   81093604,   7033289,   0x3c1004b},
        {79790395,   7996800,   79877604,   8083289,   0x3c1004b},
        {80576395,   7426800,   80663604,   7513289,   0x3c1004b},
        {81697695,   7609000,   81784904,   7695489,   0x3c1004b},
        {80323295,   7453600,   80410504,   7540089,   0x3c1004b},
        {80727095,   6914700,   80814304,   7001189,   0x3c1004b},
        {80526395,   7126800,   80613604,   7213289,   0x3c1004b},
        {79786000,   7452000,   79832644,   7613589,   0x3c1044b},
        {81545895,   7754800,   81633104,   7841289,   0x3c1004b},
        {80401615,   5934800,   80488584,   6021289,   0x3c1004b},
        {80041592,   6892650,   80104208,   6954749,   0x2b2004b},
        {80031373,   6217140,   80091826,   6277259,   0x29c004b},
        {80357205,   9342150,   80419994,   9404249,   0x2b2004b},
        {81657590,   7270940,   81718210,   7331059,   0x29c004b},
        {80318692,   7218950,   80381308,   7281049,   0x2b2004b},
        {80569690,   6859940,   80630310,   6920059,   0x29c004b},
        {80498692,   7018950,   80561308,   7081049,   0x2b2004b},
        {80990590,   7911740,   81051210,   7971859,   0x29c004b},
        {80678778,   6618950,   80741222,   6681049,   0x2b2004b},
        {81089973,   6112840,   81150426,   6172959,   0x29c004b},
        {79500000,   8957000,   79942000,   9120000,   0x004018c},
        {79502907,   9365402,   79554405,   9414855,   0x004018c},
        {79634743,   9466333,   79749750,   9570959,   0x004010c},
        {79750000,   9140000,   80877000,   9840000,   0x004018c},
        {79875000,   8555000,   81300000,   9140000,   0x004018c},
        {79688000,   8050000,   81475000,   8555000,   0x004018c},
        {79688000,   6660000,   81890533,   8050000,   0x004018c},
        {79922000,   6360000,   81800000,   6660000,   0x004018c},
        {80000000,   5900000,   81535000,   6360000,   0x004018c},
        {79450000,   5800000,   81900000,   9900000,   0x0010216},
        {44714340,   41689163,  44829660,   41775653,  0x001000a}, // GEO
        {44588000,   41417600,  45127784,   41972000,  0x023000c},
        {42601770,   42213000,  42738257,   42286600,  0x3c1044b},
        {41778560,   42465400,  41894840,   42551889,  0x3c1004b},
        {44052340,   41936800,  44167659,   42023289,  0x3c1004b},
        {40953079,   42979800,  41085936,   43056100,  0x3c1044b},
        {40219599,   43265000,  40337801,   43351489,  0x3c1004b},
        {41611379,   42796800,  41728620,   42883289,  0x3c1004b},
        {41425279,   42680500,  41542520,   42766989,  0x3c1004b},
        {41588340,   41582200,  41703659,   41668689,  0x3c1004b},
        {41754140,   41776700,  41869459,   41863189,  0x3c1004b},
        {41644560,   42108200,  41760840,   42194689,  0x3c1004b},
        {43882860,   42186000,  43999140,   42272489,  0x3c1004b},
        {43516160,   41968300,  43632440,   42054789,  0x3c1004b},
        {42001860,   42226800,  42118140,   42313289,  0x3c1004b},
        {42291860,   42126800,  42408140,   42213289,  0x3c1004b},
        {42951860,   42066800,  43068140,   42153289,  0x3c1004b},
        {45409240,   41898500,  45524559,   41984989,  0x3c1004b},
        {41932340,   41886800,  42047659,   41973289,  0x3c1004b},
        {42922340,   41596800,  43037659,   41683289,  0x3c1004b},
        {42541860,   42286800,  42658140,   42373289,  0x3c1004b},
        {44352340,   41886800,  44467659,   41973289,  0x3c1004b},
        {42928460,   42305900,  43044740,   42392389,  0x3c1004b},
        {43211860,   42246800,  43328140,   42333289,  0x3c1004b},
        {43341540,   41809600,  43456859,   41896089,  0x3c1004b},
        {41671379,   42586800,  41788620,   42673289,  0x3c1004b},
        {40543999,   43085800,  40662201,   43172289,  0x3c1004b},
        {45228800,   41707000,  45409879,   41762000,  0x3c1044b},
        {42385060,   42275700,  42501340,   42362189,  0x3c1004b},
        {42671379,   42746800,  42788620,   42833289,  0x3c1004b},
        {45742340,   41706800,  45857659,   41793289,  0x3c1004b},
        {41053179,   42899500,  41170420,   42985989,  0x3c1004b},
        {44474321,   41402800,  44588679,   41489289,  0x3c1004b},
        {40006000,   43065000,  40870000,   43587000,  0x004018c},
        {40870000,   42688000,  41560000,   43493000,  0x004018c},
        {41470000,   41427000,  42985000,   43257000,  0x004018c},
        {42985000,   42770000,  43746000,   43120000,  0x004018c},
        {42985000,   41100000,  45330000,   42770000,  0x004018c},
        {45330000,   41353000,  45800000,   42552000,  0x004018c},
        {45700000,   41225000,  45800000,   41353000,  0x004018c},
        {45800000,   41100000,  46440000,   42120000,  0x004018c},
        {46440000,   41053000,  46738000,   41463000,  0x004018c},
        {40006000,   41050000,  46738000,   43587000,  0x0010216},
        {-6342614,   53304179,  -6199425,   53390669,  0x001000a}, // IRL
        {-6836411,   53097580,  -6036500,   53570000,  0x01e000c},
        {-8543000,   51856800,  -8381586,   51931000,  0x3c1044b},
        {-8685073,   52613800,  -8543327,   52700289,  0x3c1004b},
        {-9130700,   53248400,  -8957281,   53320000,  0x3c1044b},
        {-7187732,   52206900,  -7047668,   52293389,  0x3c1004b},
        {-6462575,   53955200,  -6317225,   54041689,  0x3c1004b},
        {-6432675,   53676800,  -6287325,   53763289,  0x3c1004b},
        {-9773032,   52227200,  -9632968,   52313689,  0x3c1004b},
        {-7319573,   52609300,  -7177827,   52695789,  0x3c1004b},
        {-9053373,   52800900,  -8911627,   52887389,  0x3c1004b},
        {-8548616,   54226800,  -8401584,   54313289,  0x3c1004b},
        {-8021834,   53376800,  -7878166,   53463289,  0x3c1004b},
        {-6550032,   52296800,  -6409968,   52383289,  0x3c1004b},
        {-7780032,   52316800,  -7639968,   52403289,  0x3c1004b},
        {-6990873,   52796800,  -6849127,   52883289,  0x3c1004b},
        {-6750475,   53608500,  -6605125,   53694989,  0x3c1004b},
        {-7412675,   53486800,  -7267325,   53573289,  0x3c1004b},
        {-7835977,   54906700,  -7687023,   54993189,  0x3c1004b},
        {-9636834,   53032600,  -9493166,   53119089,  0x3c1004b},
        {-7561834,   53236800,  -7418166,   53323289,  0x3c1004b},
        {-7371834,   52996800,  -7228166,   53083289,  0x3c1004b},
        {-6258973,   52757200,  -6117227,   52843689,  0x3c1004b},
        {-9233516,   54076800,  -9086484,   54163289,  0x3c1004b},
        {-8409930,   51793002,  -8271307,   51879491,  0x3c1004b},
        {-6253381,   53578950,  -6149020,   53641049,  0x2b2004b},
        {-9350517,   53829940,  -9249483,   53890059,  0x29c004b},
        {-8970887,   52668950,  -8869113,   52731049,  0x2b2004b},
        {-6619265,   52469940,  -6520736,   52530059,  0x29c004b},
        {-6319000,   52623100,  -6224749,   52690049,  0x2b2044b},
        {-8708680,   52109940,  -8611320,   52170059,  0x29c004b},
        {-6101577,   52958950,  -5998423,   53021049,  0x2b2004b},
        {-7678680,   52059940,  -7581320,   52120059,  0x29c004b},
        {-6170081,   53533050,  -6065720,   53595149,  0x2b2004b},
        {-6314017,   53639840,  -6212983,   53699959,  0x29c004b},
        {-7869287,   52647550,  -7767513,   52709649,  0x2b2004b},
        {-7848317,   53695040,  -7747283,   53755159,  0x29c004b},
        {-7204983,   52130450,  -7104417,   52192549,  0x2b2004b},
        {-6988180,   52361240,  -6890820,   52421359,  0x29c004b},
        {-7029677,   52963650,  -6926523,   53025749,  0x2b2004b},
        {-8218179,   51889940,  -8121821,   51950059,  0x29c004b},
        {-10622000,  51417000,  -5990000,   53900000,  0x09c0011},
        {-10383000,  53900000,  -5400000,   55450000,  0x016000d},
        {-10700000,  49122422,  1889648,    60875000,  0x0010216},
        {-10700000,  51410000,  -5390000,   55450000,  0x003021c},
        {-13299000,  8449300,   -13154000,  8499500,   0x012000a}, // SLE
        {-13300933,  8219928,   -12832213,  8710968,   0x001000c},
        {-11032334,  8584790,   -10908666,  8707099,   0x54f004b},
        {-12111834,  8818890,   -11988166,  8941199,   0x54f004b},
        {-11801664,  7890590,   -11678336,  8012899,   0x54f004b},
        {-11251664,  7818890,   -11128336,  7941199,   0x54f004b},
        {-10396164,  8385990,   -10272836,  8508299,   0x54f004b},
        {-11151034,  8533690,   -11027366,  8655999,   0x54f004b},
        {-12588634,  8624490,   -12464966,  8746799,   0x54f004b},
        {-12121664,  8138890,   -11998336,  8261199,   0x54f004b},
        {-12826225,  8726800,   -12738775,  8813289,   0x3c1004b},
        {-11974525,  8676800,   -11887075,  8763289,   0x3c1004b},
        {-12007825,  8921000,   -11920375,  9007489,   0x3c1004b},
        {-12536205,  7478200,   -12448996,  7564689,   0x3c1004b},
        {-11905405,  8368200,   -11818196,  8454689,   0x3c1004b},
        {-12223605,  7556800,   -12136396,  7643289,   0x3c1004b},
        {-10623605,  8236800,   -10536396,  8323289,   0x3c1004b},
        {-11593845,  9536800,   -11506155,  9623289,   0x3c1004b},
        {-12483605,  8126800,   -12396396,  8213289,   0x3c1004b},
        {-10973605,  7976800,   -10886396,  8063289,   0x3c1004b},
        {-12963725,  9076800,   -12876275,  9163289,   0x3c1004b},
        {-13083725,  8876800,   -12996275,  8963289,   0x3c1004b},
        {-10793605,  8126800,   -10706396,  8213289,   0x3c1004b},
        {-10753605,  8056800,   -10666396,  8143289,   0x3c1004b},
        {-11513605,  7806800,   -11426396,  7893289,   0x3c1004b},
        {-12692289,  9508960,   -12218361,  10000000,  0x001008c},
        {-12218361,  9508960,   -11744433,  10000000,  0x001088c},
        {-11744433,  9508960,   -11270505,  10000000,  0x001108c},
        {-11270505,  9508960,   -10796577,  10000000,  0x001188c},
        {-13308396,  9017920,   -12834468,  9508960,   0x001208c},
        {-12834468,  9017920,   -12360540,  9508960,   0x001288c},
        {-12360540,  9017920,   -11886612,  9508960,   0x001308c},
        {-11886612,  9017920,   -11412684,  9508960,   0x001388c},
        {-11412684,  9017920,   -10938756,  9508960,   0x001408c},
        {-10938756,  9017920,   -10464828,  9508960,   0x001488c},
        {-13308395,  8526880,   -12834467,  9017920,   0x001508c},
        {-12834467,  8526880,   -12360539,  9017920,   0x001588c},
        {-12360539,  8526880,   -11886611,  9017920,   0x001608c},
        {-11886611,  8526880,   -11412683,  9017920,   0x001688c},
        {-11412683,  8526880,   -10938755,  9017920,   0x001708c},
        {-10938755,  8526880,   -10464827,  9017920,   0x001788c},
        {-13545360,  8035840,   -13076640,  8526880,   0x001808c},
        {-13076640,  8035840,   -12607920,  8526880,   0x001888c},
        {-12607920,  8035840,   -12139200,  8526880,   0x001908c},
        {-12139200,  8035840,   -11670480,  8526880,   0x001988c},
        {-11670480,  8035840,   -11201760,  8526880,   0x001a08c},
        {-11201760,  8035840,   -10733040,  8526880,   0x001a88c},
        {-10733040,  8035840,   -10264320,  8526880,   0x001b08c},
        {-13080000,  7685001,   -12481365,  8035840,   0x017b88c},
        {-13080000,  7370001,   -12481365,  7685001,   0x016e08c},
        {-12481366,  7544800,   -12012646,  8035840,   0x001c08c},
        {-12012646,  7544800,   -11543926,  8035840,   0x001c88c},
        {-11543926,  7544800,   -11075206,  8035840,   0x001d08c},
        {-11075206,  7544800,   -10606486,  8035840,   0x001d88c},
        {-12481365,  7053760,   -12012645,  7544800,   0x001e88c},
        {-12012645,  7053760,   -11543925,  7544800,   0x001f08c},
        {-11543925,  7053760,   -11075205,  7544800,   0x0010888},
        {-11075206,  7053760,   -10606486,  7544800,   0x0011088},
        {-11752245,  6919001,   -11355000,  7053760,   0x0011888},
        {-16860000,  4340000,   4000000,    15120000,  0x2a30216},
        {-13711000,  6913198,   -10266520,  10000300,  0x003021c},
        {-79557945,  8946695,   -79512264,  9029247,   0x2a7044a}, // PAN
        {-79512264,  8973150,   -79454389,  9038274,   0x2a7044a},
        {-79855340,  8831000,   -79198000,  9179000,   0x016000c},
        {-82489864,  8358590,   -82366536,  8480899,   0x54f004b},
        {-79916825,  9306600,   -79829375,  9393089,   0x3c1004b},
        {-79829375,  9306600,   -79741925,  9393089,   0x3c1004b},
        {-81029305,  8063500,   -80942096,  8149989,   0x3c1004b},
        {-82557425,  9395600,   -82469975,  9482089,   0x3c1004b},
        {-81363605,  7966800,   -81276396,  8053289,   0x3c1004b},
        {-82895505,  8237500,   -82808296,  8323989,   0x3c1004b},
        {-82646725,  8463100,   -82559275,  8549589,   0x3c1004b},
        {-82914925,  8776600,   -82827475,  8863089,   0x3c1004b},
        {-80403725,  8466800,   -80316275,  8553289,   0x3c1004b},
        {-79143725,  9126800,   -79056275,  9213289,   0x3c1004b},
        {-78607625,  9357300,   -78520175,  9443789,   0x3c1004b},
        {-80318605,  8369300,   -80231396,  8455789,   0x3c1004b},
        {-80823605,  7896800,   -80736396,  7983289,   0x3c1004b},
        {-80310205,  7712100,   -80222996,  7798589,   0x3c1004b},
        {-79688445,  9508000,   -79600755,  9594489,   0x3c1004b},
        {-80582505,  8202200,   -80495296,  8288689,   0x3c1004b},
        {-80481105,  7915400,   -80393896,  8001889,   0x3c1004b},
        {-82463725,  8516800,   -82376275,  8603289,   0x3c1004b},
        {-80588405,  8286700,   -80501196,  8373189,   0x3c1004b},
        {-81241305,  8265600,   -81154096,  8352089,   0x3c1004b},
        {-79922425,  8704100,   -79834975,  8790589,   0x3c1004b},
        {-81083605,  7946800,   -80996396,  8033289,   0x3c1004b},
        {-80948205,  8007100,   -80860996,  8093589,   0x3c1004b},
        {-80323005,  7794400,   -80235796,  7880889,   0x3c1004b},
        {-81889405,  8192500,   -81802196,  8278989,   0x3c1004b},
        {-82472825,  8732100,   -82385375,  8818589,   0x3c1004b},
        {-79958925,  8457900,   -79871475,  8544389,   0x3c1004b},
        {-79913725,  8536800,   -79826275,  8623289,   0x3c1004b},
        {-79580625,  8751900,   -79493175,  8838389,   0x3c1004b},
        {-83051396,  9129856,   -82577468,  9620896,   0x001008c},
        {-83051396,  8638816,   -82577468,  9129856,   0x001088c},
        {-83051396,  8147776,   -82582676,  8638816,   0x001108c},
        {-83051396,  7656736,   -82582676,  8147776,   0x001188c},
        {-82582676,  9129855,   -82108748,  9620895,   0x001208c},
        {-82582676,  8638815,   -82108748,  9129855,   0x001288c},
        {-82582676,  8147775,   -82113956,  8638815,   0x001308c},
        {-82582676,  7656735,   -82113956,  8147775,   0x001388c},
        {-82113956,  8835231,   -81640028,  9326271,   0x001408c},
        {-82113956,  8344191,   -81645236,  8835231,   0x001488c},
        {-82113956,  7853151,   -81645236,  8344191,   0x001508c},
        {-81973340,  7190247,   -81504620,  7681287,   0x001588c},
        {-81645236,  8442399,   -81171308,  8933439,   0x001608c},
        {-81645236,  7951359,   -81176516,  8442399,   0x001688c},
        {-81645236,  7460319,   -81176516,  7951359,   0x001708c},
        {-81176516,  8663367,   -80702588,  9154407,   0x001788c},
        {-81176516,  8172327,   -80707796,  8663367,   0x001808c},
        {-81176516,  7681287,   -80707796,  8172327,   0x001888c},
        {-81176516,  7190247,   -80707796,  7681287,   0x001908c},
        {-80707796,  8678099,   -80233868,  9169139,   0x001988c},
        {-80707796,  8187059,   -80239076,  8678099,   0x001a08c},
        {-80707796,  7696019,   -80239076,  8187059,   0x001a88c},
        {-80707796,  7204979,   -80239076,  7696019,   0x001b08c},
        {-80239076,  8972723,   -79765148,  9463763,   0x001b88c},
        {-80239076,  8481683,   -79765148,  8972723,   0x001c08c},
        {-80239076,  7990643,   -79770356,  8481683,   0x001c88c},
        {-80239076,  7352291,   -79770356,  7843331,   0x001d08c},
        {-79770356,  9169139,   -79296428,  9660179,   0x001d88c},
        {-79770356,  8678099,   -79296428,  9169139,   0x001e08c},
        {-79770356,  8187059,   -79301636,  8678099,   0x001e88c},
        {-79301636,  9169139,   -78827708,  9660179,   0x001f08c},
        {-79301636,  8678099,   -78827708,  9169139,   0x0010088},
        {-79206850,  8187059,   -78738130,  8678099,   0x0010888},
        {-78831874,  9169139,   -78357946,  9660179,   0x0011088},
        {-78831874,  8678099,   -78357946,  9169139,   0x0011888},
        {-78831874,  8187059,   -78363154,  8678099,   0x0012088},
        {-78831874,  7696019,   -78363154,  8187059,   0x0012888},
        {-78363154,  9169139,   -77889226,  9660179,   0x0013088},
        {-78363154,  8678099,   -77889226,  9169139,   0x0013888},
        {-78363154,  8187059,   -77894434,  8678099,   0x0014088},
        {-78363154,  7696019,   -77894434,  8187059,   0x0014888},
        {-78363154,  7204979,   -77894434,  7696019,   0x0015088},
        {-77894434,  8678099,   -77420506,  9169139,   0x0015888},
        {-77894434,  8187059,   -77425714,  8678099,   0x0016088},
        {-77894434,  7696019,   -77425714,  8187059,   0x0016888},
        {-77894434,  7204979,   -77425714,  7696019,   0x0017088},
        {-77608720,  8187059,   -77140000,  8678099,   0x0017888},
        {-77608720,  7696019,   -77140000,  8187059,   0x0018088},
        {-82331903,  7370480,   -82144415,  7566896,   0x0b1e090},
        {-81855371,  7711435,   -81667883,  7907851,   0x0b1e890},
        {-81637018,  8995753,   -81449530,  9192169,   0x0b1f090},
        {-92236000,  7190000,   -77140000,  18500000,  0x3300216},
        {-83054000,  7190000,   -77140000,  9670000,   0x003021c},
        {14363691,   50036755,  14497270,   50123245,  0x001000a}, // CZE
        {14220000,   49936630,  14743682,   50180000,  0xc730447},
        {16402657,   49063290,  16817343,   49336709,  0xbde0047},
        {18148419,   49644074,  18567662,   49917493,  0xbde0047},
        {13303691,   49698200,  13436308,   49784689,  0x3c1004b},
        {17183691,   49558200,  17316308,   49644689,  0x3c1004b},
        {14992250,   50719500,  15127750,   50805989,  0x3c1004b},
        {14407512,   48936800,  14538687,   49023289,  0x3c1004b},
        {15766371,   50176800,  15900429,   50263289,  0x3c1004b},
        {13952250,   50626800,  14087750,   50713289,  0x3c1004b},
        {15702971,   49986800,  15837029,   50073289,  0x3c1004b},
        {17584412,   49169500,  17715587,   49255989,  0x3c1004b},
        {14036371,   50106800,  14170429,   50193289,  0x3c1004b},
        {13602950,   50466800,  13738450,   50553289,  0x3c1004b},
        {17822971,   49896800,  17957029,   49983289,  0x3c1004b},
        {12776171,   50196800,  12910229,   50283289,  0x3c1004b},
        {14122250,   50728200,  14257750,   50814689,  0x3c1004b},
        {13752250,   50606800,  13887750,   50693289,  0x3c1004b},
        {13329050,   50425400,  13464550,   50511889,  0x3c1004b},
        {15513691,   49356800,  15646308,   49443289,  0x3c1004b},
        {17386891,   49411800,  17519508,   49498289,  0x3c1004b},
        {17053691,   49436800,  17186308,   49523289,  0x3c1004b},
        {14832250,   50376800,  14967750,   50463289,  0x3c1004b},
        {15134255,   50688350,  15231544,   50750449,  0x2b2004b},
        {14482906,   50659940,  14577093,   50720059,  0x29c004b},
        {15822908,   49188950,  15917092,   49251049,  0x2b2004b},
        {18613908,   49659940,  18706091,   49720059,  0x29c004b},
        {14627390,   49363850,  14722609,   49425949,  0x2b2004b},
        {13959408,   49657540,  14051591,   49717659,  0x29c004b},
        {16012908,   48828950,  16107092,   48891049,  0x2b2004b},
        {12320207,   50046040,  12413392,   50106159,  0x29c004b},
        {15878455,   50542150,  15975744,   50604249,  0x2b2004b},
        {15143407,   49999940,  15236592,   50060059,  0x29c004b},
        {14104408,   49278450,  14198592,   49340549,  0x2b2004b},
        {16935007,   49940940,  17028192,   50001059,  0x29c004b},
        {17348608,   49271650,  17442792,   49333749,  0x2b2004b},
        {17940408,   49326440,  18032591,   49386559,  0x29c004b},
        {17922390,   49448950,  18017609,   49511049,  0x2b2004b},
        {17101109,   48834640,  17192290,   48894759,  0x29c004b},
        {13551655,   50566350,  13648944,   50628449,  0x2b2004b},
        {17944108,   49569940,  18036291,   49630059,  0x29c004b},
        {17414408,   49024750,  17508592,   49086849,  0x2b2004b},
        {16829410,   48726840,  16919589,   48786959,  0x29c004b},
        {18572390,   49718950,  18667609,   49781049,  0x2b2004b},
        {17650007,   50060040,  17743192,   50120159,  0x29c004b},
        {12594873,   50158850,  12691127,   50220949,  0x2b2004b},
        {14093406,   50501140,  14187593,   50561259,  0x29c004b},
        {13189096,   50564766,  13923424,   51055806,  0x001088c},
        {13923424,   50564766,  14657752,   51055806,  0x001108c},
        {14657752,   50564766,  15392080,   51055806,  0x001188c},
        {15392080,   50564766,  16473000,   50830000,  0x012208c},
        {12095416,   49975518,  12819328,   50466558,  0x001288c},
        {12819328,   50073726,  13543240,   50564766,  0x001308c},
        {13543240,   50073726,  14267152,   50564766,  0x001388c},
        {14267152,   50073726,  14991064,   50564766,  0x001408c},
        {14991064,   50073726,  15714976,   50564766,  0x001488c},
        {15714976,   50073726,  16438888,   50564766,  0x001508c},
        {16438888,   50073726,  17162800,   50564766,  0x001588c},
        {17162800,   50073726,  17886712,   50564766,  0x001608c},
        {12384980,   49582686,  13103684,   50073726,  0x001688c},
        {13103684,   49582686,  13822388,   50073726,  0x001708c},
        {13822388,   49582686,  14541092,   50073726,  0x001788c},
        {14541092,   49582686,  15259796,   50073726,  0x001808c},
        {15259796,   49582686,  15978500,   50073726,  0x001888c},
        {15978500,   49582686,  16697204,   50073726,  0x001908c},
        {16697204,   49582686,  17415908,   50073726,  0x001988c},
        {17415908,   49582686,  18134612,   50073726,  0x001a08c},
        {18134612,   49582686,  18853316,   50073726,  0x001a88c},
        {12490807,   49091646,  13199095,   49582686,  0x001b08c},
        {13199095,   49091646,  13907383,   49582686,  0x001b88c},
        {13907383,   49091646,  14615671,   49582686,  0x001c08c},
        {14615671,   49091646,  15323959,   49582686,  0x001c88c},
        {15323959,   49091646,  16032247,   49582686,  0x001d08c},
        {16032247,   49091646,  16740535,   49582686,  0x001d88c},
        {16740535,   49091646,  17448823,   49582686,  0x001e08c},
        {17448823,   49091646,  18157111,   49582686,  0x001e88c},
        {18157111,   49091646,  18865399,   49582686,  0x001f08c},
        {13204303,   48600606,  13907383,   49091646,  0x0b00890},
        {13907383,   48600606,  14610463,   49091646,  0x0b01090},
        {14610463,   48600606,  15313543,   49091646,  0x0b01890},
        {15313543,   48600606,  16016623,   49091646,  0x0b02090},
        {16016623,   48600606,  16719703,   49091646,  0x0b02890},
        {16719703,   48600606,  17422783,   49091646,  0x0b03090},
        {17422783,   48600606,  18125863,   49091646,  0x0b03890},
        {14053207,   48109566,  14745871,   48600606,  0x0b14090},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {12090000,   48546000,  18860000,   51061000,  0x003021c},
        {-52345874,  4864949,   -52259384,  4951439,   0x001000a}, // GUF
        {-52715086,  4758287,   -52246366,  5249327,   0x001000c},
        {-54086273,  5394160,   -53873328,  5605929,   0x931004b},
        {-52881928,  5163040,   -52688072,  5356359,   0x864004b},
        {-53929597,  5577140,   -53735204,  5770459,   0x864004b},
        {-54401128,  5039040,   -54207272,  5232359,   0x864004b},
        {-54402128,  4153440,   -54208272,  4346759,   0x864004b},
        {-53047197,  5286340,   -52852804,  5479659,   0x864004b},
        {-54237896,  5288960,   -53769176,  5780000,   0x001088c},
        {-53769176,  5288960,   -53300456,  5780000,   0x001108c},
        {-53300456,  5293512,   -52660000,  5600000,   0x015188c},
        {-54472255,  4802472,   -54003535,  5293512,   0x001208c},
        {-54003535,  4802472,   -53534815,  5293512,   0x001288c},
        {-53534815,  4802472,   -53066095,  5293512,   0x001308c},
        {-53066095,  4802472,   -52597375,  5293512,   0x001388c},
        {-52597375,  4802472,   -52128655,  5293512,   0x001408c},
        {-54472255,  4311432,   -54003535,  4802472,   0x001488c},
        {-54003535,  4311432,   -53534815,  4802472,   0x001508c},
        {-53534815,  4311432,   -53066095,  4802472,   0x001588c},
        {-53066095,  4311432,   -52597375,  4802472,   0x001608c},
        {-52597375,  4311432,   -52128655,  4802472,   0x001688c},
        {-52128655,  4311432,   -51659935,  4802472,   0x001708c},
        {-54425383,  3820392,   -53956663,  4311432,   0x001788c},
        {-53956663,  3820392,   -53487943,  4311432,   0x001808c},
        {-53487943,  3820392,   -53019223,  4311432,   0x001888c},
        {-53019223,  3820392,   -52550503,  4311432,   0x001908c},
        {-52550503,  3820392,   -52081783,  4311432,   0x001988c},
        {-52081783,  3820392,   -51613063,  4311432,   0x001a08c},
        {-54191023,  3329352,   -53722303,  3820392,   0x001a88c},
        {-53722303,  3329352,   -53253583,  3820392,   0x001b08c},
        {-53253583,  3329352,   -52784863,  3820392,   0x001b88c},
        {-52784863,  3329352,   -52316143,  3820392,   0x001c08c},
        {-52316143,  3329352,   -51847423,  3820392,   0x001c88c},
        {-54214459,  2838312,   -53745739,  3329352,   0x001d08c},
        {-53745739,  2838312,   -53277019,  3329352,   0x001d88c},
        {-53277019,  2838312,   -52808299,  3329352,   0x001e08c},
        {-52808299,  2838312,   -52339579,  3329352,   0x001e88c},
        {-52620811,  2838312,   -52152091,  3329352,   0x001f08c},
        {-54565999,  2470032,   -54097279,  2961072,   0x0b00090},
        {-54097279,  2470032,   -53628559,  2961072,   0x0b00890},
        {-53628559,  2470032,   -53159839,  2961072,   0x0b01090},
        {-53159839,  2470032,   -52691119,  2961072,   0x0b01890},
        {-52878607,  2470032,   -52409887,  2961072,   0x0b02090},
        {-54565999,  2100000,   -54097279,  2591040,   0x0b02890},
        {-54097279,  2100000,   -53628559,  2591040,   0x0b03090},
        {-53628559,  2100000,   -53159839,  2591040,   0x0b03890},
        {-53159839,  2100000,   -52691119,  2591040,   0x0b04090},
        {-52972351,  2100000,   -52503631,  2591040,   0x0b04890},
        {-52660000,  5275000,   -52250000,  5780000,   0x0c05090},
        {-52128655,  4802472,   -51659935,  5293512,   0x0b05890},
        {-54597000,  2100000,   -51514000,  5780000,   0x0010216},
        {54318811,   24427655,  54412989,   24514145,  0x001000a}, // ARE
        {55039533,   24943292,  55555125,   25434332,  0x001000c},
        {54378870,   24337590,  54512730,   24459899,  0x54f004b},
        {54512730,   24337590,  54646590,   24459899,  0x54f004b},
        {54646590,   24337590,  54780450,   24459899,  0x54f004b},
        {54445800,   24215281,  54579660,   24337590,  0x54f004b},
        {54579660,   24215281,  54713520,   24337590,  0x54f004b},
        {54614463,   24459899,  54748323,   24582208,  0x54f004b},
        {54668007,   24582208,  54801867,   24704517,  0x54f004b},
        {55673070,   24168890,  55806930,   24291199,  0x54f004b},
        {55539210,   24144428,  55673070,   24266737,  0x54f004b},
        {55619696,   24046581,  55753216,   24168890,  0x54f004b},
        {55753216,   24046581,  55886736,   24168890,  0x54f004b},
        {55878790,   25688790,  56014009,   25811099,  0x54f004b},
        {55953171,   25809800,  56049029,   25896289,  0x3c1004b},
        {56313300,   25025000,  56368343,   25174450,  0x3c1044b},
        {56333333,   25267400,  56378903,   25448600,  0x3c1044b},
        {55525000,   25492000,  55609375,   25590000,  0x3c1044b},
        {55475330,   25434250,  55618410,   25492000,  0x3c1044b},
        {54944031,   24962200,  55039169,   25048689,  0x3c1004b},
        {56243191,   25548300,  56338809,   25634789,  0x3c1004b},
        {55868808,   25592260,  56384400,   26083300,  0x001008c},
        {55868808,   25216044,  56384400,   25707084,  0x001088c},
        {55868808,   24725004,  56384400,   25216044,  0x001108c},
        {55353216,   25382997,  55868808,   25874037,  0x001188c},
        {55353216,   24891957,  55868808,   25382997,  0x001208c},
        {54837624,   24891957,  55353216,   25382997,  0x001288c},
        {54064236,   24499125,  54574620,   24990165,  0x001308c},
        {54574620,   24499125,  55085004,   24990165,  0x001388c},
        {55085004,   24499125,  55595388,   24990165,  0x001408c},
        {55595388,   24499125,  56105772,   24990165,  0x001488c},
        {51512315,   24008085,  52022699,   24499125,  0x001508c},
        {52022699,   24008085,  52533083,   24499125,  0x001588c},
        {52533083,   24008085,  53043467,   24499125,  0x001608c},
        {53043467,   24008085,  53553851,   24499125,  0x001688c},
        {53553851,   24008085,  54064235,   24499125,  0x001708c},
        {54064235,   24008085,  54574619,   24499125,  0x001788c},
        {54574619,   24008085,  55085003,   24499125,  0x001808c},
        {55085003,   24008085,  55595387,   24499125,  0x001888c},
        {55595387,   24008085,  56105771,   24499125,  0x001908c},
        {51543043,   23517045,  52048219,   24008085,  0x001988c},
        {52048219,   23517045,  52553395,   24008085,  0x001a08c},
        {52553395,   23517045,  53058571,   24008085,  0x001a88c},
        {53058571,   23517045,  53563747,   24008085,  0x001b08c},
        {53563747,   23517045,  54068923,   24008085,  0x001b88c},
        {54068923,   23517045,  54574099,   24008085,  0x001c08c},
        {54574099,   23517045,  55079275,   24008085,  0x001c88c},
        {55079275,   23517045,  55584451,   24008085,  0x001d08c},
        {52553395,   23026005,  53058571,   23517045,  0x001d88c},
        {53058571,   23026005,  53563747,   23517045,  0x001e08c},
        {53563747,   23026005,  54068923,   23517045,  0x001e88c},
        {54068923,   23026005,  54574099,   23517045,  0x001f08c},
        {52048219,   23026005,  52553395,   23517045,  0x0b15090},
        {54574099,   23026005,  55079275,   23517045,  0x0b15890},
        {55079275,   23026005,  55584451,   23517045,  0x0b16890},
        {52452360,   22614011,  52957536,   23105051,  0x0b17890},
        {52957536,   22614011,  53462712,   23105051,  0x0b18890},
        {53462712,   22614011,  53967888,   23105051,  0x0b19890},
        {53967888,   22614011,  54473064,   23105051,  0x0b1a890},
        {54473064,   22614011,  54978240,   23105051,  0x0b1b890},
        {54978240,   22614011,  55483416,   23105051,  0x0b1c090},
        {51690000,   24390000,  55120000,   25960000,  0x015000d},
        {51511000,   22614011,  56400000,   26083300,  0x0010216},
        {16306574,   48176755,  16434387,   48263245,  0x001000a}, // AUT
        {16143000,   47696000,  16598000,   48401300,  0x02d000c},
        {14229933,   48260300,  14359667,   48346789,  0x3c1004b},
        {15377235,   47036800,  15503365,   47123289,  0x3c1004b},
        {15377235,   46950311,  15503365,   47036800,  0x3c1004b},
        {11338134,   47248700,  11531715,   47305500,  0x3c1044b},
        {12966834,   47766400,  13095366,   47852889,  0x3c1004b},
        {14240535,   46579900,  14365464,   46666389,  0x3c1004b},
        {13787535,   46576800,  13912464,   46663289,  0x3c1004b},
        {13965734,   48126800,  14094266,   48213289,  0x3c1004b},
        {15594934,   48166900,  15723466,   48253389,  0x3c1004b},
        {14345734,   47996800,  14474266,   48083289,  0x3c1004b},
        {9539934,    47206500,  9667265,    47292989,  0x3c1004b},
        {9639834,    47423700,  9767165,    47510189,  0x3c1004b},
        {9637834,    47337400,  9765165,    47423889,  0x3c1004b},
        {14990134,   47350300,  15117465,   47436789,  0x3c1004b},
        {14778735,   46791900,  14904865,   46878389,  0x3c1004b},
        {15568133,   48368800,  15697867,   48455289,  0x3c1004b},
        {14200534,   48175500,  14329066,   48261989,  0x3c1004b},
        {14820634,   48066800,  14949166,   48153289,  0x3c1004b},
        {15216134,   47389500,  15343465,   47475989,  0x3c1004b},
        {13010834,   47664900,  13138165,   47751389,  0x3c1004b},
        {12957034,   48199400,  13085566,   48285889,  0x3c1004b},
        {13465835,   46761200,  13591965,   46847689,  0x3c1004b},
        {12108834,   47549000,  12236165,   47635489,  0x3c1004b},
        {15046935,   47016800,  15173065,   47103289,  0x3c1004b},
        {15476935,   46752800,  15603065,   46839289,  0x3c1004b},
        {12817488,   47380850,  12908912,   47442949,  0x2b2004b},
        {16005445,   47685240,  16093954,   47745359,  0x29c004b},
        {14028319,   46698950,  14118880,   46761049,  0x2b2004b},
        {9587445,    47306240,  9675954,    47366359,  0x29c004b},
        {16000125,   48278250,  16093274,   48340349,  0x2b2004b},
        {9756763,    47135740,  9844437,    47195859,  0x29c004b},
        {11021088,   47270850,  11112512,   47332949,  0x2b2004b},
        {13739828,   47889640,  13829172,   47949759,  0x29c004b},
        {14310419,   46729150,  14400980,   46791249,  0x2b2004b},
        {11651245,   47314240,  11739754,   47374359,  0x29c004b},
        {14784288,   47188950,  14875712,   47251049,  0x2b2004b},
        {12745363,   46799840,  12833037,   46859959,  0x29c004b},
        {13436725,   48538016,  14139805,   48790000,  0x001008c},
        {14139805,   48538016,  14842885,   48790000,  0x001088c},
        {14842885,   48538016,  15545965,   49029000,  0x001108c},
        {15545965,   48538016,  16249045,   48920000,  0x001188c},
        {16249044,   48538016,  16952124,   48822000,  0x001208c},
        {12738852,   48046976,  13431516,   48538016,  0x001288c},
        {13431516,   48046976,  14124180,   48538016,  0x001308c},
        {14124180,   48046976,  14816844,   48538016,  0x001388c},
        {14816844,   48046976,  15509508,   48538016,  0x001408c},
        {15509508,   48046976,  16202172,   48538016,  0x001488c},
        {16202172,   48046976,  16699999,   48538016,  0x001508c},
        {16699999,   48046976,  17188000,   48538016,  0x001588c},
        {12738852,   47555936,  13426308,   48046976,  0x001608c},
        {13426308,   47555936,  14113764,   48046976,  0x001688c},
        {14113764,   47555936,  14801220,   48046976,  0x001708c},
        {14801220,   47555936,  15488676,   48046976,  0x001788c},
        {15488676,   47555936,  16176132,   48046976,  0x001808c},
        {16176132,   47555936,  16700000,   48046976,  0x001888c},
        {16700000,   47670000,  17188000,   48046976,  0x001908c},
        {12744061,   47064896,  13426309,   47555936,  0x001988c},
        {13426309,   47064896,  14108557,   47555936,  0x001a08c},
        {14108557,   47064896,  14790805,   47555936,  0x001a88c},
        {14790805,   47064896,  15473053,   47555936,  0x001b08c},
        {15473053,   47064896,  16155301,   47555936,  0x001b88c},
        {16155301,   47064896,  16837549,   47555936,  0x001c08c},
        {12744061,   46573856,  13421101,   47064896,  0x001c88c},
        {13421101,   46573856,  14098141,   47064896,  0x001d08c},
        {14098141,   46573856,  14775181,   47064896,  0x001d88c},
        {14775180,   46573856,  15452220,   47064896,  0x001e08c},
        {15452220,   46573856,  16129260,   47064896,  0x001e88c},
        {16129260,   46573856,  16806300,   47064896,  0x001f08c},
        {13087788,   46082816,  13754412,   46573856,  0x0b1e090},
        {13754412,   46082816,  14421036,   46573856,  0x0b1e890},
        {14421036,   46082816,  15087660,   46573856,  0x0b1f090},
        {9469000,    47209779,  10217582,   47600000,  0x0970090},
        {9469000,    46835000,  10217582,   47209779,  0x0930890},
        {10212374,   47209779,  10899830,   47600000,  0x09d1090},
        {10217582,   46750000,  10899830,   47209779,  0x0ab1890},
        {10894622,   47209779,  11582078,   47540000,  0x0912090},
        {10899830,   46750000,  11582078,   47209779,  0x0ab2890},
        {11576870,   47258883,  12264326,   47749923,  0x0b13090},
        {11582078,   46850000,  12264326,   47258883,  0x0a13890},
        {12259118,   47209779,  12750000,   47700819,  0x0d14090},
        {12264326,   46630000,  12750000,   47209779,  0x0e24890},
        {5850000,    35450000,  18560000,   55080000,  0x50a0216},
        {9469000,    46366000,  17180000,   49022000,  0x003021c},
        {49784462,   40357279,  49896899,   40443769,  0x001000a}, // AZE
        {49518792,   40289000,  50364000,   40636000,  0x016000c},
        {46280650,   40621890,  46360940,   40744199,  0x3c1044b},
        {46360940,   40621890,  46441230,   40744199,  0x3c1044b},
        {46964000,   40727000,  47125055,   40788000,  0x3c1044b},
        {48860262,   39899600,  48972938,   39986089,  0x3c1004b},
        {45365403,   39148100,  45476397,   39234589,  0x3c1004b},
        {47143921,   41155300,  47258279,   41241789,  0x3c1004b},
        {47093181,   40574800,  47206818,   40661289,  0x3c1004b},
        {46722742,   39792500,  46834457,   39878989,  0x3c1004b},
        {48767963,   38707200,  48878236,   38793689,  0x3c1004b},
        {46872462,   39951500,  46985138,   40037989,  0x3c1004b},
        {47053662,   40346800,  47166338,   40433289,  0x3c1004b},
        {48742340,   41426800,  48857659,   41513289,  0x3c1004b},
        {48910142,   39544700,  49021857,   39631189,  0x3c1004b},
        {48461303,   39185400,  48572297,   39271889,  0x3c1004b},
        {47680881,   40583900,  47794518,   40670389,  0x3c1004b},
        {45994181,   40800100,  46107818,   40886589,  0x3c1004b},
        {47383562,   40011000,  47496238,   40097489,  0x3c1004b},
        {47994142,   39826800,  48105857,   39913289,  0x3c1004b},
        {48567981,   40591800,  48681618,   40678289,  0x3c1004b},
        {48423662,   39956800,  48536338,   40043289,  0x3c1004b},
        {48018742,   39651800,  48130457,   39738289,  0x3c1004b},
        {47401481,   40616000,  47515118,   40702489,  0x3c1004b},
        {48873262,   39998000,  48985938,   40084489,  0x3c1004b},
        {48484045,   41344950,  48566154,   41407049,  0x2b2004b},
        {49089154,   41060540,  49168645,   41120659,  0x29c004b},
        {48955045,   41180250,  49037154,   41242349,  0x2b2004b},
        {45327554,   41070640,  45407045,   41130759,  0x29c004b},
        {49209594,   39345750,  49289805,   39407849,  0x2b2004b},
        {46711173,   39729940,  46788827,   39790059,  0x29c004b},
        {46596300,   41595150,  46679099,   41657249,  0x2b2004b},
        {48523673,   39416940,  48601327,   39477059,  0x29c004b},
        {46889549,   40308950,  46970450,   40371049,  0x2b2004b},
        {48123239,   40319640,  48201561,   40379759,  0x29c004b},
        {46297204,   40552150,  46378795,   40614249,  0x2b2004b},
        {48329239,   39904940,  48407561,   39965059,  0x29c004b},
        {48349204,   40538950,  48430795,   40601049,  0x2b2004b},
        {48380254,   41389940,  48459745,   41450059,  0x29c004b},
        {47610104,   40479850,  47691695,   40541949,  0x2b2004b},
        {48813174,   38396940,  48889826,   38457059,  0x29c004b},
        {45999920,   41438960,  46624880,   41930000,  0x001008c},
        {46624879,   41438960,  47249839,   41930000,  0x001088c},
        {47999791,   41438960,  48624751,   41930000,  0x001108c},
        {48624751,   41438960,  49249711,   41930000,  0x001188c},
        {44967694,   40997024,  45587446,   41488064,  0x001208c},
        {45587446,   40997024,  46207198,   41488064,  0x001288c},
        {46207198,   40997024,  46826950,   41488064,  0x001308c},
        {46826950,   40997024,  47446702,   41488064,  0x001388c},
        {47446702,   40997024,  48066454,   41488064,  0x001408c},
        {48066454,   40997024,  48686206,   41488064,  0x001488c},
        {48686206,   40997024,  49305958,   41488064,  0x001508c},
        {45184607,   40505984,  45799151,   40997024,  0x001588c},
        {45799151,   40505984,  46413695,   40997024,  0x001608c},
        {46413695,   40505984,  47028239,   40997024,  0x001688c},
        {47028239,   40505984,  47642783,   40997024,  0x001708c},
        {47642783,   40505984,  48257327,   40997024,  0x001788c},
        {48257327,   40505984,  48871871,   40997024,  0x001808c},
        {48871871,   40505984,  49486415,   40997024,  0x001888c},
        {49486415,   40505984,  50100959,   40997024,  0x001908c},
        {45281997,   40014944,  45891333,   40505984,  0x001988c},
        {45891333,   40014944,  46500669,   40505984,  0x001a08c},
        {46500669,   40014944,  47110005,   40505984,  0x001a88c},
        {47110005,   40014944,  47719341,   40505984,  0x001b08c},
        {47719341,   40014944,  48328677,   40505984,  0x001b88c},
        {48328677,   40014944,  48938013,   40505984,  0x001c08c},
        {48938013,   40014944,  49547349,   40505984,  0x001c88c},
        {49547349,   40014944,  50156685,   40505984,  0x001d08c},
        {50065284,   40162256,  50674620,   40653296,  0x001d88c},
        {45586665,   39523904,  46190793,   40014944,  0x001e08c},
        {46190793,   39523904,  46794921,   40014944,  0x001e88c},
        {46794921,   39523904,  47399049,   40014944,  0x001f08c},
        {47399049,   39523904,  48003177,   40014944,  0x0015088},
        {48003177,   39523904,  48607305,   40014944,  0x0015888},
        {48607305,   39523904,  49211433,   40014944,  0x0016088},
        {49211433,   39523904,  49815561,   40014944,  0x0016888},
        {46377239,   39032864,  46976159,   39523904,  0x0017088},
        {46976159,   39032864,  47575079,   39523904,  0x0017888},
        {48114107,   39032864,  48713027,   39523904,  0x0018888},
        {48713027,   39032864,  49311947,   39523904,  0x0019088},
        {49311947,   39032864,  49910867,   39523904,  0x0019888},
        {46377239,   38836448,  46976159,   39327488,  0x001a888},
        {48024269,   38541824,  48617981,   39032864,  0x001b088},
        {48439868,   38541824,  49033580,   39032864,  0x001b888},
        {49033580,   38541824,  49627292,   39032864,  0x001c088},
        {48474761,   38388000,  49063265,   38879040,  0x001c888},
        {44760000,   39330000,  45360000,   39812000,  0x0010888},
        {45360000,   39330000,  45950000,   39610000,  0x0011088},
        {45060000,   38950000,  45600000,   39330000,  0x0011888},
        {45600000,   38840000,  46155000,   39330000,  0x0012088},
        {44750000,   38388000,  50800000,   41930000,  0x0010216},
        {20399498,   44769457,  20520584,   44855947,  0x001000a}, // SRB
        {20171896,   44633584,  20828104,   45124624,  0x001000c},
        {21111379,   42606800,  21228620,   42693289,  0x3c1004b},
        {21000779,   42586000,  21118020,   42672489,  0x3c1004b},
        {20681860,   42186800,  20798140,   42273289,  0x3c1004b},
        {20251379,   42616800,  20368620,   42703289,  0x3c1004b},
        {20371860,   42346800,  20488140,   42433289,  0x3c1004b},
        {20811379,   42846800,  20928620,   42933289,  0x3c1004b},
        {21421860,   42426800,  21538140,   42513289,  0x3c1004b},
        {21139060,   42334400,  21255340,   42420889,  0x3c1004b},
        {20601860,   42366800,  20718140,   42453289,  0x3c1004b},
        {21131379,   42866800,  21248620,   42953289,  0x3c1004b},
        {19765537,   45213100,  19888063,   45299589,  0x3c1004b},
        {21856499,   43277500,  21974701,   43363989,  0x3c1004b},
        {20853818,   43970600,  20972981,   44057089,  0x3c1004b},
        {19618136,   46052900,  19741863,   46139389,  0x3c1004b},
        {20344237,   45314600,  20466763,   45401089,  0x3c1004b},
        {20307918,   43840600,  20427081,   43927089,  0x3c1004b},
        {21891379,   42956800,  22008620,   43043289,  0x3c1004b},
        {20888037,   44602700,  21009362,   44689189,  0x3c1004b},
        {19829818,   44236800,  19950182,   44323289,  0x3c1004b},
        {20605618,   43671100,  20724781,   43757589,  0x3c1004b},
        {21268618,   43531800,  21387781,   43618289,  0x3c1004b},
        {19804918,   43813400,  19924081,   43899889,  0x3c1004b},
        {21855210,   42514150,  21939389,   42576249,  0x2b2004b},
        {19645633,   44727740,  19729967,   44787859,  0x29c004b},
        {19069182,   45741350,  19158018,   45803449,  0x2b2004b},
        {21141833,   44593140,  21226167,   44653259,  0x29c004b},
        {20418482,   45794750,  20507318,   45856849,  0x2b2004b},
        {22557718,   43118740,  22639881,   43178859,  0x29c004b},
        {22230320,   43873950,  22315879,   43936049,  0x2b2004b},
        {22090984,   44023740,  22173815,   44083859,  0x29c004b},
        {19552444,   44951250,  19639555,   45013349,  0x2b2004b},
        {21255833,   45085640,  21340167,   45145759,  0x29c004b},
        {21217220,   43948950,  21302779,   44011049,  0x2b2004b},
        {19779433,   44976240,  19863767,   45036359,  0x29c004b},
        {19348513,   45208550,  19436487,   45270649,  0x2b2004b},
        {20038133,   45016040,  20122467,   45076159,  0x29c004b},
        {19597113,   45543150,  19685087,   45605249,  0x2b2004b},
        {19999415,   45588240,  20084584,   45648359,  0x29c004b},
        {21371620,   43822750,  21457179,   43884849,  0x2b2004b},
        {20922767,   44337840,  21006433,   44397959,  0x29c004b},
        {18829666,   45703960,  19496290,   46195000,  0x001088c},
        {19496290,   45703960,  20162914,   46195000,  0x001108c},
        {20162914,   45703960,  20829538,   46195000,  0x001188c},
        {18901536,   45212920,  19562952,   45703960,  0x001208c},
        {19562952,   45212920,  20224368,   45703960,  0x001288c},
        {20224368,   45212920,  20885784,   45703960,  0x001308c},
        {20885784,   45212920,  21547200,   45703960,  0x001388c},
        {18967678,   44721880,  19623886,   45212920,  0x001408c},
        {19623886,   44721880,  20280094,   45212920,  0x001488c},
        {20280094,   44721880,  20936302,   45212920,  0x001508c},
        {20936302,   44721880,  21592510,   45212920,  0x001588c},
        {19038507,   44230840,  19689507,   44721880,  0x001608c},
        {19689507,   44230840,  20340507,   44721880,  0x001688c},
        {20340507,   44230840,  20991507,   44721880,  0x001708c},
        {20991507,   44230840,  21642507,   44721880,  0x001788c},
        {21642507,   44230840,  22293507,   44721880,  0x001808c},
        {22293507,   44230840,  22944507,   44721880,  0x001888c},
        {19038507,   43739800,  19684299,   44230840,  0x001908c},
        {19684299,   43739800,  20330091,   44230840,  0x001988c},
        {20330091,   43739800,  20975883,   44230840,  0x001a08c},
        {20975883,   43739800,  21621675,   44230840,  0x001a88c},
        {21621675,   43739800,  22267467,   44230840,  0x001b08c},
        {22267467,   43739800,  22913259,   44230840,  0x001b88c},
        {19205163,   43248760,  19845747,   43739800,  0x001c08c},
        {19845747,   43248760,  20486331,   43739800,  0x001c88c},
        {20486331,   43248760,  21126915,   43739800,  0x001d08c},
        {21126915,   43248760,  21767499,   43739800,  0x001d88c},
        {21767499,   43248760,  22408083,   43739800,  0x001e08c},
        {22408083,   43248760,  23048667,   43739800,  0x001e88c},
        {19544672,   42782272,  20180048,   43273312,  0x0015088},
        {20180048,   42782272,  20815424,   43273312,  0x0015888},
        {20815424,   42782272,  21450800,   43273312,  0x0016088},
        {21450800,   42782272,  22086176,   43273312,  0x0016888},
        {22086176,   42782272,  22721552,   43273312,  0x0017088},
        {22721552,   42782272,  23356928,   43273312,  0x0017888},
        {20007351,   42291232,  20637519,   42782272,  0x0018088},
        {20637519,   42291232,  21267687,   42782272,  0x0018888},
        {21267687,   42291232,  21897855,   42782272,  0x0019088},
        {21897855,   42291232,  22560000,   42782272,  0x01e9888},
        {20360245,   41855000,  20870000,   42291232,  0x001a088},
        {20870000,   42080000,  21800000,   42291232,  0x010a888},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {18825000,   41855000,  23010000,   46200000,  0x003021c},
        {35865028,   31915755,  35965933,   32002245,  0x001000a}, // JOR
        {35698868,   31679107,  36245708,   32170147,  0x001000c},
        {35736634,   32458610,  35940365,   32631589,  0x782004b},
        {35669608,   32252520,  35845991,   32402279,  0x680004b},
        {34956396,   29478320,  35128203,   29628079,  0x680004b},
        {35962984,   32535320,  36140615,   32685079,  0x680004b},
        {36110008,   32281420,  36286391,   32431179,  0x680004b},
        {35643680,   30115120,  35816319,   30264879,  0x680004b},
        {35520364,   30755720,  35693835,   30905479,  0x680004b},
        {35838708,   32262820,  36015091,   32412579,  0x680004b},
        {35627640,   31105220,  35802359,   31254979,  0x680004b},
        {36499584,   32631320,  36677215,   32781079,  0x680004b},
        {38023396,   33027239,  38575444,   33518279,  0x001088c},
        {38575444,   33027239,  39127492,   33518279,  0x001108c},
        {35539180,   32536200,  36091228,   33027240,  0x001188c},
        {37140120,   32536200,  37692168,   33027240,  0x001208c},
        {37692168,   32536200,  38244216,   33027240,  0x001288c},
        {38244216,   32536200,  38796264,   33027240,  0x001308c},
        {38796264,   32536200,  39348312,   33027240,  0x001388c},
        {35483976,   32045160,  36036024,   32536200,  0x001408c},
        {36036024,   32045160,  36588072,   32536200,  0x001488c},
        {36588072,   32045160,  37140120,   32536200,  0x001508c},
        {37140120,   32045160,  37692168,   32536200,  0x001588c},
        {37692168,   32045160,  38244216,   32536200,  0x001608c},
        {38244216,   32045160,  38796264,   32536200,  0x001688c},
        {38796264,   32045160,  39348312,   32536200,  0x001708c},
        {35489184,   31554120,  36036024,   32045160,  0x001788c},
        {36036024,   31554120,  36582864,   32045160,  0x001808c},
        {36582864,   31554120,  37129704,   32045160,  0x001888c},
        {37129704,   31554120,  37676544,   32045160,  0x001908c},
        {37676544,   31554120,  38223384,   32045160,  0x001988c},
        {38223384,   31554120,  38770224,   32045160,  0x001a08c},
        {38770224,   31554120,  39317064,   32045160,  0x001a88c},
        {35325131,   31063080,  35871971,   31554120,  0x001b08c},
        {35871971,   31063080,  36418811,   31554120,  0x001b88c},
        {36418811,   31063080,  36965651,   31554120,  0x001c08c},
        {36965651,   31063080,  37512491,   31554120,  0x001c88c},
        {34942344,   30572040,  35483976,   31063080,  0x001d08c},
        {35483976,   30572040,  36025608,   31063080,  0x001d88c},
        {36025608,   30572040,  36567240,   31063080,  0x001e08c},
        {36567240,   30572040,  37108872,   31063080,  0x001e88c},
        {37108872,   30572040,  37650504,   31063080,  0x001f08c},
        {37650504,   30572040,  38192136,   31063080,  0x0b05890},
        {34947552,   30081000,  35483976,   30572040,  0x0b16090},
        {35483976,   30081000,  36020400,   30572040,  0x0b16890},
        {36020400,   30081000,  36556824,   30572040,  0x0b17090},
        {36556824,   30081000,  37093248,   30572040,  0x0b17890},
        {37093248,   30081000,  37629672,   30572040,  0x0b18090},
        {37629672,   30081000,  38166096,   30572040,  0x0b18890},
        {34947551,   29589960,  35483975,   30081000,  0x0b09090},
        {35483975,   29589960,  36020399,   30081000,  0x0b09890},
        {36020399,   29589960,  36556823,   30081000,  0x0b0a090},
        {36556823,   29589960,  37093247,   30081000,  0x0b0a890},
        {37093247,   29589960,  37629671,   30081000,  0x0b0b090},
        {34947551,   29098920,  35478767,   29589960,  0x0b1c090},
        {35478767,   29098920,  36009983,   29589960,  0x0b1c890},
        {36009983,   29180000,  36580000,   29589960,  0x09cd090},
        {34217000,   28520000,  48790000,   37390000,  0x0010216},
        {34870000,   29180000,  39310000,   33377300,  0x003021c},
        {-9199159,   38695782,  -9089605,   38782272,  0x001000a}, // PRT
        {-9501000,   38433500,  -8850000,   38869240,  0x01b000c},
        {-8726353,   41171666,  -8611995,   41258155,  0x3c1004b},
        {-8611995,   41171666,  -8497637,   41258155,  0x3c1004b},
        {-8693189,   41085177,  -8578831,   41171666,  0x3c1004b},
        {-8578831,   41085177,  -8464473,   41171666,  0x3c1004b},
        {-8660025,   40998688,  -8545667,   41085177,  0x3c1004b},
        {-8487660,   41506800,  -8372341,   41593289,  0x3c1004b},
        {-8497438,   40176300,  -8384762,   40262789,  0x3c1004b},
        {-17004000,  32633200,  -16829572,  32684000,  0x3c1044b},
        {-8747900,   40583700,  -8610022,   40654900,  0x3c1044b},
        {-8855858,   39706800,  -8744143,   39793289,  0x3c1004b},
        {-8056000,   37010400,  -7883810,   37064500,  0x3c1044b},
        {-8357179,   41396800,  -8242821,   41483289,  0x3c1004b},
        {-8598200,   37117200,  -8495717,   37164000,  0x2b2044b},
        {-7945926,   38540040,  -7869274,   38600159,  0x29c004b},
        {-7899943,   37983750,  -7821457,   38045849,  0x2b2004b},
        {-7538827,   39788740,  -7461173,   39848859,  0x29c004b},
        {-9083147,   38866250,  -9003453,   38928349,  0x2b2004b},
        {-8966627,   39716640,  -8888973,   39776759,  0x29c004b},
        {-7886926,   37013650,  -7809475,   37075749,  0x2b2004b},
        {-8728577,   39209940,  -8651424,   39270059,  0x29c004b},
        {-8781155,   41339350,  -8699046,   41401449,  0x2b2004b},
        {-7959495,   40639940,  -7880505,   40700059,  0x29c004b},
        {-7288996,   40517950,  -7207405,   40580049,  0x2b2004b},
        {-9187627,   39369740,  -9109973,   39429859,  0x29c004b},
        {-9394147,   39092050,  -9314453,   39154149,  0x2b2004b},
        {-8059091,   37088640,  -7984109,   37148759,  0x29c004b},
        {-8530796,   40868950,  -8449205,   40931049,  0x2b2004b},
        {-7666091,   37110840,  -7591109,   37170959,  0x29c004b},
        {-8596955,   41308350,  -8514846,   41370449,  0x2b2004b},
        {-25724900,  37731500,  -25627608,  37778100,  0x29c044b},
        {-6801600,   41775050,  -6718801,   41837149,  0x2b2004b},
        {-8444627,   39571840,  -8366973,   39631959,  0x29c004b},
        {-7513500,   41719250,  -7430701,   41781349,  0x2b2004b},
        {-8788846,   41397140,  -8709355,   41457259,  0x29c004b},
        {-8903047,   38892550,  -8823353,   38954649,  0x2b2004b},
        {-8518727,   39429440,  -8441073,   39489559,  0x29c004b},
        {-7520151,   40258850,  -7439250,   40320949,  0x2b2004b},
        {-8660080,   41499940,  -8579921,   41560059,  0x29c004b},
        {-8757200,   37075350,  -8661340,   37125440,  0x2b2044b},
        {-8678400,   40845700,  -8576825,   40892400,  0x29c044b},
        {-7472188,   38756150,  -7393012,   38818249,  0x2b2004b},
        {-8901661,   40119840,  -8823339,   40179959,  0x29c004b},
        {-8221306,   39435550,  -8141095,   39497649,  0x2b2004b},
        {-7789746,   41279940,  -7710255,   41340059,  0x29c004b},
        {-8660451,   39888950,  -8579550,   39951049,  0x2b2004b},
        {-8127491,   37039940,  -8052509,   37100059,  0x29c004b},
        {-8323200,   37071500,  -8197257,   37109600,  0x2b2044b},
        {-7468577,   39259940,  -7391424,   39320059,  0x29c004b},
        {-8121585,   41237274,  -8039476,   41299373,  0x2b2004b},
        {-8214251,   41419100,  -8134092,   41479219,  0x29c004b},
        {-8992480,   41695555,  -8367520,   42186595,  0x001008c},
        {-8367520,   41695555,  -7742560,   42186595,  0x001088c},
        {-7742559,   41695555,  -7117599,   42186595,  0x001108c},
        {-7117600,   41695555,  -6492640,   42186595,  0x001188c},
        {-8987272,   41204515,  -8367520,   41695555,  0x001208c},
        {-8367520,   41204515,  -7747768,   41695555,  0x001288c},
        {-7747768,   41204515,  -7128016,   41695555,  0x001308c},
        {-7128016,   41204515,  -6508264,   41695555,  0x001388c},
        {-6508264,   41204515,  -5888512,   41695555,  0x001408c},
        {-8987271,   40713475,  -8372727,   41204515,  0x001488c},
        {-8372727,   40713475,  -7758183,   41204515,  0x001508c},
        {-7758183,   40713475,  -7143639,   41204515,  0x001588c},
        {-7143639,   40713475,  -6529095,   41204515,  0x001608c},
        {-8982063,   40222435,  -8372727,   40713475,  0x001688c},
        {-8372727,   40222435,  -7763391,   40713475,  0x001708c},
        {-7763391,   40222435,  -7154055,   40713475,  0x001788c},
        {-7154055,   40222435,  -6544719,   40713475,  0x001808c},
        {-9103931,   39731395,  -8499803,   40222435,  0x001888c},
        {-8499803,   39731395,  -7895675,   40222435,  0x001908c},
        {-7895675,   39731395,  -7291547,   40222435,  0x001988c},
        {-7291547,   39639000,  -6860000,   40222435,  0x028a08c},
        {-9410786,   39240355,  -8811866,   39731395,  0x001a88c},
        {-8811866,   39240355,  -8212946,   39731395,  0x001b08c},
        {-8212946,   39240355,  -7614026,   39731395,  0x001b88c},
        {-7614026,   39240355,  -7015106,   39731395,  0x001c08c},
        {-9877943,   38749315,  -9284231,   39240355,  0x001c88c},
        {-9284231,   38749315,  -8690519,   39240355,  0x001d08c},
        {-8690519,   38749315,  -8096807,   39240355,  0x001d88c},
        {-8096807,   38749315,  -7503095,   39240355,  0x001e08c},
        {-7503095,   38749315,  -6909383,   39240355,  0x001e88c},
        {-9575879,   38258275,  -8987375,   38749315,  0x001f08c},
        {-8987375,   38258275,  -8398871,   38749315,  0x0010088},
        {-8398871,   38258275,  -7810367,   38749315,  0x0010888},
        {-7810367,   38258275,  -7221863,   38749315,  0x0011088},
        {-8987375,   37767235,  -8398871,   38258275,  0x0011888},
        {-8398871,   37767235,  -7810367,   38258275,  0x0012088},
        {-7810367,   37767235,  -7221863,   38258275,  0x0012888},
        {-7516115,   37889995,  -6927611,   38381035,  0x0013088},
        {-9046225,   37276195,  -8457721,   37767235,  0x0013888},
        {-8457721,   37276195,  -7869217,   37767235,  0x0014088},
        {-7869217,   37276195,  -7280713,   37767235,  0x0014888},
        {-9046225,   36785155,  -8462929,   37276195,  0x0015088},
        {-8462930,   36785155,  -7879634,   37276195,  0x0015888},
        {-7879634,   36785155,  -7296338,   37276195,  0x0016088},
        {-17320204,  32624000,  -16634000,  32890000,  0x0759890},
        {-16545000,  32402000,  -16275000,  33128000,  0x133b890},
        {-16217756,  29847341,  -15681332,  30338381,  0x0b0c090},
        {-31417659,  39303576,  -30818739,  39794616,  0x0b1c890},
        {-28840000,  38372000,  -28001000,  38651000,  0x070d090},
        {-28322000,  38525000,  -27845000,  39100000,  0x0d5d890},
        {-27845000,  38522000,  -27017000,  38822000,  0x075e090},
        {-25878000,  37684000,  -25118000,  37923000,  0x06ce890},
        {-25378928,  36736192,  -24795632,  37227232,  0x0b0f090},
        {-9722767,   41157162,  -6177638,   43838352,  0x0a80891},
        {-9839578,   38475972,  -6443404,   41157162,  0x0a91091},
        {-9979996,   35867000,  -6703000,   38475972,  0x0a61891},
        {-18145009,  31649405,  -15016954,  34330595,  0x0a99891},
        {-18115218,  28968215,  -15076536,  31649405,  0x0a9a091},
        {-31500000,  38595688,  -29057138,  40502312,  0x0a8c891},
        {-29032561,  37668688,  -26619490,  39575312,  0x0a7e091},
        {-26278640,  36409012,  -23895360,  38315636,  0x0a7f091},
        {-31500000,  27500000,  4400000,    43850000,  0x0010217},
        {-31500000,  29660000,  -6170000,   42154300,  0x003021c},
        {18982634,   47451000,  19109965,   47537489,  0x001000a}, // HUN
        {18707922,   47323584,  19395378,   47814624,  0x001000c},
        {21574834,   47484200,  21702165,   47570689,  0x3c1004b},
        {20671600,   48048600,  20816985,   48125000,  0x3c1044b},
        {20085535,   46209800,  20210464,   46296289,  0x3c1004b},
        {18174836,   46028300,  18298563,   46114789,  0x3c1004b},
        {17590134,   47643300,  17717465,   47729789,  0x3c1004b},
        {21663434,   47911500,  21791966,   47997989,  0x3c1004b},
        {19626935,   46866800,  19753065,   46953289,  0x3c1004b},
        {18352935,   47142200,  18479065,   47228689,  0x3c1004b},
        {16563034,   47191700,  16690365,   47278189,  0x3c1004b},
        {20117535,   47123700,  20243665,   47210189,  0x3c1004b},
        {18325734,   47521400,  18453065,   47607889,  0x3c1004b},
        {17727535,   46316800,  17852464,   46403289,  0x3c1004b},
        {21025235,   46629600,  21150164,   46716089,  0x3c1004b},
        {16782419,   46809750,  16872980,   46871849,  0x2b2004b},
        {17877363,   47071840,  17965037,   47131959,  0x29c004b},
        {20317957,   47864250,  20410243,   47926349,  0x2b2004b},
        {16537745,   47657040,  16626254,   47717159,  0x29c004b},
        {18905800,   46948950,  18970636,   47035500,  0x2b2044b},
        {16946580,   46429940,  17033419,   46490059,  0x29c004b},
        {20274350,   46383950,  20364049,   46446049,  0x2b2004b},
        {19775328,   48041000,  19833374,   48133300,  0x29c044b},
        {20246957,   48195850,  20339243,   48257949,  0x2b2004b},
        {18916780,   46152940,  19003619,   46213059,  0x29c004b},
        {19738219,   47149250,  19828780,   47211349,  0x2b2004b},
        {18660180,   46320940,  18747019,   46381059,  0x29c004b},
        {19885557,   47762250,  19977843,   47824349,  0x2b2004b},
        {17425745,   47299940,  17514254,   47360059,  0x29c004b},
        {21241180,   46626340,  21362989,   46672000,  0x2b2044b},
        {20590828,   48228440,  20680172,   48288559,  0x29c004b},
        {21456888,   47640750,  21548312,   47702849,  0x2b2004b},
        {19796163,   46679940,  19883837,   46740059,  0x29c004b},
        {20591000,   46542000,  20702279,   46592000,  0x2b2044b},
        {20216580,   46629940,  20303419,   46690059,  0x29c004b},
        {17240057,   47837450,  17332343,   47899549,  0x2b2004b},
        {19436580,   46399940,  19523419,   46460059,  0x29c004b},
        {19864288,   47468950,  19955712,   47531049,  0x2b2004b},
        {18216480,   46166940,  18303319,   46227059,  0x29c004b},
        {19737819,   47003950,  19828380,   47066049,  0x2b2004b},
        {20440880,   46188140,  20527719,   46248259,  0x29c004b},
        {18279288,   47623750,  18370712,   47685849,  0x2b2004b},
        {21340845,   47415140,  21429354,   47475259,  0x29c004b},
        {18006619,   46862150,  18097180,   46924249,  0x2b2004b},
        {19635745,   47639940,  19724254,   47700059,  0x29c004b},
        {20364719,   47148950,  20455280,   47211049,  0x2b2004b},
        {20882945,   47282340,  20971454,   47342459,  0x29c004b},
        {17234519,   46739150,  17325080,   46801249,  0x2b2004b},
        {21077963,   46743040,  21165637,   46803159,  0x29c004b},
        {18098219,   47149850,  18188780,   47211949,  0x2b2004b},
        {18086580,   46349940,  18173419,   46410059,  0x29c004b},
        {19397758,   48093870,  20090422,   48584910,  0x001008c},
        {20090422,   48093870,  20783086,   48584910,  0x001088c},
        {20783086,   48093870,  21475750,   48584910,  0x001108c},
        {21475750,   48093870,  22168414,   48584910,  0x001188c},
        {22168414,   48093870,  22861078,   48584910,  0x001208c},
        {16800267,   47602830,  17487723,   48093870,  0x001288c},
        {17487723,   47602830,  18175179,   48093870,  0x001308c},
        {18175179,   47602830,  18862635,   48093870,  0x001388c},
        {18862635,   47602830,  19550091,   48093870,  0x001408c},
        {19550091,   47602830,  20237547,   48093870,  0x001488c},
        {20237547,   47602830,  20925003,   48093870,  0x001508c},
        {20925003,   47602830,  21612459,   48093870,  0x001588c},
        {21612459,   47602830,  22299915,   48093870,  0x001608c},
        {22299915,   47602830,  22987371,   48093870,  0x001688c},
        {16112811,   47357310,  16800267,   47848350,  0x001708c},
        {16798601,   47111790,  17480849,   47602830,  0x001788c},
        {17480849,   47111790,  18163097,   47602830,  0x001808c},
        {18163097,   47111790,  18845345,   47602830,  0x001888c},
        {18845345,   47111790,  19527593,   47602830,  0x001908c},
        {19527593,   47111790,  20209841,   47602830,  0x001988c},
        {20209841,   47111790,  20892089,   47602830,  0x001a08c},
        {20892089,   47111790,  21574337,   47602830,  0x001a88c},
        {21574337,   47111790,  22256585,   47602830,  0x001b08c},
        {16116353,   46866270,  16798601,   47357310,  0x001b88c},
        {16791778,   46620750,  17468818,   47111790,  0x001c08c},
        {17468818,   46620750,  18145858,   47111790,  0x001c88c},
        {18145858,   46620750,  18822898,   47111790,  0x001d08c},
        {18822898,   46620750,  19499938,   47111790,  0x001d88c},
        {19499938,   46620750,  20176978,   47111790,  0x001e08c},
        {20176978,   46620750,  20854018,   47111790,  0x001e88c},
        {20854018,   46620750,  21531058,   47111790,  0x001f08c},
        {21531058,   46620750,  22208098,   47111790,  0x0010088},
        {16114738,   46375230,  16791778,   46866270,  0x0010888},
        {16790216,   46129710,  17456840,   46620750,  0x0011088},
        {17456840,   46129710,  18123464,   46620750,  0x0011888},
        {18123464,   46129710,  18790088,   46620750,  0x0012088},
        {18790088,   46129710,  19456712,   46620750,  0x0012888},
        {19456712,   46129710,  20123336,   46620750,  0x0013088},
        {20117763,   46115500,  20784387,   46620750,  0x0013888},
        {20784387,   46129710,  21451011,   46620750,  0x0014088},
        {17117955,   45638670,  17784579,   46129710,  0x0014888},
        {17784579,   45638670,  18451203,   46129710,  0x0015088},
        {18451203,   45638670,  19117827,   46129710,  0x0015888},
        {19117827,   45638670,  19784451,   46129710,  0x0016088},
        {20117763,   46115500,  20784387,   46620750,  0x0b33890},
        {20784387,   46129710,  21451011,   46620750,  0x0b14090},
        {17117955,   45638670,  17784579,   46129710,  0x0b14890},
        {17784579,   45638670,  18451203,   46129710,  0x0b15090},
        {18451203,   45638670,  19117827,   46129710,  0x0b15890},
        {19117827,   45638670,  19784451,   46129710,  0x0b16090},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {16105000,   45728000,  22900000,   48585300,  0x003021c},
        {126909304,  37513000,  127017896,  37599489,  0x001000a}, // KOR
        {126592000,  37224480,  127187000,  37702000,  0x01e000c},
        {129022155,  35130890,  129171644,  35253199,  0x54f004b},
        {128598798,  35809390,  128749306,  35931699,  0x54f004b},
        {128448290,  35791043,  128598798,  35913352,  0x54f004b},
        {127327336,  36280590,  127478863,  36402899,  0x54f004b},
        {126846606,  35116300,  126951594,  35202789,  0x3c1004b},
        {126741618,  35116300,  126846606,  35202789,  0x3c1004b},
        {129274245,  35498500,  129379954,  35584989,  0x3c1004b},
        {127087185,  35797600,  127193614,  35884089,  0x3c1004b},
        {127422125,  36592800,  127529275,  36679289,  0x3c1004b},
        {128621045,  35179900,  128726754,  35266389,  0x3c1004b},
        {128517450,  35188549,  128623159,  35275038,  0x3c1004b},
        {127005504,  37690000,  127114096,  37776489,  0x3c1004b},
        {129306485,  35979000,  129412914,  36065489,  0x3c1004b},
        {128041145,  35145900,  128146854,  35232389,  0x3c1004b},
        {126459167,  33451100,  126562233,  33537589,  0x3c1004b},
        {127076964,  36770400,  127184835,  36856889,  0x3c1004b},
        {126917985,  35905400,  127024414,  35991889,  0x3c1004b},
        {128303085,  36069800,  128409514,  36156289,  0x3c1004b},
        {126346806,  34765900,  126451794,  34852389,  0x3c1004b},
        {126657185,  35942400,  126763614,  36028889,  0x3c1004b},
        {127682844,  37827700,  127792156,  37914189,  0x3c1004b},
        {128836245,  35203500,  128941954,  35289989,  0x3c1004b},
        {127891004,  37305700,  127999596,  37392189,  0x3c1004b},
        {127457506,  34921400,  127562494,  35007889,  0x3c1004b},
        {128856804,  37722800,  128965396,  37809289,  0x3c1004b},
        {127874364,  36943100,  127982235,  37029589,  0x3c1004b},
        {129158585,  35812100,  129265014,  35898589,  0x3c1004b},
        {126926620,  38133960,  127515124,  38625000,  0x001008c},
        {127515124,  38133960,  128103628,  38625000,  0x001088c},
        {128103627,  38133960,  128692131,  38625000,  0x001108c},
        {124570000,  37520160,  124866855,  38011200,  0x001188c},
        {125573061,  37348296,  126161565,  37839336,  0x001208c},
        {126161565,  37642920,  126750069,  38133960,  0x001288c},
        {126750069,  37642920,  127338573,  38133960,  0x001308c},
        {127338573,  37642920,  127927077,  38133960,  0x001388c},
        {127927077,  37642920,  128515581,  38133960,  0x001408c},
        {128515581,  37642920,  129104085,  38133960,  0x001488c},
        {125926163,  37151880,  126509459,  37642920,  0x001508c},
        {126509459,  37151880,  127092755,  37642920,  0x001588c},
        {127092755,  37151880,  127676051,  37642920,  0x001608c},
        {127676051,  37151880,  128259347,  37642920,  0x001688c},
        {128259347,  37151880,  128842643,  37642920,  0x001708c},
        {128842643,  37151880,  129425939,  37642920,  0x001788c},
        {125639723,  36660840,  126217811,  37151880,  0x001808c},
        {126217811,  36660840,  126795899,  37151880,  0x001888c},
        {126795899,  36660840,  127373987,  37151880,  0x001908c},
        {127373987,  36660840,  127952075,  37151880,  0x001988c},
        {127952075,  36660840,  128530163,  37151880,  0x001a08c},
        {128530163,  36660840,  129108251,  37151880,  0x001a88c},
        {129108251,  36660840,  129686339,  37151880,  0x001b08c},
        {125639723,  35826072,  126212603,  36317112,  0x001b88c},
        {126212603,  36169800,  126785483,  36660840,  0x001c08c},
        {126785483,  36169800,  127358363,  36660840,  0x001c88c},
        {127358363,  36169800,  127931243,  36660840,  0x001d08c},
        {127931243,  36169800,  128504123,  36660840,  0x001d88c},
        {128504123,  36169800,  129077003,  36660840,  0x001e08c},
        {129077003,  36169800,  129649883,  36660840,  0x001e88c},
        {126212603,  35678760,  126785483,  36169800,  0x001f08c},
        {126785483,  35678760,  127358363,  36169800,  0x0010088},
        {127358363,  35678760,  127931243,  36169800,  0x0010888},
        {127931243,  35678760,  128504123,  36169800,  0x0011088},
        {128504123,  35678760,  129077003,  36169800,  0x0011888},
        {129077003,  35678760,  129649883,  36169800,  0x0012088},
        {125639723,  35187720,  126212603,  35678760,  0x0012888},
        {126212603,  35187720,  126785483,  35678760,  0x0013088},
        {126785483,  35187720,  127358363,  35678760,  0x0013888},
        {127358363,  35187720,  127931243,  35678760,  0x0014088},
        {127931243,  35187720,  128504123,  35678760,  0x0014888},
        {128504123,  35187720,  129077003,  35678760,  0x0015088},
        {129077003,  35187720,  129649883,  35678760,  0x0015888},
        {125043407,  34451160,  125605871,  34942200,  0x0016088},
        {125830856,  34696680,  126398528,  35187720,  0x0016888},
        {126398528,  34696680,  126966200,  35187720,  0x0017088},
        {126966200,  34696680,  127533872,  35187720,  0x0017888},
        {127533872,  34696680,  128101544,  35187720,  0x0018088},
        {128101544,  34696680,  128669216,  35187720,  0x0018888},
        {128669216,  34696680,  129236888,  35187720,  0x0019088},
        {125036116,  33960120,  125598580,  34451160,  0x0019888},
        {125598580,  34205640,  126161044,  34696680,  0x001a088},
        {126161044,  34205640,  126723508,  34696680,  0x001a888},
        {126723508,  34205640,  127285972,  34696680,  0x001b088},
        {127285972,  34205640,  127848436,  34696680,  0x001b888},
        {127848436,  34205640,  128410900,  34696680,  0x001c088},
        {128410900,  34205640,  128973364,  34696680,  0x001c888},
        {126245413,  33714600,  126807877,  34205640,  0x001d088},
        {126807877,  33714600,  127370341,  34205640,  0x001d888},
        {126001379,  33100000,  126558635,  33591040,  0x001e088},
        {126558635,  33100000,  127115891,  33591040,  0x001e888},
        {130368752,  37256580,  130957256,  37747620,  0x001f088},
        {127370341,  33714600,  127850000,  34205640,  0x0bff090},
        {124570000,  33100000,  131000000,  38625000,  0x0010216},
        {-22037500,  64086000,  -21836500,  64166000,  0x01d000a}, // ISL
        {-22118200,  63842000,  -21214000,  64386000,  0x023000c},
        {-22751449,  63961090,  -22477952,  64083399,  0x54f004b},
        {-21195149,  63900490,  -20921652,  64022799,  0x54f004b},
        {-18209088,  65638200,  -18000312,  65724689,  0x3c1004b},
        {-20365018,  63388200,  -20174982,  63474689,  0x3c1004b},
        {-23226688,  66037100,  -23017912,  66123589,  0x3c1004b},
        {-19764388,  65696800,  -19555612,  65783289,  0x3c1004b},
        {-22546700,  63806800,  -22353300,  63893289,  0x3c1004b},
        {-17402188,  66006800,  -17193412,  66093289,  0x3c1004b},
        {-22000224,  64496800,  -21799376,  64583289,  0x3c1004b},
        {-14502346,  65216800,  -14297654,  65303289,  0x3c1004b},
        {-15308502,  64216800,  -15111498,  64303289,  0x3c1004b},
        {-18684388,  65936800,  -18475612,  66023289,  0x3c1004b},
        {-13802346,  65106800,  -13597654,  65193289,  0x3c1004b},
        {-19036550,  66116800,  -18823450,  66203289,  0x3c1004b},
        {-22840424,  65009500,  -22639576,  65095989,  0x3c1004b},
        {-23840424,  64846800,  -23639576,  64933289,  0x3c1004b},
        {-14102346,  65026800,  -13897654,  65113289,  0x3c1004b},
        {-18754388,  66026800,  -18545612,  66113289,  0x3c1004b},
        {-23376550,  66106800,  -23163450,  66193289,  0x3c1004b},
        {-20414388,  65616800,  -20205612,  65703289,  0x3c1004b},
        {-22466700,  63926800,  -22273300,  64013289,  0x3c1004b},
        {-23370424,  64876800,  -23169576,  64963289,  0x3c1004b},
        {-20326700,  63706800,  -20133300,  63793289,  0x3c1004b},
        {-14122346,  65206800,  -13917654,  65293289,  0x3c1004b},
        {-14320424,  64986800,  -14119576,  65073289,  0x3c1004b},
        {-24104388,  65536800,  -23895612,  65623289,  0x3c1004b},
        {-20496700,  63786800,  -20303300,  63873289,  0x3c1004b},
        {-14120424,  64886800,  -13919576,  64973289,  0x3c1004b},
        {-21183900,  63815700,  -20990500,  63902189,  0x3c1004b},
        {-23220000,  66231700,  -21783000,  66480000,  0x013008c},
        {-16655743,  66231680,  -15504775,  66600000,  0x001088c},
        {-15504775,  66231680,  -14353807,  66600000,  0x001108c},
        {-24356814,  65740640,  -23226678,  66231680,  0x001188c},
        {-23226678,  65740640,  -22096542,  66231680,  0x001208c},
        {-22096542,  65740640,  -20966406,  66231680,  0x001288c},
        {-20966406,  65740640,  -19836270,  66231680,  0x001308c},
        {-19836270,  65740640,  -18706134,  66231680,  0x001388c},
        {-18706134,  65740640,  -17575998,  66231680,  0x001408c},
        {-17575998,  65740640,  -16445862,  66231680,  0x001488c},
        {-16445862,  65740640,  -15315726,  66231680,  0x001508c},
        {-15315726,  65740640,  -14185590,  66231680,  0x001588c},
        {-24572425,  65249600,  -23463121,  65740640,  0x001608c},
        {-23463121,  65249600,  -22353817,  65740640,  0x001688c},
        {-22353817,  65249600,  -21244513,  65740640,  0x001708c},
        {-21244513,  65249600,  -20135209,  65740640,  0x001788c},
        {-20135209,  65249600,  -19025905,  65740640,  0x001808c},
        {-19025905,  65249600,  -17916601,  65740640,  0x001888c},
        {-17916601,  65249600,  -16807297,  65740640,  0x001908c},
        {-16807297,  65249600,  -15697993,  65740640,  0x001988c},
        {-15697993,  65249600,  -14588689,  65740640,  0x001a08c},
        {-14588689,  65249600,  -13479385,  65740640,  0x001a88c},
        {-24218124,  64660352,  -23129652,  65151392,  0x001b08c},
        {-23129652,  64758560,  -22041180,  65249600,  0x001b88c},
        {-22041180,  64758560,  -20952708,  65249600,  0x001c08c},
        {-20952708,  64758560,  -19864236,  65249600,  0x001c88c},
        {-19864236,  64758560,  -18775764,  65249600,  0x001d08c},
        {-18775764,  64758560,  -17687292,  65249600,  0x001d88c},
        {-17687292,  64758560,  -16598820,  65249600,  0x001e08c},
        {-16598820,  64758560,  -15510348,  65249600,  0x001e88c},
        {-15510348,  64758560,  -14421876,  65249600,  0x001f08c},
        {-14421876,  64758560,  -13333404,  65249600,  0x0010088},
        {-22487923,  64267520,  -21420283,  64758560,  0x0010888},
        {-21420283,  64267520,  -20352643,  64758560,  0x0011088},
        {-20352643,  64267520,  -19285003,  64758560,  0x0011888},
        {-19285003,  64267520,  -18217363,  64758560,  0x0012088},
        {-18217363,  64267520,  -17149723,  64758560,  0x0012888},
        {-17149723,  64267520,  -16082083,  64758560,  0x0013088},
        {-16082083,  64267520,  -15014443,  64758560,  0x0013888},
        {-15014443,  64267520,  -13946803,  64758560,  0x0014088},
        {-22851181,  63776480,  -21804373,  64267520,  0x0014888},
        {-21804373,  63776480,  -20757565,  64267520,  0x0015088},
        {-20757565,  63776480,  -19710757,  64267520,  0x0015888},
        {-19710757,  63776480,  -18663949,  64267520,  0x0016088},
        {-18663949,  63776480,  -17617141,  64267520,  0x0016888},
        {-17617141,  63776480,  -16570333,  64267520,  0x0017088},
        {-16570333,  63776480,  -15523525,  64267520,  0x0017888},
        {-15523525,  63776480,  -14476717,  64267520,  0x0018088},
        {-21061191,  63285440,  -20035215,  63776480,  0x0018888},
        {-20035215,  63285440,  -19009239,  63776480,  0x0019088},
        {-19009239,  63285440,  -17983263,  63776480,  0x0019888},
        {-17983263,  63285440,  -16957287,  63776480,  0x001a088},
        {-25334760,  62014358,  -12065240,  68151511,  0x0010016},
        {-90572103,  14586755,  -90483691,  14673245,  0x001000a}, // GTM
        {-90875250,  14334076,  -90396114,  14825116,  0x001000c},
        {-91570386,  14801400,  -91481014,  14887889,  0x3c1004b},
        {-90822466,  14256800,  -90733335,  14343289,  0x3c1004b},
        {-91532706,  15275900,  -91443094,  15362389,  0x3c1004b},
        {-88631806,  15666100,  -88542194,  15752589,  0x3c1004b},
        {-90429106,  15426200,  -90339494,  15512689,  0x3c1004b},
        {-91411786,  14861500,  -91322414,  14947989,  0x3c1004b},
        {-91908966,  14659000,  -91819835,  14745489,  0x3c1004b},
        {-91533666,  14476100,  -91444535,  14562589,  0x3c1004b},
        {-91712766,  14499800,  -91623635,  14586289,  0x3c1004b},
        {-91494986,  14867700,  -91405614,  14954189,  0x3c1004b},
        {-91834486,  14923500,  -91745114,  15009989,  0x3c1004b},
        {-91213086,  14714400,  -91123714,  14800889,  0x3c1004b},
        {-89601286,  14920700,  -89511914,  15007189,  0x3c1004b},
        {-89937166,  14247600,  -89848035,  14334089,  0x3c1004b},
        {-89952767,  16864400,  -89862434,  16950889,  0x3c1004b},
        {-90308666,  14360600,  -90219535,  14447089,  0x3c1004b},
        {-91456086,  15000300,  -91366714,  15086789,  0x3c1004b},
        {-91652186,  14843700,  -91562814,  14930189,  0x3c1004b},
        {-91194686,  14986800,  -91105314,  15073289,  0x3c1004b},
        {-91691286,  14767900,  -91601914,  14854389,  0x3c1004b},
        {-90912085,  14698950,  -90847916,  14761049,  0x2b2004b},
        {-91181545,  15390040,  -91119255,  15450159,  0x29c004b},
        {-89381998,  14538950,  -89318002,  14601049,  0x2b2004b},
        {-90347462,  15068840,  -90285339,  15128959,  0x29c004b},
        {-91015085,  14739950,  -90950916,  14802049,  0x2b2004b},
        {-90829895,  13916600,  -90757746,  13968000,  0x29c044b},
        {-91090812,  14068750,  -91026988,  14130849,  0x2b2004b},
        {-91043978,  14652940,  -90982022,  14713059,  0x29c004b},
        {-91482485,  14807350,  -91418316,  14869449,  0x2b2004b},
        {-91367462,  14809540,  -91305339,  14869659,  0x29c004b},
        {-91399698,  14258550,  -91335702,  14320649,  0x2b2004b},
        {-90486045,  15340140,  -90423755,  15400259,  0x29c004b},
        {-90846298,  14629350,  -90782302,  14691449,  0x2b2004b},
        {-91334278,  14156140,  -91272322,  14216259,  0x29c004b},
        {-91049298,  14308650,  -90985302,  14370749,  0x2b2004b},
        {-91141262,  14907640,  -91079139,  14967759,  0x29c004b},
        {-90022898,  14605950,  -89958902,  14668049,  0x2b2004b},
        {-89573962,  14771040,  -89511839,  14831159,  0x29c004b},
        {-91261698,  14608250,  -91197702,  14670349,  0x2b2004b},
        {-91738645,  15641740,  -91676355,  15701859,  0x29c004b},
        {-90525385,  15054750,  -90461216,  15116849,  0x2b2004b},
        {-90656662,  15081040,  -90594539,  15141159,  0x29c004b},
        {-91089552,  17439444,  -90600000,  17930484,  0x001008c},
        {-90600000,  17439444,  -90110448,  17930484,  0x001088c},
        {-90110448,  17439444,  -89620896,  17930484,  0x001108c},
        {-89620896,  17439444,  -89131344,  17930484,  0x001188c},
        {-91579104,  16948404,  -91089552,  17439444,  0x001208c},
        {-91089552,  16948404,  -90600000,  17439444,  0x001288c},
        {-90600000,  16948404,  -90110448,  17439444,  0x001308c},
        {-90110448,  16948404,  -89620896,  17439444,  0x001388c},
        {-89620896,  16948404,  -89131344,  17439444,  0x001408c},
        {-91084344,  16457364,  -90600000,  16948404,  0x001488c},
        {-90600000,  16457364,  -90115656,  16948404,  0x001508c},
        {-90115656,  16457364,  -89631312,  16948404,  0x001588c},
        {-89631312,  16457364,  -89146968,  16948404,  0x001608c},
        {-92053032,  15966324,  -91568688,  16457364,  0x001688c},
        {-91568688,  15966324,  -91084344,  16457364,  0x001708c},
        {-91084344,  15966324,  -90600000,  16457364,  0x001788c},
        {-90600000,  15966324,  -90115656,  16457364,  0x001808c},
        {-90115656,  15966324,  -89631312,  16457364,  0x001888c},
        {-89631312,  15966324,  -89146968,  16457364,  0x001908c},
        {-92101467,  15475284,  -91617123,  15966324,  0x001988c},
        {-91617123,  15475284,  -91132779,  15966324,  0x001a08c},
        {-91132779,  15475284,  -90648435,  15966324,  0x001a88c},
        {-90648435,  15475284,  -90164091,  15966324,  0x001b08c},
        {-90164091,  15475284,  -89679747,  15966324,  0x001b88c},
        {-89679747,  15475284,  -89195403,  15966324,  0x001c08c},
        {-89195403,  15475284,  -88711059,  15966324,  0x001c88c},
        {-88711059,  15475284,  -88226715,  15966324,  0x001d08c},
        {-92236000,  14984244,  -91751656,  15475284,  0x001d88c},
        {-91762426,  14984244,  -91278082,  15475284,  0x001e08c},
        {-91278082,  14984244,  -90793738,  15475284,  0x001e88c},
        {-90793738,  14984244,  -90309394,  15475284,  0x001f08c},
        {-90309394,  14984244,  -89825050,  15475284,  0x0010088},
        {-89825050,  14984244,  -89340706,  15475284,  0x0010888},
        {-89340706,  14984244,  -88856362,  15475284,  0x0011088},
        {-88856362,  14984244,  -88372018,  15475284,  0x0011888},
        {-92236000,  14493204,  -91756864,  14984244,  0x0012088},
        {-91767634,  14493204,  -91288498,  14984244,  0x0012888},
        {-91288498,  14493204,  -90809362,  14984244,  0x0013088},
        {-90809362,  14493204,  -90330226,  14984244,  0x0013888},
        {-90330226,  14493204,  -89851090,  14984244,  0x0014088},
        {-89851090,  14493204,  -89371954,  14984244,  0x0014888},
        {-89606731,  14493204,  -89127595,  14984244,  0x0015088},
        {-92179691,  14002164,  -91700555,  14493204,  0x0015888},
        {-91700555,  14002164,  -91221419,  14493204,  0x0016088},
        {-91221419,  14002164,  -90742283,  14493204,  0x0016888},
        {-90742283,  14002164,  -90263147,  14493204,  0x0017088},
        {-90263147,  14002164,  -89784011,  14493204,  0x0017888},
        {-89784011,  14002164,  -89304875,  14493204,  0x0018088},
        {-91839504,  13511124,  -91360368,  14002164,  0x0018888},
        {-91360368,  13511124,  -90881232,  14002164,  0x0019088},
        {-90881232,  13511124,  -90402096,  14002164,  0x0019888},
        {-90402096,  13511124,  -89922960,  14002164,  0x001a088},
        {-92236000,  7190000,   -77140000,  18500000,  0x3300216},
        {-92236000,  13500000,  -88213058,  17820000,  0x003021c},
        {-82436128,  23060808,  -82342911,  23147298,  0x001000a}, // CUB
        {-82528200,  23001000,  -82213374,  23181000,  0x9ee0447},
        {-75919449,  19934760,  -75694151,  20146529,  0x9310047},
        {-78027132,  21281260,  -77800069,  21493029,  0x9310047},
        {-76364144,  20775460,  -76138257,  20987229,  0x9310047},
        {-80091020,  22304060,  -79862780,  22515829,  0x9310047},
        {-75249007,  20102400,  -75156993,  20188889,  0x3c1004b},
        {-76688507,  20335000,  -76596493,  20421489,  0x3c1004b},
        {-83744508,  22372700,  -83651292,  22459189,  0x3c1004b},
        {-80495408,  22115100,  -80402192,  22201589,  0x3c1004b},
        {-81620100,  23019400,  -81486526,  23080000,  0x3c1044b},
        {-77012000,  20941000,  -76846017,  20989000,  0x3c1044b},
        {-79501288,  21894900,  -79408313,  21981389,  0x3c1004b},
        {-77165707,  20273300,  -77073693,  20359789,  0x3c1004b},
        {-76046007,  20176800,  -75953993,  20263289,  0x3c1004b},
        {-78808288,  21802200,  -78715313,  21888689,  0x3c1004b},
        {-81250037,  23003550,  -81182763,  23065649,  0x2b2004b},
        {-76614131,  21150840,  -76549670,  21210959,  0x29c004b},
        {-76280233,  20259850,  -76214167,  20321949,  0x2b2004b},
        {-75722064,  20629940,  -75657937,  20690059,  0x29c004b},
        {-80929837,  22683950,  -80862563,  22746049,  0x2b2004b},
        {-74967564,  20616640,  -74903437,  20676759,  0x29c004b},
        {-83553265,  22472050,  -83486336,  22534149,  0x2b2004b},
        {-82801065,  22792440,  -82735936,  22852559,  0x29c004b},
        {-82058837,  22812550,  -81991563,  22874649,  0x2b2004b},
        {-75862480,  20157040,  -75798520,  20217159,  0x29c004b},
        {-83072237,  22674650,  -83004963,  22736749,  0x2b2004b},
        {-74532280,  20310040,  -74468320,  20370159,  0x29c004b},
        {-82186037,  22935950,  -82118763,  22998049,  0x2b2004b},
        {-80012514,  21753140,  -79947886,  21813259,  0x29c004b},
        {-78659265,  22071050,  -78592336,  22133149,  0x2b2004b},
        {-81163598,  22489640,  -81098803,  22549759,  0x29c004b},
        {-80117837,  22775150,  -80050563,  22837249,  0x2b2004b},
        {-77299614,  21519840,  -77234986,  21579959,  0x29c004b},
        {-78257792,  21494250,  -78191208,  21556349,  0x2b2004b},
        {-81225865,  22771440,  -81160736,  22831559,  0x29c004b},
        {-80269537,  22548550,  -80202263,  22610649,  0x2b2004b},
        {-80192398,  22345940,  -80127603,  22406059,  0x29c004b},
        {-79687365,  22279050,  -79620436,  22341149,  0x2b2004b},
        {-79267098,  22312440,  -79202303,  22372559,  0x29c004b},
        {-75753120,  20928950,  -75686881,  20991049,  0x2b2004b},
        {-77382231,  21019940,  -77317770,  21080059,  0x29c004b},
        {-81581637,  22755550,  -81514363,  22817649,  0x2b2004b},
        {-80232398,  22119940,  -80167603,  22180059,  0x29c004b},
        {-76463033,  20338950,  -76396967,  20401049,  0x2b2004b},
        {-78029064,  20696640,  -77964937,  20756759,  0x29c004b},
        {-79518565,  22038650,  -79451636,  22100749,  0x2b2004b},
        {-79554198,  22469740,  -79489403,  22529859,  0x29c004b},
        {-75683033,  20138950,  -75616967,  20201049,  0x2b2004b},
        {-82601165,  22943640,  -82536036,  23003759,  0x29c004b},
        {-79769665,  22447350,  -79702736,  22509449,  0x2b2004b},
        {-80002398,  22119940,  -79937603,  22180059,  0x29c004b},
        {-82533637,  22848950,  -82466363,  22911049,  0x2b2004b},
        {-79502398,  22489940,  -79437603,  22550059,  0x29c004b},
        {-80083637,  22618950,  -80016363,  22681049,  0x2b2004b},
        {-79301814,  21742540,  -79237186,  21802659,  0x29c004b},
        {-82420037,  22942650,  -82352763,  23004749,  0x2b2004b},
        {-81946365,  22753040,  -81881236,  22813159,  0x29c004b},
        {-77744000,  19820000,  -74120000,  21970000,  0x2fa0015},
        {-84970000,  21430000,  -80500000,  23286000,  0x0700011},
        {-80500000,  20341000,  -77600000,  23230000,  0x001000d},
        {-84970000,  19820000,  -74120000,  23286000,  0x0010216},
        {23265379,   42654755,  23382621,   42741245,  0x001000a}, // BGR
        {23014000,   42529000,  23476623,   42770000,  0xc730447},
        {24610000,   41982490,  24977597,   42255909,  0xbde0447},
        {27544800,   43140000,  28049468,   43342400,  0xbde0447},
        {27395000,   42440000,  27495187,   42540300,  0x3c1044b},
        {25913018,   43805000,  26032181,   43891489,  0x3c1004b},
        {25581500,   42391400,  25720770,   42463570,  0x3c1044b},
        {24557899,   43373800,  24676101,   43460289,  0x3c1004b},
        {26263879,   42615900,  26381120,   42702389,  0x3c1004b},
        {27760018,   43532100,  27879181,   43618589,  0x3c1004b},
        {26884999,   43204300,  27003201,   43290789,  0x3c1004b},
        {25490540,   41907400,  25605859,   41993889,  0x3c1004b},
        {24266160,   42163500,  24382440,   42249989,  0x3c1004b},
        {26438160,   42458000,  26554440,   42544489,  0x3c1004b},
        {23012360,   41980900,  23128640,   42067389,  0x3c1004b},
        {25553399,   43029200,  25671601,   43115689,  0x3c1004b},
        {25259179,   42839800,  25376420,   42926289,  0x3c1004b},
        {23503299,   43176800,  23621501,   43263289,  0x3c1004b},
        {25324079,   42590500,  25441320,   42676989,  0x3c1004b},
        {22803018,   43958700,  22922181,   44045189,  0x3c1004b},
        {22649386,   42252000,  22752961,   42302000,  0x2b2044b},
        {23208818,   43387040,  23290981,   43447159,  0x29c004b},
        {25569355,   42028150,  25652844,   42090249,  0x2b2004b},
        {25339120,   41600840,  25419279,   41660959,  0x29c004b},
        {26512765,   43222250,  26597634,   43284349,  0x2b2004b},
        {24674218,   43121340,  24756381,   43181459,  0x29c004b},
        {23089055,   42235850,  23172544,   42297949,  0x2b2004b},
        {27205767,   44064340,  27289433,   44124459,  0x29c004b},
        {25664265,   43100550,  25749134,   43162649,  0x2b2004b},
        {26466018,   43511740,  26548181,   43571859,  0x29c004b},
        {24658600,   41561150,  24741399,   41623249,  0x2b2004b},
        {25316184,   43573740,  25399015,   43633859,  0x29c004b},
        {23123954,   41382000,  23254496,   41421000,  0x2b2044b},
        {23489886,   42318840,  23570713,   42378959,  0x29c004b},
        {23229900,   41516150,  23312699,   41578249,  0x2b2004b},
        {24720000,   42622000,  24829677,   42666600,  0x29c044b},
        {25962355,   42447750,  26045844,   42509849,  0x2b2004b},
        {23967586,   41999140,  24029537,   42077500,  0x29c044b},
        {25084265,   43002050,  25169134,   43064149,  0x2b2004b},
        {27215952,   42689640,  27297447,   42749759,  0x29c004b},
        {23778910,   42868750,  23863089,   42930849,  0x2b2004b},
        {25868820,   41894640,  25948979,   41954759,  0x29c004b},
        {26938610,   42620650,  27022789,   42682749,  0x2b2004b},
        {26203318,   43299040,  26285481,   43359159,  0x29c004b},
        {24266455,   42001850,  24349944,   42063949,  0x2b2004b},
        {23683920,   41543940,  23764079,   41604059,  0x29c004b},
        {24137910,   42478950,  24222089,   42541049,  0x2b2004b},
        {24067118,   43247340,  24149281,   43307459,  0x29c004b},
        {25288255,   42168950,  25371744,   42231049,  0x2b2004b},
        {26140320,   41745740,  26220479,   41805859,  0x29c004b},
        {22350000,   43724856,  22995792,   44215896,  0x001088c},
        {22995792,   43724856,  23641584,   44215896,  0x001108c},
        {23641584,   43724856,  24287376,   44215896,  0x001188c},
        {25578959,   43724856,  26224751,   44215896,  0x001208c},
        {26224751,   43724856,  26870543,   44215896,  0x001288c},
        {26870543,   43724856,  27516335,   44215896,  0x001308c},
        {27516335,   43724856,  28162127,   44215896,  0x001388c},
        {22355207,   43233816,  22995791,   43724856,  0x001408c},
        {22995791,   43233816,  23636375,   43724856,  0x001488c},
        {23636375,   43233816,  24276959,   43724856,  0x001508c},
        {24276959,   43233816,  24917543,   43763000,  0x020588c},
        {24917543,   43233816,  25558127,   43724856,  0x001608c},
        {25558127,   43233816,  26198711,   43724856,  0x001688c},
        {26198711,   43233816,  26839295,   43724856,  0x001708c},
        {26839295,   43233816,  27479879,   43724856,  0x001788c},
        {27479879,   43233816,  28120463,   43724856,  0x001808c},
        {28120463,   43332024,  28761047,   43823064,  0x001888c},
        {22355207,   42742776,  22990583,   43233816,  0x001908c},
        {22990583,   42742776,  23625959,   43233816,  0x001988c},
        {23625959,   42742776,  24261335,   43233816,  0x001a08c},
        {24261335,   42742776,  24896711,   43233816,  0x001a88c},
        {24896711,   42742776,  25532087,   43233816,  0x001b08c},
        {25532087,   42742776,  26167463,   43233816,  0x001b88c},
        {26167463,   42742776,  26802839,   43233816,  0x001c08c},
        {26802839,   42742776,  27438215,   43233816,  0x001c88c},
        {27438215,   42742776,  28073591,   43233816,  0x001d08c},
        {22360415,   42251736,  22990583,   42742776,  0x001d88c},
        {22990583,   42251736,  23620751,   42742776,  0x001e08c},
        {23620751,   42251736,  24250919,   42742776,  0x001e88c},
        {24250919,   42251736,  24881087,   42742776,  0x001f08c},
        {24881087,   42251736,  25511255,   42742776,  0x0010088},
        {25511255,   42251736,  26141423,   42742776,  0x0010888},
        {26141423,   42251736,  26771591,   42742776,  0x0011088},
        {26771591,   42251736,  27401759,   42742776,  0x0011888},
        {27401759,   42251736,  28031927,   42742776,  0x0012088},
        {22436036,   41760696,  23060996,   42251736,  0x0012888},
        {23060996,   41760696,  23685956,   42251736,  0x0013088},
        {23685956,   41760696,  24310916,   42251736,  0x0013888},
        {24310916,   41760696,  24935876,   42251736,  0x0014088},
        {24935876,   41760696,  25560836,   42251736,  0x0014888},
        {25560836,   41760696,  26185796,   42251736,  0x0015088},
        {26185796,   41760696,  26810756,   42251736,  0x0015888},
        {26810756,   41760696,  27435716,   42251736,  0x0016088},
        {27435716,   41760696,  28060676,   42251736,  0x0016888},
        {22722476,   41269656,  23342228,   41760696,  0x0017088},
        {23342228,   41269656,  23961980,   41760696,  0x0017888},
        {23961980,   41269656,  24581732,   41760696,  0x0018088},
        {24581732,   41269656,  25201484,   41760696,  0x0018888},
        {25201484,   41234000,  25770000,   41760696,  0x0219088},
        {25770000,   41294000,  26363000,   41760696,  0x0019888},
        {25201484,   41234000,  25770000,   41760696,  0x0bfa890},
        {25770000,   41294000,  26363000,   41760696,  0x0b0b090},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {22350000,   41234000,  28620000,   44260000,  0x003021c},
        {-10818550,  6265705,   -10732060,  6352195,   0x001000a}, // LBR
        {-10852000,  6139800,   -10319500,  6563120,   0x01b000c},
        {-8205296,   5995121,   -8054705,   6144880,   0x680004b},
        {-10093696,  5818720,   -9943105,   5968479,   0x680004b},
        {-8628442,   7486398,   -8477435,   7636157,   0x680004b},
        {-9551664,   6948891,   -9428336,   7071200,   0x54f004b},
        {-7791963,   4360584,   -7669315,   4482893,   0x54f004b},
        {-10864664,  6828690,   -10741336,  6950999,   0x54f004b},
        {-9075676,   4963584,   -8953028,   5085893,   0x54f004b},
        {-9046824,   7164062,   -8923496,   7286371,   0x54f004b},
        {-8281324,   4618891,   -8158676,   4741200,   0x54f004b},
        {-9821664,   8358891,   -9698336,   8481200,   0x54f004b},
        {-11386994,  6676290,   -11264006,  6798599,   0x54f004b},
        {-8930224,   6434145,   -8807236,   6556454,   0x54f004b},
        {-8774149,   7301483,   -8650821,   7423792,   0x54f004b},
        {-9624372,   5392151,   -9501384,   5514460,   0x54f004b},
        {-10584695,  8063928,   -10115975,  8554968,   0x001108c},
        {-10115976,  8063928,   -9647256,   8554968,   0x001188c},
        {-9647256,   8063928,   -9178536,   8554968,   0x001208c},
        {-11053416,  7572888,   -10584696,  8063928,   0x001288c},
        {-10584696,  7572888,   -10115976,  8063928,   0x001308c},
        {-10115976,  7572888,   -9647256,   8063928,   0x001388c},
        {-9647256,   7572888,   -9178536,   8063928,   0x001408c},
        {-11522135,  7081848,   -11053415,  7572888,   0x001508c},
        {-11053415,  7081848,   -10584695,  7572888,   0x001588c},
        {-10584695,  7081848,   -10115975,  7572888,   0x001608c},
        {-10115975,  7081848,   -9647255,   7572888,   0x001688c},
        {-9647255,   7081848,   -9178535,   7572888,   0x001708c},
        {-9178535,   7081848,   -8709815,   7572888,   0x001788c},
        {-8709815,   7081848,   -8241095,   7572888,   0x001808c},
        {-11522135,  6590808,   -11053415,  7081848,   0x001888c},
        {-11053415,  6590808,   -10584695,  7081848,   0x001908c},
        {-10584695,  6590808,   -10115975,  7081848,   0x001988c},
        {-10115975,  6590808,   -9647255,   7081848,   0x001a08c},
        {-9647255,   6590808,   -9178535,   7081848,   0x001a88c},
        {-9178535,   6590808,   -8709815,   7081848,   0x001b08c},
        {-8709815,   6590808,   -8241095,   7081848,   0x001b88c},
        {-11100287,  6099768,   -10631567,  6590808,   0x001c08c},
        {-10631567,  6099768,   -10162847,  6590808,   0x001c88c},
        {-10162847,  6099768,   -9694127,   6590808,   0x001d08c},
        {-9694127,   6099768,   -9225407,   6590808,   0x001d88c},
        {-9225407,   6099768,   -8756687,   6590808,   0x001e08c},
        {-8756687,   6099768,   -8287967,   6590808,   0x001e88c},
        {-8287967,   6099768,   -7819247,   6590808,   0x001f08c},
        {-8756688,   7219339,   -8287968,   7710379,   0x001488c},
        {-10647972,  5608728,   -10179252,  6099768,   0x0015088},
        {-10179252,  5608728,   -9710532,   6099768,   0x0015888},
        {-9710532,   5608728,   -9241812,   6099768,   0x0016088},
        {-9241812,   5608728,   -8773092,   6099768,   0x0016888},
        {-8773092,   5608728,   -8304372,   6099768,   0x0017088},
        {-8304372,   5608728,   -7835652,   6099768,   0x0017888},
        {-7835652,   5608728,   -7366932,   6099768,   0x0018888},
        {-10179251,  5117688,   -9710531,   5608728,   0x0019088},
        {-9710531,   5117688,   -9241811,   5608728,   0x0019888},
        {-9241811,   5117688,   -8773091,   5608728,   0x001a888},
        {-8773091,   5117688,   -8304371,   5608728,   0x001b088},
        {-8304371,   5117688,   -7835651,   5608728,   0x001b888},
        {-7835651,   5117688,   -7366931,   5608728,   0x001c088},
        {-9358991,   4626648,   -8890271,   5117688,   0x001c888},
        {-8890271,   4626648,   -8421551,   5117688,   0x001d088},
        {-8421551,   4626648,   -7952831,   5117688,   0x001d888},
        {-7952831,   4626648,   -7484111,   5117688,   0x001e088},
        {-8421551,   4340000,   -7952831,   4831040,   0x001e888},
        {-7952831,   4340000,   -7484111,   4831040,   0x001f088},
        {-16860000,  4340000,   4000000,    15120000,  0x2a30216},
        {-11500000,  4340000,   -7367778,   8569677,   0x003021c},
        {-87254206,  14039855,  -87165794,  14126345,  0x001000a}, // HND
        {-88217002,  15178017,  -87732658,  15669057,  0x001000c},
        {-87268953,  14021490,  -87143247,  14143799,  0x54f004b},
        {-86863600,  15733000,  -86743734,  15797789,  0x3c1044b},
        {-87213446,  13266500,  -87124555,  13352989,  0x3c1004b},
        {-87675466,  14416800,  -87586335,  14503289,  0x3c1004b},
        {-87965226,  15783200,  -87875374,  15869689,  0x3c1004b},
        {-86614246,  13999700,  -86525355,  14086189,  0x3c1004b},
        {-87888066,  14543300,  -87798935,  14629789,  0x3c1004b},
        {-86274566,  14626800,  -86185435,  14713289,  0x3c1004b},
        {-85942886,  14785800,  -85853514,  14872289,  0x3c1004b},
        {-87538000,  15747000,  -87396910,  15802000,  0x3c1044b},
        {-86054906,  15598200,  -85965294,  15684689,  0x3c1004b},
        {-88824686,  14726800,  -88735314,  14813289,  0x3c1004b},
        {-86624806,  15436800,  -86535194,  15523289,  0x3c1004b},
        {-87519246,  13397600,  -87430355,  13484089,  0x3c1004b},
        {-86604446,  13816800,  -86515555,  13903289,  0x3c1004b},
        {-87723366,  14305500,  -87634235,  14391989,  0x3c1004b},
        {-87174686,  15086800,  -87085314,  15173289,  0x3c1004b},
        {-88811286,  14987700,  -88721914,  15074189,  0x3c1004b},
        {-88299486,  14877200,  -88210114,  14963689,  0x3c1004b},
        {-87134566,  14356800,  -87045435,  14443289,  0x3c1004b},
        {-87506846,  13482200,  -87417955,  13568689,  0x3c1004b},
        {-88214566,  14276800,  -88125435,  14363289,  0x3c1004b},
        {-86902366,  14486100,  -86813235,  14572589,  0x3c1004b},
        {-87642606,  15250000,  -87552994,  15336489,  0x3c1004b},
        {-86599346,  16266500,  -86509254,  16352989,  0x3c1004b},
        {-86324806,  15576800,  -86235194,  15663289,  0x3c1004b},
        {-88008966,  14648400,  -87919835,  14734889,  0x3c1004b},
        {-88084446,  14106800,  -87995555,  14193289,  0x3c1004b},
        {-86293606,  15488100,  -86203994,  15574589,  0x3c1004b},
        {-87720706,  15261800,  -87631094,  15348289,  0x3c1004b},
        {-84171396,  17167043,  -83681844,  17658083,  0x001d888},
        {-87172848,  16039408,  -86688504,  16530448,  0x001e088},
        {-86688504,  16039408,  -86204160,  16530448,  0x001e888},
        {-86204160,  16039408,  -85719816,  16530448,  0x001f088},
        {-88429538,  15548368,  -87945194,  16039408,  0x001008c},
        {-87945194,  15548368,  -87460850,  16039408,  0x001088c},
        {-87460850,  15548368,  -86976506,  16039408,  0x001108c},
        {-86976506,  15548368,  -86492162,  16039408,  0x001188c},
        {-86492162,  15548368,  -86007818,  16039408,  0x001208c},
        {-86007818,  15548368,  -85523474,  16039408,  0x001288c},
        {-85523474,  15548368,  -85039130,  16039408,  0x001308c},
        {-85039130,  15548368,  -84554786,  16039408,  0x001388c},
        {-84554786,  15548368,  -84070442,  16039408,  0x001408c},
        {-84070442,  15548368,  -83586098,  16039408,  0x001488c},
        {-88817013,  15057328,  -88332669,  15548368,  0x001588c},
        {-89301357,  15057328,  -88817013,  15548368,  0x001508c},
        {-88332669,  15057328,  -87848325,  15548368,  0x001608c},
        {-87848325,  15057328,  -87363981,  15548368,  0x001688c},
        {-87363981,  15057328,  -86879637,  15548368,  0x001708c},
        {-86879637,  15057328,  -86395293,  15548368,  0x001788c},
        {-86395293,  15057328,  -85910949,  15548368,  0x001808c},
        {-85910949,  15057328,  -85426605,  15548368,  0x001888c},
        {-85426605,  15057328,  -84942261,  15548368,  0x001908c},
        {-84942261,  15057328,  -84457917,  15548368,  0x001988c},
        {-84457917,  15057328,  -83973573,  15548368,  0x001a08c},
        {-83973573,  15057328,  -83489229,  15548368,  0x001a88c},
        {-83489229,  14811807,  -83004885,  15302847,  0x001b08c},
        {-87790203,  14566288,  -87311067,  15057328,  0x001d08c},
        {-88269339,  14566288,  -87790203,  15057328,  0x001c88c},
        {-88748475,  14566288,  -88269339,  15057328,  0x001c08c},
        {-89227611,  14566288,  -88748475,  15057328,  0x001b88c},
        {-87311067,  14566288,  -86831931,  15057328,  0x001d88c},
        {-86831931,  14566288,  -86352795,  15057328,  0x001e08c},
        {-86352795,  14566288,  -85873659,  15057328,  0x001e88c},
        {-85873659,  14566288,  -85394523,  15057328,  0x001f08c},
        {-85394523,  14566288,  -84915387,  15057328,  0x0b10090},
        {-84915387,  14566288,  -84436251,  15057328,  0x0b10890},
        {-84436251,  14566288,  -83957115,  15057328,  0x0b11090},
        {-83957115,  14566288,  -83477979,  15057328,  0x0b11890},
        {-85519099,  14075248,  -85039963,  14566288,  0x0b16090},
        {-89352187,  14075248,  -88873051,  14566288,  0x0b12090},
        {-88873051,  14075248,  -88393915,  14566288,  0x0b12890},
        {-88393915,  14075248,  -87914779,  14566288,  0x0b13090},
        {-87914779,  14075248,  -87435643,  14566288,  0x0b13890},
        {-87435643,  14075248,  -86956507,  14566288,  0x0b14090},
        {-86956507,  14075248,  -86477371,  14566288,  0x0b14890},
        {-86477371,  14075248,  -85998235,  14566288,  0x0b15090},
        {-85998235,  14075248,  -85519099,  14566288,  0x0b15890},
        {-88777224,  13584208,  -88298088,  14075248,  0x0b16890},
        {-88298088,  13584208,  -87818952,  14075248,  0x0b17090},
        {-87818952,  13584208,  -87339816,  14075248,  0x0b17890},
        {-87339816,  13584208,  -86860680,  14075248,  0x0b18090},
        {-86860680,  13584208,  -86381544,  14075248,  0x0b18890},
        {-86381544,  13584208,  -85902408,  14075248,  0x0b19090},
        {-85902408,  13584208,  -85423272,  14075248,  0x0b19890},
        {-88058520,  13093168,  -87579384,  13584208,  0x0b0a090},
        {-87579384,  13093168,  -87100248,  13584208,  0x0b0a890},
        {-87100248,  13093168,  -86621112,  13584208,  0x0b0b090},
        {-88058520,  12602128,  -87579384,  13093168,  0x0b0b890},
        {-87579384,  12602128,  -87100248,  13093168,  0x0b0c090},
        {-87100248,  12602128,  -86621112,  13093168,  0x0b0c890},
        {-92236000,  7190000,   -77140000,  18500000,  0x3300216},
        {-89355000,  12984900,  -83000000,  17500000,  0x003021c},
        {2342000,    6346000,   2487000,    6397000,   0x012000a}, // BEN
        {2043000,    6333000,   2684400,    6680000,   0x016000c},
        {2540000,    9295000,   2606429,    9408801,   0x3c1044b},
        {2606429,    9295000,   2672858,    9408801,   0x3c1044b},
        {1629156,    9662002,   1716846,    9748491,   0x3c1004b},
        {2037096,    7136302,   2124305,    7222791,   0x3c1004b},
        {1950096,    7138302,   2037305,    7224791,   0x3c1004b},
        {1336335,    10257800,  1424265,    10344289,  0x3c1004b},
        {1654616,    6577002,   1741585,    6663491,   0x3c1004b},
        {2451096,    7993602,   2538305,    8080091,   0x3c1004b},
        {1636235,    10286700,  1724165,    10373189,  0x3c1004b},
        {2596896,    6932902,   2684105,    7019391,   0x3c1004b},
        {2889815,    11085900,  2977985,    11172389,  0x3c1004b},
        {1650276,    8950402,   1737726,    9036891,   0x3c1004b},
        {1922796,    7031602,   2010005,    7118091,   0x3c1004b},
        {2196396,    7930502,   2283605,    8016991,   0x3c1004b},
        {2368176,    8452202,   2455626,    8538691,   0x3c1004b},
        {2343635,    10313600,  2431565,    10400089,  0x3c1004b},
        {2401315,    11260800,  2489485,    11347289,  0x3c1004b},
        {1937296,    7886402,   2024505,    7972891,   0x3c1004b},
        {3159556,    9890802,   3247246,    9977291,   0x3c1004b},
        {3326315,    11798800,  3414485,    11885289,  0x3c1004b},
        {1667500,    6241100,   1832933,    6286500,   0x3c1044b},
        {2612916,    6689802,   2699885,    6776291,   0x3c1004b},
        {2148396,    7734502,   2235605,    7820991,   0x3c1004b},
        {2627135,    10184300,  2715065,    10270789,  0x3c1004b},
        {1868656,    9489802,   1956346,    9576291,   0x3c1004b},
        {1956835,    10184600,  2044765,    10271089,  0x3c1004b},
        {3130615,    12038400,  3218785,    12124889,  0x3c1004b},
        {1747679,    6772752,   1810123,    6834851,   0x2b2004b},
        {1859574,    6357242,   1920027,    6417361,   0x29c004b},
        {1658193,    6915352,   1720809,    6977451,   0x2b2004b},
        {2563507,    8861242,   2624294,    8921361,   0x29c004b},
        {1231033,    10594750,  1294167,    10656849,  0x2b2004b},
        {2093239,    10784940,  2154360,    10845059,  0x29c004b},
        {2578693,    7328952,   2641309,    7391051,   0x2b2004b},
        {2308405,    7185801,   2369025,    7245920,   0x29c004b},
        {1498640,    6116481,   1967360,    6607521,   0x001008c},
        {1967360,    6116481,   2436080,    6607521,   0x001088c},
        {2436080,    6116481,   2904800,    6607521,   0x001108c},
        {1498640,    6607521,   1967360,    7098561,   0x001188c},
        {1967360,    6607521,   2436080,    7098561,   0x001208c},
        {2436080,    6607521,   2904800,    7098561,   0x001288c},
        {1498640,    7098561,   1967360,    7589601,   0x001308c},
        {1967360,    7098561,   2436080,    7589601,   0x001388c},
        {2436080,    7098561,   2904800,    7589601,   0x001408c},
        {1498640,    7589601,   1967360,    8080641,   0x001488c},
        {1967360,    7589601,   2436080,    8080641,   0x001508c},
        {2436080,    7589601,   2904800,    8080641,   0x001588c},
        {1498640,    8080640,   1967360,    8571680,   0x001608c},
        {1967360,    8080640,   2436080,    8571680,   0x001688c},
        {2436080,    8080640,   2904800,    8571680,   0x001708c},
        {1498640,    8571680,   1972568,    9062720,   0x001788c},
        {1972568,    8571680,   2446496,    9062720,   0x001808c},
        {2446496,    8571680,   2920424,    9062720,   0x001888c},
        {1332765,    9062720,   1806693,    9553760,   0x001908c},
        {1806693,    9062720,   2280621,    9553760,   0x001988c},
        {2280621,    9062720,   2754549,    9553760,   0x001a08c},
        {2754549,    9062720,   3228477,    9553760,   0x001a88c},
        {1261676,    9553760,   1735604,    10044800,  0x001b08c},
        {1735604,    9553760,   2209532,    10044800,  0x001b88c},
        {2209532,    9553760,   2683460,    10044800,  0x001c08c},
        {2683460,    9553760,   3157388,    10044800,  0x001c88c},
        {3157388,    9553760,   3631316,    10044800,  0x001d08c},
        {764051,     10044800,  1237979,    10535840,  0x001d88c},
        {1237979,    10044800,  1711907,    10535840,  0x001e08c},
        {1711907,    10044800,  2185835,    10535840,  0x001e88c},
        {2185835,    10044800,  2659763,    10535840,  0x001f08c},
        {2659763,    10044800,  3133691,    10535840,  0x0010088},
        {3133691,    10044800,  3607619,    10535840,  0x0010888},
        {3526072,    10044800,  4000000,    10535840,  0x0011088},
        {764051,     10535840,  1237979,    11026880,  0x0011888},
        {1237979,    10535840,  1711907,    11026880,  0x0012088},
        {1711907,    10535840,  2185835,    11026880,  0x0012888},
        {2185835,    10535840,  2659763,    11026880,  0x0013088},
        {2659763,    10535840,  3133691,    11026880,  0x0013888},
        {3133691,    10535840,  3607619,    11026880,  0x0014088},
        {3526072,    10535840,  4000000,    11026880,  0x0014888},
        {929926,     11026880,  1403854,    11517920,  0x0015088},
        {1403854,    11026880,  1877782,    11517920,  0x0015888},
        {1877782,    11026880,  2351710,    11517920,  0x0016088},
        {2351710,    11026880,  2825638,    11517920,  0x0016888},
        {2825638,    11026880,  3299566,    11517920,  0x0017088},
        {3299566,    11026880,  3773494,    11517920,  0x0017888},
        {2110000,    11517920,  2588674,    11920600,  0x01cd088},
        {2588674,    11517920,  3062602,    11920600,  0x001d888},
        {3062602,    11517920,  3617000,    11920600,  0x01ae088},
        {2369604,    11920600,  2843532,    12411641,  0x001e888},
        {2843532,    11920600,  3317460,    12411641,  0x001f088},
        {2114746,    11517920,  2588674,    11920600,  0x0a0d090},
        {2588674,    11517920,  3062602,    11920600,  0x0a0d890},
        {3062602,    11517920,  3617000,    11920600,  0x094e090},
        {2369604,    11920601,  2843532,    12411641,  0x0b1e890},
        {2843532,    11920601,  3317460,    12411641,  0x0b1f090},
        {-16860000,  4340000,   4000000,    15120000,  0x2a30216},
        {770000,     6100000,   3860000,    12410000,  0x003021c},
        {38870225,   15293955,  38959598,   15380445,  0x001000a}, // ERI
        {38687336,   15113011,  39171680,   15604051,  0x001000c},
        {38394637,   15716890,  38521362,   15839199,  0x54f004b},
        {42632517,   12945190,  42757883,   13067499,  0x54f004b},
        {39366537,   15555390,  39493262,   15677699,  0x54f004b},
        {41627147,   13868890,  41752853,   13991199,  0x54f004b},
        {38751807,   14825890,  38878193,   14948199,  0x54f004b},
        {37526807,   15058890,  37653193,   15181199,  0x54f004b},
        {39306007,   14782990,  39432393,   14905299,  0x54f004b},
        {42266547,   13206090,  42392253,   13328399,  0x54f004b},
        {38984907,   15000290,  39111293,   15122599,  0x54f004b},
        {38768577,   14573490,  38894623,   14695799,  0x54f004b},
        {39356977,   14628890,  39483023,   14751199,  0x54f004b},
        {36613114,   15060300,  36702486,   15146789,  0x3c1004b},
        {40265414,   14855900,  40354786,   14942389,  0x3c1004b},
        {38431354,   16621900,  38521446,   16708389,  0x3c1004b},
        {38640374,   16144700,  38730226,   16231189,  0x3c1004b},
        {38402074,   15841000,  38491926,   15927489,  0x3c1004b},
        {38004174,   16207600,  38094026,   16294089,  0x3c1004b},
        {37982694,   15498500,  38072306,   15584989,  0x3c1004b},
        {37522114,   14988400,  37611486,   15074889,  0x3c1004b},
        {37609114,   14974800,  37698486,   15061289,  0x3c1004b},
        {38328075,   17531160,  38817627,   18022200,  0x001008c},
        {37334264,   17174080,  37823816,   17665120,  0x001088c},
        {37823816,   17174080,  38313368,   17665120,  0x001108c},
        {38313368,   17174080,  38802920,   17665120,  0x001188c},
        {38802920,   17174080,  39292472,   17665120,  0x001208c},
        {36849920,   16683039,  37334264,   17174079,  0x001288c},
        {37334264,   16683039,  37818608,   17174079,  0x001308c},
        {37818608,   16683039,  38302952,   17174079,  0x001388c},
        {38302952,   16683039,  38787296,   17174079,  0x001408c},
        {38787296,   16683039,  39271640,   17174079,  0x001488c},
        {36849920,   16192000,  37334264,   16683040,  0x001508c},
        {37334264,   16192000,  37818608,   16683040,  0x001588c},
        {37818608,   16192000,  38302952,   16683040,  0x001608c},
        {38302952,   16192000,  38787296,   16683040,  0x001688c},
        {38787296,   16192000,  39271640,   16683040,  0x001708c},
        {36607748,   15700960,  37092092,   16192000,  0x001788c},
        {37092092,   15700960,  37576436,   16192000,  0x001808c},
        {37576436,   15700960,  38060780,   16192000,  0x001888c},
        {38060780,   15700960,  38545124,   16192000,  0x001908c},
        {38545124,   15700960,  39029468,   16192000,  0x001988c},
        {39029468,   15700960,  39513812,   16192000,  0x001a08c},
        {36438228,   15209920,  36922572,   15700960,  0x001a88c},
        {36922572,   15209920,  37406916,   15700960,  0x001b08c},
        {37406916,   15209920,  37891260,   15700960,  0x001b88c},
        {37891260,   15209920,  38375604,   15700960,  0x001c08c},
        {38375604,   15209920,  38859948,   15700960,  0x001c88c},
        {38859948,   15209920,  39344292,   15700960,  0x001d08c},
        {39344292,   15209920,  39828636,   15700960,  0x001d88c},
        {39828636,   15209920,  40312980,   15700960,  0x001e08c},
        {39889000,   15701012,  40260000,   16289000,  0x026e88c},
        {40313000,   15466000,  40842000,   15907000,  0x01cf08c},
        {36438248,   14718932,  36922592,   15209972,  0x0010088},
        {36922592,   14718932,  37406936,   15209972,  0x0010888},
        {37406936,   14718932,  37891280,   15209972,  0x0011088},
        {37891280,   14718932,  38375624,   15209972,  0x0011888},
        {38375624,   14718932,  38859968,   15209972,  0x0012088},
        {38859968,   14718932,  39344312,   15209972,  0x0015088},
        {39344312,   14718932,  39828656,   15209972,  0x0015888},
        {39828656,   14718932,  40313000,   15209972,  0x0016088},
        {40313000,   14718932,  40797344,   15209972,  0x0016888},
        {36438248,   14227892,  36917384,   14718932,  0x0012888},
        {36917384,   14227892,  37396520,   14718932,  0x0013088},
        {37396520,   14179000,  37830000,   14718914,  0x0223888},
        {37875656,   14227892,  38354792,   14718932,  0x0014088},
        {38354792,   14227892,  38833928,   14718932,  0x0014888},
        {38833928,   14227892,  39313064,   14718932,  0x0017088},
        {39313063,   14227892,  39792199,   14718932,  0x0017888},
        {39792199,   14227892,  40271335,   14718932,  0x0018088},
        {40271336,   14227892,  40750472,   14718932,  0x0018888},
        {40750472,   14227892,  41229608,   14718932,  0x0019088},
        {41229608,   14227892,  41708744,   14718932,  0x0019888},
        {40654644,   13736852,  41133780,   14227892,  0x001a088},
        {41133780,   13736852,  41612916,   14227892,  0x001a888},
        {41612916,   13736852,  42092052,   14227892,  0x001b088},
        {41133780,   13245812,  41612916,   13736852,  0x001b888},
        {41612916,   13245812,  42092052,   13736852,  0x001c088},
        {42092052,   13245812,  42571188,   13736852,  0x001c888},
        {41708743,   12754772,  42187879,   13245812,  0x001d088},
        {42187880,   12754772,  42667016,   13245812,  0x001d888},
        {42667015,   12754772,  43146151,   13245812,  0x001e088},
        {42211836,   12350000,  42690972,   12841040,  0x001e888},
        {42681864,   12350000,  43161000,   12841040,  0x001f088},
        {39266000,   14718932,  41473500,   16773000,  0x0010015},
        {36433480,   12350000,  43161000,   18022200,  0x0010216},
        {34969050,   -15836490, 35058423,   -15750000, 0x001000a}, // MWI
        {34843074,   -15971880, 35201526,   -15625921, 0xf040047},
        {33627904,   -14137400, 33972095,   -13802511, 0xe890047},
        {33967315,   -11495400, 34055485,   -11408911, 0x3c1004b},
        {35283694,   -15434300, 35373306,   -15347811, 0x3c1004b},
        {33867855,   -9979500,  33955545,   -9893011,  0x3c1004b},
        {35216034,   -14500900, 35305165,   -14414411, 0x3c1004b},
        {33445374,   -13081300, 33534025,   -12994811, 0x3c1004b},
        {34413854,   -13838700, 34502745,   -13752211, 0x3c1004b},
        {34223874,   -12956400, 34312525,   -12869911, 0x3c1004b},
        {35209333,   -16973400, 35299666,   -16886911, 0x3c1004b},
        {35182814,   -15112300, 35272186,   -15025811, 0x3c1004b},
        {34278134,   -14414700, 34367265,   -14328211, 0x3c1004b},
        {34913814,   -15033800, 35003186,   -14947311, 0x3c1004b},
        {33817335,   -11058500, 33905265,   -10972011, 0x3c1004b},
        {33553215,   -11946000, 33641385,   -11859511, 0x3c1004b},
        {35457574,   -16066900, 35547426,   -15980411, 0x3c1004b},
        {32835554,   -13843200, 32924445,   -13756711, 0x3c1004b},
        {33695554,   -13574500, 33784445,   -13488011, 0x3c1004b},
        {33631915,   -11167900, 33720085,   -11081411, 0x3c1004b},
        {34227815,   -11650500, 34315985,   -11564011, 0x3c1004b},
        {35255074,   -16053200, 35344926,   -15966711, 0x3c1004b},
        {34844354,   -14128700, 34933245,   -14042211, 0x3c1004b},
        {34499794,   -15639300, 34589406,   -15552811, 0x3c1004b},
        {34602714,   -14867500, 34692086,   -14781011, 0x3c1004b},
        {33229355,   -9742500,  33317045,   -9656011,  0x3c1004b},
        {34781474,   -16064100, 34871326,   -15977611, 0x3c1004b},
        {34046054,   -13374000, 34134945,   -13287511, 0x3c1004b},
        {35076574,   -16107500, 35166426,   -16021011, 0x3c1004b},
        {34096535,   -10667200, 34184465,   -10580711, 0x3c1004b},
        {33874854,   -13682200, 33963745,   -13595711, 0x3c1004b},
        {35595774,   -15831400, 35685626,   -15744911, 0x3c1004b},
        {34447154,   -14033000, 34536045,   -13946511, 0x3c1004b},
        {35480614,   -14925300, 35569986,   -14838811, 0x3c1004b},
        {32911567,   -9856040,  33385495,   -9365000,  0x001008c},
        {33385495,   -9856040,  33859423,   -9365000,  0x001088c},
        {33859423,   -9856040,  34333351,   -9365000,  0x001108c},
        {33314406,   -10347080, 33788334,   -9856040,  0x001188c},
        {33788334,   -10347080, 34262262,   -9856040,  0x001208c},
        {33314406,   -10838120, 33788334,   -10347080, 0x001288c},
        {33788334,   -10838120, 34262262,   -10347080, 0x001308c},
        {33077442,   -11329160, 33551370,   -10838120, 0x001388c},
        {33551370,   -11329160, 34025298,   -10838120, 0x001408c},
        {34025298,   -11329160, 34499226,   -10838120, 0x001488c},
        {33077442,   -11820200, 33551370,   -11329160, 0x001508c},
        {33551370,   -11820200, 34025298,   -11329160, 0x001588c},
        {34025298,   -11820200, 34499226,   -11329160, 0x001608c},
        {33243317,   -12311240, 33717245,   -11820200, 0x001688c},
        {33717245,   -12311240, 34191173,   -11820200, 0x001708c},
        {32930056,   -12802280, 33409192,   -12311240, 0x001788c},
        {33409192,   -12802280, 33888328,   -12311240, 0x001808c},
        {33888328,   -12802280, 34367464,   -12311240, 0x001888c},
        {32930056,   -13293320, 33409192,   -12802280, 0x001908c},
        {33409192,   -13293320, 33888328,   -12802280, 0x001988c},
        {33888328,   -13293320, 34367464,   -12802280, 0x001a08c},
        {32671892,   -13784360, 33151028,   -13293320, 0x001a88c},
        {33145667,   -13784360, 33624803,   -13293320, 0x001b08c},
        {33624803,   -13784360, 34103939,   -13293320, 0x001b88c},
        {34103939,   -13784360, 34583075,   -13293320, 0x001c08c},
        {34583075,   -13784360, 35062211,   -13293320, 0x001c88c},
        {35062211,   -13784360, 35541347,   -13293320, 0x001d08c},
        {32671892,   -14275400, 33151028,   -13784360, 0x001d88c},
        {33145667,   -14275400, 33624803,   -13784360, 0x001e08c},
        {33624803,   -14275400, 34103939,   -13784360, 0x001e88c},
        {34103939,   -14275400, 34583075,   -13784360, 0x001f08c},
        {34583075,   -14275400, 35062211,   -13784360, 0x0010088},
        {35062211,   -14275400, 35541347,   -13784360, 0x0010888},
        {33385235,   -14766440, 33864371,   -14275400, 0x0011088},
        {33864371,   -14766440, 34343507,   -14275400, 0x0011888},
        {34343507,   -14766440, 34822643,   -14275400, 0x0012088},
        {34822643,   -14766440, 35301779,   -14275400, 0x0012888},
        {35301779,   -14766440, 35780915,   -14275400, 0x0013088},
        {35470864,   -14766440, 35950000,   -14275400, 0x0013888},
        {34535161,   -15257480, 35019505,   -14766440, 0x0014088},
        {35019505,   -15257480, 35503849,   -14766440, 0x0014888},
        {35465656,   -15257480, 35950000,   -14766440, 0x0015088},
        {34196121,   -15748520, 34680465,   -15257480, 0x0015888},
        {34680465,   -15748520, 35164809,   -15257480, 0x0016088},
        {35164809,   -15748520, 35649153,   -15257480, 0x0016888},
        {35465656,   -15748520, 35950000,   -15257480, 0x0017088},
        {34196121,   -16239560, 34680465,   -15748520, 0x0017888},
        {34680465,   -16239560, 35164809,   -15748520, 0x0018088},
        {35164809,   -16239560, 35649153,   -15748520, 0x0018888},
        {35465656,   -16239560, 35950000,   -15748520, 0x0019088},
        {34389858,   -16730600, 34874202,   -16239560, 0x0019888},
        {34874202,   -16730600, 35358546,   -16239560, 0x001a088},
        {34874202,   -17140000, 35358546,   -16648960, 0x001a888},
        {32671892,   -17140000, 35950000,   -9365000,  0x0010216},
        {125699223,  38990755,  125809738,  39077245,  0x001000a}, // PRK
        {125578636,  38903990,  125892564,  39148609,  0xa9e0047},
        {127384917,  39790890,  127700883,  40035509,  0xa9e0047},
        {129585620,  41656490,  129911779,  41901109,  0xa9e0047},
        {124343076,  40000810,  124641124,  40229589,  0x9ee0047},
        {125572309,  39574590,  125730291,  39696899,  0x54f004b},
        {125316028,  38710890,  125471972,  38833199,  0x54f004b},
        {127343818,  39126490,  127500781,  39248799,  0x54f004b},
        {125660807,  37991590,  125815392,  38113899,  0x54f004b},
        {126502207,  37904490,  126656792,  38026799,  0x54f004b},
        {125781018,  39182190,  125937981,  39304499,  0x54f004b},
        {125720428,  38437190,  125876372,  38559499,  0x54f004b},
        {126535840,  40909390,  126697560,  41031699,  0x54f004b},
        {129124350,  40645890,  129285050,  40768199,  0x54f004b},
        {128147621,  41352200,  128261979,  41438689,  0x3c1004b},
        {125587963,  38702100,  125698236,  38788589,  0x3c1004b},
        {130270760,  42194800,  130387040,  42281289,  0x3c1004b},
        {130289379,  42481500,  130406620,  42567989,  0x3c1004b},
        {129190460,  42176000,  129329851,  42248000,  0x3c1044b},
        {128843281,  40389700,  128956918,  40476189,  0x3c1004b},
        {128374462,  40097700,  128487138,  40184189,  0x3c1004b},
        {127914262,  40001700,  128026938,  40088189,  0x3c1004b},
        {128125662,  40007800,  128238338,  40094289,  0x3c1004b},
        {125193262,  39935800,  125305938,  40022289,  0x3c1004b},
        {125317044,  37884100,  125426356,  37970589,  0x3c1004b},
        {129693160,  42394800,  129809440,  42481289,  0x3c1004b},
        {128592862,  40286500,  128705538,  40372989,  0x3c1004b},
        {129423620,  42530960,  130058996,  43022000,  0x001008c},
        {130058996,  42530960,  130694372,  43022000,  0x001088c},
        {128856990,  42051213,  129487158,  42542253,  0x001108c},
        {129487158,  42051213,  130117326,  42542253,  0x001188c},
        {130079832,  42051213,  130710000,  42542253,  0x001208c},
        {126556877,  41560173,  127181837,  42051213,  0x001288c},
        {127963037,  41560173,  128587997,  42051213,  0x001308c},
        {128587997,  41560173,  129212957,  42051213,  0x001388c},
        {129212957,  41560173,  129837917,  42051213,  0x001408c},
        {129837917,  41560173,  130462877,  42051213,  0x001488c},
        {126105864,  41069133,  126725616,  41560173,  0x001508c},
        {126725616,  41069133,  127345368,  41560173,  0x001588c},
        {127345368,  41069133,  127965120,  41560173,  0x001608c},
        {127965120,  41069133,  128584872,  41560173,  0x001688c},
        {128584872,  41069133,  129204624,  41560173,  0x001708c},
        {129204624,  41069133,  129824376,  41560173,  0x001788c},
        {125114261,  40578093,  125728805,  41069133,  0x001808c},
        {125728805,  40578093,  126343349,  41069133,  0x001888c},
        {126343349,  40578093,  126957893,  41069133,  0x001908c},
        {126957893,  40578093,  127572437,  41069133,  0x001988c},
        {127572437,  40578093,  128186981,  41069133,  0x001a08c},
        {128186981,  40578093,  128801525,  41069133,  0x001a88c},
        {128801525,  40578093,  129416069,  41069133,  0x001b08c},
        {129416069,  40578093,  130030613,  41069133,  0x001b88c},
        {124351289,  40087053,  124960625,  40578093,  0x001c08c},
        {124960625,  40087053,  125569961,  40578093,  0x001c88c},
        {125569961,  40087053,  126179297,  40578093,  0x001d08c},
        {126179297,  40087053,  126788633,  40578093,  0x001d88c},
        {126788633,  40087053,  127397969,  40578093,  0x001e08c},
        {127397969,  40087053,  128007305,  40578093,  0x001e88c},
        {128007305,  40087053,  128616641,  40578093,  0x001f08c},
        {128616641,  40087053,  129225977,  40578093,  0x0010088},
        {124168488,  39596013,  124772616,  40087053,  0x0010888},
        {124772616,  39596013,  125376744,  40087053,  0x0011088},
        {125376744,  39596013,  125980872,  40087053,  0x0011888},
        {125980872,  39596013,  126585000,  40087053,  0x0012088},
        {126585000,  39596013,  127189128,  40087053,  0x0012888},
        {127189128,  39596013,  127793256,  40087053,  0x0013088},
        {127793256,  39596013,  128397384,  40087053,  0x0013888},
        {124475760,  39104973,  125074680,  39596013,  0x0014088},
        {125074680,  39104973,  125673600,  39596013,  0x0014888},
        {125673600,  39104973,  126272520,  39596013,  0x0015088},
        {126272520,  39104973,  126871440,  39596013,  0x0015888},
        {126871440,  39104973,  127470360,  39596013,  0x0016088},
        {127470360,  39104973,  128069280,  39596013,  0x0016888},
        {124895004,  38613933,  125488716,  39104973,  0x0017088},
        {125488716,  38613933,  126082428,  39104973,  0x0017888},
        {126082428,  38613933,  126676140,  39104973,  0x0018088},
        {126676140,  38613933,  127269852,  39104973,  0x0018888},
        {127269852,  38613933,  127863564,  39104973,  0x0019088},
        {127863564,  38613933,  128457276,  39104973,  0x0019888},
        {124306500,  38122893,  124895004,  38613933,  0x001a088},
        {124895004,  38122893,  125483508,  38613933,  0x001a888},
        {125483508,  38122893,  126072012,  38613933,  0x001b088},
        {126072012,  38122893,  126660516,  38613933,  0x001b888},
        {126660516,  38122893,  127249020,  38613933,  0x001c088},
        {127249020,  38122893,  127837524,  38613933,  0x001c888},
        {127837524,  38122893,  128426028,  38613933,  0x001d088},
        {124600752,  37631853,  125189256,  38122893,  0x001d888},
        {125189256,  37631853,  125777760,  38122893,  0x001e088},
        {125777760,  37631853,  126366264,  38122893,  0x001e888},
        {126366264,  37631853,  126954768,  38122893,  0x001f088},
        {124150000,  37566000,  130710000,  43022000,  0x0010216},
        {-86317000,  12100000,  -86206600,  12164000,  0x017000a}, // NIC
        {-86394960,  11738580,  -85921032,  12229620,  0x001000c},
        {-86922206,  12394800,  -86833795,  12481289,  0x3c1004b},
        {-87182026,  12596700,  -87093375,  12683189,  0x3c1004b},
        {-85981026,  12892100,  -85892375,  12978589,  0x3c1004b},
        {-86398326,  13048800,  -86309675,  13135289,  0x3c1004b},
        {-83843185,  11968000,  -83755015,  12054489,  0x3c1004b},
        {-86498946,  13599900,  -86410055,  13686389,  0x3c1004b},
        {-87058806,  12513800,  -86970395,  12600289,  0x3c1004b},
        {-86052226,  13051900,  -85963575,  13138389,  0x3c1004b},
        {-85413506,  12059500,  -85325095,  12145989,  0x3c1004b},
        {-84504085,  11646800,  -84415915,  11733289,  0x3c1004b},
        {-86610706,  12220900,  -86522295,  12307389,  0x3c1004b},
        {-86164046,  13887200,  -86075155,  13973689,  0x3c1004b},
        {-83445446,  13991200,  -83356555,  14077689,  0x3c1004b},
        {-85870685,  11399300,  -85782515,  11485789,  0x3c1004b},
        {-84264206,  12106800,  -84175795,  12193289,  0x3c1004b},
        {-86481385,  11801200,  -86393215,  11887689,  0x3c1004b},
        {-85704206,  12426800,  -85615795,  12513289,  0x3c1004b},
        {-87214906,  12470000,  -87126495,  12556489,  0x3c1004b},
        {-86140726,  12810900,  -86052075,  12897389,  0x3c1004b},
        {-86708906,  12282400,  -86620495,  12368889,  0x3c1004b},
        {-86634446,  13436800,  -86545555,  13523289,  0x3c1004b},
        {-86478406,  12184000,  -86389995,  12270489,  0x3c1004b},
        {-85541740,  12348950,  -85478261,  12411049,  0x2b2004b},
        {-85121944,  12034340,  -85060656,  12094459,  0x29c004b},
        {-86149026,  12691150,  -86085375,  12753249,  0x2b2004b},
        {-86955311,  13015640,  -86893689,  13075759,  0x29c004b},
        {-84790653,  11107150,  -84727347,  11169249,  0x2b2004b},
        {-85247311,  12893540,  -85185689,  12953659,  0x29c004b},
        {-86055112,  13536550,  -85991288,  13598649,  0x2b2004b},
        {-84814195,  13692540,  -84752406,  13752659,  0x29c004b},
        {-85199453,  11951750,  -85136147,  12013849,  0x2b2004b},
        {-86432795,  13333840,  -86371006,  13393959,  0x29c004b},
        {-85491826,  12798950,  -85428175,  12861049,  0x2b2004b},
        {-86166495,  13691840,  -86104706,  13751959,  0x29c004b},
        {-86571826,  12848950,  -86508175,  12911049,  0x2b2004b},
        {-85020644,  12019940,  -84959356,  12080059,  0x29c004b},
        {-84420912,  13884550,  -84357088,  13946649,  0x2b2004b},
        {-83080628,  12141640,  -83019173,  12201759,  0x29c004b},
        {-86909440,  12480550,  -86845961,  12542649,  0x2b2004b},
        {-85890644,  11219940,  -85829356,  11280059,  0x29c004b},
        {-85509931,  14593064,  -85030795,  15084104,  0x001008c},
        {-85030795,  14593064,  -84551659,  15084104,  0x001088c},
        {-84551659,  14593064,  -84072523,  15084104,  0x001108c},
        {-84072523,  14593064,  -83593387,  15084104,  0x001188c},
        {-83593387,  14593064,  -83114251,  15084104,  0x001208c},
        {-85509931,  14102024,  -85030795,  14593064,  0x001288c},
        {-85030795,  14102024,  -84551659,  14593064,  0x001308c},
        {-84551659,  14102024,  -84072523,  14593064,  0x001388c},
        {-84072523,  14102024,  -83593387,  14593064,  0x001408c},
        {-83593387,  14102024,  -83114251,  14593064,  0x001488c},
        {-86947339,  13610984,  -86468203,  14102024,  0x001508c},
        {-86468203,  13610984,  -85989067,  14102024,  0x001588c},
        {-85989067,  13610984,  -85509931,  14102024,  0x001608c},
        {-85509931,  13610984,  -85030795,  14102024,  0x001688c},
        {-85030795,  13610984,  -84551659,  14102024,  0x001708c},
        {-84551659,  13610984,  -84072523,  14102024,  0x001788c},
        {-84072523,  13610984,  -83593387,  14102024,  0x001808c},
        {-83593387,  13610984,  -83114251,  14102024,  0x001888c},
        {-86947339,  13119944,  -86468203,  13610984,  0x001908c},
        {-86468203,  13119944,  -85989067,  13610984,  0x001988c},
        {-85989067,  13119944,  -85509931,  13610984,  0x001a08c},
        {-85509931,  13119944,  -85030795,  13610984,  0x001a88c},
        {-85030795,  13119944,  -84551659,  13610984,  0x001b08c},
        {-84551659,  13119944,  -84072523,  13610984,  0x001b88c},
        {-84072523,  13119944,  -83593387,  13610984,  0x001c08c},
        {-83593387,  13119944,  -83114251,  13610984,  0x001c88c},
        {-87694791,  12628904,  -87215655,  13119944,  0x001d08c},
        {-87215655,  12628904,  -86736519,  13119944,  0x001d88c},
        {-86736519,  12628904,  -86257383,  13119944,  0x001e08c},
        {-86257383,  12628904,  -85778247,  13119944,  0x001e88c},
        {-85778247,  12628904,  -85299111,  13119944,  0x001f08c},
        {-85299111,  12628904,  -84819975,  13119944,  0x0010088},
        {-84819975,  12628904,  -84340839,  13119944,  0x0010888},
        {-84340839,  12628904,  -83861703,  13119944,  0x0011088},
        {-83861703,  12628904,  -83382567,  13119944,  0x0011888},
        {-87694791,  12137864,  -87215655,  12628904,  0x0012088},
        {-87215655,  12137864,  -86736519,  12628904,  0x0012888},
        {-86736519,  12137864,  -86257383,  12628904,  0x0013088},
        {-86257383,  12137864,  -85778247,  12628904,  0x0013888},
        {-85778247,  12137864,  -85299111,  12628904,  0x0014088},
        {-85299111,  12137864,  -84819975,  12628904,  0x0014888},
        {-84819975,  12137864,  -84340839,  12628904,  0x0015088},
        {-84340839,  12137864,  -83861703,  12628904,  0x0015888},
        {-83861703,  12137864,  -83382567,  12628904,  0x0016088},
        {-86922965,  11646824,  -86449037,  12137864,  0x0016888},
        {-86449037,  11646824,  -85975109,  12137864,  0x0017088},
        {-85975109,  11646824,  -85501181,  12137864,  0x0017888},
        {-85501181,  11646824,  -85027253,  12137864,  0x0018088},
        {-85027253,  11646824,  -84553325,  12137864,  0x0018888},
        {-84553325,  11646824,  -84079397,  12137864,  0x0019088},
        {-84079397,  11646824,  -83605469,  12137864,  0x0019888},
        {-86449037,  11155784,  -85975109,  11646824,  0x001a088},
        {-85975109,  11155784,  -85501181,  11646824,  0x001a888},
        {-85501181,  11155784,  -85027253,  11646824,  0x001b088},
        {-85027253,  11155784,  -84553325,  11646824,  0x001b888},
        {-84553325,  11155784,  -84079397,  11646824,  0x001c088},
        {-84079397,  11155784,  -83605469,  11646824,  0x001c888},
        {-85975109,  11008472,  -85501181,  11499512,  0x001d088},
        {-85501181,  10959368,  -85027253,  11450408,  0x001d888},
        {-85027253,  10910264,  -84553325,  11401304,  0x001e088},
        {-84553325,  10758041,  -84079397,  11249081,  0x001e888},
        {-84079397,  10704027,  -83605469,  11195067,  0x001f088},
        {-83600000,  11100000,  -82300000,  15035000,  0x6980015},
        {-92236000,  7190000,   -77140000,  18500000,  0x3300216},
        {-87700000,  10700000,  -82300000,  15035000,  0x003021c},
        {23671160,   37930187,  23779753,   38016677,  0x001000a}, // GRC
        {23303857,   37773000,  24032100,   38169000,  0x019000c},
        {21705344,   38196800,  21814656,   38283289,  0x3c1004b},
        {25077145,   35261800,  25182854,   35348289,  0x3c1004b},
        {22364142,   39596800,  22475857,   39683289,  0x3c1004b},
        {22933181,   40536800,  23046818,   40623289,  0x3c1004b},
        {22884142,   39326800,  22995857,   39413289,  0x3c1004b},
        {20794142,   39616800,  20905857,   39703289,  0x3c1004b},
        {24337421,   40896800,  24451779,   40983289,  0x3c1004b},
        {23492921,   41043200,  23607279,   41129689,  0x3c1004b},
        {23544863,   38446800,  23655136,   38533289,  0x3c1004b},
        {23967145,   35466800,  24072854,   35553289,  0x3c1004b},
        {28143825,   36371600,  28250975,   36458089,  0x3c1004b},
        {22443662,   40216800,  22556338,   40303289,  0x3c1004b},
        {22066064,   36966800,  22173935,   37053289,  0x3c1004b},
        {25820781,   40833500,  25934418,   40919989,  0x3c1004b},
        {21714142,   39516800,  21825857,   39603289,  0x3c1004b},
        {22374503,   38856800,  22485497,   38943289,  0x3c1004b},
        {24837821,   41066800,  24952179,   41153289,  0x3c1004b},
        {22143181,   40476800,  22256818,   40563289,  0x3c1004b},
        {21354863,   38576800,  21465136,   38663289,  0x3c1004b},
        {22863181,   40616800,  22976818,   40703289,  0x3c1004b},
        {21864142,   39326800,  21975857,   39413289,  0x3c1004b},
        {19822542,   39580500,  19934257,   39666989,  0x3c1004b},
        {25358945,   41088950,  25441054,   41151049,  0x2b2004b},
        {24105354,   41117840,  24184845,   41177959,  0x29c004b},
        {21749549,   40268950,  21830450,   40331049,  0x2b2004b},
        {21640505,   40479940,  21719495,   40540059,  0x29c004b},
        {24433050,   35314850,  24508949,   35376949,  0x2b2004b},
        {26497923,   39079840,  26575076,   39139959,  0x29c004b},
        {22343004,   40770350,  22424595,   40832449,  0x2b2004b},
        {22335058,   37485440,  22410541,   37545559,  0x29c004b},
        {22700515,   37607150,  22778484,   37669249,  0x2b2004b},
        {26113700,   38318000,  26157877,   38422200,  0x29c044b},
        {21395215,   37643750,  21473184,   37705849,  0x2b2004b},
        {23279874,   38285840,  23356526,   38345959,  0x29c004b},
        {22040757,   38218950,  22119243,   38281049,  0x2b2004b},
        {22860074,   38416440,  22936726,   38476559,  0x29c004b},
        {22050104,   40617150,  22131695,   40679249,  0x2b2004b},
        {20951423,   39129940,  21028576,   39190059,  0x29c004b},
        {22909000,   37923800,  22990102,   37983800,  0x2b2044b},
        {22018805,   40757528,  22097795,   40817647,  0x29c004b},
        {19361536,   39421980,  19965664,   39913020,  0x0010088},
        {20288852,   38024280,  20877356,   38515320,  0x0010888},
        {20483452,   37542580,  21071956,   38033620,  0x0011088},
        {23378660,   35212580,  23951540,   35703620,  0x0011888},
        {23951540,   35138924,  24524420,   35629964,  0x0012088},
        {24524420,   35237132,  25097300,   35728172,  0x0012888},
        {24529628,   34800000,  25097300,   35291040,  0x0013088},
        {25097300,   34908135,  25664972,   35399175,  0x0013888},
        {25664971,   34990000,  26361000,   35360000,  0x0184088},
        {24211652,   37263880,  24800156,   37754920,  0x0014888},
        {27379460,   35862280,  27952340,   36353320,  0x0015088},
        {27723188,   36034144,  28296068,   36525184,  0x0015888},
        {25425844,   38937380,  26024764,   39428420,  0x0016088},
        {26024764,   38937380,  26623684,   39428420,  0x0016888},
        {26781060,   36593580,  27359148,   37084620,  0x0017088},
        {24924052,   36753880,  25507348,   37244920,  0x0017888},
        {25507348,   36753880,  26090644,   37244920,  0x0018088},
        {24972860,   36309880,  25550948,   36800920,  0x0018888},
        {26204960,   36236280,  26783048,   36727320,  0x0019088},
        {24187960,   36565000,  24990000,   36867120,  0x0149888},
        {24750000,   37215000,  25640548,   37518000,  0x013a088},
        {24677552,   37513680,  25266056,   38004720,  0x001a888},
        {24938736,   39676380,  25542864,   40167420,  0x001b088},
        {26810000,   35330000,  27250000,   35920000,  0x026b888},
        {25970052,   37265000,  26616100,   37695820,  0x01bc088},
        {24248452,   36784280,  24831748,   37275320,  0x001c888},
        {24222244,   38660880,  24815956,   39151920,  0x001d088},
        {24368136,   40355380,  24977472,   40846420,  0x001d888},
        {25335536,   40275080,  25944872,   40766120,  0x001e088},
        {26494452,   37328880,  27082956,   37819920,  0x001e888},
        {25709852,   38133780,  26298356,   38624820,  0x001f088},
        {22755000,   41204856,  23905000,   41457000,  0x010008c},
        {23904682,   41204856,  24524434,   41580000,  0x001088c},
        {24524433,   41204856,  25144185,   41580000,  0x001108c},
        {25736049,   41204856,  26190000,   41750000,  0x026188c},
        {26190000,   41204856,  26643000,   41750000,  0x026208c},
        {20840009,   40713816,  21454553,   41204856,  0x001288c},
        {21454553,   40713816,  22069097,   41204856,  0x001308c},
        {22069097,   40713816,  22683641,   41204856,  0x001388c},
        {22683641,   40713816,  23298185,   41204856,  0x001408c},
        {23298185,   40713816,  23912729,   41204856,  0x001488c},
        {23912729,   40713816,  24527273,   41204856,  0x001508c},
        {24527273,   40713816,  25141817,   41204856,  0x001588c},
        {25141817,   40836576,  25756361,   41327616,  0x001608c},
        {25756361,   40713816,  26370905,   41204856,  0x001688c},
        {20679290,   40222776,  21288626,   40713816,  0x001708c},
        {21288626,   40222776,  21897962,   40713816,  0x001788c},
        {21897962,   40222776,  22507298,   40713816,  0x001808c},
        {22507298,   40222776,  23116634,   40713816,  0x001888c},
        {23116634,   40222776,  23725970,   40713816,  0x001908c},
        {23725970,   40222776,  24335306,   40713816,  0x001988c},
        {20191821,   39731736,  20795949,   40222776,  0x001a08c},
        {20795949,   39731736,  21400077,   40222776,  0x001a88c},
        {21400077,   39731736,  22004205,   40222776,  0x001b08c},
        {22004205,   39731736,  22608333,   40222776,  0x001b88c},
        {22608333,   39731736,  23212461,   40222776,  0x001c08c},
        {23212461,   39731736,  23816589,   40222776,  0x001c88c},
        {23816589,   39731736,  24420717,   40222776,  0x001d08c},
        {19743933,   39240696,  20342853,   39731736,  0x001d88c},
        {20342853,   39240696,  20941773,   39731736,  0x001e08c},
        {20941773,   39240696,  21540693,   39731736,  0x001e88c},
        {21540693,   39240696,  22139613,   39731736,  0x001f08c},
        {22139613,   39240696,  22738533,   39731736,  0x0b10090},
        {22738533,   39240696,  23337453,   39731736,  0x0b10890},
        {20432691,   38749656,  21026403,   39240696,  0x0b11090},
        {21026403,   38749656,  21620115,   39240696,  0x0b11890},
        {21620115,   38749656,  22213827,   39240696,  0x0b12090},
        {22213827,   38749656,  22807539,   39240696,  0x0b12890},
        {22807539,   38749656,  23401251,   39240696,  0x0b13090},
        {23401251,   38749656,  23994963,   39240696,  0x0b13890},
        {20437899,   38258616,  21026403,   38749656,  0x0b14090},
        {21026403,   38258616,  21614907,   38749656,  0x0b14890},
        {21614907,   38258616,  22203411,   38749656,  0x0b15090},
        {22203411,   38258616,  22791915,   38749656,  0x0b15890},
        {22791915,   38258616,  23380419,   38749656,  0x0b16090},
        {23380419,   38258616,  23968923,   38749656,  0x0b16890},
        {23968923,   38258616,  24557427,   38749656,  0x0b17090},
        {21085253,   37767576,  21673757,   38258616,  0x0b17890},
        {21673757,   37767576,  22262261,   38258616,  0x0b18090},
        {22262261,   37767576,  22850765,   38258616,  0x0b18890},
        {22850765,   37767576,  23439269,   38258616,  0x0b19090},
        {23439269,   37767576,  24027773,   38258616,  0x0b19890},
        {24027773,   37767576,  24616277,   38258616,  0x0b1a090},
        {21232379,   37276536,  21820883,   37767576,  0x0b0a890},
        {21820883,   37276536,  22409387,   37767576,  0x0b0b090},
        {22409387,   37276536,  22997891,   37767576,  0x0b0b890},
        {22997891,   37276536,  23586395,   37767576,  0x0b0c090},
        {23586395,   37276536,  24174899,   37767576,  0x0b0c890},
        {21526631,   36685000,  22000000,   37276536,  0x0d6d090},
        {22000000,   36785496,  22550000,   37276536,  0x0b6d890},
        {22550000,   36785496,  23100000,   37276536,  0x0b6e090},
        {22290124,   36294456,  22868212,   36785496,  0x0b1e890},
        {22868212,   36115000,  23227000,   36785496,  0x105f090},
        {19360400,   38400000,  20459500,   39262500,  0x001008d},
        {20000000,   37200000,  21072000,   38515000,  0x001088d},
        {23815000,   38500000,  25640000,   39700000,  0x001108d},
        {23085000,   36600000,  24780000,   37516000,  0x001188d},
        {24780000,   36200000,  26100000,   37516000,  0x001208d},
        {26100000,   36200000,  27130000,   37516000,  0x001288d},
        {23200000,   34800000,  25000000,   36000000,  0x001308d},
        {25000000,   34800000,  26485000,   36200000,  0x001388d},
        {26485000,   35300000,  27897000,   36699255,  0x001408d},
        {27897000,   34800000,  29646000,   36167000,  0x001488d},
        {19360400,   34800000,  29646000,   41750000,  0x0010216},
        {68715409,   38517071,  68825682,   38603560,  0x001000a}, // TJK
        {68169531,   38395400,  69060284,   38700000,  0x014000c},
        {68972344,   38257700,  69081656,   38344189,  0x3c1004b},
        {69243363,   38324100,  69353636,   38410589,  0x3c1004b},
        {69584662,   40242600,  69697338,   40329089,  0x3c1004b},
        {69731344,   37858600,  69840656,   37945089,  0x3c1004b},
        {68715344,   37796800,  68824656,   37883289,  0x3c1004b},
        {70359562,   40261700,  70472238,   40348189,  0x3c1004b},
        {68958200,   39876800,  69044260,   39990000,  0x3c1044b},
        {68164863,   38466800,  68275136,   38553289,  0x3c1004b},
        {70587200,   40103600,  70721333,   40176200,  0x3c1044b},
        {67464400,   39474400,  67653305,   39525500,  0x3c1044b},
        {71495704,   37446800,  71604296,   37533289,  0x3c1004b},
        {69584844,   37775400,  69694156,   37861889,  0x3c1004b},
        {69680062,   40202400,  69792738,   40288889,  0x3c1004b},
        {68575004,   37547100,  68683596,   37633589,  0x3c1004b},
        {69361704,   37454100,  69470296,   37540589,  0x3c1004b},
        {69561804,   37605700,  69670396,   37692189,  0x3c1004b},
        {69273744,   38055100,  69383056,   38141589,  0x3c1004b},
        {68774604,   37652200,  68883196,   37738689,  0x3c1004b},
        {69439100,   40133560,  69637720,   40182600,  0x3c1044b},
        {69237681,   40370200,  69351318,   40456689,  0x3c1004b},
        {69743762,   40170500,  69856438,   40256989,  0x3c1004b},
        {68076064,   37216800,  68183935,   37303289,  0x3c1004b},
        {69261181,   40460400,  69374818,   40546889,  0x3c1004b},
        {69316039,   40127040,  69399520,   40187159,  0x2b2044b},
        {70342223,   39015740,  70419376,   39075859,  0x29c004b},
        {69578204,   40525650,  69659795,   40587749,  0x2b2004b},
        {70309705,   40641040,  70388695,   40701159,  0x29c004b},
        {68865257,   37828950,  68943743,   37891049,  0x2b2004b},
        {69991770,   38069500,  70040681,   38162703,  0x29c044b},
        {69658712,   38704450,  69737888,   38766549,  0x2b2004b},
        {68779708,   37918140,  68855692,   37978259,  0x29c004b},
        {68795349,   40189850,  68876250,   40251949,  0x2b2004b},
        {68510374,   38497840,  68587026,   38557959,  0x29c004b},
        {69286012,   38522550,  69365188,   38584649,  0x2b2004b},
        {68593758,   37374440,  68669241,   37434559,  0x29c004b},
        {68768649,   40246550,  68849550,   40308649,  0x2b2004b},
        {69093539,   39932140,  69171861,   39992259,  0x29c004b},
        {68762215,   37743050,  68840184,   37805149,  0x2b2004b},
        {68299074,   38536740,  68375726,   38596859,  0x29c004b},
        {71400000,   36670000,  75189000,   38200000,  0x2a80015},
        {69240000,   40561900,  70184976,   40840000,  0x012008c},
        {70184976,   40561900,  70799520,   41052940,  0x001088c},
        {68457169,   40070860,  69066505,   40561900,  0x001108c},
        {69066505,   40070860,  69675841,   40561900,  0x001188c},
        {69675841,   40070860,  70285177,   40561900,  0x001208c},
        {70285177,   40070860,  70894513,   40561900,  0x001288c},
        {68548570,   39589640,  69152698,   40080680,  0x001308c},
        {69152698,   39589640,  69756826,   40080680,  0x001388c},
        {70391160,   39766415,  70995288,   40257455,  0x001408c},
        {67343543,   39186988,  67942463,   39678028,  0x001488c},
        {67942463,   39186988,  68541383,   39678028,  0x001508c},
        {68541383,   39186988,  69140303,   39678028,  0x001588c},
        {69140303,   39186988,  69739223,   39678028,  0x001608c},
        {69739223,   39186988,  70338143,   39678028,  0x001688c},
        {70338143,   39186988,  70937063,   39678028,  0x001708c},
        {70937063,   39186988,  71535983,   39678028,  0x001788c},
        {71535983,   39186988,  72134903,   39678028,  0x001808c},
        {72134903,   39186988,  72733823,   39678028,  0x001888c},
        {72733823,   39186988,  73332743,   39678028,  0x001908c},
        {73332743,   39186988,  73931663,   39678028,  0x001988c},
        {67343543,   38695948,  67937255,   39186988,  0x001a08c},
        {67937255,   38695948,  68530967,   39186988,  0x001a88c},
        {68530967,   38695948,  69124679,   39186988,  0x001b08c},
        {69124679,   38695948,  69718391,   39186988,  0x001b88c},
        {69718391,   38695948,  70312103,   39186988,  0x001c08c},
        {70312103,   38695948,  70905815,   39186988,  0x001c88c},
        {70905815,   38695948,  71499527,   39186988,  0x001d08c},
        {71499527,   38695948,  72093239,   39186988,  0x001d88c},
        {72093239,   38695948,  72686951,   39186988,  0x001e08c},
        {72686951,   38695948,  73280663,   39186988,  0x001e88c},
        {73280663,   38695948,  73874375,   39186988,  0x001f08c},
        {67942463,   38204908,  68530967,   38695948,  0x0010088},
        {68530967,   38204908,  69119471,   38695948,  0x0010888},
        {69119471,   38204908,  69707975,   38695948,  0x0011088},
        {69707975,   38204908,  70296479,   38695948,  0x0011888},
        {70296479,   38204908,  70884983,   38695948,  0x0012088},
        {70884983,   38204908,  71473487,   38695948,  0x0012888},
        {71473487,   38204908,  72061991,   38695948,  0x0013088},
        {72061991,   38204908,  72650495,   38695948,  0x0013888},
        {72650495,   38204908,  73238999,   38695948,  0x0014088},
        {73238999,   38204908,  73827503,   38695948,  0x0014888},
        {73827503,   38204908,  74416007,   38695948,  0x0015088},
        {74416007,   38204908,  75004511,   38695948,  0x0015888},
        {71255741,   37713868,  71844245,   38204908,  0x0016088},
        {71255741,   37222828,  71839037,   37713868,  0x0016888},
        {67755965,   37713868,  68344469,   38204908,  0x0017088},
        {68344469,   37713868,  68932973,   38204908,  0x0017888},
        {68932973,   37713868,  69521477,   38204908,  0x0018088},
        {69521477,   37713868,  70109981,   38204908,  0x0018888},
        {70109981,   37713868,  70698485,   38204908,  0x0019088},
        {67755965,   37222828,  68339261,   37713868,  0x0019888},
        {68339261,   37222828,  68922557,   37713868,  0x001a088},
        {68922557,   37222828,  69505853,   37713868,  0x001a888},
        {69505853,   37222828,  70089149,   37713868,  0x001b088},
        {70089149,   37222828,  70672445,   37713868,  0x001b888},
        {67755965,   36731788,  68339261,   37222828,  0x001c088},
        {68339261,   36731788,  68922557,   37222828,  0x001c888},
        {68922557,   36731788,  69505853,   37222828,  0x001d088},
        {55980000,   36670000,  80230000,   45600000,  0x27a0216},
        {67340000,   36670000,  75189000,   41056000,  0x003021c},
        {90355211,   23688355,  90449389,   23774845,  0x001000a}, // BGD
        {90202000,   23426000,  90590000,   24050000,  0x028000c},
        {91745300,   22343000,  91873048,   22406000,  0x3c1044b},
        {91760000,   22267000,  91865923,   22343000,  0x3c1044b},
        {89509852,   22783100,  89603548,   22869589,  0x3c1004b},
        {88552771,   24350900,  88659445,   24427500,  0x3c1044b},
        {91157032,   23414800,  91270421,   23486400,  0x3c1044b},
        {90360631,   24706700,  90455769,   24793189,  0x3c1004b},
        {91821831,   24862300,  91951124,   24925900,  0x3c1044b},
        {89202071,   25706800,  89297929,   25793289,  0x3c1004b},
        {90657791,   23876200,  90752208,   23962689,  0x3c1004b},
        {90313852,   22654000,  90407548,   22740489,  0x3c1004b},
        {91947832,   21405300,  92040567,   21491789,  0x3c1004b},
        {89159532,   23126200,  89253468,   23212689,  0x3c1004b},
        {89324031,   24804900,  89419169,   24891389,  0x3c1004b},
        {91059691,   23931400,  91154108,   24017889,  0x3c1004b},
        {88592191,   25586800,  88687809,   25673289,  0x3c1004b},
        {89192291,   23963400,  89286708,   24049889,  0x3c1004b},
        {88215271,   24549500,  88309928,   24635989,  0x3c1004b},
        {89889171,   24204600,  89983828,   24291089,  0x3c1004b},
        {89892431,   24876800,  89987569,   24963289,  0x3c1004b},
        {88912431,   24776800,  89007569,   24863289,  0x3c1004b},
        {89626371,   24416900,  89721028,   24503389,  0x3c1004b},
        {90634232,   23186100,  90728168,   23272589,  0x3c1004b},
        {91075652,   22902800,  91169348,   22989289,  0x3c1004b},
        {89097704,   23878950,  89165495,   23941049,  0x2b2004b},
        {88827285,   23602640,  88892915,   23662759,  0x29c004b},
        {91064263,   22840050,  91131537,   22902149,  0x2b2004b},
        {89043035,   22685140,  89108164,   22745259,  0x29c004b},
        {89506773,   25302250,  89575427,   25364349,  0x2b2004b},
        {89812552,   23568740,  89877848,   23628859,  0x29c004b},
        {89038204,   24089550,  89105995,   24151649,  0x2b2004b},
        {90953285,   24029140,  91018915,   24089259,  0x29c004b},
        {88948918,   24380150,  89016882,   24442249,  0x2b2004b},
        {89566801,   24144740,  89632598,   24204859,  0x29c004b},
        {89983345,   24984050,  90051654,   25046149,  0x2b2004b},
        {90593235,   22655140,  90658364,   22715259,  0x29c004b},
        {89137977,   23511350,  89205423,   23573449,  0x2b2004b},
        {90748001,   24399640,  90813798,   24459759,  0x29c004b},
        {89610987,   25782550,  89679813,   25844649,  0x2b2004b},
        {91393601,   24343040,  91459398,   24403159,  0x29c004b},
        {88300400,   26148960,  88815992,   26640000,  0x001008c},
        {88815992,   25991648,  89331584,   26482688,  0x001088c},
        {88078695,   25746128,  88594287,   26237168,  0x001108c},
        {88594287,   25746128,  89109879,   26237168,  0x001188c},
        {89109879,   25705000,  89550000,   26120000,  0x001208c},
        {89550000,   25705000,  89898735,   26260000,  0x028288c},
        {88310000,   25255088,  88841771,   25746128,  0x01e308c},
        {88841771,   25255088,  89357363,   25746128,  0x001388c},
        {89357363,   25255088,  89890000,   25705000,  0x01d408c},
        {88064808,   24764048,  88580400,   25255088,  0x001488c},
        {88580399,   24764048,  89095991,   25255088,  0x001508c},
        {89095991,   24764048,  89611583,   25255088,  0x001588c},
        {89611583,   24764048,  90070000,   25311000,  0x022608c},
        {90070000,   24764048,  90580000,   25248267,  0x001688c},
        {90580000,   24764048,  91143967,   25202000,  0x01b708c},
        {91143967,   24764048,  91659559,   25255088,  0x001788c},
        {91659559,   24764048,  92175151,   25255088,  0x001808c},
        {92167000,   24418000,  92500000,   25141000,  0x02e888c},
        {88004500,   24296023,  88550000,   24764048,  0x01d908c},
        {88550000,   24273008,  89065976,   24764048,  0x01e988c},
        {89065976,   24273008,  89576360,   24764048,  0x001a08c},
        {89576359,   24273008,  90086743,   24764048,  0x001a88c},
        {90086743,   24273008,  90597127,   24764048,  0x001b08c},
        {90597127,   24273008,  91107511,   24764048,  0x001b88c},
        {91107512,   24273008,  91617896,   24764048,  0x001c08c},
        {91617896,   24365000,  92175000,   24764048,  0x01ac88c},
        {88555591,   23781968,  89065975,   24273008,  0x001d08c},
        {89065974,   23781968,  89576358,   24273008,  0x001d88c},
        {89576358,   23781968,  90086742,   24273008,  0x001e08c},
        {90086742,   23781968,  90597126,   24273008,  0x001e88c},
        {90597127,   23781968,  91107511,   24273008,  0x001f08c},
        {91107511,   23781968,  91617895,   24273008,  0x0010088},
        {91617895,   24076592,  92128279,   24567632,  0x0010888},
        {88560798,   23290928,  89065974,   23781968,  0x0011088},
        {89065974,   23290928,  89571150,   23781968,  0x0011888},
        {89571150,   23290928,  90076326,   23781968,  0x0012088},
        {90076326,   23290928,  90581502,   23781968,  0x0012888},
        {90581502,   23290928,  91086678,   23781968,  0x0013088},
        {91086678,   23290928,  91591854,   23781968,  0x0013888},
        {88690016,   22799888,  89195192,   23290928,  0x0015088},
        {89195192,   22799888,  89700368,   23290928,  0x0015888},
        {89700368,   22799888,  90205544,   23290928,  0x0016088},
        {90205544,   22799888,  90710720,   23290928,  0x0016888},
        {90710720,   22799888,  91215896,   23290928,  0x0017088},
        {91215896,   22799888,  91721072,   23290928,  0x0017888},
        {91830000,   23380000,  92360000,   23740000,  0x01a4088},
        {91721072,   22799888,  92100000,   23380000,  0x0278088},
        {92100000,   22799888,  92480000,   23380000,  0x0268888},
        {88907241,   22308847,  89412417,   22799887,  0x0019088},
        {89412417,   22308847,  89917593,   22799887,  0x0019888},
        {89917593,   22308847,  90422769,   22799887,  0x001a088},
        {90422769,   22308847,  90927945,   22799887,  0x001a888},
        {90927945,   22308847,  91433121,   22799887,  0x001b088},
        {91433121,   22308847,  91938297,   22799887,  0x001b888},
        {91938297,   22308847,  92443473,   22799887,  0x001c088},
        {92176824,   22308847,  92682000,   22799887,  0x001c888},
        {91655399,   21817808,  92155367,   22308848,  0x001d088},
        {92155367,   21817808,  92655335,   22308848,  0x001d888},
        {91830387,   21326767,  92330355,   21817807,  0x001e088},
        {92320000,   21200000,  92682000,   21818000,  0x028e888},
        {92020000,   20680000,  92386000,   21327000,  0x029f088},
        {88990000,   20650000,  92030000,   22308848,  0x2dd0015},
        {88004500,   20573700,  92682000,   26640000,  0x0010216},
        {85262950,   27666755,  85360011,   27753245,  0x001000a}, // NPL
        {85113600,   27470680,  85639608,   27961720,  0x001000c},
        {87221981,   26388790,  87358219,   26511099,  0x54f004b},
        {83920861,   28158890,  84059138,   28281199,  0x54f004b},
        {84801541,   26958890,  84938459,   27081199,  0x54f004b},
        {87205241,   26748890,  87342159,   26871199,  0x54f004b},
        {84330601,   27601890,  84468198,   27724199,  0x54f004b},
        {85845381,   26657790,  85981619,   26780099,  0x54f004b},
        {80117029,   28920100,  80215770,   29006589,  0x3c1004b},
        {83397550,   27635500,  83494850,   27721989,  0x3c1004b},
        {80540869,   28646800,  80639130,   28733289,  0x3c1004b},
        {84971350,   27366800,  85068650,   27453289,  0x3c1004b},
        {81571810,   28004300,  81669590,   28090789,  0x3c1004b},
        {87620630,   26632200,  87716969,   26718689,  0x3c1004b},
        {83401850,   27471200,  83499150,   27557689,  0x3c1004b},
        {81294610,   28163500,  81392390,   28249989,  0x3c1004b},
        {87221530,   26629600,  87317869,   26716089,  0x3c1004b},
        {81062869,   28487400,  81161130,   28573889,  0x3c1004b},
        {82241110,   28086800,  82338890,   28173289,  0x3c1004b},
        {86650790,   26754000,  86747609,   26840489,  0x3c1004b},
        {81563769,   28533700,  81662030,   28620189,  0x3c1004b},
        {84975090,   26978600,  85071909,   27065089,  0x3c1004b},
        {86691830,   26496800,  86788169,   26583289,  0x3c1004b},
        {86412530,   26694100,  86508869,   26780589,  0x3c1004b},
        {85221830,   26726800,  85318169,   26813289,  0x3c1004b},
        {87061230,   26566500,  87157569,   26652989,  0x3c1004b},
        {85522690,   26809600,  85619509,   26896089,  0x3c1004b},
        {80050000,   27650000,  82700000,   30450000,  0x021000d},
        {84630000,   26340000,  88200000,   28500000,  0x08a0011},
        {82700000,   27314000,  85200000,   29860000,  0x0010015},
        {80050000,   26340000,  88202700,   30450000,  0x0010216},
        {10116400,   36817700,  10220679,   36862290,  0x2a7044a}, // TUN
        {10081887,   36775500,  10192227,   36817700,  0x2a7044a},
        {10004097,   36624220,  10432702,   36970179,  0xf040047},
        {10510545,   35598600,  10919854,   35933489,  0xe890047},
        {9789327,    37214490,  9941873,    37336799,  0x54f004b},
        {10021914,   33829890,  10168685,   33952199,  0x54f004b},
        {10957406,   33754600,  11061193,   33841089,  0x3c1004b},
        {10043145,   35634800,  10148854,   35721289,  0x3c1004b},
        {10744599,   34699390,  10818778,   34821699,  0x3c1044b},
        {10670365,   34699390,  10744544,   34821699,  0x3c1044b},
        {8729346,    34370200,  8833853,    34456689,  0x3c1004b},
        {8777145,    35136800,  8882854,    35223289,  0x3c1004b},
        {11021767,   33468600,  11124833,   33555089,  0x3c1004b},
        {10789706,   33815700,  10893493,   33902189,  0x3c1004b},
        {10672921,   36420000,  10825452,   36480700,  0x3c1044b},
        {10536000,   36370900,  10672921,   36438550,  0x3c1044b},
        {10398707,   32886800,  10501292,   32973289,  0x3c1004b},
        {10432567,   33304900,  10535633,   33391389,  0x3c1004b},
        {9150625,    36686000,  9257775,    36772489,  0x3c1004b},
        {10923445,   35579100,  11029154,   35665589,  0x3c1004b},
        {9735764,    37111300,  9843635,    37197789,  0x3c1004b},
        {8652385,    36127400,  8758814,    36213889,  0x3c1004b},
        {11025300,   35385700,  11081949,   35547000,  0x3c1044b},
        {8724325,    36456000,  8831475,    36542489,  0x3c1004b},
        {8346646,    34272100,  8451153,    34358589,  0x3c1004b},
        {9431106,    34993200,  9536094,    35079689,  0x3c1004b},
        {11030564,   36816700,  11138435,   36903189,  0x3c1004b},
        {9727206,    33844400,  9830993,    33930889,  0x3c1004b},
        {10920164,   36708000,  11028035,   36794489,  0x3c1004b},
        {8080306,    33872900,  8184093,    33959389,  0x3c1004b},
        {10773925,   36515500,  10881075,   36601989,  0x3c1004b},
        {8967767,    33426700,  9070833,    33513189,  0x3c1004b},
        {10921045,   35359400,  11026754,   35445889,  0x3c1004b},
        {7500000,    32800000,  11563000,   34697028,  0x017000d},
        {8111127,    34697028,  11358346,   37378218,  0x0a80011},
        {8340000,    30390000,  11620000,   32800000,  0x3740015},
        {7500000,    30185000,  11620000,   37600000,  0x0010016},
        {-55214000,  5798360,   -55160063,  5867900,   0x2a7044a}, // SUR
        {-55160063,  5821370,   -55098977,  5882772,   0x2a7044a},
        {-55420298,  5506280,   -54951578,  5997320,   0x001000c},
        {-57071670,  5837910,   -56897730,  6010889,   0x782004b},
        {-54491170,  5544210,   -54317230,  5717189,   0x782004b},
        {-54960270,  5758810,   -54786330,  5931789,   0x782004b},
        {-56766970,  5693510,   -56593030,  5866489,   0x782004b},
        {-54175696,  5415920,   -54025105,  5565679,   0x680004b},
        {-55566096,  5725220,   -55415505,  5874979,   0x680004b},
        {-55260988,  4971320,   -55110813,  5121079,   0x680004b},
        {-55110813,  4971320,   -54960638,  5121079,   0x680004b},
        {-56369996,  5760620,   -56219405,  5910379,   0x680004b},
        {-57215496,  5535742,   -56746776,  6026782,   0x001008c},
        {-56746776,  5535742,   -56278056,  6026782,   0x001088c},
        {-56278056,  5535742,   -55809336,  6026782,   0x001108c},
        {-55809336,  5535742,   -55340616,  6026782,   0x001188c},
        {-55340616,  5535742,   -54871896,  6026782,   0x001208c},
        {-54871896,  5535742,   -54403176,  6026782,   0x001288c},
        {-54447720,  5462086,   -53979000,  5953126,   0x001308c},
        {-57337363,  5044702,   -56868643,  5535742,   0x001388c},
        {-56868643,  5044702,   -56399923,  5535742,   0x001408c},
        {-56399923,  5044702,   -55931203,  5535742,   0x001488c},
        {-55931203,  5044702,   -55462483,  5535742,   0x001508c},
        {-55462483,  5044702,   -54993763,  5535742,   0x001588c},
        {-54993763,  5044702,   -54525043,  5535742,   0x001608c},
        {-54525043,  5044702,   -54056323,  5535742,   0x001688c},
        {-58073253,  4553662,   -57604533,  5044702,   0x001708c},
        {-57604533,  4553662,   -57135813,  5044702,   0x001788c},
        {-57135813,  4553662,   -56667093,  5044702,   0x001808c},
        {-56667093,  4553662,   -56198373,  5044702,   0x001888c},
        {-56198373,  4553662,   -55729653,  5044702,   0x001908c},
        {-55729653,  4553662,   -55260933,  5044702,   0x001988c},
        {-55260933,  4553662,   -54792213,  5044702,   0x001a08c},
        {-54792213,  4553662,   -54323493,  5044702,   0x001a88c},
        {-58073253,  4062622,   -57604533,  4553662,   0x001b08c},
        {-57604533,  4062622,   -57135813,  4553662,   0x001b88c},
        {-57135813,  4062622,   -56667093,  4553662,   0x001c08c},
        {-56667093,  4062622,   -56198373,  4553662,   0x001c88c},
        {-56198373,  4062622,   -55729653,  4553662,   0x001d08c},
        {-55729653,  4062622,   -55260933,  4553662,   0x001d88c},
        {-55260933,  4062622,   -54792213,  4553662,   0x001e08c},
        {-54792213,  4062622,   -54323493,  4553662,   0x001e88c},
        {-58073253,  3571582,   -57604533,  4062622,   0x001f08c},
        {-57604533,  3571582,   -57135813,  4062622,   0x0010088},
        {-57135813,  3571582,   -56667093,  4062622,   0x0010888},
        {-56667093,  3571582,   -56198373,  4062622,   0x0011088},
        {-56198373,  3571582,   -55729653,  4062622,   0x0011888},
        {-55729653,  3571582,   -55260933,  4062622,   0x0012088},
        {-55260933,  3571582,   -54792213,  4062622,   0x0012888},
        {-54792213,  3571582,   -54323493,  4062622,   0x0013088},
        {-54447720,  3571582,   -53979000,  4062622,   0x0013888},
        {-57721713,  3080542,   -57252993,  3571582,   0x0014088},
        {-57252993,  3080542,   -56784273,  3571582,   0x0014888},
        {-56784273,  3080542,   -56315553,  3571582,   0x0015088},
        {-56315553,  3080542,   -55846833,  3571582,   0x0015888},
        {-55846833,  3080542,   -55378113,  3571582,   0x0016088},
        {-55378113,  3080542,   -54909393,  3571582,   0x0016888},
        {-54909393,  3080542,   -54440673,  3571582,   0x0017088},
        {-54447720,  3080542,   -53979000,  3571582,   0x0017888},
        {-57276429,  2589502,   -56807709,  3080542,   0x0018088},
        {-56807709,  2589502,   -56338989,  3080542,   0x0018888},
        {-56338989,  2589502,   -55870269,  3080542,   0x0019088},
        {-55870269,  2589502,   -55401549,  3080542,   0x0019888},
        {-55401549,  2589502,   -54932829,  3080542,   0x001a088},
        {-54932829,  2589502,   -54464109,  3080542,   0x001a888},
        {-54464109,  2589502,   -53995389,  3080542,   0x001b088},
        {-57042069,  2098462,   -56573349,  2589502,   0x001b888},
        {-56573349,  2098462,   -56104629,  2589502,   0x001c088},
        {-56104629,  2098462,   -55635909,  2589502,   0x001c888},
        {-55635909,  2098462,   -55167189,  2589502,   0x001d088},
        {-55167189,  2098462,   -54698469,  2589502,   0x001d888},
        {-54698469,  2098462,   -54229749,  2589502,   0x001e088},
        {-56760837,  1830000,   -56292117,  2098462,   0x001e888},
        {-56292117,  1830000,   -55823397,  2098462,   0x001f088},
        {-56760837,  1830000,   -56292117,  2098462,   0x082e890},
        {-56292117,  1830000,   -55823397,  2098462,   0x082f090},
        {-58086600,  1830000,   -53979000,  6029000,   0x0010216},
        {-56221894,  -34928845, -56117145,  -34842355, 0x001000a}, // URY
        {-56477600,  -34938500, -55600000,  -34627800, 0x013000c},
        {-58005647,  -31443110, -57862953,  -31320801, 0x54f004b},
        {-58116000,  -32356750, -58028021,  -32256750, 0x3c1044b},
        {-55576492,  -30944400, -55476309,  -30857911, 0x3c1004b},
        {-55004994,  -34973000, -54912351,  -34875000, 0x3c1044b},
        {-54912351,  -34942400, -54777647,  -34875000, 0x3c1044b},
        {-56030992,  -31748000, -55929608,  -31661511, 0x3c1004b},
        {-54209033,  -32410000, -54107168,  -32323511, 0x3c1004b},
        {-58081533,  -33295200, -57978467,  -33208711, 0x3c1004b},
        {-56516851,  -30443200, -56417149,  -30356711, 0x3c1004b},
        {-55295254,  -34424500, -55190747,  -34338011, 0x3c1004b},
        {-56756154,  -34379400, -56651647,  -34292911, 0x3c1004b},
        {-56271894,  -34143200, -56168107,  -34056711, 0x3c1004b},
        {-57886354,  -34476400, -57781847,  -34389911, 0x3c1004b},
        {-58361333,  -33193900, -58258267,  -33107411, 0x3c1004b},
        {-56574233,  -33424700, -56471167,  -33338211, 0x3c1004b},
        {-54379354,  -34522400, -54274847,  -34435911, 0x3c1004b},
        {-54972094,  -34835400, -54867106,  -34748911, 0x3c1004b},
        {-54436533,  -33275400, -54333467,  -33188911, 0x3c1004b},
        {-56332754,  -34567800, -56228247,  -34481311, 0x3c1004b},
        {-56949433,  -33560200, -56846367,  -33473711, 0x3c1004b},
        {-58359794,  -34032300, -58256007,  -33945811, 0x3c1004b},
        {-56459154,  -34487300, -56354647,  -34400811, 0x3c1004b},
        {-53436093,  -32657900, -53333508,  -32571411, 0x3c1004b},
        {-57681293,  -32747600, -57578708,  -32661111, 0x3c1004b},
        {-58268633,  -33574000, -58165567,  -33487511, 0x3c1004b},
        {-57640451,  -30301700, -57540749,  -30215211, 0x3c1004b},
        {-56561293,  -32853200, -56458708,  -32766711, 0x3c1004b},
        {-57499554,  -34446000, -57395047,  -34359511, 0x3c1004b},
        {-53510594,  -33737600, -53406807,  -33651111, 0x3c1004b},
        {-57301254,  -34358900, -57196747,  -34272411, 0x3c1004b},
        {-58447000,  -34974500, -53350000,  -33310000, 0x0690011},
        {-58368000,  -33310000, -53152000,  -31895300, 0x011000d},
        {-58220000,  -31895300, -54080000,  -30085692, 0x2aa0015},
        {-58447000,  -34974500, -53152000,  -30085692, 0x0010216},
        {104859637,  11518755,  104947088,  11605245,  0x001000a}, // KHM
        {104681640,  11365584,  105155568,  11856624,  0x001000c},
        {103471526,  10554890,  103595873,  10677199,  0x54f004b},
        {103111317,  13040290,  103236683,  13162599,  0x54f004b},
        {103786247,  13320590,  103911953,  13442899,  0x54f004b},
        {102541347,  13598790,  102667053,  13721099,  0x54f004b},
        {104598694,  12193500,  104687105,  12279989,  0x3c1004b},
        {105312115,  11447100,  105400285,  11533589,  0x3c1004b},
        {103874794,  12495800,  103963205,  12582289,  0x3c1004b},
        {104734035,  10937800,  104821965,  11024289,  0x3c1004b},
        {104480715,  11439600,  104568885,  11526089,  0x3c1004b},
        {106125915,  11770500,  106214085,  11856989,  0x3c1004b},
        {105055015,  12014100,  105143185,  12100589,  0x3c1004b},
        {102943854,  13526100,  103032745,  13612589,  0x3c1004b},
        {105985794,  12436800,  106074205,  12523289,  0x3c1004b},
        {104136035,  10566800,  104223965,  10653289,  0x3c1004b},
        {104845674,  12676800,  104934325,  12763289,  0x3c1004b},
        {102928615,  11562000,  103016785,  11648489,  0x3c1004b},
        {105755915,  11036800,  105844085,  11123289,  0x3c1004b},
        {104276935,  10475900,  104364865,  10562389,  0x3c1004b},
        {107145794,  12406800,  107234205,  12493289,  0x3c1004b},
        {106743554,  13918400,  106832445,  14004889,  0x3c1004b},
        {105934354,  13476100,  106023245,  13562589,  0x3c1004b},
        {102563074,  12825400,  102651725,  12911889,  0x3c1004b},
        {104150694,  12478100,  104239105,  12564589,  0x3c1004b},
        {105409415,  11932800,  105497585,  12019289,  0x3c1004b},
        {103417174,  12712000,  103505825,  12798489,  0x3c1004b},
        {102867355,  9881000,   102955045,  9967489,   0x3c1004b},
        {103450000,  9272000,   103561110,  9340000,   0x3c1044b},
        {102700000,  10230000,  106230000,  12250000,  0x0800011},
        {105350000,  11653500,  107640000,  14693000,  0x45d0015},
        {102330000,  12250000,  105350000,  14444000,  0x01a000d},
        {97330000,   5612500,   109500000,  23400000,  0x4720216},
        {102330000,  9270000,   107640000,  14704960,  0x003021c},
        {36242067,   33475355,  36344894,   33561845,  0x001000a}, // SYR
        {36113166,   33344000,  36577557,   33651000,  0xf040447},
        {36990450,   36044100,  37402549,   36378989,  0xe890047},
        {36638065,   34665190,  36786534,   34787499,  0x54f004b},
        {35717000,   35495000,  35890909,   35600099,  0x54f044b},
        {36683165,   35055190,  36831634,   35177499,  0x54f004b},
        {40088145,   35292800,  40193854,   35379289,  0x3c1004b},
        {40690125,   36464600,  40797275,   36551089,  0x3c1004b},
        {41189564,   37023050,  41304394,   37104189,  0x3c1044b},
        {38929500,   35925700,  39060627,   35995889,  0x3c1044b},
        {35863106,   34847100,  35968094,   34933589,  0x3c1004b},
        {36610985,   35907200,  36717414,   35993689,  0x3c1004b},
        {36037707,   32595200,  36140292,   32681689,  0x3c1004b},
        {38487485,   35781600,  38593914,   35868089,  0x3c1004b},
        {37901225,   36483300,  38008375,   36569789,  0x3c1004b},
        {36536007,   32677900,  36638592,   32764389,  0x3c1004b},
        {36995406,   34967900,  37100394,   35054389,  0x3c1004b},
        {36641745,   35601800,  36747454,   35688289,  0x3c1004b},
        {35912945,   35326300,  36018654,   35412789,  0x3c1004b},
        {36269085,   35769600,  36375514,   35856089,  0x3c1004b},
        {37479025,   36329500,  37586175,   36415989,  0x3c1004b},
        {35990707,   32849800,  36093292,   32936289,  0x3c1004b},
        {40865746,   34407600,  40970253,   34494089,  0x3c1004b},
        {35922500,   35156000,  36000489,   35273000,  0x3c1044b},
        {38227746,   34506800,  38332253,   34593289,  0x3c1004b},
        {36559985,   35776700,  36666414,   35863189,  0x3c1004b},
        {40389706,   34977100,  40494694,   35063589,  0x3c1004b},
        {36644406,   33956500,  36748193,   34042989,  0x3c1004b},
        {35815967,   33107400,  35919033,   33193889,  0x3c1004b},
        {36683006,   34878700,  36787994,   34965189,  0x3c1004b},
        {36517046,   34494100,  36621553,   34580589,  0x3c1004b},
        {35717000,   34650000,  39550000,   36926185,  0x08f0011},
        {35586890,   32313599,  38955000,   34650000,  0x01c000d},
        {39550000,   34380000,  42380000,   37322182,  0x4350015},
        {34217000,   28520000,  48790000,   37390000,  0x0010016},
        {35586900,   32313600,  42380000,   37322200,  0x003021c},
        {-17490000,  14648500,  -17416000,  14747500,  0x024000a}, // SEN
        {-17530000,  14642000,  -16875000,  14988000,  0x016000c},
        {-16118946,  14117700,  -16030055,  14204189,  0x3c1004b},
        {-16312726,  12522590,  -16199475,  12590000,  0x3c1044b},
        {-17025266,  14386800,  -16936135,  14473289,  0x3c1004b},
        {-16515126,  15978200,  -16425274,  16064689,  0x3c1004b},
        {-15934000,  14850000,  -15823610,  14920000,  0x3c1044b},
        {-15934000,  14780000,  -15823610,  14850000,  0x3c1044b},
        {-16275666,  14608200,  -16186535,  14694689,  0x3c1004b},
        {-16268506,  15580800,  -16178894,  15667289,  0x3c1004b},
        {-15727000,  16431700,  -15574845,  16482850,  0x3c1044b},
        {-13724446,  13710900,  -13635555,  13797389,  0x3c1004b},
        {-14994326,  12866800,  -14905675,  12953289,  0x3c1004b},
        {-16450366,  14290100,  -16361235,  14376589,  0x3c1004b},
        {-16272326,  12757600,  -16183675,  12844089,  0x3c1004b},
        {-16873646,  14133800,  -16784755,  14220289,  0x3c1004b},
        {-15821546,  13702300,  -15732655,  13788789,  0x3c1004b},
        {-15596126,  12660200,  -15507475,  12746689,  0x3c1004b},
        {-15507871,  15318550,  -15443530,  15380649,  0x2b2004b},
        {-15616995,  13603340,  -15555206,  13663459,  0x29c004b},
        {-15586912,  14075550,  -15523088,  14137649,  0x2b2004b},
        {-16495978,  14676240,  -16434022,  14736359,  0x29c004b},
        {-15536943,  16481750,  -15472257,  16543849,  0x2b2004b},
        {-14140895,  13119940,  -14079106,  13180059,  0x29c004b},
        {-16665785,  15081450,  -16601616,  15143549,  0x2b2004b},
        {-16476345,  15340340,  -16414055,  15400459,  0x29c004b},
        {-12216640,  12527950,  -12153161,  12590049,  0x2b2004b},
        {-15975878,  14238140,  -15913922,  14298259,  0x29c004b},
        {-14835412,  13945850,  -14771588,  14007949,  0x2b2004b},
        {-16387095,  13852540,  -16325306,  13912659,  0x29c004b},
        {-16713485,  14723650,  -16649316,  14785749,  0x2b2004b},
        {-13793311,  13103440,  -13731689,  13163559,  0x29c004b},
        {-14207426,  12701650,  -14143775,  12763749,  0x2b2004b},
        {-13351145,  15569940,  -13288855,  15630059,  0x29c004b},
        {-15162871,  15381750,  -15098530,  15443849,  0x2b2004b},
        {-12908645,  15219440,  -12846355,  15279559,  0x29c004b},
        {-16111298,  14474050,  -16047302,  14536149,  0x2b2004b},
        {-12491362,  14877640,  -12429239,  14937759,  0x29c004b},
        {-15889940,  12521750,  -15826461,  12583849,  0x2b2004b},
        {-14518611,  12844140,  -14456989,  12904259,  0x29c004b},
        {-16521912,  13758950,  -16458088,  13821049,  0x2b2004b},
        {-15991911,  12787940,  -15930289,  12848059,  0x29c004b},
        {-15961912,  13888950,  -15898088,  13951049,  0x2b2004b},
        {-16533411,  12749840,  -16471789,  12809959,  0x29c004b},
        {-16747998,  14404850,  -16684002,  14466949,  0x2b2004b},
        {-15001712,  16633840,  -14939088,  16693959,  0x29c004b},
        {-16569440,  12440850,  -16505961,  12502949,  0x2b2004b},
        {-16700978,  14159940,  -16639022,  14220059,  0x29c004b},
        {-16888000,  12301390,  -11400000,  13510000,  0x00e000d},
        {-17550000,  13587000,  -15216600,  16590000,  0x0c10011},
        {-15216600,  13510000,  -11925000,  15700000,  0x31a0015},
        {-17620000,  12301390,  -11333000,  16694000,  0x0010016},
        {74531379,   42818155,  74648621,   42904645,  0x001000a}, // KGZ
        {73770000,   42768000,  75210000,   42973000,  0x00d000c},
        {72733250,   40463190,  72893950,   40585499,  0x54f004b},
        {72880250,   40867490,  73040950,   40989799,  0x54f004b},
        {78310381,   42439990,  78474819,   42562299,  0x54f004b},
        {75204401,   42765990,  75370198,   42888299,  0x54f004b},
        {75890000,   41410000,  76136924,   41450000,  0x3c1044b},
        {72161000,   42499000,  72343877,   42554400,  0x3c1044b},
        {72025000,   40209000,  72162181,   40280000,  0x3c1044b},
        {73248881,   40744700,  73362518,   40831189,  0x3c1004b},
        {76127860,   42412800,  76244140,   42499289,  0x3c1004b},
        {72707721,   40983100,  72822079,   41069589,  0x3c1004b},
        {72834281,   40671100,  72947918,   40757589,  0x3c1004b},
        {72162821,   41306800,  72277179,   41393289,  0x3c1004b},
        {72392821,   41216800,  72507179,   41303289,  0x3c1004b},
        {74382340,   41636800,  74497659,   41723289,  0x3c1004b},
        {72897140,   41839400,  73012459,   41925889,  0x3c1004b},
        {72948981,   40737900,  73062618,   40824389,  0x3c1004b},
        {75652779,   42760100,  75770020,   42846589,  0x3c1004b},
        {77951360,   42302100,  78067640,   42388589,  0x3c1004b},
        {75758621,   41120700,  75872979,   41207189,  0x3c1004b},
        {69492000,   39811900,  69573025,   39931000,  0x3c1044b},
        {76915960,   42066700,  77032240,   42153189,  0x3c1044b},
        {72290621,   40997800,  72404979,   41084289,  0x3c1004b},
        {69554000,   39907000,  69760945,   39954000,  0x3c1044b},
        {75864021,   41127100,  75978379,   41213589,  0x3c1004b},
        {78301379,   42686800,  78418620,   42773289,  0x3c1004b},
        {75531379,   42706800,  75648620,   42793289,  0x3c1004b},
        {77021379,   42606800,  77138620,   42693289,  0x3c1044b},
        {70841000,   42162719,  79230000,   43268600,  0x0460011},
        {70422234,   39481505,  73877990,   42162695,  0x001000d},
        {69233716,   39720856,  69837844,   40211896,  0x0b00090},
        {69837844,   39720856,  70441972,   40211896,  0x0b00890},
        {73856265,   41682150,  74481225,   42173190,  0x0b01090},
        {74481225,   41682150,  75106185,   42173190,  0x0b01890},
        {75106185,   41682150,  75731145,   42173190,  0x0b02090},
        {75731145,   41682150,  76356105,   42173190,  0x0b02890},
        {76356105,   41682150,  76981065,   42173190,  0x0b03090},
        {76981065,   41682150,  77606025,   42173190,  0x0b03890},
        {77606025,   41682150,  78230985,   42173190,  0x0b04090},
        {78230985,   41682150,  78855945,   42173190,  0x0b04890},
        {78855945,   41682150,  79480905,   42173190,  0x0b05090},
        {73861473,   41191110,  74481225,   41682150,  0x0b05890},
        {74481225,   41191110,  75100977,   41682150,  0x0b06090},
        {75100977,   41191110,  75720729,   41682150,  0x0b06890},
        {75720729,   41191110,  76340481,   41682150,  0x0b07090},
        {76340481,   41191110,  76960233,   41682150,  0x0b07890},
        {76960233,   41191110,  77579985,   41682150,  0x0b08090},
        {77579985,   41191110,  78199737,   41682150,  0x0b08890},
        {78199737,   41360000,  79108000,   41682150,  0x0769090},
        {73861473,   40700070,  74476017,   41191110,  0x0b09890},
        {74476017,   40700070,  75090561,   41191110,  0x0b0a090},
        {75090560,   40700070,  75705104,   41191110,  0x0b0a890},
        {75705105,   40700070,  76319649,   41191110,  0x0b0b090},
        {76319649,   40700070,  76934193,   41191110,  0x0b0b890},
        {76934192,   40963000,  78035500,   41191110,  0x05ac090},
        {73869284,   40209030,  74478620,   40700070,  0x0b0c890},
        {74478620,   40209030,  75087956,   40700070,  0x0b0d090},
        {75087956,   40209030,  75697292,   40700070,  0x0b0d890},
        {75697292,   40209030,  76306628,   40700070,  0x0b0e090},
        {76306628,   40209030,  76915964,   40700070,  0x0b0e890},
        {73869284,   39717990,  74473412,   40209030,  0x0b0f090},
        {55980000,   36670000,  80230000,   45600000,  0x27a0016},
        {69249199,   39172800,  80230000,   43268600,  0x003021c},
        {27478925,   53858155,  27624036,   53944645,  0x001000a}, // BLR
        {27344452,   53787690,  27755548,   54032309,  0xa9e0047},
        {30791926,   52307690,  31188073,   52552309,  0xa9e0047},
        {30121552,   53777990,  30532648,   54022609,  0xa9e0047},
        {29980453,   55077210,  30379546,   55305989,  0x9ee0047},
        {23729026,   53610690,  23831723,   53732999,  0x3c1044b},
        {23831723,   53610690,  23934420,   53732999,  0x3c1044b},
        {23593563,   52039990,  23692526,   52162299,  0x3c1044b},
        {23692526,   52039990,  23791489,   52162299,  0x3c1044b},
        {29139800,   53100400,  29260894,   53202940,  0x3c1044b},
        {25948966,   53094100,  26092634,   53180589,  0x3c1004b},
        {28449000,   54168400,  28571246,   54272300,  0x3c1044b},
        {26006768,   52101400,  26192306,   52166600,  0x3c1044b},
        {30336484,   54466800,  30483516,   54553289,  0x3c1004b},
        {29174468,   52010100,  29314532,   52096589,  0x3c1004b},
        {27464127,   52776400,  27605873,   52862889,  0x3c1004b},
        {28508500,   55483300,  28714640,   55546489,  0x3c1044b},
        {25224825,   53859600,  25370175,   53946089,  0x3c1004b},
        {26780284,   54270800,  26927316,   54357289,  0x3c1004b},
        {28711662,   55447200,  28862538,   55533689,  0x3c1004b},
        {29639600,   52594250,  29859226,   52650000,  0x3c1044b},
        {30319868,   52328000,  30459932,   52414489,  0x3c1004b},
        {29939827,   52847400,  30081573,   52933889,  0x3c1004b},
        {27478166,   52986800,  27621834,   53073289,  0x3c1004b},
        {24279968,   52166800,  24420032,   52253289,  0x3c1004b},
        {31638625,   53664400,  31783975,   53750889,  0x3c1004b},
        {28281315,   54068950,  28386884,   54131049,  0x2b2004b},
        {29981067,   53055740,  30080932,   53115859,  0x29c004b},
        {25273023,   53057650,  25376177,   53119749,  0x2b2004b},
        {24392567,   53125840,  24492432,   53185959,  0x29c004b},
        {29276117,   52095750,  29376683,   52157849,  0x2b2004b},
        {26345398,   54456940,  26447601,   54517059,  0x29c004b},
        {28574823,   53275950,  28677977,   53338049,  0x2b2004b},
        {30924898,   54256140,  31027101,   54316259,  0x29c004b},
        {24903313,   52512550,  25005087,   52574649,  0x2b2004b},
        {25762983,   53567440,  25864017,   53627559,  0x29c004b},
        {26856715,   54469050,  26962284,   54531149,  0x2b2004b},
        {24397535,   52521540,  24496064,   52581659,  0x29c004b},
        {27087819,   53658950,  27192180,   53721049,  0x2b2004b},
        {28099483,   53479940,  28200517,   53540059,  0x29c004b},
        {26785835,   55088950,  26894164,   55151049,  0x2b2004b},
        {26760020,   52220940,  26857380,   52281059,  0x29c004b},
        {30168819,   53492450,  30273180,   53554549,  0x2b2004b},
        {31268520,   52381340,  31365880,   52441459,  0x29c004b},
        {28646125,   54849250,  28753074,   54911349,  0x2b2004b},
        {31893783,   53572140,  31994817,   53632259,  0x29c004b},
        {23179217,   51760000,  28050000,   54178000,  0x0960011},
        {28050000,   51760000,  32794200,   54178000,  0x01c000d},
        {25132800,   54178000,  31478900,   56171740,  0x2be0015},
        {14105000,   48990000,  32794200,   59822030,  0x0010016},
        {23179217,   51262642,  32794200,   56171740,  0x003021c},
        {-58205500,  6777000,   -58065100,  6827100,   0x012000a}, // GUY
        {-58540000,  6589100,   -57784000,  6887700,   0x013000c},
        {-58391270,  5876410,   -58217330,  6049389,   0x782004b},
        {-57610570,  6157010,   -57436630,  6329989,   0x782004b},
        {-57436630,  6157010,   -57262690,  6329989,   0x782004b},
        {-57288470,  5815110,   -57114530,  5988089,   0x782004b},
        {-58608304,  7188720,   -58457297,  7338479,   0x680004b},
        {-58724896,  6315320,   -58574305,  6465079,   0x680004b},
        {-57748296,  6398820,   -57597705,  6548579,   0x680004b},
        {-57702496,  6323820,   -57551905,  6473579,   0x680004b},
        {-57859196,  6485920,   -57708605,  6635679,   0x680004b},
        {-59790000,  2500000,   -57110000,  5100000,   0x001000d},
        {-59350000,  5100000,   -57110000,  8200000,   0x0c60011},
        {-61430000,  5100000,   -59350000,  8400000,   0x4bc0015},
        {-61430000,  1164000,   -56470909,  8560000,   0x0010016},
        {102520000,  17958851,  102610530,  18002100,  0x2a7044a}, // LAO
        {102610530,  17915606,  102653904,  18005800,  0x2a7044a},
        {102372324,  17795636,  102861876,  18286676,  0x001000c},
        {104686297,  16508890,  104813702,  16631199,  0x54f004b},
        {105751768,  15067236,  105878154,  15189545,  0x54f004b},
        {103974938,  20358890,  104105061,  20481199,  0x54f004b},
        {104740878,  17344407,  104868962,  17466716,  0x54f004b},
        {102075108,  19828890,  102204891,  19951199,  0x54f004b},
        {106775070,  14754024,  106901456,  14876333,  0x54f004b},
        {103583125,  18337162,  103711549,  18459471,  0x54f004b},
        {101338960,  20905597,  101469423,  21027906,  0x54f004b},
        {101084429,  21128890,  101215571,  21251199,  0x54f004b},
        {103324353,  19296800,  103415647,  19383289,  0x3c1004b},
        {106365194,  15676800,  106454806,  15763289,  0x3c1004b},
        {102059296,  21653508,  102152271,  21739997,  0x3c1004b},
        {101477583,  19043364,  101568877,  19129853,  0x3c1004b},
        {105849585,  14859575,  105938957,  14946064,  0x3c1004b},
        {104253872,  20756800,  104346127,  20843289,  0x3c1004b},
        {105755194,  15536800,  105844806,  15623289,  0x3c1004b},
        {102388305,  18448661,  102479358,  18535150,  0x3c1004b},
        {105816162,  14069547,  105905053,  14156036,  0x3c1004b},
        {102404628,  18870408,  102495681,  18956897,  0x3c1004b},
        {101603993,  20266800,  101696007,  20353289,  0x3c1004b},
        {106655194,  15366800,  106744806,  15453289,  0x3c1004b},
        {104144697,  18188864,  104235510,  18275353,  0x3c1004b},
        {104954426,  13906000,  107695198,  16587190,  0x001000d},
        {101299893,  17745048,  104100247,  20426238,  0x0a80011},
        {104513031,  16324524,  104997375,  16815564,  0x0b10090},
        {103918363,  20355569,  104413123,  20846609,  0x0b10890},
        {104560149,  17160041,  105049701,  17651081,  0x0b01090},
        {101026941,  20832878,  101526909,  21323918,  0x0b01890},
        {101855801,  21451232,  102355769,  21942272,  0x0b12090},
        {103945329,  17986588,  104434881,  18477628,  0x0b12890},
        {97330000,   5612500,   109500000,  23400000,  0x4720016},
        {100085450,  13906000,  107695198,  22500830,  0x003021c},
        {26040418,   44396755,  26160543,   44483245,  0x001000a}, // ROU
        {25930286,   44317690,  26270714,   44562309,  0xa9e0047},
        {27391632,   47037690,  27748368,   47282309,  0xa9e0047},
        {23423330,   46637690,  23776669,   46882309,  0xa9e0047},
        {21064959,   45640510,  21392240,   45869289,  0x9ee0047},
        {28572000,   44124600,  28665310,   44236100,  0x3c1044b},
        {23754618,   44275900,  23874982,   44362389,  0x3c1004b},
        {27978737,   45396800,  28101263,   45483289,  0x3c1004b},
        {25552237,   45610000,  25674763,   45696489,  0x3c1004b},
        {25969337,   44896800,  26090662,   44983289,  0x3c1004b},
        {27895037,   45234000,  28017563,   45320489,  0x3c1004b},
        {21859035,   47021400,  21985165,   47107889,  0x3c1004b},
        {26857535,   46536800,  26982464,   46623289,  0x3c1004b},
        {21266135,   46139200,  21391064,   46225689,  0x3c1004b},
        {24809337,   44816800,  24930662,   44903289,  0x3c1004b},
        {24077436,   45747100,  24201163,   45833589,  0x3c1004b},
        {24500835,   46510600,  24625764,   46597089,  0x3c1004b},
        {23516334,   47616800,  23643665,   47703289,  0x3c1004b},
        {26758737,   45106800,  26881263,   45193289,  0x3c1004b},
        {22825734,   47746800,  22954266,   47833289,  0x3c1004b},
        {26615557,   47712950,  26707843,   47775049,  0x2b2004b},
        {24325633,   45081040,  24409967,   45141159,  0x29c004b},
        {26195688,   47628150,  26287112,   47690249,  0x2b2004b},
        {26325763,   46903540,  26413437,   46963659,  0x29c004b},
        {22606100,   44610700,  22719219,   44658400,  0x2b2044b},
        {27125398,   45655140,  27211402,   45715259,  0x29c004b},
        {23227444,   45017450,  23314555,   45079549,  0x2b2004b},
        {28752615,   45155940,  28837784,   45216059,  0x29c004b},
        {25407144,   44899750,  25494255,   44961849,  0x2b2004b},
        {21848615,   45283140,  21933784,   45343259,  0x29c004b},
        {24454719,   47108950,  24545280,   47171049,  0x2b2004b},
        {24317667,   44391340,  24401333,   44451459,  0x29c004b},
        {22867582,   45733250,  22956418,   45795349,  0x2b2004b},
        {27675080,   46617440,  27761919,   46677559,  0x29c004b},
        {27282889,   44177750,  27369310,   44239849,  0x2b2004b},
        {25918884,   43869140,  26001715,   43929259,  0x29c004b},
        {26884719,   46898950,  26975280,   46961049,  0x2b2004b},
        {22878398,   45856540,  22964402,   45916659,  0x29c004b},
        {27625950,   46182250,  27715649,   46244349,  0x2b2004b},
        {23526998,   46049940,  23613002,   46110059,  0x29c004b},
        {23014719,   47148950,  23105280,   47211049,  0x2b2004b},
        {25762898,   45846740,  25848902,   45906859,  0x29c004b},
        {23735150,   46538950,  23824849,   46601049,  0x2b2004b},
        {24308098,   46135640,  24394102,   46195759,  0x29c004b},
        {27330389,   44549450,  27416810,   44611549,  0x2b2004b},
        {26740280,   46220240,  26827119,   46280359,  0x29c004b},
        {25270520,   43946250,  25356079,   44008349,  0x2b2004b},
        {23337415,   45379940,  23422584,   45440059,  0x29c004b},
        {21865582,   45658950,  21954418,   45721049,  0x2b2004b},
        {28255867,   44234040,  28339533,   44294159,  0x29c004b},
        {27385682,   45822450,  27474518,   45884549,  0x2b2004b},
        {25766580,   46339940,  25853419,   46400059,  0x29c004b},
        {22735000,   47855574,  23660000,   48121000,  0x0130088},
        {23660000,   47855574,  24700000,   48000000,  0x00d0888},
        {25205000,   47855574,  25900000,   47980000,  0x0011088},
        {25900000,   47855574,  26580000,   48265650,  0x0011888},
        {26580000,   47855574,  27266000,   48265650,  0x0012088},
        {21900000,   47326342,  22536000,   47820000,  0x0202888},
        {22536000,   47326342,  23172000,   47855574,  0x0213088},
        {23172000,   47326342,  23808000,   47855574,  0x0213888},
        {23808000,   47326342,  24444000,   47855574,  0x0214088},
        {24444000,   47326342,  25080000,   47855574,  0x0214888},
        {25080000,   47326342,  25716000,   47855574,  0x0215088},
        {25716000,   47326342,  26352000,   47855574,  0x0215888},
        {26352000,   47326342,  26988000,   47855574,  0x0216088},
        {26988000,   47326342,  27622000,   47855574,  0x0216888},
        {21512000,   46797110,  22176000,   47326342,  0x0207088},
        {22176000,   46797110,  22840000,   47326342,  0x0207888},
        {22840000,   46797110,  23504000,   47326342,  0x0208088},
        {23504000,   46797110,  24168000,   47326342,  0x0208888},
        {24168000,   46797110,  24832000,   47326342,  0x0209088},
        {24832000,   46797110,  25496000,   47326342,  0x0209888},
        {25496000,   46797110,  26160000,   47326342,  0x020a088},
        {26160000,   46797110,  26824000,   47326342,  0x020a888},
        {26824000,   46797110,  27488000,   47326342,  0x020b088},
        {27488000,   46797110,  28147000,   47326342,  0x020b888},
        {21100000,   46267878,  21752000,   46797110,  0x020c088},
        {21752000,   46267878,  22404000,   46797110,  0x020c888},
        {22404000,   46267878,  23056000,   46797110,  0x020d088},
        {23056000,   46267878,  23708000,   46797110,  0x020d888},
        {23708000,   46267878,  24360000,   46797110,  0x020e088},
        {24360000,   46267878,  25012000,   46797110,  0x020e888},
        {25012000,   46267878,  25664000,   46797110,  0x020f088},
        {25664000,   46267878,  26316000,   46797110,  0x020008c},
        {26316000,   46267878,  26968000,   46797110,  0x020088c},
        {26968000,   46267878,  27620000,   46797110,  0x020108c},
        {27620000,   46267878,  28270000,   46797110,  0x020188c},
        {20259000,   45738646,  20866000,   46289000,  0x022208c},
        {20866000,   45738646,  21473000,   46289000,  0x022288c},
        {21473000,   45738646,  22080000,   46267878,  0x021308c},
        {22080000,   45738646,  22687000,   46267878,  0x021388c},
        {22687000,   45738646,  23294000,   46267878,  0x021408c},
        {23294000,   45738646,  23901000,   46267878,  0x021488c},
        {23901000,   45738646,  24508000,   46267878,  0x021508c},
        {24508000,   45738646,  25115000,   46267878,  0x021588c},
        {25115000,   45738646,  25722000,   46267878,  0x021608c},
        {25722000,   45738646,  26329000,   46267878,  0x021688c},
        {26329000,   45738646,  26936000,   46267878,  0x021708c},
        {26936000,   45738646,  27548000,   46267878,  0x021788c},
        {27548000,   45738646,  28162000,   46267878,  0x021808c},
        {20760000,   45209414,  21401000,   45738646,  0x020888c},
        {21401000,   45209414,  22042000,   45738646,  0x020908c},
        {22042000,   45209414,  22683000,   45738646,  0x020988c},
        {22683000,   45209414,  23324000,   45738646,  0x020a08c},
        {23324000,   45209414,  23965000,   45738646,  0x020a88c},
        {23965000,   45209414,  24606000,   45738646,  0x020b08c},
        {24606000,   45209414,  25247000,   45738646,  0x020b88c},
        {25247000,   45209414,  25888000,   45738646,  0x020c08c},
        {25888000,   45209414,  26529000,   45738646,  0x020c88c},
        {26529000,   45209414,  27170000,   45738646,  0x020d08c},
        {27170000,   45209414,  27811000,   45738646,  0x020d88c},
        {27811000,   45209414,  28450000,   45738646,  0x020e08c},
        {28450000,   45209400,  29705000,   45470000,  0x010e88c},
        {21343427,   44770000,  22100000,   45209414,  0x01bf08c},
        {22100000,   44680182,  22734000,   45209414,  0x0ba0090},
        {22734000,   44680182,  23368000,   45209414,  0x0ba0890},
        {23368000,   44680182,  24002000,   45209414,  0x0ba1090},
        {24002000,   44680182,  24636000,   45209414,  0x0ba1890},
        {24636000,   44680182,  25270000,   45209414,  0x0ba2090},
        {25270000,   44680182,  25904000,   45209414,  0x0ba2890},
        {25904000,   44680182,  26538000,   45209414,  0x0ba3090},
        {26538000,   44680182,  27172000,   45209414,  0x0ba3890},
        {27172000,   44680182,  27806000,   45209414,  0x0ba4090},
        {27806000,   44680182,  28440000,   45209414,  0x0ba4890},
        {28440000,   44680182,  29074000,   45209414,  0x0ba5090},
        {29074000,   44680182,  29708000,   45209414,  0x0ba5890},
        {21566329,   44460000,  22450000,   44770000,  0x0786090},
        {22450000,   44150950,  23110000,   44680182,  0x0b66890},
        {23110000,   44150950,  23770000,   44680182,  0x0b67090},
        {23770000,   44150950,  24430000,   44680182,  0x0b67890},
        {24430000,   44150950,  25090000,   44680182,  0x0b68090},
        {25090000,   44150950,  25750000,   44680182,  0x0b68890},
        {25750000,   44150950,  26410000,   44680182,  0x0b69090},
        {26410000,   44150950,  27070000,   44680182,  0x0b69890},
        {27070000,   44150950,  27730000,   44680182,  0x0b6a090},
        {27730000,   44150950,  28390000,   44680182,  0x0b6a890},
        {28390000,   44150950,  29050000,   44680182,  0x0b6b090},
        {22820000,   43770000,  23470000,   44150950,  0x09bb890},
        {23470000,   43660000,  24100000,   44150950,  0x0b2c090},
        {24100000,   43660000,  24730000,   44150950,  0x0b2c890},
        {24730000,   43621718,  25340000,   44150950,  0x0bcd090},
        {25340000,   43621718,  25950000,   44150950,  0x0bcd890},
        {25950000,   43860000,  26930000,   44150950,  0x06ee090},
        {26930000,   43860000,  27930000,   44150950,  0x06de890},
        {27930000,   43730000,  28714000,   44150950,  0x094f090},
        {12090000,   39600000,  30183000,   51061000,  0x0010216},
        {20251650,   43612000,  29705000,   48265650,  0x003021c},
        {-240995,    5526500,   -200000,    5618000,   0x2a7044a}, // GHA
        {-200000,    5542800,   -150136,    5618000,   0x2a7044a},
        {-495600,    5462000,   121000,     5835000,   0x017000c},
        {-1705485,   6689810,   -1618516,   6776299,   0x3c1004b},
        {-1618516,   6689810,   -1531547,   6776299,   0x3c1004b},
        {-1705485,   6603321,   -1618516,   6689810,   0x3c1004b},
        {-1618516,   6603321,   -1531547,   6689810,   0x3c1004b},
        {-884223,    9372191,   -796773,    9458680,   0x3c1004b},
        {-1702000,   6161900,   -1581998,   6224500,   0x3c1044b},
        {-893965,    10746800,  -806035,    10833289,  0x3c1004b},
        {-303485,    6046801,   -230815,    6150220,   0x3c1044b},
        {-1826715,   4870807,   -1739986,   4957296,   0x3c1004b},
        {-2360500,   7314750,   -2252781,   7384750,   0x3c1044b},
        {-1300000,   5098700,   -1197297,   5171600,   0x3c1044b},
        {433240,     6572254,   520209,     6658743,   0x3c1004b},
        {-2550865,   10006100,  -2462935,   10092589,  0x3c1004b},
        {-297385,    11012800,  -181506,    11078500,  0x3c1044b},
        {-806522,    6517907,   -744078,    6580006,   0x2b2004b},
        {-1739582,   4920887,   -1679296,   4981006,   0x29c004b},
        {-41395,     9408951,   21394,      9471050,   0x2b2004b},
        {-726285,    5505250,   -665832,    5565369,   0x29c004b},
        {-1117855,   6765514,   -1055411,   6827613,   0x2b2004b},
        {-661572,    5325011,   -601119,    5385130,   0x29c004b},
        {-1972273,   7550098,   -1909657,   7612197,   0x2b2004b},
        {-2628067,   7420000,   -2560732,   7474000,   0x29c044b},
        {-685496,    5811311,   -623052,    5873410,   0x2b2004b},
        {439691,     7119941,   500311,     7180060,   0x29c004b},
        {1008433,    6045926,   1070877,    6108025,   0x2b2004b},
        {-2030227,   5269941,   -1969774,   5330060,   0x29c004b},
        {-1418800,   7005600,   -1367346,   7081100,   0x2b2044b},
        {-1005500,   5899400,   -928486,    5946500,   0x29c044b},
        {-864300,    5490000,   -810454,    5561841,   0x2b2044b},
        {-478392,    6016774,   -417939,    6076893,   0x29c004b},
        {867000,     5778700,   964196,     5818500,   0x2b2044b},
        {961500,     5818500,   994712,     5927800,   0x29c044b},
        {-398015,    6353878,   -335571,    6415977,   0x2b2004b},
        {-2140310,   7709941,   -2079690,   7770060,   0x29c004b},
        {-861079,    9597722,   -798118,    9659821,   0x2b2004b},
        {-1373200,   5077000,   -1322120,   5147900,   0x29c044b},
        {280800,     6968000,   329985,     7047000,   0x2b2044b},
        {-1820227,   5929941,   -1759774,   5990060,   0x29c004b},
        {-1747000,   8010000,   -1693459,   8082500,   0x2b2044b},
        {-2158000,   5410487,   -2084787,   5460000,   0x29c044b},
        {-787174,    5249344,   -724730,    5311443,   0x2b2004b},
        {-2249162,   4843407,   -2188876,   4903526,   0x29c004b},
        {-1901222,   6788951,   -1838778,   6851050,   0x2b2004b},
        {-152534,    6068344,   -92081,     6128463,   0x29c004b},
        {-1114500,   5177600,   -1033006,   5225000,   0x2b2044b},
        {-1240327,   6600906,   -1179874,   6661025,   0x29c004b},
        {-1680043,   4965040,   -1617772,   5027139,   0x2b2004b},
        {-1297025,   5673454,   -1236572,   5733573,   0x29c004b},
        {-2720000,   6762000,   740000,     8930000,   0x018000d},
        {-2944000,   8930000,   580000,     11173850,  0x3030015},
        {-3014990,   7156300,   -2720000,   7972400,   0x032008c},
        {-3260000,   6709650,   -2720000,   7156300,   0x01b088c},
        {-3260000,   6267000,   -2720000,   6709650,   0x01b108c},
        {-2720567,   6267208,   -2241431,   6763704,   0x01e188c},
        {-2241431,   6267208,   -1762295,   6763704,   0x01e208c},
        {-1762295,   6267208,   -1283159,   6763704,   0x01e288c},
        {-1283159,   6267208,   -804023,    6763704,   0x01e308c},
        {-804024,    6267208,   -324888,    6763704,   0x01e388c},
        {-324888,    6267208,   154248,     6763704,   0x01e408c},
        {154000,     6218000,   597000,     6763704,   0x021488c},
        {597000,     6218000,   1040000,    6763704,   0x021508c},
        {-3139568,   5770712,   -2660432,   6267208,   0x01e588c},
        {-2660432,   5770712,   -2181296,   6267208,   0x01e608c},
        {-2181296,   5770712,   -1702160,   6267208,   0x01e688c},
        {-1702160,   5770712,   -1223024,   6267208,   0x01e708c},
        {-1223024,   5770712,   -743888,    6267208,   0x01e788c},
        {-743888,    5770712,   -264752,    6267208,   0x01e808c},
        {-264752,    5770712,   214386,     6267208,   0x01e888c},
        {214384,     5741000,   693520,     6218000,   0x01e908c},
        {693520,     5758000,   1201100,    6218000,   0x01c988c},
        {-3069568,   5276943,   -2590432,   5773439,   0x01ea08c},
        {-2590432,   5276943,   -2111296,   5773439,   0x01ea88c},
        {-2111296,   5276943,   -1632160,   5773439,   0x01eb08c},
        {-1632160,   5276943,   -1153024,   5773439,   0x01eb88c},
        {-1153024,   5276943,   -673888,    5773439,   0x01ec08c},
        {-673888,    5276943,   -194752,    5773439,   0x01ec88c},
        {-194753,    5276943,   284383,     5773439,   0x01ed08c},
        {-3118000,   4924000,   -2447202,   5276943,   0x016d88c},
        {-2447202,   4736000,   -2020000,   5276943,   0x022e08c},
        {-2020000,   4736000,   -1590000,   5276943,   0x022e88c},
        {-1609000,   5025600,   -734700,    5276943,   0x010f08c},
        {-16860000,  4340000,   4000000,    15120000,  0x2a30216},
        {-3260000,   4727777,   1203850,    11173850,  0x003021c},
        {32536755,   276755,    32623245,   363245,    0x001000a}, // UGA
        {32345640,   35196,     32814360,   526236,    0x001000c},
        {32236755,   2736800,   32323244,   2823289,   0x3c1004b},
        {32846755,   2216800,   32933244,   2303289,   0x3c1004b},
        {33136829,   411300,    33243388,   481470,    0x3c1044b},
        {34126755,   1046800,   34213244,   1133289,   0x3c1004b},
        {30606755,   -643200,   30693244,   -556711,   0x3c1004b},
        {31686755,   -373200,   31773244,   -286711,   0x3c1004b},
        {30000000,   150800,    30126269,   210000,    0x3c1044b},
        {33137555,   591700,    33224044,   678189,    0x3c1004b},
        {30871355,   2986700,   30957844,   3073189,   0x3c1004b},
        {29936755,   -1293200,  30023244,   -1206711,  0x3c1004b},
        {32826635,   3256800,   32913364,   3343289,   0x3c1004b},
        {34168455,   680700,    34254944,   767189,    0x3c1004b},
        {33556755,   1666800,   33643244,   1753289,   0x3c1004b},
        {30226755,   626800,    30313244,   713289,    0x3c1004b},
        {33456055,   576300,    33542544,   662789,    0x3c1004b},
        {34071055,   414900,    34157544,   501389,    0x3c1004b},
        {32006755,   356800,    32093244,   443289,    0x3c1004b},
        {31311355,   1403200,   31397844,   1489689,   0x3c1004b},
        {32898950,   348950,    32961049,   411049,    0x2b2004b},
        {30933657,   3373640,   30993943,   3433759,   0x29c004b},
        {31684650,   1653250,   31746749,   1715349,   0x2b2004b},
        {30943940,   2404740,   31004059,   2464859,   0x29c004b},
        {33694150,   1148750,   33756249,   1210849,   0x2b2004b},
        {32468740,   815240,    32528859,   875359,    0x29c004b},
        {31058050,   2469750,   31120149,   2531849,   0x2b2004b},
        {30469940,   -150060,   30530059,   -89941,    0x29c004b},
        {30135250,   -573650,   30197349,   -511551,   0x2b2004b},
        {33130440,   1730940,   33190559,   1791059,   0x29c004b},
        {32507250,   552150,    32569349,   614249,    0x2b2004b},
        {31750657,   3368940,   31810943,   3429059,   0x29c004b},
        {32876550,   663050,    32938649,   725149,    0x2b2004b},
        {32493940,   712140,    32554059,   772259,    0x29c004b},
        {29608950,   -906550,   29671049,   -844451,   0x2b2004b},
        {31450640,   2443040,   31510759,   2503159,   0x29c004b},
        {30484150,   629650,    30546249,   691749,    0x2b2004b},
        {31366740,   534140,    31426859,   594259,    0x29c004b},
        {30366850,   -608250,   30428949,   -546151,   0x2b2004b},
        {30604240,   578340,    30664359,   638459,    0x29c004b},
        {31208864,   3428950,   31271135,   3491049,   0x2b2004b},
        {31823240,   -168260,   31883359,   -108141,   0x29c004b},
        {30028350,   678250,    30090449,   740349,    0x2b2004b},
        {30424040,   160240,    30484159,   220359,    0x29c004b},
        {34078950,   2978950,   34141049,   3041049,   0x2b2004b},
        {30131840,   253340,    30191959,   313459,    0x29c004b},
        {30730000,   1940000,   34290000,   3750000,   0x016000d},
        {31450000,   -428657,   34380000,   1940000,   0x0970011},
        {29573567,   -1481288,  31450000,   1940000,   0x5110015},
        {29573567,   -1481290,  35036050,   4231640,   0x0010016},
        {-196868,    51459457,  -58484,     51545947,  0x001000a}, // GBR
        {-518400,    51282900,  338400,     51692000,  0x01a000c},
        {-4346519,   55826800,  -4193481,   55913289,  0x3c1004b},
        {-2184373,   52548000,  -2042627,   52634489,  0x3c1004b},
        {-2042627,   52504755,  -1900881,   52591244,  0x3c1004b},
        {-1900881,   52504755,  -1759135,   52591244,  0x3c1004b},
        {-2184373,   52461511,  -2042627,   52548000,  0x3c1004b},
        {-2041786,   52418266,  -1901722,   52504755,  0x3c1004b},
        {-1901722,   52418266,  -1761658,   52504755,  0x3c1004b},
        {-3004934,   53378200,  -2861266,   53464689,  0x3c1004b},
        {-3295319,   55904200,  -3142281,   55990689,  0x3c1004b},
        {-1541234,   53344200,  -1397566,   53430689,  0x3c1004b},
        {-1623275,   53762600,  -1477925,   53849089,  0x3c1004b},
        {-2631112,   51416700,  -2492489,   51503189,  0x3c1004b},
        {-2321834,   53436800,  -2178166,   53523289,  0x3c1004b},
        {-1200873,   52596800,  -1059127,   52683289,  0x3c1004b},
        {-432875,    53716900,  -287525,    53803389,  0x3c1004b},
        {-1570032,   52376800,  -1429968,   52463289,  0x3c1004b},
        {-1833275,   53756400,  -1687925,   53842889,  0x3c1004b},
        {-3251212,   51447700,  -3112589,   51534189,  0x3c1004b},
        {-1246673,   52926700,  -1104927,   53013189,  0x3c1004b},
        {-2261834,   52966800,  -2118166,   53053289,  0x3c1004b},
        {-5999377,   54556300,  -5850423,   54642789,  0x3c1004b},
        {-1556273,   52874300,  -1414527,   52960789,  0x3c1004b},
        {-1055912,   51407200,  -917289,    51493689,  0x3c1004b},
        {-4205145,   50360950,  -4107856,   50423049,  0x2b2004b},
        {-1451395,   50894900,  -1345091,   50948659,  0x29c044b},
        {-2179007,   57117550,  -2066193,   57179649,  0x2b2004b},
        {-1649970,   54944640,  -1546431,   55004759,  0x29c004b},
        {-2764281,   53739150,  -2659920,   53801249,  0x2b2004b},
        {-472479,    51867140,  -376121,    51927259,  0x29c004b},
        {-1460175,   54877450,  -1353226,   54939549,  0x2b2004b},
        {-1135294,   50778840,  -1041107,   50838959,  0x29c004b},
        {1236213,    52608150,  1337987,    52670249,  0x2b2004b},
        {-3994779,   51604240,  -3898421,   51664359,  0x29c004b},
        {-1932907,   50715540,  -1811648,   50765249,  0x2b2044b},
        {-2027094,   50706773,  -1932907,   50766892,  0x29c004b},
        {631100,     51529000,  770300,     51573300,  0x2b2044b},
        {-1829366,   51543000,  -1730123,   51601300,  0x29c044b},
        {-3058557,   56451000,  -2916013,   56499359,  0x2b2044b},
        {-3058300,   53776000,  -2986155,   53860000,  0x29c044b},
        {-5074521,   55920616,  -4246449,   56411656,  0x0010088},
        {-4246449,   55920616,  -3418377,   56411656,  0x0010888},
        {-3418377,   55920616,  -2590305,   56411656,  0x0011088},
        {-4887345,   55429576,  -4069689,   55920616,  0x0011888},
        {-4874065,   54938536,  -4066825,   55429576,  0x0012088},
        {-4670193,   52747068,  -3904617,   53238108,  0x0012888},
        {-3904617,   52747068,  -3139041,   53238108,  0x0013088},
        {-3139041,   52747068,  -2373465,   53238108,  0x0013888},
        {-4664985,   52256028,  -3909825,   52747068,  0x0014088},
        {-3909825,   52256028,  -3154665,   52747068,  0x0014888},
        {-3154665,   52256028,  -2399505,   52747068,  0x0015088},
        {-5405042,   51764988,  -4655090,   52256028,  0x0015888},
        {-4655090,   51764988,  -3905138,   52256028,  0x0016088},
        {-3905138,   51764988,  -3155186,   52256028,  0x001e888},
        {-3155186,   51764988,  -2405234,   52256028,  0x0016888},
        {-5330000,   51520000,  -3875140,   51764988,  0x00f7088},
        {-3875140,   51273948,  -3135604,   51764988,  0x0017888},
        {-3135603,   51273948,  -2396067,   51764988,  0x0018088},
        {-4602072,   50782908,  -3867744,   51273948,  0x0018888},
        {-3867744,   50782908,  -3133416,   51273948,  0x0019088},
        {-3133416,   50782908,  -2399088,   51273948,  0x0019888},
        {-4787789,   50291868,  -4063877,   50782908,  0x001a088},
        {-3575000,   50511000,  -2400000,   50782908,  0x012a888},
        {-4063878,   50199000,  -3478000,   50782908,  0x025b088},
        {-6229980,   54390390,  -5433156,   54881430,  0x001b888},
        {-7445782,   54862408,  -6638542,   55353448,  0x001c088},
        {-6638542,   54862408,  -5831302,   55353448,  0x001c888},
        {-3710000,   56411000,  -2420000,   56715400,  0x013d088},
        {-3419148,   56715420,  -2570244,   57206460,  0x001d888},
        {-2570000,   56715400,  -1944000,   57309000,  0x027e088},
        {-5288000,   49954500,  -4764000,   50604296,  0x029f088},
        {-2400270,   50556764,  1800261,    53237954,  0x0a80011},
        {-4073034,   53237954,  365825,     55919144,  0x0010015},
        {-10700000,  49122422,  1889648,    60875000,  0x0010016},
        {-8650000,   49122422,  1889648,    60875000,  0x003021c},
        {-13722274,  9500222,   -13661320,  9541500,   0x22a044a}, // GIN
        {-13685400,  9541500,   -13610759,  9575200,   0x22a044a},
        {-13667200,  9575200,   -13607250,  9617200,   0x22a044a},
        {-13721360,  9494480,   -13247432,  9985520,   0x001000c},
        {-8869277,   7701965,   -8737146,   7816000,   0x54f044b},
        {-12928174,  9995890,   -12803827,  10118199,  0x54f004b},
        {-9352674,   10343890,  -9214693,   10454000,  0x54f044b},
        {-10193834,  8500890,   -10070166,  8623199,   0x54f004b},
        {-14618074,  10606890,  -14493727,  10729199,  0x54f004b},
        {-10161834,  9123890,   -10038166,  9246199,   0x54f004b},
        {-12352744,  11262090,  -12228057,  11384399,  0x54f004b},
        {-9213644,   11339990,  -9088957,   11462299,  0x54f004b},
        {-9066160,   9208413,   -8942492,   9330722,   0x54f004b},
        {-13647974,  10337490,  -13523627,  10459799,  0x54f004b},
        {-13874844,  11042990,  -13750157,  11165299,  0x54f004b},
        {-12359944,  12015490,  -12235257,  12137799,  0x54f004b},
        {-8757674,   10562290,  -8633327,   10684599,  0x54f004b},
        {-10804174,  9979490,   -10679827,  10101799,  0x54f004b},
        {-8590316,   7740710,   -8466988,   7863019,   0x54f004b},
        {-10759385,  11249700,  -10671215,  11336189,  0x3c1004b},
        {-14748791,  9038147,   -12037810,  11719337,  0x0a80011},
        {-11080000,  7180000,   -8398810,   9861190,   0x001000d},
        {-12037810,  9840605,   -8173041,   11719337,  0x2a20015},
        {-16860000,  4340000,   4000000,    15120000,  0x2a30016},
        {-15082785,  7180000,   -7637570,   12690000,  0x003021c},
        {-79950000,  -2242100,  -79873500,  -2147241,  0x022000a}, // ECU
        {-80091651,  -2338831,  -79745692,  -1992872,  0xf040047},
        {-78644847,  -382320,   -78309958,  -47431,    0xe890047},
        {-79045700,  -2926600,  -78935991,  -2858477,  0x3c1044b},
        {-79212245,  -299100,   -79125756,  -212611,   0x3c1004b},
        {-80003365,  -3303200,  -79891547,  -3236200,  0x3c1044b},
        {-80763245,  -1003200,  -80646066,  -939480,   0x3c1044b},
        {-80507545,  -1097300,  -80421056,  -1010811,  0x3c1004b},
        {-78668945,  -1306800,  -78582456,  -1220311,  0x3c1004b},
        {-78699445,  -1698500,  -78612956,  -1612011,  0x3c1004b},
        {-79505445,  -1056500,  -79418956,  -970011,   0x3c1004b},
        {-79243696,  -4039230,  -79172851,  -3933570,  0x3c1044b},
        {-79635445,  -2177700,  -79548956,  -2091211,  0x3c1004b},
        {-78161945,  311600,    -78075456,  398089,    0x3c1004b},
        {-79709845,  905600,    -79623356,  992089,    0x3c1004b},
        {-79574045,  -1851400,  -79487556,  -1764911,  0x3c1004b},
        {-80954250,  -2263850,  -80892151,  -2201751,  0x2b2004b},
        {-78651560,  -963060,   -78591441,  -902941,   0x29c004b},
        {-77844750,  -1026050,  -77782651,  -963951,   0x2b2004b},
        {-79839543,  -3359460,  -79779257,  -3299341,  0x29c004b},
        {-80129250,  -726850,   -80067151,  -664751,   0x2b2004b},
        {-79990143,  -3480060,  -79929857,  -3419941,  0x29c004b},
        {-80259436,  -3507950,  -80197165,  -3445851,  0x2b2004b},
        {-80059860,  -1354260,  -79999741,  -1294141,  0x29c004b},
        {-79663250,  -1087950,  -79601151,  -1025851,  0x2b2004b},
        {-80610060,  -1380060,  -80549941,  -1319941,  0x29c004b},
        {-80010950,  -1880950,  -79948851,  -1818851,  0x2b2004b},
        {-79030460,  -1615860,  -78970341,  -1555741,  0x29c004b},
        {-79935250,  -1396050,  -79873151,  -1333951,  0x2b2004b},
        {-78882760,  -2778260,  -78822641,  -2718141,  0x29c004b},
        {-81013450,  -2244750,  -80951351,  -2182651,  0x2b2004b},
        {-79500460,  295240,    -79440341,  355359,    0x29c004b},
        {-80893850,  -2257450,  -80831751,  -2195351,  0x2b2004b},
        {-79374860,  -2454460,  -79314741,  -2394341,  0x29c004b},
        {-78290150,  199650,    -78228051,  261749,    0x2b2004b},
        {-79491860,  -2198760,  -79431741,  -2138641,  0x29c004b},
        {-79782650,  -1594350,  -79720551,  -1532251,  0x2b2004b},
        {-80443260,  -639660,   -80383141,  -579541,   0x29c004b},
        {-78191050,  18950,     -78128951,  81049,     0x2b2004b},
        {-80420060,  -2660060,  -80359941,  -2599941,  0x29c004b},
        {-79651050,  -2701050,  -79588951,  -2638951,  0x2b2004b},
        {-78032760,  -1523960,  -77972641,  -1463841,  0x29c004b},
        {-76927450,  52250,     -76865351,  114349,    0x2b2004b},
        {-78150060,  -2340060,  -78089941,  -2279941,  0x29c004b},
        {-79063850,  -1727250,  -79001751,  -1665151,  0x2b2004b},
        {-80261660,  -1850660,  -80201541,  -1790541,  0x29c004b},
        {-80010750,  -1661050,  -79948651,  -1598951,  0x2b2004b},
        {-79724860,  -2125460,  -79664741,  -2065341,  0x29c004b},
        {-78263750,  289350,    -78201651,  351449,    0x2b2004b},
        {-79387843,  -4018860,  -79327557,  -3958741,  0x29c004b},
        {-78601050,  -541050,   -78538951,  -478951,   0x2b2004b},
        {-78866160,  1242240,   -78806041,  1302359,   0x29c004b},
        {-81007645,  -4615816,  -78326455,  -1934626,  0x001000d},
        {-80917000,  -1934626,  -77950000,  440000,    0x0960011},
        {-79900960,  580520,    -79432240,  1071560,   0x0b00090},
        {-78048055,  -1240520,  -77579335,  -749480,   0x0b00890},
        {-77130755,  -162221,   -76662035,  328819,    0x0b01890},
        {-81687615,  -679951,   -79512872,  1494792,   0x0a80891},
        {-79512872,  -679951,   -77338129,  1494792,   0x0a81091},
        {-77343743,  -679951,   -75169000,  1494792,   0x0a81891},
        {-81687615,  -2854693,  -79512872,  -679950,   0x0a82091},
        {-79512872,  -2854693,  -77338129,  -679950,   0x0a82891},
        {-77343743,  -2854693,  -75169000,  -679950,   0x0a83091},
        {-81687615,  -5018000,  -79512872,  -2843257,  0x0a83891},
        {-79512872,  -5018000,  -77338129,  -2843257,  0x0a84091},
        {-91775398,  -1621587,  -89213372,  940439,    0x0a87091},
        {-92040000,  940439,    -89213372,  1685000,   0x0567891},
        {-92040000,  -5018000,  -75169000,  1685000,   0x0010217},
        {-7700000,   33541151,  -7577000,   33610298,  0x019000a}, // ESH
        {-6902394,   33931500,  -6798607,   34017989,  0x3c1004b},
        {-6984294,   33892100,  -6880507,   33978589,  0x3c1004b},
        {-6858094,   34001700,  -6754307,   34088189,  0x3c1004b},
        {-5051894,   33986900,  -4948107,   34073389,  0x3c1004b},
        {-8084038,   31566000,  -8017152,   31697000,  0x3c1044b},
        {-8017152,   31566000,  -7950266,   31697000,  0x3c1044b},
        {-9610451,   30359100,  -9510749,   30445589,  0x3c1004b},
        {-9551451,   30304900,  -9451749,   30391389,  0x3c1004b},
        {-5895750,   35725500,  -5771711,   35799600,  0x3c1044b},
        {-5603294,   33844200,  -5477691,   33915600,  0x3c1044b},
        {-1960494,   34637800,  -1855506,   34724289,  0x3c1004b},
        {-6656370,   34226800,  -6511734,   34289200,  0x3c1044b},
        {-9283833,   32242500,  -9181968,   32328989,  0x3c1004b},
        {-5423800,   35552400,  -5291581,   35621500,  0x3c1044b},
        {-6965293,   32836600,  -6862708,   32923089,  0x3c1004b},
        {-6431333,   32281800,  -6329468,   32368289,  0x3c1004b},
        {-8553701,   33203050,  -8479700,   33265149,  0x2b2004b},
        {-3010100,   35139940,  -2911211,   35184500,  0x29c044b},
        {-7657128,   32969750,  -7583472,   33031849,  0x2b2004b},
        {-5929389,   34967140,  -5856411,   35027259,  0x29c004b},
        {-6110060,   33796450,  -6035541,   33858549,  0x2b2004b},
        {-6169940,   35143340,  -6096461,   35203459,  0x29c004b},
        {-10087848,  28958750,  -10016952,  29020849,  0x2b2004b},
        {-4040622,   34199440,  -3967978,   34259559,  0x29c004b},
        {-6743770,   32462650,  -6670631,   32524749,  0x2b2004b},
        {-5703154,   32914440,  -5631846,   32974559,  0x29c004b},
        {-4468797,   31899350,  -4396003,   31961449,  0x2b2004b},
        {-2362889,   34894940,  -2289911,   34955059,  0x29c004b},
        {-6611228,   32830450,  -6537572,   32892549,  0x2b2004b},
        {-5971422,   34230540,  -5898778,   34290659,  0x29c004b},
        {-2932518,   34377550,  -2857482,   34439649,  0x2b2004b},
        {-5756222,   34186940,  -5683578,   34247059,  0x29c004b},
        {-8916666,   30438250,  -8844735,   30500349,  0x2b2004b},
        {-2213222,   34290740,  -2140578,   34350859,  0x29c004b},
        {-7984470,   32202150,  -7911331,   32264249,  0x2b2004b},
        {-8554404,   32206840,  -8483597,   32266959,  0x29c004b},
        {-7423670,   32018250,  -7350531,   32080349,  0x2b2004b},
        {-3972240,   35200640,  -3898761,   35260759,  0x29c004b},
        {-5616391,   34759050,  -5541010,   34821149,  0x2b2004b},
        {-9773885,   29674440,  -9704915,   29734559,  0x29c004b},
        {-6360760,   33861650,  -6286241,   33923749,  0x2b2004b},
        {-9241752,   30367240,  -9172448,   30427359,  0x29c004b},
        {-11135276,  28398950,  -11064725,  28461049,  0x2b2004b},
        {-13221250,  27106940,  -13153950,  27167059,  0x29c004b},
        {-15970296,  23677250,  -15902505,  23739349,  0x2b2004b},
        {-11706383,  26712740,  -11639417,  26772859,  0x29c004b},
        {-14550000,  25700000,  -11000000,  27670000,  0x018000d},
        {-16011084,  23470080,  -15505908,  23961120,  0x001f08c},
        {-14550212,  25964994,  -11600903,  28646184,  0x0a94091},
        {-11600903,  25964994,  -8651594,   28646184,  0x0a94891},
        {-17764661,  23283804,  -14874934,  25964994,  0x0a95091},
        {-14874934,  23283804,  -11985207,  25964994,  0x0a95891},
        {-17764661,  20727860,  -14904725,  23283804,  0x0a46091},
        {-14904725,  20727860,  -12044789,  23283804,  0x0a46891},
        {-17764661,  20727860,  -995000,    35930000,  0x0010217},
        {-17764661,  20727860,  -8651594,   27670000,  0x003021c},
        {9408500,    409894,    9494719,    453139,    0x2a7044a}, // GAB
        {9428100,    366649,    9514319,    409894,    0x2a7044a},
        {9304000,    282200,    9907000,    669400,    0x018000c},
        {8728400,    -831900,   8823619,    -674900,   0x54f044b},
        {13520945,   -1688310,  13643254,   -1566001,  0x54f004b},
        {13168845,   -1603610,  13291154,   -1481301,  0x54f004b},
        {11519755,   1555500,   11606244,   1641989,   0x3c1004b},
        {12803455,   517700,    12889944,   604189,    0x3c1004b},
        {11033155,   -1923800,  11119644,   -1837311,  0x3c1004b},
        {10204055,   -724800,   10290544,   -638311,   0x3c1004b},
        {10946255,   -2982500,  11032744,   -2896011,  0x3c1004b},
        {12396055,   -1195100,  12482544,   -1108611,  0x3c1004b},
        {11453055,   2060500,   11539544,   2146989,   0x3c1004b},
        {9977855,    -2779300,  10064344,   -2692811,  0x3c1004b},
        {13115255,   -1434500,  13201744,   -1348011,  0x3c1004b},
        {12686255,   -849000,   12772744,   -762511,   0x3c1004b},
        {13630155,   -702100,   13716644,   -615611,   0x3c1004b},
        {10106155,   -2845500,  10192644,   -2759011,  0x3c1004b},
        {11304155,   -2446300,  11390644,   -2359811,  0x3c1004b},
        {11889955,   -119300,   11976444,   -32811,    0x3c1004b},
        {10575355,   -1279400,  10661844,   -1192911,  0x3c1004b},
        {10726555,   -207600,   10813044,   -121111,   0x3c1004b},
        {9748158,    -2585167,  9834647,    -2498678,  0x3c1004b},
        {10638535,   -3461800,  10725264,   -3375311,  0x3c1004b},
        {11865355,   -1938100,  11951844,   -1851611,  0x3c1004b},
        {11492855,   763200,    11579344,   849689,    0x3c1004b},
        {13893755,   948700,    13980244,   1035189,   0x3c1004b},
        {14211955,   -1630500,  14298444,   -1544011,  0x3c1004b},
        {11599355,   -1681400,  11685844,   -1594911,  0x3c1004b},
        {12124455,   -2197300,  12210944,   -2110811,  0x3c1004b},
        {9549274,    927660,    9635763,    1014149,   0x3c1004b},
        {11059405,   -361970,   13740595,   2319220,   0x0a80011},
        {11060000,   -2476000,  14529296,   -360000,   0x018000d},
        {8697000,    -3075000,  11060000,   595,       0x4480015},
        {8697000,    -3958680,  14529296,   2319220,   0x0010016},
        {174706184,  -36923545, 174813816,  -36837055, 0x001000a}, // NZL
        {174473560,  -37095520, 175051648,  -36604480, 0x001000c},
        {172507599,  -43527400, 172625801,  -43440911, 0x3c1004b},
        {172625801,  -43527400, 172744003,  -43440911, 0x3c1004b},
        {172495297,  -43613889, 172614460,  -43527400, 0x3c1004b},
        {172614460,  -43590000, 172778883,  -43527400, 0x3c1044b},
        {174715000,  -41348300, 174836498,  -41267000, 0x3c1044b},
        {174757000,  -41267000, 174840656,  -41149000, 0x3c1044b},
        {174822000,  -41149000, 174955517,  -41075000, 0x3c1044b},
        {174874721,  -41249900, 174989079,  -41163411, 0x3c1004b},
        {174970000,  -41164300, 175113037,  -41095220, 0x3c1044b},
        {175209217,  -37840510, 175285943,  -37718201, 0x3c1044b},
        {175285943,  -37840510, 175362669,  -37718201, 0x3c1044b},
        {170418136,  -45923200, 170541863,  -45836711, 0x3c1004b},
        {176111004,  -37742800, 176219596,  -37656311, 0x3c1004b},
        {175553662,  -40393200, 175666338,  -40306711, 0x3c1004b},
        {176794542,  -39689800, 176906257,  -39603311, 0x3c1004b},
        {173189621,  -41340500, 173303979,  -41254011, 0x3c1004b},
        {176818342,  -39550800, 176930057,  -39464311, 0x3c1004b},
        {176192944,  -38177600, 176302256,  -38091111, 0x3c1004b},
        {174290992,  -35751550, 174402405,  -35669000, 0x3c1044b},
        {174021000,  -39092600, 174149204,  -39017800, 0x3c1044b},
        {168330450,  -46445950, 168467339,  -46367100, 0x3c1044b},
        {174969462,  -39969200, 175082138,  -39882711, 0x3c1004b},
        {174969681,  -40936200, 175083318,  -40849711, 0x3c1004b},
        {177981312,  -38686450, 178060488,  -38624351, 0x2b2004b},
        {173913420,  -41550260, 173993579,  -41490141, 0x29c004b},
        {171187500,  -44420000, 171262774,  -44348800, 0x2b2044b},
        {176044974,  -38724160, 176121626,  -38664041, 0x29c004b},
        {174861374,  -37236250, 174938825,  -37174151, 0x2b2004b},
        {175610254,  -40980060, 175689745,  -40919941, 0x29c004b},
        {175239204,  -40651050, 175320795,  -40588951, 0x2b2004b},
        {176945208,  -37990560, 177021192,  -37930441, 0x29c004b},
        {171702220,  -43932350, 171787779,  -43870251, 0x2b2004b},
        {175435908,  -37928460, 175511892,  -37868341, 0x29c004b},
        {175825557,  -38258150, 175904043,  -38196051, 0x2b2004b},
        {175531439,  -40252660, 175609761,  -40192541, 0x29c004b},
        {175289557,  -38050250, 175368043,  -37988151, 0x2b2004b},
        {170915633,  -45116560, 170999967,  -45056441, 0x29c004b},
        {172529365,  -43333450, 172614234,  -43271351, 0x2b2004b},
        {174241173,  -39610060, 174318827,  -39549941, 0x29c004b},
        {173691704,  -39411595, 177028296,  -36730405, 0x0a80011},
        {173652379,  -42092785, 177108135,  -39411595, 0x001000d},
        {172322012,  -43688120, 172962596,  -43197080, 0x0b00890},
        {174609328,  -41457120, 175229080,  -40966080, 0x0b01090},
        {175071352,  -38100020, 175659856,  -37608980, 0x0b01890},
        {170169596,  -45941120, 170831012,  -45450080, 0x0b12090},
        {175797952,  -37842920, 176386456,  -37351880, 0x0b02890},
        {175228536,  -40659120, 175837872,  -40168080, 0x0b03090},
        {176499536,  -39822520, 177103664,  -39331480, 0x0b03890},
        {172941728,  -41542520, 173561480,  -41051480, 0x0b04090},
        {175744952,  -38419520, 176333456,  -37928480, 0x0b14890},
        {174038360,  -36053420, 174611240,  -35562380, 0x0b05090},
        {173790144,  -39447820, 174389064,  -38956780, 0x0b15890},
        {167970188,  -46628120, 168636812,  -46137080, 0x0b16090},
        {174753436,  -40181620, 175357564,  -39690580, 0x0b06890},
        {174825328,  -41134220, 175439872,  -40643180, 0x0b07090},
        {177763944,  -38789220, 178357656,  -38298180, 0x0b17890},
        {173546228,  -41645420, 174165980,  -41154380, 0x0b08090},
        {170789304,  -44522420, 171435096,  -44031380, 0x0b08890},
        {175786144,  -38939520, 176379856,  -38448480, 0x0b19090},
        {175341728,  -41195520, 175956272,  -40704480, 0x0b09890},
        {176603852,  -38327120, 177192356,  -37836080, 0x0b1a090},
        {171495404,  -44022120, 172141196,  -43531080, 0x0b0a890},
        {170566396,  -45310720, 171222604,  -44819680, 0x0b0b090},
        {172600000,  -36730405, 175969585,  -34370000, 0x09b5091},
        {177028296,  -39411595, 180364888,  -36730405, 0x0a85891},
        {171129678,  -42092785, 174585434,  -39411595, 0x0a86091},
        {166923188,  -44773975, 170527899,  -42092785, 0x0a86891},
        {170527899,  -44773975, 174132610,  -42092785, 0x0a87091},
        {163690507,  -47455165, 167444173,  -44773975, 0x0a87891},
        {167444173,  -47455165, 171197839,  -44773975, 0x0a88891},
        {173691704,  -39411595, 177028296,  -36730405, 0x0a89091},
        {173652379,  -42092785, 177108135,  -39411595, 0x0a89891},
        {177756637,  -50333695, 179782425,  -48993100, 0x0a8a091},
        {182853029,  -44947803, 184700071,  -43607208, 0x0a8a891},
        {165697550,  -48579152, 167425428,  -47417303, 0x0a7b891},
        {165050949,  -51461337, 167106528,  -50120742, 0x0a9e091},
        {178071823,  -48406038, 180008238,  -47065443, 0x0a9e891},
        {168097751,  -53210883, 170242703,  -51870288, 0x0a8f091},
        {171364030,  -35340595, 172942953,  -34000000, 0x0aa4891},
        {160000000,  -60000000, 185000000,  -34000000, 0x0010217},
        {-1574206,   12319755,  -1485794,   12406245,  0x001000a}, // BFA
        {-1689141,   12207318,  -1335494,   12553277,  0xf040047},
        {-4475060,   11012600,  -4133660,   11347489,  0xe890047},
        {-2414206,   12206800,  -2325795,   12293289,  0x3c1004b},
        {-2464446,   13526800,  -2375555,   13613289,  0x3c1004b},
        {-4794965,   10601300,  -4707035,   10687789,  0x3c1004b},
        {-3500906,   12426700,  -3412495,   12513189,  0x3c1004b},
        {-1120726,   13035000,  -1032075,   13121489,  0x3c1004b},
        {-412385,    11737600,  -324215,    11824089,  0x3c1004b},
        {322315,     12017000,  410485,     12103489,  0x3c1004b},
        {-68146,     13989700,  20745,      14076189,  0x3c1004b},
        {-2518706,   12274200,  -2430295,   12360689,  0x3c1004b},
        {-3568385,   11439600,  -3480215,   11526089,  0x3c1004b},
        {-1674446,   14056800,  -1585555,   14143289,  0x3c1004b},
        {-2117285,   11063900,  -2029115,   11150389,  0x3c1004b},
        {-1205485,   11130000,  -1117315,   11216489,  0x3c1004b},
        {-1568646,   13300000,  -1479755,   13386489,  0x3c1004b},
        {-2301126,   12917500,  -2212475,   13003989,  0x3c1004b},
        {-399006,    12137600,  -310595,    12224089,  0x3c1004b},
        {-670506,    12207800,  -582095,    12294289,  0x3c1004b},
        {-1384085,   12026800,  -1295915,   12113289,  0x3c1004b},
        {-4947765,   10939200,  -4859835,   11025689,  0x3c1004b},
        {-3447226,   13055050,  -3383575,   13117149,  0x2b2004b},
        {-3099411,   13041240,  -3037789,   13101359,  0x29c004b},
        {-3895426,   12704550,  -3831775,   12766649,  0x2b2004b},
        {-1100644,   11629940,  -1039356,   11690059,  0x29c004b},
        {-2961653,   11718950,  -2898347,   11781049,  0x2b2004b},
        {-600811,    12629940,  -539189,    12690059,  0x29c004b},
        {-3274067,   10931750,  -3210933,   10993849,  0x2b2004b},
        {-5192561,   10629040,  -5131440,   10689159,  0x29c004b},
        {-2385512,   13176650,  -2321688,   13238749,  0x2b2004b},
        {-5341244,   11049040,  -5279956,   11109159,  0x29c004b},
        {-178726,    12946450,  -115075,    13008549,  0x2b2004b},
        {-580644,    11769940,  -519356,    11830059,  0x29c004b},
        {-3491567,   10108950,  -3428433,   10171049,  0x2b2004b},
        {-3550561,   10259940,  -3489440,   10320059,  0x29c004b},
        {-3201912,   13468950,  -3138088,   13531049,  0x2b2004b},
        {-2210644,   11619940,  -2149356,   11680059,  0x29c004b},
        {-3204567,   10302750,  -3141433,   10364849,  0x2b2004b},
        {-170895,    13369940,  -109106,    13430059,  0x29c004b},
        {-3291653,   11508950,  -3228347,   11571049,  0x2b2004b},
        {-3920644,   11609940,  -3859356,   11670059,  0x29c004b},
        {-3091653,   11118950,  -3028347,   11181049,  0x2b2004b},
        {-260978,    14409940,  -199022,    14470059,  0x29c004b},
        {1758347,    12048950,  1821653,    12111049,  0x2b2004b},
        {-724844,    11212440,  -663556,    11272559,  0x29c004b},
        {-3328340,   10937662,  -617359,    13618852,  0x0a90011},
        {-5521000,   10103000,  -3328340,   13186000,  0x025000d},
        {-617360,    10937662,  2093621,    13618852,  0x0010015},
        {-16860000,  4340000,   4000000,    15120000,  0x2a30016},
        {-5521000,   9380000,   2410000,    15088140,  0x003021c},
        {120956694,  14555155,  121045106,  14641645,  0x001000a}, // PHL
        {120795432,  14295480,  121274568,  14786520,  0x001000c},
        {125515000,  7024500,   125598307,  7115000,   0x3c1044b},
        {125598307,  7044000,   125665007,  7157000,   0x3c1044b},
        {123812035,  10250900,  123899965,  10337389,  0x3c1004b},
        {123899965,  10288090,  123987895,  10374579,  0x3c1004b},
        {124605375,  8430500,   124692825,  8516989,   0x3c1004b},
        {122922035,  10624400,  123009965,  10710889,  0x3c1004b},
        {122510535,  10677900,  122598465,  10764389,  0x3c1004b},
        {120545914,  15112300,  120635286,  15198789,  0x3c1004b},
        {120538754,  16377600,  120628846,  16464089,  0x3c1004b},
        {121356234,  14224300,  121445365,  14310789,  0x3c1004b},
        {120640014,  14986400,  120729386,  15072889,  0x3c1004b},
        {121558454,  13895100,  121647345,  13981589,  0x3c1004b},
        {125122715,  6076000,   125209684,  6162489,   0x3c1004b},
        {120234614,  14789300,  120323986,  14875789,  0x3c1004b},
        {124957115,  11174700,  125045285,  11261189,  0x3c1004b},
        {123619435,  10332700,  123707365,  10419189,  0x3c1004b},
        {124195895,  7161400,   124283104,  7247889,   0x3c1004b},
        {122036095,  6890300,   122123304,  6976789,   0x3c1004b},
        {124527615,  12055000,  124615785,  12141489,  0x3c1004b},
        {123138954,  13591100,  123227845,  13677589,  0x3c1004b},
        {124233095,  7956200,   124320304,  8042689,   0x3c1004b},
        {121286888,  14032450,  121350712,  14094549,  0x2b2004b},
        {120937855,  15461140,  121000145,  15521259,  0x29c004b},
        {120317743,  15998950,  120382257,  16061049,  0x2b2004b},
        {122717656,  11548140,  122778944,  11608259,  0x29c004b},
        {120592915,  14929150,  120657084,  14991249,  0x2b2004b},
        {125491506,  8922340,   125552293,  8982459,   0x29c004b},
        {121516557,  16669650,  121581243,  16731749,  0x2b2004b},
        {125777090,  7417440,   125837710,  7477559,   0x29c004b},
        {123254805,  9286650,   123317594,  9348749,   0x2b2004b},
        {120743138,  15127540,  120805261,  15187659,  0x29c004b},
        {125323978,  6718150,   125386422,  6780249,   0x2b2004b},
        {121259022,  14466540,  121320978,  14526659,  0x29c004b},
        {121687684,  17587750,  121752715,  17649849,  0x2b2004b},
        {126312090,  8167340,   126372710,  8227459,   0x29c004b},
        {123972333,  10499150,  124035467,  10561249,  0x2b2004b},
        {118724323,  9721340,   118785277,  9781459,   0x29c004b},
        {123360588,  13398250,  123424412,  13460349,  0x2b2004b},
        {120867938,  14927840,  120930061,  14987959,  0x29c004b},
        {120973678,  6017750,   121036122,  6079849,   0x2b2004b},
        {123704605,  13123640,  123766394,  13183759,  0x29c004b},
        {119664614,  13594539,  122405386,  16275729,  0x0a90011},
        {121859405,  9029405,   124570386,  11710595,  0x001000d},
        {125463840,  6999480,   125932560,  7490520,   0x0b10090},
        {124435640,  8204480,   124904360,  8695520,   0x0b10890},
        {120251432,  16197179,  120735776,  16688219,  0x0b11090},
        {124815640,  6054480,   125284360,  6545520,   0x0b11890},
        {124788240,  11044480,  125262168,  11535520,  0x0b12090},
        {124148140,  7022580,   124616860,  7513620,   0x0b12890},
        {121866940,  6889080,   122335660,  7380120,   0x0b13090},
        {124505040,  11706680,  124978968,  12197720,  0x0b13890},
        {123043032,  13243080,  123522168,  13734120,  0x0b14090},
        {124019840,  7773779,   124488560,  8264819,   0x0b14890},
        {125225340,  8669880,   125699268,  9160920,   0x0b05090},
        {121123032,  16364480,  121607376,  16855520,  0x0b15890},
        {121475224,  17374480,  121964776,  17865520,  0x0b06090},
        {125995440,  7978680,   126464160,  8469720,   0x0b16890},
        {118488240,  9494480,   118962168,  9985520,   0x0b07090},
        {120825440,  5748980,   121294160,  6240020,   0x0b17890},
        {123640432,  12829480,  124119568,  13320520,  0x0b08090},
        {123157340,  8296580,   123626060,  8787620,   0x0b18890},
        {123399140,  7779580,   123867860,  8270620,   0x0b19090},
        {125036140,  6535380,   125504860,  7026420,   0x0b19890},
        {125344040,  9555780,   125817968,  10046820,  0x0b0a090},
        {120240224,  17334480,  120729776,  17825520,  0x0b0a890},
        {125985640,  6714480,   126454360,  7205520,   0x0b1b090},
        {122615932,  13900080,  123095068,  14391120,  0x0b1b890},
        {120463424,  17842380,  120952976,  18333420,  0x0b1c090},
        {116866000,  4599000,   126607050,  21143000,  0x4c90016},
        {116866000,  4380000,   128000000,  21143000,  0x0d40012},
        {116866000,  4380000,   128000000,  21143000,  0x0010217},
        {12433114,   41851944,  12548434,   41938434,  0x001000a}, // ITA
        {8986829,    45365330,  9393170,    45652159,  0xc730047},
        {12317720,   41753290,  12682279,   42026709,  0xbde0047},
        {14090379,   40789890,  14449621,   41063309,  0xbde0047},
        {7617137,    45025700,  7738462,    45112189,  0x3c1004b},
        {13305344,   38081100,  13414656,   38167589,  0x3c1004b},
        {11161000,   43749800,  11323811,   43813000,  0x3c1044b},
        {11269000,   44456800,  11405521,   44533000,  0x3c1044b},
        {8839718,    44383000,  9022081,    44440000,  0x3c1044b},
        {15025704,   37465400,  15134296,   37551889,  0x3c1004b},
        {16747300,   41080000,  16909377,   41141000,  0x3c1044b},
        {12301837,   45338700,  12384966,   45466000,  0x3c1044b},
        {10928737,   45396000,  11080078,   45465989,  0x3c1044b},
        {15500000,   38130000,  15576211,   38254000,  0x3c1044b},
        {13745537,   45589500,  13868063,   45675989,  0x3c1004b},
        {11809037,   45362200,  11931563,   45448689,  0x3c1004b},
        {10158737,   45498200,  10281263,   45584689,  0x3c1004b},
        {10859337,   44606800,  10980662,   44693289,  0x3c1004b},
        {11030418,   43835500,  11159625,   43915200,  0x3c1044b},
        {9086000,    39185400,  9201730,    39268200,  0x3c1044b},
        {15629800,   38014300,  15689176,   38173500,  0x3c1044b},
        {10281100,   44766000,  10374397,   44823949,  0x2b2044b},
        {12316718,   43068440,  12398881,   43128559,  0x29c004b},
        {10297700,   43512000,  10358953,   43598000,  0x2b2044b},
        {15509920,   41427340,  15590079,   41487459,  0x29c004b},
        {14496604,   40724650,  14578195,   40786749,  0x2b2004b},
        {10580533,   44679940,  10664867,   44740059,  0x29c004b},
        {12166789,   44388950,  12253210,   44451049,  0x2b2004b},
        {17215705,   40437540,  17294695,   40497659,  0x29c004b},
        {11566444,   44808950,  11653555,   44871049,  0x2b2004b},
        {12528584,   44029940,  12611415,   44090059,  0x29c004b},
        {15225674,   37048250,  15303125,   37110349,  0x2b2004b},
        {14168386,   42436940,  14249213,   42497059,  0x29c004b},
        {8519204,    40698950,  8600795,    40761049,  0x2b2004b},
        {12855620,   41434040,  12935779,   41494159,  0x29c004b},
        {9623882,    45664050,  9712718,    45726149,  0x2b2004b},
        {12011267,   44190840,  12094933,   44250959,  0x29c004b},
        {11501613,   45518850,  11589587,   45580949,  0x2b2004b},
        {12599952,   42536940,  12681447,   42597059,  0x29c004b},
        {8576013,    45418950,  8663987,    45481049,  0x2b2004b},
        {13190298,   46038140,  13276302,   46098259,  0x29c004b},
        {11292550,   46458150,  11382249,   46520249,  0x2b2004b},
        {11824118,   43434540,  11906281,   43494659,  0x29c004b},
        {16552153,   38873950,  16631847,   38936049,  0x2b2004b},
        {16256454,   41197640,  16335945,   41257759,  0x29c004b},
        {11087800,   46032500,  11139299,   46139500,  0x2b2044b},
        {13480400,   43554500,  13545375,   43631049,  0x29c044b},
        {9631833,    45023000,  9766793,    45063000,  0x2b2044b},
        {17910000,   40611000,  18023637,   40652700,  0x29c044b},
        {7273396,    44761580,  7929604,    45252620,  0x0010088},
        {12947152,   37732780,  13535656,   38223820,  0x0010888},
        {14733252,   37204480,  15316548,   37695520,  0x0011088},
        {16417628,   40768980,  17032172,   41260020,  0x0011888},
        {15146152,   37918180,  15734656,   38409220,  0x0012088},
        {13272396,   45568680,  13933812,   46059720,  0x0012888},
        {17064628,   40374080,  17679172,   40865120,  0x0013088},
        {8840944,    38973080,  9439864,    39464120,  0x0013888},
        {12486204,   43652480,  13131996,   44143520,  0x0014088},
        {14775452,   36720780,  15358748,   37211820,  0x0014888},
        {8126228,    40483080,  8740772,    40974120,  0x0015088},
        {10733488,   45878680,  11400112,   46369720,  0x0015888},
        {8119996,    45164680,  8781412,    45655720,  0x0016088},
        {13128712,   43279680,  13769296,   43770720,  0x0016888},
        {10911480,   46339480,  11588520,   46830520,  0x0017088},
        {16095643,   38874480,  16694563,   39365520,  0x0017888},
        {17675136,   40244480,  18284472,   40735520,  0x0018088},
        {15770328,   41184480,  16390080,   41675520,  0x0018888},
        {8201488,    45641480,  8868112,    46132520,  0x0019088},
        {7991896,    44679480,  8648104,    45170520,  0x0019888},
        {12406052,   37591980,  12994556,   38083020,  0x001a088},
        {13928452,   37044480,  14511748,   37535520,  0x001a888},
        {10501712,   42640680,  11137088,   43131720,  0x001b088},
        {15512336,   40301680,  16121672,   40792720,  0x001b888},
        {11574020,   41981280,  12204188,   42472320,  0x001c088},
        {7922204,    43864480,  8567996,    44355520,  0x001c888},
        {14273352,   36709480,  14856648,   37200520,  0x001d088},
        {16478836,   40342780,  17088172,   40833820,  0x001d888},
        {13418352,   37089480,  14001648,   37580520,  0x001e088},
        {7219704,    44144480,  7870704,    44635520,  0x001e888},
        {16688944,   38921480,  17287864,   39412520,  0x001f088},
        {12147410,   40513464,  15662748,   43194654,  0x0a80011},
        {8822749,    43227805,  12487042,   45908995,  0x0010015},
        {7600000,    38835000,  11000000,   41316000,  0x001008d},
        {6500000,    43700000,  9750000,    46514000,  0x021088d},
        {9750000,    44780000,  13930000,   47100000,  0x01b108d},
        {9750000,    42200000,  13400000,   44780000,  0x01e188d},
        {13400000,   42050000,  15850000,   43635000,  0x001208d},
        {11700000,   39950000,  15400000,   42200000,  0x01b308d},
        {15400000,   39250000,  18560000,   42050000,  0x021388d},
        {11700000,   35450000,  14100000,   38835000,  0x028408d},
        {14100000,   36600000,  17330000,   39250000,  0x001488d},
        {5850000,    35450000,  18560000,   55080000,  0x50a0216},
        {6500000,    35450000,  18560000,   47100000,  0x003021c},
        {58513246,   23559300,  58615000,   23637420,  0x01c000a}, // OMN
        {57921000,   23400000,  58700000,   23715800,  0x014000c},
        {53958727,   16962790,  54086472,   17085099,  0x54f004b},
        {54085327,   16994990,  54213072,   17117299,  0x54f004b},
        {56652770,   24301890,  56786630,   24424199,  0x54f004b},
        {56434979,   23165890,  56567820,   23288199,  0x54f004b},
        {57298140,   23775690,  57431660,   23897999,  0x54f004b},
        {57423340,   23735990,  57556860,   23858299,  0x54f004b},
        {56827571,   24135800,  56922228,   24222289,  0x3c1004b},
        {57508000,   22831400,  57564451,   22974900,  0x3c1044b},
        {57401832,   23378900,  57468887,   23500000,  0x3c1044b},
        {57833591,   23629800,  57928008,   23716289,  0x3c1004b},
        {59459792,   22522900,  59553008,   22609389,  0x3c1004b},
        {55751771,   24223200,  55846428,   24309689,  0x3c1004b},
        {57253152,   22926800,  57346848,   23013289,  0x3c1004b},
        {56399931,   24688400,  56495069,   24774889,  0x3c1004b},
        {58073392,   22526800,  58166608,   22613289,  0x3c1004b},
        {57050891,   23937000,  57145308,   24023489,  0x3c1004b},
        {57553091,   23726000,  57647508,   23812489,  0x3c1004b},
        {57915132,   23249700,  58009068,   23336189,  0x3c1004b},
        {58849232,   23194900,  58943168,   23281389,  0x3c1004b},
        {58485552,   22668800,  58579248,   22755289,  0x3c1004b},
        {56199571,   26126900,  56295429,   26213389,  0x3c1004b},
        {56478132,   23533500,  56572068,   23619989,  0x3c1004b},
        {57244452,   23053600,  57338148,   23140089,  0x3c1004b},
        {57779632,   23363400,  57873568,   23449889,  0x3c1004b},
        {57478232,   23267700,  57572168,   23354189,  0x3c1004b},
        {56200000,   22450000,  59218000,   24985000,  0x0a00011},
        {52169914,   16639605,  54940477,   19320795,  0x001000d},
        {59259025,   22320624,  59764201,   22811664,  0x0b00090},
        {55747961,   24168192,  56258345,   24659232,  0x0b10890},
        {56056779,   25924580,  56572371,   26415620,  0x0b11090},
        {56132000,   25540000,  56649709,   25924580,  0x09c1890},
        {56200000,   25200000,  56700000,   25350000,  0x0632090},
        {51904148,   16639560,  59840000,   26525000,  0x0010016},
        {20950808,   52216755,  21090153,   52303245,  0x001000a}, // POL
        {18568920,   50083300,  19503000,   50463450,  0x018000c},
        {20879968,   52260000,  21020032,   52346489,  0x3c1004b},
        {21020032,   52260000,  21160096,   52346489,  0x3c1004b},
        {20879968,   52173511,  21020032,   52260000,  0x3c1004b},
        {21020032,   52173511,  21160096,   52260000,  0x3c1004b},
        {20950000,   52087022,  21090064,   52173511,  0x3c1004b},
        {19390688,   51726800,  19529311,   51813289,  0x3c1004b},
        {19887771,   50012300,  20021829,   50098789,  0x3c1004b},
        {16957529,   51062800,  17094470,   51149289,  0x3c1004b},
        {16844068,   52362100,  16984132,   52448589,  0x3c1004b},
        {18554184,   54324700,  18701216,   54411189,  0x3c1004b},
        {14458166,   53386800,  14601834,   53473289,  0x3c1004b},
        {17915000,   53094000,  18090811,   53164600,  0x3c1044b},
        {22488429,   51197300,  22625370,   51283789,  0x3c1004b},
        {23079366,   53092300,  23223034,   53178789,  0x3c1004b},
        {18421884,   54479500,  18568916,   54565989,  0x3c1004b},
        {19056450,   50767000,  19191950,   50853489,  0x3c1004b},
        {21083729,   51357800,  21220670,   51444289,  0x3c1004b},
        {20557650,   50834200,  20693150,   50920689,  0x3c1004b},
        {18541066,   52983000,  18710448,   53056300,  0x3c1044b},
        {18972591,   49776200,  19105208,   49862689,  0x3c1004b},
        {20404325,   53726400,  20549675,   53812889,  0x3c1004b},
        {21956473,   50004850,  22052727,   50066949,  0x2b2004b},
        {18507007,   50061140,  18600192,   50121259,  0x29c004b},
        {16231255,   50762150,  16328544,   50824249,  0x2b2004b},
        {17898906,   50641440,  17993093,   50701559,  0x29c004b},
        {19663113,   52512450,  19764887,   52574549,  0x2b2004b},
        {19358598,   54138040,  19460801,   54198159,  0x29c004b},
        {15188113,   52710450,  15289887,   52772549,  0x2b2004b},
        {19024435,   52629740,  19122964,   52689859,  0x29c004b},
        {20924073,   49977650,  21020327,   50039749,  0x2b2004b},
        {15441120,   51912840,  15538480,   51972959,  0x29c004b},
        {18047534,   51733150,  18147065,   51795249,  0x2b2004b},
        {16135498,   54161740,  16237701,   54221859,  0x29c004b},
        {16129538,   51170950,  16227862,   51233049,  0x2b2004b},
        {18720867,   53453940,  18820732,   53514059,  0x29c004b},
        {16971515,   54432950,  17077084,   54495049,  0x2b2004b},
        {18543207,   49924340,  18636392,   49984459,  0x29c004b},
        {15690838,   50872150,  15789162,   50934249,  0x2b2004b},
        {20656008,   49588740,  20748191,   49648859,  0x29c004b},
        {20763850,   52131100,  20855234,   52199350,  0x2b2044b},
        {19642800,   51379240,  19747679,   51433750,  0x29c044b},
        {16164748,   50137417,  16888660,   50628457,  0x001008c},
        {16888660,   50137417,  17612572,   50628457,  0x001088c},
        {17612572,   50137417,  18336484,   50628457,  0x001108c},
        {18336484,   50137417,  19060396,   50628457,  0x001188c},
        {19060396,   50137417,  19784308,   50628457,  0x001208c},
        {19784308,   50137417,  20508220,   50628457,  0x001288c},
        {20508220,   50137417,  21232132,   50628457,  0x001308c},
        {21232132,   50137417,  21956044,   50628457,  0x001388c},
        {21956044,   50137417,  22679956,   50628457,  0x001408c},
        {22679956,   50137417,  23403868,   50628457,  0x001488c},
        {23403868,   50137417,  24127780,   50628457,  0x001508c},
        {17612572,   49646377,  18331276,   50137417,  0x001588c},
        {18331276,   49646377,  19049980,   50137417,  0x001608c},
        {19049980,   49646377,  19768684,   50137417,  0x001688c},
        {19768684,   49646377,  20487388,   50137417,  0x001708c},
        {20487388,   49646377,  21206092,   50137417,  0x001788c},
        {21206092,   49646377,  21924796,   50137417,  0x001808c},
        {21924796,   49646377,  22643500,   50137417,  0x001888c},
        {22643500,   49646377,  23362204,   50137417,  0x001908c},
        {18803641,   49155337,  19511929,   49646377,  0x001988c},
        {19511929,   49155337,  20220217,   49646377,  0x001a08c},
        {20220217,   49155337,  20928505,   49646377,  0x001a88c},
        {20928505,   49155337,  21636793,   49646377,  0x001b08c},
        {21636793,   49155337,  22345081,   49646377,  0x001b88c},
        {22345081,   49155337,  23053369,   49646377,  0x001c08c},
        {20577624,   52004480,  21332784,   52495520,  0x001c88c},
        {19085024,   51524480,  19834976,   52015520,  0x001d08c},
        {18170892,   54199680,  18967716,   54690720,  0x001d88c},
        {14392208,   53139480,  15168200,   53630520,  0x001e08c},
        {18943059,   53922580,  19729467,   54413620,  0x001e88c},
        {15792000,   53944480,  16578408,   54435520,  0x001f08c},
        {15180081,   50625524,  19380612,   53306714,  0x001000d},
        {19380612,   50625524,  23581143,   53306714,  0x0010015},
        {14105000,   48990000,  32794200,   59822030,  0x0010016},
        {14105000,   48990000,  24150000,   54850000,  0x003021c},
        {-4073245,   5286756,   -3986755,   5373246,   0x001000a}, // CIV
        {-4430560,   5191700,   -3718950,   5513000,   0x014000c},
        {-5091564,   7632591,   -5029946,   7754900,   0x3c1044b},
        {-5029946,   7632591,   -4968328,   7754900,   0x3c1044b},
        {-6492905,   6833522,   -6405696,   6920011,   0x3c1004b},
        {-5307785,   6766522,   -5220816,   6853011,   0x3c1004b},
        {-5673325,   9415722,   -5585875,   9502211,   0x3c1004b},
        {-6696665,   4716322,   -6609936,   4802811,   0x3c1004b},
        {-5402885,   5789022,   -5315916,   5875511,   0x3c1004b},
        {-7595905,   7364722,   -7508696,   7451211,   0x3c1004b},
        {-5993985,   6088122,   -5907016,   6174611,   0x3c1004b},
        {-3540785,   6685922,   -3453816,   6772411,   0x3c1004b},
        {-5775408,   6959672,   -5712792,   7021771,   0x2b2004b},
        {-4752821,   6621308,   -4692368,   6681427,   0x29c004b},
        {-4237982,   5898971,   -4175538,   5961070,   0x2b2004b},
        {-5941527,   6591262,   -5881074,   6651381,   0x29c004b},
        {-8182008,   7226572,   -8119392,   7288671,   0x2b2004b},
        {-2831910,   8010362,   -2771290,   8070481,   0x29c004b},
        {-5235727,   9563235,   -5172766,   9625334,   0x2b2004b},
        {-5126573,   8114133,   -5065953,   8174252,   0x29c004b},
        {-6613722,   6462272,   -6551278,   6524371,   0x2b2004b},
        {-5435827,   6337962,   -5375374,   6398081,   0x29c004b},
        {-7593981,   9472872,   -7531020,   9534971,   0x2b2004b},
        {-5043327,   6536645,   -4982874,   6596764,   0x29c004b},
        {-3893922,   6074472,   -3831478,   6136571,   0x2b2004b},
        {-6629701,   5749920,   -6569248,   5810039,   0x29c004b},
        {-7384622,   6708972,   -7322178,   6771071,   0x2b2004b},
        {-6705610,   7928862,   -6644990,   7988981,   0x29c004b},
        {-3233878,   7105847,   -3171262,   7167946,   0x2b2004b},
        {-4003675,   7029521,   -3943055,   7089640,   0x29c004b},
        {-3238122,   5437372,   -3175678,   5499471,   0x2b2004b},
        {-4855887,   5866610,   -4795434,   5926729,   0x29c004b},
        {-3913655,   6363751,   -3851211,   6425850,   0x2b2004b},
        {-5716051,   5828268,   -5655598,   5888387,   0x29c004b},
        {-6435067,   10452250,  -6371933,   10514349,  0x2b2004b},
        {-7528936,   6497478,   -7468483,   6557597,   0x29c004b},
        {-6513281,   9492572,   -6450320,   9554671,   0x2b2004b},
        {-3634532,   5235753,   -3574246,   5295872,   0x29c004b},
        {-4001922,   6642772,   -3939478,   6704871,   0x2b2004b},
        {-6082010,   7397862,   -6021390,   7457981,   0x29c004b},
        {-6508508,   7350672,   -6445892,   7412771,   0x2b2004b},
        {-3982027,   6289462,   -3921574,   6349581,   0x29c004b},
        {-4229422,   6626872,   -4166978,   6688971,   0x2b2004b},
        {-5332672,   6159890,   -5272219,   6220009,   0x29c004b},
        {-4401620,   6440108,   -4339176,   6502207,   0x2b2004b},
        {-7702006,   8247847,   -7641386,   8307966,   0x29c004b},
        {-5971222,   6288951,   -5908778,   6351050,   0x2b2004b},
        {-3030394,   9239941,   -2969607,   9300060,   0x29c004b},
        {-6120856,   4924434,   -6058585,   4986533,   0x2b2004b},
        {-4774814,   5819963,   -4714361,   5880082,   0x29c004b},
        {-7651308,   7708951,   -7588692,   7771050,   0x2b2004b},
        {-3198995,   7774648,   -3138375,   7834767,   0x29c004b},
        {-5255094,   7127785,   -5192478,   7189884,   0x2b2004b},
        {-7390075,   4394680,   -7329789,   4454799,   0x29c004b},
        {-5534432,   5659050,   -2853242,   8340240,   0x0a90011},
        {-8215622,   5659050,   -5534432,   8340240,   0x001000d},
        {-7610000,   4340000,   -2717000,   5659050,   0x1f30015},
        {-16860000,  4340000,   4000000,    15120000,  0x2a30016},
        {-8606667,   4340000,   -2488056,   10750000,  0x003021c},
        {10664471,   59881944,  10835529,   59968434,  0x001000a}, // NOR
        {10291696,   59551720,  11208304,   60042760,  0x001000c},
        {10294000,   63395000,  10546525,   63460000,  0x3c1044b},
        {10294000,   63320000,  10512908,   63395000,  0x3c1044b},
        {5203590,    60330500,  5378010,    60416989,  0x3c1004b},
        {5204911,    60244011,  5376688,    60330500,  0x3c1004b},
        {5604554,    58925800,  5771046,    59012289,  0x3c1004b},
        {5604554,    58839311,  5771046,    58925800,  0x3c1004b},
        {5604554,    58752822,  5771046,    58839311,  0x3c1004b},
        {10866454,   59174800,  11032946,   59261289,  0x3c1004b},
        {10104132,   59706900,  10273267,   59793389,  0x3c1004b},
        {7913756,    58098100,  8075443,    58184589,  0x3c1004b},
        {18842394,   69622800,  19086006,   69709289,  0x3c1004b},
        {10356054,   59232700,  10522546,   59319189,  0x3c1004b},
        {6101063,    62433400,  6287736,    62519889,  0x3c1004b},
        {6287736,    62433400,  6474409,    62519889,  0x3c1004b},
        {5235332,    59370500,  5404467,    59456989,  0x3c1004b},
        {10120854,   59098900,  10287346,   59185389,  0x3c1004b},
        {10575432,   59394000,  10744567,   59480489,  0x3c1004b},
        {14300985,   67246800,  14523215,   67333289,  0x3c1004b},
        {8682455,    58416900,  8846544,    58503389,  0x3c1004b},
        {10996790,   60755900,  11171210,   60842389,  0x3c1004b},
        {9964254,    59011500,  10130746,   59097989,  0x3c1004b},
        {11320754,   59084000,  11487246,   59170489,  0x3c1004b},
        {10373648,   61077100,  10550951,   61163589,  0x3c1004b},
        {7046460,    62730000,  7314524,    62761000,  0x2b2044b},
        {14091536,   66297840,  14239664,   66357959,  0x29c004b},
        {10378880,   59378950,  10500319,   59441049,  0x2b2004b},
        {9592516,    59631940,  9710083,    59692059,  0x29c004b},
        {10590183,   60758250,  10715417,   60820349,  0x2b2004b},
        {7694252,    63076040,  7826348,    63136159,  0x29c004b},
        {17326410,   68391550,  17493389,   68453649,  0x2b2004b},
        {10177898,   60143140,  10297302,   60203259,  0x29c004b},
        {11501848,   60853750,  11629152,   60915849,  0x2b2004b},
        {23210744,   69930840,  23384256,   69990959,  0x29c004b},
        {11108332,   60128350,  11231668,   60190449,  0x2b2004b},
        {11439130,   63986340,  11576069,   64046459,  0x29c004b},
        {11926532,   60160650,  12049868,   60222749,  0x2b2004b},
        {7902970,    58229940,  8017030,    58290059,  0x29c004b},
        {5422180,    59746150,  5543619,    59808249,  0x2b2004b},
        {7403905,    58008440,  7516295,    58068559,  0x29c004b},
        {9986694,    63112632,  11012670,   63603672,  0x001008c},
        {10797058,   63603672,  11843866,   64094712,  0x001088c},
        {6942123,    62934236,  7968099,    63425276,  0x001108c},
        {7968099,    62934236,  8994075,    63425276,  0x001188c},
        {8994075,    62934236,  10020051,   63425276,  0x001208c},
        {5921355,    62443196,  6931707,    62934236,  0x001288c},
        {6931707,    62443196,  7942059,    62934236,  0x001308c},
        {7942059,    62443196,  8952411,    62934236,  0x001388c},
        {4921419,    61952156,  5910939,    62443196,  0x001408c},
        {5910939,    61952156,  6900459,    62443196,  0x001488c},
        {6900459,    61952156,  7889979,    62443196,  0x001508c},
        {6002600,    62124020,  6992120,    62615060,  0x001588c},
        {5026100,    61485668,  5999996,    61976708,  0x001608c},
        {5999996,    61485668,  6973892,    61976708,  0x001688c},
        {4933918,    60994628,  5892190,    61485668,  0x001708c},
        {5892190,    60994628,  6850462,    61485668,  0x001788c},
        {6850462,    60994628,  7808734,    61485668,  0x001808c},
        {4944334,    60503588,  5886982,    60994628,  0x001888c},
        {5886982,    60503588,  6829630,    60994628,  0x001908c},
        {6829630,    60503588,  7772278,    60994628,  0x001988c},
        {7724128,    58874335,  12877971,   61555525,  0x0010015},
        {4716295,    57949905,  9721183,    60631095,  0x001000d},
        {-9154000,   68600000,  33625000,   80843100,  0x0970012},
        {4490000,    54544000,  31600000,   68600000,  0x3770016},
        {-9154000,   57950000,  31180000,   80843100,  0x003021c},
        {101659426,  3107727,   101745916,  3194217,   0x001000a}, // MYS
        {101369240,  2806580,   101837960,  3297620,   0x001000c},
        {103623355,  1465800,   103709844,  1552289,   0x3c1044b},
        {103709844,  1452826,   103796333,  1539315,   0x3c1044b},
        {103757855,  1531100,   103847944,  1614000,   0x3c1044b},
        {103876055,  1432000,   103957684,  1523600,   0x3c1044b},
        {101029135,  4536600,   101140412,  4604000,   0x3c1044b},
        {101043500,  4604000,   101160553,  4668000,   0x3c1044b},
        {110291045,  1488390,   110352154,  1610699,   0x3c1044b},
        {110352154,  1488390,   110413263,  1610699,   0x3c1044b},
        {116040115,  5906300,   116127084,  5992789,   0x3c1044b},
        {118028800,  5828300,   118133598,  5900000,   0x3c1044b},
        {101918155,  2671200,   102004644,  2757689,   0x3c1044b},
        {103272000,  3777100,   103361617,  3860770,   0x3c1044b},
        {103096115,  5255000,   103185528,  5339000,   0x3c1044b},
        {102227915,  6084400,   102314884,  6170889,   0x3c1044b},
        {117836300,  4238300,   117951548,  4303289,   0x3c1044b},
        {100690000,  4800000,   100753896,  4917200,   0x3c1044b},
        {100331700,  6080000,   100402379,  6186300,   0x3c1044b},
        {100270000,  5382000,   100347195,  5479340,   0x3c1044b},
        {100254500,  5271000,   100322193,  5382000,   0x3c1044b},
        {100454915,  5605300,   100541884,  5691789,   0x3c1044b},
        {113967135,  4342900,   114026067,  4470000,   0x3c1044b},
        {111815220,  2236100,   111875519,  2360000,   0x3c1044b},
        {100411615,  5289200,   100498584,  5375689,   0x3c1044b},
        {102216055,  2176400,   102302544,  2262889,   0x3c1044b},
        {103270055,  1991000,   103368334,  2067000,   0x3c1044b},
        {102920000,  1800000,   103010179,  1882889,   0x3c1044b},
        {100525000,  5352100,   100601290,  5450589,   0x3c1044b},
        {113030300,  3135910,   113123989,  3215689,   0x3c1044b},
        {102535155,  2009700,   102621644,  2096189,   0x3c1044b},
        {100363000,  5340000,   100429154,  5453530,   0x3c1044b},
        {101789200,  2520000,   101847969,  2585554,   0x2b2044b},
        {101549857,  3289940,   101610143,  3350059,   0x29c044b},
        {101280800,  1329000,   103970000,  4001000,   0x0a80011},
        {100171000,  4001000,   103260000,  6262000,   0x01a000d},
        {110117795,  1304024,   110586515,  1795064,   0x0b00890},
        {115839065,  5675844,   116307785,  6166884,   0x0b11090},
        {117846835,  5618630,   118315555,  6109670,   0x0b11890},
        {117629785,  4025274,   118098505,  4516314,   0x0b02090},
        {113746985,  4160929,   114215705,  4651969,   0x0b02890},
        {111596385,  2052530,   112065105,  2543570,   0x0b03090},
        {112820055,  2930279,   113288775,  3421319,   0x0b03890},
        {118105645,  4784479,   118574365,  5275519,   0x0b04090},
        {115005635,  5044479,   115474355,  5535519,   0x0b04890},
        {103243384,  3981687,   103712104,  4472727,   0x0b05090},
        {103243384,  4472727,   103712104,  4963767,   0x0b05890},
        {103243384,  4963767,   103712104,  5454807,   0x0b06090},
        {100358624,  3534024,   100827344,  4025064,   0x0b06890},
        {100827343,  3534024,   101296063,  4025064,   0x0b07090},
        {101050000,  2880000,   101340000,  3534023,   0x1037890},
        {99620000,   6094367,   100088720,  6585407,   0x0b18090},
        {100100060,  6251500,   100568780,  6742540,   0x0b18890},
        {100568780,  6251500,   101037500,  6742540,   0x0b19090},
        {103939066,  1828136,   104407786,  2319176,   0x0b09890},
        {103939066,  1337096,   104407786,  1828136,   0x0b0a090},
        {99620000,   845000,    119276000,  7525000,   0x2230016},
        {106639255,  10731355,  106726706,  10817845,  0x001000a}, // VNM
        {106561937,  10667020,  106913662,  11012979,  0xf040047},
        {105667792,  20908100,  106025007,  21242989,  0xe890047},
        {108095174,  16059400,  108185026,  16145889,  0x3c1004b},
        {108185026,  16059400,  108274878,  16145889,  0x3c1004b},
        {108113144,  15972911,  108202996,  16059400,  0x3c1004b},
        {108202996,  15972911,  108292848,  16059400,  0x3c1004b},
        {106635872,  20812800,  106760671,  20876630,  0x3c1044b},
        {107548354,  16422500,  107638446,  16508989,  0x3c1004b},
        {109171894,  12193000,  109237581,  12309289,  0x3c1044b},
        {105706435,  10001500,  105794365,  10087989,  0x3c1004b},
        {105061400,  9940000,   105137136,  10040000,  0x3c1044b},
        {107055035,  10328600,  107142965,  10415089,  0x3c1004b},
        {105386035,  10346800,  105473965,  10433289,  0x3c1004b},
        {107184400,  20976500,  107368521,  21020000,  0x3c1044b},
        {108066335,  10911600,  108154265,  10998089,  0x3c1004b},
        {106990300,  20935700,  107131899,  20992000,  0x3c1044b},
        {109113015,  11883600,  109201185,  11970089,  0x3c1004b},
        {105805112,  21520000,  105898087,  21606489,  0x3c1004b},
        {108395915,  11913700,  108505738,  11983000,  0x3c1044b},
        {109187288,  13738350,  109251112,  13800449,  0x2b2004b},
        {106136920,  20399140,  106200880,  20459259,  0x29c004b},
        {108008174,  12648950,  108071825,  12711049,  0x2b2004b},
        {106333439,  10341340,  106430794,  10379000,  0x29c044b},
        {105944419,  9571950,   106007380,  9634049,   0x2b2004b},
        {107980805,  13948240,  108042594,  14008359,  0x29c004b},
        {105742053,  19779650,  105807947,  19841749,  0x2b2004b},
        {105119606,  9149940,   105180393,  9210059,   0x29c004b},
        {105697005,  9265250,   105759794,  9327349,   0x2b2004b},
        {105935600,  10209400,  106004773,  10262459,  0x29c044b},
        {105322000,  20764500,  105360111,  20872400,  0x2b2044b},
        {105650054,  18648840,  105713346,  18708959,  0x29c004b},
        {108984447,  11540650,  109047753,  11602749,  0x2b2004b},
        {104842000,  21689200,  104928687,  21734000,  0x29c044b},
        {105359500,  21297470,  105443261,  21346760,  0x2b2044b},
        {109281489,  13058840,  109343111,  13118959,  0x29c004b},
        {105573008,  21280750,  105639592,  21342849,  0x2b2004b},
        {105073839,  10667840,  105134960,  10727959,  0x29c004b},
        {108455629,  15526350,  108519970,  15588449,  0x2b2004b},
        {106297736,  20904440,  106361863,  20964559,  0x29c004b},
        {106345933,  10213150,  106409067,  10275249,  0x2b2004b},
        {106317423,  9915240,   106378377,  9975359,   0x29c004b},
        {105842867,  20050050,  105908933,  20112149,  0x2b2004b},
        {106172769,  21251040,  106237230,  21311159,  0x29c004b},
        {106305567,  20422950,  106371633,  20485049,  0x2b2004b},
        {107974922,  14320640,  108036878,  14380759,  0x29c004b},
        {106026408,  21151950,  106092992,  21214049,  0x2b2004b},
        {105729439,  10269940,  105790560,  10330059,  0x29c004b},
        {104784708,  8893967,   107495689,  11575157,  0x0a80011},
        {104696438,  19413586,  107526583,  22094776,  0x001000d},
        {107940000,  11485000,  109472800,  16345000,  0x6c00015},
        {97330000,   5612500,   109500000,  23400000,  0x4720016},
        {102135000,  7500000,   109500000,  23400000,  0x003021c},
        {24854471,   60144053,  25025529,   60230543,  0x001000a}, // FIN
        {24574000,   60096344,  25247886,   60449000,  0xf040447},
        {23430600,   61297900,  24164724,   61611000,  0xe890447},
        {22162790,   60406800,  22337210,   60493289,  0x3c1004b},
        {25380676,   64976900,  25581524,   65063389,  0x3c1004b},
        {25568848,   60943200,  25746151,   61029689,  0x3c1004b},
        {27544663,   62855700,  27731336,   62942189,  0x3c1004b},
        {25658345,   62216800,  25841654,   62303289,  0x3c1004b},
        {21697287,   61443200,  21877713,   61529689,  0x3c1004b},
        {28091348,   61016800,  28268651,   61103289,  0x3c1004b},
        {21541782,   63065100,  21731818,   63151589,  0x3c1004b},
        {26831590,   60426900,  27006010,   60513389,  0x3c1004b},
        {29686363,   62571600,  29873036,   62658089,  0x3c1004b},
        {24361348,   60956800,  24538651,   61043289,  0x3c1004b},
        {25562890,   60350800,  25737310,   60437289,  0x3c1004b},
        {27173287,   61647200,  27353713,   61733689,  0x3c1004b},
        {21425148,   61086800,  21602451,   61173289,  0x3c1004b},
        {24795683,   60601750,  24920917,   60663849,  0x2b2004b},
        {25039379,   60449940,  25160620,   60510059,  0x29c004b},
        {25610097,   66468550,  25763103,   66530649,  0x2b2004b},
        {24020298,   60219940,  24139702,   60280059,  0x29c004b},
        {23050569,   63808950,  23189430,   63871049,  0x2b2004b},
        {27661530,   64199940,  27798469,   64260059,  0x29c004b},
        {26652848,   60841050,  26780152,   60903149,  0x2b2004b},
        {28711077,   61150040,  28834322,   61210159,  0x29c004b},
        {22782884,   62754150,  22916915,   62816249,  0x2b2004b},
        {28851392,   61838440,  28976808,   61898559,  0x29c004b},
        {24714083,   60710550,  24839317,   60772649,  0x2b2004b},
        {23071079,   60357940,  23192320,   60418059,  0x29c004b},
        {22117383,   60458950,  22242617,   60521049,  0x2b2004b},
        {27134083,   63537440,  27268517,   63597559,  0x29c004b},
        {27807492,   62289050,  27939108,   62351149,  0x2b2004b},
        {24496439,   65714540,  24641561,   65774659,  0x29c004b},
        {24085149,   65810550,  24235050,   65872649,  0x2b2004b},
        {25968377,   61179940,  26091622,   61240059,  0x29c004b},
        {22843248,   61308050,  22970552,   61370149,  0x2b2004b},
        {26548377,   60889940,  26671622,   60950059,  0x29c004b},
        {23966348,   61238950,  24093652,   61301049,  0x2b2004b},
        {27593952,   63049940,  27726048,   63110059,  0x29c004b},
        {22640569,   63647750,  22779430,   63709849,  0x2b2004b},
        {23569379,   60789940,  23690620,   60850059,  0x29c004b},
        {29105049,   65928950,  29254950,   65991049,  0x2b2004b},
        {24407895,   64658950,  24586171,   64706000,  0x29c044b},
        {25237883,   60611850,  25363117,   60673949,  0x2b2004b},
        {21349379,   60769940,  21470620,   60830059,  0x29c004b},
        {25846892,   62365350,  25978508,   62427449,  0x2b2004b},
        {26742079,   60659840,  26863320,   60719959,  0x29c004b},
        {25197383,   60338950,  25322617,   60401049,  0x2b2004b},
        {25278858,   65159940,  25421141,   65220059,  0x29c004b},
        {24576048,   60893450,  24703352,   60955549,  0x2b2004b},
        {23412198,   59956440,  23531602,   60016559,  0x29c004b},
        {21372000,   61800000,  28350000,   63792000,  0x017000d},
        {21372000,   59808000,  28350000,   61800000,  0x07e0011},
        {22560000,   63792000,  28900000,   66200000,  0x3750015},
        {-9154000,   68600000,  33625000,   80843100,  0x0970012},
        {4490000,    54544000,  31600000,   68600000,  0x3770016},
        {19100000,   59675750,  31700000,   70150000,  0x003021c},
        {15216755,   -4284596,  15303245,   -4198106,  0x001000a}, // COG
        {15017140,   -4388380,  15364060,   -4042421,  0xf040047},
        {11776090,   -4930700,  12111909,   -4595811,  0xe890047},
        {12611976,   -4260910,  12734624,   -4138601,  0x54f004b},
        {13260035,   -4245800,  13346764,   -4159311,  0x3c1004b},
        {13011435,   -4178800,  13098164,   -4092311,  0x3c1004b},
        {12672755,   -3004500,  12759244,   -2918011,  0x3c1004b},
        {15853355,   -527200,   15939844,   -440711,   0x3c1004b},
        {16006755,   1566800,   16093244,   1653289,   0x3c1004b},
        {13508335,   -4215000,  13595064,   -4128511,  0x3c1004b},
        {15829255,   -1919300,  15915744,   -1832811,  0x3c1004b},
        {18001655,   1559700,   18088144,   1646189,   0x3c1004b},
        {14724435,   -4405500,  14811164,   -4319011,  0x3c1004b},
        {13333435,   -3729300,  13420164,   -3642811,  0x3c1004b},
        {14711455,   -2584300,  14797944,   -2497811,  0x3c1004b},
        {11893135,   -4212200,  11979864,   -4125711,  0x3c1004b},
        {14794455,   -924500,   14880944,   -838011,   0x3c1004b},
        {12652355,   -1923200,  12738844,   -1836711,  0x3c1004b},
        {17997955,   2005500,   18084444,   2091989,   0x3c1004b},
        {16756755,   -1263200,  16843244,   -1176711,  0x3c1004b},
        {14536755,   1596800,   14623244,   1683289,   0x3c1004b},
        {14316335,   -4300700,  14403064,   -4214211,  0x3c1004b},
        {14465155,   -123900,   14551644,   -37411,    0x3c1004b},
        {12267635,   -3518400,  12354364,   -3431911,  0x3c1004b},
        {17432755,   1321100,   17519244,   1407589,   0x3c1004b},
        {13183635,   -3322400,  13270364,   -3235911,  0x3c1004b},
        {13781455,   -2908000,  13867944,   -2821511,  0x3c1004b},
        {11621135,   -4292800,  11707864,   -4206311,  0x3c1004b},
        {11263535,   -4032600,  11350264,   -3946111,  0x3c1004b},
        {14639155,   389400,    14725644,   475889,    0x3c1004b},
        {14081055,   2015600,   14167544,   2102089,   0x3c1004b},
        {15060955,   -1497000,  15147444,   -1410511,  0x3c1004b},
        {13909335,   -4041400,  13996064,   -3954911,  0x3c1004b},
        {11148038,   -5050000,  13829228,   -2368810,  0x0a80011},
        {13829228,   -5050000,  16510418,   -2368810,  0x001000d},
        {14097347,   -2424226,  16778537,   256964,    0x0010015},
        {11140000,   -5050000,  18700000,   3720000,   0x0010016},
        {13343147,   52475655,  13484414,   52562145,  0x001000a}, // DEU
        {13259774,   52495590,  13460225,   52617899,  0x54f004b},
        {13460225,   52495590,  13660676,   52617899,  0x54f004b},
        {13260963,   52373281,  13459036,   52495590,  0x54f004b},
        {13459036,   52373281,  13657109,   52495590,  0x54f004b},
        {9854800,    53542300,  10119184,   53637299,  0x54f044b},
        {11474117,   48076390,  11655882,   48198699,  0x54f004b},
        {6866672,    50880990,  7060328,    51003299,  0x54f004b},
        {8612971,    50076800,  8747029,    50163289,  0x3c1004b},
        {7410688,    51466800,  7549311,    51553289,  0x3c1004b},
        {9129133,    48751900,  9258867,    48838389,  0x3c1004b},
        {6921888,    51424600,  7060511,    51511089,  0x3c1004b},
        {6727229,    51187800,  6864170,    51274289,  0x3c1004b},
        {8738166,    53036800,  8881834,    53123289,  0x3c1004b},
        {9659968,    52356800,  9800032,    52443289,  0x3c1004b},
        {6671688,    51386300,  6810311,    51472789,  0x3c1004b},
        {10983691,   49406800,  11116308,   49493289,  0x3c1004b},
        {12331529,   51306800,  12468470,   51393289,  0x3c1004b},
        {13671529,   51006800,  13808470,   51093289,  0x3c1004b},
        {7133188,    51423600,  7271811,    51510089,  0x3c1004b},
        {7111529,    51216800,  7248470,    51303289,  0x3c1004b},
        {8473768,    51983900,  8613832,    52070389,  0x3c1004b},
        {7032250,    50686800,  7177197,    50767600,  0x3c1044b},
        {8403691,    49456800,  8536308,    49543289,  0x3c1004b},
        {8334412,    48962000,  8480602,    49039500,  0x3c1044b},
        {7040688,    51466800,  7179311,    51553289,  0x3c10047},
        {7549468,    51917600,  7689532,    52004089,  0x3c10047},
        {10825133,   48316800,  10954867,   48403289,  0x3c10047},
        {12849950,   50784300,  12985450,   50870789,  0x3c10047},
        {6037050,    50732700,  6172550,    50819189,  0x3c10047},
        {8167571,    50026800,  8301629,    50113289,  0x3c10047},
        {6382129,    51144600,  6519070,    51231089,  0x3c10047},
        {11554868,   52083100,  11694932,   52169589,  0x3c10047},
        {6797488,    51470400,  6936111,    51556889,  0x3c10047},
        {10441068,   52221500,  10581132,   52307989,  0x3c10047},
        {6511529,    51292900,  6648470,    51379389,  0x3c10047},
        {11890688,   51436800,  12029311,   51523289,  0x3c10047},
        {10046484,   54276800,  10193516,   54363289,  0x3c10047},
        {10597625,   53828900,  10742975,   53915389,  0x3c10047},
        {7782934,    47952300,  7911466,    48038789,  0x3c10047},
        {7389429,    51327100,  7526370,    51413589,  0x3c10047},
        {10961529,   50946800,  11098470,   51033289,  0x3c10047},
        {12041284,   54055500,  12188316,   54141989,  0x3c10047},
        {9411529,    51276800,  9548470,    51363289,  0x3c10047},
        {8199171,    49951900,  8333229,    50038389,  0x3c10047},
        {7730688,    51626800,  7869311,    51713289,  0x3c10047},
        {6905812,    49180900,  7036987,    49267389,  0x3c10047},
        {7125488,    51514300,  7264111,    51600789,  0x3c10047},
        {6808188,    51386800,  6946811,    51473289,  0x3c10047},
        {7979968,    52236800,  8120032,    52323289,  0x3c10047},
        {6984829,    51135500,  7121770,    51221989,  0x3c10047},
        {6927229,    51000500,  7064170,    51086989,  0x3c10047},
        {8138166,    53106800,  8281834,    53193289,  0x3c10047},
        {6597729,    51157800,  6734670,    51244289,  0x3c10047},
        {8592591,    49370400,  8725208,    49456889,  0x3c10047},
        {8670688,    51676800,  8809311,    51763289,  0x3c10047},
        {7910000,    48000000,  11940000,   50507000,  0x01d000d},
        {12891024,   52228680,  13646184,   52719720,  0x0b10090},
        {9359508,    53324480,  10135500,   53815520,  0x0b10890},
        {8129816,    52859480,  8895392,    53350520,  0x0b11090},
        {11810132,   51169480,  12549668,   51660520,  0x0b11890},
        {13235232,   50944480,  13974768,   51435520,  0x0b12090},
        {12314140,   50619480,  13048468,   51110520,  0x0b02890},
        {11543224,   51733180,  12293176,   52224220,  0x0b03090},
        {9929300,    53849480,  10715708,   54340520,  0x0b03890},
        {7411372,    47564480,  8098828,    48055520,  0x0b14090},
        {10940440,   50714480,  11674768,   51205520,  0x0b04890},
        {11359500,   53614480,  12145908,   54105520,  0x0b05090},
        {6473756,    49083180,  7182044,    49574220,  0x0b15890},
        {11991064,   48709480,  12694144,   49200520,  0x0b06090},
        {8010408,    53412280,  8786400,    53903320,  0x0b16890},
        {7202248,    50038780,  7926160,    50529820,  0x0b17090},
        {11620740,   50447980,  12355068,   50939020,  0x0b07890},
        {13915232,   51359480,  14654768,   51850520,  0x0b18090},
        {6270648,    49504480,  6989352,    49995520,  0x0b08890},
        {7216456,    49055380,  7924744,    49546420,  0x0b19090},
        {9022892,    54358980,  9819716,    54850020,  0x0b09890},
        {9041372,    47479480,  9728828,    47970520,  0x0b1a090},
        {11809924,   52269480,  12565084,   52760520,  0x0b1a890},
        {9668616,    52630680,  10434192,   53121720,  0x0b1b090},
        {12884608,   53324480,  13660600,   53815520,  0x0b1b890},
        {10014608,   53004480,  10790600,   53495520,  0x0b1c090},
        {14058924,   52003180,  14814084,   52494220,  0x0b1c890},
        {10051272,   47614480,  10738728,   48105520,  0x0b1d090},
        {11791064,   48294480,  12494144,   48785520,  0x0b0d890},
        {11806272,   47614480,  12493728,   48105520,  0x0b1e090},
        {12849400,   53959480,  13635808,   54450520,  0x0b0e890},
        {14335232,   50924480,  15074768,   51415520,  0x0b1f090},
        {5942200,    50507000,  10950000,   52630000,  0x0890011},
        {5850000,    35450000,  18560000,   55080000,  0x50a0016},
        {5850000,    47255000,  15100000,   55080000,  0x003021c},
        {139686489,  35626755,  139792199,  35713245,  0x001000a}, // JPN
        {139510642,  35943289,  139617071,  36029778,  0x3c10047},
        {139617071,  35943289,  139723500,  36029778,  0x3c10047},
        {139723500,  35943289,  139829929,  36029778,  0x3c10047},
        {139446785,  35856800,  139553214,  35943289,  0x3c10047},
        {139553214,  35856800,  139659643,  35943289,  0x3c10047},
        {139659643,  35856800,  139766072,  35943289,  0x3c10047},
        {139766072,  35856800,  139872501,  35943289,  0x3c10047},
        {139872501,  35856800,  139978930,  35943289,  0x3c10047},
        {139446785,  35770311,  139553214,  35856800,  0x3c10047},
        {139553214,  35770311,  139659643,  35856800,  0x3c10047},
        {139659643,  35770311,  139766072,  35856800,  0x3c10047},
        {139766072,  35770311,  139872501,  35856800,  0x3c10047},
        {139872501,  35770311,  139978930,  35856800,  0x3c10047},
        {139978930,  35770311,  140085359,  35856800,  0x3c10047},
        {139446785,  35683822,  139553214,  35770311,  0x3c10047},
        {139553214,  35683822,  139659643,  35770311,  0x3c10047},
        {139659643,  35683822,  139766072,  35770311,  0x3c10047},
        {139766072,  35683822,  139872501,  35770311,  0x3c10047},
        {139872501,  35683822,  139978930,  35770311,  0x3c10047},
        {139978930,  35683822,  140085359,  35770311,  0x3c10047},
        {139447145,  35597333,  139552854,  35683822,  0x3c10047},
        {139552854,  35597333,  139658563,  35683822,  0x3c10047},
        {139658563,  35597333,  139764272,  35683822,  0x3c10047},
        {139764272,  35597333,  139869981,  35683822,  0x3c10047},
        {139869981,  35597333,  139975690,  35683822,  0x3c10047},
        {139394290,  35510844,  139499999,  35597333,  0x3c10047},
        {139499999,  35510844,  139605708,  35597333,  0x3c10047},
        {139605708,  35510844,  139711417,  35597333,  0x3c10047},
        {139711417,  35510844,  139817126,  35597333,  0x3c10047},
        {139447145,  35424355,  139552854,  35510844,  0x3c10047},
        {139552854,  35424355,  139658563,  35510844,  0x3c10047},
        {135447506,  34636800,  135552494,  34723289,  0x3c1004b},
        {136857506,  35106800,  136962494,  35193289,  0x3c1004b},
        {141280899,  43016800,  141399101,  43103289,  0x3c1004b},
        {135117106,  34640000,  135222094,  34726489,  0x3c1004b},
        {135697506,  34966800,  135802494,  35053289,  0x3c1004b},
        {130358467,  33546800,  130461533,  33633289,  0x3c1004b},
        {132402146,  34347500,  132506653,  34433989,  0x3c1004b},
        {140835344,  38216800,  140944656,  38303289,  0x3c1004b},
        {130808106,  33836800,  130911893,  33923289,  0x3c1004b},
        {140057145,  35566800,  140162854,  35653289,  0x3c1004b},
        {135427746,  34526800,  135532253,  34613289,  0x3c1004b},
        {130658707,  32756800,  130761292,  32843289,  0x3c1004b},
        {133864206,  34613300,  133969194,  34699789,  0x3c1004b},
        {139339445,  35548200,  139445154,  35634689,  0x3c1004b},
        {137668706,  34669700,  137773694,  34756189,  0x3c1004b},
        {139277145,  35616800,  139382854,  35703289,  0x3c1004b},
        {130509308,  31546800,  130610692,  31633289,  0x3c1004b},
        {135545906,  34626600,  135650894,  34713089,  0x3c1004b},
        {138985344,  37876800,  139094656,  37963289,  0x3c1004b},
        {134637506,  34786800,  134742494,  34873289,  0x3c1004b},
        {132730540,  33804150,  132805059,  33866249,  0x2b2004b},
        {138353511,  34949940,  138426489,  35010059,  0x29c004b},
        {135302709,  34703250,  135378090,  34765349,  0x2b2004b},
        {136602759,  36529940,  136677240,  36590059,  0x29c004b},
        {135373709,  34699750,  135449090,  34761849,  0x2b2004b},
        {139852759,  36529940,  139927240,  36590059,  0x29c004b},
        {131562999,  33208950,  131637000,  33271049,  0x2b2004b},
        {133736178,  34561240,  133808822,  34621359,  0x29c004b},
        {139632050,  35238950,  139707949,  35301049,  0x2b2004b},
        {129844346,  32719940,  129915654,  32780059,  0x29c004b},
        {135617609,  34785650,  135692990,  34847749,  0x2b2004b},
        {136723260,  35389940,  136796739,  35450059,  0x29c004b},
        {139435550,  35304350,  139511449,  35366449,  0x2b2004b},
        {135373511,  34782540,  135446489,  34842659,  0x29c004b},
        {133335082,  34469050,  133410118,  34531149,  0x2b2004b},
        {135133678,  34189940,  135206322,  34250059,  0x29c004b},
        {137352309,  34728950,  137427690,  34791049,  0x2b2004b},
        {135773011,  34660340,  135845989,  34720459,  0x29c004b},
        {138141533,  36618950,  138218467,  36681049,  0x2b2004b},
        {137123511,  35059940,  137196489,  35120059,  0x29c004b},
        {140841274,  37018950,  140918725,  37081049,  0x2b2004b},
        {142318584,  43739940,  142401415,  43800059,  0x29c004b},
        {138000000,  34900000,  141045000,  37719521,  0x0b20011},
        {133019845,  34140000,  138360000,  35630000,  0x011000d},
        {141173412,  42758800,  141833743,  43231100,  0x0aa0090},
        {130334975,  33550000,  131028227,  33946000,  0x08e0890},
        {132218768,  34190000,  132955329,  34565520,  0x0871090},
        {140701452,  38168280,  141363520,  38605000,  0x09d1890},
        {130420000,  32430000,  130847182,  33064000,  0x0e42090},
        {130291784,  31344480,  130838624,  31835520,  0x0b02890},
        {138782000,  37717000,  139510411,  38115000,  0x08f3090},
        {132675000,  33725000,  133357992,  34132120,  0x0923890},
        {136369060,  36384580,  136947148,  36875620,  0x0b14090},
        {131400000,  32955000,  131929046,  33464000,  0x0b84890},
        {129803248,  32701880,  130237000,  33323000,  0x0e05090},
        {141800000,  43455000,  142458280,  43933000,  0x0ab5890},
        {133197500,  33350000,  134109676,  33650000,  0x06c6090},
        {136947000,  36545000,  137624878,  36964300,  0x0976890},
        {140015436,  39326580,  140619564,  39817620,  0x0b07090},
        {131000000,  31638000,  131538000,  32136961,  0x0b47890},
        {127636000,  26074000,  128016556,  26740000,  0x0f08090},
        {140268128,  40592980,  140882672,  41084020,  0x0b08890},
        {139975000,  37720000,  140847208,  38050000,  0x0779090},
        {140965000,  39105000,  141296546,  39990000,  0x13f9890},
        {140499586,  41694000,  141189000,  42138000,  0x0a0a090},
        {134268768,  33824480,  134831232,  34315520,  0x0b0a890},
        {139960000,  38050000,  140509973,  38574120,  0x0bdb090},
        {135967360,  35825180,  136540240,  36316220,  0x0b1b890},
        {130860000,  33922600,  131874445,  34195520,  0x062c090},
        {141115936,  40308280,  141725272,  40799320,  0x0b0c890},
        {130236575,  33064480,  130793831,  33555520,  0x0b0d090},
        {137786000,  35630000,  138000000,  36944467,  0x1d9d890},
        {143813412,  42921880,  144448788,  43412920,  0x0b0e090},
        {142872312,  42674480,  143507688,  43165520,  0x0b0e890},
        {132370000,  35118341,  133020000,  35548000,  0x09af090},
        {145382749,  42876810,  149017251,  45558000,  0x0a80091},
        {128250000,  31940000,  130128000,  34770000,  0x0e00891},
        {128800000,  27990000,  131230000,  30946000,  0x0c51091},
        {126363710,  25316208,  129313019,  27997398,  0x0a91891},
        {122826065,  24030000,  125745583,  26711190,  0x0a82091},
        {138230268,  31875196,  141358323,  34556386,  0x0a92891},
        {138885670,  29194006,  141924352,  31875196,  0x0a93091},
        {139523197,  26512816,  142502297,  29194006,  0x0a83891},
        {140148808,  24030000,  143068326,  26711190,  0x0a84091},
        {129733478,  24030000,  132652996,  26711190,  0x0a84891},
        {129300000,  30965000,  132104000,  33975000,  0x0bc5091},
        {130713029,  33698405,  133930457,  36379595,  0x0a85891},
        {131933868,  31838167,  135061923,  34519357,  0x0a96891},
        {142473401,  41849223,  146048321,  44530413,  0x0a87091},
        {139746928,  42868810,  143381430,  45550000,  0x0a88091},
        {133928074,  33296227,  137115711,  35977417,  0x0a88891},
        {138920228,  41312985,  142465357,  43994175,  0x0a89091},
        {138170000,  37235000,  141702706,  39130000,  0x08a9891},
        {135445000,  34450000,  138170700,  37560000,  0x0c6a091},
        {138979810,  38899914,  142405775,  41581104,  0x0a9c091},
        {138170686,  34556386,  141388114,  37237576,  0x0a9c891},
        {139750000,  41390000,  142473401,  44530413,  0x0d0f091},
        {135377023,  37560000,  138600000,  40236615,  0x0acd091},
        {131000000,  35959405,  134250000,  38640595,  0x0a9d891},
        {122826000,  24030000,  149150000,  45558000,  0x0010217},
        {31004713,   -17869254, 31095286,   -17782765, 0x001000a}, // ZWE
        {30886966,   -18040495, 31249262,   -17694536, 0xf040047},
        {28397258,   -20302655, 28753542,   -19967766, 0xe890047},
        {29727408,   -19526610, 29857191,   -19404301, 0x54f004b},
        {30613458,   -17940610, 30741542,   -17818301, 0x54f004b},
        {29838688,   -18403810, 29967112,   -18281501, 0x54f004b},
        {30782293,   -20119400, 30874307,   -20032911, 0x3c1004b},
        {29777453,   -18965900, 29868747,   -18879411, 0x3c1004b},
        {31504793,   -18243100, 31595606,   -18156611, 0x3c1004b},
        {30016893,   -20360500, 30108907,   -20274011, 0x3c1004b},
        {30145013,   -17418900, 30235586,   -17332411, 0x3c1004b},
        {26456093,   -18397100, 26546906,   -18310611, 0x3c1004b},
        {30092893,   -18177600, 30183706,   -18091111, 0x3c1004b},
        {29716353,   -19058700, 29807647,   -18972211, 0x3c1004b},
        {28801554,   -16553800, 28891646,   -16467311, 0x3c1004b},
        {31280533,   -17350100, 31370866,   -17263611, 0x3c1004b},
        {25764293,   -17978400, 25855106,   -17891911, 0x3c1004b},
        {32550853,   -19038700, 32642147,   -18952211, 0x3c1004b},
        {32642147,   -19048800, 32719571,   -18947000, 0x3c1044b},
        {29653133,   -16872200, 29743466,   -16785711, 0x3c1004b},
        {32085573,   -18580800, 32176626,   -18494311, 0x3c1004b},
        {29947513,   -19721500, 30039287,   -19635011, 0x3c1004b},
        {31629332,   -21092800, 31722067,   -21006311, 0x3c1004b},
        {27764093,   -20531100, 27856107,   -20444611, 0x3c1004b},
        {31540954,   -16812800, 31631046,   -16726311, 0x3c1004b},
        {32587193,   -20240500, 32679207,   -20154011, 0x3c1004b},
        {28960972,   -20981200, 29053227,   -20894711, 0x3c1004b},
        {32823113,   -19852300, 32914887,   -19765811, 0x3c1004b},
        {30850253,   -19059100, 30941547,   -18972611, 0x3c1004b},
        {30481853,   -19331900, 30573147,   -19245411, 0x3c1004b},
        {29949292,   -22254400, 30042508,   -22167911, 0x3c1004b},
        {29768924,   -18490620, 30258476,   -17999580, 0x001088c},
        {29622058,   -18981660, 30111610,   -18490620, 0x001108c},
        {29622058,   -19472700, 30116818,   -18981660, 0x001188c},
        {29622058,   -19963740, 30116818,   -19472700, 0x001208c},
        {29671534,   -20454780, 30166294,   -19963740, 0x001288c},
        {28739732,   -16767720, 29224076,   -16276680, 0x001708c},
        {25598124,   -18300320, 26087676,   -17809280, 0x001788c},
        {29375532,   -17074120, 29859876,   -16583080, 0x001808c},
        {27666924,   -20733420, 28161684,   -20242380, 0x001888c},
        {28918616,   -21240620, 29418584,   -20749580, 0x001908c},
        {29745916,   -22316820, 30245884,   -21825780, 0x001988c},
        {26256724,   -18673120, 26746276,   -18182080, 0x001a88c},
        {26746276,   -18673120, 27235828,   -18182080, 0x001b08c},
        {27235828,   -18732044, 27725380,   -18241004, 0x001b88c},
        {27725380,   -18732044, 28214932,   -18241004, 0x001c08c},
        {27480604,   -19223084, 27970156,   -18732044, 0x001c88c},
        {30106670,   -18840595, 32877233,   -16159405, 0x001000d},
        {30079858,   -21521785, 32880212,   -18840595, 0x0010015},
        {25235000,   -22420410, 33080000,   -15606000, 0x0010016},
        {-57672089,  -25343245, -57576950,  -25256755, 0x001000a}, // PRY
        {-57672570,  -25557220, -57156978,  -25066180, 0x001000c},
        {-54728710,  -25578910, -54593491,  -25456601, 0x54f004b},
        {-54715188,  -25701219, -54579969,  -25578910, 0x54f004b},
        {-54863929,  -25578910, -54728710,  -25456601, 0x54f004b},
        {-54715188,  -25456601, -54579969,  -25334292, 0x54f004b},
        {-55910899,  -27390010, -55773302,  -27267701, 0x54f004b},
        {-55791911,  -22599010, -55660089,  -22476701, 0x54f004b},
        {-56087610,  -25521110, -55952391,  -25398801, 0x54f004b},
        {-56487809,  -25493200, -56392191,  -25406711, 0x3c1004b},
        {-57460168,  -23443700, -57366232,  -23357211, 0x3c1004b},
        {-56508029,  -25820300, -56412171,  -25733811, 0x3c1004b},
        {-58321810,  -26909600, -58224991,  -26823111, 0x3c1004b},
        {-57189209,  -25440600, -57093591,  -25354111, 0x3c1004b},
        {-57070110,  -26924700, -56973291,  -26838211, 0x3c1004b},
        {-56482929,  -24714900, -56388272,  -24628411, 0x3c1004b},
        {-56928900,  -27409100, -56777634,  -27353500, 0x3c1044b},
        {-57188070,  -26700000, -57027070,  -26648300, 0x3c1044b},
        {-57101668,  -23390700, -57007732,  -23304211, 0x3c1004b},
        {-55755309,  -25415500, -55659691,  -25329011, 0x3c1004b},
        {-55735329,  -24522900, -55640672,  -24436411, 0x3c1004b},
        {-57083409,  -25503300, -56987791,  -25416811, 0x3c1004b},
        {-57128109,  -25303300, -57032491,  -25216811, 0x3c1004b},
        {-57203609,  -25663200, -57107991,  -25576711, 0x3c1004b},
        {-56286210,  -27201000, -56189391,  -27114511, 0x3c1004b},
        {-55140329,  -25838700, -55044471,  -25752211, 0x3c1004b},
        {-57826000,  -25966242, -54242000,  -23812000, 0x0880011},
        {-58667000,  -27605000, -54615000,  -25788711, 0x015000d},
        {-59864333,  -23812000, -55423000,  -22070000, 0x2710015},
        {-62660000,  -27605000, -54230000,  -19280000, 0x0010016},
        {44349467,   33297800,  44452533,   33384289,  0x001000a}, // IRQ
        {44081000,   33198000,  44574349,   33487000,  0xf040447},
        {47648274,   30339300,  48034326,   30674189,  0xe890047},
        {43044425,   36352300,  43151575,   36438789,  0x3c1004b},
        {43151575,   36352300,  43258725,   36438789,  0x3c1004b},
        {43044425,   36265811,  43151575,   36352300,  0x3c1004b},
        {43151575,   36265811,  43258725,   36352300,  0x3c1004b},
        {43935746,   36118890,  44010944,   36241199,  0x3c1044b},
        {44010944,   36108890,  44086142,   36231199,  0x3c1044b},
        {44323245,   35446400,  44428954,   35532889,  0x3c1004b},
        {44316000,   35375000,  44443929,   35446422,  0x3c1044b},
        {45367000,   35524000,  45482499,   35603089,  0x3c1044b},
        {44308167,   31984400,  44410032,   32070889,  0x3c1004b},
        {43953207,   32569100,  44055792,   32655589,  0x3c1004b},
        {46209548,   30996800,  46310452,   31083289,  0x3c1004b},
        {44367467,   32429400,  44469332,   32515889,  0x3c1004b},
        {43238267,   33388300,  43341333,   33474789,  0x3c1004b},
        {44876708,   31952400,  44978092,   32038889,  0x3c1004b},
        {45779967,   32466300,  45881832,   32552789,  0x3c1004b},
        {47115908,   31800700,  47217292,   31887189,  0x3c1004b},
        {44581506,   33703000,  44685293,   33789489,  0x3c1004b},
        {43748899,   33312850,  43822900,   33374949,  0x2b2004b},
        {43849578,   34166540,  43922222,   34226659,  0x29c004b},
        {47679107,   30359650,  47750693,   30421749,  0x2b2004b},
        {42393300,   36346640,  42482722,   36396600,  0x29c044b},
        {45245775,   31289750,  45318224,   31351849,  0x2b2004b},
        {46134930,   31379940,  46205069,   31440059,  0x29c004b},
        {44802550,   35487650,  44878449,   35549749,  0x2b2004b},
        {44644596,   32269940,  44715403,   32330059,  0x29c004b},
        {46421634,   30860450,  46493565,   30922549,  0x2b2004b},
        {42793609,   36829440,  42868591,   36889559,  0x29c004b},
        {45342482,   34318950,  45417518,   34381049,  0x2b2004b},
        {45905460,   35596340,  45978939,   35656459,  0x29c004b},
        {44238272,   32684350,  44311928,   32746449,  0x2b2004b},
        {43454011,   34891340,  43526989,   34951459,  0x29c004b},
        {44246472,   32746350,  44320128,   32808449,  0x2b2004b},
        {45034346,   32879940,  45105654,   32940059,  0x29c004b},
        {42926000,   36839200,  43049923,   36877900,  0x2b2044b},
        {43534179,   33359940,  43605821,   33420059,  0x29c004b},
        {44183172,   32518950,  44256828,   32581049,  0x2b2004b},
        {42600000,   37133400,  42731107,   37167750,  0x29c044b},
        {44580809,   34853350,  44656190,   34915449,  0x2b2004b},
        {41876878,   34446140,  41949522,   34506259,  0x29c004b},
        {42332482,   34108950,  42407518,   34171049,  0x2b2004b},
        {44554763,   31929940,  44625236,   31990059,  0x29c004b},
        {48434207,   29939750,  48505793,   30001849,  0x2b2004b},
        {44745046,   32895940,  44816354,   32956059,  0x29c004b},
        {42519793,   31750126,  45647848,   34431316,  0x0a90011},
        {45646359,   29900105,  48714832,   32581295,  0x001000d},
        {42370000,   34431347,  45520000,   37173400,  0x3d90015},
        {34217000,   28520000,  48790000,   37390000,  0x0010016},
        {38789600,   29000000,  48700000,   37390000,  0x003021c},
        {-7700000,   33541151,  -7577000,   33610298,  0x019000a}, // MAR
        {-7847000,   33230000,  -7326400,   33734000,  0x020000c},
        {-6902394,   33931500,  -6798607,   34017989,  0x3c1004b},
        {-6984294,   33892100,  -6880507,   33978589,  0x3c1004b},
        {-6858094,   34001700,  -6754307,   34088189,  0x3c1004b},
        {-5051894,   33986900,  -4948107,   34073389,  0x3c1004b},
        {-8084038,   31566000,  -8017152,   31697000,  0x3c1044b},
        {-8017152,   31566000,  -7950266,   31697000,  0x3c1044b},
        {-9610451,   30359100,  -9510749,   30445589,  0x3c1004b},
        {-9551451,   30304900,  -9451749,   30391389,  0x3c1004b},
        {-5895750,   35725500,  -5771711,   35799600,  0x3c1044b},
        {-5603294,   33844200,  -5477691,   33915600,  0x3c1044b},
        {-1960494,   34637800,  -1855506,   34724289,  0x3c1004b},
        {-6656370,   34226800,  -6511734,   34289200,  0x3c1044b},
        {-9283833,   32242500,  -9181968,   32328989,  0x3c1004b},
        {-5423800,   35552400,  -5291581,   35621500,  0x3c1044b},
        {-6965293,   32836600,  -6862708,   32923089,  0x3c1004b},
        {-6431333,   32281800,  -6329468,   32368289,  0x3c1004b},
        {-8553701,   33203050,  -8479700,   33265149,  0x2b2004b},
        {-3010100,   35139940,  -2911211,   35184500,  0x29c044b},
        {-7657128,   32969750,  -7583472,   33031849,  0x2b2004b},
        {-5929389,   34967140,  -5856411,   35027259,  0x29c004b},
        {-6110060,   33796450,  -6035541,   33858549,  0x2b2004b},
        {-6169940,   35143340,  -6096461,   35203459,  0x29c004b},
        {-10087848,  28958750,  -10016952,  29020849,  0x2b2004b},
        {-4040622,   34199440,  -3967978,   34259559,  0x29c004b},
        {-6743770,   32462650,  -6670631,   32524749,  0x2b2004b},
        {-5703154,   32914440,  -5631846,   32974559,  0x29c004b},
        {-4468797,   31899350,  -4396003,   31961449,  0x2b2004b},
        {-2362889,   34894940,  -2289911,   34955059,  0x29c004b},
        {-6611228,   32830450,  -6537572,   32892549,  0x2b2004b},
        {-5971422,   34230540,  -5898778,   34290659,  0x29c004b},
        {-2932518,   34377550,  -2857482,   34439649,  0x2b2004b},
        {-5756222,   34186940,  -5683578,   34247059,  0x29c004b},
        {-8916666,   30438250,  -8844735,   30500349,  0x2b2004b},
        {-2213222,   34290740,  -2140578,   34350859,  0x29c004b},
        {-7984470,   32202150,  -7911331,   32264249,  0x2b2004b},
        {-8554404,   32206840,  -8483597,   32266959,  0x29c004b},
        {-7423670,   32018250,  -7350531,   32080349,  0x2b2004b},
        {-3972240,   35200640,  -3898761,   35260759,  0x29c004b},
        {-5616391,   34759050,  -5541010,   34821149,  0x2b2004b},
        {-9773885,   29674440,  -9704915,   29734559,  0x29c004b},
        {-6360760,   33861650,  -6286241,   33923749,  0x2b2004b},
        {-9241752,   30367240,  -9172448,   30427359,  0x29c004b},
        {-11135276,  28398950,  -11064725,  28461049,  0x2b2004b},
        {-13221250,  27106940,  -13153950,  27167059,  0x29c004b},
        {-15970296,  23677250,  -15902505,  23739349,  0x2b2004b},
        {-11706383,  26712740,  -11639417,  26772859,  0x29c004b},
        {-14550000,  25700000,  -11000000,  27670000,  0x018000d},
        {-6206056,   35342092,  -5633176,   35833132,  0x001008c},
        {-5633176,   35430480,  -5060296,   35921520,  0x001088c},
        {-6321153,   34851052,  -5753481,   35342092,  0x001108c},
        {-5583179,   34939440,  -5015507,   35430480,  0x001188c},
        {-6025732,   34583280,  -5463268,   35074320,  0x001208c},
        {-5463268,   34583280,  -4900804,   35074320,  0x001288c},
        {-4934232,   33729480,  -4371768,   34220520,  0x001308c},
        {-8273616,   31385480,  -7726776,   31876520,  0x001388c},
        {-9675708,   30071880,  -9139284,   30562920,  0x001408c},
        {-2395832,   34665480,  -1828160,   35156520,  0x001488c},
        {-9293324,   32017980,  -8741276,   32509020,  0x001508c},
        {-8693162,   32917680,  -8141114,   33408720,  0x001588c},
        {-8742846,   32426639,  -8190798,   32917679,  0x001608c},
        {-8743159,   31935600,  -8196319,   32426640,  0x001688c},
        {-3235932,   34916680,  -2668260,   35407720,  0x001708c},
        {-10318008,  28744280,  -9786792,   29235320,  0x001788c},
        {-4285531,   33983980,  -3723067,   34475020,  0x001808c},
        {-4635816,   31633980,  -4088976,   32125020,  0x001888c},
        {-3408732,   34078780,  -2846268,   34569820,  0x001908c},
        {-9141108,   30223780,  -8604684,   30714820,  0x001988c},
        {-2589832,   34196880,  -2027368,   34687920,  0x001a08c},
        {-9823216,   31235480,  -9276376,   31726520,  0x001a88c},
        {-4353449,   34803480,  -3785777,   35294520,  0x001b08c},
        {-3785777,   34803480,  -3218105,   35294520,  0x001b88c},
        {-9999808,   29458980,  -9463384,   29950020,  0x001c08c},
        {-11355200,  28184480,  -10829192,  28675520,  0x001c88c},
        {-7170816,   30674480,  -6629184,   31165520,  0x001d08c},
        {-4927524,   32435980,  -4375476,   32927020,  0x001d88c},
        {-5795616,   31274480,  -5248776,   31765520,  0x001e08c},
        {-8247716,   30421480,  -7706084,   30912520,  0x001e88c},
        {-16011084,  23470080,  -15505908,  23961120,  0x001f08c},
        {-8052729,   31909405,  -4924674,   34590595,  0x0010015},
        {-6972871,   33248810,  -3755443,   35930000,  0x0a80091},
        {-4212428,   33248810,  -995000,    35930000,  0x0a80891},
        {-10130717,  31327374,  -7002662,   34008564,  0x0a81091},
        {-7002662,   31327374,  -3874607,   34008564,  0x0a81891},
        {-4123055,   31327374,  -995000,    34008564,  0x0a82091},
        {-11571112,  28646184,  -8532430,   31327374,  0x0a82891},
        {-8532430,   28646184,  -5493748,   31327374,  0x0a83091},
        {-5493748,   28646184,  -2455066,   31327374,  0x0a83891},
        {-14550212,  25964994,  -11600903,  28646184,  0x0a94091},
        {-11600903,  25964994,  -8651594,   28646184,  0x0a94891},
        {-17764661,  23283804,  -14874934,  25964994,  0x0a95091},
        {-14874934,  23283804,  -11985207,  25964994,  0x0a95891},
        {-17764661,  20727860,  -14904725,  23283804,  0x0a46091},
        {-14904725,  20727860,  -12044789,  23283804,  0x0a46891},
        {-17764661,  20727860,  -995000,    35930000,  0x0010217},
        {69181679,   41239111,  69296037,   41325600,  0x001000a}, // UZB
        {68907928,   40993580,  69527680,   41484620,  0x001000c},
        {71583040,   40936690,  71744760,   41058999,  0x54f004b},
        {66884509,   39589190,  67042491,   39711499,  0x54f004b},
        {72273850,   40718190,  72434550,   40840499,  0x54f004b},
        {64350009,   39713890,  64507991,   39836199,  0x54f004b},
        {59518381,   42401290,  59682819,   42523599,  0x54f004b},
        {71727662,   40340800,  71840338,   40427289,  0x3c1004b},
        {65735203,   38809800,  65846197,   38896289,  0x3c1004b},
        {70883181,   40496800,  70996818,   40583289,  0x3c1004b},
        {69522421,   41418300,  69636779,   41504789,  0x3c1004b},
        {60566840,   41508200,  60682159,   41594689,  0x3c1004b},
        {67784862,   40083900,  67897538,   40170389,  0x3c1004b},
        {70039021,   40972100,  70153379,   41058589,  0x3c1004b},
        {65293362,   40071800,  65406038,   40158289,  0x3c1004b},
        {71664581,   40425700,  71778218,   40512189,  0x3c1004b},
        {69186762,   40183800,  69299438,   40270289,  0x3c1004b},
        {67231364,   37184600,  67339235,   37271089,  0x3c1004b},
        {69533181,   40806800,  69646818,   40893289,  0x3c1004b},
        {59389360,   42363900,  59505640,   42450389,  0x3c1004b},
        {66773803,   39017900,  66884797,   39104389,  0x3c1004b},
        {68726481,   40459900,  68840118,   40546389,  0x3c1004b},
        {66203662,   39856800,  66316338,   39943289,  0x3c1004b},
        {67855244,   38233100,  67964556,   38319589,  0x3c1004b},
        {60938940,   41511100,  61054259,   41597589,  0x3c1004b},
        {71176121,   40958000,  71290479,   41044489,  0x3c1004b},
        {64499742,   39680500,  64611457,   39766989,  0x3c1004b},
        {72003181,   40666800,  72116818,   40753289,  0x3c1004b},
        {68424000,   40140000,  73180000,   42072480,  0x07a0011},
        {63520000,   38468711,  68424000,   40285000,  0x015000d},
        {57954561,   41131721,  61499690,   43812911,  0x0010015},
        {55980000,   36670000,  80230000,   45600000,  0x27a0016},
        {55980000,   37170000,  73180000,   45600000,  0x003021c},
        {17985432,   59286755,  18154568,   59373245,  0x001000a}, // SWE
        {17565570,   59086269,  18466554,   59577309,  0x001000c},
        {11929156,   57676800,  12090843,   57763289,  0x3c1004b},
        {12934362,   55552900,  13085238,   55639389,  0x3c1004b},
        {17548311,   59812200,  17720088,   59898689,  0x3c1004b},
        {16457832,   59582500,  16626967,   59668989,  0x3c1004b},
        {15125054,   59233000,  15291546,   59319489,  0x3c1004b},
        {15552155,   58360200,  15716244,   58446689,  0x3c1004b},
        {12676181,   55997200,  12829219,   56083689,  0x3c1004b},
        {14126156,   57736900,  14287843,   57823389,  0x3c1004b},
        {16103555,   58554800,  16267644,   58641289,  0x3c1004b},
        {13123081,   55663200,  13276119,   55749689,  0x3c1004b},
        {20150800,   63783800,  20344200,   63870289,  0x3c1004b},
        {17059490,   60626400,  17233910,   60712889,  0x3c1004b},
        {12872156,   57679700,  13033843,   57766189,  0x3c1004b},
        {16406332,   59319500,  16575467,   59405989,  0x3c1004b},
        {13422532,   59358900,  13591667,   59445389,  0x3c1004b},
        {12714900,   56634500,  12937259,   56695600,  0x3c1044b},
        {14715839,   56837000,  14872961,   56923489,  0x3c1004b},
        {17214845,   62365500,  17398154,   62451989,  0x3c1004b},
        {22027000,   65558260,  22282485,   65628870,  0x3c1044b},
        {12252000,   58249600,  12354278,   58321049,  0x2b2044b},
        {14578652,   63153140,  14710748,   63213259,  0x29c004b},
        {15368983,   60458750,  15494217,   60520849,  0x2b2004b},
        {15583679,   60575940,  15704920,   60636059,  0x29c004b},
        {16275793,   56648750,  16388607,   56710849,  0x2b2004b},
        {13797170,   58366340,  13911230,   58426459,  0x29c004b},
        {15521269,   56147550,  15632530,   56209649,  0x2b2004b},
        {14087211,   56002140,  14193589,   56062259,  0x29c004b},
        {11870192,   58323650,  11988008,   58385749,  0x2b2004b},
        {14977470,   58510540,  15091530,   58570659,  0x29c004b},
        {18652177,   63261050,  18788623,   63323149,  0x2b2004b},
        {12793011,   55847640,  12899389,   55907759,  0x29c004b},
        {14455780,   59298450,  14577219,   59360549,  0x2b2004b},
        {16962135,   58729940,  17077865,   58790059,  0x29c004b},
        {12199293,   57077350,  12312107,   57139449,  0x2b2004b},
        {13097462,   55357440,  13202337,   55417559,  0x29c004b},
        {13101092,   58478950,  13218908,   58541049,  0x2b2004b},
        {17781216,   59599940,  17898783,   59660059,  0x29c004b},
        {12481954,   57898950,  12598045,   57961049,  0x2b2004b},
        {12816443,   56222140,  12924157,   56282259,  0x29c004b},
        {16707383,   60588950,  16832617,   60651049,  0x2b2004b},
        {21402158,   65289640,  21544441,   65349759,  0x29c004b},
        {18239230,   57601850,  18353769,   57663949,  0x2b2004b},
        {12272970,   58339940,  12387030,   58400059,  0x29c004b},
        {11190000,   55320000,  14655000,   58660000,  0x028000d},
        {14588328,   57898780,  15463272,   58389820,  0x0b00090},
        {15463272,   57898780,  16338216,   58389820,  0x0b00890},
        {16338215,   57898780,  17213159,   58389820,  0x0b01090},
        {14593536,   57407740,  15458064,   57898780,  0x0b01890},
        {15458064,   57407740,  16322592,   57898780,  0x0b02090},
        {16322592,   57407740,  17187120,   57898780,  0x0b02890},
        {14603952,   56916700,  15452856,   57407740,  0x0b03090},
        {15452856,   56916700,  16301760,   57407740,  0x0b03890},
        {16301760,   56916700,  17150664,   57407740,  0x0b04090},
        {14609160,   56425660,  15447648,   56916700,  0x0b04890},
        {15447648,   56425660,  16286136,   56916700,  0x0b05090},
        {16286136,   56425660,  17124624,   56916700,  0x0b05890},
        {14614368,   55934620,  15442440,   56425660,  0x0b06090},
        {15442440,   55934620,  16270512,   56425660,  0x0b06890},
        {16270512,   55934620,  17098584,   56425660,  0x0b07090},
        {21276652,   65209180,  22385956,   65700220,  0x0b07890},
        {21266236,   65700220,  22396372,   66191260,  0x0b08090},
        {22396372,   65700220,  23526508,   66191260,  0x0b08890},
        {19625700,   63550080,  20672508,   64041120,  0x0b09090},
        {14136816,   62937680,  15162792,   63428720,  0x0b19890},
        {18277716,   63056080,  19303692,   63547120,  0x0b1a090},
        {18083736,   57345380,  18948264,   57836420,  0x0b0a890},
        {18076861,   56854340,  18925765,   57345380,  0x0b0b090},
        {18490897,   57590900,  19355425,   58081940,  0x0b0b890},
        {12458392,   59028980,  13359376,   59520020,  0x0b0c090},
        {13359376,   59151740,  14260360,   59642780,  0x0b0c890},
        {13364584,   58660700,  14249944,   59151740,  0x0b1d090},
        {17104424,   62511780,  18114776,   63002820,  0x0b0d890},
        {16761216,   62020740,  17750736,   62511780,  0x0b1e090},
        {16623204,   61529700,  17597100,   62020740,  0x0b1e890},
        {16384938,   61038660,  17343210,   61529700,  0x0b0f090},
        {14237588,   58368100,  19302058,   61049290,  0x0a90011},
        {-9154000,   68600000,  33625000,   80843100,  0x0970012},
        {4490000,    54544000,  31600000,   68600000,  0x3770016},
        {10960000,   55320000,  24170000,   69070000,  0x003021c},
        {147132300,  -9504800,  147226575,  -9424700,  0x01c000a}, // PNG
        {146992425,  -9626760,  147466353,  -9135720,  0x001000c},
        {146919606,  -6746410,  147042594,  -6624101,  0x54f004b},
        {145704876,  -5279810,  145827524,  -5157501,  0x54f004b},
        {143560000,  -3620000,  143721275,  -3527101,  0x54f044b},
        {155556615,  -6280100,  155643584,  -6193611,  0x3c1004b},
        {145372415,  -6119900,  145459384,  -6033411,  0x3c1004b},
        {141255155,  -2749900,  141341644,  -2663411,  0x3c1004b},
        {150104915,  -5608300,  150191884,  -5521811,  0x3c1004b},
        {152121935,  -4242800,  152208664,  -4156311,  0x3c1004b},
        {144214915,  -5896000,  144301884,  -5809511,  0x3c1004b},
        {143173275,  -9104900,  143260725,  -9018411,  0x3c1004b},
        {150768455,  -2635800,  150854944,  -2549311,  0x3c1004b},
        {150422335,  -10334900, 150510265,  -10248411, 0x3c1004b},
        {143620515,  -6207300,  143707484,  -6120811,  0x3c1004b},
        {148210375,  -8794800,  148297825,  -8708311,  0x3c1004b},
        {146614595,  -7230500,  146701804,  -7144011,  0x3c1004b},
        {141257515,  -6156700,  141344484,  -6070211,  0x3c1004b},
        {144927415,  -6063300,  145014384,  -5976811,  0x3c1004b},
        {147253255,  -2094700,  147339744,  -2008211,  0x3c1004b},
        {146652195,  -7373400,  146739404,  -7286911,  0x3c1004b},
        {155036415,  -6262000,  155123384,  -6175511,  0x3c1004b},
        {143659715,  -5502700,  143746684,  -5416211,  0x3c1004b},
        {147703175,  -8914500,  147790625,  -8828011,  0x3c1004b},
        {145807615,  -6310900,  145894584,  -6224411,  0x3c1004b},
        {145706995,  -7987700,  145794204,  -7901211,  0x3c1004b},
        {155414415,  -6352800,  155501384,  -6266311,  0x3c1004b},
        {142309555,  -3203900,  142396044,  -3117411,  0x3c1004b},
        {152226735,  -4395400,  152313464,  -4308911,  0x3c1004b},
        {154610915,  -5478300,  154697884,  -5391811,  0x3c1004b},
        {146352681,  -10345954, 149033871,  -7664764,  0x0a90011},
        {143550000,  -6910000,  147070000,  -5058000,  0x016000d},
        {143406275,  -3819070,  143874995,  -3328030,  0x0b00090},
        {155294635,  -6518725,  155763355,  -6027685,  0x0b10890},
        {141064035,  -2952175,  141532755,  -2461135,  0x0b01090},
        {149914035,  -5810575,  150382755,  -5319535,  0x0b11890},
        {151983335,  -4521375,  152452055,  -4030335,  0x0b02090},
        {142985239,  -9307175,  143459167,  -8816135,  0x0b02890},
        {150577335,  -2838075,  151046055,  -2347035,  0x0b03090},
        {150234539,  -10537175, 150708467,  -10046135, 0x0b13890},
        {146442635,  -7504225,  146911355,  -7013185,  0x0b14090},
        {141066635,  -6358975,  141535355,  -5867935,  0x0b14890},
        {147062135,  -2296974,  147530855,  -1805934,  0x0b05090},
        {154845535,  -6464275,  155314255,  -5973235,  0x0b15890},
        {145516235,  -8189975,  145984955,  -7698935,  0x0b16090},
        {142118435,  -3406175,  142587155,  -2915135,  0x0b06890},
        {154420035,  -5680575,  154888755,  -5189535,  0x0b07090},
        {140830000,  -11660000, 159505000,  -870000,   0x2c90016},
        {9681000,    4004756,   9767490,    4091246,   0x001000a}, // CMR
        {9559398,    3939421,   9847023,    4226250,   0xc730047},
        {11336111,   3734290,   11610289,   4007709,   0xbde0047},
        {13260871,   9196790,   13537328,   9470209,   0xbde0047},
        {14970915,   12035400,  15059085,   12121889,  0x3c1004b},
        {10115715,   5926800,   10202684,   6013289,   0x3c1004b},
        {14264000,   10570000,  14382125,   10634290,  0x3c1044b},
        {10373115,   5438900,   10460084,   5525389,   0x3c1004b},
        {13758035,   10696800,  13845965,   10783289,  0x3c1004b},
        {13539395,   7278700,   13626604,   7365189,   0x3c1004b},
        {13641635,   4533800,   13728364,   4620289,   0x3c1004b},
        {9396636,    4596801,   9483365,    4683290,   0x3c1004b},
        {10856515,   5686800,   10943484,   5773289,   0x3c1004b},
        {9151357,    3992402,   9238086,    4078891,   0x3c1004b},
        {9686636,    4676801,   9773365,    4763290,   0x3c1004b},
        {9896636,    4916801,   9983365,    5003290,   0x3c1004b},
        {14406335,   10064800,  14494265,   10151289,  0x3c1004b},
        {10089935,   3751600,   10176664,   3838089,   0x3c1004b},
        {10210315,   5582300,   10297284,   5668789,   0x3c1004b},
        {10634815,   6168500,   10721784,   6254989,   0x3c1004b},
        {14246515,   6476800,   14333484,   6563289,   0x3c1004b},
        {10014115,   5404700,   10101084,   5491189,   0x3c1004b},
        {13900255,   9888400,   13987945,   9974889,   0x3c1004b},
        {10230435,   5100100,   10317164,   5186589,   0x3c1004b},
        {10602878,   5478050,   10665322,   5540149,   0x2b2004b},
        {11469857,   3489940,   11530143,   3550059,   0x29c004b},
        {11126850,   2890550,   11188949,   2952649,   0x2b2004b},
        {10149857,   5139940,   10210143,   5200059,   0x29c004b},
        {11198864,   4718950,   11261135,   4781049,   0x2b2004b},
        {9199858,    4129941,   9260144,    4190060,   0x29c004b},
        {15210533,   10309250,  15273667,   10371349,  0x2b2004b},
        {10048373,   6358340,   10108826,   6418459,   0x29c004b},
        {10494064,   5111850,   10556335,   5173949,   0x2b2004b},
        {14114656,   11020940,  14175944,   11081059,  0x29c004b},
        {10408078,   5961850,   10470522,   6023949,   0x2b2004b},
        {11942040,   2903040,   12002159,   2963159,   0x29c004b},
        {9276068,    4056447,   9338339,    4118546,   0x2b2004b},
        {14329857,   4399940,   14390143,   4460059,   0x29c004b},
        {14518778,   5858950,   14581222,   5921049,   0x2b2004b},
        {11775373,   6717340,   11835826,   6777459,   0x29c004b},
        {10262278,   6235750,   10324722,   6297849,   0x2b2004b},
        {9336068,    4051413,   9396354,    4111532,   0x29c004b},
        {9534532,    4470698,   9596803,    4532797,   0x2b2004b},
        {9893846,    2909668,   9953965,    2969787,   0x29c004b},
        {9837997,    5447471,   9900441,    5509570,   0x2b2004b},
        {15019857,   3479940,   15080143,   3540059,   0x29c004b},
        {13348640,   7076480,   13817360,   7567520,   0x0010088},
        {13817360,   6781856,   14286080,   7272896,   0x0010888},
        {14051720,   6290816,   14520440,   6781856,   0x0011088},
        {13450640,   4331480,   13919360,   4822520,   0x0011888},
        {14125640,   4184480,   14594360,   4675520,   0x0012088},
        {14166240,   5643980,   14634960,   6135020,   0x0012888},
        {11575640,   6504480,   12044360,   6995520,   0x0013088},
        {9846740,    2688280,   10315460,   3179320,   0x0013888},
        {10315459,   2688280,   10784179,   3179320,   0x0014088},
        {10784179,   2688280,   11252899,   3179320,   0x0014888},
        {11252899,   2688280,   11721619,   3179320,   0x0015088},
        {11721619,   2688280,   12190339,   3179320,   0x0015888},
        {10549820,   3179320,   11018540,   3670360,   0x0016088},
        {11018539,   3179320,   11487259,   3670360,   0x0016888},
        {11487259,   3179320,   11955979,   3670360,   0x0017088},
        {10596692,   2197240,   11065412,   2688280,   0x0017888},
        {11065412,   2197240,   11534132,   2688280,   0x0018088},
        {14779540,   3182880,   15248260,   3673920,   0x0018888},
        {12385640,   6224480,   12854360,   6715520,   0x0019088},
        {12385640,   6715520,   12854360,   7206560,   0x0019888},
        {12854359,   6715520,   13323079,   7206560,   0x001a088},
        {13385640,   2914480,   13854360,   3405520,   0x001a888},
        {14966540,   1899480,   15435260,   2390520,   0x001b088},
        {12094440,   3473180,   12563160,   3964220,   0x001b888},
        {12135640,   4424480,   12604360,   4915520,   0x001c088},
        {13944140,   8155580,   14412860,   8646620,   0x001c888},
        {13475420,   8155580,   13944140,   8646620,   0x001d088},
        {13381676,   8769379,   13855604,   9260419,   0x001d888},
        {13151640,   6224483,   13620360,   6715523,   0x001e088},
        {14696060,   8107303,   15164780,   8598343,   0x001e888},
        {15064316,   2495081,   15533036,   2986121,   0x001f088},
        {8952500,    3760933,   11633690,   6442123,   0x0a80011},
        {13207000,   9265000,   15455000,   12187000,  0x44d0015},
        {8340000,    1640000,   16210000,   13110000,  0x0010016},
        {58346284,   37892255,  58454877,   37978745,  0x001000a}, // TKM
        {57926000,   37841000,  58617000,   38252000,  0x01a000c},
        {63514503,   39056800,  63625497,   39143289,  0x3c1004b},
        {63514503,   38970311,  63625497,   39056800,  0x3c1004b},
        {59902340,   41806800,  60017659,   41893289,  0x3c1004b},
        {61785404,   37553400,  61893996,   37639889,  0x3c1004b},
        {54304142,   39466800,  54415857,   39553289,  0x3c1004b},
        {52903062,   39985500,  53015738,   40071989,  0x3c1004b},
        {62105704,   37576800,  62214296,   37663289,  0x3c1004b},
        {60445704,   37336800,  60554296,   37423289,  0x3c1004b},
        {56214503,   38936800,  56325497,   39023289,  0x3c1004b},
        {59611860,   42096800,  59728140,   42183289,  0x3c1004b},
        {65995344,   37766800,  66104656,   37853289,  0x3c1004b},
        {65166744,   37794300,  65276056,   37880789,  0x3c1004b},
        {62302104,   37253900,  62410696,   37340389,  0x3c1004b},
        {59572240,   41832300,  59687559,   41918789,  0x3c1004b},
        {59081860,   42286800,  59198140,   42373289,  0x3c1004b},
        {59329960,   42008000,  59446240,   42094489,  0x3c1004b},
        {54535903,   39160300,  54646897,   39246789,  0x3c1004b},
        {57391063,   38376300,  57501336,   38462789,  0x3c1004b},
        {61332621,   41139800,  61446979,   41226289,  0x3c1004b},
        {61218263,   41170071,  61332621,   41256560,  0x3c1004b},
        {55461703,   39212400,  55572697,   39298889,  0x3c1004b},
        {59568304,   37302600,  59676896,   37389089,  0x3c1004b},
        {56224863,   38396800,  56335136,   38483289,  0x3c1004b},
        {63830363,   38743200,  63940636,   38829689,  0x3c1004b},
        {61176525,   36486100,  61283675,   36572589,  0x3c1004b},
        {59873400,   41621050,  59956199,   41683149,  0x2b2004b},
        {64828308,   38051240,  64904292,   38111359,  0x29c004b},
        {59906855,   42035750,  59990344,   42097849,  0x2b2004b},
        {54204373,   39602540,  54282027,   39662659,  0x29c004b},
        {55342504,   40744050,  55424095,   40806149,  0x2b2004b},
        {61622258,   37629940,  61697741,   37690059,  0x29c004b},
        {62303115,   37381550,  62381084,   37443649,  0x2b2004b},
        {63561423,   39139940,  63638576,   39200059,  0x29c004b},
        {56763712,   38698750,  56842888,   38760849,  0x2b2004b},
        {62898010,   35911800,  62988602,   35960800,  0x29c044b},
        {52553200,   41509050,  52635999,   41571149,  0x2b2004b},
        {60370009,   36845240,  60444991,   36905359,  0x29c004b},
        {54522000,   37500000,  59345000,   39420000,  0x0770011},
        {59345000,   36336000,  62921305,   38760595,  0x01c000d},
        {58090000,   40311505,  61840317,   42800000,  0x37d0015},
        {52430000,   35130000,  66684310,   42800000,  0x0010016},
        {-3750145,   40389490,  -3669855,   40450599,  0x2a7004a}, // ESP
        {2129600,    41369490,  2210400,    41430599,  0x2a7004a},
        {-3950167,   40147028,  -3340831,   40638068,  0x001000c},
        {-430758,    39436000,  -319043,    39522489,  0x3c1004b},
        {2015621,    41349900,  2129979,    41436389,  0x3c1004b},
        {2147621,    41393600,  2261979,    41480089,  0x3c1004b},
        {1969921,    41263400,  2084279,    41349889,  0x3c1004b},
        {2084221,    41283300,  2198579,    41369789,  0x3c1004b},
        {-6023396,   37349300,  -5914804,   37435789,  0x3c1004b},
        {-947660,    41606800,  -832341,    41693289,  0x3c1004b},
        {-4494775,   36672500,  -4387625,   36758989,  0x3c1004b},
        {-1181056,   37935000,  -1071744,   38021489,  0x3c1004b},
        {-3009600,   43230300,  -2872456,   43304789,  0x3c1044b},
        {-4799360,   41606000,  -4684041,   41692489,  0x3c1004b},
        {-538337,    38320300,  -428064,    38406789,  0x3c1004b},
        {-4820556,   37842700,  -4711244,   37929189,  0x3c1004b},
        {-8773040,   42185600,  -8656760,   42272089,  0x3c1004b},
        {-5733101,   43487100,  -5614899,   43573589,  0x3c1004b},
        {-3656936,   37128700,  -3549065,   37215189,  0x3c1004b},
        {-8469101,   43297700,  -8350899,   43384189,  0x3c1004b},
        {-2755321,   42816000,  -2638080,   42902489,  0x3c1004b},
        {-727156,    38228000,  -617844,    38314489,  0x3c1004b},
        {-5890401,   43346300,  -5772199,   43432789,  0x3c1004b},
        {-1021085,   37585550,  -943116,    37647649,  0x2b2004b},
        {-1690848,   42782440,  -1609353,   42842559,  0x29c004b},
        {2063400,    41514550,  2146199,    41576649,  0x2b2004b},
        {-6161641,   36654440,  -6087160,   36714559,  0x29c004b},
        {1971900,    41527750,  2054699,    41589849,  0x2b2004b},
        {2614973,    39550040,  2692627,    39610159,  0x29c004b},
        {-15481003,  28080750,  -15410797,  28142849,  0x2b2004b},
        {-16311951,  28426140,  -16243649,  28486259,  0x29c004b},
        {-2022435,   43288950,  -1888858,   43328300,  0x2b2044b},
        {-3868000,   43439940,  -3764312,   43487500,  0x29c044b},
        {-3731745,   42318950,  -3648256,   42381049,  0x2b2004b},
        {-2478091,   36808940,  -2403109,   36869059,  0x29c004b},
        {-100351,    39939150,  -19450,     40001249,  0x2b2004b},
        {-5697446,   40926740,  -5617955,   40986859,  0x29c004b},
        {-1913947,   38969850,  -1834253,   39031949,  0x2b2004b},
        {-6974142,   37226940,  -6898659,   37287059,  0x29c004b},
        {-2481945,   42413850,  -2398456,   42475949,  0x2b2004b},
        {-4665000,   36505000,  -4603676,   36577950,  0x29c044b},
        {-7008947,   38840450,  -6929253,   38902549,  0x2b2004b},
        {-4543266,   36578600,  -4478597,   36647791,  0x29c044b},
        {-5623490,   42561950,  -5539311,   42624049,  0x2b2004b},
        {-3825542,   37744540,  -3750059,   37804659,  0x29c004b},
        {-3046232,   36659405,  260569,     39340595,  0x001000d},
        {-9350000,   41807000,  -4812540,   43820000,  0x2e30015},
        {-4028489,   39658440,  -3424361,   40149480,  0x001008c},
        {1905628,    41252780,  2525380,    41743820,  0x001088c},
        {-758156,    39251780,  -159236,    39742820,  0x001108c},
        {-6241148,   37090680,  -5657852,   37581720,  0x001188c},
        {-1194672,   41404480,  -574920,    41895520,  0x001208c},
        {-4948540,   36461080,  -4370452,   36952120,  0x001288c},
        {-4370451,   36685000,  -3040000,   36890000,  0x00d308c},
        {-3214988,   42967580,  -2579612,   43458620,  0x001388c},
        {-5046372,   41403680,  -4426620,   41894720,  0x001408c},
        {-5054948,   37640380,  -4466444,   38131420,  0x001488c},
        {-3894648,   36926380,  -3311352,   37417420,  0x001508c},
        {-2878380,   42419080,  -2248212,   42910120,  0x001588c},
        {-1853388,   42468380,  -1218012,   42959420,  0x001608c},
        {-6443240,   36365780,  -5865152,   36856820,  0x001688c},
        {2338136,    39345980,  2942264,    39837020,  0x001708c},
        {-15843200,  27707380,  -15317192,  28198420,  0x001788c},
        {-16880400,  27982880,  -16354392,  28473920,  0x001808c},
        {-5734540,   35987080,  -5161660,   36478120,  0x001888c},
        {-2306288,   42910080,  -1670912,   43401120,  0x001908c},
        {-4108288,   43030180,  -3467704,   43521220,  0x001988c},
        {-3999880,   42104480,  -3369712,   42595520,  0x001a08c},
        {-352064,    39724480,  252064,     40215520,  0x001a88c},
        {-5977272,   40724480,  -5362728,   41215520,  0x001b08c},
        {-7358748,   37106480,  -6775452,   37597520,  0x001b88c},
        {-7130756,   38544680,  -6537044,   39035720,  0x001c08c},
        {-4089048,   37524480,  -3500544,   38015520,  0x001c88c},
        {858428,     40980180,  1478180,    41471220,  0x001d08c},
        {325328,     41374480,  945080,     41865520,  0x001d88c},
        {-6674256,   39224480,  -6075336,   39715520,  0x001e08c},
        {2621620,    41649480,  3246580,    42140520,  0x001e88c},
        {278373,     40383120,  892917,     40874160,  0x001f08c},
        {348000,     40191933,  3820000,    42873123,  0x0a90091},
        {-9722767,   41157162,  -6177638,   43838352,  0x0a80891},
        {-9839578,   38475972,  -6443404,   41157162,  0x0a91091},
        {-9979996,   35867000,  -6703000,   38475972,  0x0a61891},
        {-6177638,   41157162,  -2632509,   43838352,  0x0a82091},
        {-6443404,   38475972,  -3047230,   41157162,  0x0a92891},
        {-6703000,   35867000,  -3426000,   38475972,  0x0a63091},
        {-2632509,   41157162,  912620,     43500000,  0x09d3891},
        {-3047230,   38475972,  348000,     41157162,  0x0a94091},
        {-3426000,   35920000,  -300000,    38475972,  0x0a94891},
        {1033604,    37805405,  4399987,    40486595,  0x0a99891},
        {-18200000,  27600000,  -15950000,  30200000,  0x0c0c891},
        {-15950000,  27600000,  -13300000,  30200000,  0x0b17091},
        {-2970500,   35262000,  -2830000,   35323000,  0x07af091},
        {-31500000,  27500000,  4400000,    43850000,  0x0010217},
        {-18200000,  27500000,  4400000,    43850000,  0x003021c},
        {100485777,  13686800,  100574668,  13773289,  0x001000a}, // THA
        {100270732,  13502880,  100749868,  13993920,  0x001000c},
        {102725958,  17348890,  102854042,  17471199,  0x54f004b},
        {100920947,  13298390,  101046653,  13420699,  0x54f004b},
        {102031107,  14911090,  102157493,  15033399,  0x54f004b},
        {98941800,   18739090,  99064121,   18867700,  0x54f044b},
        {100426395,  6956800,   100513604,  7043289,   0x3c1004b},
        {100906500,  13138550,  100985401,  13235880,  0x3c1044b},
        {99436193,   18243000,  99527006,   18329489,  0x3c1004b},
        {102786954,  16391900,  102877046,  16478389,  0x3c1004b},
        {99285875,   9088300,   99373325,   9174789,   0x3c1004b},
        {99906495,   8381500,   99993704,   8467989,   0x3c1004b},
        {104817694,  15219400,  104907306,  15305889,  0x3c1004b},
        {100015554,  13776800,  100104445,  13863289,  0x3c1004b},
        {101234074,  12648000,  101322725,  12734489,  0x3c1004b},
        {100577054,  14041500,  100665945,  14127989,  0x3c1004b},
        {100224833,  16779700,  100315166,  16866189,  0x3c1004b},
        {100067494,  15662700,  100157106,  15749189,  0x3c1004b},
        {102068894,  12566800,  102157305,  12653289,  0x3c1004b},
        {100854974,  12874600,  100943625,  12961089,  0x3c1004b},
        {99775554,   13496800,  99864445,   13583289,  0x3c1004b},
        {101240215,  6506300,   101327184,  6592789,   0x3c1004b},
        {100571704,  7122500,   100642488,  7229000,   0x3c1044b},
        {98336395,   7836800,   98423604,   7923289,   0x3c1004b},
        {100525434,  14316800,  100614565,  14403289,  0x3c1004b},
        {99784113,   19866800,  99875887,   19953289,  0x3c1004b},
        {100872434,  14488200,  100961565,  14574689,  0x3c1004b},
        {100185254,  13494200,  100274145,  13580689,  0x3c1004b},
        {99486354,   13980400,  99575245,   14066889,  0x3c1004b},
        {99665575,   12369405,  102406347,  15050595,  0x0a80011},
        {98194000,   6618000,   100877000,  9340000,   0x001000d},
        {98670000,   17424000,  101165000,  20465250,  0x43d0015},
        {97330000,   5612500,   109500000,  23400000,  0x4720016},
        {97330000,   5612500,   105640000,  20465250,  0x003021c},
        {44162794,   15311755,  44252167,   15398245,  0x001000a}, // YEM
        {44029154,   15157020,  44386645,   15502979,  0xf040047},
        {44798769,   12743700,  45142030,   13078589,  0xe890047},
        {42923314,   14752200,  43012686,   14838689,  0x3c1004b},
        {43955554,   13545400,  44044445,   13631889,  0x3c1004b},
        {44044445,   13545400,  44133336,   13631889,  0x3c1004b},
        {49090134,   14509500,  49179265,   14595989,  0x3c1004b},
        {49167678,   14544095,  49256809,   14630584,  0x3c1004b},
        {44114154,   13915200,  44203045,   14001689,  0x3c1004b},
        {44291914,   15070000,  44381286,   15156489,  0x3c1004b},
        {43304934,   14161900,  43394065,   14248389,  0x3c1004b},
        {43230014,   15004400,  43319386,   15090889,  0x3c1004b},
        {44367434,   14493200,  44456565,   14579689,  0x3c1004b},
        {49564114,   14743500,  49653486,   14829989,  0x3c1004b},
        {44795434,   14386800,  44884565,   14473289,  0x3c1004b},
        {44093954,   13749100,  44182845,   13835589,  0x3c1004b},
        {43121714,   14793800,  43211086,   14880289,  0x3c1004b},
        {43894294,   15617000,  43983906,   15703489,  0x3c1004b},
        {44355734,   14249900,  44444865,   14336389,  0x3c1004b},
        {45530654,   13949700,  45619545,   14036189,  0x3c1004b},
        {48746974,   15904000,  48836826,   15990489,  0x3c1004b},
        {44076654,   13174500,  44165545,   13260989,  0x3c1004b},
        {44637854,   13819600,  44726745,   13906089,  0x3c1004b},
        {47018934,   14302000,  47108065,   14388489,  0x3c1004b},
        {51199914,   15185700,  51289286,   15272189,  0x3c1004b},
        {45656854,   13343700,  45745745,   13430189,  0x3c1004b},
        {45264354,   13166300,  45353245,   13252789,  0x3c1004b},
        {43571729,   15665250,  43636070,   15727349,  0x2b2004b},
        {43293622,   14488840,  43355578,   14548959,  0x29c004b},
        {42685329,   15673950,  42749670,   15736049,  0x2b2004b},
        {42978855,   15299940,  43041145,   15360059,  0x29c004b},
        {45285929,   15439350,  45350270,   15501449,  0x2b2004b},
        {45833905,   13858340,  45895694,   13918459,  0x29c004b},
        {43229688,   13285650,  43293512,   13347749,  0x2b2004b},
        {45337989,   13079840,  45399611,   13139959,  0x29c004b},
        {46805502,   14497650,  46869498,   14559749,  0x2b2004b},
        {44747371,   16148240,  44809828,   16208359,  0x29c004b},
        {43723170,   16913750,  43788029,   16975849,  0x2b2004b},
        {52156371,   16167340,  52218828,   16227459,  0x29c004b},
        {45659588,   13908650,  45723412,   13970749,  0x2b2004b},
        {44707105,   13686240,  44768894,   13746359,  0x29c004b},
        {42855536,   12573900,  45596308,   15255090,  0x0a80011},
        {42663682,   14879723,  45434245,   17560913,  0x001000d},
        {45596308,   13217385,  48337080,   15898575,  0x0010015},
        {41801000,   11985592,  54750366,   19000000,  0x0010016},
        {2274652,    48816755,  2405348,    48903245,  0x001000a}, // FRA
        {1991064,    48614480,  2694144,    49105520,  0x001000c},
        {4761980,    45672020,  4833435,    45821779,  0x3c1044b},
        {4833435,    45672020,  4904890,    45821779,  0x3c1044b},
        {4904890,    45672020,  4976345,    45821779,  0x3c1044b},
        {1355042,    43543890,  1439237,    43666199,  0x3c1044b},
        {1439237,    43543890,  1523432,    43666199,  0x3c1044b},
        {7219318,    43667800,  7338481,    43754289,  0x3c1004b},
        {5346399,    43266800,  5464601,    43353289,  0x3c1004b},
        {-1617265,   47170500,  -1491135,   47256989,  0x3c1004b},
        {7680933,    48536200,  7810667,    48622689,  0x3c1004b},
        {3810418,    43566800,  3929581,    43653289,  0x3c1004b},
        {-651863,    44794800,  -530538,    44881289,  0x3c1004b},
        {-1727166,   48066800,  -1598634,   48153289,  0x3c1004b},
        {65791,      49466300,  198408,     49552789,  0x3c1004b},
        {3959712,    49207700,  4090887,    49294189,  0x3c1004b},
        {3002250,    50596800,  3137750,    50683289,  0x3c1004b},
        {4329137,    45395000,  4451663,    45481489,  0x3c1004b},
        {5852199,    43069300,  5970401,    43155789,  0x3c1004b},
        {-609466,    47426800,  -482135,    47513289,  0x3c1004b},
        {5667837,    45135600,  5790363,    45222089,  0x3c1004b},
        {-4555967,   48359700,  -4426233,   48446189,  0x3c1004b},
        {147734,     47959600,  276266,     48046089,  0x3c1004b},
        {4979834,    47285300,  5107165,    47371789,  0x3c1004b},
        {5394365,    43506050,  5479234,    43568149,  0x2b2004b},
        {3047898,    45745540,  3133902,    45805659,  0x29c004b},
        {4316920,    43801950,  4402479,    43864049,  0x2b2004b},
        {2256007,    49860940,  2349192,    49921059,  0x29c004b},
        {644288,     47348950,  735712,     47411049,  0x2b2004b},
        {1217098,    45799740,  1303102,    45859859,  0x29c004b},
        {6137008,    49087750,  6231192,    49149849,  0x2b2004b},
        {5972145,    47216640,  6060654,    47276759,  0x29c004b},
        {-409092,    49150050,  -314908,    49212149,  0x2b2004b},
        {1860828,    47872640,  1950172,    47932759,  0x29c004b},
        {7293857,    47728950,  7386143,    47791049,  0x2b2004b},
        {2849252,    42669940,  2930747,    42730059,  0x29c004b},
        {1032390,    49408950,  1127609,    49471049,  0x2b2004b},
        {6130610,    48654840,  6220789,    48714959,  0x29c004b},
        {3124555,    50678550,  3221844,    50740649,  0x2b2004b},
        {-416482,    43278140,  -334319,    43338259,  0x29c004b},
        {295150,     46548950,  384849,     46611049,  0x2b2004b},
        {4766684,    43921140,  4849515,    43981259,  0x29c004b},
        {5027612,    43145780,  5668196,    43636820,  0x0010088},
        {4334796,    45373580,  4996212,    45864620,  0x0010888},
        {1061704,    43566980,  1707496,    44058020,  0x0011088},
        {6689412,    43329980,  7329996,    43821020,  0x0011888},
        {-1931020,   46956380,  -1248772,   47447420,  0x0012088},
        {7413764,    48454180,  8116844,    48945220,  0x0012888},
        {3460012,    43264480,  4100596,    43755520,  0x0013088},
        {-943104,    44589480,  -286896,    45080520,  0x0013888},
        {-2004028,   47864480,  -1311364,   48355520,  0x0014088},
        {-468944,    49099780,  239344,     49590820,  0x0014888},
        {2633248,    50254480,  3357160,    50745520,  0x0015088},
        {5650512,    42972180,  6285888,    43463220,  0x0015888},
        {-1048720,   47024480,  -366472,    47515520,  0x0016088},
        {5484496,    45119480,  6145912,    45610520,  0x0016888},
        {-4641728,   47950980,  -3949064,   48442020,  0x0017088},
        {-338928,    47737180,  353736,     48228220,  0x0017888},
        {4707580,    47082980,  5389828,    47574020,  0x0018088},
        {2765396,    45530080,  3426812,    46021120,  0x0018888},
        {4261004,    43575080,  4906796,    44066120,  0x0019088},
        {346480,     47031580,  1028728,    47522620,  0x0019888},
        {934596,     45584280,  1596012,    46075320,  0x001a088},
        {5835164,    48623880,  6538244,    49114920,  0x001a888},
        {5680480,    47001180,  6362728,    47492220,  0x001b088},
        {6761372,    47619480,  7448828,    48110520,  0x001b888},
        {2558620,    42453680,  3188788,    42944720,  0x001c088},
        {-470088,    43028580,  170496,     43519620,  0x001c888},
        {101580,     46449480,  778620,     46940520,  0x001d088},
        {-1513312,   45924480,  -846688,    46415520,  0x001d888},
        {1903340,    50612380,  2637668,    51103420,  0x001e088},
        {2739912,    43024480,  3380496,    43515520,  0x001e888},
        {-2833728,   47224480,  -2146272,   47715520,  0x001f088},
        {2054080,    46834480,  2736328,    47325520,  0x0b00090},
        {4636896,    44754480,  5293104,    45245520,  0x0b00890},
        {-3713728,   47494480,  -3026272,   47985520,  0x0b11090},
        {-803312,    46074480,  -136688,    46565520,  0x0b11890},
        {4370648,    49504480,  5089352,    49995520,  0x0b02090},
        {-2415036,   48235780,  -1711956,   48726820,  0x0b02890},
        {-1121128,   47824480,  -428464,    48315520,  0x0b13090},
        {-1778520,   46424480,  -1101480,   46915520,  0x0b03890},
        {5786688,    45664480,  6453312,    46155520,  0x0b14090},
        {4501480,    46544480,  5178520,    47035520,  0x0b04890},
        {1361480,    46564480,  2038520,    47055520,  0x0b05090},
        {1181896,    44914480,  1838104,    45405520,  0x0b05890},
        {8417520,    41684480,  9042480,    42175520,  0x0b06090},
        {1867104,    43524480,  2512896,    44015520,  0x0b06890},
        {4308564,    48564480,  5011644,    49055520,  0x0b07090},
        {1528840,    50499780,  2263168,    50990820,  0x0b07890},
        {2022312,    42974480,  2657688,    43465520,  0x0b08090},
        {-3116336,   48274480,  -2413256,   48765520,  0x0b08890},
        {-175504,    45414480,  485912,     45905520,  0x0b19090},
        {8969832,    42464480,  9600000,    42955520,  0x0b09890},
        {5803056,    49081980,  6511344,    49573020,  0x0b1a090},
        {4631788,    45904480,  5298412,    46395520,  0x0b1a890},
        {3078548,    50067380,  3802460,    50558420,  0x0b1b090},
        {-1830088,   43244480,  -1189504,   43735520,  0x0b0b890},
        {3757104,    43884480,  4402896,    44375520,  0x0b0c090},
        {4701212,    43319180,  5341796,    43810220,  0x0b0c890},
        {2246688,    46094480,  2913312,    46585520,  0x0b1d090},
        {2814080,    46754480,  3496328,    47245520,  0x0b0d890},
        {3736688,    45804480,  4403312,    46295520,  0x0b1e090},
        {5759704,    44324480,  6410704,    44815520,  0x0b0e890},
        {6098872,    47934480,  6791536,    48425520,  0x0b1f090},
        {356523,     47484449,  4288935,    50165639,  0x0a80011},
        {-5200000,   41310000,  9600000,    53557000,  0x0010016},
        {-5200000,   41310000,  9600000,    51100000,  0x003021c},
        {19474000,   59973000,  20400000,   60464000,  0x001000c}, // ALA
        {20400000,   59900000,  21118800,   60536000,  0x0e40010},
        {4490000,    54544000,  31600000,   68600000,  0x3770016},
        {19100000,   59675750,  21480000,   60671833,  0x003021c},
        {36798377,   -1311622,  36884867,   -1225132,  0x001000a}, // KEN
        {36694245,   -1500829,  37162965,   -1009789,  0x001000c},
        {39558535,   -4050300,  39645264,   -3963811,  0x3c1004b},
        {39645264,   -4078841,  39731993,   -3992352,  0x3c1004b},
        {36005155,   -336200,   36091644,   -249711,   0x3c1004b},
        {36091644,   -336200,   36178133,   -249711,   0x3c1004b},
        {34698155,   -133200,   34784644,   -46711,    0x3c1004b},
        {34784644,   -133200,   34871133,   -46711,    0x3c1004b},
        {34957155,   967300,    35043644,   1053789,   0x3c1004b},
        {34716955,   247900,    34803444,   334389,    0x3c1004b},
        {40051035,   -3263600,  40137764,   -3177111,  0x3c1004b},
        {36930255,   -467400,   37016744,   -380911,   0x3c1004b},
        {39615950,   -487850,   39678049,   -425751,   0x2b2004b},
        {34513140,   537040,    34573259,   597159,    0x29c004b},
        {37607850,   27650,     37669949,   89749,     0x2b2004b},
        {34460040,   307840,    34520159,   367959,    0x29c004b},
        {36415250,   -764150,   36477349,   -702051,   0x2b2004b},
        {40030640,   1718840,   40090759,   1778959,   0x29c004b},
        {34424450,   -571350,   34486549,   -509251,   0x2b2004b},
        {34439940,   -1100060,  34500059,   -1039941,  0x29c004b},
        {37031650,   -19450,    37093749,   42649,     0x2b2004b},
        {37426040,   -567460,   37486159,   -507341,   0x29c004b},
        {34070250,   432950,    34132349,   495049,    0x2b2004b},
        {41833957,   3910440,   41894243,   3970559,   0x29c004b},
        {39817164,   -3646850,  39879435,   -3584751,  0x2b2004b},
        {35254340,   -391260,   35314459,   -331141,   0x29c004b},
        {37227250,   -1545250,  37289349,   -1483151,  0x2b2004b},
        {37552840,   329040,    37612959,   389159,    0x29c004b},
        {34741350,   -702650,   34803449,   -640551,   0x2b2004b},
        {36337340,   3740,      36397459,   63859,     0x29c004b},
        {35835050,   -1120550,  35897149,   -1058451,  0x2b2004b},
        {35700240,   -282260,   35760359,   -222141,   0x29c004b},
        {37126350,   -757350,   37188449,   -695251,   0x2b2004b},
        {34733340,   579440,    34793459,   639559,    0x29c004b},
        {35079050,   172650,    35141149,   234749,    0x2b2004b},
        {40859740,   -2304360,  40919859,   -2244241,  0x29c004b},
        {35566150,   3094350,   35628249,   3156449,   0x2b2004b},
        {38537857,   -3417560,  38598143,   -3357441,  0x29c004b},
        {36660150,   1059050,   36722249,   1121149,   0x2b2004b},
        {37701640,   -1144060,  37761759,   -1083941,  0x29c004b},
        {35619850,   2347750,   35681949,   2409849,   0x2b2004b},
        {36349940,   -300060,   36410059,   -239941,   0x29c004b},
        {37227350,   -525850,   37289449,   -463751,   0x2b2004b},
        {39022457,   3499440,   39082743,   3559559,   0x29c004b},
        {37960050,   2309950,   38022149,   2372049,   0x2b2004b},
        {34556040,   -874560,   34616159,   -814441,   0x29c004b},
        {34244650,   45350,     34306749,   107449,    0x2b2004b},
        {35164140,   -182860,   35224259,   -122741,   0x29c004b},
        {37977750,   -1408550,  38039849,   -1346451,  0x2b2004b},
        {35064640,   1219040,   35124759,   1279159,   0x29c004b},
        {34599650,   -1215050,  34661749,   -1152951,  0x2b2004b},
        {36253240,   -1916160,  36313359,   -1856041,  0x29c004b},
        {37647064,   -3422150,  37709335,   -3360051,  0x2b2004b},
        {39615257,   -4128360,  39675543,   -4068241,  0x29c004b},
        {33905000,   -1339737,  36586190,   1341453,   0x0a80011},
        {36586190,   -1875974,  39267380,   805216,    0x001000d},
        {39401340,   -4231720,  39870060,   -3740680,  0x0b00890},
        {39672540,   -3653820,  40141260,   -3162780,  0x0b01090},
        {39412640,   -702320,   39881360,   -211280,   0x0b01890},
        {39769340,   1510780,   40238060,   2001820,   0x0b02090},
        {41458040,   3504580,   41926760,   3995620,   0x0b02890},
        {40655440,   -2519820,  41124160,   -2028780,  0x0b03090},
        {35362840,   2879880,   35831560,   3370920,   0x0b03890},
        {38333640,   -3633020,  38802360,   -3141980,  0x0b04090},
        {36576040,   799579,    37044760,   1290619,   0x0b04890},
        {35368440,   2123680,   35837160,   2614720,   0x0b05090},
        {38818740,   3090880,   39287460,   3581920,   0x0b05890},
        {37756740,   2095480,   38225460,   2586520,   0x0b06090},
        {36125640,   -1972520,  36594360,   -1481480,  0x0b06890},
        {37569540,   -3647720,  38038260,   -3156680,  0x0b07090},
        {39154940,   -4690820,  39623660,   -4199780,  0x0b07890},
        {33905000,   -4725000,  41930000,   5051500,   0x0010016},
        {25862911,   -24693245, 25957089,   -24606755, 0x001000a}, // BWA
        {25629288,   -24920072, 26139672,   -24429032, 0x001000c},
        {27456829,   -21236610, 27587971,   -21114301, 0x54f004b},
        {25450000,   -24435000, 25611046,   -24333401, 0x54f044b},
        {27780159,   -22034510, 27911641,   -21912201, 0x54f004b},
        {23370738,   -20054110, 23500861,   -19931801, 0x54f004b},
        {26638089,   -22458810, 26769911,   -22336501, 0x54f004b},
        {25286231,   -25027300, 25381369,   -24940811, 0x3c1004b},
        {26780452,   -23148400, 26874148,   -23061911, 0x3c1004b},
        {26092671,   -24434200, 26187328,   -24347711, 0x3c1004b},
        {25642091,   -25257800, 25737709,   -25171311, 0x3c1004b},
        {27080092,   -22585700, 27173308,   -22499211, 0x3c1004b},
        {25491871,   -24722400, 25586528,   -24635911, 0x3c1004b},
        {25370731,   -24823000, 25465869,   -24736511, 0x3c1004b},
        {27416532,   -21472100, 27509267,   -21385611, 0x3c1004b},
        {25543632,   -21463200, 25636367,   -21376711, 0x3c1004b},
        {26995472,   -20552400, 27087727,   -20465911, 0x3c1004b},
        {28373512,   -22013200, 28466487,   -21926711, 0x3c1004b},
        {27706112,   -21917000, 27799087,   -21830511, 0x3c1004b},
        {21593512,   -21743200, 21686487,   -21656711, 0x3c1004b},
        {25331532,   -21357400, 25424267,   -21270911, 0x3c1004b},
        {25128413,   -17852500, 25218986,   -17766011, 0x3c1004b},
        {26460452,   -23086800, 26554148,   -23000311, 0x3c1004b},
        {22357271,   -26069300, 22453129,   -25982811, 0x3c1004b},
        {24683271,   -24645800, 24777928,   -24559311, 0x3c1004b},
        {22121753,   -19421100, 22213047,   -19334611, 0x3c1004b},
        {24983291,   -24144500, 25077708,   -24058011, 0x3c1004b},
        {27165693,   -20172900, 27257707,   -20086411, 0x3c1004b},
        {25189402,   -22896564, 28019547,   -20215374, 0x001000d},
        {23180024,   -20242420, 23674784,   -19751380, 0x0b10090},
        {28170016,   -22215520, 28669984,   -21724480, 0x0b10890},
        {21390016,   -21945520, 21889984,   -21454480, 0x0b11090},
        {24933424,   -18257040, 25422976,   -17766000, 0x0b01890},
        {22151208,   -26275820, 22666800,   -25784780, 0x0b12090},
        {21925224,   -19623420, 22419984,   -19132380, 0x0b02890},
        {26787324,   -20417220, 27282084,   -19926180, 0x0b13090},
        {24258624,   -18427220, 24748176,   -17936180, 0x0b13890},
        {21713524,   -18771720, 22203076,   -18280680, 0x0b14090},
        {22463824,   -20715320, 22958584,   -20224280, 0x0b14890},
        {22547916,   -23927120, 23053092,   -23436080, 0x0b15090},
        {23541408,   -24798620, 24051792,   -24307580, 0x0b15890},
        {21517608,   -24241020, 22027992,   -23749980, 0x0b06090},
        {24036491,   -25577754, 26926218,   -22896564, 0x0a90011},
        {19980000,   -26909000, 29380000,   -17766000, 0x0010016},
        {47512220,   -18964346, 47603514,   -18877857, 0x001000a}, // MDG
        {47264068,   -19166620, 47753620,   -18675580, 0x001000c},
        {49340993,   -18166300, 49431806,   -18079811, 0x3c1004b},
        {49322830,   -18252789, 49413643,   -18166300, 0x3c1004b},
        {47007113,   -19908000, 47098887,   -19821511, 0x3c1004b},
        {47052232,   -21487700, 47144967,   -21401211, 0x3c1004b},
        {43639232,   -23400800, 43733168,   -23314311, 0x3c1004b},
        {48192754,   -13421600, 48281645,   -13335111, 0x3c1004b},
        {46284694,   -15745000, 46374306,   -15658511, 0x3c1004b},
        {49258760,   -12328250, 49322239,   -12266151, 0x2b2004b},
        {47303303,   -19698360, 47367096,   -19638241, 0x29c004b},
        {46051745,   -25207550, 46120054,   -25145451, 0x2b2004b},
        {48186021,   -17617060, 48248979,   -17556941, 0x29c004b},
        {46936445,   -25056550, 47004754,   -24994451, 0x2b2004b},
        {48387421,   -17855660, 48450379,   -17795541, 0x29c004b},
        {46705725,   -19201150, 46771274,   -19139051, 0x2b2004b},
        {49736071,   -16206760, 49798528,   -16146641, 0x29c004b},
        {48490980,   -20613250, 48557219,   -20551151, 0x2b2004b},
        {48763103,   -19934260, 48826896,   -19874141, 0x29c004b},
        {49542470,   -16954150, 49607329,   -16892051, 0x2b2004b},
        {44261420,   -20318260, 44325380,   -20258141, 0x29c004b},
        {47972435,   -22170950, 48039364,   -22108851, 0x2b2004b},
        {46910170,   -19431360, 46973629,   -19371241, 0x29c004b},
        {46361145,   -25070450, 46429454,   -25008351, 0x2b2004b},
        {50236238,   -14928060, 50298361,   -14867941, 0x29c004b},
        {49163284,   -17498250, 49228315,   -17436151, 0x2b2004b},
        {47338386,   -22028060, 47403014,   -21967941, 0x29c004b},
        {50120702,   -14293950, 50184698,   -14231851, 0x2b2004b},
        {47338020,   -20270060, 47401980,   -20209941, 0x29c004b},
        {48419688,   -13704150, 48483512,   -13642051, 0x2b2004b},
        {47207936,   -20560060, 47272063,   -20499941, 0x29c004b},
        {44336104,   -23751050, 44403895,   -23688951, 0x2b2004b},
        {47778270,   -18950060, 47841729,   -18889941, 0x29c004b},
        {46632243,   -16136250, 46696757,   -16074151, 0x2b2004b},
        {45450567,   -25349160, 45517032,   -25289041, 0x29c004b},
        {46896622,   -21861050, 46963378,   -21798951, 0x2b2004b},
        {46823503,   -19869260, 46887296,   -19809141, 0x29c004b},
        {48299708,   -21267150, 48366292,   -21205051, 0x2b2004b},
        {47398270,   -19410060, 47461729,   -19349941, 0x29c004b},
        {48187225,   -18971050, 48252774,   -18908951, 0x2b2004b},
        {46767936,   -20580060, 46832063,   -20519941, 0x29c004b},
        {46007312,   -18801050, 46072688,   -18738951, 0x2b2004b},
        {44477602,   -22320060, 44542397,   -22259941, 0x29c004b},
        {44705845,   -24731050, 44774154,   -24668951, 0x2b2004b},
        {47780935,   -22850060, 47846064,   -22789941, 0x29c004b},
        {48177553,   -19466150, 48243447,   -19404051, 0x2b2004b},
        {48104220,   -20079460, 48168180,   -20019341, 0x29c004b},
        {47565777,   -23373950, 47633223,   -23311851, 0x2b2004b},
        {44515203,   -19729960, 44578996,   -19669841, 0x29c004b},
        {45023645,   -25203150, 45091954,   -25141051, 0x2b2004b},
        {49710155,   -15456660, 49772445,   -15396541, 0x29c004b},
        {46677657,   -16501050, 46742343,   -16438951, 0x2b2004b},
        {44487435,   -22950060, 44552564,   -22889941, 0x29c004b},
        {49618002,   -14691050, 49681998,   -14628951, 0x2b2004b},
        {47958938,   -14910060, 48021061,   -14849941, 0x29c004b},
        {45427653,   -19567050, 45493547,   -19504951, 0x2b2004b},
        {49378521,   -17410060, 49441479,   -17349941, 0x29c004b},
        {46199823,   -21090595, 49000177,   -18409405, 0x0a90011},
        {49000000,   -18500000, 50500000,   -13800000, 0x037000d},
        {46770811,   -21876650, 47270779,   -21385610, 0x0b10090},
        {43438825,   -23603075, 43944001,   -23112035, 0x0b10890},
        {46253761,   -16142900, 46738105,   -15651860, 0x0b01890},
        {45988007,   -25353470, 46503599,   -24862430, 0x0b02890},
        {48073429,   -17951820, 48562981,   -17460780, 0x0b03090},
        {49058739,   -12542720, 49532667,   -12051680, 0x0b12090},
        {48098567,   -13765150, 48577703,   -13274110, 0x0b11090},
        {45017747,   -25490625, 45533339,   -24999585, 0x0b06090},
        {46718007,   -25271020, 47233599,   -24779980, 0x0b03890},
        {44051233,   -20533720, 44545993,   -20042680, 0x0b14090},
        {47755911,   -22385420, 48255879,   -21894380, 0x0b14890},
        {47120721,   -22243520, 47620689,   -21752480, 0x0b15090},
        {44122615,   -23965520, 44627791,   -23474480, 0x0b15890},
        {48083021,   -21481620, 48582989,   -20990580, 0x0b16890},
        {45795229,   -19015520, 46284781,   -18524480, 0x0b17090},
        {44262615,   -22535520, 44767791,   -22044480, 0x0b07890},
        {44484803,   -24945520, 44995187,   -24454480, 0x0b18090},
        {47566115,   -23065520, 48071291,   -22574480, 0x0b18890},
        {47352125,   -23588420, 47857301,   -23097380, 0x0b19090},
        {44304923,   -19945420, 44799683,   -19454380, 0x0b19890},
        {46473041,   -16715519, 46957385,   -16224479, 0x0b1a090},
        {44272615,   -23165520, 44777791,   -22674480, 0x0b1a890},
        {47750427,   -15125520, 48229563,   -14634480, 0x0b1b090},
        {45218433,   -19781520, 45713193,   -19290480, 0x0b0b890},
        {43150016,   -22305520, 43649984,   -21814480, 0x0b1c090},
        {43210000,   -25610000, 50500000,   -11930000, 0x0010016},
        {42000000,   -27000000, 54600000,   -9000000,  0x0010217},
        {30438530,   50402055,  30574031,   50488545,  0x001000a}, // UKR
        {30286000,   50324400,  30716635,   50539700,  0xa9e0447},
        {36077520,   49858490,  36456680,   50103109,  0xa9e0047},
        {34802935,   48344790,  35169864,   48589409,  0xa9e0047},
        {37656000,   47908610,  38053905,   48104000,  0x9ee0447},
        {30649435,   46437700,  30774364,   46524189,  0x3c1004b},
        {30649435,   46351211,  30774364,   46437700,  0x3c1004b},
        {37470700,   47028450,  37565986,   47142800,  0x3c1044b},
        {37565986,   47085400,  37696972,   47168600,  0x3c1044b},
        {35125734,   47779800,  35254266,   47866289,  0x3c1004b},
        {23956691,   49794800,  24089308,   49881289,  0x3c1004b},
        {33315734,   47866800,  33444266,   47953289,  0x3c1004b},
        {31933935,   46932000,  32080671,   47006260,  0x3c1044b},
        {39256800,   48534300,  39406919,   48608920,  0x3c1044b},
        {34039337,   44906800,  34160662,   44993289,  0x3c1004b},
        {28391000,   49200000,  28545653,   49273289,  0x3c1044b},
        {33424700,   44556800,  33591782,   44619000,  0x3c1044b},
        {34469500,   49550000,  34620747,   49625700,  0x3c1044b},
        {32537535,   46613000,  32681444,   46688000,  0x3c1044b},
        {31225600,   51467500,  31377782,   51546200,  0x3c1044b},
        {34711529,   50876800,  34848470,   50963289,  0x3c1044b},
        {31994700,   49364700,  32111999,   49462400,  0x3c1044b},
        {37979900,   48264000,  38121379,   48343289,  0x3c1044b},
        {28594100,   50224000,  28752152,   50297300,  0x3c1044b},
        {26182250,   50580800,  26336785,   50656500,  0x3c1044b},
        {26933691,   49376800,  27066308,   49463289,  0x3c1044b},
        {32195133,   48456800,  32324867,   48543289,  0x3c1044b},
        {34555133,   48477900,  34726582,   48543289,  0x3c1044b},
        {25865133,   48256800,  25994867,   48343289,  0x3c1044b},
        {33373000,   49008000,  33480697,   49113289,  0x3c1044b},
        {25538200,   49503900,  25652601,   49604000,  0x3c1044b},
        {24644412,   48876800,  24775587,   48963289,  0x3c1044b},
        {25266360,   50706800,  25405103,   50791200,  0x3c1044b},
        {30028800,   49766000,  30201161,   49832500,  0x3c1044b},
        {37503700,   48688200,  37621959,   48783000,  0x3c1044b},
        {35306935,   46803880,  35426502,   46895000,  0x3c1044b},
        {35790585,   46773826,  39693206,   49455016,  0x0a80011},
        {28277433,   48970645,  32329009,   51651835,  0x001000d},
        {23545500,   47912870,  27140757,   50847000,  0x4220015},
        {22135720,   44386383,  40227172,   52379475,  0x0010016},
        {31533700,   4803300,   31623116,   4887600,   0x01e000a}, // SSD
        {31350640,   4600480,   31819360,   5091520,   0x001000c},
        {31584680,   9464120,   31736519,   9613879,   0x680004b},
        {27919496,   7628120,   28070503,   7777879,   0x680004b},
        {32406512,   3759720,   32556687,   3909479,   0x680004b},
        {28319912,   4497120,   28470087,   4646879,   0x680004b},
        {30602912,   4020120,   30753087,   4169879,   0x680004b},
        {27343066,   8706090,   27466734,   8828399,   0x54f004b},
        {28038166,   8471890,   28161834,   8594199,   0x54f004b},
        {29629506,   6740890,   29752494,   6863199,   0x54f004b},
        {33005066,   8551490,   33128734,   8673799,   0x54f004b},
        {30428506,   6488890,   30551494,   6611199,   0x54f004b},
        {31516006,   6169090,   31638994,   6291399,   0x54f004b},
        {32065496,   9826490,   32189503,   9948799,   0x54f004b},
        {32748756,   11684990,  32873443,   11807299,  0x54f004b},
        {30236905,   3683069,   32918095,   6364259,   0x0a80011},
        {27287596,   6498319,   29968786,   9179509,   0x001000d},
        {31428839,   9293479,   31902767,   9784519,   0x0b00890},
        {28160635,   4326479,   28629355,   4817519,   0x0b01890},
        {32832545,   8367124,   33301265,   8858164,   0x0b12090},
        {30255645,   6304524,   30724365,   6795564,   0x0b12890},
        {31895739,   9642124,   32369667,   10133164,  0x0b03090},
        {32579339,   11500624,  33053267,   11991664,  0x0b13890},
        {23400000,   3480000,   36000000,   12250000,  0x0900012},
        {21810000,   9342000,   38630000,   23200000,  0x3580016},
        {-19000000,  -47500000, 60000000,   37550000,  0x3e50217},
        {23400000,   3480000,   36000000,   12250000,  0x003021c},
        {18504835,   4317755,   18548785,   4402723,   0x2a7044a}, // CAF
        {18548785,   4344956,   18592194,   4431049,   0x2a7044a},
        {18217521,   4115480,   18686241,   4606520,   0x001000c},
        {17916835,   3829200,   18003564,   3915689,   0x3c1004b},
        {15734935,   4214900,   15821664,   4301389,   0x3c1004b},
        {19143395,   6946800,   19230604,   7033289,   0x3c1004b},
        {16336515,   6275800,   16423484,   6362289,   0x3c1004b},
        {15822635,   4897800,   15909364,   4984289,   0x3c1004b},
        {19060415,   5691400,   19147384,   5777889,   0x3c1004b},
        {20616815,   5718400,   20703784,   5804889,   0x3c1004b},
        {21942515,   6498800,   22029484,   6585289,   0x3c1004b},
        {15568915,   5900600,   15655884,   5987089,   0x3c1004b},
        {17408015,   6464600,   17494984,   6551089,   0x3c1004b},
        {22773635,   4707100,   22860364,   4793589,   0x3c1004b},
        {15996635,   3476800,   16083364,   3563289,   0x3c1004b},
        {23875335,   4944300,   23962064,   5030789,   0x3c1004b},
        {21157715,   6208700,   21244684,   6295189,   0x3c1004b},
        {21822535,   4559500,   21909264,   4645989,   0x3c1004b},
        {21166635,   5006800,   21253364,   5093289,   0x3c1004b},
        {15596395,   6946800,   15683604,   7033289,   0x3c1004b},
        {22211235,   4579200,   22297964,   4665689,   0x3c1004b},
        {20623995,   8352500,   20711204,   8438989,   0x3c1004b},
        {18656635,   4916800,   18743364,   5003289,   0x3c1004b},
        {14786515,   5756800,   14873484,   5843289,   0x3c1004b},
        {17062315,   5266100,   17149284,   5352589,   0x3c1004b},
        {22489635,   4283200,   22576364,   4369689,   0x3c1004b},
        {25083435,   4986200,   25170164,   5072689,   0x3c1004b},
        {15102235,   4071500,   15188964,   4157989,   0x3c1004b},
        {15908415,   5653000,   15995384,   5739489,   0x3c1004b},
        {18166535,   4648100,   18253264,   4734589,   0x3c1004b},
        {19943335,   4975200,   20030064,   5061689,   0x3c1004b},
        {18520535,   3603300,   18607264,   3689789,   0x3c1004b},
        {21155364,   4302550,   21217635,   4364649,   0x2b2004b},
        {26457773,   5368840,   26518226,   5428959,   0x29c004b},
        {22758433,   10253350,  22821567,   10315449,  0x2b2004b},
        {22369690,   8039940,   22430310,   8100059,   0x29c004b},
        {16159405,   3473900,   18840595,   6155090,   0x0a80011},
        {20373900,   4116652,   23055090,   6797842,   0x001000d},
        {15543935,   4012624,   16012655,   4503664,   0x0b00090},
        {18952635,   6744524,   19421355,   7235564,   0x0b10890},
        {16145635,   6073524,   16614355,   6564564,   0x0b11090},
        {15631635,   4695524,   16100355,   5186564,   0x0b01890},
        {18869535,   5489124,   19338255,   5980164,   0x0b12090},
        {15547785,   5574524,   16016505,   6065564,   0x0b12890},
        {17217135,   6262324,   17685855,   6753364,   0x0b13090},
        {15805635,   3274524,   16274355,   3765564,   0x0b03890},
        {23684335,   4742024,   24153055,   5233064,   0x0b04090},
        {15405635,   6744524,   15874355,   7235564,   0x0b14890},
        {20433235,   8150224,   20901955,   8641264,   0x0b15090},
        {14595635,   5554524,   15064355,   6045564,   0x0b15890},
        {24892435,   4783924,   25361155,   5274964,   0x0b06090},
        {14911235,   3869224,   15379955,   4360264,   0x0b06890},
        {19752335,   4772924,   20221055,   5263964,   0x0b07090},
        {26253635,   5153379,   26722355,   5644419,   0x0b07890},
        {22558249,   10038879,  23032177,   10529919,  0x0b18090},
        {22165645,   7824478,   22634365,   8315518,   0x0b18890},
        {14400000,   2210000,   27467000,   11017950,  0x0010016},
        {45300755,   2014460,   45345574,   2097542,   0x2a7044a}, // SOM
        {45345574,   2034700,   45392283,   2114560,   0x2a7044a},
        {44997395,   1854066,   45466115,   2345106,   0x001000c},
        {44018997,   9511446,   44106687,   9597935,   0x3c1004b},
        {44969235,   10390800,  45057165,   10477289,  0x3c1004b},
        {42487602,   -389980,   42574091,   -303491,   0x3c1004b},
        {44716755,   1676800,   44803244,   1763289,   0x3c1004b},
        {42706755,   36800,     42793244,   123289,    0x3c1004b},
        {43606755,   3070800,   43693244,   3157289,   0x3c1004b},
        {42503682,   3755511,   42590411,   3842000,   0x3c1004b},
        {45490155,   9478800,   45577845,   9565289,   0x3c1004b},
        {49141815,   11221600,  49229985,   11308089,  0x3c1004b},
        {47387515,   6726800,   47474484,   6813289,   0x3c1004b},
        {45163735,   4696901,   45250464,   4783390,   0x3c1004b},
        {45457328,   2732236,   45543817,   2818725,   0x3c1004b},
        {42236755,   2296800,   42323244,   2383289,   0x3c1004b},
        {44498950,   1758950,   44561049,   1821049,   0x2b2004b},
        {48454090,   8375140,   48514710,   8435259,   0x29c004b},
        {49054319,   9475150,   49117280,   9537249,   0x2b2004b},
        {47336939,   10584840,  47398060,   10644959,  0x29c004b},
        {42729650,   484350,    42791749,   546449,    0x2b2004b},
        {47331506,   8439440,   47392293,   8499559,   0x29c004b},
        {43155219,   9905650,   43218180,   9967749,   0x2b2004b},
        {44049940,   2769940,   44110059,   2830059,   0x29c004b},
        {43996650,   1097950,   44058749,   1160049,   0x2b2004b},
        {47149857,   3819940,   47210143,   3880059,   0x29c004b},
        {42026364,   4146450,   42088635,   4208549,   0x2b2004b},
        {44859940,   2589940,   44920059,   2650059,   0x29c004b},
        {44482664,   3980450,   44544935,   4042549,   0x2b2004b},
        {44804240,   1946440,   44864359,   2006559,   0x29c004b},
        {49787092,   7949350,   49849708,   8011449,   0x2b2004b},
        {45534757,   3824240,   45595043,   3884359,   0x29c004b},
        {42946650,   2376750,   43008749,   2438849,   0x2b2004b},
        {49859056,   11430540,  49920344,   11490659,  0x29c004b},
        {50778519,   9468950,   50841480,   9531049,   0x2b2004b},
        {42191457,   3299440,   42251743,   3359559,   0x29c004b},
        {42039950,   481550,    42102049,   543649,    0x2b2004b},
        {51019356,   11819940,  51080644,   11880059,  0x29c004b},
        {51227933,   10395050,  51291067,   10457149,  0x2b2004b},
        {43861057,   4092940,   43921343,   4153059,   0x29c004b},
        {45502250,   2940650,   45564349,   3002749,   0x2b2004b},
        {48489773,   5319940,   48550226,   5380059,   0x29c004b},
        {46478778,   5718950,   46541222,   5781049,   0x2b2004b},
        {45029606,   9379940,   45090393,   9440059,   0x29c004b},
        {46588564,   4654650,   46650835,   4716749,   0x2b2004b},
        {45559857,   3359940,   45620143,   3420059,   0x29c004b},
        {42424150,   1609750,   42486249,   1671849,   0x2b2004b},
        {43441256,   11314840,  43502544,   11374959,  0x29c004b},
        {48148347,   11118950,  48211653,   11181049,  0x2b2004b},
        {51019356,   11239940,  51080644,   11300059,  0x29c004b},
        {43208864,   3788950,   43271135,   3851049,   0x2b2004b},
        {42999857,   4499940,   43060143,   4560059,   0x29c004b},
        {43125195,   1005703,   45806385,   3686893,   0x0a80011},
        {44826740,   9180180,   45300668,   9671220,   0x0010088},
        {43831040,   9309180,   44304968,   9800220,   0x0010888},
        {44798640,   10063080,  45272568,   10554120,  0x0011088},
        {42260740,   -620520,   42729460,   -129480,   0x0011888},
        {42515640,   -165520,   42984360,   325520,    0x0012088},
        {42312640,   3553180,   42781360,   4044220,   0x0012888},
        {45302240,   9276480,   45776168,   9767520,   0x0013088},
        {48947240,   10837980,  49421168,   11329020,  0x0013888},
        {47196640,   6524480,   47665360,   7015520,   0x0014088},
        {44972740,   4494580,   45441460,   4985620,   0x0014888},
        {42045640,   2094480,   42514360,   2585520,   0x0015088},
        {48250040,   8159680,   48718760,   8650720,   0x0015888},
        {48854040,   9260680,   49327968,   9751720,   0x0016088},
        {46953440,   10563880,  47427368,   11054920,  0x0016888},
        {42439040,   310580,    42907760,   801620,    0x0017088},
        {47127540,   8223980,   47596260,   8715020,   0x0017888},
        {43095240,   9572080,   43569168,   10063120,  0x0018088},
        {46945640,   3604480,   47414360,   4095520,   0x0018888},
        {41823140,   3931980,   42291860,   4423020,   0x0019088},
        {44279440,   3765980,   44748160,   4257020,   0x0019888},
        {49584040,   7734880,   50052760,   8225920,   0x001a088},
        {45316040,   3658780,   45784760,   4149820,   0x001a888},
        {42696240,   2256380,   43164960,   2747420,   0x001b088},
        {49655340,   11058880,  50129268,   11549920,  0x001b888},
        {50394040,   9316680,   50867968,   9807720,   0x001c088},
        {42061140,   3073480,   42529860,   3564520,   0x001c888},
        {41836640,   267079,    42305360,   758119,    0x001d088},
        {50870000,   10300000,  51421968,   10696000,  0x019d888},
        {43656840,   3877480,   44125560,   4368520,   0x001e088},
        {48246340,   5127780,   48715060,   5618820,   0x001e888},
        {50673000,   11651520,  51302000,   12000000,  0x016f088},
        {41800000,   -700000,   43125195,   4720970,   0x7970015},
        {40970000,   -1680000,  51460000,   12000000,  0x0010016},
        {69118106,   34486755,  69221894,   34573245,  0x001000a}, // AFG
        {68960983,   34357020,  69379017,   34702979,  0xf040047},
        {65533518,   31466300,  65926082,   31801189,  0xe890047},
        {67046725,   36668300,  67153875,   36754789,  0x3c1004b},
        {67153875,   36668300,  67261025,   36754789,  0x3c1004b},
        {69117506,   34976800,  69222494,   35063289,  0x3c1004b},
        {62129246,   34304200,  62233753,   34390689,  0x3c1004b},
        {62233753,   34304200,  62338260,   34390689,  0x3c1004b},
        {70392246,   34383500,  70496753,   34469989,  0x3c1004b},
        {70505564,   37075200,  70613435,   37161689,  0x3c1004b},
        {70157006,   34622800,  70261994,   34709289,  0x3c1004b},
        {63085306,   34935300,  63190294,   35021789,  0x3c1004b},
        {68688685,   36157500,  68795114,   36243989,  0x3c1004b},
        {68812525,   36680700,  68919675,   36767189,  0x3c1004b},
        {71077406,   34850500,  71182394,   34936989,  0x3c1004b},
        {69184606,   33556100,  69288393,   33642589,  0x3c1004b},
        {65197746,   34476800,  65302253,   34563289,  0x3c1004b},
        {69031525,   36642600,  69138675,   36729089,  0x3c1004b},
        {64736885,   35873300,  64843314,   35959789,  0x3c1004b},
        {66816964,   36705200,  66924835,   36791689,  0x3c1004b},
        {68376767,   33515600,  68479833,   33602089,  0x3c1004b},
        {68664360,   35915300,  68705890,   36029250,  0x2b2044b},
        {67679559,   36666640,  67754040,   36726759,  0x29c004b},
        {65731033,   36632450,  65807967,   36694549,  0x2b2004b},
        {68912578,   34545940,  68985222,   34606059,  0x29c004b},
        {62077630,   32362450,  62150769,   32424549,  0x2b2004b},
        {65079309,   36903440,  65154291,   36963559,  0x29c004b},
        {64335103,   31560750,  64407897,   31622849,  0x2b2004b},
        {68743678,   34419940,  68816322,   34480059,  0x29c004b},
        {69492759,   36715950,  69601528,   36760059,  0x2b2044b},
        {67466511,   34769540,  67539489,   34829659,  0x29c004b},
        {66891930,   32070150,  66965069,   32132249,  0x2b2004b},
        {61818181,   30925640,  61887819,   30985759,  0x29c004b},
        {68874374,   37151150,  68951825,   37213249,  0x2b2004b},
        {61449878,   34326140,  61522522,   34386259,  0x29c004b},
        {61152909,   34617650,  61228290,   34679749,  0x2b2004b},
        {68357909,   36966740,  68432891,   37026859,  0x29c004b},
        {68905340,   33925250,  68979859,   33987349,  0x2b2004b},
        {68983928,   33988140,  69056071,   34048259,  0x29c004b},
        {69032040,   33907750,  69106559,   33969849,  0x2b2004b},
        {69771358,   37360340,  69846841,   37420459,  0x29c004b},
        {69869599,   33315150,  69943600,   33377249,  0x2b2004b},
        {69943300,   33322350,  70014942,   33382469,  0x29c004b},
        {62113399,   33285750,  62187400,   33347849,  0x2b2004b},
        {66733609,   36991140,  66808591,   37051259,  0x29c004b},
        {66141574,   36879250,  66219025,   36941349,  0x2b2004b},
        {69222811,   34904440,  69295789,   34964559,  0x29c004b},
        {67433184,   33019286,  70591030,   35700476,  0x0a90011},
        {66050000,   35700000,  70700000,   37500000,  0x015000d},
        {61952523,   34101924,  62514987,   34592964,  0x0b10090},
        {62859177,   34733024,  63426849,   35224064,  0x0b00890},
        {70851267,   34648224,  71418939,   35139264,  0x0b01090},
        {64968763,   34274524,  65531227,   34765564,  0x0b11890},
        {64503654,   35671024,  65076534,   36162064,  0x0b12090},
        {65485659,   36417979,  66063747,   36909019,  0x0b12890},
        {61838171,   32147979,  62390219,   32639019,  0x0b03090},
        {64832969,   36687979,  65411057,   37179019,  0x0b13890},
        {64103293,   31346279,  64650133,   31837319,  0x0b04090},
        {66660283,   31855679,  67207123,   32346719,  0x0b14890},
        {61690510,   30710080,  62232142,   31201120,  0x0b05090},
        {61056483,   34257424,  61618947,   34748464,  0x0b15890},
        {61876975,   33071279,  62434231,   33562319,  0x0b06090},
        {64912143,   31879220,  65458983,   32370260,  0x0b16890},
        {65458984,   31879220,  66005824,   32370260,  0x0b17090},
        {66005824,   31879220,  66552664,   32370260,  0x0b17890},
        {64912144,   31388180,  65458984,   31879220,  0x0b08890},
        {65458984,   31388180,  66005824,   31879220,  0x0b09090},
        {66005824,   31388180,  66552664,   31879220,  0x0b09890},
        {64912144,   30897140,  65453776,   31388180,  0x0b0a890},
        {65453776,   30897140,  65995408,   31388180,  0x0b0b090},
        {65995408,   30897140,  66537040,   31388180,  0x0b0b890},
        {63128537,   31917887,  63675377,   32408927,  0x0b1e090},
        {66293170,   34156857,  66855634,   34647897,  0x0b1f090},
        {60478400,   29377450,  74900000,   38483500,  0x0010016},
        {96117194,   16766055,  96206567,   16852545,  0x001000a}, // MMR
        {96012010,   16737630,  96310790,   17024459,  0xc730047},
        {95920637,   21823990,  96214562,   22097409,  0xbde0047},
        {96035700,   19617500,  96290875,   19928300,  0xbde0447},
        {97610954,   16429800,  97701046,   16516289,  0x3c1004b},
        {96433533,   17273000,  96523866,   17359489,  0x3c1004b},
        {94690354,   16743500,  94780446,   16829989,  0x3c1004b},
        {95096500,   22078200,  95175554,   22180000,  0x3c1044b},
        {92822293,   20113000,  92911626,   20202000,  0x3c1044b},
        {95817772,   20832500,  95910027,   20918989,  0x3c1044b},
        {98569894,   12409700,  98672749,   12484000,  0x3c1044b},
        {96968672,   20734500,  97060927,   20820989,  0x3c1044b},
        {98162054,   14048100,  98250945,   14134589,  0x3c1044b},
        {97703252,   22907300,  97796948,   22993789,  0x3c1044b},
        {95210973,   18780000,  95302026,   18866489,  0x3c1044b},
        {95344732,   21418800,  95437467,   21505289,  0x3c1044b},
        {95409213,   17601100,  95499786,   17687589,  0x3c1044b},
        {96418712,   21983300,  96511687,   22069789,  0x3c1044b},
        {95039732,   21311800,  95132467,   21398289,  0x3c1044b},
        {97335000,   16880000,  97390741,   17019900,  0x3c1044b},
        {94846093,   20407000,  94938107,   20493489,  0x3c1044b},
        {96391653,   18886000,  96482947,   18972489,  0x3c1044b},
        {94916000,   20100000,  95004855,   20189500,  0x3c1044b},
        {97673274,   16226200,  97748821,   16328900,  0x3c1044b},
        {96677093,   17928000,  96789925,   17997489,  0x3c1044b},
        {94762272,   20870000,  94872863,   20942089,  0x3c1044b},
        {95646292,   22524900,  95739508,   22611389,  0x3c1044b},
        {96400000,   22892000,  96547126,   22947000,  0x3c1044b},
        {97341000,   25335000,  97432439,   25425300,  0x3c1044b},
        {99573632,   21246800,  99691168,   21315000,  0x3c1044b},
        {95355074,   16246800,  95444926,   16333289,  0x3c1044b},
        {95635074,   16246800,  95724926,   16333289,  0x3c1044b},
        {95493993,   19966800,  95586007,   20053289,  0x3c1044b},
        {95162000,   19286800,  95230399,   19402000,  0x3c1044b},
        {94833993,   20136800,  94926007,   20223289,  0x3c1004b},
        {94791014,   15668000,  97764000,   18149895,  0x09c0011},
        {94207110,   18149895,  97007464,   20831085,  0x001000d},
        {94177319,   20831085,  97037255,   23512275,  0x0010015},
        {92170000,   9570000,   101176790,  28550000,  0x55c0016},
        {28246794,   -15463245, 28336167,   -15376755, 0x001000a}, // ZMB
        {28164774,   -15542310, 28418226,   -15297691, 0xa9e0047},
        {28077233,   -12936110, 28327967,   -12691491, 0xa9e0047},
        {28515433,   -13105110, 28766167,   -12860491, 0xa9e0047},
        {28327915,   -14552190, 28563684,   -14323411, 0x9ee0047},
        {27824394,   -12600800, 27912805,   -12514311, 0x3c1004b},
        {28183600,   -12585400, 28288295,   -12512440, 0x3c1044b},
        {28355354,   -13185530, 28453958,   -13107660, 0x3c1044b},
        {25807313,   -17889600, 25897886,   -17803111, 0x3c1004b},
        {31143235,   -10255400, 31231165,   -10168911, 0x3c1004b},
        {32589754,   -13681800, 32678645,   -13595311, 0x3c1004b},
        {27793694,   -12408600, 27882105,   -12322111, 0x3c1004b},
        {27710574,   -15905700, 27800426,   -15819211, 0x3c1004b},
        {28126094,   -15798100, 28215706,   -15711611, 0x3c1004b},
        {28845915,   -11243200, 28934085,   -11156711, 0x3c1004b},
        {26930754,   -16839400, 27020846,   -16752911, 0x3c1004b},
        {23114894,   -15307600, 23204506,   -15221111, 0x3c1004b},
        {26342994,   -12213550, 26444561,   -12138311, 0x3c1044b},
        {28659100,   -14002700, 28744106,   -13912400, 0x3c1044b},
        {31383600,   -11859800, 31473972,   -11816370, 0x2b2044b},
        {27448771,   -16310060, 27511228,   -16249941, 0x29c004b},
        {28723755,   -9372066,  28770255,   -9288290,  0x2b2044b},
        {29026700,   -9815500,  29124336,   -9778000,  0x29c044b},
        {29514447,   -11409350, 29577753,   -11347251, 0x2b2004b},
        {31335306,   -8869860,  31396093,   -8809741,  0x29c004b},
        {27042715,   -15026250, 27106884,   -14964151, 0x2b2004b},
        {31299522,   -14293660, 31361478,   -14233541, 0x29c004b},
        {24269384,   -17492750, 24334415,   -17430651, 0x2b2004b},
        {28678288,   -16547160, 28740912,   -16487041, 0x29c004b},
        {28025474,   -12667250, 28089125,   -12605151, 0x2b2004b},
        {24769038,   -14830960, 24831161,   -14770841, 0x29c004b},
        {27190384,   -17386650, 27255415,   -17324551, 0x2b2004b},
        {32042639,   -10577260, 32103760,   -10517141, 0x29c004b},
        {32604433,   -10188950, 32667567,   -10126851, 0x2b2004b},
        {26446904,   -17057260, 26509695,   -16997141, 0x29c004b},
        {24400447,   -11771750, 24463753,   -11709651, 0x2b2004b},
        {29356505,   -13640660, 29418294,   -13580541, 0x29c004b},
        {28128088,   -13541050, 28191912,   -13478951, 0x2b2004b},
        {32027205,   -14110060, 32088994,   -14049941, 0x29c004b},
        {27420570,   -17276750, 27485429,   -17214651, 0x2b2004b},
        {27844871,   -15891760, 27907328,   -15831641, 0x29c004b},
        {29628533,   -10928650, 29691667,   -10866551, 0x2b2004b},
        {32716906,   -9362160,  32777693,   -9302041,  0x29c004b},
        {23278543,   -16144150, 23343057,   -16082051, 0x2b2004b},
        {28248855,   -15600060, 28311145,   -15539941, 0x29c004b},
        {33138260,   -12321050, 33201739,   -12258951, 0x2b2004b},
        {30199005,   -13257360, 30260794,   -13197241, 0x29c004b},
        {22632415,   -15039150, 22696584,   -14977051, 0x2b2004b},
        {23123038,   -15163360, 23185161,   -15103241, 0x29c004b},
        {31078105,   -8805450,  31140894,   -8743351,  0x2b2004b},
        {26008055,   -15770660, 26070345,   -15710541, 0x29c004b},
        {23078088,   -13571050, 23141912,   -13508951, 0x2b2004b},
        {24969105,   -13500060, 25030894,   -13439941, 0x29c004b},
        {28380058,   -10900377, 31061248,   -8219187,  0x001000d},
        {27967032,   -12944620, 28446168,   -12453580, 0x001008c},
        {28255532,   -13291720, 28734668,   -12800680, 0x001088c},
        {28206232,   -14683320, 28685368,   -14192280, 0x001108c},
        {25610224,   -18002920, 26099776,   -17511880, 0x001188c},
        {31051840,   -10436620, 31525768,   -9945580,  0x001208c},
        {32394632,   -13884120, 32873768,   -13393080, 0x001288c},
        {27556732,   -12686620, 28035868,   -12195580, 0x001308c},
        {28658240,   -11445520, 29132168,   -10954480, 0x001388c},
        {22917932,   -15427720, 23402276,   -14936680, 0x001408c},
        {26135740,   -12421420, 26609668,   -11930380, 0x001488c},
        {28440032,   -14203020, 28919168,   -13711980, 0x001508c},
        {31194140,   -12083620, 31668068,   -11592580, 0x001588c},
        {31006140,   -9045420,  31480068,   -8554380,  0x001688c},
        {29314340,   -11623820, 29788268,   -11132780, 0x001608c},
        {31090932,   -14509120, 31570068,   -14018080, 0x001708c},
        {24059924,   -17576420, 24549476,   -17085380, 0x001788c},
        {24560532,   -15046420, 25039668,   -14555380, 0x001808c},
        {24660432,   -13820520, 25139568,   -13329480, 0x001f08c},
        {31841440,   -10792720, 32315368,   -10301680, 0x001888c},
        {32404239,   -10403420, 32878167,   -9912380,  0x001908c},
        {24200340,   -11986220, 24674268,   -11495180, 0x001988c},
        {29150432,   -13855520, 29629568,   -13364480, 0x001a08c},
        {27920432,   -13755520, 28399568,   -13264480, 0x001a88c},
        {31820432,   -14325520, 32299568,   -13834480, 0x001b08c},
        {32543640,   -9702320,  33017568,   -9211280,  0x001b88c},
        {23033032,   -16365520, 23517376,   -15874480, 0x001c08c},
        {32938240,   -12535520, 33412168,   -12044480, 0x001c88c},
        {30000432,   -13465520, 30479568,   -12974480, 0x001d08c},
        {22443032,   -15235520, 22927376,   -14744480, 0x001d88c},
        {25649932,   -16029420, 26134276,   -15538380, 0x001e08c},
        {22870432,   -13785520, 23349568,   -13294480, 0x001e88c},
        {26112214,   -17620595, 28882777,   -14939405, 0x0010015},
        {21980000,   -18080000, 33708300,   -8180000,  0x0010016},
        {-70689933,  -33503245, -70587106,  -33416755, 0x001000a}, // CHL
        {-70908300,  -33636000, -70488525,  -33296300, 0xf040447},
        {-71660000,  -33150000, -71223394,  -32845411, 0xe890447},
        {-70421200,  -23688500, -70368025,  -23536000, 0x3c1044b},
        {-73145836,  -36797300, -73037965,  -36710811, 0x3c1004b},
        {-73151000,  -36855600, -72991382,  -36797200, 0x3c1044b},
        {-72653537,  -38771000, -72543264,  -38684511, 0x3c1004b},
        {-70158200,  -20299500, -70077676,  -20200700, 0x3c1044b},
        {-70788954,  -34197000, -70670527,  -34120711, 0x3c1044b},
        {-71712255,  -35461850, -71587406,  -35388750, 0x3c1044b},
        {-70333527,  -18516200, -70247401,  -18424911, 0x3c1044b},
        {-73006879,  -41492200, -72892521,  -41405711, 0x3c1044b},
        {-72403896,  -37511800, -72295304,  -37425311, 0x3c1044b},
        {-71383051,  -30014800, -71283349,  -29928311, 0x3c1044b},
        {-72163575,  -36643200, -72056425,  -36556711, 0x3c1044b},
        {-71283111,  -29978000, -71210115,  -29860511, 0x3c1044b},
        {-73189000,  -37055500, -73112896,  -36933000, 0x3c1044b},
        {-70965000,  -53195000, -70853773,  -53083400, 0x3c1044b},
        {-73184855,  -40600000, -73090729,  -40546200, 0x2b2044b},
        {-68951250,  -22491100, -68888201,  -22429400, 0x29c044b},
        {-73271306,  -39856250, -73191095,  -39794151, 0x2b2004b},
        {-70360917,  -27401160, -70293283,  -27341041, 0x29c004b},
        {-71271291,  -35006330, -71179632,  -34955351, 0x2b2044b},
        {-71232519,  -30635460, -71162881,  -30575341, 0x29c004b},
        {-71257260,  -33717000, -71169997,  -33664000, 0x2b2044b},
        {-71627000,  -33625260, -71586890,  -33518000, 0x29c044b},
        {-73050000,  -36964300, -73005775,  -36855600, 0x2b2044b},
        {-70748000,  -32768000, -70629295,  -32732000, 0x29c044b},
        {-70788880,  -33773450, -70718357,  -33708000, 0x2b2044b},
        {-71019000,  -34610060, -70946356,  -34549941, 0x29c044b},
        {-70634100,  -32861050, -70568023,  -32792000, 0x2b2044b},
        {-70960200,  -33690060, -70880065,  -33636000, 0x29c044b},
        {-72983200,  -36650000, -72913514,  -36581600, 0x2b2044b},
        {-70898000,  -34440060, -70825356,  -34379941, 0x29c044b},
        {-71998467,  -36451050, -71900237,  -36402500, 0x2b2044b},
        {-70786072,  -33845700, -70708421,  -33789941, 0x29c044b},
        {-71226828,  -32808700, -71130648,  -32761200, 0x2b2044b},
        {-73176000,  -37123200, -73109549,  -37055500, 0x29c044b},
        {-72745000,  -37825000, -72656618,  -37770000, 0x2b2044b},
        {-70802200,  -28600060, -70723673,  -28547800, 0x29c044b},
        {-72440500,  -35385700, -72375161,  -35313700, 0x2b2044b},
        {-73020000,  -36768800, -72955108,  -36699941, 0x29c044b},
        {-72269847,  -39311050, -72190153,  -39248951, 0x2b2044b},
        {-72112585,  -45600060, -72014411,  -45548000, 0x29c044b},
        {-72366000,  -35996000, -72274854,  -35944000, 0x2b2044b},
        {-71116322,  -34460060, -71022690,  -34413500, 0x29c044b},
        {-70904000,  -33300000, -70814126,  -33248951, 0x2b2044b},
        {-73870080,  -41908000, -73775761,  -41857000, 0x29c044b},
        {-72999588,  -38785500, -72915707,  -38727000, 0x2b2044b},
        {-73112300,  -40320060, -73033978,  -40259941, 0x29c044b},
        {-72410000,  -35172161, -69766000,  -32020000, 0x0c70011},
        {-73700000,  -37680371, -70310000,  -35172161, 0x01d000d},
        {-73783000,  -40726561, -70825000,  -37680371, 0x4440015},
        {-71212191,  -20171190, -68411837,  -17490000, 0x0a85091},
        {-70652120,  -22802220, -67821975,  -20121030, 0x0a95891},
        {-72691314,  -25483410, -69801587,  -22802220, 0x0a96091},
        {-69801587,  -25483410, -66911860,  -22802220, 0x0a96891},
        {-71247344,  -28164600, -68298035,  -25483410, 0x0a97091},
        {-72309393,  -30845790, -69300502,  -28164600, 0x0a97891},
        {-72850398,  -33526980, -69752134,  -30845790, 0x0a88091},
        {-72942154,  -36208170, -69754517,  -33526980, 0x0a88891},
        {-73958027,  -38889360, -70651226,  -36208170, 0x0a99091},
        {-74678969,  -41570550, -71253004,  -38889360, 0x0a99891},
        {-75110939,  -44251740, -71536019,  -41570550, 0x0a8a091},
        {-74795154,  -46932930, -71071279,  -44251740, 0x0a8a891},
        {-78519029,  -46932930, -74795154,  -44251740, 0x0a8b091},
        {-75722399,  -49614120, -71819778,  -46932930, 0x0a8b891},
        {-75841563,  -52295310, -71730405,  -49614120, 0x0a8c091},
        {-76958726,  -54654757, -72639031,  -51973567, 0x0a9c891},
        {-72639031,  -54654757, -68319336,  -51973567, 0x0a9d091},
        {-74888251,  -56531590, -70389810,  -53850400, 0x0a8d891},
        {-70880941,  -56531590, -66382500,  -53850400, 0x0a8e091},
        {-81290227,  -35046658, -78132381,  -32365468, 0x0a8e891},
        {-81444348,  -27659247, -78495039,  -24978057, 0x0a8f091},
        {-110000000, -28463297, -107050691, -25782107, 0x0a90091},
        {-110000000, -56536000, -66382500,  -17490000, 0x0010217},
        {28883919,   40978550,  28936040,   41073140,  0x2a7044a}, // TUR
        {28936040,   41000000,  29003512,   41073140,  0x2a7044a},
        {32538562,   39926100,  32651238,   40012589,  0x3c10047},
        {32651238,   39926100,  32763914,   40012589,  0x3c10047},
        {32763914,   39934748,  32876590,   40021237,  0x3c10047},
        {32876590,   39934748,  32989266,   40021237,  0x3c10047},
        {32763914,   39848259,  32876590,   39934748,  0x3c10047},
        {32876590,   39848259,  32989266,   39934748,  0x3c10047},
        {27027763,   38447595,  27189215,   38506600,  0x3c10447},
        {27189163,   38411300,  27299436,   38497789,  0x3c10047},
        {27082863,   38361200,  27193136,   38447689,  0x3c10047},
        {27082863,   38274711,  27193136,   38361200,  0x3c10047},
        {28618921,   41042300,  28733279,   41128789,  0x3c10047},
        {28733279,   41042300,  28847637,   41128789,  0x3c10047},
        {28847637,   41042300,  28961995,   41128789,  0x3c10047},
        {28961995,   41037975,  29076353,   41124464,  0x3c10047},
        {29076353,   41037975,  29190711,   41124464,  0x3c10047},
        {28544588,   40955811,  28658946,   41042300,  0x3c10047},
        {28658946,   40955811,  28773304,   41042300,  0x3c10047},
        {28773304,   40955811,  28887662,   41042300,  0x3c10047},
        {29006594,   40951486,  29120952,   41037975,  0x3c10047},
        {29120952,   40951486,  29235310,   41037975,  0x3c10047},
        {29235310,   40951486,  29349668,   41037975,  0x3c10047},
        {29095582,   40864997,  29209219,   40951486,  0x3c10047},
        {29209219,   40864997,  29322856,   40951486,  0x3c10047},
        {29322856,   40856348,  29436493,   40942837,  0x3c10047},
        {29254686,   40760000,  29348102,   40865039,  0x3c10447},
        {29348102,   40752000,  29442228,   40856390,  0x3c10447},
        {29442228,   40763000,  29561896,   40845000,  0x3c10447},
        {28912762,   40182600,  29025438,   40269089,  0x3c10047},
        {29025438,   40167000,  29188180,   40226800,  0x3c10447},
        {35240246,   36958800,  35329034,   37063800,  0x3c10447},
        {35329034,   36958844,  35436905,   37045333,  0x3c10047},
        {37320864,   37023000,  37428735,   37109489,  0x3c1004b},
        {32438944,   37827300,  32548256,   37913789,  0x3c1004b},
        {30642064,   36864800,  30749935,   36951289,  0x3c1004b},
        {40136944,   37886200,  40246256,   37972689,  0x3c1004b},
        {34573464,   36772500,  34681335,   36858989,  0x3c1004b},
        {35424763,   38692600,  35535036,   38779089,  0x3c1004b},
        {30446000,   39732100,  30580616,   39803789,  0x3c1044b},
        {38759264,   37100000,  38834021,   37224600,  0x3c1044b},
        {36268221,   41252400,  36382579,   41338889,  0x3c1004b},
        {38248363,   38312200,  38358636,   38398689,  0x3c1004b},
        {36817000,   37550700,  36998138,   37602500,  0x3c1044b},
        {43317063,   38457300,  43427336,   38543789,  0x3c1004b},
        {30322481,   40715300,  30436118,   40801789,  0x3c1004b},
        {29022104,   37729000,  29130696,   37815489,  0x3c1004b},
        {39126563,   38644000,  39276655,   38707500,  0x3c1044b},
        {36948142,   39696800,  37059857,   39783289,  0x3c1004b},
        {27839542,   39602400,  27951257,   39688889,  0x3c1004b},
        {27315363,   38605200,  27474635,   38665000,  0x3c1044b},
        {29750681,   40743400,  29979139,   40786400,  0x3c1044b},
        {29934000,   39383000,  30080241,   39449000,  0x3c1044b},
        {36117485,   36161200,  36223914,   36247689,  0x3c1004b},
        {41235200,   39868200,  41297458,   39948800,  0x2b2044b},
        {34847000,   36896500,  34937809,   36946000,  0x29c044b},
        {39654000,   40981000,  39818219,   41012000,  0x2b2044b},
        {33474500,   39819350,  33566569,   39870000,  0x29c044b},
        {38204800,   37741500,  38311019,   37787000,  0x2b2044b},
        {30507800,   37746100,  30600459,   37795000,  0x29c044b},
        {41090357,   37854350,  41168843,   37916449,  0x2b2004b},
        {36214209,   37043940,  36289191,   37104059,  0x29c004b},
        {34917704,   40517650,  34999295,   40579749,  0x2b2004b},
        {36129759,   36535840,  36204240,   36595959,  0x29c004b},
        {27801457,   37801350,  27879943,   37863449,  0x2b2004b},
        {29369874,   38641440,  29446526,   38701559,  0x29c004b},
        {27759845,   41135950,  27841954,   41198049,  0x2b2004b},
        {33979274,   38338640,  34055926,   38398759,  0x29c004b},
        {30511012,   38724150,  30590188,   38786249,  0x2b2004b},
        {39724009,   37202840,  39798991,   37262959,  0x29c004b},
        {39282515,   37721750,  39360484,   37783849,  0x2b2004b},
        {26523220,   41643140,  26603379,   41703259,  0x29c004b},
        {29463249,   40059050,  29544150,   40121149,  0x2b2004b},
        {40552509,   37159940,  40627491,   37220059,  0x29c004b},
        {26214378,   36699724,  29521179,   39380914,  0x0a90011},
        {26455685,   39380913,  29911441,   42062103,  0x001000d},
        {36958559,   36652579,  37536647,   37143619,  0x0b10090},
        {32347680,   37474729,  32936184,   37965769,  0x0b00890},
        {30412159,   36662479,  30990247,   37153519,  0x0b11090},
        {40141751,   37644179,  40730255,   38135219,  0x0b01890},
        {34458859,   36626149,  35036947,   37117189,  0x0b12090},
        {35183039,   38490279,  35776751,   38981319,  0x0b12890},
        {29900021,   39347874,  30504149,   39838914,  0x0b03090},
        {38303267,   36847600,  38886563,   37338640,  0x0b03890},
        {35802927,   41187279,  36422679,   41678319,  0x0b04090},
        {38014451,   38109879,  38602955,   38600919,  0x0b14890},
        {36376727,   37161550,  36960023,   37652590,  0x0b05090},
        {43083151,   38254979,  43671655,   38746019,  0x0b15890},
        {30072023,   40512979,  30686567,   41004019,  0x0b06090},
        {38843189,   38430230,  39436901,   38921270,  0x0b16890},
        {36701931,   39494479,  37306059,   39985519,  0x0b07090},
        {36062055,   36139629,  36634935,   36630669,  0x0b17890},
        {40943981,   39662980,  41548109,   40154020,  0x0b08090},
        {39316273,   40764159,  39930817,   41255199,  0x0b08890},
        {33252041,   39520300,  33856169,   40011340,  0x0b09090},
        {38119961,   37519409,  38708465,   38010449,  0x0b09890},
        {30110621,   37507800,  30699125,   37998840,  0x0b0a090},
        {40780751,   37772179,  41369255,   38263219,  0x0b1a890},
        {35768347,   36721479,  36351643,   37212519,  0x0b0b090},
        {34896973,   40468829,  35511517,   40959869,  0x0b0b890},
        {33728551,   38123179,  34317055,   38614219,  0x0b1c090},
        {30498439,   38497079,  31092151,   38988119,  0x0b1c890},
        {39469847,   36987379,  40053143,   37478419,  0x0b0d090},
        {39032451,   37507279,  39620955,   37998319,  0x0b0d890},
        {40393427,   37014479,  40976723,   37505519,  0x0b0e090},
        {36020535,   40239479,  36629871,   40730519,  0x0b0e890},
        {37827723,   40709479,  38442267,   41200519,  0x0b0f090},
        {25662000,   35806600,  44830000,   42110000,  0x2550016},
        {66967667,   24810700,  67062806,   24897190,  0x001000a}, // PAK
        {66888808,   24746000,  67279956,   25082460,  0xf040447},
        {74146042,   31333700,  74503671,   31699400,  0xe890447},
        {72982896,   31444017,  73083800,   31530506,  0x3c1004b},
        {73083800,   31444017,  73184704,   31530506,  0x3c1004b},
        {72982896,   31357528,  73083800,   31444017,  0x3c1004b},
        {73083800,   31357528,  73184704,   31444017,  0x3c1004b},
        {72963000,   33693000,  73124351,   33748589,  0x3c1044b},
        {72963000,   33636000,  73120247,   33693000,  0x3c1044b},
        {72967000,   33580000,  73127055,   33636000,  0x3c1044b},
        {72995000,   33523000,  73151155,   33580000,  0x3c1044b},
        {71425149,   30153300,  71524851,   30239789,  0x3c1004b},
        {68312900,   25341500,  68408518,   25427989,  0x3c1044b},
        {74136660,   32110000,  74230999,   32203289,  0x3c1044b},
        {71493906,   33967000,  71624585,   34035600,  0x3c1044b},
        {66949000,   30133000,  67041855,   30225789,  0x3c1044b},
        {72632000,   32031000,  72731003,   32119889,  0x3c1044b},
        {74487867,   32462000,  74589732,   32548489,  0x3c1044b},
        {71625529,   29347000,  71739272,   29422000,  0x3c1044b},
        {68809500,   27662300,  68913786,   27742889,  0x3c1044b},
        {72280248,   31237400,  72381152,   31323889,  0x3c1044b},
        {73936508,   31669900,  74037892,   31756389,  0x3c1044b},
        {68159000,   27515500,  68262679,   27596500,  0x3c1044b},
        {74020407,   32537200,  74122992,   32623689,  0x3c1044b},
        {71987846,   34158700,  72092353,   34245189,  0x3c1044b},
        {74399548,   31076800,  74500452,   31163289,  0x3c1044b},
        {70255969,   28376100,  70354230,   28462589,  0x3c1044b},
        {73056808,   30626800,  73156991,   30713289,  0x3c1044b},
        {73400808,   30761900,  73500991,   30848389,  0x3c1044b},
        {72698106,   33726800,  72801893,   33813289,  0x3c1044b},
        {70601000,   30006600,  70700702,   30093089,  0x3c1044b},
        {68975973,   25488000,  69045821,   25549000,  0x2b2044b},
        {68372284,   26222000,  68449676,   26273959,  0x29c044b},
        {72322309,   34748950,  72397690,   34811049,  0x2b2044b},
        {72946563,   31688440,  73017036,   31748559,  0x29c044b},
        {74179803,   31945050,  74252597,   32007149,  0x2b2044b},
        {72643448,   30127040,  72712752,   30187159,  0x29c044b},
        {72278809,   30611000,  74655000,   34044000,  0x0da0011},
        {66800000,   24587292,  69070000,   27870000,  0x027000d},
        {69076400,   27686080,  69602408,   28177120,  0x0b00890},
        {68296000,   27916380,  68822008,   28407420,  0x0b11090},
        {69862800,   28118780,  70388808,   28609820,  0x0b11890},
        {70377792,   28458780,  70909008,   28949820,  0x0b02090},
        {70881892,   28903080,  71413108,   29394120,  0x0b12890},
        {71457192,   29066080,  71988408,   29557120,  0x0b13090},
        {72260292,   29800180,  72796716,   30291220,  0x0b03890},
        {70244492,   29788680,  70780916,   30279720,  0x0b04090},
        {70778092,   29832380,  71314516,   30323420,  0x0b04890},
        {71448892,   30014980,  71985316,   30506020,  0x0b15090},
        {66671691,   29924380,  67208115,   30415420,  0x0b15890},
        {71908692,   30133880,  72445116,   30624920,  0x0b16090},
        {70612884,   30750880,  71154516,   31241920,  0x0b06890},
        {71155568,   33586080,  71718032,   34077120,  0x0b07090},
        {71712168,   33788880,  72274632,   34279920,  0x0b07890},
        {67566728,   29263420,  68097944,   29754460,  0x0b1a890},
        {71288917,   32296663,  71840965,   32787703,  0x0b0b090},
        {70563535,   31576045,  71110375,   32067085,  0x0b1b890},
        {70501717,   34263405,  73719145,   36944595,  0x0a92891},
        {67343871,   31582215,  70471926,   34263405,  0x0a93091},
        {70471926,   31582215,  73599981,   34263405,  0x0a93891},
        {60850000,   28901025,  66200000,   29880000,  0x04d5091},
        {66200000,   28901025,  68644546,   31582215,  0x0bc6091},
        {68644546,   28901025,  71683228,   31582215,  0x0a96891},
        {71683228,   28901025,  74721910,   31582215,  0x0a97091},
        {61442273,   26219835,  64421373,   28901025,  0x0a87891},
        {64421373,   26219835,  67400473,   28901025,  0x0a88891},
        {67400473,   26219835,  70379573,   28901025,  0x0a89091},
        {69783753,   27560430,  72792644,   30241620,  0x0a89891},
        {61538796,   23670000,  64428523,   26351190,  0x0a9a091},
        {64428523,   23670000,  67318250,   26351190,  0x0a9a891},
        {67318250,   23670000,  70207977,   26351190,  0x0a9b091},
        {68213172,   24074883,  71132690,   26756073,  0x0a8b891},
        {72500000,   33864760,  75000000,   37100000,  0x0d20091},
        {75000000,   33864760,  77500000,   37100000,  0x0d20891},
        {77495479,   33864760,  80500000,   36545950,  0x0ae1091},
        {73426660,   31183570,  76554715,   33864760,  0x0a81891},
        {76554715,   31183570,  79682770,   33864760,  0x0a82091},
        {60850000,   23670000,  80500000,   37100000,  0x0010217},
        {32534327,   -25983731, 32629466,   -25897241, 0x001000a}, // MOZ
        {32235937,   -26152662, 32751529,   -25661622, 0x001000c},
        {34829113,   -19852000, 34920887,   -19765511, 0x3c1004b},
        {34801580,   -19765511, 34893354,   -19679022, 0x3c1004b},
        {39164014,   -15147300, 39253386,   -15060811, 0x3c1004b},
        {39253386,   -15173246, 39342758,   -15086757, 0x3c1004b},
        {33423553,   -19164900, 33514847,   -19078411, 0x3c1004b},
        {40660500,   -14618200, 40710027,   -14462800, 0x3c1044b},
        {40561434,   -14588700, 40650565,   -14502211, 0x3c1004b},
        {36852713,   -17896000, 36943286,   -17809511, 0x3c1004b},
        {33551374,   -16210700, 33641226,   -16124211, 0x3c1004b},
        {33631800,   -25095000, 33733571,   -25014190, 0x3c1044b},
        {36931794,   -15522600, 37021406,   -15436111, 0x3c1004b},
        {35259991,   -23903800, 35354408,   -23817311, 0x3c1004b},
        {35220500,   -13353000, 35290891,   -13244000, 0x3c1044b},
        {40479574,   -13033900, 40568225,   -12947411, 0x3c1004b},
        {34686613,   -19656000, 34778387,   -19569511, 0x3c1004b},
        {39884374,   -16246000, 39974226,   -16159511, 0x3c1004b},
        {36491114,   -14843500, 36580486,   -14757011, 0x3c1004b},
        {38972974,   -13170400, 39061625,   -13083911, 0x3c1004b},
        {38219833,   -16894700, 38310166,   -16808211, 0x3c1004b},
        {35376104,   -23937600, 35420413,   -23842651, 0x2b2044b},
        {32950101,   -24555260, 33015898,   -24495141, 0x29c004b},
        {33508145,   -24722150, 33576454,   -24660051, 0x2b2004b},
        {40613400,   -15053500, 40750760,   -15026400, 0x29c044b},
        {32839225,   -18962950, 32918549,   -18911700, 0x2b2044b},
        {34696934,   -24740060, 34763065,   -24679941, 0x29c004b},
        {40598915,   -15040350, 40674988,   -14988000, 0x2b2044b},
        {34984201,   -24510760, 35049998,   -24450641, 0x29c004b},
        {34698304,   -24104650, 34766095,   -24042551, 0x2b2004b},
        {33071834,   -25061660, 33137965,   -25001541, 0x29c004b},
        {37470988,   -13232150, 37534812,   -13170051, 0x2b2004b},
        {33760634,   -25040460, 33826765,   -24980341, 0x29c004b},
        {35124704,   -23931050, 35192495,   -23868951, 0x2b2004b},
        {32766767,   -25430060, 32833232,   -25369941, 0x29c004b},
        {32619514,   -26375550, 32688685,   -26313451, 0x2b2004b},
        {32631134,   -25059660, 32697265,   -24999541, 0x29c004b},
        {30405829,   -15654950, 30470170,   -15592851, 0x2b2004b},
        {35262785,   -24130360, 35328415,   -24070241, 0x29c004b},
        {34937574,   -12770450, 35001225,   -12708351, 0x2b2004b},
        {32205767,   -25629760, 32272232,   -25569641, 0x29c004b},
        {35599502,   -14389850, 35663498,   -14327751, 0x2b2004b},
        {31981784,   -26003160, 32048416,   -25943041, 0x29c004b},
        {34150245,   -24938650, 34218554,   -24876551, 0x2b2004b},
        {33851034,   -24734960, 33917165,   -24674841, 0x29c004b},
        {31920000,   -25666000, 35556000,   -23583753, 0x0840011},
        {32690000,   -21431191, 35350000,   -18750000, 0x001000d},
        {32305808,   -26604320, 32821400,   -26113280, 0x0b10090},
        {39016432,   -15362520, 39500776,   -14871480, 0x0b00890},
        {36653224,   -18098320, 37142776,   -17607280, 0x0b01090},
        {33359332,   -16413020, 33843676,   -15921980, 0x0b11890},
        {36739632,   -15724920, 37223976,   -15233880, 0x0b02090},
        {35016132,   -13544020, 35495268,   -13052980, 0x0b02890},
        {39692332,   -16448320, 40176676,   -15957280, 0x0b13090},
        {36296232,   -15045820, 36775368,   -14554780, 0x0b13890},
        {38777732,   -13372720, 39256868,   -12881680, 0x0b04090},
        {38028032,   -17097020, 38512376,   -16605980, 0x0b14890},
        {31728108,   -26223120, 32243700,   -25732080, 0x0b15090},
        {37263332,   -13446620, 37742468,   -12955580, 0x0b05890},
        {30359632,   -15872320, 30843976,   -15381280, 0x0b06090},
        {34729832,   -12984920, 35208968,   -12493880, 0x0b06890},
        {35505832,   -14557920, 35984968,   -14066880, 0x0b17090},
        {40195798,   -15870259, 40680142,   -15379219, 0x0b08890},
        {40355632,   -15379219, 40839976,   -14888179, 0x0b09090},
        {40360475,   -14888179, 40839611,   -14397139, 0x0b19890},
        {40312561,   -14397139, 40791697,   -13906099, 0x0b1a090},
        {40154446,   -13906099, 40633582,   -13415059, 0x0b1a890},
        {40120907,   -13415059, 40600043,   -12924019, 0x0b0b090},
        {40168821,   -12924019, 40647957,   -12432979, 0x0b0b890},
        {40150072,   -12432979, 40624000,   -11941939, 0x0b1c090},
        {40150072,   -11941939, 40624000,   -11450899, 0x0b1c890},
        {40150072,   -11450899, 40624000,   -10959859, 0x0b1d090},
        {40150072,   -10959859, 40624000,   -10468819, 0x0b1d890},
        {30200000,   -26870000, 40840060,   -10468720, 0x4970016},
        {17036872,   -22602245, 17130089,   -22515755, 0x001000a}, // NAM
        {16896566,   -22731980, 17269433,   -22386021, 0xf040047},
        {19608683,   -18186100, 19960316,   -17851211, 0xe890047},
        {15639513,   -17825900, 15730086,   -17739411, 0x3c1004b},
        {15730086,   -17825900, 15820659,   -17739411, 0x3c1004b},
        {14467252,   -22998200, 14560948,   -22911711, 0x3c1004b},
        {14513152,   -22702400, 14606848,   -22615911, 0x3c1004b},
        {24240313,   -17563100, 24330886,   -17476611, 0x3c1004b},
        {18066813,   -19614100, 18158587,   -19527611, 0x3c1004b},
        {17031432,   -23362300, 17125368,   -23275811, 0x3c1004b},
        {16613993,   -20510500, 16706007,   -20424011, 0x3c1004b},
        {16868412,   -22039100, 16961387,   -21952611, 0x3c1004b},
        {18089330,   -26621800, 18185669,   -26535311, 0x3c1004b},
        {18931992,   -22504400, 19025208,   -22417911, 0x3c1004b},
        {17661853,   -19284700, 17753147,   -19198211, 0x3c1004b},
        {15101330,   -26695700, 15197669,   -26609211, 0x3c1004b},
        {17914071,   -24668300, 18008728,   -24581811, 0x3c1004b},
        {15933993,   -17946300, 16024806,   -17859811, 0x3c1004b},
        {14900293,   -20426000, 14992307,   -20339511, 0x3c1004b},
        {16355669,   -28608000, 16453930,   -28521511, 0x3c1004b},
        {17395872,   -20628900, 17488127,   -20542411, 0x3c1004b},
        {16114193,   -20149500, 16206207,   -20063011, 0x3c1004b},
        {14943392,   -22473200, 15036608,   -22386711, 0x3c1004b},
        {17101830,   -26543200, 17198169,   -26456711, 0x3c1004b},
        {15903632,   -21473200, 15996367,   -21386711, 0x3c1004b},
        {18708110,   -28061600, 18805890,   -27975111, 0x3c1004b},
        {13792093,   -18095500, 13882906,   -18009011, 0x3c1004b},
        {15810612,   -21973500, 15903587,   -21887011, 0x3c1004b},
        {17307053,   -19671050, 17372947,   -19608951, 0x2b2004b},
        {15547686,   -22030060, 15612314,   -21969941, 0x29c004b},
        {16086535,   -22391050, 16153464,   -22328951, 0x2b2004b},
        {19067101,   -24180060, 19132898,   -24119941, 0x29c004b},
        {16301384,   -17509050, 16366415,   -17446951, 0x2b2004b},
        {15038537,   -17928560, 15101662,   -17868441, 0x29c004b},
        {14950184,   -17548350, 15015215,   -17486251, 0x2b2004b},
        {15863721,   -17438060, 15926679,   -17377941, 0x29c004b},
        {16951845,   -24861150, 17020154,   -24799051, 0x2b2004b},
        {18695849,   -28470060, 18764151,   -28409941, 0x29c004b},
        {14246535,   -22151050, 14313464,   -22088951, 0x2b2004b},
        {17550985,   -24102660, 17616615,   -24042541, 0x29c004b},
        {14950000,   -19712000, 18210000,   -17389000, 0x0910011},
        {14220000,   -23390000, 18500000,   -21670000, 0x014000d},
        {24035524,   -17929820, 24525076,   -17438780, 0x0b00090},
        {14807099,   -26920520, 15327899,   -26429480, 0x0b00890},
        {15327900,   -26920520, 15848700,   -26429480, 0x0b01090},
        {15848699,   -26920520, 16369499,   -26429480, 0x0b01890},
        {16369500,   -26920520, 16890300,   -26429480, 0x0b02090},
        {16890300,   -26920520, 17411100,   -26429480, 0x0b02890},
        {17411100,   -26920520, 17931900,   -26429480, 0x0b03090},
        {16417824,   -20712820, 16912584,   -20221780, 0x0b13890},
        {18731216,   -22706720, 19236392,   -22215680, 0x0b04090},
        {14801724,   -20617220, 15296484,   -20126180, 0x0b14890},
        {16186699,   -28677620, 16712707,   -28186580, 0x0b15090},
        {17296824,   -20897720, 17791584,   -20406680, 0x0b15890},
        {15918024,   -20351820, 16412784,   -19860780, 0x0b16090},
        {15700016,   -21675520, 16199984,   -21184480, 0x0b16890},
        {13592724,   -18297820, 14082276,   -17806780, 0x0b07090},
        {18844808,   -24395520, 19355192,   -23904480, 0x0b07890},
        {16730808,   -25075620, 17241192,   -24584580, 0x0b18090},
        {17328608,   -24318120, 17838992,   -23827080, 0x0b08890},
        {17706208,   -24870620, 18216592,   -24379580, 0x0b19090},
        {17706208,   -25361659, 18221800,   -24870619, 0x0b09890},
        {17706208,   -25852699, 18221800,   -25361659, 0x0b1a090},
        {17860885,   -26343739, 18376477,   -25852699, 0x0b1a890},
        {17933016,   -26834779, 18453816,   -26343739, 0x0b0b090},
        {18375696,   -27325819, 18896496,   -26834779, 0x0b1b890},
        {18167376,   -27816859, 18693384,   -27325819, 0x0b0c090},
        {18499200,   -28263920, 19025208,   -27772880, 0x0b0c890},
        {18483200,   -28733920, 19009208,   -28242880, 0x0b1d090},
        {11720000,   -28970000, 25270000,   -16950000, 0x0010016},
        {-66950440,  10460000,  -66834794,  10524169,  0x017000a}, // VEN
        {-67068050,  10381700,  -66722090,  10623400,  0xc730447},
        {-67732000,  10145100,  -67297651,  10320000,  0xbde0447},
        {-68115900,  10083000,  -67781194,  10310000,  0xbde0447},
        {-71761465,  10632000,  -71673535,  10718489,  0x3c1004b},
        {-71673535,  10632000,  -71585605,  10718489,  0x3c1004b},
        {-71695517,  10545511,  -71607587,  10632000,  0x3c1004b},
        {-69393000,  10044300,  -69279175,  10111000,  0x3c1044b},
        {-62697100,  8316500,   -62598184,  8392720,   0x3c1044b},
        {-64714440,  10046600,  -64648012,  10161000,  0x3c1044b},
        {-63217000,  9708000,   -63109874,  9778700,   0x3c1044b},
        {-64662065,  10170700,  -64574135,  10257189,  0x3c1004b},
        {-63597100,  8058500,   -63511252,  8146250,   0x3c1044b},
        {-64200000,  10412300,  -64087822,  10480000,  0x3c1044b},
        {-71201225,  8553100,   -71107496,  8633689,   0x3c1044b},
        {-70257300,  8579000,   -70165664,  8661489,   0x3c1044b},
        {-72245000,  7735000,   -72185651,  7862000,   0x3c1044b},
        {-66645700,  10445950,  -66558776,  10491000,  0x2b2044b},
        {-71479800,  10368840,  -71418679,  10428959,  0x29c044b},
        {-64714400,  10161000,  -64653279,  10225000,  0x2b2044b},
        {-68073100,  10446500,  -67992124,  10491800,  0x29c044b},
        {-69228000,  9512000,   -69175533,  9586500,   0x2b2044b},
        {-66716100,  10223780,  -66643084,  10274000,  0x29c044b},
        {-69704653,  11373650,  -69631621,  11427400,  0x2b2044b},
        {-70624994,  9284700,   -70575582,  9358500,   0x29c044b},
        {-66564600,  10443770,  -66491401,  10497300,  0x2b2044b},
        {-69779094,  9019940,   -69699197,  9065600,   0x29c044b},
        {-64283295,  8857250,   -64213954,  8913360,   0x2b2044b},
        {-66805661,  10097600,  -66738135,  10151959,  0x29c044b},
        {-63294500,  10621150,  -63221576,  10674800,  0x2b2044b},
        {-66915061,  10141040,  -66853940,  10201159,  0x29c044b},
        {-67456495,  8886000,   -67386790,  8941849,   0x2b2044b},
        {-70223200,  11675500,  -70162830,  11736500,  0x29c044b},
        {-66883067,  10196000,  -66830273,  10270249,  0x2b2044b},
        {-70100800,  10144000,  -70037026,  10201559,  0x29c044b},
        {-67511440,  7852000,   -67428859,  7899000,   0x2b2044b},
        {-66037000,  9184000,   -65966294,  9235600,   0x29c044b},
        {-67388181,  9875050,   -67325220,  9937149,   0x2b2044b},
        {-63871660,  10944700,  -63805415,  11000059,  0x29c044b},
        {-69649981,  9900000,   -69582549,  9957949,   0x2b2044b},
        {-64503000,  9408940,   -64443396,  9470200,   0x29c044b},
        {-68794160,  10307770,  -68719223,  10360000,  0x2b2044b},
        {-69305500,  10003300,  -69213361,  10043100,  0x29c044b},
        {-68617781,  9634800,   -68549071,  9691649,   0x2b2044b},
        {-68338977,  9887440,   -68275742,  9945300,   0x29c044b},
        {-71684700,  8597650,   -71603347,  8645500,   0x2b2044b},
        {-71340161,  10169640,  -71279040,  10229759,  0x29c044b},
        {-71254295,  8529550,   -71191506,  8591649,   0x2b2044b},
        {-72392210,  7660540,   -72331590,  7720659,   0x29c044b},
        {-69154567,  10044850,  -69091433,  10106949,  0x2b2044b},
        {-67528961,  10008140,  -67467840,  10068259,  0x29c044b},
        {-67635800,  5623150,   -67573356,  5685249,   0x2b2044b},
        {-67821161,  10035840,  -67760040,  10095959,  0x29c044b},
        {-69800000,  8759200,   -66045300,  10660000,  0x0780011},
        {-64930000,  8000000,   -62335300,  10766700,  0x020000d},
        {-72510982,  8411775,   -69800000,  11092965,  0x0010015},
        {-73390000,  630000,    -59790000,  12200000,  0x0010016},
        {3328000,    6421000,   3482500,    6468900,   0x011000a}, // NGA
        {3168231,    6419660,   3405068,    6768800,   0xc730447},
        {3746440,    7270861,   4022137,    7544280,   0xbde0047},
        {8388632,    11861590,  8667367,    12135009,  0xbde0047},
        {7355335,    10510400,  7443265,    10596889,  0x3c1004b},
        {7443265,    10510400,  7531195,    10596889,  0x3c1004b},
        {7355335,    10423911,  7443265,    10510400,  0x3c1004b},
        {7443265,    10423911,  7531195,    10510400,  0x3c1004b},
        {5544841,    6339495,   5631810,    6425984,   0x3c1004b},
        {5631810,    6339495,   5718779,    6425984,   0x3c1004b},
        {5544841,    6253006,   5631810,    6339495,   0x3c1004b},
        {5631810,    6253006,   5718779,    6339495,   0x3c1004b},
        {6970132,    4763727,   7056861,    4850216,   0x3c1004b},
        {13114115,   11796900,  13202285,   11883389,  0x3c1004b},
        {7673000,    11038400,  7747133,    11141100,  0x3c1044b},
        {7323636,    5063801,   7410365,    5150290,   0x3c1004b},
        {8841726,    9874456,   8929416,    9960945,   0x3c1004b},
        {4506471,    8446060,   4593921,    8532549,   0x3c1004b},
        {7471942,    6408820,   7558911,    6495309,   0x3c1004b},
        {3300598,    7113490,   3387807,    7199979,   0x3c1004b},
        {6759333,    6103471,   6846302,    6189960,   0x3c1004b},
        {7448793,    9012900,   7526142,    9110600,   0x3c1044b},
        {5729063,    5503872,   5791507,    5565971,   0x2b2004b},
        {4210706,    8101199,   4271326,    8161318,   0x29c004b},
        {3905123,    7815321,   3967739,    7877420,   0x2b2004b},
        {5213389,    13020840,  5275011,    13080959,  0x29c004b},
        {6194936,    7524222,   6257552,    7586321,   0x2b2004b},
        {8306248,    4914580,   8366534,    4974699,   0x29c004b},
        {8312489,    4973709,   8374760,    5035808,   0x2b2004b},
        {4527241,    7739597,   4587861,    7799716,   0x29c004b},
        {7576674,    12955450,  7640325,    13017549,  0x2b2004b},
        {5157737,    7214723,   5218357,    7274842,   0x29c004b},
        {4524793,    7446195,   4587409,    7508294,   0x2b2004b},
        {9804039,    10282240,  9865160,    10342359,  0x29c004b},
        {3565733,    7940467,   3628349,    8002566,   0x2b2004b},
        {6521025,    9578798,   6581979,    9638917,   0x29c004b},
        {8494919,    7699748,   8557535,    7761847,   0x2b2004b},
        {4716325,    7596735,   4776945,    7656854,   0x29c004b},
        {5557427,    7164026,   5620043,    7226125,   0x2b2004b},
        {11146139,   10256340,  11207260,   10316459,  0x29c004b},
        {4805667,    7060314,   4868283,    7122413,   0x2b2004b},
        {11929456,   11715740,  11990744,   11775859,  0x29c004b},
        {12414505,   9227650,   12477294,   9289749,   0x2b2004b},
        {4156238,    7605558,   4216858,    7665677,   0x29c004b},
        {7680672,    5152674,   7742943,    5214773,   0x2b2004b},
        {6642472,    12138340,  6703927,    12198459,  0x29c004b},
        {13238433,   10238950,  13301567,   10301049,  0x2b2004b},
        {3477882,    6594148,   3538335,    6654267,   0x29c004b},
        {2839404,    6289406,   5520594,    8970596,   0x0a90011},
        {5522000,    4269668,   8430000,    6560000,   0x01b000d},
        {6515986,    7427435,   6984706,    7918475,   0x0b10090},
        {8275740,    11754480,  8749668,    12245520,  0x0b10890},
        {7192840,    10237480,  7666768,    10728520,  0x0b11090},
        {12926440,   11594580,  13400368,   12085620,  0x0b11890},
        {7281340,    11063580,  7755268,    11554620,  0x0b12090},
        {8653819,    9672135,   9127747,    10163175,  0x0b02890},
        {5006332,    12804480,  5485468,    13295520,  0x0b03090},
        {5953583,    7413390,   6422303,    7904430,   0x0b13890},
        {7477932,    12729880,  7957068,    13220920,  0x0b04090},
        {9728740,    10148080,  10202668,   10639120,  0x0b14890},
        {6135324,    9449420,   6609252,    9940460,   0x0b05090},
        {8453531,    7285120,   8922251,    7776160,   0x0b15890},
        {5505378,    7090837,   5974098,    7581877,   0x0b16090},
        {7400905,    8837035,   7874833,    9328075,   0x0b06890},
        {10954440,   9996480,   11428368,   10487520,  0x0b17090},
        {11873440,   11502880,  12347368,   11993920,  0x0b17890},
        {12179740,   9075880,   12653668,   9566920,   0x0b08090},
        {6522140,    11880780,  6996068,    12371820,  0x0b18890},
        {12886140,   9978680,   13360068,   10469720,  0x0b19090},
        {5907933,    8806624,   6381861,    9297664,   0x0b09890},
        {6941001,    8893607,   7414929,    9384647,   0x0b0a090},
        {8764663,    6413143,   9233383,    6904183,   0x0b1a890},
        {3626789,    8952532,   4100717,    9443572,   0x0b0b090},
        {8331391,    8232385,   8800111,    8723425,   0x0b1b890},
        {10840132,   12643480,  11319268,   13134520,  0x0b0c090},
        {11138240,   8644480,   11612168,   9135520,   0x0b0c890},
        {13380140,   11253980,  13854068,   11745020,  0x0b1d090},
        {5928401,    6514637,   6397121,    7005677,   0x0b1d890},
        {7097329,    6608923,   7566049,    7099963,   0x0b1e090},
        {10005432,   12424480,  10484568,   12915520,  0x0b0e890},
        {9852940,    11234280,  10326868,   11725320,  0x0b1f090},
        {2665436,    4269668,   14700000,   13888120,  0x0010016},
        {39212292,   -6860000,  39301572,   -6776755,  0x01e000a}, // TZA
        {39106059,   -6975680,  39453940,   -6629721,  0xf040047},
        {32865855,   -2687000,  33200744,   -2352111,  0xe890047},
        {39207815,   -6153000,  39294784,   -6066511,  0x3c1004b},
        {39185203,   -6239489,  39272172,   -6153000,  0x3c1004b},
        {33403175,   -8952600,  33490625,   -8866111,  0x3c1004b},
        {33490625,   -8952600,  33578075,   -8866111,  0x3c1004b},
        {36642935,   -3423500,  36729664,   -3337011,  0x3c1004b},
        {37620115,   -6847800,  37707084,   -6761311,  0x3c1004b},
        {39047635,   -5139800,  39134364,   -5053311,  0x3c1004b},
        {35696515,   -6213200,  35783484,   -6126711,  0x3c1004b},
        {29608135,   -4925000,  29694864,   -4838511,  0x3c1004b},
        {37296035,   -3389600,  37382764,   -3303111,  0x3c1004b},
        {32770035,   -5064100,  32856764,   -4977611,  0x3c1004b},
        {35608235,   -10704900, 35696165,   -10618411, 0x3c1004b},
        {33760155,   -1562200,  33846644,   -1475711,  0x3c1004b},
        {35646395,   -7813200,  35733604,   -7726711,  0x3c1004b},
        {32722175,   -9345700,  32809625,   -9259211,  0x3c1004b},
        {33377135,   -3702000,  33463864,   -3615511,  0x3c1004b},
        {40143635,   -10319700, 40231565,   -10233211, 0x3c1004b},
        {30360964,   -5120350,  30423235,   -5058251,  0x2b2004b},
        {36964773,   -6865560,  37025226,   -6805441,  0x29c004b},
        {31865464,   -3493550,  31927735,   -3431451,  0x2b2004b},
        {31592590,   -7990760,  31653210,   -7930641,  0x29c004b},
        {38858878,   -6468650,  38921322,   -6406551,  0x2b2004b},
        {31777740,   -1358260,  31837859,   -1298141,  0x29c004b},
        {31043078,   -6374050,  31105522,   -6311951,  0x2b2004b},
        {34721557,   -4848460,  34781843,   -4788341,  0x29c004b},
        {29965864,   -5024350,  30028135,   -4962251,  0x2b2004b},
        {34796406,   -8882760,  34857193,   -8822641,  0x29c004b},
        {32608950,   -2681050,  32671049,   -2618951,  0x2b2004b},
        {31899240,   -3034260,  31959359,   -2974141,  0x29c004b},
        {33838550,   -2046350,  33900649,   -1984251,  0x2b2004b},
        {36653190,   -8147660,  36713810,   -8087541,  0x29c004b},
        {34738005,   -9369050,  34800794,   -9306951,  0x2b2004b},
        {39675639,   -10026260, 39736760,   -9966141,  0x29c004b},
        {32910405,   -9137150,  32973194,   -9075051,  0x2b2004b},
        {36827773,   -6175460,  36888226,   -6115341,  0x29c004b},
        {36948292,   -7723250,  37010908,   -7661151,  0x2b2004b},
        {31015657,   -5152960,  31075943,   -5092841,  0x29c004b},
        {38774533,   -10754350, 38837667,   -10692251, 0x2b2004b},
        {38410457,   -5186960,  38470743,   -5126841,  0x29c004b},
        {30084964,   -4606150,  30147235,   -4544051,  0x2b2004b},
        {39245139,   -10964460, 39306260,   -10904341, 0x29c004b},
        {33048950,   -2881050,  33111049,   -2818951,  0x2b2004b},
        {35780206,   -8823660,  35840993,   -8763541,  0x29c004b},
        {35258092,   -8324650,  35320708,   -8262551,  0x2b2004b},
        {33849857,   -4310060,  33910143,   -4249941,  0x29c004b},
        {36600000,   -5220000,  39230000,   -2530000,  0x001000d},
        {36750000,   -7706880,  39600000,   -5220000,  0x09d0011},
        {33258840,   -9154920,  33732768,   -8663880,  0x0b00090},
        {35505640,   -6415520,  35974360,   -5924480,  0x0b10890},
        {29583740,   -5176920,  30052460,   -4685880,  0x0b01090},
        {32579040,   -5266420,  33047760,   -4775380,  0x0b01890},
        {35420440,   -10907220, 35894368,   -10416180, 0x0b12090},
        {33569040,   -1764520,  34037760,   -1273480,  0x0b02890},
        {35455640,   -8015520,  35924360,   -7524480,  0x0b13090},
        {32615939,   -9455920,  33089867,   -8964880,  0x0b03890},
        {33186139,   -3904320,  33654859,   -3413280,  0x0b04090},
        {39971652,   -10548520, 40445580,   -10057480, 0x0b14890},
        {30157740,   -5334820,  30626460,   -4843780,  0x0b05090},
        {31662240,   -3708020,  32130960,   -3216980,  0x0b05890},
        {31388540,   -8206220,  31857260,   -7715180,  0x0b16090},
        {31573440,   -1573720,  32042160,   -1082680,  0x0b06890},
        {30839940,   -6588520,  31308660,   -6097480,  0x0b17090},
        {34517340,   -5063920,  34986060,   -4572880,  0x0b07890},
        {34595040,   -9098220,  35068968,   -8607180,  0x0b08090},
        {32405640,   -2895520,  32874360,   -2404480,  0x0b08890},
        {31694940,   -3249720,  32163660,   -2758680,  0x0b09090},
        {33635240,   -2260819,  34103960,   -1769779,  0x0b09890},
        {36597640,   -8149920,  37066360,   -7658880,  0x0b1a090},
        {34537640,   -9583520,  35011568,   -9092480,  0x0b0a890},
        {39516440,   -10257820, 39990368,   -9766780,  0x0b0b090},
        {30811440,   -5368420,  31280160,   -4877380,  0x0b0b890},
        {38574340,   -10968820, 39048268,   -10477780, 0x0b1c090},
        {29881740,   -4820620,  30350460,   -4329580,  0x0b0c890},
        {39043940,   -11179920, 39517868,   -10688880, 0x0b1d090},
        {32854840,   -3163120,  33323560,   -2672080,  0x0b0d890},
        {35578840,   -9039120,  36052768,   -8548080,  0x0b0e090},
        {35055040,   -8539120,  35523760,   -8048080,  0x0b1e890},
        {33645640,   -4525520,  34114360,   -4034480,  0x0b0f090},
        {29327168,   -11761350, 40445580,   -984617,   0x0010016},
        {31200989,   30019755,  31299972,   30106245,  0x001000a}, // EGY
        {30858900,   29893000,  31551050,   30273150,  0x018000c},
        {29854048,   31142500,  29954952,   31228989,  0x3c1004b},
        {29934771,   31203042,  30035675,   31289531,  0x3c1004b},
        {29711348,   31058300,  29812252,   31144789,  0x3c1004b},
        {32243648,   31196500,  32344552,   31282989,  0x3c1004b},
        {32476149,   29932800,  32575851,   30019289,  0x3c1004b},
        {31114908,   30930800,  31253142,   30993400,  0x3c1044b},
        {32602191,   25656800,  32697809,   25743289,  0x3c1004b},
        {31327548,   30998600,  31428452,   31085089,  0x3c1004b},
        {31145790,   27138700,  31242609,   27225189,  0x3c1004b},
        {30946908,   30744800,  31047091,   30831289,  0x3c1004b},
        {32844491,   24036800,  32938908,   24123289,  0x3c1004b},
        {31040329,   29009200,  31139070,   29095689,  0x3c1004b},
        {31670730,   26506800,  31767069,   26593289,  0x3c1004b},
        {31464034,   30548950,  31535965,   30611049,  0x2b2004b},
        {30805682,   29279940,  30874318,   29340059,  0x29c004b},
        {32239834,   30562750,  32311765,   30624849,  0x2b2004b},
        {30096130,   31095740,  30166269,   31155859,  0x29c004b},
        {30426375,   31002050,  30498824,   31064149,  0x2b2004b},
        {30714416,   28067040,  30782384,   28127159,  0x29c004b},
        {32703787,   26140750,  32772613,   26202849,  0x2b2004b},
        {30971181,   30532040,  31040819,   30592159,  0x29c004b},
        {31131634,   30431550,  31203565,   30493649,  0x2b2004b},
        {30817783,   27700540,  30885417,   27760659,  0x29c004b},
        {30893975,   31062150,  30966424,   31124249,  0x2b2004b},
        {31529748,   30394540,  31599052,   30454659,  0x29c004b},
        {33773075,   31090250,  33845524,   31152349,  0x2b2004b},
        {31235181,   30679940,  31304819,   30740059,  0x29c004b},
        {31845414,   26298950,  31914585,   26361049,  0x2b2004b},
        {32836934,   24949940,  32903065,   25010059,  0x29c004b},
        {31298779,   29820050,  31370020,   29882149,  0x2b2004b},
        {30604930,   31099940,  30675069,   31160059,  0x29c004b},
        {30263775,   31278950,  30336224,   31341049,  0x2b2004b},
        {31314930,   31189940,  31385069,   31250059,  0x29c004b},
        {31983775,   31138950,  32056224,   31201049,  0x2b2004b},
        {31635181,   30699940,  31704819,   30760059,  0x29c004b},
        {31563775,   31048950,  31636224,   31111049,  0x2b2004b},
        {29743430,   30976840,  29813569,   31036959,  0x29c004b},
        {31783775,   31388950,  31856224,   31451049,  0x2b2004b},
        {30676116,   28283340,  30744084,   28343459,  0x29c004b},
        {30885534,   30445250,  30957465,   30507349,  0x2b2004b},
        {31469617,   26737340,  31536583,   26797459,  0x29c004b},
        {31103752,   29132750,  31174648,   29194849,  0x2b2004b},
        {31422481,   30856840,  31492119,   30916959,  0x29c004b},
        {30814379,   29458950,  30885620,   29521049,  0x2b2004b},
        {30258181,   30881340,  30327819,   30941459,  0x29c004b},
        {30990507,   30403950,  31062093,   30466049,  0x2b2004b},
        {30917783,   27284140,  30985417,   27344259,  0x29c004b},
        {32522273,   25593550,  32590927,   25655649,  0x2b2004b},
        {30785181,   30789940,  30854819,   30850059,  0x29c004b},
        {29300000,   29848000,  32586000,   31604000,  0x004010c},
        {30348000,   28860000,  31400000,   29848000,  0x004010c},
        {30545000,   27423000,  30930000,   28860000,  0x004018c},
        {30715000,   27151000,  31391000,   27423000,  0x004018c},
        {33617000,   26400000,  34110000,   27434000,  0x004018c},
        {30350241,   24593166,  33269759,   27274356,  0x001000d},
        {30380032,   21911977,  33239968,   24593167,  0x0010015},
        {24690000,   21660000,  36908500,   31678500,  0x0010016},
        {-16027750,  18028850,  -15934870,  18111666,  0x01e000a}, // MRT
        {-16086029,  17822880,  -15596477,  18313920,  0x001000c},
        {-11463703,  16558890,  -11336298,  16681199,  0x54f004b},
        {-13560333,  16096490,  -13433268,  16218799,  0x54f004b},
        {-13433268,  16096490,  -13306203,  16218799,  0x54f004b},
        {-15866003,  16468290,  -15738598,  16590599,  0x54f004b},
        {-12544151,  22668690,  -12411650,  22790999,  0x54f004b},
        {-13111932,  20460590,  -12981469,  20582899,  0x54f004b},
        {-7337103,   16558890,  -7209698,   16681199,  0x54f004b},
        {-11489582,  18492690,  -11360818,  18614999,  0x54f004b},
        {-13563873,  16938890,  -13436128,  17061199,  0x54f004b},
        {-7100173,   17243290,  -6972428,   17365599,  0x54f004b},
        {-14445887,  19706800,  -14354113,  19793289,  0x3c1004b},
        {-13968367,  17010200,  -13878034,  17096689,  0x3c1004b},
        {-14311446,  16567300,  -14221354,  16653789,  0x3c1004b},
        {-12241986,  15115500,  -12152614,  15201989,  0x3c1004b},
        {-12407407,  20420900,  -12315393,  20507389,  0x3c1004b},
        {-8215726,   16199300,  -8125874,   16285789,  0x3c1004b},
        {-9665046,   16616800,  -9574954,   16703289,  0x3c1004b},
        {-9471526,   15762900,  -9381674,   15849389,  0x3c1004b},
        {-12739448,  22646200,  -12645752,  22732689,  0x3c1004b},
        {-11611609,  25170200,  -11515991,  25256689,  0x3c1004b},
        {-11675428,  20886400,  -11583173,  20972889,  0x3c1004b},
        {-16525000,  16068000,  -13384576,  18400000,  0x0940011},
        {-13433300,  14710000,  -10363000,  17045230,  0x01b000d},
        {-10363000,  15358000,  -6800000,   17440433,  0x2ec0015},
        {-17240000,  14710000,  -4790000,   27367000,  0x0010016},
        {-63225667,  -17830445, -63135333,  -17743955, 0x001000a}, // BOL
        {-63270587,  -17930570, -62970214,  -17643741, 0xc730047},
        {-66358086,  -17503300, -65957431,  -17308000, 0xbde0447},
        {-68324000,  -16666000, -67982564,  -16438000, 0xbde0447},
        {-67168812,  -18018510, -67040388,  -17896201, 0x54f004b},
        {-65316747,  -19077800, -65225453,  -18991311, 0x3c1004b},
        {-64769968,  -21571600, -64677233,  -21485111, 0x3c1004b},
        {-65799787,  -19621700, -65708013,  -19535211, 0x3c1004b},
        {-63297567,  -17378300, -63207234,  -17291811, 0x3c1004b},
        {-64942085,  -14856400, -64794774,  -14804000, 0x3c1044b},
        {-63692690,  -22058188, -63629997,  -21930000, 0x3c1044b},
        {-66096465,  -11054900, -66008535,  -10968411, 0x3c1004b},
        {-65398665,  -10866900, -65310735,  -10780411, 0x3c1004b},
        {-66615527,  -18490800, -66524474,  -18404311, 0x3c1004b},
        {-65645108,  -22139400, -65551892,  -22052911, 0x3c1004b},
        {-63570507,  -20074900, -63478493,  -19988411, 0x3c1004b},
        {-64382748,  -22777300, -64289052,  -22690811, 0x3c1004b},
        {-65766368,  -21483200, -65673633,  -21396711, 0x3c1004b},
        {-68798765,  -11063900, -68710835,  -10977411, 0x3c1004b},
        {-61011846,  -16419200, -60921754,  -16332711, 0x3c1004b},
        {-63207587,  -17566500, -63117014,  -17480011, 0x3c1004b},
        {-66788386,  -14903500, -66699014,  -14817011, 0x3c1004b},
        {-63505900,  -21287760, -63314735,  -21245870, 0x3c1044b},
        {-66885407,  -18333200, -66794594,  -18246711, 0x3c1004b},
        {-63910350,  -17423000, -63719495,  -17382000, 0x3c1044b},
        {-65901329,  -17562311, -65742236,  -17513140, 0x3c1044b},
        {-63274067,  -17160000, -63183734,  -17073511, 0x3c1004b},
        {-65468746,  -13782800, -65379855,  -13696311, 0x3c1004b},
        {-63229726,  -15935300, -63139874,  -15848811, 0x3c1004b},
        {-67604126,  -15879800, -67514274,  -15793311, 0x3c1004b},
        {-63436407,  -18044300, -63345594,  -17957811, 0x3c1004b},
        {-57846247,  -19020200, -57754953,  -18933711, 0x3c1004b},
        {-63445287,  -17403200, -63354714,  -17316711, 0x3c1004b},
        {-66876007,  -20503200, -66783993,  -20416711, 0x3c1004b},
        {-65140747,  -19664033, -62340393,  -16982843, 0x0a80011},
        {-67941101,  -19664033, -65140747,  -16982843, 0x001000d},
        {-68751417,  -16982842, -66010645,  -14301652, 0x0010015},
        {-69660000,  -22910000, -57440000,  -9669100,  0x0010016},
        {38696150,   8980000,   38779000,   9070000,   0x020000a}, // ETH
        {38587540,   8686380,   39061468,   9177420,   0x001000c},
        {41775900,   9566000,   41894250,   9630000,   0x3c1044b},
        {39436354,   13465000,  39525245,   13551489,  0x3c1004b},
        {39228475,   8502100,   39315925,   8588589,   0x3c1004b},
        {37343315,   11549900,  37431485,   11636389,  0x3c1004b},
        {37408994,   12547800,  37497405,   12634289,  0x3c1004b},
        {39600615,   11088500,  39688785,   11174989,  0x3c1004b},
        {38455395,   7011000,   38535344,   7105300,   0x3c1044b},
        {36797195,   7629100,   36884404,   7715589,   0x3c1004b},
        {42079575,   9266500,   42167025,   9352989,   0x3c1004b},
        {38573395,   7157200,   38660604,   7243689,   0x3c1004b},
        {37528015,   5988700,   37614984,   6075189,   0x3c1004b},
        {39700515,   11035200,  39788685,   11121689,  0x3c1004b},
        {36502975,   9047000,   36590425,   9133489,   0x3c1004b},
        {37686535,   10297800,  37774465,   10384289,  0x3c1004b},
        {39101492,   7932350,   39164108,   7994449,   0x2b2004b},
        {39430922,   14250540,  39492878,   14310659,  0x29c004b},
        {37827792,   7521150,   37890408,   7583249,   0x2b2004b},
        {37732190,   6819340,   37792810,   6879459,   0x29c004b},
        {39499619,   9637450,   39562580,   9699549,   0x2b2004b},
        {38271573,   6384940,   38332026,   6445059,   0x29c004b},
        {39938692,   6978950,   40001308,   7041049,   0x2b2004b},
        {39529272,   12389940,  39590727,   12450059,  0x29c004b},
        {38244188,   14066450,  38308012,   14128549,  0x2b2004b},
        {37827106,   8945340,   37887893,   9005459,   0x29c004b},
        {39545678,   5301050,   39608122,   5363149,   0x2b2004b},
        {42768506,   9321540,   42829293,   9381659,   0x29c004b},
        {38699788,   14087150,  38763612,   14149249,  0x2b2004b},
        {38850705,   14143040,  38912494,   14203159,  0x29c004b},
        {37941505,   8501350,   38004294,   8563449,   0x2b2004b},
        {39561856,   11800240,  39623144,   11860359,  0x29c004b},
        {38360778,   6712550,   38423222,   6774649,   0x2b2004b},
        {38789690,   8119940,   38850310,   8180059,   0x29c004b},
        {39088605,   8568950,   39151394,   8631049,   0x2b2004b},
        {39599690,   7829940,   39660310,   7890059,   0x29c004b},
        {39611160,   12134050,  39674639,   12196149,  0x2b2004b},
        {35799606,   9149940,   35860393,   9210059,   0x29c004b},
        {38338692,   8088950,   38401308,   8151049,   0x2b2004b},
        {40857006,   9039740,   40917793,   9099859,   0x29c004b},
        {38948778,   5848950,   39011222,   5911049,   0x2b2004b},
        {39509189,   12749940,  39570811,   12810059,  0x29c004b},
        {38706119,   9753050,   38769080,   9815149,   0x2b2004b},
        {38684890,   7887440,   38745510,   7947559,   0x29c004b},
        {34772105,   8510250,   34834894,   8572349,   0x2b2004b},
        {37853056,   11047240,  37914344,   11107359,  0x29c004b},
        {41040247,   11707850,  41103553,   11769949,  0x2b2004b},
        {34559690,   8219940,   34620310,   8280059,   0x29c004b},
        {36480133,   10931550,  36543267,   10993649,  0x2b2004b},
        {38480006,   9040140,   38540793,   9100259,   0x29c004b},
        {37419583,   6653028,   40100773,   9334218,   0x0a90011},
        {37258712,   9334218,   39969693,   12015408,  0x001000d},
        {37258712,   12015408,  39969693,   14696598,  0x0010015},
        {32970000,   3390000,   47999500,   14894220,  0x3360016},
        {-74133245,  4586755,   -74046755,  4673245,   0x001000a}, // COL
        {-74228439,  4484000,   -73996769,  4840000,   0xc730447},
        {-76647089,  3283290,   -76372911,  3556709,   0xbde0047},
        {-75727469,  6113290,   -75452531,  6386709,   0xbde0047},
        {-74848000,  10962000,  -74757782,  11046200,  0x3c1044b},
        {-74844000,  10884000,  -74746554,  10962000,  0x3c1044b},
        {-75566000,  10390000,  -75450894,  10456000,  0x3c1044b},
        {-75535000,  10309000,  -75441305,  10390000,  0x3c1044b},
        {-72548200,  7866800,   -72459357,  7951600,   0x3c1044b},
        {-73179305,  7095900,   -73092096,  7182389,   0x3c1044b},
        {-75723365,  4766800,   -75636636,  4853289,   0x3c1044b},
        {-74238000,  11179700,  -74140746,  11258000,  0x3c1044b},
        {-75258165,  4405500,   -75141924,  4470000,   0x3c1044b},
        {-77323245,  1156800,   -77236756,  1243289,   0x3c1044b},
        {-75550265,  5024000,   -75421119,  5082000,   0x3c1044b},
        {-75319645,  2899400,   -75233156,  2985889,   0x3c1044b},
        {-73660665,  4093000,   -73563377,  4170000,   0x3c1044b},
        {-75721865,  4490500,   -75635136,  4576989,   0x3c1044b},
        {-73306065,  10418800,  -73218135,  10505289,  0x3c1044b},
        {-75918225,  8719300,   -75833050,  8808000,   0x3c1044b},
        {-75439425,  9257800,   -75351975,  9344289,   0x3c1044b},
        {-73143005,  7012300,   -73055796,  7098789,   0x3c1044b},
        {-76349665,  3490000,   -76255987,  3570000,   0x3c1044b},
        {-77083565,  3855000,   -76909203,  3898000,   0x3c1044b},
        {-76648745,  2420000,   -76555326,  2500000,   0x3c1044b},
        {-73897705,  7030000,   -73793162,  7102000,   0x3c1044b},
        {-75809065,  4769900,   -75722336,  4856389,   0x3c1044b},
        {-76253365,  4046800,   -76166636,  4133289,   0x3c1044b},
        {-75965765,  4706600,   -75879036,  4793089,   0x3c1044b},
        {-74830236,  4269350,   -74767965,  4331449,   0x2b2044b},
        {-75650060,  1579940,   -75589941,  1640059,   0x29c044b},
        {-72272353,  11350450,  -72209047,  11412549,  0x2b2044b},
        {-72958527,  5690140,   -72898074,  5750259,   0x29c044b},
        {-76328236,  3872750,   -76265965,  3934849,   0x2b2044b},
        {-73384627,  5506000,   -73332048,  5575000,   0x29c044b},
        {-73201308,  7038950,   -73138692,  7101049,   0x2b2044b},
        {-74801961,  10840240,  -74740840,  10900359,  0x29c044b},
        {-74803780,  9221000,   -74731254,  9274700,   0x2b2044b},
        {-72938800,  11503040,  -72874209,  11560000,  0x29c044b},
        {-74391136,  4788950,   -74328865,  4851049,   0x2b2044b},
        {-73064327,  5795540,   -73003874,  5855659,   0x29c044b},
        {-76750000,  3210000,   -73242159,  5235500,   0x0800011},
        {-76134830,  8386600,   -73713108,  11295000,  0x022000d},
        {-72814560,  7640180,   -72345840,  8131220,   0x0b10090},
        {-73348660,  6829380,   -72879940,  7320420,   0x0b10890},
        {-77720560,  779880,    -77251840,  1270920,   0x0b01090},
        {-75544360,  2732480,   -75075640,  3223520,   0x0b01890},
        {-73498360,  10020880,  -73024432,  10511920,  0x0b12090},
        {-77294360,  3630980,   -76825640,  4122020,   0x0b02890},
        {-76843860,  2258180,   -76375140,  2749220,   0x0b03090},
        {-74117860,  6820480,   -73649140,  7311520,   0x0b13890},
        {-76075160,  1545280,   -75606440,  2036320,   0x0b04090},
        {-72487460,  11135980,  -72013532,  11627020,  0x0b14890},
        {-73388960,  5435280,   -72920240,  5926320,   0x0b15090},
        {-73153060,  11225980,  -72679132,  11717020,  0x0b15890},
        {-79043460,  1350580,   -78574740,  1841620,   0x0b06090},
        {-76924360,  7639480,   -76455640,  8130520,   0x0b16890},
        {-73719360,  8029480,   -73250640,  8520520,   0x0b17090},
        {-74904360,  5224480,   -74435640,  5715520,   0x0b07890},
        {-76894360,  5444480,   -76425640,  5935520,   0x0b18090},
        {-70988260,  6625580,   -70519540,  7116620,   0x0b18890},
        {-75754360,  5949480,   -75285640,  6440520,   0x0b19090},
        {-72644360,  5104480,   -72175640,  5595520,   0x0b09890},
        {-81735968,  12334480,  -81256832,  12825520,  0x0b0a090},
        {-75244360,  7549480,   -74775640,  8040520,   0x0b1a890},
        {-72889460,  7155380,   -72420740,  7646420,   0x0b1b090},
        {-74054360,  5374480,   -73585640,  5865520,   0x0b1b890},
        {-76658060,  2725180,   -76189340,  3216220,   0x0b0c090},
        {-74934360,  6824480,   -74465640,  7315520,   0x0b1c890},
        {-74654360,  6234480,   -74185640,  6725520,   0x0b1d090},
        {-73373260,  6347380,   -72904540,  6838420,   0x0b1d890},
        {-72129460,  6531580,   -71660740,  7022620,   0x0b1e090},
        {-75946760,  1997380,   -75478040,  2488420,   0x0b0e890},
        {-79060000,  -4230000,  -66860000,  12460000,  0x44a0016},
        {-81736000,  10500000,  -79060000,  13395000,  0x0b50012},
        {-81736000,  -4230000,  -66860000,  13395000,  0x0010217},
        {18371780,   -33948000, 18459691,   -33897133, 0x2a7044a}, // ZAF
        {18459691,   -33983623, 18511422,   -33897133, 0x2a7044a},
        {30957089,   -29910500, 31056311,   -29824011, 0x3c1004b},
        {27992071,   -26233200, 28087929,   -26146711, 0x3c1004b},
        {28159371,   -25781100, 28255229,   -25694611, 0x3c1004b},
        {27810871,   -26298200, 27906729,   -26211711, 0x3c1004b},
        {25546906,   -33999600, 25650693,   -33913111, 0x3c1004b},
        {28253971,   -26223000, 28349829,   -26136511, 0x3c1004b},
        {27905530,   -26693800, 28001869,   -26607311, 0x3c1004b},
        {30345489,   -29656400, 30444711,   -29569911, 0x3c1004b},
        {27834307,   -33048500, 27936892,   -32962011, 0x3c1004b},
        {28159571,   -26056700, 28255429,   -25970211, 0x3c1004b},
        {26164529,   -29162200, 26263270,   -29075711, 0x3c1004b},
        {28160971,   -26282400, 28256829,   -26195911, 0x3c1004b},
        {27787130,   -26750600, 27883469,   -26664111, 0x3c1004b},
        {29892150,   -27792800, 29989450,   -27706311, 0x3c1004b},
        {27729871,   -26151900, 27825729,   -26065411, 0x3c1004b},
        {26690110,   -28011500, 26787890,   -27925011, 0x3c1004b},
        {28312871,   -26292600, 28408729,   -26206111, 0x3c1004b},
        {28405871,   -26290900, 28501729,   -26204411, 0x3c1004b},
        {25354406,   -33809100, 25458193,   -33722611, 0x3c1004b},
        {29203987,   -25915450, 29272813,   -25853351, 0x2b2004b},
        {28096117,   -26301860, 28163083,   -26241741, 0x29c004b},
        {26674152,   -29260850, 26745048,   -29198751, 0x2b2004b},
        {18944728,   -33756660, 19016871,   -33696541, 0x29c004b},
        {28076187,   -26021650, 28145013,   -25959551, 0x2b2004b},
        {24718149,   -28766760, 24786451,   -28706641, 0x29c004b},
        {26621042,   -26890550, 26690558,   -26828451, 0x2b2004b},
        {27359717,   -26388160, 27426683,   -26328041, 0x29c004b},
        {28151787,   -25891450, 28220613,   -25829351, 0x2b2004b},
        {18803928,   -34100060, 18876071,   -34039941, 0x29c004b},
        {27663787,   -26208550, 27732613,   -26146451, 0x2b2004b},
        {29434284,   -25789660, 29500916,   -25729541, 0x29c004b},
        {27200973,   -25688950, 27269627,   -25626851, 0x2b2004b},
        {28352017,   -26388560, 28418983,   -26328441, 0x29c004b},
        {27058914,   -26742150, 27128085,   -26680051, 0x2b2004b},
        {22411728,   -33998960, 22483871,   -33938841, 0x29c004b},
        {29745124,   -28586850, 29815675,   -28524751, 0x2b2004b},
        {29422685,   -23922260, 29488315,   -23862141, 0x29c004b},
        {28954718,   -24196250, 29022682,   -24134151, 0x2b2004b},
        {30595615,   -29839560, 30664585,   -29779441, 0x29c004b},
        {28048273,   -25527550, 28116927,   -25465451, 0x2b2004b},
        {19409128,   -33674660, 19481271,   -33614541, 0x29c004b},
        {29050814,   -26577450, 29119985,   -26515351, 0x2b2004b},
        {27176183,   -27690060, 27243817,   -27629941, 0x29c004b},
        {18345468,   -34139912, 18907932,   -33648872, 0x001000c},
        {30618792,   -30134820, 31155216,   -29643780, 0x0010088},
        {25201968,   -34056720, 25764432,   -33565680, 0x0010888},
        {30031992,   -29915520, 30568416,   -29424480, 0x0011088},
        {27353976,   -33255519, 27906024,   -32764479, 0x0011888},
        {25989192,   -29395220, 26520408,   -28904180, 0x0012088},
        {29817200,   -28200520, 30343208,   -27709480, 0x0012888},
        {26682200,   -28120520, 27208208,   -27629480, 0x0013088},
        {26514392,   -29465520, 27045608,   -28974480, 0x0013888},
        {18892668,   -34177120, 19455132,   -33686080, 0x0014088},
        {24457692,   -28970620, 24988908,   -28479580, 0x0014888},
        {22138276,   -34035220, 22695532,   -33544180, 0x0015088},
        {30872908,   -25573920, 31388500,   -25082880, 0x0015888},
        {30929808,   -24180520, 31440192,   -23689480, 0x0016088},
        {29710500,   -28774620, 30236508,   -28283580, 0x0016888},
        {28969808,   -24270520, 29480192,   -23779480, 0x0017088},
        {19096676,   -33745520, 19653932,   -33254480, 0x0017888},
        {31722092,   -28997020, 32253308,   -28505980, 0x0018088},
        {29642616,   -23285520, 30147792,   -22794480, 0x0018888},
        {28521784,   -31825520, 29068624,   -31334480, 0x0019088},
        {25908008,   -26423420, 26423600,   -25932380, 0x0019888},
        {26426676,   -33695520, 26983932,   -33204480, 0x001a088},
        {30497200,   -28115520, 31023208,   -27624480, 0x001a888},
        {18326576,   -33755519, 18883832,   -33264479, 0x001b088},
        {28107200,   -28250520, 28633208,   -27759480, 0x001b888},
        {26741684,   -32125520, 27288524,   -31634480, 0x001c088},
        {17852776,   -33197220, 18404824,   -32706180, 0x001c888},
        {21815368,   -34384420, 22377832,   -33893380, 0x001d088},
        {20972200,   -28705520, 21498208,   -28214480, 0x001d888},
        {25376308,   -26116120, 25891900,   -25625080, 0x001e088},
        {29627508,   -26585520, 30143100,   -26094480, 0x001e888},
        {30352616,   -23375520, 30857792,   -22884480, 0x001f088},
        {28712100,   -28645520, 29238108,   -28154480, 0x0b10090},
        {24469600,   -27205520, 24990400,   -26714480, 0x0b00890},
        {22935768,   -34103020, 23498232,   -33611980, 0x0b01090},
        {31034292,   -29580520, 31565508,   -29089480, 0x0b11890},
        {22293976,   -32595520, 22846024,   -32104480, 0x0b02090},
        {24263976,   -32545519, 24816024,   -32054479, 0x0b02890},
        {30061384,   -31101420, 30603016,   -30610380, 0x0b03090},
        {27823976,   -32575520, 28376024,   -32084480, 0x0b03890},
        {30549600,   -27245520, 31070400,   -26754480, 0x0b14090},
        {29554392,   -29275520, 30085608,   -28784480, 0x0b04890},
        {25069600,   -27435520, 25590400,   -26944480, 0x0b15090},
        {25341784,   -32445520, 25888624,   -31954480, 0x0b15890},
        {30797408,   -26025520, 31313000,   -25534480, 0x0b16090},
        {26353976,   -33015520, 26906024,   -32524480, 0x0b16890},
        {23736992,   -30895520, 24273416,   -30404480, 0x0b17090},
        {25524500,   -27670520, 26045300,   -27179480, 0x0b17890},
        {29244808,   -24445520, 29755192,   -23954480, 0x0b08090},
        {29156992,   -30795520, 29693416,   -30304480, 0x0b18890},
        {18948768,   -34655520, 19511232,   -34164480, 0x0b19090},
        {29962616,   -24030520, 30467792,   -23539480, 0x0b19890},
        {26102200,   -28085520, 26628208,   -27594480, 0x0b0a090},
        {29629600,   -27605520, 30150400,   -27114480, 0x0b1a890},
        {30486992,   -30525520, 31023416,   -30034480, 0x0b1b090},
        {26439184,   -30935520, 26980816,   -30444480, 0x0b0b890},
        {19923768,   -34155520, 20486232,   -33664480, 0x0b0c090},
        {24662300,   -28195520, 25188308,   -27704480, 0x0b0c890},
        {26462200,   -28645520, 26988208,   -28154480, 0x0b1d090},
        {30197408,   -25335520, 30713000,   -24844480, 0x0b0d890},
        {27133976,   -32805520, 27686024,   -32314480, 0x0b0e090},
        {28144808,   -24945520, 28655192,   -24454480, 0x0b1e890},
        {27362200,   -28565520, 27888208,   -28074480, 0x0b1f090},
        {26542941,   -27500595, 29492250,   -24819405, 0x0a80011},
        {16440000,   -34900000, 33000000,   -22116000, 0x3580016},
        {37000000,   -47400000, 38500000,   -46300000, 0x001988d},
        {-19000000,  -47500000, 60000000,   37550000,  0x3e50217},
        {16440000,   -47400000, 38500000,   -22116000, 0x003021c},
        {-8032023,   12595155,  -7943611,   12681645,  0x001000a}, // MLI
        {-8245146,   12392934,  -7766010,   12883974,  0x001000c},
        {-5721785,   11275900,  -5633615,   11362389,  0x3c1004b},
        {-5512206,   12334900,  -5423795,   12421389,  0x3c1004b},
        {-4224566,   14446800,  -4135435,   14533289,  0x3c1004b},
        {-4131166,   14488500,  -4042035,   14574989,  0x3c1004b},
        {-11484566,  14406800,  -11395435,  14493289,  0x3c1004b},
        {-4953346,   13236700,  -4864455,   13323189,  0x3c1004b},
        {-6321346,   13372600,  -6232455,   13459089,  0x3c1004b},
        {-6234446,   13415400,  -6145555,   13501889,  0x3c1004b},
        {-9628106,   15206800,  -9538494,   15293289,  0x3c1004b},
        {-3440026,   16223900,  -3350174,   16310389,  0x3c1004b},
        {-6120546,   13657500,  -6031655,   13743989,  0x3c1004b},
        {-3050646,   16728900,  -2960554,   16815389,  0x3c1004b},
        {-4597246,   13881600,  -4508355,   13968089,  0x3c1004b},
        {-62326,     16227600,  27526,      16314089,  0x3c1004b},
        {-8079546,   13535900,  -7990655,   13622389,  0x3c1004b},
        {-7534085,   11376800,  -7445915,   11463289,  0x3c1004b},
        {-6034166,   14198500,  -5945035,   14284989,  0x3c1004b},
        {-7597226,   12827900,  -7508575,   12914389,  0x3c1004b},
        {-7490646,   13504500,  -7401755,   13590989,  0x3c1004b},
        {-7329786,   15125400,  -7240414,   15211889,  0x3c1004b},
        {-10881646,  13744200,  -10792755,  13830689,  0x3c1004b},
        {-8470485,   11874400,  -8382315,   11960889,  0x3c1004b},
        {1364673,    18398800,  1455726,    18485289,  0x3c1004b},
        {-3126446,   14028500,  -3037555,   14114989,  0x3c1004b},
        {-4022257,   15898950,  -3957743,   15961049,  0x2b2004b},
        {-3692512,   16385840,  -3629888,   16445959,  0x29c004b},
        {-6927753,   11066150,  -6864447,   11128249,  0x2b2004b},
        {-4810528,   12325340,  -4749073,   12385459,  0x29c004b},
        {-5388112,   13957650,  -5324288,   14019749,  0x2b2004b},
        {-2981362,   14974940,  -2919239,   15035059,  0x29c004b},
        {-3641998,   14318950,  -3578002,   14381049,  0x2b2004b},
        {-4948778,   14423040,  -4886822,   14483159,  0x29c004b},
        {-4957626,   12803250,  -4893975,   12865349,  0x2b2004b},
        {-9520811,   13009940,  -9459189,   13070059,  0x29c004b},
        {-6136285,   14701450,  -6072116,   14763549,  0x2b2004b},
        {-6033795,   13692240,  -5972006,   13752359,  0x29c004b},
        {-3781757,   16090350,  -3717243,   16152449,  0x2b2004b},
        {-6801844,   11829740,  -6740556,   11889859,  0x29c004b},
        {-9076903,   11722831,  -6365922,   14404021,  0x001000d},
        {-6395713,   12259069,  -3654941,   14940259,  0x0a80011},
        {-254368,    16025280,  229976,     16516320,  0x0b10090},
        {-6056760,   10992980,  -5582832,   11484020,  0x0b10890},
        {-11662768,  14131180,  -11183632,  14622220,  0x0b11090},
        {-9791768,   14950480,  -9307424,   15441520,  0x0b01890},
        {-3802868,   16022680,  -3318524,   16513720,  0x0b12090},
        {-3231568,   16360880,  -2747224,   16851920,  0x0b12890},
        {-7721760,   11174480,  -7247832,   11665520,  0x0b13090},
        {-7706668,   14897280,  -7222324,   15388320,  0x0b03890},
        {-11173068,  13454580,  -10693932,  13945620,  0x0b14090},
        {1165424,    18196480,  1654976,    18687520,  0x0b14890},
        {-3321568,   13826180,  -2842432,   14317220,  0x0b15090},
        {-4316368,   15630380,  -3832024,   16121420,  0x0b05890},
        {-7072160,   11000180,  -6598232,   11491220,  0x0b16090},
        {-3245468,   14714480,  -2761124,   15205520,  0x0b06890},
        {-3817268,   13992780,  -3338132,   14483820,  0x0b17090},
        {-9894868,   12975880,  -9415732,   13466920,  0x0b07890},
        {-6621509,   22328810,  -3731782,   25010000,  0x0a80091},
        {-3731782,   22328810,  -842055,    25010000,  0x0a80891},
        {-6591718,   19836096,  -3761573,   22517286,  0x0a91091},
        {-3761573,   19836096,  -931428,    22517286,  0x0a91891},
        {-931428,    19836096,  1898717,    22517286,  0x0a92091},
        {1444855,    19836096,  4275000,    22517286,  0x0a92891},
        {-6591718,   17154906,  -3791364,   19836096,  0x0a83091},
        {-3791364,   17154906,  -991010,    19836096,  0x0a83891},
        {-991010,    17154906,  1809344,    19836096,  0x0a84091},
        {1474646,    17154906,  4275000,    19836096,  0x0a84891},
        {-12250000,  13073716,  -9509228,   15754906,  0x0a85091},
        {-9561881,   13073716,  -6821109,   15754906,  0x0a85891},
        {-6821109,   14473716,  -4080337,   17154906,  0x0a96091},
        {-4080337,   14473716,  -1339565,   17154906,  0x0a96891},
        {-1339565,   14473716,  1401207,    17154906,  0x0a97091},
        {1401207,    15200000,  4275000,    17154906,  0x08d7891},
        {-12250000,  11792526,  -9539019,   14473716,  0x0a98891},
        {-9561880,   11792526,  -6850899,   14473716,  0x0a99091},
        {-6850900,   11792526,  -4139919,   14473716,  0x0a99891},
        {-4139919,   11792526,  -1428938,   14473716,  0x0a9a091},
        {-8900000,   10130000,  -5150000,   11795000,  0x071a891},
        {-12250000,  10130000,  4275000,    25010000,  0x0010217},
        {13202002,   -8880543,  13289453,   -8794053,  0x001000a}, // AGO
        {13019857,   -9163728,  13493785,   -8672688,  0x001000c},
        {19856615,   -11823970, 19959924,   -11750236, 0x3c1044b},
        {13468000,   -14875400, 13612521,   -14822000, 0x3c1044b},
        {13433714,   -14961800, 13523086,   -14875311, 0x3c1004b},
        {13523086,   -14961800, 13612458,   -14875311, 0x3c1004b},
        {15674217,   -12829510, 15736853,   -12707201, 0x3c1044b},
        {15736853,   -12829510, 15799489,   -12707201, 0x3c1044b},
        {13340386,   -12680910, 13402853,   -12558601, 0x3c1044b},
        {13402853,   -12640910, 13465320,   -12518601, 0x3c1044b},
        {16902000,   -12434400, 16973207,   -12327200, 0x3c1044b},
        {13513994,   -12401100, 13602405,   -12314611, 0x3c1004b},
        {13507894,   -12484200, 13596305,   -12397711, 0x3c1004b},
        {12107914,   -15229800, 12197286,   -15143311, 0x3c1004b},
        {16294000,   -9581000,  16395012,   -9506000,  0x3c1044b},
        {12160500,   -5619000,  12257515,   -5541600,  0x3c1044b},
        {20346700,   -9708000,  20449081,   -9634000,  0x3c1044b},
        {14194415,   -6304200,  14281384,   -6217711,  0x3c1004b},
        {15006395,   -7663200,  15093604,   -7576711,  0x3c1004b},
        {20688995,   -8474000,  20776204,   -8387511,  0x3c1004b},
        {15073415,   -11434100, 15161585,   -11347611, 0x3c1004b},
        {13813315,   -11250700, 13901485,   -11164211, 0x3c1004b},
        {12318715,   -6196900,  12405684,   -6110411,  0x3c1004b},
        {13629105,   -8608850,  13691894,   -8546751,  0x2b2004b},
        {17664122,   -14690460, 17726078,   -14630341, 0x29c004b},
        {15525174,   -12880150, 15588825,   -12818051, 0x2b2004b},
        {14657805,   -13819560, 14719594,   -13759441, 0x29c004b},
        {14878605,   -9331050,  14941394,   -9268951,  0x2b2004b},
        {15218289,   -12948360, 15279911,   -12888241, 0x29c004b},
        {17247960,   -12177750, 17311439,   -12115651, 0x2b2004b},
        {22200839,   -10739760, 22261960,   -10679641, 0x29c004b},
        {17447547,   -12058250, 17510853,   -11996151, 0x2b2004b},
        {16194372,   -12593860, 16255827,   -12533741, 0x29c004b},
        {20408347,   -11681050, 20471653,   -11618951, 0x2b2004b},
        {12852290,   -7260360,  12912910,   -7200241,  0x29c004b},
        {15338692,   -8221050,  15401308,   -8158951,  0x2b2004b},
        {20747256,   -11593360, 20808544,   -11533241, 0x29c004b},
        {15681370,   -17100050, 15746229,   -17037951, 0x2b2004b},
        {15033705,   -13769660, 15095494,   -13709541, 0x29c004b},
        {14272247,   -11438350, 14335553,   -11376251, 0x2b2004b},
        {15246590,   -7790260,  15307210,   -7730141,  0x29c004b},
        {17960805,   -8804850,  18023594,   -8742751,  0x2b2004b},
        {14822190,   -7379960,  14882810,   -7319841,  0x29c004b},
        {14349503,   -13947792, 17060484,   -11266602, 0x0a90011},
        {12807084,   -9735525,  15488274,   -7054335,  0x001000d},
        {19676509,   -12032622, 20150437,   -11541582, 0x0b10090},
        {13283547,   -15137420, 13762683,   -14646380, 0x0b10890},
        {13231827,   -12743280, 13710963,   -12252240, 0x0b01090},
        {11915641,   -15432075, 12399985,   -14941035, 0x0b01890},
        {16112749,   -9789020,  16586677,   -9297980,  0x0b02090},
        {11974645,   -5825819,  12443365,   -5334779,  0x0b12890},
        {20166139,   -9916520,  20640067,   -9425480,  0x0b03090},
        {14003535,   -6506475,  14472255,   -6015435,  0x0b13890},
        {20498235,   -8676275,  20966955,   -8185235,  0x0b14090},
        {13625639,   -11452975, 14099567,   -10961935, 0x0b14890},
        {12127835,   -6399175,  12596555,   -5908135,  0x0b15090},
        {17455537,   -14905920, 17934673,   -14414880, 0x0b15890},
        {17147649,   -12332470, 17621577,   -11841430, 0x0b16090},
        {21999639,   -10955220, 22473567,   -10464180, 0x0b16890},
        {20376689,   -11852665, 20850617,   -11361625, 0x0b17090},
        {15469019,   -17314520, 15958571,   -16823480, 0x0b07890},
        {14072149,   -11652820, 14546077,   -11161780, 0x0b18090},
        {17760439,   -9019320,  18234367,   -8528280,  0x0b08890},
        {11670362,   -18039060, 24089400,   -4376823,  0x0010016},
        {2065794,    13470755,  2154206,    13557245,  0x001000a}, // NER
        {2007115,    13260420,  2362684,    13606379,  0xf040047},
        {6923004,    13289600,  7267195,    13624489,  0xe890047},
        {8943554,    13763800,  9032445,    13850289,  0x3c1004b},
        {7941833,    16927300,  8032166,    17013789,  0x3c1004b},
        {5219214,    14845400,  5308586,    14931889,  0x3c1004b},
        {7319473,    18697800,  7410526,    18784289,  0x3c1004b},
        {3149674,    13005800,  3238325,    13092289,  0x3c1004b},
        {5228454,    13721500,  5317345,    13807989,  0x3c1004b},
        {3387115,    11818600,  3475285,    11905089,  0x3c1004b},
        {3960354,    13601400,  4049245,    13687889,  0x3c1004b},
        {869814,     14688600,  959186,     14775089,  0x3c1004b},
        {5902654,    14043800,  5991545,    14130289,  0x3c1004b},
        {2832274,    13050800,  2920925,    13137289,  0x3c1004b},
        {8864374,    12960900,  8953025,    13047389,  0x3c1004b},
        {7615954,    13884400,  7704845,    13970889,  0x3c1004b},
        {7942554,    13713800,  8031445,    13800289,  0x3c1004b},
        {12567654,   13271100,  12656545,   13357589,  0x3c1004b},
        {709654,     13962800,  798545,     14049289,  0x3c1004b},
        {9110154,    13669600,  9199045,    13756089,  0x3c1004b},
        {6714234,    14455300,  6803365,    14541789,  0x3c1004b},
        {1408834,    14166500,  1497965,    14252989,  0x3c1004b},
        {13063334,   14209200,  13152465,   14295689,  0x3c1004b},
        {5202134,    14417700,  5291265,    14504189,  0x3c1004b},
        {8433154,    13387900,  8522045,    13474389,  0x3c1004b},
        {7015554,    13530700,  7104445,    13617189,  0x3c1004b},
        {8842115,    14935850,  8906284,    14997949,  0x2b2004b},
        {10237405,   13954040,  10299194,   14014159,  0x29c004b},
        {6250229,    15430750,  6314570,    15492849,  0x2b2004b},
        {7743805,    13474940,  7805594,    13535059,  0x29c004b},
        {3298002,    14318950,  3361998,    14381049,  0x2b2004b},
        {2818389,    12968340,  2880011,    13028459,  0x29c004b},
        {6665588,    13632750,  6729412,    13694849,  0x2b2004b},
        {11997205,   13189740,  12058994,   13249859,  0x29c004b},
        {2321174,    13067650,  2384825,    13129749,  0x2b2004b},
        {2299105,    13289940,  2360894,    13350059,  0x29c004b},
        {7145488,    13286250,  7209312,    13348349,  0x2b2004b},
        {5750438,    14721040,  5812561,    14781159,  0x29c004b},
        {5767743,    15868950,  5832257,    15931049,  0x2b2004b},
        {8439105,    13519940,  8500894,    13580059,  0x29c004b},
        {2058002,    14288950,  2121998,    14351049,  0x2b2004b},
        {6019022,    14389940,  6080978,    14450059,  0x29c004b},
        {671000,     12830000,  4109600,    14800000,  0x017000d},
        {5182000,    13043057,  8050000,    15600000,  0x0a10011},
        {8831732,    13514380,  9310868,    14005420,  0x0b10890},
        {7602832,    16702480,  8087176,    17193520,  0x0b11090},
        {7120224,    18495480,  7609776,    18986520,  0x0b11890},
        {3222740,    11680000,  3696668,    12171040,  0x0b12090},
        {8668932,    12806080,  9148068,    13297120,  0x0b03090},
        {12372432,   13041780,  12851568,   13532820,  0x0b04090},
        {12747632,   13880780,  13226768,   14371820,  0x0b15090},
        {8234232,    13244980,  8713368,    13736020,  0x0b15890},
        {8637232,    14721380,  9121576,    15212420,  0x0b06090},
        {10028732,   13738580,  10507868,   14229620,  0x0b16890},
        {11787032,   13070280,  12266168,   13561320,  0x0b07090},
        {5551932,    15587580,  6036276,    16078620,  0x0b07890},
        {150000,     11680000,  16000000,   23530000,  0x3330016},
        {15030394,   12088553,  15118806,   12175043,  0x001000a}, // TCD
        {14928397,   11985471,  15220803,   12272300,  0xc730047},
        {15928024,   8441191,   16204481,   8714610,   0xbde0047},
        {18246106,   9009622,   18522563,   9283041,   0xbde0047},
        {20787554,   13785800,  20876445,   13872289,  0x3c1004b},
        {15757508,   9266023,   15844958,   9352512,   0x3c1004b},
        {17502146,   8872102,   17589596,   8958591,   0x3c1004b},
        {14861275,   9320800,   14948725,   9407289,   0x3c1004b},
        {20239035,   10986800,  20326965,   11073289,  0x3c1004b},
        {15328035,   10237800,  15415965,   10324289,  0x3c1004b},
        {18648794,   12140800,  18737205,   12227289,  0x3c1004b},
        {16801766,   8630473,   16889216,   8716962,   0x3c1004b},
        {18299554,   13166500,  18388445,   13252989,  0x3c1004b},
        {16249345,   9359973,   16336795,   9446462,   0x3c1004b},
        {19648154,   13255700,  19737045,   13342189,  0x3c1004b},
        {18176815,   11938500,  18264985,   12024989,  0x3c1004b},
        {15265554,   14076800,  15354445,   14163289,  0x3c1004b},
        {15396394,   12443500,  15484805,   12529989,  0x3c1004b},
        {15823715,   11766300,  15911885,   11852789,  0x3c1004b},
        {14179512,   9615462,   14267202,   9701951,   0x3c1004b},
        {18896275,   9406800,   18983725,   9493289,   0x3c1004b},
        {16269693,   8967682,   16357143,   9054171,   0x3c1004b},
        {15682774,   12962900,  15771425,   13049389,  0x3c1004b},
        {16444754,   13598500,  16533645,   13684989,  0x3c1004b},
        {17015794,   12336800,  17104205,   12423289,  0x3c1004b},
        {16111052,   9273975,   16198502,   9360464,   0x3c1004b},
        {16679435,   10430500,  16767365,   10516989,  0x3c1004b},
        {19062193,   17883900,  19153006,   17970389,  0x3c1004b},
        {15100190,   9873012,   15187880,   9959501,   0x3c1004b},
        {16522562,   8633919,   16610012,   8720408,   0x3c1004b},
        {17115715,   11742400,  17203885,   11828889,  0x3c1004b},
        {22155554,   13426800,  22244445,   13513289,  0x3c1004b},
        {15498535,   10871100,  15586465,   10957589,  0x3c1004b},
        {17726395,   8296800,   17813604,   8383289,   0x3c1004b},
        {20888902,   14497150,  20952898,   14559249,  0x2b2004b},
        {15658572,   7714810,   15719192,   7774929,   0x29c004b},
        {14782347,   8290347,   17463537,   10971537,  0x0a90011},
        {14782347,   11239656,  17493328,   13920846,  0x001000d},
        {20592427,   13583524,  21071563,   14074564,  0x0b10090},
        {17314119,   8669826,   17788047,   9160866,   0x0b00890},
        {20051249,   10784524,  20525177,   11275564,  0x0b11090},
        {18461239,   11938524,  18935167,   12429564,  0x0b11890},
        {18104427,   12964224,  18583563,   13455264,  0x0b02090},
        {19453027,   13053424,  19932163,   13544464,  0x0b02890},
        {17989149,   11736224,  18463077,   12227264,  0x0b13090},
        {15070427,   13874524,  15549563,   14365564,  0x0b13890},
        {13991599,   9413186,   14465527,   9904226,   0x0b04090},
        {18708239,   9204524,   19182167,   9695564,   0x0b04890},
        {18862819,   17681624,  19352371,   18172664,  0x0b0a890},
        {21960427,   13224524,  22439563,   13715564,  0x0b1b090},
        {17535635,   8094524,   18004355,   8585564,   0x0b1b890},
        {20681337,   14282679,  21160473,   14773719,  0x0b1c090},
        {15454525,   7499349,   15923245,   7990389,   0x0b1c890},
        {13450000,   7440000,   24000010,   23460000,  0x4890016},
        {-77066600,  -12129255, -77008600,  -12003998, 0x02d000a}, // PER
        {-77171000,  -12247500, -76894742,  -11806000, 0xf040447},
        {-71734778,  -16567260, -71386866,  -16232371, 0xe890047},
        {-79100864,  -8160610,  -79039246,  -8038301,  0x3c1044b},
        {-79039246,  -8160610,  -78977628,  -8038301,  0x3c1044b},
        {-79928394,  -6814010,  -79866946,  -6691701,  0x3c1044b},
        {-79866946,  -6814010,  -79805498,  -6691701,  0x3c1044b},
        {-73349324,  -3847510,  -73288046,  -3725201,  0x3c1044b},
        {-73288046,  -3812510,  -73226768,  -3690201,  0x3c1044b},
        {-80694424,  -5250710,  -80633146,  -5128401,  0x3c1044b},
        {-80633146,  -5250710,  -80571868,  -5128401,  0x3c1044b},
        {-75298444,  -12125110, -75236147,  -12002801, 0x3c1044b},
        {-75236147,  -12125110, -75173850,  -12002801, 0x3c1044b},
        {-78613134,  -9133000,  -78533328,  -9038301,  0x3c1044b},
        {-78534000,  -9160610,  -78429897,  -9088000,  0x3c1044b},
        {-74607605,  -8433000,  -74520396,  -8346511,  0x3c1004b},
        {-72002000,  -13558000, -71861309,  -13503400, 0x3c1044b},
        {-70290207,  -18082400, -70221034,  -17969000, 0x3c1044b},
        {-75770646,  -14100600, -75681755,  -14014111, 0x3c1004b},
        {-70184806,  -15543200, -70095194,  -15456711, 0x3c1004b},
        {-74264446,  -13213200, -74175555,  -13126711, 0x3c1004b},
        {-80731600,  -4931100,  -80657326,  -4879100,  0x2b2044b},
        {-76264677,  -9976540,  -76219053,  -9896400,  0x29c044b},
        {-76171912,  -13451050, -76108088,  -13388951, 0x2b2004b},
        {-76396427,  -6518060,  -76335974,  -6457941,  0x29c004b},
        {-78532308,  -7196750,  -78469692,  -7134651,  0x2b2004b},
        {-81293343,  -4614260,  -81233057,  -4554141,  0x29c004b},
        {-70042957,  -15881850, -69978443,  -15819751, 0x2b2004b},
        {-80469843,  -3612060,  -80409557,  -3551941,  0x29c004b},
        {-76721053,  -11956200, -76632332,  -11912000, 0x2b2044b},
        {-77558277,  -9548060,  -77497323,  -9487941,  0x29c004b},
        {-80703222,  -5312050,  -80640778,  -5249951,  0x2b2004b},
        {-77240644,  -11530060, -77179356,  -11469941, 0x29c004b},
        {-76301567,  -10721050, -76238433,  -10658951, 0x2b2004b},
        {-76226895,  -13750760, -76165106,  -13690641, 0x29c004b},
        {-77632453,  -11136950, -77569147,  -11074851, 0x2b2004b},
        {-80205443,  -5127860,  -80145157,  -5067741,  0x29c004b},
        {-71361516,  -17670050, -71296485,  -17607951, 0x2b2004b},
        {-72911095,  -13661060, -72849306,  -13600941, 0x29c004b},
        {-75743753,  -11427450, -75680447,  -11365351, 0x2b2004b},
        {-77780861,  -10776660, -77719740,  -10716541, 0x29c004b},
        {-70972430,  -17221050, -70907571,  -17158951, 0x2b2004b},
        {-81133043,  -5126160,  -81072757,  -5066041,  0x29c004b},
        {-76033595,  -9323950,  -75970806,  -9261851,  0x2b2004b},
        {-78840227,  -5740060,  -78779774,  -5679941,  0x29c004b},
        {-79451308,  -7251050,  -79388692,  -7188951,  0x2b2004b},
        {-76152427,  -5927060,  -76091974,  -5866941,  0x29c004b},
        {-77911026,  -12427323, -75200045,  -9746133,  0x001000d},
        {-81360000,  -6036216,  -78678810,  -3355026,  0x0010015},
        {-69138720,  -504010,   -68670000,  -12970,    0x001008c},
        {-69138720,  -504010,   -68670000,  -12970,    0x001088c},
        {-79368995,  -8200525,  -78900275,  -7709485,  0x001108c},
        {-79973145,  -7015475,  -79504425,  -6524435,  0x001188c},
        {-73537735,  -4014375,  -73069015,  -3523335,  0x001208c},
        {-78779331,  -9344975,  -78305403,  -8853935,  0x001288c},
        {-74798345,  -8635275,  -74329625,  -8144235,  0x001308c},
        {-72206453,  -13776220, -71727317,  -13285180, 0x001388c},
        {-70517731,  -18271220, -70028179,  -17780180, 0x001408c},
        {-75965763,  -14302875, -75486627,  -13811835, 0x001488c},
        {-70312259,  -15920875, -69827915,  -15429835, 0x001508c},
        {-74459563,  -13415475, -73980427,  -12924435, 0x001588c},
        {-76407563,  -13815825, -75928427,  -13324785, 0x001608c},
        {-76600545,  -6733475,  -76131825,  -6242435,  0x001688c},
        {-78735355,  -7411175,  -78266635,  -6920135,  0x001708c},
        {-77759551,  -9763475,  -77285623,  -9272435,  0x001788c},
        {-71573771,  -17884475, -71084219,  -17393435, 0x001808c},
        {-73119763,  -13876475, -72640627,  -13385435, 0x001888c},
        {-71184771,  -17435475, -70695219,  -16944435, 0x001908c},
        {-76233951,  -9538375,  -75760023,  -9047335,  0x001988c},
        {-79729355,  -7555475,  -79260635,  -7064435,  0x001a08c},
        {-76356545,  -6142475,  -75887825,  -5651435,  0x001a88c},
        {-75229553,  -13035475, -74750417,  -12544435, 0x001b08c},
        {-77204355,  -6275475,  -76735635,  -5784435,  0x001b88c},
        {-69429513,  -12910475, -68950377,  -12419435, 0x001c08c},
        {-71469553,  -14535475, -70990417,  -14044435, 0x001c88c},
        {-76974355,  -7415475,  -76505635,  -6924435,  0x001d08c},
        {-76584563,  -13320475, -76105427,  -12829435, 0x001d88c},
        {-69122744,  -12739756, -68643608,  -12248716, 0x001e08c},
        {-81360000,  -18351470, -68670000,  -12970,    0x4680016},
        {-92000000,  -56600000, -30000000,  13500000,  0x0010217},
        {106810541,  47889000,  106987706,  47951245,  0x016000a}, // MNG
        {106539272,  47662480,  107226728,  48153520,  0x001000c},
        {103969749,  48970090,  104155251,  49092399,  0x54f004b},
        {105854129,  49412290,  106041670,  49534599,  0x54f004b},
        {114437917,  48013490,  114619682,  48135799,  0x54f004b},
        {91551117,   47944890,  91732882,   48067199,  0x54f004b},
        {110051014,  44834390,  110222586,  44956699,  0x54f004b},
        {89889949,   48899790,  90075451,   49022099,  0x54f004b},
        {91972210,   49919890,  92161789,   50042199,  0x54f004b},
        {100083691,  49596800,  100216308,  49683289,  0x3c1004b},
        {96789134,   47691300,  96916465,   47777789,  0x3c1004b},
        {106140971,  50187800,  106275029,  50274289,  0x3c1004b},
        {100057535,  46646800,  100182464,  46733289,  0x3c1004b},
        {102716435,  46216500,  102841364,  46302989,  0x3c1004b},
        {101402934,  47431400,  101530265,  47517889,  0x3c1004b},
        {96188235,   46322800,  96313164,   46409289,  0x3c1004b},
        {106401512,  48796700,  106532687,  48883189,  0x3c1004b},
        {103468012,  48775300,  103599187,  48861789,  0x3c1004b},
        {104343118,  43541100,  104462281,  43627589,  0x3c1004b},
        {113213035,  46630200,  113337964,  46716689,  0x3c1004b},
        {106210536,  45722600,  106334263,  45809089,  0x3c1004b},
        {110585334,  47285200,  110712665,  47371689,  0x3c1004b},
        {98197433,   48712900,  98327167,   48799389,  0x3c1004b},
        {107206334,  47725600,  107334866,  47812089,  0x3c1004b},
        {108320835,  46309400,  108445764,  46395889,  0x3c1004b},
        {102114337,  44626800,  102235662,  44713289,  0x3c1004b},
        {103737070,  47586257,  107669482,  50267447,  0x0a80011},
        {99617367,   45480305,  103400824,  48161495,  0x0010015},
        {114187671,  47829124,  114880335,  48320164,  0x0010088},
        {91300871,   47760524,  91993535,   48251564,  0x0010888},
        {109808701,  44650024,  110464909,  45141064,  0x0011088},
        {89636373,   48715424,  90339453,   49206464,  0x0011888},
        {91707643,   49735524,  92426347,   50226564,  0x0012088},
        {99790643,   49394524,  100509347,  49885564,  0x0012888},
        {96509067,   47489024,  97196523,   47980064,  0x0013088},
        {105851257,  49985524,  106575169,  50476564,  0x0013888},
        {95917383,   46120524,  96584007,   46611564,  0x0015888},
        {103187263,  48573024,  103890343,  49064064,  0x0016088},
        {104087611,  43338824,  104728195,  43829864,  0x0016888},
        {112936975,  46427924,  113614015,  46918964,  0x0017088},
        {105946895,  45520324,  106608311,  46011364,  0x0017888},
        {110313079,  47082924,  110995327,  47573964,  0x0018088},
        {97915973,   48510624,  98619053,   49001664,  0x0018888},
        {88151115,   49468810,  92262273,   52150000,  0x0a89091},
        {92262273,   49468810,  96373431,   52150000,  0x0a89891},
        {96373431,   49468810,  100484589,  52150000,  0x0a8a091},
        {100484589,  49468810,  104595747,  52150000,  0x0a8a891},
        {104595747,  49468810,  108706905,  52150000,  0x0a8b091},
        {112818063,  49468810,  116929221,  52150000,  0x0a8b891},
        {87740000,   46921679,  91642621,   49602869,  0x0a8c091},
        {91515115,   46921679,  95417736,   49602869,  0x0a8c891},
        {95417736,   46921679,  99320357,   49602869,  0x0a8d091},
        {99320357,   46921679,  103222978,  49602869,  0x0a8d891},
        {103222978,  46921679,  107125599,  49602869,  0x0a8e091},
        {107125599,  46921679,  111028220,  49602869,  0x0a8e891},
        {111028220,  46921679,  114930841,  49602869,  0x0a8f091},
        {114930841,  46921679,  118833462,  49602869,  0x0a80091},
        {90589807,   44240489,  94313682,   46921679,  0x0a80891},
        {94313682,   44240489,  98037557,   46921679,  0x0a81091},
        {98037557,   44240489,  101761432,  46921679,  0x0a81891},
        {101761432,  44240489,  105485307,  46921679,  0x0a82091},
        {105485307,  44240489,  109209182,  46921679,  0x0a82891},
        {109209182,  44240489,  112933057,  46921679,  0x0a83091},
        {112933057,  44240489,  116656932,  46921679,  0x0a83891},
        {116146543,  45581084,  119930000,  48262274,  0x0a84091},
        {94772463,   41567630,  98347383,   44248820,  0x0a84891},
        {98347383,   41567630,  101922303,  44248820,  0x0a85091},
        {101922303,  41567630,  105497223,  44248820,  0x0a85891},
        {105497223,  41567630,  109072143,  44248820,  0x0a86091},
        {109072143,  41567630,  112647063,  44248820,  0x0a86891},
        {87740000,   41567630,  119930000,  52150000,  0x0010217},
        {51323945,   35635355,  51429655,   35721845,  0x001000a}, // IRN
        {51176280,   35483220,  51599119,   35829179,  0xf040047},
        {59381850,   36131100,  59793949,   36465989,  0xe890047},
        {51602864,   32601190,  51747936,   32723499,  0x54f004b},
        {46212500,   38017000,  46386650,   38125500,  0x54f044b},
        {52459189,   29540000,  52627692,   29641700,  0x54f044b},
        {50870000,   35786000,  51057055,   35884299,  0x54f044b},
        {50802350,   34578290,  50928934,   34721000,  0x54f044b},
        {48618053,   31250690,  48760747,   31372999,  0x54f044b},
        {47015605,   34282000,  47173400,   34396399,  0x54f044b},
        {60794142,   29421790,  60934457,   29544099,  0x54f044b},
        {45003804,   37502000,  45112396,   37588489,  0x3c1044b},
        {57019500,   30238910,  57126050,   30319800,  0x3c1044b},
        {54300208,   31841000,  54401592,   31927489,  0x3c1044b},
        {49537404,   37240200,  49645996,   37326689,  0x3c1044b},
        {49624200,   34061100,  49752719,   34130880,  0x3c1044b},
        {48457706,   34756400,  48562694,   34842889,  0x3c1044b},
        {48234844,   38207300,  48344156,   38293789,  0x3c1044b},
        {49953925,   36243800,  50061075,   36330289,  0x3c1044b},
        {48229149,   30313700,  48328851,   30400189,  0x3c1044b},
        {46967145,   35256800,  47072854,   35343289,  0x3c1044b},
        {48435300,   36641000,  48575566,   36707000,  0x3c1044b},
        {48313000,   33424700,  48384963,   33548500,  0x3c1044b},
        {56238200,   27166000,  56368871,   27230000,  0x3c1044b},
        {48706600,   33850000,  48807363,   33939000,  0x3c1044b},
        {54390764,   36797800,  54498635,   36884289,  0x3c1044b},
        {49778986,   34315605,  52996414,   36996795,  0x0a90011},
        {51236676,   32490679,  51788724,   32981719,  0x0010888},
        {52396992,   29437980,  52933416,   29929020,  0x0011088},
        {48363584,   31066280,  48910424,   31557320,  0x0011888},
        {46749568,   34093680,  47312032,   34584720,  0x0012088},
        {60542092,   29237380,  61073308,   29728420,  0x0012888},
        {44735652,   37299680,  45324156,   37790720,  0x0013088},
        {56776992,   30033880,  57313416,   30524920,  0x0013888},
        {54051484,   31638680,  54598324,   32129720,  0x0014088},
        {49204652,   37079180,  49787948,   37570220,  0x0014888},
        {49367768,   33850480,  49930232,   34341520,  0x0015088},
        {48196668,   34554080,  48759132,   35045120,  0x0015888},
        {47945292,   30139780,  48481716,   30630820,  0x0016888},
        {46708868,   35054480,  47276540,   35545520,  0x0017088},
        {48178460,   36428480,  48756548,   36919520,  0x0017888},
        {48074076,   33240279,  48631332,   33731319,  0x0018088},
        {55869600,   27011680,  56390400,   27502720,  0x0018888},
        {48620876,   33455580,  49178132,   33946620,  0x0019088},
        {54127660,   36595480,  54705748,   37086520,  0x0019888},
        {51298768,   33734480,  51861232,   34225520,  0x001a088},
        {57343560,   35974480,  57916440,   36465520,  0x001a888},
        {53033660,   36387980,  53611748,   36879020,  0x001b088},
        {58533560,   35974480,  59106440,   36465520,  0x001b888},
        {55464392,   29224480,  55995608,   29715520,  0x001c088},
        {44673144,   38284480,  45266856,   38775520,  0x001c888},
        {48193976,   32134480,  48746024,   32625520,  0x001d088},
        {57030952,   37224480,  57619456,   37715520,  0x001d888},
        {58943976,   32634480,  59496024,   33125520,  0x001e088},
        {50763592,   28664080,  51294808,   29155120,  0x001f088},
        {45091379,   36605345,  48398180,   39286535,  0x0010015},
        {53559078,   35768215,  56836088,   38449405,  0x0a91091},
        {56836088,   35768215,  60113098,   38449405,  0x0a91891},
        {44020000,   37108809,  47356592,   39789999,  0x0a80091},
        {47356592,   37108809,  50693184,   39789999,  0x0a80891},
        {44413241,   34427619,  47630669,   37108809,  0x0a92091},
        {47630669,   34427619,  50848097,   37108809,  0x0a92891},
        {50848097,   34427619,  54065525,   37108809,  0x0a93091},
        {54065525,   34427619,  57282953,   37108809,  0x0a93891},
        {57282953,   34427619,  60500381,   37108809,  0x0a94091},
        {58248181,   34427619,  61465609,   37108809,  0x0a94891},
        {45373703,   31746429,  48501758,   34427619,  0x0a95091},
        {48501758,   31746429,  51629813,   34427619,  0x0a95891},
        {51629813,   31746429,  54757868,   34427619,  0x0a96091},
        {54757868,   31746429,  57885923,   34427619,  0x0a96891},
        {57885923,   31746429,  61013978,   34427619,  0x0a97091},
        {58824339,   31746429,  61952394,   34427619,  0x0a97891},
        {47593132,   29065239,  50631814,   31746429,  0x0a98091},
        {50631814,   29065239,  53670496,   31746429,  0x0a98891},
        {53670496,   29065239,  56709178,   31746429,  0x0a99091},
        {56709178,   29065239,  59747860,   31746429,  0x0a99891},
        {58836255,   29065239,  61874937,   31746429,  0x0a9a091},
        {50661605,   26384049,  53640705,   29065239,  0x0a8a891},
        {53640705,   26384049,  56619805,   29065239,  0x0a8b091},
        {56619805,   26384049,  59598905,   29065239,  0x0a8b891},
        {59598905,   26384049,  62578005,   29065239,  0x0a8c091},
        {60370900,   26384049,  63350000,   29065239,  0x0a8c891},
        {53670496,   25059100,  56590014,   27740290,  0x0a9d091},
        {56590014,   25059100,  59509532,   27740290,  0x0a9d891},
        {59509532,   25059100,  62429050,   27740290,  0x0a9e091},
        {44020000,   25059100,  63350000,   39790000,  0x0010217},
        {13143759,   32839490,  13216241,   32900599,  0x2a7004a}, // LBY
        {20034013,   32089490,  20105986,   32150599,  0x2a7004a},
        {12975000,   32700000,  13433063,   32913000,  0xc730447},
        {19974151,   31955948,  20294659,   32229367,  0xbde0047},
        {14928986,   32147593,  15251013,   32421012,  0xbde0047},
        {14232507,   32586600,  14335092,   32673089,  0x3c1004b},
        {20159008,   30692000,  20259191,   30778489,  0x3c1004b},
        {23905667,   32026900,  24007532,   32113389,  0x3c1004b},
        {12969067,   32126800,  13070932,   32213289,  0x3c1004b},
        {12668907,   32709700,  12771492,   32796189,  0x3c1004b},
        {14508567,   32420600,  14610432,   32507089,  0x3c1004b},
        {16532548,   31128600,  16633452,   31215089,  0x3c1004b},
        {12721830,   26536800,  12818169,   26623289,  0x3c1004b},
        {13954308,   31707200,  14055692,   31793689,  0x3c1004b},
        {21708307,   32718500,  21810892,   32804989,  0x3c1004b},
        {12485167,   32027200,  12587032,   32113689,  0x3c1004b},
        {14379690,   26994600,  14476509,   27081089,  0x3c1004b},
        {22592707,   32707300,  22695292,   32793789,  0x3c1004b},
        {12969067,   32486800,  13070932,   32573289,  0x3c1004b},
        {10929308,   31827000,  11030692,   31913489,  0x3c1004b},
        {12430307,   32737900,  12532892,   32824389,  0x3c1004b},
        {13867171,   25881000,  13963029,   25967489,  0x3c1004b},
        {13587767,   32390300,  13689632,   32476789,  0x3c1004b},
        {20780967,   32448700,  20882832,   32535189,  0x3c1004b},
        {12035007,   32877100,  12137592,   32963589,  0x3c1004b},
        {21823807,   32751300,  21926392,   32837789,  0x3c1004b},
        {14232469,   27518450,  14302330,   27580549,  0x2b2004b},
        {12951430,   31417840,  13021569,   31477959,  0x29c004b},
        {20556830,   32156550,  20629969,   32218649,  0x2b2004b},
        {20089381,   30919440,  20159019,   30979559,  0x29c004b},
        {20546830,   32497750,  20619969,   32559849,  0x2b2004b},
        {10148534,   24927340,  10214665,   24987459,  0x29c004b},
        {21258152,   29116750,  21329048,   29178849,  0x2b2004b},
        {23257101,   24169940,  23322898,   24230059,  0x29c004b},
        {12543172,   32738950,  12616828,   32801049,  0x2b2004b},
        {19561148,   30364140,  19630452,   30424259,  0x29c004b},
        {20217003,   31640750,  20289797,   31702849,  0x2b2004b},
        {16108982,   29134540,  16177618,   29194659,  0x29c004b},
        {9465407,    30093650,  9536993,    30155749,  0x2b2004b},
        {13986946,   32549240,  14058254,   32609359,  0x29c004b},
        {25037203,   31721750,  25109997,   31783849,  0x2b2004b},
        {11984763,   31919940,  12055236,   31980059,  0x29c004b},
        {15915252,   29096150,  15986148,   29158249,  0x2b2004b},
        {22201646,   32727740,  22272954,   32787859,  0x29c004b},
        {11829572,   32923250,  11903228,   32985349,  0x2b2004b},
        {21511282,   29005540,  21579918,   29065659,  0x29c004b},
        {10612000,   31300000,  15410000,   32960000,  0x06b0011},
        {19900000,   31300000,  24300000,   32960000,  0x014000d},
        {12240241,   25429405,  15189550,   28110595,  0x0010015},
        {9290000,    19480000,  25141963,   33170000,  0x3820016},
        {32492924,   15532000,  32588750,   15615449,  0x01d000a}, // SDN
        {32287030,   15326640,  32771374,   15817680,  0x001000c},
        {37141000,   19534500,  37245667,   19610250,  0x3c1044b},
        {37141000,   19610250,  37245667,   19686000,  0x3c1044b},
        {24840415,   12011800,  24928585,   12098289,  0x3c1004b},
        {30175154,   13143600,  30264045,   13230089,  0x3c1004b},
        {36335494,   15413400,  36425106,   15499889,  0x3c1004b},
        {35331654,   13994800,  35420545,   14081289,  0x3c1004b},
        {33481834,   14346500,  33570965,   14432989,  0x3c1004b},
        {32615554,   13112200,  32704445,   13198689,  0x3c1004b},
        {25304954,   13585900,  25393845,   13672389,  0x3c1004b},
        {22410654,   13406700,  22499545,   13493189,  0x3c1004b},
        {34328815,   11752900,  34416985,   11839389,  0x3c1004b},
        {32954334,   14190300,  33043465,   14276789,  0x3c1004b},
        {29669935,   10959300,  29757865,   11045789,  0x3c1004b},
        {26085415,   11411700,  26173585,   11498189,  0x3c1004b},
        {33551754,   13510300,  33640645,   13596789,  0x3c1004b},
        {33964913,   17673400,  34055486,   17759889,  0x3c1004b},
        {33292314,   14706800,  33381686,   14793289,  0x3c1004b},
        {33394154,   16643700,  33484246,   16730189,  0x3c1004b},
        {32702754,   13142700,  32791645,   13229189,  0x3c1004b},
        {31176674,   12858700,  31265325,   12945189,  0x3c1004b},
        {32252054,   13955500,  32340945,   14041989,  0x3c1004b},
        {35566294,   15280000,  35655906,   15366489,  0x3c1004b},
        {33932684,   17559550,  33997715,   17621649,  0x2b2004b},
        {28393889,   12660840,  28455511,   12720959,  0x29c004b},
        {33884988,   13116750,  33948812,   13178849,  0x2b2004b},
        {27782056,   11298940,  27843344,   11359059,  0x29c004b},
        {29621047,   12015950,  29684353,   12078049,  0x2b2004b},
        {33849605,   13273840,  33911394,   13333959,  0x29c004b},
        {35866015,   14931050,  35930184,   14993149,  0x2b2004b},
        {31829189,   12979940,  31890811,   13040059,  0x29c004b},
        {23438174,   12868950,  23501825,   12931049,  0x2b2004b},
        {37298270,   19069940,  37361729,   19130059,  0x29c004b},
        {33643188,   13385750,  33707012,   13447849,  0x2b2004b},
        {31203756,   11429740,  31265044,   11489859,  0x29c004b},
        {34339947,   11835350,  34403253,   11897449,  0x2b2004b},
        {34592905,   13391240,  34654694,   13451359,  0x29c004b},
        {33150488,   14027950,  33214312,   14090049,  0x2b2004b},
        {34146005,   13248340,  34207794,   13308459,  0x29c004b},
        {33957398,   17988950,  34022602,   18051049,  0x2b2004b},
        {30610689,   12696240,  30672311,   12756359,  0x29c004b},
        {29401922,   10653888,  32112903,   13335078,  0x001000d},
        {32086091,   13066959,  34826863,   15748149,  0x0a80011},
        {36828624,   19365380,  37323384,   19856420,  0x0b00890},
        {24652740,   11809480,  25126668,   12300520,  0x0b11090},
        {36143332,   15211080,  36627676,   15702120,  0x0b01890},
        {35134432,   13746380,  35613568,   14237420,  0x0b12090},
        {25075932,   13300780,  25555068,   13791820,  0x0b12890},
        {22215532,   13204380,  22694668,   13695420,  0x0b13090},
        {34038240,   11548780,  34512168,   12039820,  0x0b13890},
        {25915640,   11268980,  26389568,   11760020,  0x0b14090},
        {33759224,   17310980,  34248776,   17802020,  0x0b04890},
        {33256532,   16487880,  33740876,   16978920,  0x0b15090},
        {35511232,   14903280,  35995576,   15394320,  0x0b05890},
        {28107232,   12407880,  28586368,   12898920,  0x0b06090},
        {27568640,   11006780,  28042568,   11497820,  0x0b16890},
        {23230432,   12654480,  23709568,   13145520,  0x0b07090},
        {36965124,   18884980,  37459884,   19376020,  0x0b07890},
        {33745224,   17774480,  34234776,   18265520,  0x0b08090},
        {21810000,   9342000,   38630000,   23200000,  0x3580016},
        {23400000,   3480000,   36000000,   12250000,  0x0900012},
        {-19000000,  -47500000, 60000000,   37550000,  0x3e50217},
        {21810000,   9342000,   38630000,   23200000,  0x003021c},
        {106786755,  -6240545,  106873245,  -6154055,  0x001000a}, // IDN
        {106557000,  -6425520,  107178000,  -6068000,  0x017000c},
        {112660000,  -7245000,  112804926,  -7193000,  0x3c1044b},
        {112670000,  -7297000,  112814926,  -7245000,  0x3c1044b},
        {112670000,  -7348000,  112817740,  -7297000,  0x3c1044b},
        {112670000,  -7400000,  112814926,  -7348000,  0x3c1044b},
        {107521495,  -6953200,  107608704,  -6866711,  0x3c1004b},
        {107608704,  -6961849,  107695913,  -6875360,  0x3c1004b},
        {98624000,   3530000,   98723905,   3605000,   0x3c1044b},
        {98627000,   3605000,   98708043,   3697500,   0x3c1044b},
        {104715055,  -3025400,  104801544,  -2938911,  0x3c1004b},
        {110376495,  -7033800,  110463704,  -6947311,  0x3c1004b},
        {119398935,  -5192100,  119485664,  -5105611,  0x3c1004b},
        {112593095,  -8006200,  112680304,  -7919711,  0x3c1004b},
        {105223015,  -5467500,  105309984,  -5381011,  0x3c1004b},
        {106746515,  -6623200,  106833484,  -6536711,  0x3c1004b},
        {100343655,  -990400,   100430144,  -903911,   0x3c1004b},
        {110768095,  -7596000,  110870641,  -7522500,  0x3c1044b},
        {114562764,  -3352850,  114625035,  -3290751,  0x2b2004b},
        {101409740,  476040,    101469859,  536159,    0x29c004b},
        {117101950,  -530750,   117164049,  -468651,   0x2b2004b},
        {109303440,  -53560,    109363559,  6559,      0x29c004b},
        {115188605,  -8681050,  115251394,  -8618951,  0x2b2004b},
        {110341490,  -7825760,  110402110,  -7765641,  0x29c004b},
        {116804050,  -1284850,  116866149,  -1222751,  0x2b2004b},
        {103581740,  -1646060,  103641859,  -1585941,  0x29c004b},
        {124818750,  1453950,   124880849,  1516049,   0x2b2004b},
        {116069206,  -8609660,  116129993,  -8549541,  0x29c004b},
        {108523578,  -6747550,  108586022,  -6685451,  0x2b2004b},
        {111979690,  -7840060,  112040310,  -7779941,  0x29c004b},
        {109099392,  -6904450,  109162008,  -6842351,  0x2b2004b},
        {109641790,  -6909360,  109702410,  -6849241,  0x29c004b},
        {113664692,  -8200950,  113727308,  -8138851,  0x2b2004b},
        {128153757,  -3720000,  128221533,  -3666600,  0x29c044b},
        {95288778,   5518950,   95351222,   5581049,   0x2b2004b},
        {108992690,  -7746255,  109047592,  -7680000,  0x29c044b},
        {102246920,  -3837350,  102316321,  -3781700,  0x2b2044b},
        {109209090,  -7456460,  109269710,  -7396341,  0x29c044b},
        {99028950,   2928950,   99091049,   2991049,   0x2b2044b},
        {108179890,  -7353360,  108240510,  -7293241,  0x29c044b},
        {111501900,  -7664200,  111558617,  -7595800,  0x2b2044b},
        {122480957,  -4014060,  122541243,  -3953941,  0x29c044b},
        {119835000,  -935180,   119906729,  -881478,   0x2b2044b},
        {125104000,  1426330,   125214249,  1459000,   0x29c044b},
        {98466200,   3587420,   98533886,   3644449,   0x2b2044b},
        {112869690,  -7670060,  112930310,  -7609941,  0x29c044b},
        {123574033,  -10202150, 123637167,  -10140051, 0x2b2044b},
        {103919000,  1018330,   104001619,  1062000,   0x29c044b},
        {105900000,  -7824000,  109528800,  -5872000,  0x07c0011},
        {109528800,  -8382291,  113285000,  -6566000,  0x015000d},
        {98415640,   3409480,   98884360,   3900520,   0x0b00090},
        {104524240,  -3235520,  104992960,  -2744480,  0x0b00890},
        {119353000,  -5439520,  119824512,  -4948480,  0x0b01090},
        {105063840,  -5507720,  105532560,  -5016680,  0x0b01890},
        {100258340,  -1014420,  100727060,  -523380,   0x0b02090},
        {114480640,  -3615520,  114949360,  -3124480,  0x0b02890},
        {101195640,  314480,    101664360,  805520,    0x0b03090},
        {116915640,  -745520,   117384360,  -254480,   0x0b03890},
        {109105640,  -265520,   109574360,  225520,    0x0b04090},
        {114989040,  -8860020,  115457760,  -8368980,  0x0b14890},
        {116598240,  -1428020,  117066960,  -936980,   0x0b05090},
        {103375640,  -1835520,  103844360,  -1344480,  0x0b05890},
        {124780640,  1234480,   125249360,  1725520,   0x0b06090},
        {116006440,  -8826320,  116475160,  -8335280,  0x0b16890},
        {113565640,  -8195520,  114034360,  -7704480,  0x0b17090},
        {127895140,  -3781320,  128363860,  -3290280,  0x0b07890},
        {95195240,   5189180,   95663960,   5680220,   0x0b08090},
        {102170440,  -4043120,  102639160,  -3552080,  0x0b08890},
        {98865640,   2899480,   99334360,   3390520,   0x0b09090},
        {122296040,  -4214520,  122764760,  -3723480,  0x0b09890},
        {119605640,  -1145520,  120074360,  -654480,   0x0b0a090},
        {123280640,  -10398920, 123754568,  -9907880,  0x0b0a890},
        {103717000,  750500,    104213000,  1199000,   0x0a4b090},
        {113685640,  -2455520,  114154360,  -1964480,  0x0b0b890},
        {122772240,  379280,    123240960,  870320,    0x0b0c090},
        {140470540,  -2919220,  140939260,  -2428180,  0x0b0c890},
        {96771940,   4786171,   97240660,   5280000,   0x0b1d090},
        {105740990,  -2235120,  106212500,  -1744080,  0x0b0d890},
        {104213000,  743500,    104700000,  1230000,   0x0ace090},
        {98972840,   1043980,   99441560,   1535020,   0x0b0e890},
        {114115640,  -8560519,  114584360,  -8069479,  0x0b1f090},
        {129600000,  -1474366,  132994416,  360487,    0x016008d},
        {130313226,  -4155557,  132994416,  -1474367,  0x001088d},
        {132994417,  -2010605,  135675607,  670585,    0x001108d},
        {132994417,  -4691795,  135675607,  -2010605,  0x001188d},
        {135675607,  -3109892,  138356797,  -428702,   0x001208d},
        {135675607,  -5791082,  138356797,  -3109892,  0x001288d},
        {135675607,  -8472272,  138356797,  -5791082,  0x001308d},
        {138356797,  -3914249,  141037987,  -1233059,  0x001388d},
        {138356797,  -6595439,  141037987,  -3914249,  0x001408d},
        {138356797,  -9276629,  141037987,  -6595439,  0x001488d},
        {118680988,  -362912,   121362178,  2318278,   0x001508d},
        {121362178,  -362912,   124043368,  2318278,   0x001588d},
        {124043368,  -362912,   126724558,  2318278,   0x001608d},
        {118680988,  -3044101,  121362178,  -362911,   0x001688d},
        {121362178,  -3044101,  124043368,  -362911,   0x001708d},
        {124043368,  -3044101,  126724558,  -362911,   0x001788d},
        {118680988,  -5725291,  121362178,  -3044101,  0x001808d},
        {121362178,  -5725291,  124043368,  -3044101,  0x001888d},
        {120343326,  -8406481,  123024516,  -5725291,  0x001908d},
        {126984524,  21405,     129665714,  2702595,   0x001988d},
        {126984524,  -2659784,  129665714,  21406,     0x001a08d},
        {125643929,  -5340975,  128325119,  -2659785,  0x001a88d},
        {128325118,  -4134439,  131006308,  -1453249,  0x001b08d},
        {131006308,  -6413451,  133687498,  -3732261,  0x001b88d},
        {132615022,  -7754046,  135296212,  -5072856,  0x001c08d},
        {130282387,  -8826522,  132963577,  -6145332,  0x001c88d},
        {127601197,  -8826522,  130282387,  -6145332,  0x001d08d},
        {124920007,  -9898998,  127601197,  -7217808,  0x001d88d},
        {124900000,  2218000,   127500000,  4880000,   0x001e08d},
        {104967524,  781552,    107648714,  3462742,   0x001e88d},
        {107648714,  2256207,   110329904,  4937397,   0x001f08d},
        {114604286,  1743107,   117285476,  4424297,   0x0a80091},
        {117285476,  1743107,   119966666,  4424297,   0x0a80891},
        {108685000,  -938083,   110984679,  2090000,   0x0c11091},
        {110984679,  -938082,   113665869,  1743108,   0x0a81891},
        {113665869,  -938082,   116347059,  1743108,   0x0a82091},
        {116347059,  -938082,   119028249,  1743108,   0x0a82891},
        {109241905,  -3619272,  111923095,  -938082,   0x0a83091},
        {111923095,  -3619272,  114604285,  -938082,   0x0a83891},
        {114604285,  -3619272,  117285475,  -938082,   0x0a84091},
        {114068047,  -6300462,  116749237,  -3619272,  0x0a84891},
        {95004700,   3225694,   97685890,   5906884,   0x0a85091},
        {97685890,   3225694,   100367080,  5906884,   0x0a85891},
        {95674997,   544519,    98356187,   3225709,   0x0a86091},
        {98356187,   544519,    101037377,  3225709,   0x0a86891},
        {101037377,  544519,    104857000,  2330000,   0x0737091},
        {98141605,   -2136670,  100822795,  544520,    0x0a87891},
        {100822795,  -2136670,  103503985,  544520,    0x0a88091},
        {103503985,  -2136670,  106185175,  544520,    0x0a88891},
        {98141605,   -4817860,  100822795,  -2136670,  0x0a89091},
        {100822795,  -4817860,  103503985,  -2136670,  0x0a89891},
        {103503985,  -4817860,  106185175,  -2136670,  0x0a8a091},
        {106185175,  -4817860,  108866365,  -2136670,  0x0a8a891},
        {101975706,  -7499050,  104656896,  -4817860,  0x0a8b091},
        {104656896,  -7499050,  107338086,  -4817860,  0x0a8b891},
        {107338086,  -8330218,  110019276,  -5649028,  0x0a9c091},
        {110019276,  -8866456,  112700466,  -6185266,  0x0a9c891},
        {112700466,  -9134575,  115381656,  -6453385,  0x0a9d091},
        {115381656,  -9402694,  118062846,  -6721504,  0x0a9d891},
        {118062846,  -8980000,  125200000,  -8020000,  0x03ee091},
        {118890000,  -10850000, 122040000,  -9200000,  0x07ae891},
        {122486810,  -11020000, 125197791,  -8920080,  0x095f091},
        {95004677,   -11020000, 141054950,  5906884,   0x0010017},
        {-99180500,  19393000,  -99074700,  19466000,  0x01a000a}, // DIF
        {-99320000,  19197764,  -98875000,  19732000,  0x022000c},
        {-100620000, 18300000,  -98570000,  20296000,  0x0aa0011},
        {-99365200,  19045000,  -98938000,  19593000,  0x0020216},
        {-98279000,  19283000,  -98152500,  19343800,  0x016000a}, // TLA
        {-98110776,  19103030,  -97616016,  19594070,  0x0b00010},
        {-98590000,  19103030,  -98110776,  19602000,  0x001000c},
        {-98725000,  19103000,  -97616000,  19740000,  0x0830011},
        {-98725000,  19103000,  -97616000,  19740000,  0x0020216},
        {-99254084,  18885404,  -99162789,  18971894,  0x001000a}, // MOR
        {-99494000,  18626120,  -99020250,  19133000,  0x020000c},
        {-99020250,  18408400,  -98665000,  19088000,  0x0f40010},
        {-100620000, 18300000,  -98570000,  20296000,  0x0aa0011},
        {-99500000,  18323000,  -98632000,  19144000,  0x0020216},
        {-102327212, 21836555,  -102234956, 21923045,  0x001000a}, // AGU
        {-102780000, 21620000,  -102175000, 22016000,  0x019000c},
        {-102491600, 22016000,  -101942000, 22460000,  0x0a00010},
        {-102880000, 21620000,  -101833000, 22460000,  0x09c0011},
        {-102880000, 21620000,  -101833000, 22460000,  0x0020216},
        {-103776000, 19216200,  -103676500, 19295000,  0x01c000a}, // 5CL
        {-103974776, 19022469,  -103480016, 19513509,  0x001000c},
        {-104418598, 18901237,  -104053419, 19247196,  0xf04004b},
        {-104056058, 18687811,  -103703495, 19022700,  0xe89004b},
        {-104700000, 18660000,  -103460000, 19520000,  0x0900011},
        {-104700000, 18660000,  -103460000, 19520000,  0x0020216},
        {-100425500, 20546655,  -100357475, 20661000,  0x029000a}, // QUE
        {-100599396, 20344380,  -100104636, 20835420,  0x001000c},
        {-100104636, 20292000,  -99684000,  20870000,  0x0d00010},
        {-100602000, 20000000,  -99035000,  21690000,  0x0b40011},
        {-100602000, 20000000,  -99035000,  21690000,  0x0020216},
        {-98790000,  20057200,  -98696600,  20140000,  0x01e000a}, // HID
        {-99002176,  19800780,  -98507416,  20291820,  0x001000c},
        {-99390884,  19883000,  -99111261,  20110000,  0xa9e044b},
        {-99295000,  20110000,  -99000570,  20326128,  0xa9e044b},
        {-99380124,  20326128,  -99119877,  20570747,  0xa9e004b},
        {-98507998,  19977810,  -98264603,  20206589,  0x9ee004b},
        {-99880000,  19577000,  -97960000,  21404000,  0x0a90011},
        {-99880000,  19577000,  -97960000,  21404000,  0x0020216},
        {-99180500,  19393000,  -99074700,  19466000,  0x01a000a}, // 5MX
        {-99320000,  19197764,  -98875000,  19732000,  0x022000c},
        {-99780000,  19205000,  -99477901,  19414000,  0xa9e044b},
        {-99237000,  19732000,  -98943816,  19948500,  0xa9e044b},
        {-98875000,  19197764,  -98756821,  19732000,  0xa9e044b},
        {-99423000,  19197764,  -99319641,  19732000,  0x9ee044b},
        {-100620000, 18300000,  -98570000,  20296000,  0x0aa0011},
        {-100620000, 18300000,  -98570000,  20296000,  0x0020216},
        {-92975567,  17964355,  -92885233,  18050845,  0x001000a}, // TAB
        {-93222776,  17700880,  -92733224,  18191920,  0x001000c},
        {-93461000,  17800000,  -93307562,  18055000,  0x864044b},
        {-91526724,  17377140,  -91324276,  17570459,  0x864004b},
        {-93374393,  18159340,  -93171408,  18352659,  0x864004b},
        {-92632274,  17735510,  -92451127,  17908489,  0x782004b},
        {-91839174,  17716110,  -91658027,  17889089,  0x782004b},
        {-92731954,  18465710,  -92549846,  18638689,  0x782004b},
        {-93289895,  18331240,  -93013956,  18445000,  0x782044b},
        {-94140000,  17232000,  -90958000,  18670000,  0x0730011},
        {-94140000,  17232000,  -90958000,  18670000,  0x0020216},
        {-104932328, 21458155,  -104840072, 21544645,  0x001000a}, // NAY
        {-105177384, 21102580,  -104677416, 21593620,  0x001000c},
        {-105569723, 22310790,  -105306078, 22555409,  0xa9e004b},
        {-105441764, 20667590,  -105180837, 20912209,  0xa9e004b},
        {-105318000, 21727200,  -105048166, 21965500,  0xa9e044b},
        {-104548216, 20948310,  -104304185, 21177089,  0x9ee004b},
        {-106720000, 20594000,  -103706000, 23092000,  0x09e0011},
        {-106720000, 20594000,  -103706000, 23092000,  0x0020216},
        {-101713628, 21089455,  -101621372, 21175945,  0x001000a}, // GUA
        {-101805876, 20949130,  -101499925, 21235959,  0xc730047},
        {-101532424, 20549390,  -101240777, 20822809,  0xbde0047},
        {-101017444, 20408890,  -100726557, 20682309,  0xbde0047},
        {-101292056, 20472210,  -101107545, 20645189,  0x782004b},
        {-101367956, 20919610,  -101183445, 21092589,  0x782004b},
        {-101545856, 20842110,  -101361345, 21015089,  0x782004b},
        {-101955956, 20910210,  -101771445, 21083189,  0x782004b},
        {-100862872, 20864220,  -100703129, 21013979,  0x680004b},
        {-101309164, 20306320,  -101149837, 20456079,  0x680004b},
        {-101010288, 21095120,  -100849713, 21244879,  0x680004b},
        {-101253564, 20083620,  -101094237, 20233379,  0x680004b},
        {-100839764, 20000020,  -100680437, 20149779,  0x680004b},
        {-102110000, 19890000,  -99645000,  21847000,  0x09a0011},
        {-102110000, 19890000,  -99645000,  21847000,  0x0020216},
        {-98244667,  19006755,  -98153372,  19093245,  0x001000a}, // PUE
        {-98382590,  18877020,  -98017411,  19222979,  0xf040047},
        {-97555817,  18282600,  -97204184,  18617489,  0xe890047},
        {-98630065,  18746590,  -98372536,  18991209,  0xa9e004b},
        {-98614505,  19124890,  -98356296,  19369509,  0xa9e004b},
        {-97548984,  19704290,  -97289416,  19948909,  0xa9e004b},
        {-98168998,  20122510,  -97925603,  20351289,  0x9ee004b},
        {-99088000,  17870000,  -96722000,  20850000,  0x0c10011},
        {-99088000,  17870000,  -96722000,  20850000,  0x0020216},
        {-89664828,  20932755,  -89572572,  21019245,  0x001000a}, // YUC
        {-89982000,  20799700,  -89320753,  21164000,  0x017000c},
        {-88362044,  20612760,  -88136157,  20824529,  0x931004b},
        {-88337741,  20986240,  -88130460,  21179559,  0x864004b},
        {-89848000,  21205000,  -89484003,  21315000,  0x864044b},
        {-89450135,  20159440,  -89244465,  20352759,  0x864004b},
        {-90039504,  20499240,  -89833297,  20692559,  0x864004b},
        {-89340641,  21038740,  -89133360,  21232059,  0x864004b},
        {-90422000,  19515000,  -87310000,  21650000,  0x08f0011},
        {-90422000,  21650000,  -87310000,  23660000,  0x019000d},
        {-90422000,  19515000,  -87310000,  23660000,  0x0020216},
        {-86913210,  21128780,  -86803572,  21204200,  0x01a000a}, // ROO
        {-87200012,  20800152,  -86700044,  21291192,  0x001000c},
        {-88600000,  18470000,  -88223560,  18700000,  0xc73044b},
        {-87190544,  20439490,  -86899657,  20712909,  0xbde004b},
        {-88199364,  19439890,  -87909236,  19713309,  0xbde004b},
        {-87649984,  21291191,  -87150016,  21782231,  0x001008c},
        {-87150016,  21291191,  -86650048,  21782231,  0x001088c},
        {-87699980,  20800152,  -87200012,  21291192,  0x001108c},
        {-87200012,  20800152,  -86700044,  21291192,  0x001188c},
        {-88194740,  20309112,  -87699980,  20800152,  0x001208c},
        {-87699980,  20309112,  -87205220,  20800152,  0x001288c},
        {-87205220,  20309112,  -86710460,  20800152,  0x001308c},
        {-87205220,  19818072,  -86710460,  20309112,  0x001388c},
        {-89317845,  19818072,  -88823085,  20309112,  0x001408c},
        {-88823085,  19818072,  -88328325,  20309112,  0x001488c},
        {-88328325,  19818072,  -87833565,  20309112,  0x001508c},
        {-87833565,  19818072,  -87338805,  20309112,  0x001588c},
        {-89317845,  19327032,  -88823085,  19818072,  0x001608c},
        {-88823085,  19327032,  -88328325,  19818072,  0x001688c},
        {-88328325,  19327032,  -87833565,  19818072,  0x001708c},
        {-87833565,  19327032,  -87338805,  19818072,  0x001788c},
        {-89169417,  18835992,  -88679865,  19327032,  0x001808c},
        {-88679865,  18835992,  -88190313,  19327032,  0x001888c},
        {-88190313,  18835992,  -87700761,  19327032,  0x001908c},
        {-87700761,  18835992,  -87211209,  19327032,  0x001988c},
        {-89169417,  18344952,  -88679865,  18835992,  0x001a08c},
        {-88679865,  18344952,  -88190313,  18835992,  0x001a88c},
        {-88190313,  18344952,  -87700761,  18835992,  0x001b08c},
        {-87700761,  18344952,  -87211209,  18835992,  0x001b88c},
        {-89218373,  17880000,  -88728821,  18371040,  0x001c08c},
        {-89022552,  17880000,  -88533000,  18371040,  0x001c88c},
        {-87994493,  18148536,  -87504941,  18639576,  0x001d08c},
        {-89323000,  17880000,  -86600000,  21800000,  0x0020216},
        {-107437189, 24750555,  -107342050, 24837045,  0x001000a}, // SIN
        {-107771892, 24481280,  -107261508, 24972320,  0x001000c},
        {-106496042, 23174000,  -106154798, 23364409,  0xa9e044b},
        {-109053920, 25654490,  -108783480, 25899109,  0xa9e004b},
        {-108656120, 25501490,  -108385680, 25746109,  0xa9e004b},
        {-108252864, 25328310,  -107999936, 25557089,  0x9ee004b},
        {-109481209, 24388810,  -106561691, 27070000,  0x0a90011},
        {-108249968, 22449405,  -105360241, 25130595,  0x001000d},
        {-109511000, 22438000,  -105344000, 27070000,  0x0020216},
        {-90572700,  19799000,  -90469650,  19874000,  0x01b000a}, // CAM
        {-90704476,  19599980,  -90209716,  20091020,  0x001000c},
        {-91876000,  18593000,  -91457775,  18800000,  0xc73044b},
        {-90784805,  19282590,  -90496196,  19556009,  0xbde004b},
        {-90891025,  18473090,  -90603176,  18746509,  0xbde004b},
        {-91340000,  17799000,  -89094500,  20900000,  0x0ca0011},
        {-92470000,  17799000,  -90300000,  20900000,  0x025000d},
        {-92470000,  17799000,  -89094500,  20900000,  0x0020216},
        {-101240567, 19659255,  -101149272, 19745745,  0x001000a}, // MIC
        {-101400000, 19628330,  -100956117, 19914400,  0xf040447},
        {-102246747, 19252600,  -101893253, 19587489,  0xe890047},
        {-102356775, 19874910,  -102173225, 20047889,  0x782004b},
        {-102403895, 18987000,  -102174281, 19124500,  0x782044b},
        {-100451295, 19353510,  -100268706, 19526489,  0x782004b},
        {-102335000, 17914000,  -102097428, 18046200,  0x782044b},
        {-102099464, 20245620,  -101940137, 20395379,  0x680004b},
        {-102754364, 19974520,  -102595037, 20124279,  0x680004b},
        {-100649456, 19605120,  -100490545, 19754879,  0x680004b},
        {-101859456, 19745120,  -101700545, 19894879,  0x680004b},
        {-101728656, 19488020,  -101569745, 19637779,  0x680004b},
        {-103052500, 17909000,  -100060000, 20398000,  0x09d0011},
        {-103743000, 17909000,  -100803000, 20398000,  0x01d000d},
        {-103743000, 17909000,  -100060000, 20398000,  0x0020216},
        {-101021828, 22115155,  -100928611, 22201645,  0x001000a}, // SLP
        {-101139284, 21877780,  -100639316, 22368820,  0x001000c},
        {-99049969,  21883610,  -98804032,  22112389,  0x9ee004b},
        {-100736502, 23567960,  -100506498, 23779729,  0x931004b},
        {-100063326, 21822260,  -99835675,  22034029,  0x931004b},
        {-98920232,  21238360,  -98693169,  21450129,  0x931004b},
        {-98552720,  22073660,  -98324480,  22285429,  0x931004b},
        {-102310000, 21427000,  -99839000,  24510000,  0x0c30011},
        {-101130145, 21132000,  -98300000,  23813190,  0x001000d},
        {-102310000, 21132000,  -98300000,  24510000,  0x0020216},
        {-99933600,  16814555,  -99834525,  16892675,  0x01c000a}, // GRO
        {-100129968, 16710480,  -99645624,  17201520,  0x001000c},
        {-99572000,  17421300,  -99354284,  17673000,  0x9ee044b},
        {-99594979,  18268160,  -99372622,  18479929,  0x931004b},
        {-101663685, 17567660,  -101441916, 17779429,  0x931004b},
        {-99652273,  18464660,  -99429328,  18676429,  0x931004b},
        {-98654685,  17512560,  -98432916,  17724329,  0x931004b},
        {-102190000, 16574000,  -99042000,  18880000,  0x0930011},
        {-100288000, 16250000,  -97960000,  18789000,  0x001000d},
        {-102190000, 16250000,  -97960000,  18890000,  0x0020216},
        {-100353589, 25654755,  -100258450, 25741245,  0x001000a}, // NLE
        {-100641100, 25544000,  -99919000,  25886986,  0x015000c},
        {-100081056, 25087630,  -99765544,  25374459,  0xc73004b},
        {-99720381,  24723290,  -99419620,  24996709,  0xbde004b},
        {-99756498,  27344290,  -99448902,  27617709,  0xbde004b},
        {-100880000, 23135000,  -98400000,  25936000,  0x0ba0011},
        {-101240000, 25936000,  -98400000,  27830000,  0x001000d},
        {-101240000, 23135000,  -98400000,  27830000,  0x0020216},
        {-117070733, 32462654,  -116968867, 32549144,  0x001000a}, // BCN
        {-117125500, 32175161,  -116484412, 32587000,  0x01a000c},
        {-115593432, 32340220,  -115185969, 32686179,  0xf04004b},
        {-116816282, 31702600,  -116423718, 32037489,  0xe89004b},
        {-117545088, 30037805,  -114476615, 32718995,  0x0a90011},
        {-116160000, 27999000,  -112748200, 30050000,  0x019000d},
        {-118388964, 27999000,  -115380073, 30680190,  0x0010015},
        {-118403860, 27999000,  -112748200, 32719000,  0x0020216},
        {-96207200,  19182000,  -96123221,  19228845,  0x2a7044a}, // VER
        {-96186767,  19140000,  -96093003,  19182000,  0x2a7044a},
        {-96325190,  19012620,  -95960011,  19358579,  0xf040047},
        {-97148147,  19363600,  -96794653,  19698489,  0xe890047},
        {-94531514,  17996610,  -94349886,  18169589,  0x782004b},
        {-97491915,  20418000,  -97297927,  20582000,  0x782044b},
        {-94733000,  17919000,  -94513383,  18062000,  0x782044b},
        {-97054754,  18806110,  -96872646,  18979089,  0x782004b},
        {-97224454,  18749710,  -97042346,  18922689,  0x782004b},
        {-97476556,  20877210,  -97292045,  21050189,  0x782004b},
        {-95318000,  18378000,  -95018118,  18483000,  0x782044b},
        {-97102064,  20012820,  -96942737,  20162579,  0x680004b},
        {-97444028,  18349405,  -94643674,  20300000,  0x0900011},
        {-96330000,  17123005,  -93599823,  18770000,  0x001000d},
        {-98680000,  20050000,  -96000000,  22470595,  0x0010015},
        {-98682000,  17123000,  -93593000,  22478000,  0x0020216},
        {-93174000,  16725600,  -93060000,  16793245,  0x018000a}, // CHP
        {-93390600,  16549700,  -92881330,  17005400,  0x01d000c},
        {-92170000,  16099000,  -91821433,  16344100,  0xc73044b},
        {-92685206,  16492090,  -92400395,  16765509,  0xbde004b},
        {-92424167,  14763390,  -92141634,  15036809,  0xbde004b},
        {-94240000,  16060000,  -90368000,  17989000,  0x0790011},
        {-94240000,  14531918,  -91700000,  16400000,  0x001000d},
        {-94240000,  14531918,  -90368000,  17989000,  0x0020216},
        {-110350089, 24096755,  -110255911, 24183245,  0x001000a}, // BCS
        {-110575192, 23894480,  -110064808, 24385520,  0x001000c},
        {-109804000, 22989490,  -109555279, 23250000,  0xa9e044b},
        {-111584760, 25841390,  -111313641, 26086009,  0xa9e004b},
        {-110079502, 22860990,  -109814498, 23105609,  0xa9e004b},
        {-111743629, 24897410,  -111491972, 25126189,  0x9ee004b},
        {-112310000, 22843000,  -109400000, 25481190,  0x0a70011},
        {-113704131, 25319805,  -110754822, 28000995,  0x001000d},
        {-116653440, 25319805,  -113704131, 28000995,  0x0010015},
        {-116700000, 22800000,  -109400000, 28001000,  0x0020216},
        {-102629000, 22736620,  -102553341, 22790000,  0x2a7044a}, // ZAC
        {-102553341, 22725800,  -102476025, 22778000,  0x2a7044a},
        {-102824784, 22534480,  -102319608, 23025520,  0x001000c},
        {-102923122, 23033610,  -102675278, 23262389,  0x9ee004b},
        {-102293620, 22508860,  -102065380, 22720629,  0x931004b},
        {-103116420, 22539860,  -102888180, 22751629,  0x931004b},
        {-103212291, 23713360,  -102981110, 23925129,  0x931004b},
        {-102116520, 22137760,  -101888280, 22349529,  0x931004b},
        {-104368000, 21022000,  -101266000, 23343000,  0x0970011},
        {-104140000, 23343000,  -100738000, 25129000,  0x2d50015},
        {-104368000, 21022000,  -100738000, 25129000,  0x0020216},
        {-103384528, 20622055,  -103292272, 20708545,  0x001000a}, // JAL
        {-103541476, 20381380,  -103046716, 20872420,  0x001000c},
        {-105289216, 20548610,  -105045185, 20777389,  0x9ee004b},
        {-103534055, 19525660,  -103309345, 19737429,  0x931004b},
        {-102075632, 21260560,  -101848569, 21472329,  0x931004b},
        {-102798544, 20725200,  -102516881, 20895000,  0x931044b},
        {-102951750, 20286630,  -102694471, 20472000,  0x931044b},
        {-105695000, 18914000,  -101934000, 21025000,  0x0810011},
        {-104388000, 20939000,  -101501000, 22760000,  0x3140015},
        {-106800000, 18914000,  -101461000, 22760000,  0x0020216},
        {-97902500,  22208000,  -97815298,  22300000,  0x021000a}, // TAM
        {-98159934,  22207220,  -97787067,  22553179,  0xf040047},
        {-98430000,  25918000,  -97938034,  26170589,  0xe890447},
        {-97675760,  25699290,  -97404641,  25943909,  0xa9e004b},
        {-99740298,  27358690,  -99465102,  27603309,  0xa9e004b},
        {-99210821,  23682790,  -98943779,  23927409,  0xa9e004b},
        {-99099322,  22649310,  -98851478,  22878089,  0x9ee004b},
        {-100178000, 22200000,  -97500000,  24881000,  0x0af0011},
        {-99990000,  24881000,  -97121000,  27685000,  0x020000d},
        {-100178000, 22200000,  -97121000,  27685000,  0x0020216},
        {-96771767,  17021955,  -96681433,  17108445,  0x001000a}, // OAX
        {-96901368,  16749980,  -96417024,  17241020,  0x001000c},
        {-96191425,  17980000,  -95857274,  18168000,  0xa9e044b},
        {-95321166,  16147890,  -95067034,  16392509,  0xa9e004b},
        {-95220306,  16336000,  -94985839,  16601709,  0xa9e044b},
        {-97902991,  17675010,  -97663409,  17903789,  0x9ee004b},
        {-98590000,  15640000,  -96280000,  18677000,  0x0c40011},
        {-96320000,  15640000,  -93810000,  18340000,  0x020000d},
        {-98590000,  14564000,  -93810000,  18677000,  0x0020216},
        {-104717000, 23985500,  -104615000, 24063300,  0x01c000a}, // DUR
        {-104847792, 23815080,  -104337408, 24306120,  0x001000c},
        {-103636953, 25430630,  -103319848, 25717459,  0xc73004b},
        {-105448381, 24915290,  -105147620, 25188709,  0xbde004b},
        {-105455441, 23668190,  -105156959, 23941609,  0xbde004b},
        {-106202000, 22309000,  -103380000, 24700000,  0x0a10011},
        {-107260000, 24268000,  -104800000, 26842000,  0x001000d},
        {-104800000, 24268000,  -102477000, 26842000,  0x0010015},
        {-107260000, 22309000,  -102477000, 26842000,  0x0020216},
        {-101039700, 25372750,  -100959906, 25472750,  0x024000a}, // COA
        {-101110039, 25330220,  -100727562, 25676179,  0xf040047},
        {-103534619, 25456200,  -103164381, 25791089,  0xe890047},
        {-101535319, 26744190,  -101261482, 26988809,  0xa9e004b},
        {-100665457, 28583190,  -100387543, 28827809,  0xa9e004b},
        {-101072037, 29161390,  -100792764, 29406009,  0xa9e004b},
        {-101310888, 27775110,  -101053512, 28003889,  0x9ee004b},
        {-103540000, 24524000,  -100160000, 26500000,  0x0860011},
        {-103951000, 26500000,  -101875000, 29883000,  0x029000d},
        {-101875000, 26500000,  -99800000,  29883000,  0x50f0015},
        {-103951000, 24524000,  -99800000,  29883000,  0x0020216},
        {-111016511, 29066055,  -110918489, 29152545,  0x001000a}, // SON
        {-111156485, 28952220,  -110761515, 29298179,  0xf040047},
        {-110145175, 27319800,  -109768425, 27654689,  0xe890047},
        {-111070532, 31131260,  -110823468, 31343029,  0x931004b},
        {-114852344, 32299140,  -114624657, 32492459,  0x864004b},
        {-109601605, 27017840,  -109385195, 27211159,  0x864004b},
        {-110990479, 27850440,  -110771921, 28043759,  0x864004b},
        {-109645870, 31175840,  -109420331, 31369159,  0x864004b},
        {-112221164, 30591140,  -111997236, 30784459,  0x864004b},
        {-111462000, 26280000,  -108395000, 28820000,  0x0a10011},
        {-111566000, 28820000,  -108520000, 31388000,  0x001000d},
        {-115013524, 32002879,  -114461476, 32493919,  0x0b00090},
        {-115008316, 31511840,  -114461476, 32002880,  0x0b13090},
        {-114461476, 31904671,  -113914636, 32395711,  0x0b10890},
        {-114461476, 31413632,  -113914636, 31904672,  0x0b03890},
        {-113914636, 31737718,  -113367796, 32228758,  0x0b11090},
        {-113914636, 31246678,  -113367796, 31737718,  0x0b04090},
        {-113367796, 31570764,  -112820956, 32061804,  0x0b11890},
        {-112820956, 31570764,  -112274116, 32061804,  0x0b12090},
        {-112274116, 31570764,  -111727276, 32061804,  0x0b12890},
        {-113422480, 31079724,  -112875640, 31570764,  0x0b04890},
        {-112875640, 31079724,  -112328800, 31570764,  0x0b05090},
        {-112328800, 31079724,  -111781960, 31570764,  0x0b05890},
        {-111781960, 31079724,  -111235120, 31570764,  0x0b06090},
        {-113422480, 30588684,  -112880848, 31079724,  0x0b06890},
        {-112880848, 30588684,  -112339216, 31079724,  0x0b07090},
        {-112339216, 30588684,  -111797584, 31079724,  0x0b07890},
        {-111797584, 30588684,  -111255952, 31079724,  0x0b08090},
        {-113157288, 30097644,  -112620864, 30588684,  0x0b18890},
        {-112620864, 30097644,  -112084440, 30588684,  0x0b19090},
        {-112084440, 30097644,  -111548016, 30588684,  0x0b19890},
        {-113157288, 29606604,  -112620864, 30097644,  0x0b0a090},
        {-112620864, 29606604,  -112084440, 30097644,  0x0b0a890},
        {-112084440, 29606604,  -111548016, 30097644,  0x0b0b090},
        {-112620864, 29115564,  -112089648, 29606604,  0x0b1b890},
        {-112089648, 29115564,  -111558432, 29606604,  0x0b1c090},
        {-112620864, 28624524,  -112089648, 29115564,  0x0b0c890},
        {-112089648, 28624524,  -111558432, 29115564,  0x0b0d090},
        {-112403170, 28133484,  -111877162, 28624524,  0x0b1d890},
        {-111882370, 28329900,  -111351154, 28820940,  0x0b0e090},
        {-115060500, 26280000,  -108395000, 32494000,  0x0020216},
        {-106516372, 31681755,  -106415467, 31768245,  0x001000a}, // CHH
        {-106679510, 31446120,  -106275891, 31792079,  0xf040047},
        {-106218536, 28542900,  -105838065, 28877789,  0xe890047},
        {-105609478, 28105790,  -105332923, 28350409,  0xa9e004b},
        {-105858000, 26749400,  -105564416, 26977500,  0xa9e044b},
        {-106955078, 28283790,  -106678523, 28528409,  0xa9e004b},
        {-108051866, 30305610,  -107788135, 30534389,  0x9ee004b},
        {-108380000, 26259900,  -104248545, 28400000,  0x0800011},
        {-108400000, 28400000,  -105833000, 31787000,  0x4980015},
        {-108920000, 30910000,  -108400000, 31336700,  0x0010088},
        {-108949700, 30480000,  -108400000, 30910000,  0x01c0888},
        {-108695000, 29600000,  -108400000, 30480000,  0x0381088},
        {-108770000, 28950000,  -108400000, 29600000,  0x02a1888},
        {-108770000, 28400000,  -108400000, 28950000,  0x0272088},
        {-109082000, 28046000,  -108380000, 28400000,  0x0162888},
        {-109038000, 27650000,  -108380000, 28046000,  0x0183088},
        {-108773000, 26984000,  -108380000, 27650000,  0x0293888},
        {-105833000, 30806000,  -105262000, 31245700,  0x01c4088},
        {-105833000, 30300000,  -105290000, 30806000,  0x0014888},
        {-105290000, 30300000,  -104747000, 30806000,  0x0015088},
        {-105833000, 29860000,  -105220000, 30300000,  0x01b5888},
        {-105220000, 29860000,  -104607000, 30300000,  0x01b6088},
        {-105833000, 29387000,  -105269000, 29860000,  0x01d6888},
        {-105269000, 29387000,  -104705000, 29860000,  0x01d7088},
        {-104705000, 29387000,  -104141000, 29860000,  0x01d7888},
        {-105833000, 28893500,  -105294000, 29387000,  0x01e8088},
        {-105294000, 28893500,  -104751000, 29387000,  0x01e8888},
        {-104751000, 28893500,  -104209000, 29387000,  0x01e9088},
        {-104209000, 28893500,  -103650000, 29387000,  0x01e9888},
        {-105833000, 28400000,  -105294000, 28893500,  0x01ea088},
        {-105294000, 28400000,  -104751000, 28893500,  0x01ea888},
        {-104751000, 28400000,  -104209000, 28893500,  0x01eb088},
        {-104209000, 28400000,  -103650000, 28893500,  0x01eb888},
        {-103650000, 28524000,  -103295000, 29174500,  0x02bc088},
        {-104248545, 27884000,  -103690000, 28400000,  0x01ec888},
        {-104248545, 27242000,  -103806500, 27884000,  0x026d088},
        {-104248545, 26725000,  -103698000, 27242000,  0x01ed888},
        {-107880400, 25854600,  -107200100, 26259900,  0x018e088},
        {-107200100, 25922000,  -106385000, 26259900,  0x014e888},
        {-107200100, 25560000,  -106460000, 25922000,  0x016f088},
        {-109100000, 25555000,  -103295000, 31800000,  0x0020216},
        {-51762770,  64129105,  -51565765,  64215595,  0x001000a}, // GRL
        {-52234800,  63935480,  -51187992,  64426520,  0x001000c},
        {-53890666,  66852510,  -53455334,  67025489,  0x782004b},
        {-51182368,  69142120,  -50770529,  69291879,  0x680004b},
        {-46093403,  60642120,  -45791388,  60791879,  0x680004b},
        {-53071344,  68635120,  -52668657,  68784879,  0x680004b},
        {-52668657,  68635120,  -52265970,  68784879,  0x680004b},
        {-53077216,  65342120,  -52722785,  65491879,  0x680004b},
        {-49763222,  61934096,  -49445815,  62083855,  0x680004b},
        {-37817752,  65540120,  -37456249,  65689879,  0x680004b},
        {-46203504,  60842120,  -45896497,  60991879,  0x680004b},
        {-45385720,  60068120,  -45088281,  60217879,  0x680004b},
        {-48600000,  59700000,  -42000000,  61600000,  0x07e0011},
        {-54100000,  63730446,  -48900000,  66757595,  0x023000d},
        {-54246553,  66757605,  -47513787,  69438795,  0x0010015},
        {-56180000,  59700000,  -21340000,  72200000,  0x3120016},
        {-73263500,  72200000,  -11100000,  83627430,  0x0840012},
        {-73263500,  59700000,  -11100000,  83627430,  0x0010217},
        {46675611,   24628355,  46769789,   24714845,  0x001000a}, // SAU
        {39087500,   21326400,  39399194,   21738000,  0xf040447},
        {46569341,   24503600,  46935858,   24838489,  0xe890047},
        {36498222,   28331090,  36637178,   28453399,  0x54f004b},
        {43901381,   26303590,  44037619,   26425899,  0x54f004b},
        {39750432,   21430000,  39843167,   21516489,  0x3c1004b},
        {39843167,   21430000,  39935902,   21516489,  0x3c1004b},
        {39935902,   21430000,  40028637,   21516489,  0x3c1004b},
        {39731885,   21343511,  39824620,   21430000,  0x3c1004b},
        {39824620,   21343511,  39917355,   21430000,  0x3c1004b},
        {39532571,   24416800,  39627228,   24503289,  0x3c1004b},
        {39627228,   24416800,  39721885,   24503289,  0x3c1004b},
        {39532571,   24330311,  39627228,   24416800,  0x3c1004b},
        {39627228,   24330311,  39721885,   24416800,  0x3c1004b},
        {50003630,   26386800,  50099969,   26473289,  0x3c1004b},
        {50099969,   26386800,  50196308,   26473289,  0x3c1004b},
        {49948716,   26300311,  50045055,   26386800,  0x3c1004b},
        {50045055,   26300311,  50141394,   26386800,  0x3c1004b},
        {50141394,   26300311,  50237733,   26386800,  0x3c1004b},
        {50132001,   26213822,  50227859,   26300311,  0x3c1004b},
        {40378732,   21219000,  40471467,   21305489,  0x3c1004b},
        {49544500,   25319400,  49642009,   25404100,  0x3c1044b},
        {49509091,   25404100,  49609684,   25486200,  0x3c1044b},
        {42683700,   18258700,  42779333,   18340700,  0x3c1044b},
        {41656100,   27475700,  41743579,   27571800,  0x3c1044b},
        {47262600,   24115100,  47379320,   24185000,  0x3c1044b},
        {45912369,   28382400,  46010630,   28468889,  0x3c1004b},
        {42480000,   18194700,  42612771,   18253750,  0x3c1044b},
        {40982748,   30938700,  41083652,   31025189,  0x3c1004b},
        {49993330,   26510600,  50089669,   26597089,  0x3c1004b},
        {43956171,   26046200,  44052029,   26132689,  0x3c1004b},
        {38010791,   24053600,  38121124,   24127500,  0x3c1044b},
        {45531092,   23001497,  48420819,   25682687,  0x001000d},
        {47318213,   25023724,  50267522,   27704914,  0x0010015},
        {46481708,   24452880,  46992092,   24943920,  0x001008c},
        {39058316,   21269480,  39558284,   21760520,  0x001088c},
        {39552516,   21198880,  40052484,   21689920,  0x001108c},
        {39357808,   24214480,  39868192,   24705520,  0x001188c},
        {49717200,   26254180,  50238000,   26745220,  0x001208c},
        {40115216,   21053280,  40615184,   21544320,  0x001288c},
        {36305700,   28138680,  36831708,   28629720,  0x001308c},
        {43727108,   25981880,  44242700,   26472920,  0x001388c},
        {49268008,   25096480,  49783600,   25587520,  0x001408c},
        {42371324,   18020580,  42860876,   18511620,  0x001488c},
        {41441200,   27279380,  41967208,   27770420,  0x001508c},
        {46987808,   23828380,  47498192,   24319420,  0x001588c},
        {45702200,   28184480,  46228208,   28675520,  0x001608c},
        {40762384,   30736380,  41304016,   31227420,  0x001688c},
        {37920608,   23846380,  38430992,   24337420,  0x001708c},
        {49389600,   26730580,  49910400,   27221620,  0x001788c},
        {37071784,   31084480,  37618624,   31575520,  0x001808c},
        {39772092,   29644480,  40308516,   30135520,  0x001888c},
        {43253908,   25703880,  43769500,   26194920,  0x001908c},
        {44041024,   17352180,  44530576,   17843220,  0x001988c},
        {42445224,   16779480,  42934776,   17270520,  0x001a08c},
        {48126600,   28054680,  48652608,   28545720,  0x001a88c},
        {42357824,   19764480,  42852584,   20255520,  0x001b08c},
        {44598308,   25975580,  45113900,   26466620,  0x001b88c},
        {44124808,   24244480,  44635192,   24735520,  0x001c08c},
        {46875224,   17224480,  47364776,   17715520,  0x001c88c},
        {38391784,   31424480,  38938624,   31915520,  0x001d08c},
        {49284708,   25538780,  49800300,   26029820,  0x001d88c},
        {38772616,   22554480,  39277792,   23045520,  0x001e08c},
        {43236992,   29384480,  43773416,   29875520,  0x001e88c},
        {42674808,   23674480,  43185192,   24165520,  0x001f08c},
        {36019131,   29479810,  39087604,   32161000,  0x0a80091},
        {39087604,   29479810,  42156077,   32161000,  0x0a80891},
        {42156077,   29479810,  45224550,   32161000,  0x0a81091},
        {34484001,   26798620,  37463101,   29479810,  0x0a91891},
        {37463101,   26798620,  40442201,   29479810,  0x0a92091},
        {40442201,   26798620,  43421301,   29479810,  0x0a92891},
        {43421301,   26798620,  46400401,   29479810,  0x0a93091},
        {46400401,   26798620,  49379501,   29479810,  0x0a93891},
        {47592041,   26798620,  50571141,   29479810,  0x0a94091},
        {35735223,   24117430,  38654741,   26798620,  0x0a94891},
        {38654741,   24117430,  41574259,   26798620,  0x0a95091},
        {41574259,   24117430,  44493777,   26798620,  0x0a95891},
        {44493777,   24117430,  47413295,   26798620,  0x0a96091},
        {47413295,   24117430,  50332813,   26798620,  0x0a96891},
        {50332813,   24117430,  53252331,   26798620,  0x0a97091},
        {37890423,   21436240,  40750359,   24117430,  0x0a97891},
        {40750359,   21436240,  43610295,   24117430,  0x0a98091},
        {43610295,   21436240,  46470231,   24117430,  0x0a98891},
        {46470231,   21436240,  49330167,   24117430,  0x0a99091},
        {49330167,   21436240,  52190103,   24117430,  0x0a99891},
        {52190103,   21436240,  55670000,   23440000,  0x084a091},
        {38761394,   18755050,  41561748,   21436240,  0x0a9a891},
        {41561748,   18755050,  44362102,   21436240,  0x0a9b091},
        {44362102,   18755050,  47162456,   21436240,  0x0a9b891},
        {47162456,   18755050,  49962810,   21436240,  0x0a9c091},
        {49962810,   18755050,  52763164,   21436240,  0x0a9c891},
        {52763164,   18755050,  55563518,   21436240,  0x0a9d091},
        {40611415,   16073860,  43381978,   18755050,  0x0a9d891},
        {43352187,   17146336,  46152541,   19827526,  0x0a8e091},
        {46152541,   16878217,  48952895,   19559407,  0x0a8e891},
        {48952895,   18218812,  51753249,   20900002,  0x0a9f091},
        {34470000,   16073800,  55670000,   32161000,  0x0010217},
        {15277000,   -4382000,  15363245,   -4296000,  0x001000a}, // COD
        {15171687,   -4512500,  15547757,   -4293200,  0xc730447},
        {27322332,   -11781110, 27601067,   -11507691, 0xbde0047},
        {23531631,   -6322810,  23806569,   -6049391,  0xbde0047},
        {25443935,   -10761200, 25531865,   -10674711, 0x3c1004b},
        {22356515,   -5933200,  22443484,   -5846711,  0x3c1004b},
        {25147155,   483700,    25233644,   570189,    0x3c1004b},
        {26692235,   -11036600, 26780165,   -10950111, 0x3c1004b},
        {13014115,   -5863800,  13101084,   -5777311,  0x3c1004b},
        {20741315,   -6474200,  20828284,   -6387711,  0x3c1004b},
        {28807155,   -2551000,  28893644,   -2464511,  0x3c1004b},
        {13428615,   -5871700,  13515584,   -5785211,  0x3c1004b},
        {18763935,   -5083800,  18850664,   -4997311,  0x3c1004b},
        {29114635,   -3426400,  29201364,   -3339911,  0x3c1004b},
        {23408395,   -7049700,  23495604,   -6963211,  0x3c1004b},
        {18217255,   -7400,     18303744,   79089,     0x3c1004b},
        {29253555,   77900,     29340044,   164389,    0x3c1004b},
        {29162855,   -1702300,  29249344,   -1615811,  0x3c1004b},
        {27583350,   2743050,   27645449,   2805149,   0x2b2004b},
        {30218840,   1536140,   30278959,   1596259,   0x29c004b},
        {19746664,   3215450,   19808935,   3277549,   0x2b2004b},
        {25897140,   -2978460,  25957259,   -2918341,  0x29c004b},
        {17352964,   -3346750,  17415235,   -3284651,  0x2b2004b},
        {20565657,   -4362460,  20625943,   -4302341,  0x29c004b},
        {29157878,   -5958350,  29220322,   -5896251,  0x2b2004b},
        {29434640,   466140,    29494759,   526259,    0x29c004b},
        {23917778,   -6763550,  23980222,   -6701451,  0x2b2004b},
        {22438340,   2165840,   22498459,   2225959,   0x29c004b},
        {14837864,   -5279350,  14900135,   -5217251,  0x2b2004b},
        {27218956,   -11788960, 27280244,   -11728841, 0x29c004b},
        {24966505,   -8765450,  25029294,   -8703351,  0x2b2004b},
        {21484740,   2134840,   21544859,   2194959,   0x29c004b},
        {23577364,   -3553250,  23639635,   -3491151,  0x2b2004b},
        {24451373,   -6170660,  24511826,   -6110541,  0x29c004b},
        {26634364,   -4468750,  26696635,   -4406651,  0x2b2004b},
        {21530157,   -4879560,  21590443,   -4819441,  0x29c004b},
        {20973064,   4253750,   21035335,   4315849,   0x2b2004b},
        {18576357,   -4584060,  18636643,   -4523941,  0x29c004b},
        {24703450,   2773850,   24765549,   2835949,   0x2b2004b},
        {23570640,   1224940,   23630759,   1285059,   0x29c004b},
        {23398864,   -5001050,  23461135,   -4938951,  0x2b2004b},
        {17660240,   -2743360,  17720359,   -2683241,  0x29c004b},
        {18259750,   -1967950,  18321849,   -1905851,  0x2b2004b},
        {12913157,   -5039260,  12973443,   -4979141,  0x29c004b},
        {19537164,   -4100250,  19599435,   -4038151,  0x2b2004b},
        {17004757,   -4842560,  17065043,   -4782441,  0x29c004b},
        {25800105,   -9193550,  25862894,   -9131451,  0x2b2004b},
        {24410340,   749640,    24470459,   809759,    0x29c004b},
        {27358092,   -7328350,  27420708,   -7266251,  0x2b2004b},
        {23749940,   2709940,   23810059,   2770059,   0x29c004b},
        {21376878,   -5365150,  21439322,   -5303051,  0x2b2004b},
        {26569439,   -10900060, 26630560,   -10839941, 0x29c004b},
        {21845890,   -7258575,  24527080,   -4577385,  0x0a80011},
        {15026025,   -4694725,  15494745,   -4203685,  0x0011888},
        {25217199,   -10769520, 25691127,   -10278480, 0x0012088},
        {24956035,   281379,    25424755,   772419,    0x0012888},
        {26426349,   -11195520, 26900277,   -10704480, 0x0013088},
        {13030495,   -6070070,  13499215,   -5579030,  0x0013888},
        {20550445,   -6676520,  21019165,   -6185480,  0x0014088},
        {28595835,   -2729420,  29064555,   -2238380,  0x0014888},
        {18572935,   -5286120,  19041655,   -4795080,  0x0015088},
        {28823635,   -3628720,  29292355,   -3137680,  0x0015888},
        {18026135,   -209721,   18494855,   281319,    0x0016088},
        {29146385,   63129,     29615105,   554169,    0x0016888},
        {28971735,   -1904620,  29440455,   -1413580,  0x0017088},
        {27380035,   2528579,   27848755,   3019619,   0x0017888},
        {29900085,   1522579,   30368805,   2013619,   0x0018088},
        {19543435,   3000979,   20012155,   3492019,   0x0018888},
        {25692835,   -3193920,  26161555,   -2702880,  0x0019088},
        {17149735,   -3561220,  17618455,   -3070180,  0x0019888},
        {20361435,   -4577920,  20830155,   -4086880,  0x001a088},
        {28954745,   -6172820,  29423465,   -5681780,  0x001a888},
        {22234035,   1950379,   22702755,   2441419,   0x001b088},
        {14775135,   -5359670,  15243855,   -4868630,  0x001b888},
        {27017849,   -12004420, 27491777,   -11513380, 0x001c088},
        {24766139,   -8979920,  25240067,   -8488880,  0x001c888},
        {21280435,   1919379,   21749155,   2410419,   0x001d088},
        {23374135,   -3767720,  23842855,   -3276680,  0x001d888},
        {26431135,   -4683220,  26899855,   -4192180,  0x001e088},
        {21325935,   -5095020,  21794655,   -4603980,  0x001e888},
        {20857735,   4046879,   21326455,   4537919,   0x001f088},
        {18372135,   -4799520,  18840855,   -4308480,  0x0b00090},
        {24500135,   2559379,   24968855,   3050419,   0x0b00890},
        {23366335,   1009479,   23835055,   1500519,   0x0b01090},
        {17455935,   -2958820,  17924655,   -2467780,  0x0b01890},
        {18056435,   -2182420,  18525155,   -1691380,  0x0b02090},
        {12708935,   -5254720,  13177655,   -4763680,  0x0b02890},
        {19333935,   -4314720,  19802655,   -3823680,  0x0b03090},
        {16800535,   -5058020,  17269255,   -4566980,  0x0b03890},
        {25599739,   -9408020,  26073667,   -8916980,  0x0b04090},
        {24206035,   534179,    24674755,   1025219,   0x0b04890},
        {27155045,   -7542820,  27623765,   -7051780,  0x0b15090},
        {23545635,   2494479,   24014355,   2985519,   0x0b05890},
        {21173745,   -5579620,  21642465,   -5088580,  0x0b06090},
        {25515645,   -5635520,  25984365,   -5144480,  0x0b06890},
        {16685635,   -3265520,  17154355,   -2774480,  0x0b07090},
        {20625635,   -465520,   21094355,   25520,     0x0b07890},
        {26435635,   -3845520,  26904355,   -3354480,  0x0b08090},
        {22205635,   3864479,   22674355,   4355519,   0x0b08890},
        {26745645,   -5625520,  27214365,   -5134480,  0x0b09090},
        {22015605,   2799479,   22484325,   3290519,   0x0b09890},
        {22645635,   454479,    23114355,   945519,    0x0b0a090},
        {25275635,   3044479,   25744355,   3535519,   0x0b0a890},
        {17905635,   -2965520,  18374355,   -2474480,  0x0b0b090},
        {20635635,   3094479,   21104355,   3585519,   0x0b0b890},
        {26675645,   -6295520,  27144365,   -5804480,  0x0b1c090},
        {29485645,   -7305520,  29954365,   -6814480,  0x0b1c890},
        {16165635,   -2270520,  16634355,   -1779480,  0x0b0d090},
        {23935645,   -7815520,  24404365,   -7324480,  0x0b1d890},
        {18385635,   3414479,   18854355,   3905519,   0x0b0e090},
        {25585635,   4484479,   26054355,   4975519,   0x0b0e890},
        {29295635,   2794479,   29764355,   3285519,   0x0b0f090},
        {21675219,   -10687095, 24356409,   -8005905,  0x001088d},
        {24356409,   -10687095, 27037599,   -8005905,  0x001108d},
        {26286865,   -10687095, 28968055,   -8005905,  0x001188d},
        {28110075,   -8810262,  30791265,   -6129072,  0x001208d},
        {22142000,   -11712000, 25458676,   -9346500,  0x01a288d},
        {25458676,   -12474000, 28240000,   -9882738,  0x01e308d},
        {28240000,   -13460000, 29840000,   -10687140, 0x029388d},
        {27430000,   -11230000, 28710000,   -10100000, 0x001408d},
        {18189677,   2718810,   20870867,   5400000,   0x0a80091},
        {20870867,   2718810,   23552057,   5400000,   0x0a80891},
        {23552057,   2718810,   26233247,   5400000,   0x0a81091},
        {26233247,   2718810,   28914437,   5400000,   0x0a81891},
        {28628810,   2718810,   31310000,   5400000,   0x0a82091},
        {17653439,   37620,     20334629,   2718810,   0x0a82891},
        {20334629,   37620,     23015819,   2718810,   0x0a83091},
        {23015819,   37620,     25697009,   2718810,   0x0a83891},
        {25697009,   37620,     28378199,   2718810,   0x0a84091},
        {28378199,   37620,     31059389,   2718810,   0x0a84891},
        {28628810,   37620,     31310000,   2718810,   0x0a85091},
        {15910666,   -2643570,  18591856,   37620,     0x0a85891},
        {18591856,   -2643570,  21273046,   37620,     0x0a86091},
        {21273046,   -2643570,  23954236,   37620,     0x0a86891},
        {23954236,   -2643570,  26635426,   37620,     0x0a87091},
        {26635426,   -2643570,  29316616,   37620,     0x0a87891},
        {27171664,   -2643570,  29852854,   37620,     0x0a88091},
        {14623694,   -5324760,  17304884,   -2643570,  0x0a88891},
        {17304884,   -5324760,  19986074,   -2643570,  0x0a89091},
        {19986074,   -5324760,  22667264,   -2643570,  0x0a89891},
        {22667264,   -5324760,  25348454,   -2643570,  0x0a8a091},
        {25348454,   -5324760,  28029644,   -2643570,  0x0a8a891},
        {26635426,   -5324760,  29316616,   -2643570,  0x0a8b091},
        {12022940,   -6665355,  14704130,   -3984165,  0x0a8b891},
        {14704130,   -8005950,  17385320,   -5324760,  0x0a9c091},
        {17385320,   -8005950,  20066510,   -5324760,  0x0a9c891},
        {20066510,   -8005950,  22747700,   -5324760,  0x0a9d091},
        {22747700,   -8005950,  25428890,   -5324760,  0x0a9d891},
        {25428890,   -8005950,  28110080,   -5324760,  0x0a9e091},
        {28110080,   -8005950,  30791270,   -5324760,  0x0a9e891},
        {17385320,   -8274069,  20066510,   -5592879,  0x0a9f091},
        {11700000,   -13460000, 31310000,   5400000,   0x0010217},
        {2986184,    36735355,  3093816,    36821845,  0x001000a}, // DZA
        {2710600,    36444400,  3455670,    36822000,  0x018000c},
        {-670880,    35665100,  -549721,    35741000,  0x3c1044b},
        {6566425,    36317200,  6673575,    36403689,  0x3c1004b},
        {6116345,    35506700,  6222054,    35593189,  0x3c1004b},
        {7706000,    36824500,  7794339,    36930000,  0x3c1044b},
        {5356785,    36146800,  5463214,    36233289,  0x3c1004b},
        {-667555,    35157700,  -561846,    35244189,  0x3c1004b},
        {5681706,    34787200,  5786694,    34873689,  0x3c1004b},
        {3205706,    34622000,  3310694,    34708489,  0x3c1004b},
        {8050445,    35376200,  8156154,    35462689,  0x3c1004b},
        {6890364,    36815800,  6998235,    36902289,  0x3c1004b},
        {5004925,    36692700,  5112075,    36779189,  0x3c1004b},
        {1277145,    35312800,  1382854,    35399289,  0x3c1004b},
        {1278685,    36108200,  1385114,    36194689,  0x3c1004b},
        {3993125,    36666900,  4100275,    36753389,  0x3c1004b},
        {-2261697,   31575750,  -2188903,   31637849,  0x2b2004b},
        {4726110,    36040840,  4800090,    36100959,  0x29c004b},
        {53092,      35908950,  129508,     35971049,  0x2b2004b},
        {2731759,    36240040,  2806240,    36300159,  0x29c004b},
        {-1357691,   34858950,  -1282310,   34921049,  0x2b2004b},
        {5292763,    31921040,  5363236,    31981159,  0x29c004b},
        {7921933,    36251050,  7998867,    36313149,  0x2b2004b},
        {123180,     34810540,  179115,     34888900,  0x29c044b},
        {7398000,    36432800,  7494669,    36482200,  0x2b2044b},
        {7103460,    35398140,  7176939,    35458259,  0x29c004b},
        {5711874,    36770450,  5789325,    36832549,  0x2b2004b},
        {5647210,    36121540,  5721190,    36181659,  0x29c004b},
        {6822999,    33338950,  6897000,    33401049,  0x2b2004b},
        {511210,     35699340,  585190,     35759459,  0x29c004b},
        {4501792,    35678950,  4578208,    35741049,  0x2b2004b},
        {4143260,    35179940,  4216739,    35240059,  0x29c004b},
        {2830740,    33778650,  2905259,    33840749,  0x2b2004b},
        {7351310,    35764740,  7425290,    35824859,  0x29c004b},
        {2864350,    35419450,  2940249,    35481549,  0x2b2004b},
        {103260,     35369940,  176739,     35430059,  0x29c004b},
        {5329750,    35356450,  5405649,    35418549,  0x2b2004b},
        {3862759,    36349940,  3937240,    36410059,  0x29c004b},
        {3633430,    32458950,  3706569,    32521049,  0x2b2004b},
        {3463678,    34129940,  3536322,    34190059,  0x29c004b},
        {7075592,    35852000,  7183350,    35896000,  0x2b2044b},
        {-1773289,   34824140,  -1700311,   34884259,  0x29c004b},
        {2883592,    36105750,  2960008,    36167849,  0x2b2004b},
        {2183559,    36229740,  2258040,    36289859,  0x29c004b},
        {6219174,    36727150,  6296625,    36789249,  0x2b2004b},
        {6681059,    36228440,  6755540,    36288559,  0x29c004b},
        {4464272,    32745850,  4537928,    32807949,  0x2b2004b},
        {2706910,    35857140,  2780890,    35917259,  0x29c004b},
        {2970000,    35044000,  3060895,    35095449,  0x2b2044b},
        {990928,     33648440,  1063071,    33708559,  0x29c004b},
        {-2220600,   34678220,  2030414,    36581000,  0x016000d},
        {2030414,    34257524,  5247842,    36938714,  0x0a90011},
        {5247842,    34660000,  8690000,    37090000,  0x3790015},
        {-3200372,   34408810,  17056,      37090000,  0x001008d},
        {17055,      34408810,  3234483,    37090000,  0x001088d},
        {3234483,    34408810,  6451911,    37090000,  0x001108d},
        {6451911,    34408810,  9669339,    37090000,  0x001188d},
        {-3170581,   32357699,  -12735,     35038889,  0x001208d},
        {-12736,     32357699,  3145110,    35038889,  0x001288d},
        {3145110,    32357699,  6302956,    35038889,  0x001308d},
        {6302956,    32357699,  9460802,    35038889,  0x001388d},
        {-5637276,   29676509,  -2568803,   32357699,  0x001408d},
        {-2568803,   29676509,  499670,     32357699,  0x001488d},
        {499669,     29676509,  3568142,    32357699,  0x001508d},
        {3568142,    29676509,  6636615,    32357699,  0x001588d},
        {6636615,    29676509,  9705088,    32357699,  0x001608d},
        {-8670790,   26995319,  -5691690,   29676509,  0x001688d},
        {-6003705,   26995319,  -3024605,   29676509,  0x001708d},
        {-3024605,   26995319,  -45505,     29676509,  0x001788d},
        {-45506,     26995319,  2933594,    29676509,  0x001808d},
        {2933594,    26995319,  5912694,    29676509,  0x001888d},
        {5912694,    26995319,  8891794,    29676509,  0x001908d},
        {8891794,    26995319,  11870894,   29676509,  0x001988d},
        {-8655104,   24314129,  -5735586,   26995319,  0x001a08d},
        {-5735586,   24314129,  -2816068,   26995319,  0x001a88d},
        {-2816068,   24314129,  103450,     26995319,  0x001b08d},
        {103449,     24314129,  3022967,    26995319,  0x001b88d},
        {3022967,    24314129,  5942485,    26995319,  0x001c08d},
        {5942485,    24314129,  8862003,    26995319,  0x001c88d},
        {8862003,    24314129,  11781521,   26995319,  0x001d08d},
        {-4246036,   21632939,  -1386100,   24314129,  0x0a90091},
        {-1386101,   21632939,  1473835,    24314129,  0x0a90891},
        {1473835,    21632939,  4333771,    24314129,  0x0a91091},
        {4333771,    21632939,  7193707,    24314129,  0x0a91891},
        {7193707,    21632939,  10053643,   24314129,  0x0a92091},
        {9139564,    21632939,  11999500,   24314129,  0x0a92891},
        {-1356310,   18951749,  1473835,    21632939,  0x0a83091},
        {1473835,    18951749,  4303980,    21632939,  0x0a83891},
        {4303980,    18951749,  7134125,    21632939,  0x0a84091},
        {7134125,    18951749,  9964270,    21632939,  0x0a84891},
        {-8670790,   18944440,  11999500,   37090000,  0x0010217},
        {76870879,   43211055,  76989082,   43297545,  0x001000a}, // KAZ
        {76716500,   43153730,  77108500,   43440559,  0xc730047},
        {72901078,   49719090,  73320321,   49992509,  0xbde0047},
        {69460000,   42245590,  69901891,   42473000,  0xbde0447},
        {71298201,   42837190,  71463998,   42959499,  0x54f004b},
        {71348872,   51109890,  71542528,   51232199,  0x54f004b},
        {65416714,   44778490,  65588286,   44900799,  0x54f004b},
        {76899168,   52236800,  77039232,   52323289,  0x3c1004b},
        {82541571,   49928300,  82675629,   50014789,  0x3c1004b},
        {80189450,   50371000,  80324950,   50457489,  0x3c1004b},
        {57124871,   50239700,  57258929,   50326189,  0x3c1004b},
        {63581866,   53170800,  63725534,   53257289,  0x3c1004b},
        {69099023,   54835700,  69247977,   54922189,  0x3c1004b},
        {51344829,   51187800,  51481770,   51274289,  0x3c1004b},
        {72885071,   50027700,  73019129,   50114189,  0x3c1004b},
        {51127218,   43615800,  51246381,   43702289,  0x3c1004b},
        {51847635,   47066700,  51973765,   47153189,  0x3c1004b},
        {75248988,   51680300,  75387611,   51766789,  0x3c1004b},
        {68183955,   43270400,  68329094,   43340700,  0x3c1044b},
        {63039427,   52925600,  63181173,   53012089,  0x3c1004b},
        {67635934,   47753400,  67764466,   47839889,  0x3c1004b},
        {69340500,   53242400,  69465481,   53341700,  0x3c1044b},
        {78304500,   44974700,  78440217,   45052000,  0x3c1044b},
        {74910235,   46804100,  75036365,   46890589,  0x3c1004b},
        {67438400,   47848300,  67597160,   47918300,  0x3c1044b},
        {63217437,   45594200,  63339963,   45680689,  0x3c1004b},
        {83448371,   50299200,  83582429,   50385689,  0x3c1004b},
        {68471000,   43483800,  68605807,   43559500,  0x3c1044b},
        {70126000,   52905400,  70290904,   52979700,  0x3c1044b},
        {52800000,   43307000,  52949567,   43375300,  0x3c1044b},
        {71783668,   52292300,  71923732,   52378789,  0x3c1004b},
        {66845471,   50210600,  66979529,   50297089,  0x3c1004b},
        {67900000,   41193755,  71800000,   43585595,  0x0970011},
        {75109749,   42760762,  78744251,   45441952,  0x001000d},
        {66847895,   52606890,  71227172,   55288080,  0x0010015},
        {60946509,   52768810,  65325786,   55450000,  0x001008d},
        {65325786,   52768810,  69705063,   55450000,  0x001088d},
        {69705063,   52768810,  74084340,   55450000,  0x001108d},
        {74084340,   52768810,  78463617,   55450000,  0x001188d},
        {47051987,   50087620,  51192936,   52768810,  0x001208d},
        {51192936,   50087620,  55333885,   52768810,  0x001288d},
        {55333885,   50087620,  59474834,   52768810,  0x001308d},
        {59474834,   50087620,  63615783,   52768810,  0x001388d},
        {63615783,   50087620,  67756732,   52768810,  0x001408d},
        {67756732,   50087620,  71897681,   52768810,  0x001488d},
        {71897681,   50087620,  76038630,   52768810,  0x001508d},
        {76038630,   50087620,  80179579,   52768810,  0x001588d},
        {80179579,   50087620,  84320528,   52768810,  0x001608d},
        {83397797,   47942668,  87360000,   50623858,  0x001688d},
        {46480000,   47406430,  50412412,   50087620,  0x001708d},
        {50388281,   47406430,  54320693,   50087620,  0x001788d},
        {54320693,   47406430,  58253105,   50087620,  0x001808d},
        {58253105,   47406430,  62185517,   50087620,  0x001888d},
        {62185517,   47406430,  66117929,   50087620,  0x001908d},
        {66117929,   47406430,  70050341,   50087620,  0x001988d},
        {70050341,   47406430,  73982753,   50087620,  0x001a08d},
        {73982753,   47406430,  77915165,   50087620,  0x001a88d},
        {77915165,   47406430,  81847577,   50087620,  0x001b08d},
        {81847577,   47406430,  85779989,   50087620,  0x001b88d},
        {48314827,   44725240,  52068493,   47406430,  0x001c08d},
        {52068493,   44725240,  55822159,   47406430,  0x001c88d},
        {55822159,   44725240,  59575825,   47406430,  0x001d08d},
        {49530300,   42044050,  53135011,   44725240,  0x001d88d},
        {53135011,   42044050,  56739722,   44725240,  0x001e08d},
        {49589882,   40560000,  53045638,   43241190,  0x001e88d},
        {53045638,   40560000,  56501394,   43241190,  0x001f08d},
        {59462619,   44725240,  63216285,   47406430,  0x0a80091},
        {63216285,   44725240,  66969951,   47406430,  0x0a80891},
        {66969951,   44725240,  70723617,   47406430,  0x0a81091},
        {70723617,   44725240,  74477283,   47406430,  0x0a81891},
        {74477283,   44725240,  78230949,   47406430,  0x0a82091},
        {78230949,   44725240,  81984615,   47406430,  0x0a82891},
        {81984615,   44725240,  85738281,   47406430,  0x0a83091},
        {59551992,   42044050,  63156703,   44725240,  0x0a83891},
        {63156703,   42044050,  66761414,   44725240,  0x0a84091},
        {66761414,   42044050,  70366125,   44725240,  0x0a84891},
        {70366125,   42044050,  73970836,   44725240,  0x0a85091},
        {73970836,   42044050,  77575547,   44725240,  0x0a85891},
        {77575547,   42044050,  81180258,   44725240,  0x0a86091},
        {65018641,   40560000,  68474397,   43241190,  0x0aa6891},
        {68474397,   40560000,  71930153,   43241190,  0x0aa7091},
        {46480000,   40560000,  87360000,   55450000,  0x0010217},
        {-58453030,  -34644596, -58349242,  -34558106, 0x001000a}, // ARG
        {-58744317,  -34890070, -58181853,  -34399030, 0x001000c},
        {-64286115,  -31387370, -64226686,  -31336431, 0x236004b},
        {-64226686,  -31387370, -64167257,  -31336431, 0x236004b},
        {-64286115,  -31438309, -64226686,  -31387370, 0x236004b},
        {-64226686,  -31438309, -64167257,  -31387370, 0x236004b},
        {-60703310,  -32937570, -60642891,  -32886631, 0x236004b},
        {-60685184,  -32988509, -60624765,  -32937570, 0x236004b},
        {-68860210,  -32915470, -68799791,  -32864531, 0x236004b},
        {-57990917,  -34945470, -57929083,  -34894531, 0x236004b},
        {-65246612,  -26852870, -65189589,  -26801931, 0x236004b},
        {-57610891,  -38025370, -57546510,  -37974431, 0x236004b},
        {-65444417,  -24815870, -65388384,  -24764931, 0x236004b},
        {-60735456,  -31654770, -60675744,  -31603831, 0x236004b},
        {-68567356,  -31567170, -68507644,  -31516231, 0x236004b},
        {-59018653,  -27485470, -58961347,  -27434531, 0x236004b},
        {-64298153,  -27823670, -64240847,  -27772731, 0x236004b},
        {-68091886,  -38977370, -68026514,  -38926431, 0x236004b},
        {-58843453,  -27521270, -58786147,  -27470331, 0x236004b},
        {-62304874,  -38745370, -62239927,  -38694431, 0x236004b},
        {-55946453,  -27407270, -55889147,  -27356331, 0x236004b},
        {-60545356,  -31764170, -60485644,  -31713231, 0x236004b},
        {-65322275,  -24216670, -65266525,  -24165731, 0x236004b},
        {-58216829,  -26203870, -58160372,  -26152931, 0x236004b},
        {-65808936,  -28495470, -65751064,  -28444531, 0x236004b},
        {-64378851,  -33154170, -64318149,  -33103231, 0x236004b},
        {-67543736,  -45885970, -67470865,  -45835031, 0x236004b},
        {-60251951,  -33364470, -60191249,  -33313531, 0x236004b},
        {-66366951,  -33325070, -66306249,  -33274131, 0x236004b},
        {-58048315,  -31407370, -57988886,  -31356431, 0x236004b},
        {-66880419,  -29438470, -66821981,  -29387531, 0x236004b},
        {-68364076,  -34642970, -68302525,  -34592031, 0x236004b},
        {-71341977,  -41183870, -71274624,  -41132931, 0x236004b},
        {-65351709,  -43280570, -65282092,  -43229631, 0x236004b},
        {-65502464,  -33701470, -65441337,  -33650531, 0x236004b},
        {-59162179,  -37341570, -59098222,  -37290631, 0x236004b},
        {-64319854,  -36642070, -64256746,  -36591131, 0x236004b},
        {-68513351,  -33105970, -68452649,  -33055031, 0x236004b},
        {-63272898,  -32438770, -63212903,  -32387831, 0x236004b},
        {-59064364,  -34127270, -59003237,  -34076331, 0x236004b},
        {-60600564,  -33920170, -60539437,  -33869231, 0x236004b},
        {-69269522,  -51652270, -69187878,  -51601331, 0x236004b},
        {-59681678,  -29165370, -59623523,  -29114431, 0x236004b},
        {-60351266,  -36925170, -60287734,  -36874231, 0x236004b},
        {-58457717,  -35053770, -58395883,  -35002831, 0x236004b},
        {-58766374,  -38584470, -58701427,  -38533531, 0x236004b},
        {-67642686,  -39045470, -67577314,  -38994531, 0x236004b},
        {-61529715,  -31275470, -61470286,  -31224531, 0x236004b},
        {-58990776,  -34185470, -58929225,  -34134531, 0x236004b},
        {-60478512,  -26815470, -60421489,  -26764531, 0x236004b},
        {-63033464,  -40835470, -62966536,  -40784531, 0x236004b},
        {-62119715,  -31455470, -62060286,  -31404531, 0x236004b},
        {-58550210,  -33045470, -58489791,  -32994531, 0x236004b},
        {-60990776,  -34615470, -60929225,  -34564531, 0x236004b},
        {-59140776,  -34605470, -59079225,  -34554531, 0x236004b},
        {-65074526,  -42795470, -65005475,  -42744531, 0x236004b},
        {-64347663,  -23165470, -64292338,  -23114531, 0x236004b},
        {-68930210,  -33055470, -68869791,  -33004531, 0x236004b},
        {-62000564,  -33775470, -61939437,  -33724531, 0x236004b},
        {-59299078,  -29165470, -59240923,  -29114531, 0x236004b},
        {-58269998,  -32505470, -58210003,  -32454531, 0x236004b},
        {-68500351,  -33215470, -68439649,  -33164531, 0x236004b},
        {-59720564,  -33695470, -59659437,  -33644531, 0x236004b},
        {-54628229,  -26225470, -54571772,  -26174531, 0x236004b},
        {-62112686,  -38905470, -62047314,  -38854531, 0x236004b},
        {-63837451,  -22575470, -63782550,  -22524531, 0x236004b},
        {-69272686,  -38965470, -69207314,  -38914531, 0x236004b},
        {-64529715,  -31445470, -64470286,  -31394531, 0x236004b},
        {-55158653,  -27505470, -55101347,  -27454531, 0x236004b},
        {-63801130,  -35685470, -63738871,  -35634531, 0x236004b},
        {-60070917,  -34925470, -60009083,  -34874531, 0x236004b},
        {-59901766,  -36805470, -59838234,  -36754531, 0x236004b},
        {-64149998,  -32205470, -64090003,  -32154531, 0x236004b},
        {-59470917,  -34685470, -59409083,  -34634531, 0x236004b},
        {-60302474,  -38395470, -60237527,  -38344531, 0x236004b},
        {-64817804,  -23845470, -64762196,  -23794531, 0x236004b},
        {-60380351,  -33255470, -60319649,  -33204531, 0x236004b},
        {-58798795,  -28145470, -58741206,  -28094531, 0x236004b},
        {-64459856,  -31685470, -64400144,  -31634531, 0x236004b},
        {-64897875,  -24245470, -64842125,  -24194531, 0x236004b},
        {-62710210,  -32625470, -62649791,  -32574531, 0x236004b},
        {-60921130,  -35485470, -60858871,  -35434531, 0x236004b},
        {-60520917,  -34675470, -60459083,  -34624531, 0x236004b},
        {-59370351,  -33175470, -59309649,  -33124531, 0x236004b},
        {-58109078,  -29205470, -58050923,  -29154531, 0x236004b},
        {-65144809,  -43325470, -65075192,  -43274531, 0x236004b},
        {-57721554,  -36355470, -57658446,  -36304531, 0x236004b},
        {-61570917,  -34905470, -61509083,  -34854531, 0x236004b},
        {-60211130,  -35455470, -60148871,  -35404531, 0x236004b},
        {-60210210,  -32635470, -60149791,  -32584531, 0x236004b},
        {-68353865,  -54815470, -68266136,  -54764531, 0x236004b},
        {-60940000,  -35185355, -57780000,  -32644000, 0x0a40011},
        {-64571316,  -31719620, -64024476,  -31228580, 0x0010088},
        {-68969124,  -33258820, -68417076,  -32767780, 0x0010888},
        {-65482600,  -27086820, -64961800,  -26595780, 0x0011088},
        {-58047148,  -38302820, -57458644,  -37811780, 0x0011888},
        {-65736992,  -25133620, -65221400,  -24642580, 0x0012088},
        {-60965516,  -31802020, -60418676,  -31310980, 0x0012888},
        {-68765016,  -31798720, -68218176,  -31307680, 0x0013088},
        {-59162800,  -27723420, -58642000,  -27232380, 0x0013888},
        {-64497200,  -28040820, -63971192,  -27549780, 0x0014088},
        {-68266000,  -39126000, -67409077,  -38805000, 0x0154888},
        {-62472956,  -39045520, -61879244,  -38554480, 0x0015088},
        {-56178200,  -27627320, -55657400,  -27136280, 0x0015888},
        {-65350000,  -24550000, -64773761,  -24130000, 0x01b6088},
        {-58441192,  -26423920, -57925600,  -25932880, 0x0016888},
        {-65976907,  -28849520, -65445691,  -28358480, 0x0017088},
        {-64624524,  -33374220, -64072476,  -32883180, 0x0017888},
        {-67908504,  -46046820, -67247088,  -45555780, 0x0018088},
        {-66653023,  -33555120, -66095767,  -33064080, 0x0018888},
        {-58437716,  -31623420, -57890876,  -31132380, 0x0019088},
        {-67116808,  -29658520, -66585592,  -29167480, 0x0019888},
        {-68614532,  -34863020, -68052068,  -34371980, 0x001a088},
        {-71612972,  -41403920, -70993220,  -40912880, 0x001a888},
        {-65528488,  -43523020, -64887904,  -43031980, 0x001b088},
        {-65745324,  -33921520, -65188068,  -33430480, 0x001b888},
        {-59421848,  -37561620, -58838552,  -37070580, 0x001c088},
        {-64572140,  -36862120, -63994052,  -36371080, 0x001c888},
        {-63518924,  -32658820, -62966876,  -32167780, 0x001d088},
        {-69603676,  -51872320, -68853724,  -51381280, 0x001d888},
        {-59726908,  -29385420, -59195692,  -28894380, 0x001e088},
        {-60378540,  -37085320, -59800452,  -36594280, 0x001e888},
        {-59041248,  -38696420, -58452744,  -38205380, 0x001f088},
        {-61768216,  -31495520, -61221376,  -31004480, 0x0b00090},
        {-60710400,  -27035520, -60189600,  -26544480, 0x0b00890},
        {-63307272,  -41055520, -62692728,  -40564480, 0x0b01090},
        {-62358216,  -31675520, -61811376,  -31184480, 0x0b01890},
        {-61241232,  -34835520, -60678768,  -34344480, 0x0b12090},
        {-65357688,  -43015520, -64722312,  -42524480, 0x0b02890},
        {-64567384,  -23385520, -64062208,  -22894480, 0x0b13090},
        {-62243424,  -33995520, -61686168,  -33504480, 0x0b03890},
        {-58601324,  -32661920, -58049276,  -32170880, 0x0b04090},
        {-54852592,  -26445520, -54337000,  -25954480, 0x0b14890},
        {-64057384,  -22795520, -63552208,  -22304480, 0x0b05090},
        {-69536856,  -39185520, -68943144,  -38694480, 0x0b15890},
        {-55390400,  -27725520, -54869600,  -27234480, 0x0b16090},
        {-64056440,  -35905520, -63483560,  -35414480, 0x0b06890},
        {-64388216,  -32425520, -63841376,  -31934480, 0x0b17090},
        {-60559048,  -38615520, -59970544,  -38124480, 0x0b17890},
        {-65037384,  -24065520, -64532208,  -23574480, 0x0b18090},
        {-59027800,  -28365520, -58501792,  -27874480, 0x0b18890},
        {-62956024,  -32845520, -62403976,  -32354480, 0x0b09090},
        {-61176440,  -35705520, -60603560,  -35214480, 0x0b09890},
        {-58345608,  -29425520, -57814392,  -28934480, 0x0b1a090},
        {-57976440,  -36575520, -57403560,  -36084480, 0x0b1a890},
        {-61818632,  -35125520, -61250960,  -34634480, 0x0b0b090},
        {-60466440,  -35675520, -59893560,  -35184480, 0x0b0b890},
        {-60456024,  -32855520, -59903976,  -32364480, 0x0b0c090},
        {-68708416,  -55035520, -67901176,  -54544480, 0x0b0c890},
        {-68711936,  -24460595, -65852000,  -21779405, 0x001008d},
        {-65852000,  -24460595, -62992064,  -21779405, 0x001088d},
        {-62992064,  -24460595, -60132128,  -21779405, 0x001108d},
        {-60132128,  -24460595, -57272192,  -21779405, 0x001188d},
        {-68741727,  -27141785, -65822209,  -24460595, 0x001208d},
        {-65822209,  -27141785, -62902691,  -24460595, 0x001288d},
        {-62902691,  -27141785, -59983173,  -24460595, 0x001308d},
        {-59983173,  -27141785, -57063655,  -24460595, 0x001388d},
        {-70523228,  -29822975, -67544128,  -27141785, 0x001408d},
        {-67544128,  -29822975, -64565028,  -27141785, 0x001488d},
        {-64565028,  -29822975, -61585928,  -27141785, 0x001508d},
        {-61585928,  -29822975, -58606828,  -27141785, 0x001588d},
        {-58606828,  -29822975, -55627728,  -27141785, 0x001608d},
        {-56584309,  -28214261, -53635000,  -25533071, 0x001688d},
        {-70613495,  -32504165, -67545022,  -29822975, 0x001708d},
        {-67545022,  -32504165, -64476549,  -29822975, 0x001788d},
        {-64476549,  -32504165, -61408076,  -29822975, 0x001808d},
        {-61408076,  -32504165, -58339603,  -29822975, 0x001888d},
        {-60180687,  -32504165, -57112214,  -29822975, 0x001908d},
        {-70673077,  -35185355, -67515231,  -32504165, 0x001988d},
        {-67515231,  -35185355, -64357385,  -32504165, 0x001a08d},
        {-64357385,  -35185355, -61199539,  -32504165, 0x001a88d},
        {-61199539,  -35185355, -58041693,  -32504165, 0x001b08d},
        {-71458964,  -37866545, -68181954,  -35185355, 0x001b88d},
        {-68181954,  -37866545, -64904944,  -35185355, 0x001c08d},
        {-64904944,  -37866545, -61627934,  -35185355, 0x001c88d},
        {-61627934,  -37866545, -58350924,  -35185355, 0x001d08d},
        {-59861327,  -37383930, -56614108,  -34702740, 0x001d88d},
        {-71951856,  -40547735, -68585473,  -37866545, 0x0a90091},
        {-68585473,  -40547735, -65219090,  -37866545, 0x0a90891},
        {-65219090,  -40547735, -61852707,  -37866545, 0x0a91091},
        {-61852707,  -40547735, -58486324,  -37866545, 0x0a91891},
        {-58486324,  -40038308, -55119941,  -37357118, 0x0a82091},
        {-72243212,  -43228925, -68727874,  -40547735, 0x0a82891},
        {-68727874,  -43228925, -65212536,  -40547735, 0x0a83091},
        {-65212536,  -43228925, -61697198,  -40547735, 0x0a83891},
        {-72091873,  -45910115, -68427580,  -43228925, 0x0a84091},
        {-68427580,  -45910115, -64763287,  -43228925, 0x0a84891},
        {-72657604,  -48591305, -68844356,  -45910115, 0x0a95091},
        {-68844356,  -48591305, -65031108,  -45910115, 0x0a95891},
        {-73700289,  -51272495, -69678504,  -48591305, 0x0a86091},
        {-69678504,  -51272495, -65656719,  -48591305, 0x0a86891},
        {-72472900,  -52479030, -68361742,  -49797840, 0x0a87091},
        {-65274203,  -55116860, -60894926,  -52435670, 0x0a89091},
        {-68865210,  -55116860, -64485933,  -52435670, 0x0a88891},
        {-73730000,  -55116860, -53635000,  -21760000, 0x0010217},
        {72821000,   20367000,  72906600,   20467200,  0x022000b}, // 2DD
        {70870000,   20690000,  71007000,   20744000,  0x001000c},
        {70870000,   20367000,  72906600,   20744000,  0x0020216},
        {72926000,   20300000,  73002000,   20364000,  0x001000a}, // 2DN
        {72920000,   20051500,  73232000,   20364000,  0x001000c},
        {72920000,   20051500,  73232000,   20364000,  0x0020216},
        {76714228,   30677855,  76814172,   30764345,  0x001000a}, // 2CH
        {76670456,   30633804,  76900000,   30808396,  0x001000c},
        {76670456,   30633804,  76900000,   30808396,  0x0020216},
        {92681755,   11603107,  92769206,   11689597,  0x001000a}, // 2AN
        {92512000,   11343000,  92800000,   12135000,  0x032000c},
        {92213843,   10504821,  92687771,   10995861,  0x0b10010},
        {92120300,   11160000,  93485000,   14248000,  0x004010c},
        {92671000,   7842000,   93680000,   9296000,   0x004010c},
        {93600000,   6720000,   94000000,   7465000,   0x004010c},
        {92721605,   11139203,  92736454,   11150698,  0x004010c},
        {94221815,   13371257,  94347521,   13493566,  0x004010c},
        {93798494,   12219185,  93923521,   12341494,  0x004010c},
        {92120300,   6670000,   94356000,   14333000,  0x0020216},
        {72999358,   8253865,   73085848,   8340355,   0x001000b}, // 2LD
        {72570000,   10505000,  72845000,   11300000,  0x033000c},
        {71923843,   10766451,  72397771,   11257491,  0x0b10010},
        {71660809,   9770405,   74371790,   12451595,  0x0a80011},
        {71660809,   8253865,   74371790,   12451595,  0x0020216},
        {77170681,   28589511,  77268703,   28676001,  0x001000a}, // 2DL
        {76822831,   28395928,  77354047,   28886968,  0x001000c},
        {76822831,   28395928,  77354047,   28886968,  0x0020216},
        {91848224,   25533886,  91943363,   25620376,  0x001000a}, // 2ML
        {91543560,   25277659,  92059152,   25768699,  0x001000c},
        {91171481,   25439210,  91362719,   25612189,  0x782004b},
        {90551481,   25394310,  90742719,   25567289,  0x782004b},
        {90544461,   25163810,  90734738,   25336789,  0x782004b},
        {92128081,   25368610,  92319319,   25541589,  0x782004b},
        {90103081,   25436510,  90294319,   25609489,  0x782004b},
        {90335581,   25230210,  90526819,   25403189,  0x782004b},
        {92306081,   25318710,  92497319,   25491689,  0x782004b},
        {91812908,   25850520,  91978891,   26000279,  0x680004b},
        {89800000,   25000000,  92810000,   26200000,  0x06f0011},
        {89800000,   25000000,  92810000,   26200000,  0x0020216},
        {93676911,   25851781,  93772050,   25938271,  0x001000a}, // 2NL
        {93645834,   25549928,  94161426,   26040968,  0x001000c},
        {94535360,   26557610,  94728039,   26730589,  0x782004b},
        {94383460,   26250810,  94576139,   26423789,  0x782004b},
        {94201241,   25998610,  94392959,   26171589,  0x782004b},
        {94737441,   26158410,  94929159,   26331389,  0x782004b},
        {94473908,   25936020,  94639891,   26085779,  0x680004b},
        {94359308,   25812620,  94525291,   25962379,  0x680004b},
        {94947992,   26667620,  95114807,   26817379,  0x680004b},
        {94994576,   26830020,  95162223,   26979779,  0x680004b},
        {94593616,   25614720,  94759183,   25764479,  0x680004b},
        {93321000,   25183000,  95266000,   27052000,  0x0ad0011},
        {93321000,   25183000,  95266000,   27052000,  0x0020216},
        {93892911,   24752755,  93988050,   24839245,  0x001000a}, // 2MN
        {93684808,   24544480,  94195192,   25035520,  0x001000c},
        {94219074,   25009340,  94431725,   25202659,  0x864004b},
        {93884574,   25135640,  94097225,   25328959,  0x864004b},
        {93425374,   24850540,  93638025,   25043859,  0x864004b},
        {93688142,   24373369,  93877458,   24546348,  0x782004b},
        {93877458,   24373369,  94066774,   24546348,  0x782004b},
        {93650278,   24200390,  93839594,   24373369,  0x782004b},
        {93839594,   24200390,  94028910,   24373369,  0x782004b},
        {92955000,   23830000,  94780000,   25700000,  0x0b20011},
        {92955000,   23830000,  94780000,   25700000,  0x0020216},
        {91243711,   23791055,  91337889,   23877545,  0x001000a}, // 2TR
        {91191568,   23490272,  91696744,   23981312,  0x001000c},
        {91644972,   23319120,  91807627,   23468879,  0x680004b},
        {91909556,   23916420,  92073043,   24066179,  0x680004b},
        {91922548,   24235520,  92086451,   24385279,  0x680004b},
        {92083848,   24320620,  92247751,   24470379,  0x680004b},
        {92086848,   24176420,  92250751,   24326179,  0x680004b},
        {92098056,   23759020,  92261543,   23908779,  0x680004b},
        {91963856,   24089020,  92127343,   24238779,  0x680004b},
        {91777040,   23894390,  91910560,   24016699,  0x54f004b},
        {91765940,   24088990,  91899460,   24211299,  0x54f004b},
        {91545840,   23978290,  91679360,   24100599,  0x54f004b},
        {91634849,   22972690,  91767350,   23094999,  0x54f004b},
        {91430079,   23196290,  91562920,   23318599,  0x54f004b},
        {91130000,   22917792,  92350000,   24556297,  0x0cb0011},
        {91130000,   22917792,  92350000,   24556297,  0x0020216},
        {92670654,   23702800,  92758000,   23794500,  0x021000a}, // 2MZ
        {92467716,   23482880,  92972892,   23973920,  0x001000c},
        {92860213,   22346910,  93106786,   22575689,  0x9ee004b},
        {93120000,   23356960,  93374833,   23548000,  0x931044b},
        {92566415,   24145360,  92798184,   24357129,  0x931004b},
        {92693392,   22761160,  92922808,   22972929,  0x931004b},
        {92740698,   23203460,  92970702,   23415229,  0x931004b},
        {92178000,   21940000,  93450000,   24536000,  0x0f90011},
        {92178000,   21940000,  93450000,   24536000,  0x0020216},
        {88560950,   27287755,  88658011,   27374245,  0x001000a}, // 2SK
        {88348600,   27085480,  88869400,   27576520,  0x001000c},
        {88520000,   27572000,  88883790,   27942000,  0xf04044b},
        {88020000,   27098000,  88353481,   27474297,  0xe89044b},
        {87978000,   27070000,  88928000,   28129412,  0x0bc0011},
        {87978000,   27070000,  88928000,   28129412,  0x0020216},
        {75800028,   30866755,  75899972,   30953245,  0x001000a}, // 2PB
        {75673878,   30766630,  76006121,   31053459,  0xc730047},
        {74687883,   31489196,  75008391,   31762615,  0xbde0047},
        {75418889,   31189363,  75737878,   31462782,  0xbde0047},
        {76322602,   30268490,  76463597,   30390799,  0x54f004b},
        {74878902,   30150190,  75019897,   30272499,  0x54f004b},
        {75576673,   32205090,  75720726,   32327399,  0x54f004b},
        {75838313,   31468890,  75981686,   31591199,  0x54f004b},
        {76620463,   30648590,  76762137,   30770899,  0x54f004b},
        {75123508,   30774800,  75223691,   30861289,  0x3c1004b},
        {75152708,   31772900,  75254092,   31859389,  0x3c1004b},
        {74149049,   30098200,  74248751,   30184689,  0x3c1004b},
        {75833008,   30481400,  75933191,   30567889,  0x3c1004b},
        {76197308,   30637000,  76297491,   30723489,  0x3c1004b},
        {75729448,   31175900,  75830352,   31262389,  0x3c1004b},
        {74495408,   30444800,  74595591,   30531289,  0x3c1004b},
        {75484549,   30319700,  75584251,   30406189,  0x3c1004b},
        {75331848,   31332700,  75432752,   31419189,  0x3c1004b},
        {76538508,   30432400,  76638691,   30518889,  0x3c1004b},
        {74703308,   30631500,  74803491,   30717989,  0x3c1004b},
        {75793949,   30204400,  75893651,   30290889,  0x3c1004b},
        {75406308,   30756500,  75506491,   30842989,  0x3c1004b},
        {74774208,   30537000,  74874391,   30623489,  0x3c1004b},
        {75353249,   29964900,  75452951,   30051389,  0x3c1004b},
        {74448549,   30146400,  74548251,   30232889,  0x3c1004b},
        {75352967,   31995400,  75454832,   32081889,  0x3c1004b},
        {73980249,   30359700,  74079951,   30446189,  0x3c1004b},
        {75289248,   31052300,  75390152,   31138789,  0x3c1004b},
        {76084049,   30327500,  76183751,   30413989,  0x3c1004b},
        {74567008,   30883800,  74667191,   30970289,  0x3c1004b},
        {75273000,   32122000,  75932000,   32500000,  0x004010c},
        {73875000,   29727000,  76933000,   32122000,  0x004010c},
        {75154000,   29522000,  75402000,   29727000,  0x004018c},
        {73875000,   29522000,  76933000,   32514000,  0x0020216},
        {76977509,   28416165,  77075531,   28502655,  0x001000a}, // 2HR
        {76921600,   28080300,  77481544,   28546400,  0x01d000c},
        {76910742,   29390090,  77051057,   29512399,  0x54f004b},
        {76911082,   29267781,  77050718,   29390090,  0x54f004b},
        {76685102,   30309090,  76826097,   30431399,  0x54f004b},
        {76826097,   30309090,  76967092,   30431399,  0x54f004b},
        {77209502,   30078890,  77350497,   30201199,  0x54f004b},
        {76454722,   28831990,  76593678,   28954299,  0x54f004b},
        {76593678,   28831990,  76732634,   28954299,  0x54f004b},
        {75636282,   29085890,  75775918,   29208199,  0x54f004b},
        {75775918,   29085890,  75915554,   29208199,  0x54f004b},
        {76944289,   29646300,  77043511,   29732789,  0x3c1004b},
        {76960629,   28946800,  77059370,   29033289,  0x3c1004b},
        {76799808,   30630900,  76899991,   30717389,  0x3c1004b},
        {76090569,   28749500,  76188830,   28835989,  0x3c1004b},
        {74980389,   29486800,  75079611,   29573289,  0x3c1004b},
        {76881169,   28650600,  76979430,   28737089,  0x3c1004b},
        {76269929,   29272200,  76368670,   29358689,  0x3c1004b},
        {76799549,   29921300,  76899251,   30007789,  0x3c1004b},
        {76352589,   29758000,  76451811,   29844489,  0x3c1004b},
        {76569510,   28153300,  76667290,   28239789,  0x3c1004b},
        {75916029,   29056500,  76014770,   29142989,  0x3c1004b},
        {76058010,   28003300,  76155790,   28089789,  0x3c1004b},
        {75404189,   29469900,  75503411,   29556389,  0x3c1004b},
        {76682000,   30491000,  77210000,   30916000,  0x004010c},
        {74444000,   29214000,  75280000,   30000000,  0x004010c},
        {75280000,   27640000,  77581000,   30491000,  0x004018c},
        {74444000,   27640000,  77597000,   30931000,  0x0020216},
        {93580000,   27058000,  93706000,   27121000,  0x017000a}, // 2AR
        {93484559,   26917620,  93871841,   27263579,  0xf040047},
        {95186995,   27887700,  95565605,   28222589,  0xe890047},
        {94719744,   28094720,  94889055,   28244479,  0x680004b},
        {91833260,   27514820,  92001739,   27664579,  0x680004b},
        {95430576,   26889120,  95598223,   27038879,  0x680004b},
        {95665476,   27063820,  95833123,   27213579,  0x680004b},
        {96080044,   27849120,  96249355,   27998879,  0x680004b},
        {95767561,   28080190,  95905838,   28202499,  0x54f004b},
        {95834522,   28736490,  95973478,   28858799,  0x54f004b},
        {94968722,   28551190,  95107678,   28673499,  0x54f004b},
        {94183861,   27919790,  94322138,   28042099,  0x54f004b},
        {92377041,   27180090,  92513959,   27302399,  0x54f004b},
        {92927001,   27296390,  93064598,   27418699,  0x54f004b},
        {95540361,   28203790,  95678638,   28326099,  0x54f004b},
        {93751001,   27500690,  93888598,   27622999,  0x54f004b},
        {91555000,   26827000,  94690000,   29330000,  0x09f0011},
        {94690000,   26641000,  97416000,   29400000,  0x020000d},
        {91555000,   26641000,  97416000,   29400000,  0x0020216},
        {91716000,   26110736,  91812830,   26200576,  0x001000a}, // 2AS
        {91380108,   26038280,  91895700,   26529320,  0x001000c},
        {92735630,   24746390,  92870170,   24868699,  0x54f004b},
        {92714281,   26609690,  92850519,   26731999,  0x54f004b},
        {94870901,   27384990,  95008498,   27507299,  0x54f004b},
        {94143581,   26695090,  94279819,   26817399,  0x54f004b},
        {92616881,   26286390,  92753119,   26408699,  0x54f004b},
        {95288201,   27431390,  95425798,   27553699,  0x54f004b},
        {95262901,   27309290,  95400498,   27431599,  0x54f004b},
        {94551941,   26916490,  94688859,   27038799,  0x54f004b},
        {93697420,   25958690,  93832979,   26080999,  0x54f004b},
        {93902881,   26451290,  94039119,   26573599,  0x54f004b},
        {90464181,   26431890,  90600419,   26554199,  0x54f004b},
        {89900320,   26003190,  90035879,   26125499,  0x54f004b},
        {94052190,   27204200,  94149009,   27290689,  0x3c1004b},
        {92313531,   24830000,  92408669,   24916489,  0x3c1004b},
        {93389471,   25807600,  93485329,   25894089,  0x3c1004b},
        {93123371,   25708000,  93219229,   25794489,  0x3c1004b},
        {90551571,   26111000,  90647429,   26197489,  0x3c1004b},
        {90956430,   26278100,  91052769,   26364589,  0x3c1004b},
        {90911730,   26456900,  91008069,   26543389,  0x3c1004b},
        {89736600,   26537480,  90257400,   27028520,  0x001008c},
        {90257400,   26537480,  90778200,   27028520,  0x001088c},
        {90778200,   26537480,  91299000,   27028520,  0x001108c},
        {91299000,   26537480,  91819800,   27028520,  0x001188c},
        {91819800,   26537480,  92340600,   27028520,  0x001208c},
        {92340600,   26537480,  92861400,   27028520,  0x001288c},
        {92861400,   26537480,  93382200,   27028520,  0x001308c},
        {93382200,   26537480,  93903000,   27028520,  0x001388c},
        {93903000,   26537480,  94423800,   27028520,  0x001408c},
        {93903000,   27028520,  94423800,   27519560,  0x001488c},
        {93903000,   27478960,  94429008,   27970000,  0x001508c},
        {93376992,   27028520,  93897792,   27519560,  0x001588c},
        {93903000,   26046440,  94418592,   26537480,  0x001608c},
        {93387408,   26046440,  93903000,   26537480,  0x001688c},
        {92871816,   26046440,  93387408,   26537480,  0x001708c},
        {92356224,   26046440,  92871816,   26537480,  0x001788c},
        {91840632,   26046440,  92356224,   26537480,  0x001808c},
        {91325040,   26046440,  91840632,   26537480,  0x001888c},
        {90809448,   26046440,  91325040,   26537480,  0x001908c},
        {90293856,   26046440,  90809448,   26537480,  0x001988c},
        {89778264,   26046440,  90293856,   26537480,  0x001a08c},
        {89778264,   25555400,  90293856,   26046440,  0x001a88c},
        {90293856,   25555400,  90809448,   26046440,  0x001b08c},
        {90809448,   25555400,  91325040,   26046440,  0x001b88c},
        {91325040,   25555400,  91840632,   26046440,  0x001c08c},
        {91840632,   25555400,  92356224,   26046440,  0x001c88c},
        {92356224,   25555400,  92871816,   26046440,  0x001d08c},
        {92871816,   25555400,  93387408,   26046440,  0x001d88c},
        {93387408,   25555400,  93903000,   26046440,  0x001e08c},
        {93903000,   25555400,  94418592,   26046440,  0x001e88c},
        {93897792,   27028520,  94428608,   27519560,  0x01ef08c},
        {92098428,   25064360,  92614020,   25555400,  0x0b00890},
        {92614020,   25064360,  93129612,   25555400,  0x0b01090},
        {93129612,   25064360,  93645204,   25555400,  0x0b01890},
        {92098428,   24573320,  92608812,   25064360,  0x0b12090},
        {92608812,   24573320,  93119196,   25064360,  0x0b12890},
        {93119196,   24573320,  93629580,   25064360,  0x0b13090},
        {92098428,   24111000,  92608812,   24602040,  0x0b03890},
        {92608812,   24111000,  93119196,   24602040,  0x0b04090},
        {94428608,   27478960,  94954616,   27970000,  0x0b08890},
        {94954616,   27478960,  95480624,   27970000,  0x0b09090},
        {95480624,   27478960,  96006632,   27970000,  0x0b09890},
        {94428608,   27028440,  94949408,   27519480,  0x0b1a090},
        {94949408,   27028440,  95470208,   27519480,  0x0b1a890},
        {95470208,   27028440,  95991008,   27519480,  0x0b1b090},
        {94428608,   26537400,  94949408,   27028440,  0x0b0b890},
        {94949408,   26537400,  95470208,   27028440,  0x0b0c090},
        {94376000,   26537400,  94850000,   27028440,  0x0b9c890},
        {89666000,   24111000,  96030000,   27970000,  0x0020216},
        {85078640,   25570255,  85146498,   25631061,  0x2a7044a}, // 2BR
        {85146498,   25573000,  85228982,   25623000,  0x2a7044a},
        {84987247,   25504930,  85304352,   25791759,  0xc730047},
        {84823619,   24686290,  85124380,   24959709,  0xbde0047},
        {86835319,   25154590,  87136080,   25428009,  0xbde0047},
        {85332071,   26086800,  85427929,   26173289,  0x3c1004b},
        {87422071,   25736800,  87517929,   25823289,  0x3c1004b},
        {85851271,   26108200,  85947129,   26194689,  0x3c1004b},
        {85472191,   25166800,  85567809,   25253289,  0x3c1004b},
        {84612191,   25516800,  84707809,   25603289,  0x3c1004b},
        {86450891,   25312200,  86546509,   25398689,  0x3c1004b},
        {84672071,   25762700,  84767929,   25849189,  0x3c1004b},
        {84767929,   25719455,  84863787,   25805944,  0x3c1004b},
        {87522191,   25506800,  87617809,   25593289,  0x3c1004b},
        {86082591,   25374300,  86178209,   25460789,  0x3c1004b},
        {84457590,   26757200,  84554409,   26843689,  0x3c1004b},
        {86550071,   25841300,  86645929,   25927789,  0x3c1004b},
        {83968131,   24909900,  84063269,   24996389,  0x3c1004b},
        {84133431,   24873400,  84228569,   24959889,  0x3c1004b},
        {84863330,   26606100,  84959669,   26692589,  0x3c1004b},
        {85494131,   24845400,  85589269,   24931889,  0x3c1004b},
        {84039990,   27087700,  84136809,   27174189,  0x3c1004b},
        {83927191,   25520600,  84022809,   25607089,  0x3c1004b},
        {87899271,   26059200,  87995129,   26145689,  0x3c1004b},
        {85446130,   26550200,  85542469,   26636689,  0x3c1004b},
        {86441391,   25246500,  86537009,   25332989,  0x3c1004b},
        {84938991,   25171400,  85034609,   25257889,  0x3c1004b},
        {84327431,   24710000,  84422569,   24796489,  0x3c1004b},
        {84309871,   26178200,  84405729,   26264689,  0x3c1004b},
        {86050731,   25126000,  86145869,   25212489,  0x3c1004b},
        {86177431,   24887500,  86272569,   24973989,  0x3c1004b},
        {86013830,   26304100,  86110169,   26390589,  0x3c1004b},
        {85733771,   25815500,  85829629,   25901989,  0x3c1004b},
        {87417971,   26082400,  87513829,   26168889,  0x3c1004b},
        {85902073,   25355950,  85970727,   25418049,  0x2b2004b},
        {84408417,   26435640,  84475383,   26495759,  0x29c004b},
        {86563787,   26089750,  86632613,   26151849,  0x2b2004b},
        {84113867,   25527540,  84180332,   25587659,  0x29c004b},
        {83739600,   27032480,  84260400,   27523520,  0x001008c},
        {84260400,   27032480,  84781200,   27523520,  0x001088c},
        {83739600,   26541440,  84260400,   27032480,  0x001108c},
        {84260400,   26541440,  84781200,   27032480,  0x001188c},
        {84781200,   26541440,  85302000,   27032480,  0x001208c},
        {85302000,   26541440,  85822800,   27032480,  0x001288c},
        {85822800,   26541440,  86343600,   27032480,  0x001308c},
        {86343600,   26541440,  86864400,   27032480,  0x001388c},
        {86864400,   26541440,  87385200,   27032480,  0x001408c},
        {83744808,   26050400,  84260400,   26541440,  0x001488c},
        {84260400,   26050400,  84775992,   26541440,  0x001508c},
        {84775992,   26050400,  85291584,   26541440,  0x001588c},
        {85291584,   26050400,  85807176,   26541440,  0x001608c},
        {85807176,   26050400,  86322768,   26541440,  0x001688c},
        {86322768,   26050400,  86838360,   26541440,  0x001708c},
        {86838360,   26050400,  87353952,   26541440,  0x001788c},
        {87353952,   26050400,  87869544,   26541440,  0x001808c},
        {87817408,   26065131,  88333000,   26556171,  0x001888c},
        {83744808,   25559360,  84260400,   26050400,  0x001908c},
        {84260400,   25559360,  84775992,   26050400,  0x001988c},
        {84775992,   25559360,  85291584,   26050400,  0x001a08c},
        {85291584,   25559360,  85807176,   26050400,  0x001a88c},
        {85807176,   25559360,  86322768,   26050400,  0x001b08c},
        {86322768,   25559360,  86838360,   26050400,  0x001b88c},
        {86838360,   25559360,  87353952,   26050400,  0x001c08c},
        {87353952,   25559360,  87869544,   26050400,  0x001c88c},
        {87817408,   25559360,  88333000,   26050400,  0x001d08c},
        {87397168,   25709480,  87912760,   26200520,  0x001f08c},
        {83298000,   25068320,  83813592,   25559360,  0x0010088},
        {83744808,   25068320,  84260400,   25559360,  0x0010888},
        {84260400,   25068320,  84775992,   25559360,  0x0011088},
        {84775992,   25068320,  85291584,   25559360,  0x0011888},
        {85291584,   25068320,  85807176,   25559360,  0x0012088},
        {85807176,   25068320,  86322768,   25559360,  0x0012888},
        {86322768,   25068320,  86838360,   25559360,  0x0013088},
        {86838360,   25068320,  87353952,   25559360,  0x0013888},
        {87353952,   25068320,  87869544,   25559360,  0x0014088},
        {87817408,   25068320,  88333000,   25559360,  0x0014888},
        {83298000,   24577280,  83808384,   25068320,  0x0015088},
        {83739600,   24577280,  84249984,   25068320,  0x0015888},
        {84249984,   24577280,  84760368,   25068320,  0x0016088},
        {84760368,   24577280,  85270752,   25068320,  0x0016888},
        {85270752,   24577280,  85781136,   25068320,  0x0017088},
        {85781136,   24577280,  86291520,   25068320,  0x0017888},
        {86291520,   24577280,  86801904,   25068320,  0x0018088},
        {86801904,   24577280,  87312288,   25068320,  0x0018888},
        {83298000,   24258000,  83808384,   24749040,  0x0019088},
        {83739600,   24258000,  84249984,   24749040,  0x0019888},
        {84249984,   24258000,  84760368,   24749040,  0x001a088},
        {84760368,   24258000,  85270752,   24749040,  0x001a888},
        {85270752,   24258000,  85781136,   24749040,  0x001b088},
        {85781136,   24258000,  86291520,   24749040,  0x001b888},
        {86291520,   24258000,  86801904,   24749040,  0x001c088},
        {86801904,   24258000,  87312288,   24749040,  0x001c888},
        {83298000,   24258000,  88333000,   27533000,  0x0020216},
        {77984789,   30277355,  78083772,   30363845,  0x001000a}, // 2UT
        {77786992,   30094480,  78323416,   30585520,  0x001000c},
        {78010877,   29848310,  78209322,   30021289,  0x782004b},
        {77809577,   29781410,  78008022,   29954389,  0x782004b},
        {79420258,   29104510,  79617742,   29277489,  0x782004b},
        {79336358,   28883110,  79533842,   29056089,  0x782004b},
        {78911712,   29136120,  79082687,   29285879,  0x680004b},
        {78163880,   29989420,  78336519,   30139179,  0x680004b},
        {80132296,   29484920,  80304103,   29634679,  0x680004b},
        {79046212,   29337920,  79217187,   29487679,  0x680004b},
        {78743212,   29167720,  78914187,   29317479,  0x680004b},
        {77547000,   29486000,  80425000,   31461000,  0x004010c},
        {80425000,   29780000,  81063000,   30520000,  0x004010c},
        {78717000,   28680000,  80330000,   29486000,  0x004010c},
        {77547000,   28680000,  81063000,   31461000,  0x0020216},
        {73760576,   15347514,  73870000,   15416139,  0x018000a}, // 2GA
        {73679000,   15418000,  74290000,   15801000,  0x018000c},
        {73870000,   14894000,  74344100,   15418000,  0x0b80010},
        {73625000,   14894000,  74344100,   15801000,  0x0020216},
        {76906794,   8462827,   76995206,   8550278,   0x001000a}, // 2KL
        {76775579,   8359520,   77124421,   8705479,   0xf040047},
        {76185030,   9825700,   76524570,   10160589,  0xe890047},
        {75750461,   11163340,  75947539,   11356659,  0x864004b},
        {76513566,   8832040,   76709033,   9025359,   0x864004b},
        {76111729,   10404040,  76308270,   10597359,  0x864004b},
        {76284800,   9453400,   76393295,   9732800,   0x782044b},
        {76600669,   10661710,  76776531,   10834689,  0x782004b},
        {75299029,   11780410,  75475371,   11953389,  0x782004b},
        {76456409,   9518110,   76631790,   9691089,   0x782004b},
        {74859000,   12300960,  75338136,   12792000,  0x001088c},
        {74907793,   12004083,  75381721,   12495123,  0x001108c},
        {75381721,   12004083,  75855649,   12495123,  0x001188c},
        {75049971,   11513043,  75523899,   12004083,  0x001208c},
        {75523899,   11513043,  75997827,   12004083,  0x001288c},
        {75997827,   11513043,  76471755,   12004083,  0x001308c},
        {75523899,   11022003,  75997827,   11513043,  0x001388c},
        {75997827,   11022003,  76471755,   11513043,  0x001408c},
        {76471755,   11022003,  76945683,   11513043,  0x001488c},
        {75523899,   10530963,  75997827,   11022003,  0x001508c},
        {75997827,   10530963,  76471755,   11022003,  0x001588c},
        {76471755,   10530963,  76945683,   11022003,  0x001608c},
        {75978870,   10039923,  76452798,   10530963,  0x001688c},
        {76452798,   10039923,  76926726,   10530963,  0x001708c},
        {76926072,   10039923,  77400000,   10530963,  0x001788c},
        {75978870,   9548883,   76452798,   10039923,  0x001808c},
        {76452798,   9548883,   76926726,   10039923,  0x001888c},
        {76926072,   9548883,   77400000,   10039923,  0x001908c},
        {75978870,   9057843,   76452798,   9548883,   0x001988c},
        {76452798,   9057843,   76926726,   9548883,   0x001a08c},
        {76926072,   9057843,   77400000,   9548883,   0x001a88c},
        {76452798,   8566803,   76926726,   9057843,   0x001b08c},
        {76926072,   8566803,   77400000,   9057843,   0x001b88c},
        {76452798,   8287000,   76921518,   8778040,   0x001c08c},
        {76921518,   8287000,   77390238,   8778040,   0x001c88c},
        {74859000,   8287000,   77400000,   12792000,  0x0020216},
        {80203494,   13002655,  80291906,   13089145,  0x001000a}, // 2TN
        {79864632,   12789080,  80343768,   13280120,  0x001000c},
        {78052496,   9865490,   78176503,   9987799,   0x54f004b},
        {78645326,   10749090,  78769673,   10871399,  0x54f004b},
        {78091456,   11596690,  78216143,   11718999,  0x54f004b},
        {77660566,   8665090,   77784234,   8787399,   0x54f004b},
        {77275156,   11047190,  77399843,   11169499,  0x54f004b},
        {79724756,   11868590,  79849443,   11990899,  0x54f004b},
        {78051766,   8753290,   78175434,   8875599,   0x54f004b},
        {79075926,   10706590,  79200273,   10828899,  0x54f004b},
        {77392000,   8138900,   77481297,   8223289,   0x3c1044b},
        {77934835,   10316800,  78022765,   10403289,  0x3c1044b},
        {79104700,   12882000,  79188462,   12973400,  0x3c1044b},
        {78755000,   10046300,  78858485,   10119650,  0x3c1044b},
        {77753100,   9419562,   77845737,   9501160,   0x3c1044b},
        {78026800,   10920600,  78125710,   10997416,  0x3c1044b},
        {76872035,   11010000,  76959965,   11096489,  0x3c1004b},
        {76959965,   11010000,  77047895,   11096489,  0x3c1004b},
        {76959965,   10923511,  77047895,   11010000,  0x3c1004b},
        {76872035,   10923511,  76959965,   11010000,  0x3c1004b},
        {79710315,   11708200,  79798485,   11794689,  0x3c1004b},
        {79655674,   12796800,  79744325,   12883289,  0x3c1004b},
        {77677115,   11306800,  77765285,   11393289,  0x3c1004b},
        {79336035,   10918200,  79423965,   11004689,  0x3c1004b},
        {79026394,   12190700,  79114805,   12277189,  0x3c1004b},
        {79933000,   12985017,  80356168,   13500000,  0x021088c},
        {79390000,   12985017,  79933000,   13360000,  0x019108c},
        {78600000,   12985017,  79390000,   13200000,  0x00f188c},
        {77481351,   12493977,  77960487,   12985017,  0x001208c},
        {77960486,   12493977,  78439622,   12985017,  0x001288c},
        {78439622,   12493977,  78918758,   12985017,  0x001308c},
        {78918758,   12493977,  79397894,   12985017,  0x001388c},
        {79397894,   12493977,  79877030,   12985017,  0x001408c},
        {79877030,   12493977,  80356166,   12985017,  0x001488c},
        {79762455,   12002937,  80236383,   12493977,  0x001508c},
        {79288527,   12002937,  79762455,   12493977,  0x001588c},
        {78814599,   12002937,  79288527,   12493977,  0x001608c},
        {78340671,   12002937,  78814599,   12493977,  0x001688c},
        {77866743,   12002937,  78340671,   12493977,  0x001708c},
        {77392815,   12002937,  77866743,   12493977,  0x001788c},
        {79478098,   11511897,  79952026,   12002937,  0x001808c},
        {79004170,   11511897,  79478098,   12002937,  0x001888c},
        {78530242,   11511897,  79004170,   12002937,  0x001908c},
        {78056314,   11511897,  78530242,   12002937,  0x001988c},
        {77582386,   11511897,  78056314,   12002937,  0x001a08c},
        {77108458,   11511897,  77582386,   12002937,  0x001a88c},
        {76634530,   11511897,  77108458,   12002937,  0x001b08c},
        {76228000,   11511897,  76701928,   12002937,  0x001b88c},
        {76228000,   11020857,  76701928,   11511897,  0x001c08c},
        {76634530,   11020857,  77108458,   11511897,  0x001c88c},
        {77108458,   11020857,  77582386,   11511897,  0x001d08c},
        {77582386,   11020857,  78056314,   11511897,  0x001d88c},
        {78056314,   11020857,  78530242,   11511897,  0x001e08c},
        {78530242,   11020857,  79004170,   11511897,  0x001e88c},
        {79004170,   11020857,  79478098,   11511897,  0x001f08c},
        {79478098,   11020857,  79952026,   11511897,  0x0b10090},
        {79478098,   10529817,  79952026,   11020857,  0x0b10890},
        {79004170,   10529817,  79478098,   11020857,  0x0b11090},
        {78530242,   10529817,  79004170,   11020857,  0x0b11890},
        {78056314,   10529817,  78530242,   11020857,  0x0b12090},
        {77582386,   10529817,  78056314,   11020857,  0x0b12890},
        {77108458,   10529817,  77582386,   11020857,  0x0b13090},
        {76634530,   10529817,  77108458,   11020857,  0x0b13890},
        {76634530,   10038777,  77108458,   10529817,  0x0b14090},
        {77108458,   10038777,  77582386,   10529817,  0x0b14890},
        {77582386,   10038777,  78056314,   10529817,  0x0b15090},
        {78056314,   10038777,  78530242,   10529817,  0x0b15890},
        {78530242,   10038777,  79004170,   10529817,  0x0b16090},
        {79004170,   10038777,  79478098,   10529817,  0x0b16890},
        {79478098,   10038777,  79952026,   10529817,  0x0b17090},
        {79004170,   9547737,   79478098,   10038777,  0x0b07890},
        {78530242,   9547737,   79004170,   10038777,  0x0b08090},
        {78056314,   9547737,   78530242,   10038777,  0x0b08890},
        {77582386,   9547737,   78056314,   10038777,  0x0b09090},
        {77108458,   9547737,   77582386,   10038777,  0x0b09890},
        {77108458,   9056697,   77582386,   9547737,   0x0b0a090},
        {77582386,   9056697,   78056314,   9547737,   0x0b0a890},
        {78056314,   9056697,   78530242,   9547737,   0x0b0b090},
        {78530242,   9056697,   79004170,   9547737,   0x0b0b890},
        {79004170,   9056697,   79478098,   9547737,   0x0b0c090},
        {77937832,   8565657,   78411760,   9056697,   0x0b0c890},
        {77463904,   8565657,   77937832,   9056697,   0x0b0d090},
        {76989976,   8565657,   77463904,   9056697,   0x0b0d890},
        {76989976,   8074617,   77458696,   8565657,   0x0b1e090},
        {77458696,   8074617,   77927416,   8565657,   0x0b1e890},
        {77927416,   8074617,   78396136,   8565657,   0x0b1f090},
        {76200000,   8000000,   80700000,   13555000,  0x0020216},
        {77132028,   31046055,  77232933,   31132545,  0x001000a}, // 2HP
        {76911084,   30806980,  77452716,   31298020,  0x001000c},
        {76199074,   32068110,  76468525,   32296889,  0x9ee004b},
        {76848880,   31622160,  77097120,   31833929,  0x931004b},
        {77171350,   30454160,  77416649,   30665929,  0x931004b},
        {76807268,   31408860,  77054332,   31620629,  0x931004b},
        {76009291,   32437160,  76258708,   32648929,  0x931004b},
        {75576000,   31100000,  78023000,   33238000,  0x004010c},
        {78023000,   31100000,  79020000,   32771000,  0x004010c},
        {76577000,   30378000,  77904000,   31100000,  0x004010c},
        {75576000,   30378000,  79020000,   33238000,  0x0020216},
        {74755106,   34040755,  74858894,   34127245,  0x001000a}, // 2JK
        {74599424,   33911020,  75014575,   34256979,  0xf040047},
        {74669392,   32547600,  75066607,   32882489,  0xe890047},
        {75057644,   33656120,  75237355,   33805879,  0x680004b},
        {74256720,   34139120,  74437679,   34288879,  0x680004b},
        {75053984,   32837120,  75231615,   32986879,  0x680004b},
        {75438808,   32308120,  75615191,   32457879,  0x680004b},
        {74235856,   35866720,  74420143,   36016479,  0x680004b},
        {75490480,   35232420,  75673519,   35382179,  0x680004b},
        {73685000,   33087490,  73917302,   33202500,  0x680044b},
        {73380520,   34289520,  73561479,   34439279,  0x680004b},
        {74229768,   33296120,  74408231,   33445879,  0x680004b},
        {75473424,   33084390,  75619175,   33206699,  0x54f004b},
        {75690324,   33258690,  75836075,   33380999,  0x54f004b},
        {73290000,   34947842,  78225000,   36590000,  0x013000d},
        {73392645,   32266652,  76550491,   34947842,  0x0a80011},
        {76550491,   32266652,  79708337,   34947842,  0x0010015},
        {72500000,   32263000,  80430000,   37088000,  0x0020216},
        {81591872,   21202755,  81684128,   21289245,  0x001000a}, // 2CT
        {81178000,   21014681,  81839248,   21379000,  0x017000c},
        {82623196,   22310620,  82784603,   22460379,  0x680004b},
        {82069004,   21998320,  82229995,   22148079,  0x680004b},
        {80959712,   21025120,  81120287,   21174879,  0x680004b},
        {83315504,   21820120,  83476495,   21969879,  0x680004b},
        {81947960,   19008120,  82106039,   19157879,  0x680004b},
        {83091380,   23057820,  83253619,   23207579,  0x680004b},
        {81490628,   20645020,  81650371,   20794779,  0x680004b},
        {82290572,   23100920,  82453227,   23250679,  0x680004b},
        {81011428,   20506320,  81171171,   20656079,  0x680004b},
        {81881259,   21675890,  82012741,   21798199,  0x54f004b},
        {82006129,   21064690,  82137271,   21186999,  0x54f004b},
        {80920000,   22200000,  84453000,   24147000,  0x017000d},
        {80374000,   19950000,  83673000,   22200000,  0x08f0011},
        {80238000,   17730000,  82810000,   20500000,  0x3fc0015},
        {80238000,   17730000,  84453000,   24147000,  0x0020216},
        {85281172,   23316455,  85374389,   23402945,  0x001000a}, // 2JH
        {86052300,   23608400,  86537261,   23877700,  0xf040447},
        {85145037,   23192300,  85508763,   23527189,  0xe890047},
        {86133849,   22732090,  86266350,   22854399,  0x54f004b},
        {86618170,   24427290,  86752030,   24549599,  0x54f004b},
        {85304640,   23909790,  85438160,   24032099,  0x54f004b},
        {86237370,   24122690,  86371230,   24244999,  0x54f004b},
        {85270540,   23598490,  85404060,   23720799,  0x54f004b},
        {85404060,   23604605,  85537580,   23726914,  0x54f004b},
        {84003940,   23981790,  84137460,   24104099,  0x54f004b},
        {86749540,   23676090,  86883060,   23798399,  0x54f004b},
        {87577790,   25178890,  87713009,   25301199,  0x54f004b},
        {85475070,   24369990,  85608930,   24492299,  0x54f004b},
        {85739789,   22482790,  85871611,   22605099,  0x54f004b},
        {86579370,   24206190,  86713230,   24328499,  0x54f004b},
        {87182970,   24226590,  87316830,   24348899,  0x54f004b},
        {84477349,   22982390,  84609850,   23104699,  0x54f004b},
        {85558149,   22613490,  85690650,   22735799,  0x54f004b},
        {87160031,   24771200,  87255169,   24857689,  0x3c1004b},
        {86965307,   24846960,  87480899,   25338000,  0x001008c},
        {87451408,   24846960,  87967000,   25338000,  0x001088c},
        {83356163,   24355920,  83866547,   24846960,  0x001108c},
        {83866547,   24355920,  84376931,   24846960,  0x001188c},
        {84376931,   24355920,  84887315,   24846960,  0x001208c},
        {84887315,   24355920,  85397699,   24846960,  0x001288c},
        {85397699,   24355920,  85908083,   24846960,  0x001308c},
        {85908083,   24355920,  86418467,   24846960,  0x001388c},
        {86418467,   24355920,  86928851,   24846960,  0x001408c},
        {86928851,   24355920,  87439235,   24846960,  0x001488c},
        {87439235,   24355920,  87949619,   24846960,  0x001508c},
        {83305124,   23864880,  83815508,   24355920,  0x001588c},
        {83815508,   23864880,  84325892,   24355920,  0x001608c},
        {84325892,   23864880,  84836276,   24355920,  0x001688c},
        {84836276,   23864880,  85346660,   24355920,  0x001708c},
        {85346660,   23864880,  85857044,   24355920,  0x001788c},
        {85857044,   23864880,  86367428,   24355920,  0x001808c},
        {86367428,   23864880,  86877812,   24355920,  0x001888c},
        {86877812,   23864880,  87388196,   24355920,  0x001908c},
        {87388196,   23864880,  87898580,   24355920,  0x001988c},
        {83565524,   23373840,  84070700,   23864880,  0x001a08c},
        {84070700,   23373840,  84575876,   23864880,  0x001a88c},
        {84575876,   23373840,  85081052,   23864880,  0x001b08c},
        {85081052,   23373840,  85586228,   23864880,  0x001b88c},
        {85586228,   23373840,  86091404,   23864880,  0x001c08c},
        {86091404,   23373840,  86596580,   23864880,  0x001c88c},
        {86596580,   23640000,  87300000,   23864880,  0x011d08c},
        {84030287,   22882800,  84535463,   23373840,  0x001d88c},
        {84535463,   22882800,  85040639,   23373840,  0x001e08c},
        {85040639,   22882800,  85545815,   23373840,  0x001e88c},
        {85545815,   22882800,  86050991,   23373840,  0x001f08c},
        {86050991,   22882800,  86556167,   23373840,  0x0010088},
        {83878734,   22391760,  84383910,   22882800,  0x0010888},
        {84383910,   22391760,  84889086,   22882800,  0x0011088},
        {84889086,   22391760,  85394262,   22882800,  0x0011888},
        {85394262,   22391760,  85899438,   22882800,  0x0012088},
        {85899438,   22391760,  86404614,   22882800,  0x0012888},
        {86404614,   22391760,  86909790,   22882800,  0x0013088},
        {83929251,   21940000,  84429219,   22431040,  0x0013888},
        {84429219,   21940000,  84929187,   22431040,  0x0014088},
        {84929187,   21940000,  85429155,   22431040,  0x0014888},
        {85429155,   21940000,  85929123,   22431040,  0x0015088},
        {85929123,   21940000,  86429091,   22431040,  0x0015888},
        {86429091,   21940000,  86929059,   22431040,  0x0016088},
        {83302000,   21940000,  87967000,   25338000,  0x0020216},
        {77549894,   12928155,  77638306,   13014645,  0x001000a}, // 2KA
        {77354532,   12725880,  77833668,   13216920,  0x001000c},
        {75066637,   15298890,  75193362,   15421199,  0x54f004b},
        {76587486,   12248890,  76712513,   12371199,  0x54f004b},
        {76769527,   17272990,  76897272,   17395299,  0x54f004b},
        {74449167,   15798890,  74576232,   15921199,  0x54f004b},
        {74795917,   12840090,  74921283,   12962399,  0x54f004b},
        {75880734,   14412900,  75969865,   14499389,  0x3c1004b},
        {76878914,   15093500,  76968286,   15179989,  0x3c1004b},
        {75673833,   16786800,  75764166,   16873289,  0x3c1004b},
        {75525554,   13886800,  75614445,   13973289,  0x3c1004b},
        {77064454,   13305400,  77153345,   13391889,  0x3c1004b},
        {77305074,   16166800,  77394926,   16253289,  0x3c1004b},
        {77457293,   17868900,  77548106,   17955389,  0x3c1004b},
        {76325194,   15236800,  76414806,   15323289,  0x3c1004b},
        {75645554,   13796800,  75734445,   13883289,  0x3c1004b},
        {78235674,   12926800,  78324325,   13013289,  0x3c1004b},
        {76358934,   14183400,  76448065,   14269889,  0x3c1004b},
        {78086274,   13093800,  78174925,   13180289,  0x3c1004b},
        {76854194,   12480000,  76942605,   12566489,  0x3c1004b},
        {76055574,   12966900,  76144225,   13053389,  0x3c1004b},
        {75619074,   16116800,  75708926,   16203289,  0x3c1004b},
        {74706554,   13291800,  74795445,   13378289,  0x3c1004b},
        {75737554,   13281800,  75826445,   13368289,  0x3c1004b},
        {75587434,   14572800,  75676565,   14659289,  0x3c1004b},
        {76486194,   15388800,  76575806,   15475289,  0x3c1004b},
        {75590194,   15385500,  75679806,   15471989,  0x3c1004b},
        {77497354,   13258700,  77586245,   13345189,  0x3c1004b},
        {74710000,   16100000,  77700000,   18447000,  0x01b000d},
        {74524000,   12170000,  78589000,   13975000,  0x0710011},
        {74094000,   13975000,  77520000,   16100000,  0x2ff0015},
        {74040000,   11580000,  78600000,   18447000,  0x0020216},
        {75757350,   26864355,  75853450,   26950845,  0x001000a}, // 2RJ
        {75644855,   26749930,  75965944,   27036759,  0xc730047},
        {72864780,   26161890,  73167819,   26435309,  0xbde0047},
        {75685619,   25092790,  75986380,   25366209,  0xbde0047},
        {73266061,   27963390,  73404338,   28085699,  0x54f004b},
        {74547781,   26396790,  74684019,   26519099,  0x54f004b},
        {73642670,   24522290,  73776530,   24644599,  0x54f004b},
        {74552790,   25280290,  74688009,   25402599,  0x54f004b},
        {76580550,   27521100,  76677850,   27607589,  0x3c1004b},
        {77446790,   27178300,  77543609,   27264789,  0x3c1004b},
        {75094750,   27565700,  75192050,   27652189,  0x3c1004b},
        {73273971,   25738200,  73369829,   25824689,  0x3c1004b},
        {73839389,   29859500,  73938611,   29945989,  0x3c1004b},
        {75732071,   26126800,  75827929,   26213289,  0x3c1004b},
        {74803330,   26545000,  74899669,   26631489,  0x3c1004b},
        {74260489,   29558000,  74359711,   29644489,  0x3c1004b},
        {74297371,   26067200,  74393229,   26153689,  0x3c1004b},
        {77830930,   26665500,  77927269,   26751989,  0x3c1004b},
        {76314471,   25969800,  76410329,   26056289,  0x3c1004b},
        {74918010,   28258000,  75015790,   28344489,  0x3c1004b},
        {75343410,   28075400,  75441190,   28161889,  0x3c1004b},
        {74580831,   24848300,  74675969,   24934789,  0x3c1004b},
        {76667730,   26441300,  76764069,   26527789,  0x3c1004b},
        {76463231,   25053300,  76558369,   25139789,  0x3c1004b},
        {76805910,   28167400,  76903690,   28253889,  0x3c1004b},
        {75597891,   25387000,  75693509,   25473489,  0x3c1004b},
        {74421650,   27656000,  74518950,   27742489,  0x3c1004b},
        {74386932,   23504200,  74480868,   23590689,  0x3c1004b},
        {74666000,   26964500,  74755465,   27058000,  0x3c1044b},
        {73690990,   27155600,  73787809,   27242089,  0x3c1004b},
        {76981930,   26699500,  77078269,   26785989,  0x3c1004b},
        {74183648,   23054298,  77073375,   25735488,  0x001000d},
        {74150282,   25735488,  77099591,   28416678,  0x0a90011},
        {73077399,   27779024,  73603407,   28270064,  0x0b00090},
        {73454403,   24337924,  73964787,   24828964,  0x0b10890},
        {77234795,   26976024,  77755595,   27467064,  0x0b11090},
        {73069317,   25535924,  73584909,   26026964,  0x0b11890},
        {73836541,   29506474,  74372965,   29997514,  0x0b02090},
        {77618695,   26463224,  78139495,   26954264,  0x0b02890},
        {73478995,   26953324,  73999795,   27444364,  0x0b13090},
        {69400000,   22890000,  78320000,   30200000,  0x0020216},
        {85789733,   20238455,  85881028,   20324945,  0x001000a}, // 2OR
        {85545748,   20120000,  85970000,   20680000,  0x023000c},
        {84720960,   19245120,  84879039,   19394879,  0x680004b},
        {84761596,   22165120,  84923003,   22314879,  0x680004b},
        {85750544,   19780020,  85909455,   19929779,  0x680004b},
        {83861029,   21430990,  83992171,   21553299,  0x54f004b},
        {86865329,   21432690,  86996471,   21554999,  0x54f004b},
        {86669959,   21873390,  86801441,   21995699,  0x54f004b},
        {83446168,   20648290,  83576631,   20770599,  0x54f004b},
        {83834759,   21757890,  83966241,   21880199,  0x54f004b},
        {86575738,   20227290,  86705861,   20349599,  0x54f004b},
        {83554729,   21289790,  83685871,   21412099,  0x54f004b},
        {83099708,   19869490,  83229491,   19991799,  0x54f004b},
        {83338448,   19147490,  83467552,   19269799,  0x54f004b},
        {86438459,   21000564,  86569601,   21122873,  0x54f044b},
        {85051450,   20781499,  85205433,   20885000,  0x54f044b},
        {84621330,   19612019,  87451475,   22293209,  0x001000d},
        {81791185,   19612019,  84621330,   22293209,  0x0a90011},
        {81507000,   17800000,  85463000,   19612019,  0x2990015},
        {81376000,   17800000,  87533000,   22576000,  0x0020216},
        {72541672,   22977255,  72634889,   23063745,  0x001000a}, // 2GJ
        {72416334,   22892330,  72727065,   23179159,  0xc730047},
        {72690117,   21078190,  72983283,   21351609,  0xbde0047},
        {73032657,   22173290,  73327342,   22446709,  0xbde0047},
        {70746792,   22240600,  70840008,   22327089,  0x3c1004b},
        {72083512,   21712200,  72176487,   21798689,  0x3c1004b},
        {70023392,   22405500,  70101961,   22508000,  0x3c1044b},
        {70409700,   21462800,  70478021,   21580000,  0x3c1044b},
        {70058152,   23019800,  70151848,   23106289,  0x3c1004b},
        {72891872,   20901200,  72984127,   20987689,  0x3c1004b},
        {72810952,   22644100,  72904648,   22730589,  0x3c1004b},
        {72601532,   23184400,  72695468,   23270889,  0x3c1004b},
        {72328532,   23552400,  72422468,   23638889,  0x3c1004b},
        {72899292,   22522100,  72992508,   22608589,  0x3c1004b},
        {69570112,   21601000,  69663087,   21687489,  0x3c1004b},
        {70789152,   22775800,  70882848,   22862289,  0x3c1004b},
        {71599752,   22666800,  71693448,   22753289,  0x3c1004b},
        {72952312,   21675400,  73045287,   21761889,  0x3c1004b},
        {72878993,   20325800,  72971007,   20412289,  0x3c1004b},
        {70331872,   20870800,  70424127,   20957289,  0x3c1004b},
        {69623332,   23202600,  69717268,   23289089,  0x3c1004b},
        {72886472,   20565000,  72978727,   20651489,  0x3c1004b},
        {73572152,   22732800,  73665848,   22819289,  0x3c1004b},
        {71620392,   22126800,  71713608,   22213289,  0x3c1004b},
        {72380671,   24128800,  72475328,   24215289,  0x3c1004b},
        {72080291,   23804900,  72174708,   23891389,  0x3c1004b},
        {70565712,   21717100,  70658687,   21803589,  0x3c1004b},
        {70744212,   21918800,  70837187,   22005289,  0x3c1004b},
        {72963812,   21587900,  73056787,   21674389,  0x3c1004b},
        {71184922,   21571950,  71251678,   21634049,  0x2b2004b},
        {72150701,   24226140,  72216498,   24286259,  0x29c004b},
        {70415422,   21702150,  70482178,   21764249,  0x2b2004b},
        {74222335,   22807540,  74287464,   22867659,  0x29c004b},
        {73428063,   22578150,  73495337,   22640249,  0x2b2004b},
        {72595702,   22295240,  72660497,   22355359,  0x29c004b},
        {71730508,   21057150,  71797092,   21119249,  0x2b2004b},
        {71276769,   21308840,  71341230,   21368959,  0x29c004b},
        {72507204,   23677850,  72574995,   23739949,  0x2b2004b},
        {71434735,   22962240,  71499864,   23022359,  0x29c004b},
        {69990877,   23080850,  70058323,   23142949,  0x2b2004b},
        {70219669,   21270340,  70284130,   21330459,  0x29c004b},
        {68100000,   22728000,  71794000,   24750000,  0x017000d},
        {71785408,   24258960,  72295792,   24750000,  0x001008c},
        {72295792,   24258960,  72806176,   24750000,  0x001088c},
        {72806175,   24258960,  73316559,   24750000,  0x001108c},
        {71785408,   23846880,  72295792,   24337920,  0x001188c},
        {72295792,   23846880,  72806176,   24337920,  0x001208c},
        {72806175,   23846880,  73316559,   24337920,  0x001288c},
        {71790615,   23355840,  72295791,   23846880,  0x001308c},
        {72295791,   23355840,  72800967,   23846880,  0x001388c},
        {72800967,   23355840,  73306143,   23846880,  0x001408c},
        {73306143,   23355840,  73811319,   23846880,  0x001488c},
        {73811319,   23355840,  74316495,   23846880,  0x001508c},
        {71790615,   22864800,  72295791,   23355840,  0x001588c},
        {72295791,   22864800,  72800967,   23355840,  0x001608c},
        {72800967,   22864800,  73306143,   23355840,  0x001688c},
        {73306143,   22864800,  73811319,   23355840,  0x001708c},
        {73811319,   22864800,  74316495,   23355840,  0x001788c},
        {74024824,   22864800,  74530000,   23355840,  0x001808c},
        {69264736,   22373760,  69769912,   22864800,  0x001888c},
        {69769912,   22373760,  70275088,   22864800,  0x001908c},
        {70275088,   22373760,  70780264,   22864800,  0x001988c},
        {70780264,   22373760,  71285440,   22864800,  0x001a08c},
        {71285440,   22373760,  71790616,   22864800,  0x001a88c},
        {71790616,   22373760,  72295792,   22864800,  0x001b08c},
        {72295792,   22373760,  72800968,   22864800,  0x001b88c},
        {72800968,   22373760,  73306144,   22864800,  0x001c08c},
        {73306144,   22373760,  73811320,   22864800,  0x001c88c},
        {73811320,   22373760,  74316496,   22864800,  0x001d08c},
        {74024824,   22373760,  74530000,   22864800,  0x001d88c},
        {69264735,   21882720,  69764703,   22373760,  0x001e08c},
        {69764703,   21882720,  70264671,   22373760,  0x001e88c},
        {70264671,   21882720,  70764639,   22373760,  0x001f08c},
        {70764639,   21882720,  71264607,   22373760,  0x0b10090},
        {71264607,   21882720,  71764575,   22373760,  0x0b10890},
        {71764575,   21882720,  72264543,   22373760,  0x0b11090},
        {72264543,   21882720,  72764511,   22373760,  0x0b11890},
        {72764511,   21882720,  73264479,   22373760,  0x0b12090},
        {73264479,   21882720,  73764447,   22373760,  0x0b12890},
        {73764447,   21882720,  74264415,   22373760,  0x0b13090},
        {69289734,   21391680,  69789702,   21882720,  0x0b13890},
        {69789702,   21391680,  70289670,   21882720,  0x0b14090},
        {70289670,   21391680,  70789638,   21882720,  0x0b14890},
        {70789638,   21391680,  71289606,   21882720,  0x0b15090},
        {71289606,   21391680,  71789574,   21882720,  0x0b15890},
        {71789574,   21391680,  72289542,   21882720,  0x0b16090},
        {72289542,   21391680,  72789510,   21882720,  0x0b16890},
        {72789510,   21391680,  73289478,   21882720,  0x0b17090},
        {73289478,   21391680,  73789446,   21882720,  0x0b17890},
        {73789446,   21391680,  74289414,   21882720,  0x0b18090},
        {69699708,   20900640,  70199676,   21391680,  0x0b08890},
        {70199676,   20900640,  70699644,   21391680,  0x0b09090},
        {70699644,   20900640,  71199612,   21391680,  0x0b09890},
        {71199612,   20900640,  71699580,   21391680,  0x0b0a090},
        {71699580,   20900640,  72199548,   21391680,  0x0b0a890},
        {72579523,   20900640,  73079491,   21391680,  0x0b0b090},
        {73079491,   20900640,  73579459,   21391680,  0x0b0b890},
        {73579459,   20900640,  74079427,   21391680,  0x0b0c090},
        {72784719,   20409600,  73279479,   20900640,  0x0b1c890},
        {73279479,   20409600,  73774239,   20900640,  0x0b1d090},
        {73774239,   20409600,  74268999,   20900640,  0x0b1d890},
        {72730000,   20050000,  73375000,   20409600,  0x084e890},
        {68929000,   21900000,  69266000,   22481000,  0x0ebe090},
        {70368000,   20688000,  71495000,   20900640,  0x04df090},
        {68100000,   20000000,  74530000,   24750000,  0x0020216},
        {88301972,   22524755,  88395189,   22611245,  0x001000a}, // 2WB
        {88185689,   22334410,  88544200,   23006000,  0x02b000c},
        {87247979,   23480990,  87380820,   23603299,  0x54f004b},
        {86902540,   23623090,  87036060,   23745399,  0x54f004b},
        {88352481,   26652290,  88488719,   26774599,  0x54f004b},
        {87807179,   23191590,  87940020,   23313899,  0x54f004b},
        {86772940,   23672690,  86906460,   23794999,  0x54f004b},
        {88012800,   22456500,  88186041,   22503000,  0x3c1044b},
        {86318789,   23286289,  86412725,   23372778,  0x3c1004b},
        {88097131,   24966100,  88192269,   25052589,  0x3c1004b},
        {87256892,   22296800,  87350108,   22383289,  0x3c1004b},
        {87275392,   22382300,  87368608,   22468789,  0x3c1004b},
        {88202191,   24056800,  88296608,   24143289,  0x3c1004b},
        {88072191,   25576800,  88167809,   25663289,  0x3c1004b},
        {88453632,   23366800,  88547568,   23453289,  0x3c1004b},
        {88722191,   25186800,  88817809,   25273289,  0x3c1004b},
        {88592652,   22798400,  88686348,   22884889,  0x3c1004b},
        {87019032,   23192800,  87112968,   23279289,  0x3c1004b},
        {87032391,   23660300,  87126808,   23746789,  0x3c1004b},
        {87068132,   23575500,  87162068,   23661989,  0x3c1004b},
        {88815052,   22612200,  88908748,   22698689,  0x3c1004b},
        {88322232,   23365700,  88416168,   23452189,  0x3c1004b},
        {88211790,   26992100,  88308609,   27078589,  0x3c1004b},
        {88252791,   23646400,  88347208,   23732889,  0x3c1004b},
        {88783552,   22997900,  88877248,   23084389,  0x3c1004b},
        {88657730,   26485000,  88754069,   26571489,  0x3c1004b},
        {88034500,   22015900,  88151856,   22084300,  0x3c1044b},
        {88337032,   23198200,  88453451,   23267900,  0x3c1044b},
        {87845040,   26748104,  88365840,   27239144,  0x001008c},
        {88365840,   26748104,  88886640,   27239144,  0x001088c},
        {88886640,   26748104,  89407440,   27239144,  0x001108c},
        {89379200,   26748104,  89900000,   27239144,  0x001188c},
        {87845039,   26257064,  88365839,   26748104,  0x001208c},
        {88365839,   26257064,  88886639,   26748104,  0x001288c},
        {88886639,   26257064,  89407439,   26748104,  0x001308c},
        {89379200,   26257064,  89900000,   26748104,  0x001388c},
        {87746087,   25766024,  88261679,   26257064,  0x001408c},
        {88261679,   25766024,  88777271,   26257064,  0x001488c},
        {88777271,   25766024,  89292863,   26257064,  0x001508c},
        {89292863,   25766024,  89808455,   26257064,  0x001588c},
        {87720308,   25274984,  88235900,   25766024,  0x001608c},
        {88235900,   25274984,  88751492,   25766024,  0x001688c},
        {88751492,   25078568,  89267084,   25569608,  0x001708c},
        {87720308,   24783944,  88235900,   25274984,  0x001788c},
        {88235900,   24783944,  88751492,   25274984,  0x001808c},
        {87720308,   24292904,  88230692,   24783944,  0x001888c},
        {88230692,   24292904,  88741076,   24783944,  0x001908c},
        {86725059,   23801864,  87235443,   24292904,  0x001988c},
        {87235443,   23801864,  87745827,   24292904,  0x001a08c},
        {87745827,   23801864,  88256211,   24292904,  0x001a88c},
        {88256211,   23801864,  88766595,   24292904,  0x001b08c},
        {85811576,   23310824,  86316752,   23801864,  0x001b88c},
        {86316752,   23310824,  86821928,   23801864,  0x001c08c},
        {86821928,   23310824,  87327104,   23801864,  0x001c88c},
        {87327104,   23310824,  87832280,   23801864,  0x001d08c},
        {87832280,   23310824,  88337456,   23801864,  0x001d88c},
        {88337456,   23310824,  88842632,   23801864,  0x001e08c},
        {85811576,   22819784,  86316752,   23310824,  0x001e88c},
        {86316752,   22819784,  86821928,   23310824,  0x001f08c},
        {86821928,   22819784,  87327104,   23310824,  0x0010088},
        {87327104,   22819784,  87832280,   23310824,  0x0010888},
        {87832280,   22819784,  88337456,   23310824,  0x0011088},
        {88337456,   22819784,  88842632,   23310824,  0x0011888},
        {88842632,   22819784,  89347808,   23310824,  0x0012088},
        {86316752,   22328744,  86821928,   22819784,  0x0012888},
        {86821928,   22328744,  87327104,   22819784,  0x0013088},
        {87327104,   22328744,  87832280,   22819784,  0x0013888},
        {87832280,   22328744,  88337456,   22819784,  0x0014088},
        {88337456,   22328744,  88842632,   22819784,  0x0014888},
        {88842632,   22328744,  89347808,   22819784,  0x0015088},
        {86670375,   21837704,  87170343,   22328744,  0x0015888},
        {87170343,   21837704,  87670311,   22328744,  0x0016088},
        {87670311,   21837704,  88170279,   22328744,  0x0016888},
        {88170279,   21837704,  88670247,   22328744,  0x0017088},
        {88670247,   21837704,  89170215,   22328744,  0x0017888},
        {87170343,   21430000,  87670311,   21921040,  0x0018088},
        {87670311,   21430000,  88170279,   21921040,  0x0018888},
        {88170279,   21430000,  88670247,   21921040,  0x0019088},
        {88670247,   21430000,  89170215,   21921040,  0x0019888},
        {85700000,   21430000,  89900000,   27250000,  0x0020216},
        {75814372,   22676755,  75907589,   22763245,  0x001000a}, // 2MP
        {75714698,   22622190,  75979702,   22866809,  0xa9e0047},
        {77280858,   23074590,  77546541,   23319209,  0xa9e0047},
        {79794198,   23047690,  80059202,   23292309,  0xa9e0047},
        {78065518,   26161410,  78319081,   26390189,  0x9ee0047},
        {75751832,   23128000,  75830128,   23231600,  0x3c1044b},
        {75999452,   22916000,  76093148,   23002489,  0x3c1004b},
        {80782671,   24528200,  80877328,   24614689,  0x3c1004b},
        {80877371,   24528200,  80972028,   24614689,  0x3c1004b},
        {78716991,   23789500,  78811408,   23875989,  0x3c1004b},
        {74983032,   23306800,  75076968,   23393289,  0x3c1004b},
        {80342791,   23785200,  80437208,   23871689,  0x3c1004b},
        {76171332,   21271100,  76264067,   21357589,  0x3c1004b},
        {76303512,   21786800,  76396487,   21873289,  0x3c1004b},
        {77941830,   26466800,  78038169,   26553289,  0x3c1004b},
        {78731630,   26523500,  78827969,   26609989,  0x3c1004b},
        {77270571,   24604500,  77365228,   24690989,  0x3c1004b},
        {77603291,   25384700,  77698909,   25471189,  0x3c1004b},
        {77763232,   23474600,  77857168,   23561089,  0x3c1004b},
        {75011291,   24028800,  75105708,   24115289,  0x3c1004b},
        {78904512,   22013700,  78997487,   22100189,  0x3c1004b},
        {79541031,   24865000,  79636169,   24951489,  0x3c1004b},
        {74817371,   24424700,  74912028,   24511189,  0x3c1004b},
        {75636852,   22568000,  75730548,   22654489,  0x3c1004b},
        {79394791,   23791800,  79489208,   23878289,  0x3c1004b},
        {77682452,   22703700,  77776148,   22790189,  0x3c1004b},
        {77038732,   23165000,  77132668,   23251489,  0x3c1004b},
        {75569312,   21780500,  75662287,   21866989,  0x3c1004b},
        {77853612,   21865000,  77946587,   21951489,  0x3c1004b},
        {79515235,   22060150,  79582164,   22122249,  0x2b2004b},
        {75278735,   22569040,  75343864,   22629159,  0x29c004b},
        {80154922,   21780050,  80221678,   21842149,  0x2b2004b},
        {74929735,   22641440,  74994864,   22701559,  0x29c004b},
        {78424873,   25634750,  78493527,   25696849,  0x2b2004b},
        {75381252,   23434040,  75446548,   23494159,  0x29c004b},
        {78134235,   22086950,  78201164,   22149049,  0x2b2004b},
        {77728135,   22582040,  77793264,   22642159,  0x29c004b},
        {75722735,   22519050,  75789664,   22581149,  0x2b2004b},
        {81328952,   23274440,  81394248,   23334559,  0x29c004b},
        {75091904,   23605750,  75159695,   23667849,  0x2b2004b},
        {76246952,   23387240,  76312248,   23447359,  0x29c004b},
        {78796845,   24721850,  78865154,   24783949,  0x2b2004b},
        {74872686,   22009040,  74937314,   22069159,  0x29c004b},
        {78210000,   21770000,  81500000,   23990000,  0x01a000d},
        {74850000,   21570000,  78210000,   23720000,  0x08b0011},
        {77832087,   26124524,  78347679,   26615564,  0x0b10090},
        {80622133,   24325924,  81132517,   24816964,  0x0b10890},
        {81132517,   24375028,  81642901,   24866068,  0x0b11090},
        {81642900,   24424132,  82153284,   24915172,  0x0b11890},
        {75970011,   21084524,  76469979,   21575564,  0x0b12090},
        {78519395,   26321179,  79040195,   26812219,  0x0b02890},
        {76041840,   24402180,  76552224,   24893220,  0x0b13090},
        {76552224,   24402180,  77062608,   24893220,  0x0b13890},
        {77062608,   24402180,  77572992,   24893220,  0x0b14090},
        {77572992,   24402180,  78083376,   24893220,  0x0b14890},
        {78083376,   24402180,  78593760,   24893220,  0x0b15090},
        {78593760,   24402180,  79104144,   24893220,  0x0b15890},
        {77398517,   25182379,  77914109,   25673419,  0x0b16090},
        {74709403,   24023634,  75219787,   24514674,  0x0b06890},
        {79336007,   24662679,  79851599,   25153719,  0x0b07090},
        {78206617,   25420279,  78722209,   25911319,  0x0b17890},
        {75594417,   24935811,  76110009,   25426851,  0x0b08090},
        {77617446,   23750680,  78127830,   24241720,  0x0b08890},
        {74000000,   21000000,  82950000,   26873000,  0x0020216},
        {78440933,   17339555,  78531267,   17426045,  0x001000a}, // 2TG
        {78209624,   17172880,  78699176,   17663920,  0x001000c},
        {83265613,   17686800,  83356186,   17773289,  0x3c1004b},
        {83175040,   17682475,  83265613,   17768964,  0x3c1004b},
        {83145713,   17637800,  83236286,   17724289,  0x3c1004b},
        {80566954,   16476800,  80657046,   16563289,  0x3c1004b},
        {80653442,   16450853,  80743534,   16537342,  0x3c1004b},
        {80394954,   16258200,  80485046,   16344689,  0x3c1004b},
        {79566693,   17934800,  79657506,   18021289,  0x3c1004b},
        {79500593,   17962800,  79591406,   18049289,  0x3c1004b},
        {79935434,   14390900,  80024565,   14477389,  0x3c1004b},
        {77991374,   15778200,  78081226,   15864689,  0x3c1004b},
        {81753833,   16968200,  81844166,   17054689,  0x3c1004b},
        {78780434,   14428800,  78869565,   14515289,  0x3c1004b},
        {82195833,   16967700,  82286166,   17054189,  0x3c1004b},
        {82195833,   16881211,  82286166,   16967700,  0x3c1004b},
        {78054473,   18636800,  78145526,   18723289,  0x3c1004b},
        {79392254,   13586800,  79481145,   13673289,  0x3c1004b},
        {77559734,   14630900,  77648865,   14717389,  0x3c1004b},
        {79084473,   18398200,  79175526,   18484689,  0x3c1004b},
        {79461112,   18720950,  79526488,   18783049,  0x2b2004b},
        {83368437,   18089940,  83431562,   18150059,  0x29c004b},
        {81059557,   16685250,  81124243,   16747349,  0x2b2004b},
        {79999555,   15479240,  80061845,   15539359,  0x29c004b},
        {78448229,   15444850,  78512570,   15506949,  0x2b2004b},
        {80112304,   17213940,  80175095,   17274059,  0x29c004b},
        {81101243,   16152750,  81165757,   16214849,  0x2b2004b},
        {77243555,   15597940,  77305845,   15658059,  0x29c004b},
        {80598343,   16208950,  80662857,   16271049,  0x2b2004b},
        {78518938,   14725940,  78581061,   14786059,  0x29c004b},
        {77971657,   16714950,  78036343,   16777049,  0x2b2004b},
        {79069105,   13189940,  79130894,   13250059,  0x29c004b},
        {77466088,   13801950,  77529912,   13864049,  0x2b2004b},
        {81490988,   16510640,  81553612,   16570759,  0x29c004b},
        {78477088,   13525850,  78540912,   13587949,  0x2b2004b},
        {79241104,   17026940,  79303895,   17087059,  0x29c004b},
        {77339015,   15133950,  77403184,   15196049,  0x2b2004b},
        {83861137,   18269840,  83924262,   18329959,  0x29c004b},
        {77687602,   14385950,  77751598,   14448049,  0x2b2004b},
        {80964188,   16404940,  81026812,   16465059,  0x29c004b},
        {78492253,   19640850,  78558147,   19702949,  0x2b2004b},
        {80018671,   16203940,  80081128,   16264059,  0x29c004b},
        {77963515,   14890550,  78027684,   14952649,  0x2b2004b},
        {79589404,   17110940,  79652195,   17171059,  0x29c004b},
        {81493970,   16782950,  81558829,   16845049,  0x2b2004b},
        {80136671,   16065940,  80199128,   16126059,  0x29c004b},
        {76745000,   13250000,  79111000,   16100000,  0x022000d},
        {79111000,   15400000,  82440000,   17450000,  0x0860011},
        {79334269,   17746524,  79823821,   18237564,  0x0b01090},
        {77855219,   18434524,  78344771,   18925564,  0x0b12090},
        {79060709,   18345104,  79550261,   18836144,  0x0b13090},
        {77767031,   16500479,  78251375,   16991519,  0x0b14090},
        {78283033,   19426379,  78777793,   19917419,  0x0b15090},
        {76722000,   15777000,  81320000,   19920000,  0x0020216},
        {78440933,   17339555,  78531267,   17426045,  0x001000a}, // 2AP
        {78209624,   17172880,  78699176,   17663920,  0x001000c},
        {83265613,   17686800,  83356186,   17773289,  0x3c1004b},
        {83175040,   17682475,  83265613,   17768964,  0x3c1004b},
        {83145713,   17637800,  83236286,   17724289,  0x3c1004b},
        {80566954,   16476800,  80657046,   16563289,  0x3c1004b},
        {80653442,   16450853,  80743534,   16537342,  0x3c1004b},
        {80394954,   16258200,  80485046,   16344689,  0x3c1004b},
        {79566693,   17934800,  79657506,   18021289,  0x3c1004b},
        {79500593,   17962800,  79591406,   18049289,  0x3c1004b},
        {79935434,   14390900,  80024565,   14477389,  0x3c1004b},
        {77991374,   15778200,  78081226,   15864689,  0x3c1004b},
        {81753833,   16968200,  81844166,   17054689,  0x3c1004b},
        {78780434,   14428800,  78869565,   14515289,  0x3c1004b},
        {82195833,   16967700,  82286166,   17054189,  0x3c1004b},
        {82195833,   16881211,  82286166,   16967700,  0x3c1004b},
        {78054473,   18636800,  78145526,   18723289,  0x3c1004b},
        {79392254,   13586800,  79481145,   13673289,  0x3c1004b},
        {77559734,   14630900,  77648865,   14717389,  0x3c1004b},
        {79084473,   18398200,  79175526,   18484689,  0x3c1004b},
        {79461112,   18720950,  79526488,   18783049,  0x2b2004b},
        {83368437,   18089940,  83431562,   18150059,  0x29c004b},
        {81059557,   16685250,  81124243,   16747349,  0x2b2004b},
        {79999555,   15479240,  80061845,   15539359,  0x29c004b},
        {78448229,   15444850,  78512570,   15506949,  0x2b2004b},
        {80112304,   17213940,  80175095,   17274059,  0x29c004b},
        {81101243,   16152750,  81165757,   16214849,  0x2b2004b},
        {77243555,   15597940,  77305845,   15658059,  0x29c004b},
        {80598343,   16208950,  80662857,   16271049,  0x2b2004b},
        {78518938,   14725940,  78581061,   14786059,  0x29c004b},
        {77971657,   16714950,  78036343,   16777049,  0x2b2004b},
        {79069105,   13189940,  79130894,   13250059,  0x29c004b},
        {77466088,   13801950,  77529912,   13864049,  0x2b2004b},
        {81490988,   16510640,  81553612,   16570759,  0x29c004b},
        {78477088,   13525850,  78540912,   13587949,  0x2b2004b},
        {79241104,   17026940,  79303895,   17087059,  0x29c004b},
        {77339015,   15133950,  77403184,   15196049,  0x2b2004b},
        {83861137,   18269840,  83924262,   18329959,  0x29c004b},
        {77687602,   14385950,  77751598,   14448049,  0x2b2004b},
        {80964188,   16404940,  81026812,   16465059,  0x29c004b},
        {78492253,   19640850,  78558147,   19702949,  0x2b2004b},
        {80018671,   16203940,  80081128,   16264059,  0x29c004b},
        {77963515,   14890550,  78027684,   14952649,  0x2b2004b},
        {79589404,   17110940,  79652195,   17171059,  0x29c004b},
        {81493970,   16782950,  81558829,   16845049,  0x2b2004b},
        {80136671,   16065940,  80199128,   16126059,  0x29c004b},
        {76745000,   13250000,  79111000,   16100000,  0x022000d},
        {79111000,   15400000,  82440000,   17450000,  0x0860011},
        {83006169,   17460024,  83495721,   17951064,  0x0b00890},
        {79334269,   17746524,  79823821,   18237564,  0x0b01090},
        {79740427,   14188624,  80219563,   14679664,  0x0b11890},
        {77855219,   18434524,  78344771,   18925564,  0x0b12090},
        {79035557,   13186112,  79514693,   13677152,  0x0b12890},
        {79060709,   18345104,  79550261,   18836144,  0x0b13090},
        {83155219,   17874479,  83644771,   18365519,  0x0b13890},
        {77767031,   16500479,  78251375,   16991519,  0x0b14090},
        {83647919,   18054379,  84137471,   18545419,  0x0b14890},
        {78283033,   19426379,  78777793,   19917419,  0x0b15090},
        {76722000,   12550000,  84940000,   19920000,  0x0020216},
        {72790089,   18892644,  72862186,   18998664,  0x026000a}, // 2MH
        {72775700,   18893000,  73212200,   19470000,  0x023000c},
        {73785373,   18521397,  73876426,   18607886,  0x3c1004b},
        {73876426,   18521397,  73967479,   18607886,  0x3c1004b},
        {73876426,   18434908,  73967479,   18521397,  0x3c1004b},
        {73785373,   18434908,  73876426,   18521397,  0x3c1004b},
        {78987832,   21143726,  79080567,   21230215,  0x3c1004b},
        {79080567,   21156700,  79173302,   21243189,  0x3c1004b},
        {78987832,   21057237,  79080567,   21143726,  0x3c1004b},
        {79080567,   21070211,  79173302,   21156700,  0x3c1004b},
        {73687986,   19975449,  73780000,   20061938,  0x3c1004b},
        {73780000,   19975449,  73872014,   20061938,  0x3c1004b},
        {73780120,   19888960,  73871894,   19975449,  0x3c1004b},
        {73688346,   19888960,  73780120,   19975449,  0x3c1004b},
        {73754573,   18585000,  73845626,   18671489,  0x3c1004b},
        {75301113,   19837800,  75392887,   19924289,  0x3c1004b},
        {75870213,   17618700,  75960786,   17705189,  0x3c1004b},
        {77713972,   20889100,  77806227,   20975589,  0x3c1004b},
        {73208611,   19124400,  73299905,   19210889,  0x3c1004b},
        {77269253,   19125200,  77360547,   19211689,  0x3c1004b},
        {74182454,   16648300,  74272546,   16734789,  0x3c1004b},
        {74533633,   16820300,  74623966,   16906789,  0x3c1004b},
        {74483772,   20513700,  74576027,   20600189,  0x3c1004b},
        {75513872,   20957800,  75606127,   21044289,  0x3c1004b},
        {76957172,   20661800,  77049427,   20748289,  0x3c1004b},
        {76528173,   18363800,  76619226,   18450289,  0x3c1004b},
        {74723872,   20861100,  74816127,   20947589,  0x3c1004b},
        {74694353,   19061000,  74785647,   19147489,  0x3c1004b},
        {79270267,   19928950,  79336333,   19991049,  0x2b2004b},
        {76744170,   19233940,  76807629,   19294059,  0x29c004b},
        {74424457,   16671350,  74489143,   16733449,  0x2b2004b},
        {75854503,   19813940,  75918296,   19874059,  0x29c004b},
        {75749508,   21005950,  75816092,   21068049,  0x2b2004b},
        {75723670,   18961140,  75787129,   19021259,  0x29c004b},
        {80162708,   21437150,  80229292,   21499249,  0x2b2004b},
        {73975321,   17655540,  74038279,   17715659,  0x29c004b},
        {75657998,   18205950,  75723202,   18268049,  0x2b2004b},
        {78093020,   20359940,  78156980,   20420059,  0x29c004b},
        {75450177,   17559405,  78250531,   20240595,  0x001000d},
        {72649823,   17559405,  75450177,   20240595,  0x0a80011},
        {78846791,   20892636,  79346759,   21383676,  0x0b00090},
        {79346759,   20892636,  79846727,   21383676,  0x0b00890},
        {77385416,   20822580,  77885384,   21313620,  0x0b01090},
        {74161932,   16529479,  74646276,   17020519,  0x0b11890},
        {74399916,   20484980,  74899884,   20976020,  0x0b02090},
        {75422016,   20773880,  75921984,   21264920,  0x0b02890},
        {76128256,   20459380,  76628224,   20950420,  0x0b03090},
        {76628224,   20459380,  77128192,   20950420,  0x0b03890},
        {77128192,   20459380,  77628160,   20950420,  0x0b04090},
        {78863220,   19837140,  79357980,   20328180,  0x0b14890},
        {79357980,   19837140,  79852740,   20328180,  0x0b15090},
        {79946016,   21149024,  80445984,   21640064,  0x0b15890},
        {77882824,   20144380,  78377584,   20635420,  0x0b16090},
        {73992916,   21127380,  74492884,   21618420,  0x0b16890},
        {78355916,   20500380,  78855884,   20991420,  0x0b07090},
        {72500000,   15474000,  80988000,   22110000,  0x0020216},
        {80885950,   26803755,  80982050,   26890245,  0x001000a}, // 2UP
        {77276565,   28490000,  77591085,   28787000,  0xc730447},
        {80781721,   26710290,  81086279,   26983709,  0xbde0047},
        {80226621,   26333790,  80531179,   26607209,  0xbde0047},
        {77904190,   27182000,  78001009,   27268489,  0x3c1004b},
        {78001009,   27182000,  78097828,   27268489,  0x3c1004b},
        {78001009,   27095511,  78097828,   27182000,  0x3c1004b},
        {77904190,   27095511,  78001009,   27182000,  0x3c1004b},
        {77661629,   28948800,  77760370,   29035289,  0x3c1004b},
        {77661629,   28862311,  77760370,   28948800,  0x3c1004b},
        {82952591,   25294100,  83048209,   25380589,  0x3c1004b},
        {82933467,   25207611,  83029085,   25294100,  0x3c1004b},
        {81725291,   25398200,  81820909,   25484689,  0x3c1004b},
        {81820909,   25367928,  81916527,   25454417,  0x3c1004b},
        {81820909,   25454417,  81916527,   25540906,  0x3c1004b},
        {79375069,   28320800,  79473330,   28407289,  0x3c1004b},
        {78720669,   28796800,  78818930,   28883289,  0x3c1004b},
        {78021410,   27849900,  78119190,   27936389,  0x3c1004b},
        {77490149,   29918200,  77589851,   30004689,  0x3c1004b},
        {83333230,   26716300,  83429569,   26802789,  0x3c1004b},
        {78348790,   27115500,  78445609,   27201989,  0x3c1004b},
        {78518991,   25406800,  78614609,   25493289,  0x3c1004b},
        {77675089,   29423800,  77774311,   29510289,  0x3c1004b},
        {77631350,   27456800,  77728650,   27543289,  0x3c1004b},
        {79875510,   27836800,  79973290,   27923289,  0x3c1004b},
        {78984724,   28761050,  79055275,   28823149,  0x2b2004b},
        {83526684,   25914940,  83593316,   25975059,  0x29c004b},
        {79560500,   27348000,  79639980,   27402500,  0x2b2044b},
        {77735849,   28699940,  77804151,   28760059,  0x29c004b},
        {78989142,   26748950,  79058658,   26811049,  0x2b2004b},
        {82533534,   25105940,  82599665,   25166059,  0x29c004b},
        {77814724,   28378950,  77885275,   28441049,  0x2b2004b},
        {78535149,   28540640,  78603451,   28600759,  0x29c004b},
        {78438752,   28866550,  78509648,   28928649,  0x2b2004b},
        {80780684,   25897540,  80847316,   25957659,  0x29c004b},
        {81209387,   26198950,  81278213,   26261049,  0x2b2004b},
        {79416684,   25959940,  79483316,   26020059,  0x29c004b},
        {81555069,   27548950,  81624930,   27611049,  0x2b2004b},
        {80646083,   27539940,  80713717,   27600059,  0x29c004b},
        {82655587,   25716550,  82724413,   25778649,  0x2b2004b},
        {82113050,   26743940,  82180350,   26804059,  0x29c004b},
        {79084897,   27999650,  79155103,   28061749,  0x2b2004b},
        {80310067,   25451940,  80376532,   25512059,  0x29c004b},
        {80744897,   27916950,  80815103,   27979049,  0x2b2004b},
        {78018183,   27567940,  78085817,   27628059,  0x29c004b},
        {80169550,   25096510,  83118859,   27777700,  0x001000d},
        {77190450,   26437105,  80169550,   29118295,  0x0a80011},
        {77276892,   29719080,  77813316,   30210120,  0x0b00090},
        {83111500,   26514480,  83632300,   27005520,  0x0b00890},
        {78307408,   25204480,  78823000,   25695520,  0x0b11090},
        {77088888,   29099404,  77620104,   29590444,  0x0b11890},
        {77620104,   29099404,  78151320,   29590444,  0x0b12090},
        {83120808,   25759780,  83636400,   26250820,  0x0b12890},
        {79197308,   25744480,  79712900,   26235520,  0x0b13090},
        {79197308,   25253440,  79712900,   25744480,  0x0b13890},
        {80653602,   27771225,  81179610,   28262265,  0x0b04090},
        {81179609,   27771225,  81705617,   28262265,  0x0b04890},
        {78154908,   24456180,  78665292,   24947220,  0x0b15090},
        {82866408,   25035480,  83382000,   25526520,  0x0b05890},
        {77000000,   23820000,  84760000,   30417000,  0x0020216},
        {79757488,   11882857,  79844939,   11969347,  0x001000a}, // 2PY
        {79595000,   11766000,  79908000,   12060000,  0x004010b},
        {79727000,   10822000,  79871000,   11011000,  0x004010b},
        {82183000,   16704000,  82328000,   16778000,  0x004010b},
        {75522000,   11673000,  75569000,   11710000,  0x004010b},
        {75522000,   11703500,  75569000,   11720000,  0x004010b},
        {75522000,   10822000,  82328000,   16778000,  0x0020216},
        {151158106,  -33913245, 151261894,  -33826755, 0x001000a}, // NSW
        {150745968,  -34120420, 151308432,  -33629380, 0x001000c},
        {151601307,  -32963200, 151703892,  -32876711, 0x3c1004b},
        {151703892,  -32963200, 151806477,  -32876711, 0x3c1004b},
        {151632082,  -33049689, 151734667,  -32963200, 0x3c1004b},
        {150817746,  -34497800, 150922253,  -34411311, 0x3c1004b},
        {150862000,  -34411306, 150942474,  -34299000, 0x3c1044b},
        {150757500,  -34597600, 150876906,  -34521980, 0x3c1044b},
        {146877385,  -36095000, 147017039,  -36029200, 0x3c1044b},
        {146820000,  -36166000, 146949576,  -36095000, 0x3c1044b},
        {150552006,  -34926400, 150640716,  -34824211, 0x3c1044b},
        {153062349,  -30331800, 153162051,  -30245311, 0x3c1004b},
        {152843948,  -31491200, 152944852,  -31404711, 0x3c1004b},
        {149522767,  -33450800, 149625833,  -33364311, 0x3c1004b},
        {147307806,  -35178000, 147412794,  -35091511, 0x3c1004b},
        {153253469,  -28854500, 153351730,  -28768011, 0x3c1004b},
        {152429408,  -31945500, 152530792,  -31859011, 0x3c1004b},
        {148565667,  -32296500, 148667532,  -32210011, 0x3c1004b},
        {150867948,  -31138200, 150968852,  -31051711, 0x3c1004b},
        {151611508,  -30558200, 151711691,  -30471711, 0x3c1004b},
        {150651906,  -33812200, 150755693,  -33725711, 0x3c1004b},
        {149657506,  -34793200, 149762494,  -34706711, 0x3c1004b},
        {141412008,  -32005000, 141513392,  -31918511, 0x3c1004b},
        {150285906,  -33735570, 150470585,  -33687000, 0x3c1044b},
        {151308307,  -32887900, 151410892,  -32801411, 0x3c1004b},
        {152469567,  -32228900, 152571432,  -32142411, 0x3c1004b},
        {152856689,  -29749400, 152955911,  -29662911, 0x3c1004b},
        {153511769,  -28877300, 153610030,  -28790811, 0x3c1004b},
        {145991946,  -34327600, 146096453,  -34241111, 0x3c1004b},
        {153044007,  -30382750, 153115593,  -30320651, 0x2b2004b},
        {151421900,  -32837100, 151505591,  -32785930, 0x29c044b},
        {151129872,  -32586950, 151203528,  -32524851, 0x2b2004b},
        {150854596,  -32300060, 150925403,  -32239941, 0x29c004b},
        {151708272,  -32797550, 151781928,  -32735451, 0x2b2004b},
        {150801311,  -34691460, 150874289,  -34631341, 0x29c004b},
        {150114499,  -33516150, 150188500,  -33454051, 0x2b2004b},
        {153011349,  -28890360, 153079651,  -28830241, 0x29c004b},
        {149157400,  -35210595, 152315246,  -32529405, 0x0a90011},
        {150096664,  -32529404, 153252000,  -29966000, 0x01e000d},
        {149234028,  -29966000, 153655000,  -28154347, 0x28e0015},
        {141000000,  -37508092, 159267000,  -28154347, 0x2ca0016},
        {140997000,  -37508092, 159267000,  -28154347, 0x0020217},
        {149082445,  -35350645, 149188155,  -35264155, 0x001000a}, // ACT
        {148750000,  -35500000, 149400000,  -35121000, 0x019000c},
        {148750000,  -35922000, 149170000,  -35400000, 0x0d40010},
        {148750000,  -35922000, 149400000,  -35121000, 0x0020217},
        {150670106,  -35201645, 150774855,  -35115155, 0x001000a}, // JBT
        {150589000,  -35205000, 150790000,  -35105200, 0x001000c},
        {150589000,  -35205000, 150790000,  -35105200, 0x0020217},
        {130841100,  -12410500, 130924083,  -12364600, 0x2a7044a}, // 4NT
        {130816194,  -12471845, 130896969,  -12424600, 0x2a7044a},
        {130738532,  -12803820, 131217668,  -12312780, 0x001000c},
        {133631125,  -23846980, 134006875,  -23501021, 0xf04004b},
        {132066539,  -14614900, 132411660,  -14280011, 0xe89004b},
        {130475928,  -13770595, 133186909,  -11089405, 0x0a90011},
        {130889613,  -16400456, 133630385,  -13719266, 0x001000d},
        {132440032,  -25040595, 135329759,  -22359405, 0x0010015},
        {129000000,  -26000000, 138000000,  -10600000, 0x4d60016},
        {128999000,  -26040000, 138000000,  -10600000, 0x0020217},
        {138551406,  -34968445, 138656155,  -34881955, 0x001000a}, // 4SA
        {138459868,  -35174720, 139027540,  -34683680, 0x001000c},
        {137423314,  -33099090, 137628486,  -32926111, 0x782004b},
        {140667207,  -37895490, 140884392,  -37722511, 0x782004b},
        {138629292,  -34685190, 138838308,  -34512211, 0x782004b},
        {137701734,  -32574790, 137905465,  -32401811, 0x782004b},
        {137930233,  -33255090, 138136366,  -33082111, 0x782004b},
        {138573750,  -35587600, 138935209,  -35486500, 0x782044b},
        {135730992,  -34771390, 135940008,  -34598411, 0x782004b},
        {139188704,  -35182780, 139370495,  -35033021, 0x680004b},
        {138087000,  -38064800, 141000000,  -35243000, 0x021000d},
        {137240141,  -35243000, 140036500,  -32326000, 0x0ba0011},
        {134082295,  -35067336, 137240141,  -32386146, 0x0010015},
        {129000000,  -38300000, 141000000,  -26000000, 0x0010016},
        {128999000,  -38300000, 141005000,  -25995000, 0x0020217},
        {147243600,  -42872000, 147336807,  -42817755, 0x2a7044a}, // TAS
        {147273700,  -42928500, 147363247,  -42872000, 0x2a7044a},
        {147011912,  -43201520, 147647288,  -42710480, 0x001000c},
        {146963374,  -41625770, 147342626,  -41338941, 0xc73004b},
        {145669239,  -41201410, 146030760,  -40927991, 0xbde004b},
        {146030000,  -41269300, 146580969,  -41090000, 0xbde044b},
        {144820374,  -43672013, 148365503,  -40990823, 0x0a80011},
        {144560000,  -41520000, 148516000,  -39390000, 0x019000d},
        {141154896,  -41881195, 144580861,  -39200005, 0x0010015},
        {141000000,  -45000000, 150000000,  -39200000, 0x0010016},
        {141000000,  -45000000, 150000000,  -39200000, 0x0020217},
        {144907684,  -37853245, 145016277,  -37766755, 0x001000a}, // VIC
        {144710252,  -38056820, 145298756,  -37565780, 0x001000c},
        {144296044,  -38215300, 144405356,  -38128811, 0x3c1004b},
        {144296044,  -38128811, 144405356,  -38042322, 0x3c1004b},
        {143785704,  -37603200, 143894296,  -37516711, 0x3c1004b},
        {144226064,  -36803200, 144333935,  -36716711, 0x3c1004b},
        {144991444,  -38289100, 145100756,  -38202611, 0x3c1004b},
        {145069644,  -38218600, 145178956,  -38132111, 0x3c1004b},
        {142107746,  -34233200, 142212253,  -34146711, 0x3c1004b},
        {145332725,  -36427100, 145439875,  -36340611, 0x3c1004b},
        {144515704,  -37733200, 144624296,  -37646711, 0x3c1004b},
        {142430663,  -38404200, 142540936,  -38317711, 0x3c1004b},
        {145215044,  -38142500, 145324356,  -38056011, 0x3c1004b},
        {144684104,  -37612100, 144792696,  -37525611, 0x3c1004b},
        {146475344,  -38220000, 146643920,  -38164000, 0x3c1044b},
        {146246425,  -36403200, 146353575,  -36316711, 0x3c1004b},
        {147005344,  -38129500, 147195988,  -38080000, 0x3c1044b},
        {146227244,  -38232400, 146336556,  -38145911, 0x3c1004b},
        {146352244,  -38253900, 146461556,  -38167411, 0x3c1004b},
        {144599244,  -37919400, 144708556,  -37832911, 0x3c1004b},
        {142148325,  -36765900, 142255475,  -36679411, 0x3c1004b},
        {144696785,  -36173200, 144803214,  -36086711, 0x3c1004b},
        {144375704,  -37713200, 144484296,  -37626711, 0x3c1004b},
        {144476000,  -38293200, 144683592,  -38247700, 0x3c1044b},
        {147574144,  -37862800, 147683456,  -37776311, 0x3c1004b},
        {143539763,  -38382800, 143650036,  -38296311, 0x3c1004b},
        {141536563,  -38389900, 141646836,  -38303411, 0x3c1004b},
        {145284344,  -38069600, 145393656,  -37983111, 0x3c1004b},
        {143487145,  -35383200, 143592854,  -35296711, 0x3c1004b},
        {141965704,  -37773200, 142074296,  -37686711, 0x3c1004b},
        {145840844,  -38189300, 145950156,  -38102811, 0x3c1004b},
        {145919025,  -36586700, 146026175,  -36500211, 0x3c1004b},
        {143676064,  -37075870, 143831417,  -37015890, 0x3c1044b},
        {143161495,  -38728713, 146438505,  -36047523, 0x0a90011},
        {146438505,  -38728713, 149715515,  -36047523, 0x0010015},
        {141200000,  -38663000, 143161495,  -34087000, 0x034000d},
        {141000000,  -39206719, 151318000,  -33977816, 0x0010016},
        {140950000,  -39260000, 151318000,  -33977816, 0x0020217},
        {115792028,  -32003245, 115892933,  -31916755, 0x001000a}, // 4WA
        {115689500,  -32274400, 116116000,  -31669000, 0x027000c},
        {115700073,  -32392510, 115844126,  -32270201, 0x54f004b},
        {115721700,  -32519500, 115860241,  -32392510, 0x54f044b},
        {115627673,  -32613710, 115815872,  -32519500, 0x54f044b},
        {121393663,  -30827310, 121535337,  -30705001, 0x54f004b},
        {114578000,  -28829500, 114681271,  -28665000, 0x54f044b},
        {115596624,  -33420210, 115742375,  -33297901, 0x54f004b},
        {117805765,  -35081110, 117954234,  -34958801, 0x54f004b},
        {118537938,  -20425000, 118662603,  -20297401, 0x54f044b},
        {122173688,  -18010210, 122302112,  -17887901, 0x54f004b},
        {115150800,  -33693550, 115412483,  -33625000, 0x54f044b},
        {116775268,  -20803010, 116905731,  -20680701, 0x54f004b},
        {121810614,  -33899910, 121957385,  -33777601, 0x54f004b},
        {116071324,  -33437210, 116217075,  -33314901, 0x54f004b},
        {113610930,  -24949610, 113745470,  -24827301, 0x54f004b},
        {116596313,  -31709910, 116739686,  -31587601, 0x54f004b},
        {115676167,  -33300400, 115779233,  -33213911, 0x3c1004b},
        {114962979,  -33989928, 118091034,  -31308738, 0x0a80011},
        {116891946,  -35196656, 120049792,  -32515466, 0x001000d},
        {120079583,  -34124180, 123207638,  -31442990, 0x0010015},
        {121599901,  -16608714, 124340673,  -13927524, 0x0a90091},
        {124340673,  -16608714, 126715000,  -13524000, 0x0c20891},
        {126715000,  -16608714, 129000000,  -13524000, 0x0c61091},
        {120792565,  -19289904, 123563128,  -16608714, 0x0a91891},
        {123563128,  -19289904, 126333691,  -16608714, 0x0a92091},
        {126229437,  -19289904, 129000000,  -16608714, 0x0a92891},
        {113005197,  -21971094, 115835342,  -19289904, 0x0a83091},
        {115835342,  -21971094, 118665487,  -19289904, 0x0a83891},
        {118665487,  -21971094, 121495632,  -19289904, 0x0a84091},
        {121495632,  -21971094, 124325777,  -19289904, 0x0a84891},
        {124325777,  -21971094, 127155922,  -19289904, 0x0a85091},
        {126169855,  -21971094, 129000000,  -19289904, 0x0a85891},
        {112975406,  -24652284, 115835342,  -21971094, 0x0a96091},
        {115835342,  -24652284, 118695278,  -21971094, 0x0a96891},
        {118695278,  -24652284, 121555214,  -21971094, 0x0a97091},
        {112945615,  -27333474, 115894924,  -24652284, 0x0a87891},
        {115894924,  -27333474, 118844233,  -24652284, 0x0a88091},
        {118844233,  -27333474, 121793542,  -24652284, 0x0a88891},
        {112915824,  -30014664, 115924715,  -27333474, 0x0a89091},
        {115924715,  -30014664, 118933606,  -27333474, 0x0a89891},
        {118933606,  -30014664, 121942497,  -27333474, 0x0a8a091},
        {113788700,  -32695854, 116857173,  -30014664, 0x0a9a891},
        {116857173,  -32695854, 119925646,  -30014664, 0x0a9b091},
        {119925646,  -32695854, 122994119,  -30014664, 0x0a9b891},
        {122994119,  -32695854, 126062592,  -30014664, 0x0a9c091},
        {125931527,  -32695854, 129000000,  -30014664, 0x0a9c891},
        {114496237,  -35377044, 117654083,  -32695854, 0x0a9d091},
        {117654083,  -35377044, 120811929,  -32695854, 0x0a9d891},
        {120811929,  -35377044, 123969775,  -32695854, 0x0a9e091},
        {123969775,  -35377044, 127127621,  -32695854, 0x0a9e891},
        {120612051,  -24652284, 123471987,  -21971094, 0x001008d},
        {123471987,  -24652284, 126331923,  -21971094, 0x001088d},
        {126140064,  -24652284, 129000000,  -21971094, 0x001108d},
        {120582260,  -27333474, 123531569,  -24652284, 0x001188d},
        {123531569,  -27333474, 126480878,  -24652284, 0x001208d},
        {126050691,  -27333474, 129000000,  -24652284, 0x001288d},
        {120552469,  -30014664, 123561360,  -27333474, 0x001308d},
        {123561360,  -30014664, 126570251,  -27333474, 0x001388d},
        {125991109,  -30014664, 129000000,  -27333474, 0x001408d},
        {121680337,  -14881190, 124391318,  -12200000, 0x001488d},
        {117765356,  -18754141, 120535919,  -16072951, 0x001508d},
        {112700000,  -35600000, 129000000,  -12200000, 0x0020217},
        {152981650,  -27503145, 153078711,  -27416655, 0x001000a}, // QLD
        {152912000,  -27481600, 153208909,  -27030380, 0xf040447},
        {152725670,  -27705000, 153290239,  -27481600, 0xe890447},
        {153284000,  -27897000, 153412102,  -27831100, 0x3c1044b},
        {153293000,  -27958000, 153431582,  -27897000, 0x3c1044b},
        {153311600,  -28026530, 153434818,  -27958000, 0x3c1044b},
        {153352000,  -28102290, 153463517,  -28026530, 0x3c1044b},
        {153399710,  -28188900, 153497490,  -28102411, 0x3c1004b},
        {153019530,  -26674700, 153115869,  -26588211, 0x3c1004b},
        {153043614,  -26761189, 153139953,  -26674700, 0x3c1004b},
        {153055898,  -26847678, 153152717,  -26761189, 0x3c1004b},
        {146702100,  -19396600, 146756724,  -19252211, 0x3c1044b},
        {146756724,  -19337000, 146836333,  -19238000, 0x3c1044b},
        {145692133,  -16959000, 145782466,  -16872511, 0x3c1004b},
        {145692133,  -17045489, 145782466,  -16959000, 0x3c1004b},
        {151896650,  -27608900, 151993950,  -27522411, 0x3c1004b},
        {149133632,  -21183200, 149226367,  -21096711, 0x3c1004b},
        {150473000,  -23416300, 150553642,  -23315650, 0x3c1044b},
        {152800000,  -25318000, 152911638,  -25244000, 0x3c1044b},
        {152999500,  -26444900, 153114786,  -26372660, 0x3c1044b},
        {139470700,  -20782730, 139530987,  -20650500, 0x3c1044b},
        {152296431,  -24918200, 152391569,  -24831711, 0x3c1004b},
        {151202291,  -23908300, 151296708,  -23821811, 0x3c1004b},
        {152647291,  -25576200, 152742909,  -25489711, 0x3c1004b},
        {151978710,  -28257500, 152076490,  -28171011, 0x3c1004b},
        {152617171,  -26237800, 152713029,  -26151311, 0x3c1004b},
        {153281820,  -27647000, 153382866,  -27563800, 0x3c1044b},
        {150693032,  -23173200, 150786968,  -23086711, 0x3c1004b},
        {151222642,  -27224650, 151292158,  -27162551, 0x2b2004b},
        {148134452,  -23560700, 148189777,  -23489941, 0x29c044b},
        {148202567,  -20030850, 148268633,  -19968751, 0x2b2004b},
        {145984821,  -17546850, 146068514,  -17501700, 0x29c044b},
        {146234667,  -20102550, 146300733,  -20040451, 0x2b2004b},
        {147346900,  -19589100, 147426355,  -19540900, 0x29c044b},
        {153072300,  -26590350, 153102775,  -26449760, 0x2b2044b},
        {151814617,  -26576660, 151881583,  -26516541, 0x29c004b},
        {145390570,  -17029450, 145455429,  -16967351, 0x2b2004b},
        {148020186,  -22025560, 148084814,  -21965441, 0x29c004b},
        {148846277,  -23611050, 148913723,  -23548951, 0x2b2004b},
        {145462530,  -17289500, 145510469,  -17210900, 0x29c044b},
        {150642944,  -28358473, 153592253,  -25677283, 0x0a90011},
        {150230339,  -25677283, 153120066,  -22996093, 0x001000d},
        {146080000,  -21260000, 149240000,  -19019400, 0x33f0015},
        {138000000,  -29181841, 154000000,  -15300000, 0x37a0016},
        {138000000,  -15300000, 146800000,  -9182000,  0x0900012},
        {137990000,  -29181841, 159267000,  -9182000,  0x0020217},
        {-47947500,  -15840000, -47871000,  -15735000, 0x025000a}, // 6DF
        {-48290000,  -16052000, -47805657,  -15570000, 0x001000c},
        {-47805657,  -16052000, -47300000,  -15570000, 0x0ab0010},
        {-48290000,  -16052000, -47300000,  -15499000, 0x0800011},
        {-48290000,  -16052000, -47300000,  -15499000, 0x0020217},
        {-37106200,  -10983900, -37042588,  -10867000, 0x02a000a}, // 6SE
        {-37315760,  -11169520, -36841832,  -10678480, 0x001000c},
        {-37590005,  -10811470, -37298396,  -10524641, 0xc73004b},
        {-37570268,  -11382510, -37291533,  -11109091, 0xbde004b},
        {-37716988,  -11117710, -37439012,  -10844291, 0xbde004b},
        {-38298340,  -11609193, -36353760,  -9459899,  0x0b20011},
        {-38298340,  -11609193, -36353760,  -9459899,  0x0020217},
        {-35768045,  -9685600,  -35686700,  -9593530,  0x021000a}, // 6AL
        {-36123300,  -9848000,  -35541888,  -9457570,  0x018000c},
        {-36918360,  -10009520, -36444432,  -9518480,  0x0b00010},
        {-38248215,  -10514818, -35106812,  -8809082,  0x07c0011},
        {-38248215,  -10514818, -35106812,  -8809082,  0x0020217},
        {-43265000,  -22930000, -43166429,  -22889000, 0x2a7044a}, // 6RJ
        {-43231000,  -22989000, -43162556,  -22930000, 0x2a7044a},
        {-43654000,  -23034980, -42950000,  -22689000, 0x016000c},
        {-43332220,  -22689000, -43139561,  -22563000, 0x680044b},
        {-42954120,  -22836280, -42791881,  -22686521, 0x680004b},
        {-43813820,  -22992880, -43651581,  -22843121, 0x680004b},
        {-42393651,  -22943000, -42184222,  -22827000, 0x680044b},
        {-41400796,  -21842180, -41239805,  -21692421, 0x680004b},
        {-43246311,  -22556810, -43114489,  -22434501, 0x54f004b},
        {-44214470,  -22565600, -44048213,  -22468700, 0x54f044b},
        {-42567700,  -22340000, -42473805,  -22168500, 0x54f044b},
        {-41829011,  -22416010, -41697189,  -22293701, 0x54f004b},
        {-44335651,  -23041910, -44159470,  -22950000, 0x54f044b},
        {-43021211,  -22470010, -42889389,  -22347701, 0x54f004b},
        {-42118551,  -22927810, -41986050,  -22805501, 0x54f004b},
        {-44592000,  -22508000, -44385391,  -22430000, 0x54f044b},
        {-44900000,  -23382598, -40929565,  -21497500, 0x0780011},
        {-42420000,  -23200000, -40929565,  -20720153, 0x001000d},
        {-44900000,  -23382598, -40929565,  -20720153, 0x0020217},
        {-40340167,  -20395500, -40266600,  -20289480, 0x026000a}, // 6ES
        {-40539776,  -20600000, -40145800,  -20000000, 0x026000c},
        {-40627844,  -20791740, -40401957,  -20579971, 0x931004b},
        {-41230704,  -20946660, -41024497,  -20753341, 0x864004b},
        {-40154230,  -19497060, -39950171,  -19303741, 0x864004b},
        {-40714630,  -19582960, -40510571,  -19389641, 0x864004b},
        {-39931461,  -18824060, -39727939,  -18630741, 0x864004b},
        {-40419867,  -19908960, -40214734,  -19715641, 0x864004b},
        {-41883000,  -21306000, -39656000,  -17885000, 0x0d60011},
        {-41883000,  -21306000, -39656000,  -17885000, 0x0020217},
        {-35269000,  -5862825,  -35190755,  -5770755,  0x021000a}, // 6RN
        {-35514000,  -6156640,  -35096000,  -5618080,  0x022000c},
        {-37441960,  -5345280,  -37095040,  -4999321,  0xf04004b},
        {-37379175,  -6590200,  -37042426,  -6255311,  0xe89004b},
        {-38224473,  -6985000,  -34947510,  -4828300,  0x0890011},
        {-38606600,  -6730000,  -34947510,  -4828300,  0x016000d},
        {-38606600,  -6985000,  -34947510,  -4828300,  0x0020217},
        {-34900945,  -7177245,  -34814455,  -7090755,  0x001000a}, // 6PB
        {-35255260,  -7278320,  -34786540,  -6787280,  0x001000c},
        {-36038610,  -7387370,  -35749391,  -7100541,  0xc73004b},
        {-37486349,  -7185510,  -37210652,  -6912091,  0xbde004b},
        {-38367169,  -6986010,  -38092231,  -6712591,  0xbde004b},
        {-37800000,  -8336500,  -34768982,  -5993000,  0x0940011},
        {-38784485,  -8336500,  -35800000,  -5993000,  0x01b000d},
        {-38784485,  -8336500,  -34768982,  -5993000,  0x0020217},
        {-48663550,  -27630345, -48566489,  -27543855, 0x001000a}, // 6SC
        {-48744602,  -27722080, -48355398,  -27376121, 0xf040047},
        {-48947084,  -26490100, -48575916,  -26155211, 0xe890047},
        {-49191620,  -26984390, -48997980,  -26811411, 0x782004b},
        {-50422301,  -27895990, -50227700,  -27723011, 0x782004b},
        {-49465162,  -28742390, -49268639,  -28569411, 0x782004b},
        {-48775740,  -26903090, -48583061,  -26730111, 0x782004b},
        {-52731720,  -27179290, -52538080,  -27006311, 0x782004b},
        {-49153940,  -26542290, -48961261,  -26369311, 0x782004b},
        {-48761120,  -27073390, -48567480,  -26900411, 0x782004b},
        {-49026524,  -27182880, -48858877,  -27033121, 0x680004b},
        {-50620000,  -29360000, -48342000,  -25955000, 0x0d90011},
        {-53850000,  -28398000, -50620000,  -26056400, 0x01b000d},
        {-53850000,  -29360000, -48342000,  -25955000, 0x0020217},
        {-34934845,  -8096445,  -34848355,  -8009955,  0x001000a}, // 6PE
        {-35179707,  -8350000,  -34818000,  -7724400,  0x028000c},
        {-36069504,  -8368880,  -35918497,  -8219121,  0x680004b},
        {-40599712,  -9468880,  -40448289,  -9319121,  0x680004b},
        {-36556012,  -8967780,  -36404589,  -8818021,  0x680004b},
        {-35389504,  -8208880,  -35238497,  -8059121,  0x680004b},
        {-36305839,  -8011036,  -36154832,  -7861277,  0x680004b},
        {-35282104,  -7930580,  -35131097,  -7780821,  0x680004b},
        {-35654004,  -8295180,  -35502997,  -8145421,  0x680004b},
        {-37100000,  -8516180,  -36923674,  -8388000,  0x680044b},
        {-38353604,  -8046480,  -38202597,  -7896721,  0x680004b},
        {-35112864,  -8470310,  -34989536,  -8348001,  0x54f004b},
        {-35075464,  -7624610,  -34952136,  -7502301,  0x54f004b},
        {-38180000,  -9400000,  -34790000,  -7250000,  0x0860011},
        {-41375000,  -9484000,  -38180000,  -7288000,  0x019000d},
        {-41375000,  -9484000,  -34790000,  -7250000,  0x0020217},
        {-51105370,  -17245,    -51040000,  94355,     0x028000a}, // 6AP
        {-51388860,  -175420,   -50920140,  315620,    0x001000c},
        {-52562360,  -969920,   -52093640,  -478880,   0x0b00010},
        {-52547000,  -1241840,  -49855957,  1600000,   0x0ad0011},
        {-52530000,  1600000,   -49880000,  4450500,   0x020000d},
        {-54886000,  -604500,   -52530000,  2660000,   0x46b0015},
        {-54942627,  -1241840,  -49855957,  4450500,   0x0020217},
        {-38569145,  -3787645,  -38482655,  -3701155,  0x001000a}, // 6CE
        {-38706583,  -4197000,  -38288000,  -3662800,  0x022000c},
        {-39470000,  -7335000,  -39074331,  -7030000,  0xf04044b},
        {-40486000,  -3963000,  -40249276,  -3488000,  0xe89044b},
        {-39330000,  -5700000,  -37239000,  -2691000,  0x0ca0011},
        {-41448000,  -5700000,  -39330000,  -2691000,  0x4790015},
        {-41000000,  -7885000,  -38000000,  -5700000,  0x01a000d},
        {-41448000,  -7885000,  -37239000,  -2691000,  0x0020217},
        {-67869245,  -10007345, -67781794,  -9920855,  0x001000a}, // 6AC
        {-68036660,  -10233520, -67562732,  -9742480,  0x001000c},
        {-72969721,  -7849880,  -72620879,  -7503921,  0xf04004b},
        {-68829705,  -9275000,  -68491095,  -8940111,  0xe89004b},
        {-69434267,  -11156000, -66610000,  -8610000,  0x0a00011},
        {-71585069,  -11090000, -69434267,  -7850000,  0x026000d},
        {-74004000,  -10050000, -71585069,  -7100000,  0x4290015},
        {-74004000,  -11156000, -66610000,  -7100000,  0x0010016},
        {-74004000,  -11156000, -66610000,  -7100000,  0x0020217},
        {-49296589,  -25489045, -49201450,  -25402555, 0x001000a}, // 6PR
        {-49480000,  -25707000, -49014305,  -25168441, 0x022000c},
        {-52063000,  -23475000, -51841695,  -23365000, 0x680044b},
        {-51217400,  -23380500, -51041549,  -23242000, 0x680044b},
        {-50233000,  -25155500, -50014310,  -25042801, 0x680044b},
        {-54601000,  -25592000, -54491253,  -25441500, 0x54f044b},
        {-53534770,  -25014200, -53386172,  -24903501, 0x54f044b},
        {-51538910,  -25450010, -51403691,  -25327701, 0x54f004b},
        {-48620610,  -25618710, -48485391,  -25496401, 0x54f004b},
        {-51516621,  -23625710, -51383780,  -23503401, 0x54f004b},
        {-53803070,  -24793510, -53668530,  -24671201, 0x54f004b},
        {-51504121,  -23470510, -51371280,  -23348201, 0x54f004b},
        {-51402000,  -23346000, -51213246,  -23260000, 0x54f044b},
        {-49606010,  -25514710, -49470791,  -25392401, 0x54f004b},
        {-53374060,  -23832410, -53240540,  -23710101, 0x54f004b},
        {-52448260,  -24086410, -52314740,  -23964101, 0x54f004b},
        {-51200000,  -26322000, -48018000,  -23898480, 0x0990011},
        {-53880000,  -26755000, -51200000,  -23900830, 0x021000d},
        {-54623000,  -25705000, -54230000,  -25110000, 0x0de0090},
        {-54230000,  -25670000, -53880000,  -25110000, 0x0e50890},
        {-54451500,  -25110000, -53880000,  -24739784, 0x0911090},
        {-54379592,  -24739820, -53869208,  -24248780, 0x0b11890},
        {-54379592,  -24248780, -53869208,  -23757740, 0x0b02090},
        {-54068153,  -23905052, -53562977,  -23414012, 0x0b12890},
        {-53562977,  -23905052, -53057801,  -23414012, 0x0b13090},
        {-53057801,  -23905052, -52552625,  -23414012, 0x0b13890},
        {-52552625,  -23905052, -52047449,  -23414012, 0x0b14090},
        {-52047449,  -23905052, -51542273,  -23414012, 0x0b14890},
        {-51542273,  -23905052, -51037097,  -23414012, 0x0b15090},
        {-51037097,  -23905052, -50531921,  -23414012, 0x0b15890},
        {-50531921,  -23905052, -50026745,  -23414012, 0x0b16090},
        {-50026745,  -23905052, -49521569,  -23414012, 0x0b16890},
        {-54068153,  -23414012, -53562977,  -22922972, 0x0b17090},
        {-53562977,  -23414012, -53057801,  -22922972, 0x0b17890},
        {-53057801,  -23414012, -52552625,  -22922972, 0x0b18090},
        {-52552625,  -23414012, -52047449,  -22922972, 0x0b18890},
        {-52047449,  -23414012, -51542273,  -22922972, 0x0b19090},
        {-51542273,  -23414012, -51037097,  -22922972, 0x0b19890},
        {-51037097,  -23414012, -50531921,  -22922972, 0x0b1a090},
        {-50531921,  -23414012, -50026745,  -22922972, 0x0b1a890},
        {-50026745,  -23414012, -49521569,  -22922972, 0x0b1b090},
        {-53562977,  -23001040, -53057801,  -22510000, 0x0b0b890},
        {-53057801,  -23001040, -52552625,  -22510000, 0x0b0c090},
        {-52552625,  -23001040, -52047449,  -22510000, 0x0b0c890},
        {-52047449,  -23001040, -51542273,  -22510000, 0x0b0d090},
        {-51542273,  -23001040, -51037097,  -22510000, 0x0b0d890},
        {-51037105,  -22922972, -49945000,  -22765036, 0x044e090},
        {-54640000,  -26755000, -48018000,  -22510000, 0x0020217},
        {-60755401,  2790454,   -60641900,  2858456,   0x018000a}, // 6RR
        {-60908360,  2570480,   -60439640,  3061520,   0x001000c},
        {-61302280,  1649820,   -60956321,  1995779,   0xf04004b},
        {-60592945,  773900,    -60258056,  1108789,   0xe89004b},
        {-61557950,  -79738,    -58876760,  2601452,   0x0a80011},
        {-61557950,  2601452,   -58876760,  5282642,   0x001000d},
        {-64239140,  1260857,   -61557950,  3942047,   0x0010015},
        {-64863000,  -1625000,  -58842000,  5282642,   0x0010016},
        {-64863000,  -1625000,  -58842000,  5282642,   0x0020217},
        {-63919000,  -8818700,  -63833094,  -8730600,  0x001000a}, // 6RO
        {-63992460,  -9063920,  -63518532,  -8572880,  0x001000c},
        {-62060548,  -11007510, -61811852,  -10762891, 0xa9e004b},
        {-63174508,  -10034310, -62926492,  -9789691,  0xa9e004b},
        {-60267467,  -12860210, -60016733,  -12615591, 0xa9e004b},
        {-61565914,  -11523490, -61332687,  -11294711, 0x9ee004b},
        {-64673247,  -10800000, -61450000,  -8571405,  0x08c0011},
        {-62355262,  -13700000, -59760000,  -10800000, 0x021000d},
        {-65368000,  -13145000, -62355262,  -10744627, 0x3600015},
        {-66885000,  -13742000, -59677000,  -7874000,  0x0010016},
        {-66885000,  -13742000, -59677000,  -7874000,  0x0020217},
        {-46700000,  -23614000, -46613695,  -23521931, 0x021000a}, // 6SP
        {-46900000,  -23789520, -46313344,  -23378000, 0x01a000c},
        {-47141848,  -22996000, -47077889,  -22869400, 0x3c1044b},
        {-47078400,  -22955500, -47007226,  -22841700, 0x3c1044b},
        {-45941968,  -23257200, -45848032,  -23170711, 0x3c1004b},
        {-47861368,  -21227200, -47768633,  -21140711, 0x3c1004b},
        {-47535568,  -23576100, -47441632,  -23489611, 0x3c1004b},
        {-46393509,  -23997500, -46299092,  -23911011, 0x3c1004b},
        {-49437328,  -20854400, -49345073,  -20767911, 0x3c1004b},
        {-47694248,  -22767000, -47600552,  -22680511, 0x3c1004b},
        {-49131608,  -22370500, -49038392,  -22284011, 0x3c1004b},
        {-46479409,  -24030300, -46384992,  -23943811, 0x3c1004b},
        {-46244368,  -23577100, -46150432,  -23490611, 0x3c1004b},
        {-46929468,  -23252400, -46835532,  -23165911, 0x3c1004b},
        {-47450028,  -20576000, -47357773,  -20489511, 0x3c1004b},
        {-46303509,  -24014500, -46209092,  -23928011, 0x3c1004b},
        {-47458208,  -22615500, -47364992,  -22529011, 0x3c1004b},
        {-46314768,  -23603700, -46220832,  -23517211, 0x3c1004b},
        {-45619548,  -23070300, -45525852,  -22983811, 0x3c1004b},
        {-47496068,  -23494800, -47402132,  -23408311, 0x3c1004b},
        {-46559409,  -24083600, -46464992,  -23997111, 0x3c1004b},
        {-47313437,  -22841150, -47246163,  -22779051, 0x2b2004b},
        {-49978398,  -22258160, -49913603,  -22198041, 0x29c004b},
        {-45996623,  -23333550, -45929177,  -23271451, 0x2b2004b},
        {-51440298,  -22153760, -51375503,  -22093641, 0x29c004b},
        {-47925278,  -22055250, -47858522,  -21993151, 0x2b2004b},
        {-47362765,  -22770960, -47297636,  -22710841, 0x29c004b},
        {-46963823,  -23567550, -46896377,  -23505451, 0x2b2004b},
        {-48201214,  -21819460, -48136586,  -21759341, 0x29c004b},
        {-47231237,  -22901750, -47163963,  -22839651, 0x2b2004b},
        {-47438165,  -22783060, -47373036,  -22722941, 0x29c004b},
        {-47598665,  -22436050, -47531736,  -22373951, 0x2b2004b},
        {-50480731,  -21238760, -50416270,  -21178641, 0x29c004b},
        {-46962823,  -23637150, -46895377,  -23575051, 0x2b2004b},
        {-47248748,  -23133660, -47183452,  -23073541, 0x29c004b},
        {-46771323,  -23318050, -46703877,  -23255951, 0x2b2004b},
        {-47329748,  -23302760, -47264452,  -23242641, 0x29c004b},
        {-45494937,  -22966350, -45427663,  -22904251, 0x2b2004b},
        {-46970198,  -22382460, -46905403,  -22322341, 0x29c004b},
        {-48079223,  -23627150, -48011777,  -23565051, 0x2b2004b},
        {-46573765,  -22984160, -46508636,  -22924041, 0x29c004b},
        {-46469096,  -23916250, -46401305,  -23854151, 0x2b2004b},
        {-48592498,  -22320460, -48527703,  -22260341, 0x29c004b},
        {-48494337,  -22920350, -48427063,  -22858251, 0x2b2004b},
        {-49006331,  -21166160, -48941870,  -21106041, 0x29c004b},
        {-48628000,  -24399539, -44156000,  -22688818, 0x06c0011},
        {-51761505,  -22688818, -48931360,  -20007628, 0x001000d},
        {-48931360,  -22688818, -46101215,  -20007628, 0x0010015},
        {-53228000,  -25304000, -44099000,  -19663000, 0x0010016},
        {-53228000,  -25310000, -44099000,  -19663000, 0x0020217},
        {-42829445,  -5135745,  -42742955,  -5049255,  0x001000a}, // 6PI
        {-42863960,  -5404120,  -42395240,  -4913080,  0x001000c},
        {-41871310,  -3045610,  -41626691,  -2800991,  0xa9e004b},
        {-41533129,  -7207510,  -41286472,  -6962891,  0xa9e004b},
        {-43120489,  -6933710,  -42874511,  -6689091,  0xa9e004b},
        {-41892507,  -4314190,  -41663093,  -4085411,  0x9ee004b},
        {-43105000,  -5928842,  -40872000,  -2745000,  0x0c90011},
        {-43500000,  -8220000,  -40368000,  -5928842,  0x01a000d},
        {-46000000,  -10936000, -43374611,  -8220000,  0x3d50015},
        {-46230000,  -11049000, -40276000,  -2592000,  0x0010016},
        {-46230000,  -11049000, -40276000,  -2592000,  0x0020217},
        {-48499863,  -10456980, -48148138,  -10111021, 0xf040047}, // 6TO
        {-48392840,  -7371400,  -48055161,  -7036511,  0xe890047},
        {-49216603,  -11880370, -48924197,  -11593541, 0xc73004b},
        {-49026088,  -10321910, -48748112,  -10048491, 0xbde004b},
        {-48541988,  -10845210, -48264012,  -10571791, 0xbde004b},
        {-50770000,  -12319522, -48220000,  -9500000,  0x0b20011},
        {-48220000,  -12267681, -45670000,  -9500000,  0x020000d},
        {-49031680,  -9500000,  -47380000,  -5166000,  0x6160015},
        {-50998000,  -13603000, -45527300,  -5003000,  0x0010016},
        {-50998000,  -13603000, -45527300,  -5003000,  0x0020217},
        {-51252211,  -30093445, -51153228,  -30006955, 0x001000a}, // 6RS
        {-51375000,  -30219200, -50925097,  -29654655, 0x024000c},
        {-51257988,  -29244480, -51087013,  -29094721, 0x680004b},
        {-52450000,  -31787500, -52216319,  -31675021, 0x680044b},
        {-53901504,  -29750000, -53644413,  -29650000, 0x680044b},
        {-52191592,  -32132780, -52015209,  -31983021, 0x680004b},
        {-52482756,  -28334580, -52313445,  -28184821, 0x680004b},
        {-57149204,  -29868580, -56977397,  -29718821, 0x680004b},
        {-52541904,  -29798880, -52370097,  -29649121, 0x680004b},
        {-54174547,  -31392510, -54031853,  -31270201, 0x54f004b},
        {-52391000,  -27690000, -52172605,  -27613000, 0x54f044b},
        {-55607737,  -30955010, -55466063,  -30832701, 0x54f004b},
        {-51546000,  -29315000, -51452499,  -29132400, 0x54f044b},
        {-55849658,  -29858910, -55709343,  -29736601, 0x54f004b},
        {-52964002,  -29562200, -49688000,  -27170000, 0x0980011},
        {-56037296,  -31620000, -52943703,  -29025300, 0x01e000d},
        {-52943703,  -32250000, -49888000,  -29562200, 0x3c50015},
        {-57788100,  -33750000, -49482400,  -26922070, 0x0010016},
        {-57788100,  -33752000, -49482400,  -26922070, 0x0020217},
        {-44315645,  -2568745,  -44229155,  -2482255,  0x001000a}, // 6MA
        {-44426241,  -2957400,  -44018000,  -2403000,  0x023000c},
        {-47513870,  -5584290,  -47339930,  -5411311,  0x782004b},
        {-42967130,  -5200190,  -42793671,  -5027211,  0x782004b},
        {-43480730,  -4980490,  -43307271,  -4807511,  0x782004b},
        {-47576330,  -5031890,  -47402871,  -4858911,  0x782004b},
        {-44862188,  -4300780,  -44712013,  -4151021,  0x680004b},
        {-45450388,  -3736280,  -45300213,  -3586521,  0x680004b},
        {-46134304,  -7606180,  -45983297,  -7456421,  0x680004b},
        {-43409988,  -3810280,  -43259813,  -3660521,  0x680004b},
        {-45322796,  -5579680,  -45172205,  -5429921,  0x680004b},
        {-44900000,  -5598472,  -42798000,  -2245000,  0x0d50011},
        {-47755000,  -5598472,  -44900000,  -3176752,  0x01c000d},
        {-46318872,  -7645000,  -42823000,  -5598472,  0x2e10015},
        {-48758700,  -10336500, -41785100,  -950200,   0x0010016},
        {-48758700,  -10336500, -41785100,  -950200,   0x0020217},
        {-49318706,  -16734045, -49229333,  -16647555, 0x001000a}, // 6GO
        {-49548368,  -16979419, -49064024,  -16488379, 0x001000c},
        {-49099802,  -16426140, -48879798,  -16214371, 0x931004b},
        {-48046419,  -16281250, -47879616,  -16048600, 0x864044b},
        {-51040724,  -17881960, -50838276,  -17688641, 0x864004b},
        {-48398550,  -15837160, -48198250,  -15643841, 0x864004b},
        {-49326493,  -18510660, -49123508,  -18317341, 0x864004b},
        {-47441250,  -15634560, -47240950,  -15441241, 0x864004b},
        {-50542216,  -17000000, -46800000,  -15042000, 0x07b0011},
        {-51267409,  -18650000, -47127000,  -17000000, 0x014000d},
        {-50051280,  -15042000, -46800000,  -12788000, 0x32a0015},
        {-53272700,  -19497600, -45892600,  -12318500, 0x0010016},
        {-53272700,  -19497600, -45892600,  -12318500, 0x0020217},
        {-54657967,  -20506645, -54566672,  -20420155, 0x001000a}, // 6MS
        {-54923576,  -20694320, -54428816,  -20203280, 0x001000c},
        {-54916187,  -22278590, -54669614,  -22049811, 0x9ee004b},
        {-57742067,  -19185440, -57518533,  -18973671, 0x931004b},
        {-51847944,  -20909840, -51622057,  -20698071, 0x931004b},
        {-55775620,  -22626140, -55547380,  -22414371, 0x931004b},
        {-54316408,  -23168240, -54086992,  -22956471, 0x931004b},
        {-55819968,  -24104595, -52960032,  -21423405, 0x0a90011},
        {-55761577,  -21423405, -52961223,  -18742215, 0x001000d},
        {-52960000,  -22380000, -50918000,  -18733096, 0x5250015},
        {-58260500,  -24146700, -50866600,  -17161700, 0x0010016},
        {-58260500,  -24146700, -50866600,  -17161700, 0x0020217},
        {-38534706,  -13018145, -38446294,  -12931655, 0x001000a}, // 6BA
        {-38537968,  -13023320, -38058832,  -12532280, 0x001000c},
        {-39037244,  -12333880, -38884157,  -12184121, 0x680004b},
        {-40923976,  -14939080, -40769225,  -14789321, 0x680004b},
        {-39360376,  -14879080, -39205625,  -14729321, 0x680004b},
        {-40586512,  -9484580,  -40435089,  -9334821,  0x680004b},
        {-39165976,  -14896280, -39011225,  -14746521, 0x680004b},
        {-45080836,  -12193280, -44928165,  -12043521, 0x680004b},
        {-40164060,  -13933280, -40010141,  -13783521, 0x680004b},
        {-38496914,  -12203710, -38371887,  -12081401, 0x54f004b},
        {-39801642,  -17602010, -39673558,  -17479701, 0x54f004b},
        {-39152403,  -16478810, -39024998,  -16356501, 0x54f004b},
        {-38297134,  -9459010,  -38173466,  -9336701,  0x54f004b},
        {-39637203,  -16420610, -39509798,  -16298301, 0x54f004b},
        {-41000000,  -17950000, -38830000,  -14420000, 0x028000d},
        {-41000000,  -14420000, -37935000,  -12050000, 0x0950011},
        {-45758320,  -13680597, -43047339,  -10999407, 0x0010015},
        {-46714000,  -18437900, -37287600,  -8407200,  0x0010016},
        {-46714000,  -18437900, -37287600,  -8407200,  0x0020217},
        {-43988500,  -19951400, -43902900,  -19860000, 0x021000a}, // 6MG
        {-44255176,  -20110620, -43760416,  -19619580, 0x001000c},
        {-48341082,  -18974510, -48212318,  -18852201, 0x54f004b},
        {-43444041,  -21817310, -43312559,  -21695001, 0x54f004b},
        {-43918603,  -16790010, -43791198,  -16667701, 0x54f004b},
        {-48000792,  -19805710, -47871009,  -19683401, 0x54f004b},
        {-42003627,  -18914200, -41912574,  -18827711, 0x3c1004b},
        {-42597187,  -19512100, -42505413,  -19425611, 0x3c1004b},
        {-44279587,  -19495600, -44187813,  -19409111, 0x3c1004b},
        {-44929207,  -20192800, -44837193,  -20106311, 0x3c1004b},
        {-46613588,  -21859800, -46520613,  -21773311, 0x3c1004b},
        {-46551827,  -18635200, -46460774,  -18548711, 0x3c1004b},
        {-43813668,  -21264500, -43720933,  -21178011, 0x3c1004b},
        {-45484188,  -21605800, -45391213,  -21519311, 0x3c1004b},
        {-45981408,  -22270900, -45888192,  -22184411, 0x3c1004b},
        {-43832928,  -20708400, -43740673,  -20621911, 0x3c1004b},
        {-41549487,  -17910500, -41458914,  -17824011, 0x3c1004b},
        {-42675587,  -19567400, -42583813,  -19480911, 0x3c1004b},
        {-43273587,  -19675800, -43181813,  -19589311, 0x3c1004b},
        {-46652028,  -20761300, -46559773,  -20674811, 0x3c1004b},
        {-48241027,  -18688500, -48149974,  -18602011, 0x3c1004b},
        {-42427668,  -21174200, -42334933,  -21087711, 0x3c1004b},
        {-42990668,  -21161000, -42897933,  -21074511, 0x3c1004b},
        {-49511447,  -19026900, -49420153,  -18940411, 0x3c1004b},
        {-46995087,  -19640600, -46903313,  -19554111, 0x3c1004b},
        {-45508208,  -22471200, -45414992,  -22384711, 0x3c1004b},
        {-45041068,  -21292700, -44948333,  -21206211, 0x3c1004b},
        {-44292568,  -21171800, -44199833,  -21085311, 0x3c1004b},
        {-44631007,  -20117200, -44538993,  -20030711, 0x3c1004b},
        {-45127562,  -21875992, -42297417,  -19194802, 0x0a80011},
        {-44107220,  -19194802, -41336657,  -16513612, 0x0010015},
        {-49676877,  -20418600, -46166215,  -18316200, 0x018000d},
        {-51090000,  -22958400, -39800000,  -14200000, 0x0010016},
        {-51090000,  -22958400, -39800000,  -14200000, 0x0020217},
        {-56143500,  -15636000, -56031600,  -15569041, 0x018000a}, // 6MT
        {-56364768,  -15878020, -55880424,  -15386980, 0x001000c},
        {-54746087,  -16684580, -54385713,  -16338621, 0xf04004b},
        {-55594900,  -12018300, -55253500,  -11683411, 0xe89004b},
        {-56749719,  -17462941, -53979156,  -14781751, 0x0a80011},
        {-56764795,  -13191495, -54053814,  -10510305, 0x001000d},
        {-61655000,  -11140000, -58557582,  -8795000,  0x3490015},
        {-61680000,  -18150000, -50140000,  -7300000,  0x0010016},
        {-61680000,  -18150000, -50140000,  -7300000,  0x0020217},
        {-48507750,  -1478750,  -48440500,  -1372730,  0x026000a}, // 6PA
        {-48510000,  -1478500,  -47866537,  -1130020,  0x016000c},
        {-51234790,  -100090,   -51006011,  128689,    0x9ee004b},
        {-54877485,  -2607440,  -54665716,  -2395671,  0x931004b},
        {-49208679,  -5440000,  -49020870,  -5200671,  0x931044b},
        {-48982785,  -1778440,  -48771016,  -1566671,  0x931004b},
        {-48786985,  -1644440,  -48575216,  -1432671,  0x931004b},
        {-50217495,  -3013195,  -47536305,  -332005,   0x0a80011},
        {-56112195,  -4914671,  -53431005,  -2233481,  0x001000d},
        {-50493427,  -5927971,  -47812237,  -3246781,  0x0010015},
        {-58920000,  -9880000,  -45990000,  2640000,   0x0010016},
        {-58920000,  -9880000,  -45990000,  2640000,   0x0020217},
        {-60074000,  -3150750,  -59968000,  -3081000,  0x019000a}, // 6AM
        {-60261160,  -3325920,  -59792440,  -2834880,  0x001000c},
        {-56865690,  -2767690,  -56636911,  -2538911,  0x9ee004b},
        {-60747185,  -3343140,  -60535416,  -3131371,  0x931004b},
        {-58543085,  -3178340,  -58331316,  -2966571,  0x931004b},
        {-64858979,  -3404640,  -64646622,  -3192871,  0x931004b},
        {-63213679,  -4249240,  -63001322,  -4037471,  0x931004b},
        {-61450595,  -4440595,  -58769405,  -1759405,  0x0a80011},
        {-58769405,  -4440595,  -56088215,  -1759405,  0x001000d},
        {-65240000,  -4841911,  -61450595,  -2947500,  0x2a70015},
        {-73820000,  -9847000,  -56087000,  2245000,   0x3070016},
        {-73820000,  -9847000,  -56087000,  2245000,   0x0020217},
        {-77074777,  38866755,  -76964262,  38953245,  0x001000a}, // 1DC
        {-77120000,  38789750,  -76908000,  38997000,  0x001000c},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-77120000,  38789750,  -76908000,  38997000,  0x0020217},
        {-71470860,  41778255,  -71355540,  41864745,  0x001000a}, // 1RI
        {-71812000,  41648000,  -71118000,  42023000,  0x019000c},
        {-71888000,  41300000,  -71118000,  41648000,  0x0850010},
        {-73733000,  40977000,  -69800000,  42887549,  0x0870011},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-71888000,  41140000,  -71118000,  42030000,  0x0020217},
        {-75607738,  39702755,  -75496262,  39789245,  0x001000a}, // 1DE
        {-75788000,  39085000,  -75395500,  39840000,  0x02f000c},
        {-75645759,  38495484,  -75052047,  38986524,  0x0b10010},
        {-75788000,  38451000,  -75000000,  39840000,  0x0fc0011},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-75788000,  38451000,  -75000000,  39840000,  0x0020217},
        {-73244199,  41146555,  -73129840,  41233045,  0x001000a}, // 1CT
        {-73144600,  41417950,  -72464873,  41861450,  0x01c000c},
        {-73228006,  41143840,  -72972395,  41337159,  0x864004b},
        {-73447831,  41066512,  -73192220,  41259831,  0x864004b},
        {-73703442,  40979518,  -73447831,  41172837,  0x864004b},
        {-72979659,  41241510,  -72750942,  41414489,  0x782004b},
        {-73550659,  41309310,  -73321942,  41482289,  0x782004b},
        {-72208020,  41462110,  -71977381,  41635089,  0x782004b},
        {-72223359,  41294610,  -71994642,  41467589,  0x782004b},
        {-73733000,  40977000,  -69800000,  42887549,  0x0870011},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-73735000,  40977000,  -71786994,  42050588,  0x0020217},
        {-74071380,  40741500,  -73996056,  40806566,  0x2a7044a}, // 1NJ
        {-74107482,  40687708,  -74016431,  40741500,  0x2a7044a},
        {-74494550,  40494880,  -73936844,  41038539,  0x022000c},
        {-74495224,  40280410,  -74197176,  40509189,  0x9ee004b},
        {-74294444,  39891860,  -74018556,  40103629,  0x931004b},
        {-74811944,  40111160,  -74536056,  40322929,  0x931004b},
        {-75144668,  39820160,  -74871133,  40031929,  0x931004b},
        {-75276600,  39356864,  -74942150,  39530000,  0x931044b},
        {-75583000,  38923000,  -73885000,  41358000,  0x0e40011},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-75583000,  38923000,  -73885000,  41358000,  0x0020217},
        {-71517521,  42937055,  -71400279,  43023545,  0x001000a}, // 1NH
        {-71623077,  42696800,  -70765000,  43068000,  0x017000c},
        {-71726357,  43065990,  -71392044,  43310609,  0xa9e004b},
        {-70936298,  42977290,  -70604703,  43221909,  0xa9e004b},
        {-71020555,  43221909,  -70686242,  43466528,  0xa9e004b},
        {-72433062,  42819610,  -72122939,  43048389,  0x9ee004b},
        {-73435000,  42696800,  -70575000,  45306000,  0x0bb0011},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-72577000,  42696800,  -70575000,  45306000,  0x0020217},
        {-73248082,  44440355,  -73127957,  44526845,  0x001000a}, // 1VT
        {-73343196,  44340280,  -72692196,  44831320,  0x001000c},
        {-72866296,  43977280,  -72220504,  44468320,  0x0b00010},
        {-73435000,  42696800,  -70575000,  45306000,  0x0bb0011},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-73435000,  42725000,  -71445000,  45020000,  0x0020217},
        {-71125360,  42322755,  -71009079,  42409245,  0x001000a}, // 1MA
        {-71423580,  42107380,  -70793412,  42598420,  0x001000c},
        {-71918281,  42176510,  -71685720,  42349489,  0x782004b},
        {-72682981,  42057710,  -72450420,  42230689,  0x782004b},
        {-71433242,  42546510,  -71198759,  42719489,  0x782004b},
        {-71038720,  41572410,  -70808081,  41745389,  0x782004b},
        {-71235504,  42659120,  -71032497,  42808879,  0x680004b},
        {-71118672,  41981120,  -70917329,  42130879,  0x680004b},
        {-71255440,  41644220,  -71055761,  41793979,  0x680004b},
        {-71188240,  41825320,  -70988561,  41975079,  0x680004b},
        {-73332472,  42380420,  -73131129,  42530179,  0x680004b},
        {-73733000,  40977000,  -69800000,  42887549,  0x0870011},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-73508143,  41227770,  -69858861,  42887549,  0x0020217},
        {-157904128, 21307000,  -157811682, 21350245,  0x2a7044a}, // 1HI
        {-157882000, 21268000,  -157779518, 21307000,  0x2a7044a},
        {-158283000, 21290000,  -157989062, 21590000,  0xc730447},
        {-158156000, 21480000,  -157822111, 21720000,  0xbde0447},
        {-157989062, 21250000,  -157640698, 21480000,  0xbde0447},
        {-156700000, 20574000,  -156170000, 21032000,  0x0a50010},
        {-160300000, 21700000,  -159260000, 22300000,  0x004010c},
        {-158310000, 21200000,  -157607000, 21812000,  0x004010c},
        {-157415000, 20444000,  -155920000, 21280000,  0x004010c},
        {-156100000, 18880000,  -154772000, 20280000,  0x004010c},
        {-177512700, 28095368,  -177252300, 28340888,  0x004010c},
        {-162101772, 22890364,  -161747628, 23234092,  0x004010c},
        {-164828492, 23462168,  -164578508, 23707688,  0x004010c},
        {-166357112, 23556184,  -165950888, 23949016,  0x004010c},
        {-171853592, 25656968,  -171598400, 25902488,  0x004010c},
        {-174087292, 25945968,  -173832100, 26191488,  0x004010c},
        {-176000580, 27655636,  -175636020, 27999364,  0x004010c},
        {-178415076, 28290136,  -178185924, 28502920,  0x004010c},
        {-178424000, 18840000,  -154500000, 28503000,  0x2640016},
        {-178424000, 18840000,  -154500000, 28503000,  0x0020217},
        {-76666277,  39255355,  -76555762,  39341845,  0x001000a}, // 1MD
        {-76906256,  39053080,  -76307336,  39544120,  0x001000c},
        {-77339985,  39014260,  -77068215,  39226029,  0x931004b},
        {-77102747,  38906340,  -76854654,  39099659,  0x864004b},
        {-77044841,  38507840,  -76798359,  38701159,  0x864004b},
        {-77569552,  39328840,  -77319848,  39522159,  0x864004b},
        {-77841152,  39528940,  -77591448,  39722259,  0x864004b},
        {-77180352,  39499840,  -76930648,  39693159,  0x864004b},
        {-79487651,  37886607,  -75042000,  39723622,  0x0790011},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-79487651,  37886607,  -75042000,  39723622,  0x0020217},
        {-81773520,  38334000,  -81584816,  38384800,  0x012000a}, // 1WV
        {-82606888,  38259000,  -81424419,  38493000,  0x00f000c},
        {-81648347,  39226040,  -81415616,  39432000,  0x864044b},
        {-80753726,  40303040,  -80501874,  40496359,  0x864004b},
        {-80080852,  39533340,  -79831148,  39726659,  0x864004b},
        {-80798250,  39903000,  -80631405,  40136500,  0x782044b},
        {-80254716,  39398510,  -80031285,  39571489,  0x782004b},
        {-81296593,  37691510,  -81079408,  37864489,  0x782004b},
        {-78075716,  39369510,  -77852285,  39542489,  0x782004b},
        {-80876000,  40186000,  -80510000,  40644000,  0x001008c},
        {-80876000,  39730000,  -80510000,  40188000,  0x001088c},
        {-81750912,  39239362,  -81151992,  39730402,  0x001108c},
        {-81151992,  39239362,  -80553072,  39730402,  0x001188c},
        {-80553072,  39239362,  -79954152,  39730402,  0x001208c},
        {-79954152,  39239362,  -79355232,  39730402,  0x001288c},
        {-79355232,  39239362,  -78756312,  39730402,  0x001308c},
        {-78756312,  39239362,  -78157392,  39730402,  0x001388c},
        {-78170000,  39130000,  -77719000,  39700000,  0x026408c},
        {-82469615,  38748322,  -81875903,  39239362,  0x001488c},
        {-81875903,  38748322,  -81282191,  39239362,  0x001508c},
        {-81282191,  38748322,  -80688479,  39239362,  0x001588c},
        {-80688480,  38748322,  -80094768,  39239362,  0x001608c},
        {-80094768,  38748322,  -79501056,  39239362,  0x001688c},
        {-79501056,  38748322,  -78907344,  39239362,  0x001708c},
        {-78907343,  38748322,  -78313631,  39239362,  0x001788c},
        {-82600961,  38257282,  -82012457,  38748322,  0x001808c},
        {-82012457,  38257282,  -81423953,  38748322,  0x001888c},
        {-81423953,  38257282,  -80835449,  38748322,  0x001908c},
        {-80835449,  38257282,  -80246945,  38748322,  0x001988c},
        {-80246945,  38257282,  -79658441,  38748322,  0x001a08c},
        {-79658441,  38257282,  -79069937,  38748322,  0x001a88c},
        {-82644739,  37766242,  -82056235,  38257282,  0x001b08c},
        {-82071308,  37766242,  -81482804,  38257282,  0x001b88c},
        {-81482804,  37766242,  -80894300,  38257282,  0x001c08c},
        {-80894300,  37766242,  -80305796,  38257282,  0x001c88c},
        {-80305796,  37766242,  -79717292,  38257282,  0x001d08c},
        {-82340000,  37273000,  -81770000,  37766242,  0x001d88c},
        {-81770000,  37201483,  -81297000,  37767725,  0x025e08c},
        {-81297000,  37230000,  -80806000,  37766242,  0x023e88c},
        {-80806000,  37275202,  -80217520,  37766242,  0x001f08c},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-82644739,  37201483,  -77718935,  40644000,  0x0020217},
        {-81056966,  33961290,  -80983635,  34022399,  0x2a7004a}, // 1SC
        {-79992641,  32767890,  -79920159,  32828999,  0x2a7004a},
        {-80318324,  32644480,  -79766276,  33135520,  0x001000c},
        {-81162062,  33895160,  -80907939,  34106929,  0x931004b},
        {-81142334,  34828340,  -80907666,  35021659,  0x864004b},
        {-82511334,  34756340,  -82276666,  34949659,  0x864004b},
        {-80514992,  33823340,  -80283009,  34016659,  0x864004b},
        {-80885544,  32117540,  -80657857,  32310859,  0x864004b},
        {-79916797,  34131940,  -79683203,  34325259,  0x864004b},
        {-83363396,  34724960,  -82795724,  35216000,  0x001008c},
        {-82795724,  34724960,  -82228052,  35216000,  0x001088c},
        {-82228052,  34724960,  -81660380,  35216000,  0x001108c},
        {-81660380,  34724960,  -81092708,  35216000,  0x001188c},
        {-81092708,  34724960,  -80525036,  35216000,  0x001208c},
        {-83363396,  34331628,  -82800932,  34822668,  0x001288c},
        {-82800932,  34331628,  -82238468,  34822668,  0x001308c},
        {-82238468,  34331628,  -81676004,  34822668,  0x001388c},
        {-81676004,  34331628,  -81113540,  34822668,  0x001408c},
        {-81113540,  34331628,  -80551076,  34822668,  0x001488c},
        {-80551076,  34331628,  -79988612,  34822668,  0x001508c},
        {-79988612,  34331628,  -79426148,  34822668,  0x001588c},
        {-79426148,  34331628,  -78863684,  34822668,  0x001608c},
        {-82857178,  33840588,  -82294714,  34331628,  0x001688c},
        {-82294714,  33840588,  -81732250,  34331628,  0x001708c},
        {-81732250,  33840588,  -81169786,  34331628,  0x001788c},
        {-81169786,  33840588,  -80607322,  34331628,  0x001808c},
        {-80607322,  33840588,  -80044858,  34331628,  0x001888c},
        {-80044858,  33840588,  -79482394,  34331628,  0x001908c},
        {-79482394,  33840588,  -78919930,  34331628,  0x001988c},
        {-79090464,  33840588,  -78528000,  34331628,  0x001a08c},
        {-82373875,  33349548,  -81816619,  33840588,  0x001a88c},
        {-81816619,  33349548,  -81259363,  33840588,  0x001b08c},
        {-81259363,  33349548,  -80702107,  33840588,  0x001b88c},
        {-80702107,  33349548,  -80144851,  33840588,  0x001c08c},
        {-80144851,  33349548,  -79587595,  33840588,  0x001c88c},
        {-79587595,  33349548,  -79030339,  33840588,  0x001d08c},
        {-79085256,  33349548,  -78528000,  33840588,  0x001d88c},
        {-81956024,  32858508,  -81403976,  33349548,  0x0b16090},
        {-81403976,  32858508,  -80851928,  33349548,  0x0b16890},
        {-80851928,  32858508,  -80299880,  33349548,  0x0b17090},
        {-80299880,  32858508,  -79747832,  33349548,  0x0b17890},
        {-79747832,  32858508,  -79195784,  33349548,  0x0b18090},
        {-79195784,  32858508,  -78643736,  33349548,  0x0b18890},
        {-81514385,  32367468,  -80962337,  32858508,  0x0b09090},
        {-80962337,  32367468,  -80410289,  32858508,  0x0b09890},
        {-80410289,  32367468,  -79858241,  32858508,  0x0b0a090},
        {-79858241,  32367468,  -79306193,  32858508,  0x0b0a890},
        {-81233153,  32032000,  -80686313,  32523040,  0x0b1b090},
        {-80686313,  32032000,  -80139473,  32523040,  0x0b1b890},
        {-94618000,  24450000,  -75350000,  36688000,  0x30e0216},
        {-83366000,  32032000,  -78528000,  35216000,  0x0020217},
        {-70344382,  43617755,  -70225218,  43704245,  0x001000a}, // 1ME
        {-70508088,  43482280,  -69867504,  43973320,  0x001000c},
        {-70383516,  43977690,  -70046485,  44222309,  0xa9e004b},
        {-68939673,  44709990,  -68596527,  44954609,  0xa9e004b},
        {-70636657,  43369790,  -70302344,  43614409,  0xa9e004b},
        {-70002092,  44198310,  -69683708,  44427089,  0x9ee004b},
        {-70723900,  45495527,  -70062484,  45986567,  0x001008c},
        {-70062484,  45495527,  -69401068,  45986567,  0x001088c},
        {-69401068,  45495527,  -68739652,  45986567,  0x001108c},
        {-68739652,  45495527,  -68078236,  45986567,  0x001188c},
        {-68078236,  45495527,  -67416820,  45986567,  0x001208c},
        {-71084335,  45004487,  -70428127,  45495527,  0x001288c},
        {-70464541,  45004487,  -69808333,  45495527,  0x001308c},
        {-69808333,  45004487,  -69152125,  45495527,  0x001388c},
        {-69152125,  45004487,  -68495917,  45495527,  0x001408c},
        {-68495917,  45004487,  -67839709,  45495527,  0x001488c},
        {-67839709,  45004487,  -67183501,  45495527,  0x001508c},
        {-67541283,  45004487,  -66885075,  45495527,  0x001588c},
        {-71084335,  44513447,  -70433335,  45004487,  0x001608c},
        {-70464541,  44513447,  -69813541,  45004487,  0x001688c},
        {-69813541,  44513447,  -69162541,  45004487,  0x001708c},
        {-69162541,  44513447,  -68511541,  45004487,  0x001788c},
        {-68511541,  44513447,  -67860541,  45004487,  0x001808c},
        {-67860541,  44513447,  -67209541,  45004487,  0x001888c},
        {-67536075,  44513447,  -66885075,  45004487,  0x001908c},
        {-71050441,  44022407,  -70404649,  44513447,  0x001988c},
        {-70404649,  44022407,  -69758857,  44513447,  0x001a08c},
        {-69758857,  44022407,  -69113065,  44513447,  0x001a88c},
        {-69113065,  44022407,  -68467273,  44513447,  0x001b08c},
        {-68467273,  44022407,  -67821481,  44513447,  0x001b88c},
        {-67821481,  44022407,  -67175689,  44513447,  0x001c08c},
        {-71050441,  43531367,  -70404649,  44022407,  0x001c88c},
        {-70404649,  43531367,  -69758857,  44022407,  0x001d08c},
        {-69758857,  43531367,  -69113065,  44022407,  0x001d88c},
        {-69113065,  43531367,  -68467273,  44022407,  0x001e08c},
        {-70990341,  43040327,  -70349757,  43531367,  0x001e88c},
        {-70635000,  42940000,  -70206000,  43551400,  0x02af08c},
        {-69785459,  46968647,  -69103211,  47459687,  0x0b08890},
        {-69103211,  46968647,  -68420963,  47459687,  0x0b09090},
        {-68420963,  46968647,  -67738715,  47459687,  0x0b09890},
        {-70467707,  46477607,  -69790667,  46968647,  0x0b0a890},
        {-69790667,  46477607,  -69113627,  46968647,  0x0b0b090},
        {-69113627,  46477607,  -68436587,  46968647,  0x0b0b890},
        {-68436587,  46477607,  -67759547,  46968647,  0x0b0c090},
        {-70394795,  45986567,  -69728171,  46477607,  0x0b1c890},
        {-69728171,  45986567,  -69061547,  46477607,  0x0b1e090},
        {-69061547,  45986567,  -68394923,  46477607,  0x0b1e890},
        {-68394923,  45986567,  -67728299,  46477607,  0x0b1f090},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-71084335,  42917000,  -66885075,  47459687,  0x0020217},
        {-86213738,  39724755,  -86102262,  39811245,  0x001000a}, // 1IN
        {-86460064,  39522480,  -85855936,  40013520,  0x001000c},
        {-85227908,  41034320,  -85029893,  41184079,  0x680004b},
        {-86398940,  41611420,  -86199261,  41761179,  0x680004b},
        {-86199261,  41611420,  -85999582,  41761179,  0x680004b},
        {-85999582,  41611420,  -85799903,  41761179,  0x680004b},
        {-87650640,  37933330,  -87380371,  38038100,  0x680044b},
        {-87599840,  41508120,  -87400161,  41657879,  0x680004b},
        {-86622096,  39090120,  -86429905,  39239879,  0x680004b},
        {-87427540,  41531890,  -87264461,  41654199,  0x54f004b},
        {-85469871,  40139590,  -85310530,  40261899,  0x54f004b},
        {-86965071,  40349290,  -86805730,  40471599,  0x54f004b},
        {-87475191,  39402690,  -87317209,  39524999,  0x54f004b},
        {-85749371,  40037790,  -85590030,  40160099,  0x54f004b},
        {-87847387,  41270328,  -87227635,  41761368,  0x001008c},
        {-87227635,  41270328,  -86607883,  41761368,  0x001088c},
        {-86607883,  41270328,  -85988131,  41761368,  0x001108c},
        {-85988131,  41270328,  -85368379,  41761368,  0x001188c},
        {-85399752,  41270328,  -84780000,  41761368,  0x001208c},
        {-87692449,  40779288,  -87077905,  41270328,  0x001288c},
        {-87077905,  40779288,  -86463361,  41270328,  0x001308c},
        {-86463361,  40779288,  -85848817,  41270328,  0x001388c},
        {-85848817,  40779288,  -85234273,  41270328,  0x001408c},
        {-85394544,  40779288,  -84780000,  41270328,  0x001488c},
        {-87687241,  40288248,  -87077905,  40779288,  0x001508c},
        {-87077905,  40288248,  -86468569,  40779288,  0x001588c},
        {-86468569,  40288248,  -85859233,  40779288,  0x001608c},
        {-85859233,  40288248,  -85249897,  40779288,  0x001688c},
        {-85389336,  40288248,  -84780000,  40779288,  0x001708c},
        {-87687241,  39797208,  -87083113,  40288248,  0x001788c},
        {-87083113,  39797208,  -86478985,  40288248,  0x001808c},
        {-86478985,  39797208,  -85874857,  40288248,  0x001888c},
        {-85874857,  39797208,  -85270729,  40288248,  0x001908c},
        {-85384128,  39797208,  -84780000,  40288248,  0x001988c},
        {-87682033,  39306168,  -87083113,  39797208,  0x001a08c},
        {-87083113,  39306168,  -86484193,  39797208,  0x001a88c},
        {-86484193,  39306168,  -85885273,  39797208,  0x001b08c},
        {-85885273,  39306168,  -85286353,  39797208,  0x001b88c},
        {-85378920,  39306168,  -84780000,  39797208,  0x001c08c},
        {-87682033,  38815128,  -87083113,  39306168,  0x001c88c},
        {-87083113,  38815128,  -86484193,  39306168,  0x001d08c},
        {-86484193,  38815128,  -85885273,  39306168,  0x001d88c},
        {-85885273,  38815128,  -85286353,  39306168,  0x001e08c},
        {-85378920,  38815128,  -84780000,  39306168,  0x001e88c},
        {-87771871,  38324088,  -87178159,  38815128,  0x0b10090},
        {-87178159,  38324088,  -86584447,  38815128,  0x0b10890},
        {-86584447,  38324088,  -85990735,  38815128,  0x0b11090},
        {-85990735,  38324088,  -85397023,  38815128,  0x0b11890},
        {-85397023,  38667816,  -84803311,  39158856,  0x0b12090},
        {-88097892,  37767000,  -87720000,  38390000,  0x0f92890},
        {-87720000,  37815000,  -87183367,  38324088,  0x0bd3090},
        {-87183367,  37777000,  -86690000,  38324088,  0x0cc3890},
        {-86690000,  37833048,  -86160000,  38324088,  0x0ba4090},
        {-86160000,  37950000,  -85630000,  38324088,  0x0a34890},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-88097892,  37767000,  -84780000,  41761368,  0x0020217},
        {-84557316,  37990055,  -84448723,  38076545,  0x001000a}, // 1KY
        {-84750700,  37846450,  -84395005,  38271600,  0xf040447},
        {-85904331,  38083100,  -85481069,  38417989,  0xe890047},
        {-86576062,  36884160,  -86311939,  37095929,  0x931004b},
        {-87222862,  37666440,  -86980139,  37859759,  0x864004b},
        {-84590547,  38927940,  -84342454,  39121259,  0x864004b},
        {-87609556,  36769340,  -87368444,  36962659,  0x864004b},
        {-84416362,  37651340,  -84173639,  37844659,  0x864004b},
        {-84821147,  38899140,  -84573054,  39092459,  0x864004b},
        {-89580000,  36490000,  -85451600,  38523000,  0x018000d},
        {-85451600,  36561000,  -81963500,  39144000,  0x0a10011},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-89580000,  36490000,  -81960000,  39144000,  0x0020217},
        {-90069894,  35106755,  -89965145,  35193245,  0x001000a}, // 1TN
        {-90147600,  34993512,  -89623529,  35270700,  0xf040447},
        {-86990050,  35998600,  -86577951,  36333489,  0xe890047},
        {-84103397,  35855160,  -83842804,  36066929,  0x931004b},
        {-85331234,  34981240,  -85096566,  35174559,  0x864004b},
        {-87481151,  36449840,  -87241650,  36643159,  0x864004b},
        {-86508945,  35749340,  -86271055,  35942659,  0x864004b},
        {-88932140,  35537640,  -88695861,  35730959,  0x864004b},
        {-82485000,  36263600,  -82144369,  36399489,  0x864044b},
        {-90313000,  34975000,  -85900000,  36680000,  0x015000d},
        {-85900000,  34975000,  -81646901,  36630000,  0x0730011},
        {-94618000,  24450000,  -75350000,  36688000,  0x30e0216},
        {-90313000,  34975000,  -81646901,  36688000,  0x0020217},
        {-76074816,  36809755,  -75967184,  36896245,  0x001000a}, // 1VA
        {-76530840,  36681180,  -75952752,  37172220,  0x001000c},
        {-77251274,  38767510,  -77030726,  38940489,  0x782004b},
        {-77568593,  37467510,  -77351408,  37640489,  0x782004b},
        {-80067872,  37193510,  -79852129,  37366489,  0x782004b},
        {-76714851,  36638010,  -76500549,  36810989,  0x782004b},
        {-79285516,  37304020,  -79097485,  37453779,  0x680004b},
        {-77471472,  38731120,  -77280529,  38880879,  0x680004b},
        {-77402172,  38564520,  -77211229,  38714279,  0x680004b},
        {-77463196,  38879220,  -77271005,  39028979,  0x680004b},
        {-78959472,  38380320,  -78768529,  38530079,  0x680004b},
        {-78571828,  38975460,  -77972908,  39466500,  0x001008c},
        {-77972908,  38979928,  -77211000,  39333000,  0x017088c},
        {-79769668,  38488888,  -79175956,  38979928,  0x001108c},
        {-79175956,  38488888,  -78582244,  38979928,  0x001188c},
        {-78582244,  38488888,  -77988532,  38979928,  0x001208c},
        {-77988532,  38488888,  -77394820,  38979928,  0x001288c},
        {-77394820,  38488888,  -76801108,  38979928,  0x001308c},
        {-80001944,  37997848,  -79413440,  38488888,  0x001388c},
        {-79413440,  37997848,  -78824936,  38488888,  0x001408c},
        {-78824936,  37997848,  -78236432,  38488888,  0x001488c},
        {-78236432,  37997848,  -77647928,  38488888,  0x001508c},
        {-77647928,  37997848,  -77059424,  38488888,  0x001588c},
        {-77059424,  37997848,  -76470920,  38488888,  0x001608c},
        {-76470920,  37997848,  -75882416,  38488888,  0x001688c},
        {-80331507,  37506808,  -79743003,  37997848,  0x001708c},
        {-79743003,  37506808,  -79154499,  37997848,  0x001788c},
        {-79154499,  37506808,  -78565995,  37997848,  0x001808c},
        {-78565995,  37506808,  -77977491,  37997848,  0x001888c},
        {-77977491,  37506808,  -77388987,  37997848,  0x001908c},
        {-77388987,  37506808,  -76800483,  37997848,  0x001988c},
        {-76800483,  37506808,  -76211979,  37997848,  0x001a08c},
        {-76211979,  37506808,  -75623475,  37997848,  0x001a88c},
        {-75754944,  37536270,  -75166440,  38027310,  0x001b08c},
        {-77942180,  37015768,  -77358884,  37506808,  0x001b88c},
        {-77358884,  37015768,  -76775588,  37506808,  0x001c08c},
        {-76775588,  37015768,  -76192292,  37506808,  0x001c88c},
        {-76192292,  37015768,  -75608996,  37506808,  0x001d08c},
        {-77936972,  36530000,  -77358884,  37021040,  0x001d88c},
        {-77358884,  36530000,  -76780796,  37021040,  0x001e08c},
        {-76780796,  36530000,  -76202708,  37021040,  0x001e88c},
        {-76202708,  36530000,  -75624620,  37021040,  0x001f08c},
        {-83112801,  37047290,  -82529505,  37538330,  0x0b00890},
        {-82529505,  37047290,  -81946209,  37538330,  0x0b01090},
        {-81946209,  37047290,  -81362913,  37538330,  0x0b01890},
        {-81362913,  37047290,  -80779617,  37538330,  0x0b02090},
        {-83675290,  36556250,  -83097202,  37047290,  0x0b12890},
        {-83112801,  36556250,  -82534713,  37047290,  0x0b13090},
        {-82534713,  36556250,  -81956625,  37047290,  0x0b13890},
        {-81956625,  36556250,  -81378537,  37047290,  0x0b14090},
        {-81378537,  36556250,  -80800449,  37047290,  0x0b14890},
        {-80805657,  37027648,  -80222361,  37518688,  0x0b05090},
        {-80222361,  37027648,  -79639065,  37518688,  0x0b05890},
        {-79639065,  37027648,  -79055769,  37518688,  0x0b06090},
        {-79055769,  37027648,  -78472473,  37518688,  0x0b06890},
        {-78472473,  37027648,  -77889177,  37518688,  0x0b07090},
        {-80800449,  36536608,  -80222361,  37027648,  0x0b17890},
        {-80222361,  36536608,  -79644273,  37027648,  0x0b18090},
        {-79644273,  36536608,  -79066185,  37027648,  0x0b18890},
        {-79066185,  36536608,  -78488097,  37027648,  0x0b19090},
        {-78488097,  36536608,  -77910009,  37027648,  0x0b19890},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-83675290,  36530000,  -75166440,  39466500,  0x0020217},
        {-83054738,  39917755,  -82942301,  40004245,  0x001000a}, // 1OH
        {-83186682,  39836454,  -82739818,  40182413,  0xf040047},
        {-81880975,  41247877,  -81438177,  41582766,  0xe890047},
        {-84291881,  39662340,  -84042177,  39855659,  0x864004b},
        {-84581047,  39092404,  -84332954,  39285723,  0x864044b},
        {-84604000,  39285723,  -84246875,  39420000,  0x864044b},
        {-83681852,  41558482,  -83451213,  41731461,  0x782004b},
        {-81633359,  40994510,  -81404642,  41167489,  0x782004b},
        {-81521183,  40747105,  -81293908,  40920084,  0x782004b},
        {-80791805,  41013510,  -80563088,  41186489,  0x782004b},
        {-84818198,  41243440,  -84198446,  41734480,  0x001088c},
        {-84198446,  41243440,  -83578694,  41734480,  0x001108c},
        {-83578694,  41243440,  -82958942,  41734480,  0x001188c},
        {-82958942,  41243440,  -82339190,  41734480,  0x001208c},
        {-82344398,  41488960,  -81719438,  41980000,  0x001288c},
        {-81719438,  41488960,  -81094478,  41980000,  0x001308c},
        {-81134960,  41488960,  -80510000,  41980000,  0x001388c},
        {-84827000,  41007740,  -84207248,  41498780,  0x001408c},
        {-84219278,  41007740,  -83599526,  41498780,  0x001488c},
        {-83599526,  41007740,  -82979774,  41498780,  0x001508c},
        {-82979774,  41007740,  -82360022,  41498780,  0x001588c},
        {-82360022,  41007740,  -81740270,  41498780,  0x001608c},
        {-81740270,  41007740,  -81120518,  41498780,  0x001688c},
        {-81129752,  41007740,  -80510000,  41498780,  0x001708c},
        {-84827000,  40516700,  -84212456,  41007740,  0x001788c},
        {-84224486,  40516700,  -83609942,  41007740,  0x001808c},
        {-83609942,  40516700,  -82995398,  41007740,  0x001888c},
        {-82995398,  40516700,  -82380854,  41007740,  0x001908c},
        {-82380854,  40516700,  -81766310,  41007740,  0x001988c},
        {-81766310,  40516700,  -81151766,  41007740,  0x001a08c},
        {-81151766,  40516700,  -80537222,  41007740,  0x001a88c},
        {-84827000,  40025660,  -84217664,  40516700,  0x001b08c},
        {-84255213,  40025660,  -83645877,  40516700,  0x001b88c},
        {-83645877,  40025660,  -83036541,  40516700,  0x001c08c},
        {-83036541,  40025660,  -82427205,  40516700,  0x001c88c},
        {-82427205,  40025660,  -81817869,  40516700,  0x001e08c},
        {-81817869,  40025660,  -81208533,  40516700,  0x001e88c},
        {-81208533,  40025660,  -80599197,  40516700,  0x001f08c},
        {-84827000,  39534620,  -84222872,  40025660,  0x0b00890},
        {-84321355,  39534620,  -83717227,  40025660,  0x0b01090},
        {-83717227,  39534620,  -83113099,  40025660,  0x0b01890},
        {-83113099,  39534620,  -82508971,  40025660,  0x0b02090},
        {-82508971,  39534620,  -81904843,  40025660,  0x0b02890},
        {-81904843,  39534620,  -81300715,  40025660,  0x0b03090},
        {-81300715,  39534620,  -80696587,  40025660,  0x0b03890},
        {-84827000,  39043580,  -84228080,  39534620,  0x0b14090},
        {-84381768,  39043580,  -83782848,  39534620,  0x0b14890},
        {-83782848,  39043580,  -83183928,  39534620,  0x0b15090},
        {-83183928,  39043580,  -82585008,  39534620,  0x0b15890},
        {-82585008,  39043580,  -81986088,  39534620,  0x0b16090},
        {-81986088,  39043580,  -81387168,  39534620,  0x0b16890},
        {-81387168,  39043580,  -80788248,  39534620,  0x0b17090},
        {-84441660,  38552540,  -83847948,  39043580,  0x0b17890},
        {-83847948,  38552540,  -83254236,  39043580,  0x0b18090},
        {-83254236,  38552540,  -82660524,  39043580,  0x0b18890},
        {-82660524,  38552540,  -82066812,  39043580,  0x0b19090},
        {-82066812,  38847164,  -81467892,  39338204,  0x0b19890},
        {-82845408,  38400000,  -82251696,  38891040,  0x0b1a090},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-84827000,  38400000,  -80510000,  41980000,  0x0020217},
        {-75242238,  39908755,  -75129801,  39995245,  0x001000a}, // 1PA
        {-75371779,  39856500,  -74991890,  40138500,  0xc730447},
        {-80186500,  40304290,  -79766746,  40536300,  0xbde0447},
        {-75641100,  40504500,  -75180045,  40717500,  0xbde0447},
        {-76050326,  40275440,  -75798474,  40468759,  0x864004b},
        {-75776906,  41311740,  -75521295,  41505059,  0x864004b},
        {-76023906,  41175940,  -75744733,  41352850,  0x864044b},
        {-76433377,  39986410,  -76234522,  40182300,  0x782044b},
        {-74992200,  40041000,  -74758288,  40207500,  0x782044b},
        {-77016677,  40192000,  -76739499,  40332500,  0x782044b},
        {-80247800,  42031300,  -79965992,  42174000,  0x782044b},
        {-80519880,  41661090,  -79894920,  42152130,  0x001088c},
        {-79894920,  41661090,  -79269960,  42152130,  0x001108c},
        {-80376139,  41882058,  -79751179,  42373098,  0x001008c},
        {-79269960,  41513778,  -78645000,  42004818,  0x001188c},
        {-78645000,  41513778,  -78020040,  42004818,  0x001208c},
        {-78020040,  41513778,  -77395080,  42004818,  0x001288c},
        {-77395080,  41513778,  -76770120,  42004818,  0x001308c},
        {-76770120,  41513778,  -76145160,  42004818,  0x001388c},
        {-76145160,  41513778,  -75520200,  42004818,  0x001408c},
        {-75520200,  41513778,  -74895240,  42004818,  0x001488c},
        {-80519900,  41170050,  -79900148,  41661090,  0x001508c},
        {-79907419,  41170050,  -79287667,  41661090,  0x001588c},
        {-79287667,  41170050,  -78667915,  41661090,  0x001608c},
        {-78667915,  41170050,  -78048163,  41661090,  0x001688c},
        {-78048163,  41170050,  -77428411,  41661090,  0x001708c},
        {-77428411,  41170050,  -76808659,  41661090,  0x001788c},
        {-76808659,  41170050,  -76188907,  41661090,  0x001808c},
        {-76188907,  41170050,  -75569155,  41661090,  0x001888c},
        {-75569155,  41170050,  -74949403,  41661090,  0x001908c},
        {-80519900,  40679010,  -79905356,  41170050,  0x001988c},
        {-79912627,  40679010,  -79298083,  41170050,  0x001a08c},
        {-79298083,  40679010,  -78683539,  41170050,  0x001a88c},
        {-78683539,  40679010,  -78068995,  41170050,  0x001b08c},
        {-78068995,  40679010,  -77454451,  41170050,  0x001b88c},
        {-77454451,  40679010,  -76839907,  41170050,  0x001c08c},
        {-76839907,  40679010,  -76225363,  41170050,  0x001c88c},
        {-76225363,  40679010,  -75610819,  41170050,  0x001d08c},
        {-75610819,  40679010,  -74996275,  41170050,  0x001d88c},
        {-75309752,  41047290,  -74690000,  41538330,  0x001e08c},
        {-80519900,  40187970,  -79910564,  40679010,  0x0b00890},
        {-79916116,  40187970,  -79306780,  40679010,  0x0b01090},
        {-79306780,  40187970,  -78697444,  40679010,  0x0b01890},
        {-78697444,  40187970,  -78088108,  40679010,  0x0b02090},
        {-78088108,  40187970,  -77478772,  40679010,  0x0b02890},
        {-77478772,  40187970,  -76869436,  40679010,  0x0b03090},
        {-76869436,  40187970,  -76260100,  40679010,  0x0b03890},
        {-76260100,  40187970,  -75650764,  40679010,  0x0b04090},
        {-75650764,  40187970,  -75041428,  40679010,  0x0b04890},
        {-80519900,  39700000,  -79915772,  40191040,  0x0b05090},
        {-79921324,  39700000,  -79317196,  40191040,  0x0b05890},
        {-79317196,  39700000,  -78713068,  40191040,  0x0b06090},
        {-78713068,  39700000,  -78108940,  40191040,  0x0b06890},
        {-78108940,  39700000,  -77504812,  40191040,  0x0b07090},
        {-77504812,  39700000,  -76900684,  40191040,  0x0b07890},
        {-76900684,  39700000,  -76296556,  40191040,  0x0b08090},
        {-76296556,  39700000,  -75692428,  40191040,  0x0b08890},
        {-75692428,  39700000,  -75088300,  40191040,  0x0b09090},
        {-75299336,  39942450,  -74690000,  40433490,  0x0b09890},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-80519900,  39700000,  -74690000,  42373098,  0x0020217},
        {-90256333,  32268754,  -90154467,  32355244,  0x001000a}, // 1MS
        {-90356132,  32139020,  -89948669,  32484979,  0xf040047},
        {-89201000,  30321900,  -88618341,  30543660,  0xe890447},
        {-90115840,  34805000,  -89783394,  34996000,  0x9ee044b},
        {-89455032,  31218360,  -89207968,  31430129,  0x931004b},
        {-88817109,  32274860,  -88567692,  32486629,  0x931004b},
        {-88806344,  34144560,  -88550457,  34356329,  0x931004b},
        {-91113879,  33301960,  -90861521,  33513729,  0x931004b},
        {-90812304,  34505960,  -90249840,  34997000,  0x001008c},
        {-90249840,  34505960,  -89687376,  34997000,  0x001088c},
        {-89687376,  34505960,  -89124912,  34997000,  0x001108c},
        {-89124912,  34505960,  -88562448,  34997000,  0x001188c},
        {-88659464,  34505960,  -88097000,  34997000,  0x001208c},
        {-90958544,  34037016,  -90396080,  34528056,  0x001288c},
        {-90396080,  34037016,  -89833616,  34528056,  0x001308c},
        {-89833616,  34037016,  -89271152,  34528056,  0x001388c},
        {-89271152,  34037016,  -88708688,  34528056,  0x001408c},
        {-88708688,  34037016,  -88146224,  34528056,  0x001488c},
        {-91515800,  33545976,  -90958544,  34037016,  0x001508c},
        {-90958544,  33545976,  -90401288,  34037016,  0x001588c},
        {-90401288,  33545976,  -89844032,  34037016,  0x001608c},
        {-89844032,  33545976,  -89286776,  34037016,  0x001688c},
        {-89286776,  33545976,  -88729520,  34037016,  0x001708c},
        {-88729520,  33545976,  -88172264,  34037016,  0x001788c},
        {-91515800,  33054936,  -90958544,  33545976,  0x001888c},
        {-90958544,  33054936,  -90401288,  33545976,  0x001908c},
        {-90401288,  33054936,  -89844032,  33545976,  0x001988c},
        {-89844032,  33054936,  -89286776,  33545976,  0x001a08c},
        {-89286776,  33054936,  -88729520,  33545976,  0x001a88c},
        {-88729520,  33054936,  -88172264,  33545976,  0x001b08c},
        {-91515800,  32563896,  -90963752,  33054936,  0x001b88c},
        {-90963752,  32563896,  -90411704,  33054936,  0x001c08c},
        {-90411704,  32563896,  -89859656,  33054936,  0x001c88c},
        {-89859656,  32563896,  -89307608,  33054936,  0x001e08c},
        {-89307608,  32563896,  -88755560,  33054936,  0x001e88c},
        {-88755560,  32563896,  -88203512,  33054936,  0x001f08c},
        {-91656000,  32072856,  -91103952,  32563896,  0x0b00890},
        {-91106733,  32072856,  -90554685,  32563896,  0x0b01090},
        {-90554685,  32072856,  -90002637,  32563896,  0x0b01890},
        {-90002637,  32072856,  -89450589,  32563896,  0x0b02090},
        {-89450589,  32072856,  -88898541,  32563896,  0x0b02890},
        {-88898541,  32072856,  -88346493,  32563896,  0x0b03090},
        {-91653573,  31581816,  -91106733,  32072856,  0x0b13890},
        {-91106733,  31581816,  -90559893,  32072856,  0x0b14090},
        {-90559893,  31581816,  -90013053,  32072856,  0x0b14890},
        {-90013053,  31581816,  -89466213,  32072856,  0x0b15090},
        {-89466213,  31581816,  -88919373,  32072856,  0x0b15890},
        {-88919373,  31581816,  -88372533,  32072856,  0x0b16090},
        {-91653573,  31090776,  -91106733,  31581816,  0x0b06890},
        {-91106733,  31090776,  -90559893,  31581816,  0x0b07090},
        {-90559893,  31090776,  -90013053,  31581816,  0x0b08890},
        {-90013053,  31090776,  -89466213,  31581816,  0x0b09090},
        {-89466213,  31090776,  -88919373,  31581816,  0x0b09890},
        {-88919373,  31090776,  -88372533,  31581816,  0x0b0a090},
        {-91653573,  30599736,  -91111941,  31090776,  0x0b0a890},
        {-91111941,  30599736,  -90570309,  31090776,  0x0b0b090},
        {-90570309,  30599736,  -90028677,  31090776,  0x0b0b890},
        {-90028677,  30599736,  -89487045,  31090776,  0x0b0c090},
        {-89487045,  30599736,  -88945413,  31090776,  0x0b0c890},
        {-88945413,  30599736,  -88403781,  31090776,  0x0b0d090},
        {-89860979,  30145000,  -89324555,  30636040,  0x0b1e090},
        {-89324555,  30145000,  -88788131,  30636040,  0x0b1e890},
        {-88788131,  30145000,  -88251707,  30636040,  0x0b1f090},
        {-94618000,  24450000,  -75350000,  36688000,  0x30e0216},
        {-91656000,  30145000,  -88097000,  34997000,  0x0020217},
        {-90162011,  29872755,  -90063028,  29959245,  0x001000a}, // 1LA
        {-90273446,  29782020,  -89876554,  30127979,  0xf040047},
        {-91272926,  30277700,  -90886874,  30612589,  0xe890047},
        {-93882554,  32362090,  -93594447,  32606709,  0xa9e004b},
        {-92160896,  30088590,  -91878905,  30333209,  0xa9e004b},
        {-93398996,  30116690,  -93117005,  30361309,  0xa9e004b},
        {-92253726,  32427600,  -91939013,  32623389,  0x9ee044b},
        {-94044000,  32528960,  -93491952,  33020000,  0x001008c},
        {-93547156,  32528960,  -92995108,  33020000,  0x001088c},
        {-92995108,  32528960,  -92443060,  33020000,  0x001108c},
        {-92443060,  32528960,  -91891012,  33020000,  0x001188c},
        {-91891012,  32528960,  -91338964,  33020000,  0x001208c},
        {-91338964,  32528960,  -90786916,  33020000,  0x001288c},
        {-94044000,  32037920,  -93491952,  32528960,  0x001308c},
        {-93547156,  32037920,  -92995108,  32528960,  0x001388c},
        {-92995108,  32037920,  -92443060,  32528960,  0x001408c},
        {-92443060,  32037920,  -91891012,  32528960,  0x001488c},
        {-91891012,  32037920,  -91338964,  32528960,  0x001508c},
        {-91338964,  32037920,  -90786916,  32528960,  0x001588c},
        {-94044000,  31546880,  -93497160,  32037920,  0x001608c},
        {-93547156,  31546880,  -93000316,  32037920,  0x001688c},
        {-93000316,  31546880,  -92453476,  32037920,  0x001708c},
        {-92453476,  31546880,  -91906636,  32037920,  0x001788c},
        {-91906636,  31546880,  -91359796,  32037920,  0x001808c},
        {-91359796,  31546880,  -90812956,  32037920,  0x001888c},
        {-93820576,  31055840,  -93273736,  31546880,  0x001908c},
        {-93273736,  31055840,  -92726896,  31546880,  0x001988c},
        {-92726896,  31055840,  -92180056,  31546880,  0x001a08c},
        {-92180056,  31055840,  -91633216,  31546880,  0x001a88c},
        {-91633216,  31055840,  -91086376,  31546880,  0x001b08c},
        {-93820576,  30564800,  -93278944,  31055840,  0x001b88c},
        {-93278944,  30564800,  -92737312,  31055840,  0x001c08c},
        {-92737312,  30564800,  -92195680,  31055840,  0x001c88c},
        {-92195680,  30564800,  -91654048,  31055840,  0x001d08c},
        {-91654048,  30564800,  -91112416,  31055840,  0x001d88c},
        {-91112416,  30564800,  -90570784,  31055840,  0x001e08c},
        {-90570784,  30564800,  -90029152,  31055840,  0x001e88c},
        {-90029152,  30564800,  -89487520,  31055840,  0x001f08c},
        {-93815368,  30073760,  -93278944,  30564800,  0x0010088},
        {-93278944,  30073760,  -92742520,  30564800,  0x0010888},
        {-92742520,  30073760,  -92206096,  30564800,  0x0011088},
        {-92206096,  30073760,  -91669672,  30564800,  0x0011888},
        {-91669672,  30073760,  -91133248,  30564800,  0x0012088},
        {-91133248,  30073760,  -90596824,  30564800,  0x0012888},
        {-90596824,  30073760,  -90060400,  30564800,  0x0013088},
        {-90060400,  30073760,  -89523976,  30564800,  0x0013888},
        {-89523976,  30073760,  -88987552,  30564800,  0x0014088},
        {-94044000,  29582720,  -93507576,  30073760,  0x0014888},
        {-93547156,  29582720,  -93010732,  30073760,  0x0015088},
        {-93010732,  29582720,  -92474308,  30073760,  0x0015888},
        {-92474308,  29582720,  -91937884,  30073760,  0x0016088},
        {-91937884,  29582720,  -91401460,  30073760,  0x0016888},
        {-91401460,  29582720,  -90865036,  30073760,  0x0017088},
        {-90865036,  29582720,  -90328612,  30073760,  0x0017888},
        {-90328612,  29582720,  -89792188,  30073760,  0x0018088},
        {-89792188,  29582720,  -89255764,  30073760,  0x0018888},
        {-89294424,  29582720,  -88758000,  30073760,  0x0019088},
        {-93010732,  29091680,  -92479516,  29582720,  0x0019888},
        {-92479516,  29091680,  -91948300,  29582720,  0x001a088},
        {-91948300,  29091680,  -91417084,  29582720,  0x001a888},
        {-91417084,  29091680,  -90885868,  29582720,  0x001b088},
        {-90885868,  29091680,  -90354652,  29582720,  0x001b888},
        {-90354652,  29091680,  -89823436,  29582720,  0x001c088},
        {-89823436,  29091680,  -89292220,  29582720,  0x001c888},
        {-89292220,  29091680,  -88761004,  29582720,  0x001d088},
        {-91151476,  28854000,  -90620260,  29345040,  0x001d888},
        {-90620260,  28854000,  -90089044,  29345040,  0x001e088},
        {-90089044,  28854000,  -89557828,  29345040,  0x001e888},
        {-89557828,  28854000,  -89026612,  29345040,  0x001f088},
        {-94618000,  24450000,  -75350000,  36688000,  0x30e0216},
        {-94044000,  28854000,  -88758000,  33020000,  0x0020217},
        {-86849933,  33473755,  -86747106,  33560245,  0x001000a}, // 1AL
        {-87004602,  33337330,  -86662798,  33624159,  0xc730047},
        {-86482000,  32290000,  -86067011,  32502100,  0xbde0447},
        {-86794391,  34593290,  -86464010,  34866709,  0xbde0047},
        {-88278901,  30579410,  -88013899,  30808189,  0x9ee004b},
        {-87685379,  33104460,  -87433021,  33316229,  0x931004b},
        {-85504532,  31115560,  -85257468,  31327329,  0x931004b},
        {-87116644,  34462660,  -86860757,  34674429,  0x931004b},
        {-85555309,  32504160,  -85305892,  32715929,  0x931004b},
        {-88245327,  34517960,  -87677655,  35009000,  0x01e008c},
        {-87677655,  34517960,  -87109983,  35009000,  0x01e088c},
        {-87109983,  34517960,  -86542311,  35009000,  0x01e108c},
        {-86542311,  34517960,  -85974639,  35009000,  0x01e188c},
        {-85974639,  34517960,  -85406967,  35009000,  0x01e208c},
        {-88216943,  34115307,  -87654479,  34606347,  0x001288c},
        {-87654479,  34115307,  -87092015,  34606347,  0x001308c},
        {-87092015,  34115307,  -86529551,  34606347,  0x001388c},
        {-86529551,  34115307,  -85967087,  34606347,  0x001408c},
        {-85967087,  34115307,  -85404623,  34606347,  0x001488c},
        {-88391307,  33624267,  -87828843,  34115307,  0x001508c},
        {-87828843,  33624267,  -87266379,  34115307,  0x001588c},
        {-87266379,  33624267,  -86703915,  34115307,  0x001608c},
        {-86703915,  33624267,  -86141451,  34115307,  0x001688c},
        {-86141451,  33624267,  -85578987,  34115307,  0x001708c},
        {-85578987,  33624267,  -85016523,  34115307,  0x001888c},
        {-88386099,  33133227,  -87828843,  33624267,  0x001908c},
        {-87828843,  33133227,  -87271587,  33624267,  0x001988c},
        {-87271587,  33133227,  -86714331,  33624267,  0x001a08c},
        {-86714331,  33133227,  -86157075,  33624267,  0x001a88c},
        {-86157075,  33133227,  -85599819,  33624267,  0x001b08c},
        {-85599819,  33133227,  -85042563,  33624267,  0x001b88c},
        {-88386099,  32642187,  -87834051,  33133227,  0x001c08c},
        {-87834051,  32642187,  -87282003,  33133227,  0x001c88c},
        {-87282003,  32642187,  -86729955,  33133227,  0x001d08c},
        {-86729955,  32642187,  -86177907,  33133227,  0x001e08c},
        {-86177907,  32642187,  -85625859,  33133227,  0x001e88c},
        {-85625859,  32642187,  -85073811,  33133227,  0x001f08c},
        {-88475000,  32151147,  -87922952,  32642187,  0x0b00090},
        {-87922952,  32151147,  -87370904,  32642187,  0x0b00890},
        {-87370904,  32151147,  -86818856,  32642187,  0x0b01090},
        {-86818856,  32151147,  -86266808,  32642187,  0x0b01890},
        {-86266808,  32151147,  -85714760,  32642187,  0x0b02090},
        {-85714760,  32151147,  -85162712,  32642187,  0x0b02890},
        {-85192616,  31920000,  -84888000,  32642187,  0x11f3090},
        {-88471052,  31660107,  -87924212,  32151147,  0x0b13890},
        {-87924212,  31660107,  -87377372,  32151147,  0x0b14090},
        {-87377372,  31660107,  -86830532,  32151147,  0x0b14890},
        {-86830532,  31660107,  -86283692,  32151147,  0x0b15090},
        {-86283692,  31660107,  -85736852,  32151147,  0x0b15890},
        {-85736852,  31660107,  -85190012,  32151147,  0x0b16090},
        {-88471052,  31169067,  -87924212,  31660107,  0x0b07090},
        {-87924212,  31169067,  -87377372,  31660107,  0x0b07890},
        {-87377372,  31169067,  -86830532,  31660107,  0x0b08090},
        {-86830532,  31169067,  -86283692,  31660107,  0x0b08890},
        {-86283692,  31169067,  -85736852,  31660107,  0x0b09090},
        {-85736852,  31169067,  -85190012,  31660107,  0x0b09890},
        {-85192616,  30991000,  -84970000,  31920000,  0x17ca890},
        {-88464219,  30678027,  -87922587,  31169067,  0x0b0b090},
        {-87922587,  30678027,  -87380955,  31169067,  0x0b0b890},
        {-87380955,  30991000,  -86285500,  31169067,  0x04bc090},
        {-86285500,  30991000,  -85192616,  31169067,  0x04bc890},
        {-88429325,  30186987,  -87892901,  30678027,  0x0b1e090},
        {-87892901,  30186987,  -87356477,  30678027,  0x0b1f090},
        {-94618000,  24450000,  -75350000,  36688000,  0x30e0216},
        {-88475000,  30143000,  -84888000,  35009000,  0x0020217},
        {-92341394,  34711355,  -92236645,  34797845,  0x001000a}, // 1AR
        {-94332220,  35909400,  -94040727,  36414500,  0xf040447},
        {-92492329,  34587200,  -92087672,  34922089,  0xe890047},
        {-94508690,  35245390,  -94209711,  35490009,  0xa9e004b},
        {-90854509,  35719690,  -90553492,  35964309,  0xa9e004b},
        {-92562970,  34942290,  -92266030,  35186909,  0xa9e004b},
        {-92160621,  34123610,  -91884180,  34352389,  0x9ee004b},
        {-94618000,  36008960,  -94045120,  36500000,  0x001008c},
        {-94045120,  36008960,  -93472240,  36500000,  0x001088c},
        {-93472240,  36008960,  -92899360,  36500000,  0x001108c},
        {-92899360,  36008960,  -92326480,  36500000,  0x001188c},
        {-92326480,  36008960,  -91753600,  36500000,  0x001208c},
        {-91753600,  36008960,  -91180720,  36500000,  0x001288c},
        {-91180720,  36008960,  -90607840,  36500000,  0x001308c},
        {-90607840,  36008960,  -90034960,  36500000,  0x001388c},
        {-94617999,  35517920,  -94045119,  36008960,  0x001408c},
        {-94045119,  35517920,  -93472239,  36008960,  0x001488c},
        {-93472239,  35517920,  -92899359,  36008960,  0x001508c},
        {-92899359,  35517920,  -92326479,  36008960,  0x001588c},
        {-92326479,  35517920,  -91753599,  36008960,  0x001608c},
        {-91753599,  35517920,  -91180719,  36008960,  0x001688c},
        {-91180719,  35517920,  -90607839,  36008960,  0x001708c},
        {-90607839,  35517920,  -90034959,  36008960,  0x001788c},
        {-90216880,  35517920,  -89644000,  36008960,  0x001808c},
        {-94469571,  35026880,  -93901899,  35517920,  0x001888c},
        {-93901899,  35026880,  -93334227,  35517920,  0x001908c},
        {-93334227,  35026880,  -92766555,  35517920,  0x001988c},
        {-92766555,  35026880,  -92198883,  35517920,  0x001a08c},
        {-92198883,  35026880,  -91631211,  35517920,  0x001a88c},
        {-91631211,  35026880,  -91063539,  35517920,  0x001b08c},
        {-91063539,  35026880,  -90495867,  35517920,  0x001b88c},
        {-90495867,  35026880,  -89928195,  35517920,  0x001c08c},
        {-94611489,  34535840,  -94049025,  35026880,  0x001c88c},
        {-94049025,  34535840,  -93486561,  35026880,  0x001d08c},
        {-93486561,  34535840,  -92924097,  35026880,  0x001d88c},
        {-92924097,  34535840,  -92361633,  35026880,  0x001e08c},
        {-92361633,  34535840,  -91799169,  35026880,  0x001e88c},
        {-91799169,  34535840,  -91236705,  35026880,  0x001f08c},
        {-91236705,  34535840,  -90674241,  35026880,  0x0010088},
        {-90674241,  34535840,  -90111777,  35026880,  0x0010888},
        {-94611489,  34044800,  -94049025,  34535840,  0x0011088},
        {-94049025,  34044800,  -93486561,  34535840,  0x0011888},
        {-93486561,  34044800,  -92924097,  34535840,  0x0012088},
        {-92924097,  34044800,  -92361633,  34535840,  0x0012888},
        {-92361633,  34044800,  -91799169,  34535840,  0x0013088},
        {-91799169,  34044800,  -91236705,  34535840,  0x0013888},
        {-91236705,  34044800,  -90674241,  34535840,  0x0014088},
        {-90674241,  34044800,  -90111777,  34535840,  0x0014888},
        {-94606281,  33553760,  -94049025,  34044800,  0x0015088},
        {-94049025,  33553760,  -93491769,  34044800,  0x0015888},
        {-93491769,  33553760,  -92934513,  34044800,  0x0016088},
        {-92934513,  33553760,  -92377257,  34044800,  0x0016888},
        {-92377257,  33553760,  -91820001,  34044800,  0x0017088},
        {-91820001,  33553760,  -91262745,  34044800,  0x0017888},
        {-91262745,  33553760,  -90705489,  34044800,  0x0018088},
        {-94394524,  33062720,  -93837268,  33553760,  0x0018888},
        {-93837268,  33062720,  -93280012,  33553760,  0x0019088},
        {-93280012,  33062720,  -92722756,  33553760,  0x0019888},
        {-92722756,  33062720,  -92165500,  33553760,  0x001a088},
        {-92165500,  33062720,  -91608244,  33553760,  0x001a888},
        {-91608244,  33062720,  -91050988,  33553760,  0x001b088},
        {-94171622,  33003000,  -93619574,  33494040,  0x001b888},
        {-93619574,  33003000,  -93067526,  33494040,  0x001c088},
        {-93067526,  33003000,  -92515478,  33494040,  0x001c888},
        {-92515478,  33003000,  -91963430,  33494040,  0x0b1e090},
        {-91963430,  33003000,  -91411382,  33494040,  0x0b1e890},
        {-91411382,  33003000,  -90859334,  33494040,  0x0b1f090},
        {-94618000,  24450000,  -75350000,  36688000,  0x30e0216},
        {-94618000,  33003000,  -89644000,  36500000,  0x0020217},
        {-80895855,  35183755,  -80790145,  35270245,  0x001000a}, // 1NC
        {-81052978,  35054020,  -80633022,  35399979,  0xf040047},
        {-78907855,  35602600,  -78498546,  35937489,  0xe890047},
        {-79005430,  35907510,  -78792570,  36080489,  0x782004b},
        {-79040000,  34994000,  -78854167,  35189300,  0x782044b},
        {-77957480,  34085663,  -77792725,  34305000,  0x782044b},
        {-80352230,  36017010,  -80139370,  36189989,  0x782004b},
        {-79950030,  35989010,  -79737170,  36161989,  0x782004b},
        {-80119730,  35864010,  -79906870,  36036989,  0x782004b},
        {-77468710,  35531510,  -77257291,  35704489,  0x782004b},
        {-82650120,  35521020,  -82467081,  35670779,  0x680004b},
        {-82603360,  36097960,  -82030480,  36589000,  0x001008c},
        {-82030480,  36097960,  -81457600,  36589000,  0x001088c},
        {-81457600,  36097960,  -80884720,  36589000,  0x001108c},
        {-80884720,  36097960,  -80311840,  36589000,  0x001188c},
        {-80311840,  36097960,  -79738960,  36589000,  0x001208c},
        {-79738960,  36097960,  -79166080,  36589000,  0x001288c},
        {-83749120,  35606920,  -83176240,  36097960,  0x001308c},
        {-83176240,  35606920,  -82603360,  36097960,  0x001388c},
        {-82603360,  35606920,  -82030480,  36097960,  0x001408c},
        {-82030480,  35606920,  -81457600,  36097960,  0x001488c},
        {-81457600,  35606920,  -80884720,  36097960,  0x001508c},
        {-80884720,  35606920,  -80311840,  36097960,  0x001588c},
        {-80311840,  35606920,  -79738960,  36097960,  0x001608c},
        {-79738960,  35606920,  -79166080,  36097960,  0x001688c},
        {-84316792,  35115880,  -83749120,  35606920,  0x001708c},
        {-83749120,  35115880,  -83181448,  35606920,  0x001788c},
        {-83181448,  35115880,  -82613776,  35606920,  0x001808c},
        {-82613776,  35115880,  -82046104,  35606920,  0x001888c},
        {-82046104,  35115880,  -81478432,  35606920,  0x001908c},
        {-81478432,  35115880,  -80910760,  35606920,  0x001988c},
        {-80910760,  35115880,  -80343088,  35606920,  0x001a08c},
        {-80343088,  35115880,  -79775416,  35606920,  0x001a88c},
        {-79775416,  35115880,  -79207744,  35606920,  0x001b08c},
        {-84316792,  34985000,  -82613776,  35115880,  0x009b88c},
        {-81478432,  34624840,  -80910760,  35115880,  0x001c08c},
        {-80910760,  34624840,  -80343088,  35115880,  0x001c88c},
        {-80343088,  34624840,  -79775416,  35115880,  0x001d08c},
        {-79775416,  34624840,  -79207744,  35115880,  0x001d88c},
        {-79775415,  34133800,  -79212951,  34624840,  0x001e08c},
        {-78931720,  33752500,  -78369256,  34243540,  0x001e88c},
        {-78369256,  33752500,  -77806792,  34243540,  0x001f08c},
        {-79218159,  36063587,  -78645279,  36554627,  0x0010088},
        {-78645279,  36063587,  -78072399,  36554627,  0x0010888},
        {-78072399,  36063587,  -77499519,  36554627,  0x0011088},
        {-77499519,  36063587,  -76926639,  36554627,  0x0011888},
        {-76926639,  36063587,  -76353759,  36554627,  0x0012088},
        {-76353759,  36063587,  -75780879,  36554627,  0x0012888},
        {-75922880,  36063587,  -75350000,  36554627,  0x0013088},
        {-79218159,  35572547,  -78645279,  36063587,  0x0013888},
        {-78645279,  35572547,  -78072399,  36063587,  0x0014088},
        {-78072399,  35572547,  -77499519,  36063587,  0x0014888},
        {-77499519,  35572547,  -76926639,  36063587,  0x0015088},
        {-76926639,  35572547,  -76353759,  36063587,  0x0015888},
        {-76353759,  35572547,  -75780879,  36063587,  0x0016088},
        {-75922880,  35572547,  -75350000,  36063587,  0x0016888},
        {-79212951,  35081507,  -78645279,  35572547,  0x0017088},
        {-78645279,  35081507,  -78077607,  35572547,  0x0017888},
        {-78077607,  35081507,  -77509935,  35572547,  0x0018088},
        {-77509935,  35081507,  -76942263,  35572547,  0x0018888},
        {-76942263,  35081507,  -76374591,  35572547,  0x0019088},
        {-76374591,  35081507,  -75806919,  35572547,  0x0019888},
        {-75917672,  35081507,  -75350000,  35572547,  0x001a088},
        {-79212951,  34590467,  -78650487,  35081507,  0x001a888},
        {-78650487,  34590467,  -78088023,  35081507,  0x001b088},
        {-78088023,  34590467,  -77525559,  35081507,  0x001b888},
        {-77525559,  34590467,  -76963095,  35081507,  0x001c088},
        {-76963095,  34590467,  -76400631,  35081507,  0x001c888},
        {-76400631,  34590467,  -75838167,  35081507,  0x001d088},
        {-79212951,  34099427,  -78650487,  34590467,  0x001d888},
        {-78650487,  34099427,  -78088023,  34590467,  0x001e088},
        {-78088023,  34099427,  -77525559,  34590467,  0x001e888},
        {-77525559,  34099427,  -76963095,  34590467,  0x001f088},
        {-94618000,  24450000,  -75350000,  36688000,  0x30e0216},
        {-84322000,  33752500,  -75350000,  36589000,  0x0020217},
        {-74019000,  40700000,  -73960231,  40755500,  0x22a044a}, // 1NY
        {-74007000,  40755500,  -73928483,  40797000,  0x22a044a},
        {-73977300,  40797000,  -73915693,  40850000,  0x22a044a},
        {-73972500,  40542180,  -73301537,  40978600,  0x01c000c},
        {-78941162,  42795710,  -78631039,  43024489,  0x9ee004b},
        {-77738809,  43062260,  -77449391,  43274029,  0x931004b},
        {-76293033,  42973660,  -76005968,  43185429,  0x931004b},
        {-73991933,  42632670,  -73689252,  42833429,  0x931044b},
        {-74256850,  40495560,  -73968794,  40700000,  0x931044b},
        {-79158350,  42929080,  -78522974,  43420120,  0x001008c},
        {-78522974,  42929080,  -77887598,  43420120,  0x001088c},
        {-77887598,  42929080,  -77252222,  43420120,  0x001108c},
        {-77252222,  42929080,  -76616846,  43420120,  0x001188c},
        {-76616846,  42929080,  -75981470,  43420120,  0x001208c},
        {-75981470,  42929080,  -75346094,  43420120,  0x001288c},
        {-75346094,  42929080,  -74710718,  43420120,  0x001308c},
        {-74710718,  42929080,  -74075342,  43420120,  0x001388c},
        {-74075342,  42929080,  -73439966,  43420120,  0x001408c},
        {-73884729,  42929080,  -73249353,  43420120,  0x001488c},
        {-79534367,  42438040,  -78904199,  42929080,  0x001508c},
        {-78904199,  42438040,  -78274031,  42929080,  0x001588c},
        {-78274031,  42438040,  -77643863,  42929080,  0x001608c},
        {-77643863,  42438040,  -77013695,  42929080,  0x001688c},
        {-77013695,  42438040,  -76383527,  42929080,  0x001708c},
        {-76383527,  42438040,  -75753359,  42929080,  0x001788c},
        {-75753359,  42438040,  -75123191,  42929080,  0x001808c},
        {-75123191,  42438040,  -74493023,  42929080,  0x001888c},
        {-74493023,  42438040,  -73862855,  42929080,  0x001908c},
        {-73862855,  42438040,  -73232687,  42929080,  0x001988c},
        {-75312241,  41455960,  -74687281,  41947000,  0x001a88c},
        {-74687281,  41455960,  -74062321,  41947000,  0x001b08c},
        {-74062321,  41455960,  -73437361,  41947000,  0x001b88c},
        {-74619577,  40964920,  -73999825,  41455960,  0x001c88c},
        {-73999825,  40964920,  -73380073,  41455960,  0x001d08c},
        {-74929453,  41308648,  -74309701,  41799688,  0x001c08c},
        {-74256850,  40495560,  -73640369,  40964920,  0x01ef08c},
        {-73640369,  40498431,  -73025825,  40989471,  0x001d88c},
        {-73025825,  40621191,  -72411281,  41112231,  0x001e08c},
        {-72411281,  40805331,  -71796737,  41296371,  0x001e88c},
        {-75235164,  44888000,  -73320000,  45016000,  0x0340090},
        {-75883560,  44402200,  -75232560,  44893240,  0x0b00890},
        {-75232560,  44402200,  -74581560,  44893240,  0x0b01090},
        {-74581560,  44402200,  -73930560,  44893240,  0x0b01890},
        {-73930560,  44402200,  -73279560,  44893240,  0x0b02090},
        {-76469459,  43911160,  -75823667,  44402200,  0x0b02890},
        {-75823667,  43911160,  -75177875,  44402200,  0x0b03090},
        {-75177875,  43911160,  -74532083,  44402200,  0x0b03890},
        {-74532083,  43911160,  -73886291,  44402200,  0x0b04090},
        {-73886291,  43911160,  -73240499,  44402200,  0x0b04890},
        {-76916306,  43420120,  -76275722,  43911160,  0x0b05090},
        {-76275722,  43420120,  -75635138,  43911160,  0x0b05890},
        {-75635138,  43420120,  -74994554,  43911160,  0x0b06090},
        {-74994554,  43420120,  -74353970,  43911160,  0x0b06890},
        {-74353970,  43420120,  -73713386,  43911160,  0x0b07090},
        {-73713386,  43420120,  -73072802,  43911160,  0x0b07890},
        {-79763000,  41947000,  -79132832,  42438040,  0x0b08090},
        {-79342713,  41947000,  -78712545,  42438040,  0x0b08890},
        {-78712545,  41947000,  -78082377,  42438040,  0x0b09090},
        {-78082377,  41947000,  -77452209,  42438040,  0x0b09890},
        {-77452209,  41947000,  -76822041,  42438040,  0x0b0a090},
        {-76822041,  41947000,  -76191873,  42438040,  0x0b0a890},
        {-76191873,  41947000,  -75561705,  42438040,  0x0b0b090},
        {-75561705,  41947000,  -74931537,  42438040,  0x0b0b890},
        {-74931537,  41947000,  -74301369,  42438040,  0x0b0c090},
        {-74301369,  41947000,  -73671201,  42438040,  0x0b0c890},
        {-73986284,  41947000,  -73356116,  42438040,  0x0b0d090},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-79763000,  40477000,  -71777000,  45016000,  0x0020217},
        {-93666660,  41557755,  -93551340,  41644245,  0x001000a}, // 1IA
        {-93890940,  41446020,  -93429661,  41791979,  0xf040047},
        {-91850360,  41830600,  -91403841,  42165489,  0xe890047},
        {-90650000,  41496020,  -90473241,  41665100,  0x680044b},
        {-96495000,  42385200,  -96314590,  42552200,  0x680044b},
        {-92500000,  42442000,  -92248321,  42561779,  0x680044b},
        {-91647540,  41613820,  -91447861,  41763579,  0x680004b},
        {-95931808,  41176320,  -95733793,  41326079,  0x680004b},
        {-93703819,  41969290,  -93539381,  42091599,  0x54f004b},
        {-90796419,  42447090,  -90631981,  42569399,  0x54f004b},
        {-93305778,  43107190,  -93138622,  43229499,  0x54f004b},
        {-92996419,  41996490,  -92831981,  42118799,  0x54f004b},
        {-90332440,  41774590,  -90169361,  41896899,  0x54f004b},
        {-91273000,  40754000,  -91092907,  40863000,  0x54f044b},
        {-94236619,  42429190,  -94072181,  42551499,  0x54f004b},
        {-92499260,  40950190,  -92337540,  41072499,  0x54f004b},
        {-96640000,  43010960,  -95999416,  43502000,  0x001088c},
        {-96003217,  43010960,  -95362633,  43502000,  0x001108c},
        {-95362633,  43010960,  -94722049,  43502000,  0x001188c},
        {-94722049,  43010960,  -94081465,  43502000,  0x001208c},
        {-94081465,  43010960,  -93440881,  43502000,  0x001288c},
        {-93440881,  43010960,  -92800297,  43502000,  0x001308c},
        {-92800297,  43010960,  -92159713,  43502000,  0x001388c},
        {-92159713,  43010960,  -91519129,  43502000,  0x001408c},
        {-91519129,  43010960,  -90878545,  43502000,  0x001488c},
        {-96640000,  42524830,  -96004624,  43015870,  0x001508c},
        {-96008425,  42524830,  -95373049,  43015870,  0x001588c},
        {-95373049,  42524830,  -94737673,  43015870,  0x001608c},
        {-94737673,  42524830,  -94102297,  43015870,  0x001688c},
        {-94102297,  42524830,  -93466921,  43015870,  0x001708c},
        {-93466921,  42524830,  -92831545,  43015870,  0x001788c},
        {-92831545,  42524830,  -92196169,  43015870,  0x001808c},
        {-92196169,  42524830,  -91560793,  43015870,  0x001888c},
        {-91560793,  42524830,  -90925417,  43015870,  0x001908c},
        {-90925417,  42524830,  -90290041,  43015870,  0x001988c},
        {-96638593,  42033790,  -96008425,  42524830,  0x001a08c},
        {-96008425,  42033790,  -95378257,  42524830,  0x001a88c},
        {-95378257,  42033790,  -94748089,  42524830,  0x001b08c},
        {-94748089,  42033790,  -94117921,  42524830,  0x001b88c},
        {-94117921,  42033790,  -93487753,  42524830,  0x001c08c},
        {-93487753,  42033790,  -92857585,  42524830,  0x001c88c},
        {-92857585,  42033790,  -92227417,  42524830,  0x001d08c},
        {-92227417,  42033790,  -91597249,  42524830,  0x001d88c},
        {-91597249,  42033790,  -90967081,  42524830,  0x001e08c},
        {-90967081,  42033790,  -90336913,  42524830,  0x001e88c},
        {-90769168,  42033790,  -90139000,  42524830,  0x001f08c},
        {-96638593,  41542750,  -96013633,  42033790,  0x0010088},
        {-96013633,  41542750,  -95388673,  42033790,  0x0010888},
        {-95388673,  41542750,  -94763713,  42033790,  0x0011088},
        {-94763713,  41542750,  -94138753,  42033790,  0x0011888},
        {-94138753,  41542750,  -93513793,  42033790,  0x0012088},
        {-93513793,  41542750,  -92888833,  42033790,  0x0012888},
        {-92888833,  41542750,  -92263873,  42033790,  0x0013088},
        {-92263873,  41542750,  -91638913,  42033790,  0x0013888},
        {-91638913,  41542750,  -91013953,  42033790,  0x0014088},
        {-91013953,  41542750,  -90388993,  42033790,  0x0014888},
        {-90763960,  41542750,  -90139000,  42033790,  0x0015088},
        {-96633385,  41051710,  -96013633,  41542750,  0x0015888},
        {-96013633,  41051710,  -95393881,  41542750,  0x0016088},
        {-95393881,  41051710,  -94774129,  41542750,  0x0016888},
        {-94774129,  41051710,  -94154377,  41542750,  0x0017088},
        {-94154377,  41051710,  -93534625,  41542750,  0x0017888},
        {-93534625,  41051710,  -92914873,  41542750,  0x0018088},
        {-92914873,  41051710,  -92295121,  41542750,  0x0018888},
        {-92295121,  41051710,  -91675369,  41542750,  0x0019088},
        {-91675369,  41051710,  -91055617,  41542750,  0x0019888},
        {-91055617,  41051710,  -90435865,  41542750,  0x001a088},
        {-96013633,  40560670,  -95399089,  41051710,  0x001a888},
        {-95399089,  40560670,  -94784545,  41051710,  0x001b088},
        {-94784545,  40560670,  -94170001,  41051710,  0x001b888},
        {-94170001,  40560670,  -93555457,  41051710,  0x001c088},
        {-93555457,  40560670,  -92940913,  41051710,  0x001c888},
        {-92940913,  40560670,  -92326369,  41051710,  0x001d088},
        {-92326369,  40560670,  -91711825,  41051710,  0x001d888},
        {-91711825,  40560670,  -91097281,  41051710,  0x001e088},
        {-91097281,  40560670,  -90482737,  41051710,  0x001e888},
        {-91706617,  40375000,  -91097281,  40866040,  0x001f088},
        {-104060000, 35995500,  -89100000,  49384500,  0x0010216},
        {-96640000,  40375000,  -90139000,  43502000,  0x0020217},
        {-87719160,  41832655,  -87603840,  41919145,  0x001000a}, // 1IL
        {-88049960,  41577000,  -87521400,  42140000,  0x024000c},
        {-88337213,  41971010,  -88049960,  42111000,  0x782044b},
        {-88279065,  41798031,  -88048426,  41971010,  0x782004b},
        {-88279065,  41625052,  -88048426,  41798031,  0x782004b},
        {-88274452,  41452073,  -88043813,  41625052,  0x782004b},
        {-89150681,  42181810,  -88960228,  42392900,  0x782044b},
        {-89740720,  39727120,  -89522171,  39903800,  0x782044b},
        {-89687384,  40545500,  -89549742,  40831000,  0x782044b},
        {-88002372,  42291220,  -87801029,  42440979,  0x680004b},
        {-90692177,  42017960,  -90062009,  42509000,  0x001008c},
        {-90062009,  42017960,  -89431841,  42509000,  0x001088c},
        {-89431841,  42017960,  -88801673,  42509000,  0x001108c},
        {-88801673,  42017960,  -88171505,  42509000,  0x001188c},
        {-88171505,  42017960,  -87541337,  42509000,  0x001208c},
        {-90566143,  41531830,  -89941183,  42022870,  0x001288c},
        {-89941183,  41531830,  -89316223,  42022870,  0x001308c},
        {-89316223,  41531830,  -88691263,  42022870,  0x001388c},
        {-88691264,  41531830,  -88066304,  42022870,  0x001408c},
        {-88066304,  41531830,  -87441344,  42022870,  0x001488c},
        {-91185896,  41040790,  -90566144,  41531830,  0x001508c},
        {-90566144,  41040790,  -89946392,  41531830,  0x001588c},
        {-89946392,  41040790,  -89326640,  41531830,  0x001608c},
        {-89326640,  41040790,  -88706888,  41531830,  0x001688c},
        {-88706888,  41040790,  -88087136,  41531830,  0x001708c},
        {-88087136,  41040790,  -87467384,  41531830,  0x001788c},
        {-91514000,  40549750,  -90899456,  41040790,  0x001808c},
        {-90912215,  40549750,  -90297671,  41040790,  0x001888c},
        {-90297671,  40549750,  -89683127,  41040790,  0x001908c},
        {-89683127,  40549750,  -89068583,  41040790,  0x001988c},
        {-89068583,  40549750,  -88454039,  41040790,  0x001a08c},
        {-88454039,  40549750,  -87839495,  41040790,  0x001a88c},
        {-88039544,  40549750,  -87425000,  41040790,  0x001b08c},
        {-91514000,  40058710,  -90904664,  40549750,  0x001b88c},
        {-90912215,  40058710,  -90302879,  40549750,  0x001c08c},
        {-90302879,  40058710,  -89693543,  40549750,  0x001c88c},
        {-89693543,  40058710,  -89084207,  40549750,  0x001d08c},
        {-89084207,  40058710,  -88474871,  40549750,  0x001d88c},
        {-88474871,  40058710,  -87865535,  40549750,  0x001e08c},
        {-88034336,  40058710,  -87425000,  40549750,  0x001e88c},
        {-91514000,  39567670,  -90909872,  40058710,  0x001f08c},
        {-90917423,  39567670,  -90313295,  40058710,  0x0010088},
        {-90313295,  39567670,  -89709167,  40058710,  0x0010888},
        {-89709167,  39567670,  -89105039,  40058710,  0x0011088},
        {-89105039,  39567670,  -88500911,  40058710,  0x0011888},
        {-88500911,  39567670,  -87896783,  40058710,  0x0012088},
        {-88029128,  39567670,  -87425000,  40058710,  0x0012888},
        {-91514000,  39076630,  -90915080,  39567670,  0x0013088},
        {-90917423,  39076630,  -90318503,  39567670,  0x0013888},
        {-90318503,  39076630,  -89719583,  39567670,  0x0014088},
        {-89719583,  39076630,  -89120663,  39567670,  0x0014888},
        {-89120663,  39076630,  -88521743,  39567670,  0x0015088},
        {-88521743,  39076630,  -87922823,  39567670,  0x0015888},
        {-88023920,  39076630,  -87425000,  39567670,  0x0016088},
        {-90917423,  38585590,  -90323711,  39076630,  0x0016888},
        {-90323711,  38585590,  -89729999,  39076630,  0x0017088},
        {-89729999,  38585590,  -89136287,  39076630,  0x0017888},
        {-89136287,  38585590,  -88542575,  39076630,  0x0018088},
        {-88542575,  38585590,  -87948863,  39076630,  0x0018888},
        {-88018712,  38585590,  -87425000,  39076630,  0x0019088},
        {-90496617,  38094550,  -89908113,  38585590,  0x0019888},
        {-89908113,  38094550,  -89319609,  38585590,  0x001a088},
        {-89319609,  38094550,  -88731105,  38585590,  0x001a888},
        {-88731105,  38094550,  -88142601,  38585590,  0x001b088},
        {-88142601,  38094550,  -87554097,  38585590,  0x001b888},
        {-90261215,  37603510,  -89672711,  38094550,  0x001c088},
        {-89672711,  37603510,  -89084207,  38094550,  0x001c888},
        {-89084207,  37603510,  -88495703,  38094550,  0x001d088},
        {-88495703,  37603510,  -87907199,  38094550,  0x001d888},
        {-89520000,  36969500,  -89080000,  37603510,  0x028e088},
        {-89080000,  37050000,  -88570000,  37603510,  0x023e888},
        {-88570000,  37050000,  -88060000,  37603510,  0x023f088},
        {-89520000,  36969500,  -89080000,  37603510,  0x0e7e090},
        {-89080000,  37050000,  -88570000,  37603510,  0x0c8e890},
        {-88570000,  37050000,  -88060000,  37603510,  0x0c8f090},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-91514000,  36969500,  -87425000,  42509000,  0x0020217},
        {-84439894,  33714355,  -84336106,  33800845,  0x001000a}, // 1GA
        {-84644332,  33592880,  -84081868,  34083920,  0x001000c},
        {-82144986,  33358140,  -81914614,  33551459,  0x864004b},
        {-85064044,  32384240,  -84836357,  32577559,  0x864004b},
        {-81263007,  31969540,  -81036394,  32162859,  0x864004b},
        {-83486088,  33847310,  -83278513,  34020289,  0x782004b},
        {-83768186,  32695810,  -83563014,  32868789,  0x782004b},
        {-84271585,  31495810,  -84068815,  31668789,  0x782004b},
        {-83761186,  32524710,  -83556014,  32697689,  0x782004b},
        {-85606000,  32319810,  -82448154,  35001000,  0x0a80011},
        {-82700000,  30354000,  -80820000,  33911000,  0x58b0015},
        {-85249040,  30595312,  -82150776,  33276502,  0x001000d},
        {-94618000,  24450000,  -75350000,  36688000,  0x30e0216},
        {-85606000,  30354000,  -80820000,  35001000,  0x0020217},
        {-87987321,  42995755,  -87869118,  43082245,  0x001000a}, // 1WI
        {-88304584,  42866020,  -87835617,  43211979,  0xf040047},
        {-89602000,  42899600,  -89182077,  43261500,  0xe890447},
        {-88171918,  44407340,  -87902882,  44600659,  0x864004b},
        {-88018828,  42674440,  -87756773,  42867759,  0x864004b},
        {-88068528,  42499740,  -87806473,  42693059,  0x864004b},
        {-88520065,  44143610,  -88257668,  44302268,  0x782044b},
        {-88778400,  43962000,  -88505601,  44113089,  0x782044b},
        {-91569826,  44764800,  -91364292,  44968900,  0x782044b},
        {-89124442,  42616510,  -88889959,  42789489,  0x782004b},
        {-90000000,  44352595,  -86700000,  46700000,  0x001000d},
        {-92890000,  44423600,  -89250000,  47100000,  0x0010015},
        {-92113000,  42490000,  -87490000,  44423600,  0x07e0011},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-92890000,  42490000,  -86700000,  47100000,  0x0020217},
        {-80250265,  25743490,  -80182536,  25804599,  0x2a7004a}, // 1FL
        {-81691223,  30301490,  -81620778,  30362599,  0x2a7004a},
        {-80436000,  25654000,  -80071000,  26330000,  0x02b000c},
        {-81755703,  30245510,  -81556297,  30418489,  0x782004b},
        {-82539356,  27889520,  -82370045,  28039279,  0x680004b},
        {-82763240,  27698620,  -82594761,  27848379,  0x680004b},
        {-81461472,  28461220,  -81291329,  28610979,  0x680004b},
        {-84369120,  30367620,  -84196481,  30517379,  0x680004b},
        {-80433824,  27219120,  -80266177,  27368879,  0x680004b},
        {-82068608,  26543420,  -81901793,  26693179,  0x680004b},
        {-80193508,  26674420,  -80026693,  26824179,  0x680004b},
        {-82845356,  27912220,  -82676045,  28061979,  0x680004b},
        {-82449204,  29577020,  -82277397,  29726779,  0x680004b},
        {-82952745,  25468781,  -80003436,  28149971,  0x0a90011},
        {-83513411,  28149971,  -80504520,  30831161,  0x001000d},
        {-81194880,  25054480,  -80679288,  25545520,  0x0b00090},
        {-80679288,  25054480,  -80163696,  25545520,  0x0b00890},
        {-82999452,  24465232,  -82489068,  24956272,  0x0b11090},
        {-82386991,  24465232,  -81876607,  24956272,  0x0b11890},
        {-81876607,  24465232,  -81366223,  24956272,  0x0b12090},
        {-81366223,  24465232,  -80855839,  24956272,  0x0b12890},
        {-80855839,  24710752,  -80340247,  25201792,  0x0b03090},
        {-87640916,  30510960,  -87099284,  31002000,  0x0b05090},
        {-87099284,  30510960,  -86557652,  31002000,  0x0b05890},
        {-86557652,  30510960,  -86016020,  31002000,  0x0b06090},
        {-86016020,  30510960,  -85474388,  31002000,  0x0b06890},
        {-85474387,  30510960,  -84932755,  31002000,  0x0b07090},
        {-84932755,  30510960,  -84391123,  31002000,  0x0b07890},
        {-84391123,  30510960,  -83849491,  31002000,  0x0b08090},
        {-83849491,  30510960,  -83307859,  31002000,  0x0b08890},
        {-87641000,  30019920,  -87104576,  30510960,  0x0b19090},
        {-87640916,  30019920,  -87104492,  30510960,  0x0b19890},
        {-87104492,  30019920,  -86568068,  30510960,  0x0b1a090},
        {-86568068,  30019920,  -86031644,  30510960,  0x0b1a890},
        {-86031644,  30019920,  -85495220,  30510960,  0x0b1b090},
        {-85495220,  30019920,  -84958796,  30510960,  0x0b1b890},
        {-84958796,  30019920,  -84422372,  30510960,  0x0b1c090},
        {-84422372,  30019920,  -83885948,  30510960,  0x0b1c890},
        {-83885948,  30019920,  -83349524,  30510960,  0x0b1d090},
        {-85602504,  29528880,  -85066080,  30019920,  0x0b0d890},
        {-85066080,  29528880,  -84529656,  30019920,  0x0b0e090},
        {-84529656,  29528880,  -83993232,  30019920,  0x0b0e890},
        {-83993232,  29528880,  -83456808,  30019920,  0x0b0f090},
        {-94618000,  24450000,  -75350000,  36688000,  0x30e0216},
        {-87641000,  24450000,  -79900000,  31002000,  0x0020217},
        {-94607977,  39060255,  -94497462,  39146745,  0x001000a}, // 1MO
        {-94613300,  38886400,  -94252133,  39311600,  0xf040447},
        {-90537000,  38454800,  -90180703,  38856000,  0xe890447},
        {-93488269,  37041310,  -93202931,  37270089,  0x9ee004b},
        {-92469885,  38846160,  -92198115,  39057929,  0x931004b},
        {-90826303,  38644160,  -90556298,  38855929,  0x931004b},
        {-94584500,  37025770,  -94281090,  37210000,  0x931044b},
        {-94905968,  39677660,  -94706601,  39968000,  0x931044b},
        {-94840000,  36471156,  -91800000,  39312000,  0x0b50011},
        {-91800000,  35995500,  -89098843,  39250000,  0x4920015},
        {-95774700,  39000000,  -90649996,  40613641,  0x013000d},
        {-104060000, 35995500,  -89100000,  49384500,  0x0010216},
        {-95774700,  35995500,  -89100000,  40613641,  0x0020217},
        {-97568855,  35424755,  -97463145,  35511245,  0x001000a}, // 1OK
        {-97784000,  35177300,  -97266561,  35713520,  0x022000c},
        {-96146330,  36114910,  -95933470,  36287889,  0x782004b},
        {-95933470,  36114910,  -95720610,  36287889,  0x782004b},
        {-96146330,  35941931,  -95933470,  36114910,  0x782004b},
        {-95933470,  35941931,  -95720610,  36114910,  0x782004b},
        {-98496180,  34549620,  -98315221,  34699379,  0x680004b},
        {-97964168,  36318220,  -97778633,  36467979,  0x680004b},
        {-97154444,  36048020,  -96970157,  36197779,  0x680004b},
        {-95414944,  35675420,  -95230657,  35825179,  0x680004b},
        {-96046068,  36686420,  -95860533,  36836179,  0x680004b},
        {-96900000,  33615700,  -94431300,  37002500,  0x0d80011},
        {-99450000,  33719000,  -96900000,  37002500,  0x026000d},
        {-103002856, 36494024,  -102403936, 37001432,  0x0b05090},
        {-102403936, 36494024,  -101805016, 37001432,  0x0b05890},
        {-101805016, 36494024,  -101206096, 37001432,  0x0b06090},
        {-101206096, 36495092,  -100607176, 37002500,  0x0b06890},
        {-100607176, 36495092,  -100008256, 37002500,  0x0b07090},
        {-100009037, 36506004,  -99420533,  37002500,  0x0b07890},
        {-100009714, 36325924,  -99431626,  36816964,  0x0b18090},
        {-100009714, 35834884,  -99436834,  36325924,  0x0b18890},
        {-100009714, 35343844,  -99436834,  35834884,  0x0b09090},
        {-100004506, 34852804,  -99436834,  35343844,  0x0b09890},
        {-100004506, 34361764,  -99442042,  34852804,  0x0b1a090},
        {-103002856, 36494024,  -94610000,  37001432,  0x02ee091},
        {-100004500, 33615700,  -97200000,  36494024,  0x0bbe891},
        {-97200000,  33615700,  -94431300,  36494024,  0x0bcf091},
        {-103005000, 33615700,  -94431300,  37002500,  0x0020217},
        {-96923000,  46832555,  -96767400,  46905500,  0x019000a}, // 1ND
        {-97244062,  46704020,  -96739538,  47049979,  0xf040047},
        {-101025865, 46640600,  -100542136, 46975489,  0xe890047},
        {-97190356,  47819160,  -96875644,  48030929,  0x931004b},
        {-101469600, 48158600,  -101125864, 48320100,  0x864044b},
        {-102930962, 46782340,  -102649038, 46975659,  0x864004b},
        {-98848962,  46814340,  -98567038,  47007659,  0x864004b},
        {-103761647, 48050340,  -103474353, 48243659,  0x864004b},
        {-96833820,  46168340,  -96554581,  46361659,  0x864004b},
        {-104049000, 45925000,  -101549000, 49000700,  0x0df0011},
        {-101549000, 45925000,  -99049000,  49000700,  0x029000d},
        {-99049000,  45925000,  -96554000,  49000700,  0x4fc0015},
        {-104060000, 35995500,  -89100000,  49384500,  0x0010216},
        {-104050000, 45925000,  -96554000,  49000700,  0x0020217},
        {-122395426, 47562755,  -122268574, 47649245,  0x001000a}, // 1WA
        {-122423300, 47060000,  -122065000, 48019000,  0x03b000c},
        {-117520000, 47587000,  -117136414, 47759000,  0x931044b},
        {-122625130, 47067340,  -122423006, 47336837,  0x864044b},
        {-122726800, 45576250,  -122399381, 45737800,  0x864044b},
        {-122650490, 48692740,  -122360511, 48886059,  0x864004b},
        {-119372900, 46161500,  -119042311, 46324700,  0x864044b},
        {-120655500, 46539500,  -120341031, 46711059,  0x864044b},
        {-124770000, 45543500,  -122065000, 49002500,  0x0e20011},
        {-122065000, 45600000,  -119544000, 49002500,  0x02a000d},
        {-119544000, 45900000,  -116916000, 49002500,  0x4e00015},
        {-124800000, 40994700,  -104018000, 49002500,  0x29e0216},
        {-124800000, 45543500,  -116916000, 49002500,  0x0020217},
        {-96790921,  43498655,  -96672718,  43585145,  0x001000a}, // 1SD
        {-96973306,  43325420,  -96500495,  43671379,  0xf040047},
        {-103415302, 43934600,  -102953899, 44269489,  0xe890047},
        {-98599527,  45372710,  -98354473,  45545689,  0x782004b},
        {-96939165,  44215410,  -96698436,  44388389,  0x782004b},
        {-97226726,  44818310,  -96984075,  44991289,  0x782004b},
        {-98155464,  43627710,  -97917137,  43800689,  0x782004b},
        {-97502642,  42842710,  -97268159,  43015689,  0x782004b},
        {-100452765, 44292810,  -100212036, 44465789,  0x782004b},
        {-98334465,  44284010,  -98093736,  44456989,  0x782004b},
        {-97019304,  42711720,  -96816297,  42861479,  0x680004b},
        {-104060000, 42990000,  -101420000, 45945400,  0x026000d},
        {-101420000, 42990000,  -98800000,  45945400,  0x4a40015},
        {-98800000,  42479750,  -96436000,  45945400,  0x0ed0011},
        {-104060000, 35995500,  -89100000,  49384500,  0x0010216},
        {-104060000, 42479750,  -96436000,  45945400,  0x0020217},
        {-95994500,  41228690,  -95913700,  41289799,  0x2a7004a}, // 1NE
        {-96740645,  40782990,  -96660355,  40844099,  0x2a7004a},
        {-96298718,  41043220,  -95841283,  41389179,  0xf040047},
        {-96887004,  40632600,  -96446997,  40967489,  0xe890047},
        {-98480300,  40824140,  -98226300,  41017459,  0x864004b},
        {-99208000,  40602340,  -98954000,  40795659,  0x864004b},
        {-96589406,  41297340,  -96333795,  41490659,  0x864004b},
        {-98524238,  40501510,  -98296963,  40674489,  0x782004b},
        {-100883059, 41046210,  -100654342, 41219189,  0x782004b},
        {-97542281,  41948610,  -97309720,  42121589,  0x782004b},
        {-97421259,  41320610,  -97192542,  41493589,  0x782004b},
        {-104053550, 39999700,  -101050000, 43001710,  0x4480015},
        {-101050000, 39999700,  -98190000,  43001710,  0x024000d},
        {-98190000,  39999700,  -95308200,  43001710,  0x0c40011},
        {-104060000, 35995500,  -89100000,  49384500,  0x0010216},
        {-104060000, 39999700,  -95308200,  43001710,  0x0020217},
        {-97388116,  37648755,  -97279523,  37735245,  0x001000a}, // 1KS
        {-94950000,  38787600,  -94593014,  39214979,  0xf040447},
        {-97548236,  37524600,  -97127764,  37859489,  0xe890047},
        {-95834964,  38925690,  -95521036,  39170309,  0xa9e004b},
        {-95391964,  38869500,  -94948561,  39042600,  0xa9e044b},
        {-96728964,  39061690,  -96415036,  39306309,  0xa9e004b},
        {-97730047,  38710510,  -97438354,  38939289,  0x9ee004b},
        {-102052000, 36990000,  -99600000,  40003300,  0x4a60015},
        {-99600000,  36990000,  -97100000,  40003300,  0x026000d},
        {-97100000,  36990000,  -94580000,  40003300,  0x0cd0011},
        {-104060000, 35995500,  -89100000,  49384500,  0x0010216},
        {-102052000, 36990000,  -94580000,  40003300,  0x0020217},
        {-116292582, 43566455,  -116173418, 43652945,  0x001000a}, // 1ID
        {-116981452, 43414000,  -116092900, 43760000,  0x016000c},
        {-112190333, 43352610,  -111877668, 43581389,  0x9ee004b},
        {-112619833, 42783860,  -112332768, 42995629,  0x931004b},
        {-117044000, 47642000,  -116686516, 47826600,  0x931044b},
        {-114577000, 42478000,  -114349105, 42744600,  0x931044b},
        {-117066445, 46349160,  -116760556, 46560929,  0x931004b},
        {-117244000, 41987500,  -114150000, 44990000,  0x0c00011},
        {-114150000, 41987500,  -111043000, 44990000,  0x023000d},
        {-117040000, 48420000,  -116540000, 49002000,  0x0e40090},
        {-116540000, 48420000,  -116040000, 49002000,  0x0e40890},
        {-117049723, 47934480,  -116357059, 48425520,  0x0b11090},
        {-116357059, 47934480,  -115664395, 48425520,  0x0b11890},
        {-117049723, 47443440,  -116362267, 47934480,  0x0b12090},
        {-116362267, 47443440,  -115674811, 47934480,  0x0b12890},
        {-116224775, 47443440,  -115537319, 47934480,  0x0b13090},
        {-117044515, 46952400,  -116362267, 47443440,  0x0b03890},
        {-116362267, 46952400,  -115680019, 47443440,  0x0b04090},
        {-115680019, 46952400,  -114997771, 47443440,  0x0b04890},
        {-117078627, 46461360,  -116401587, 46952400,  0x0b05090},
        {-116401587, 46461360,  -115724547, 46952400,  0x0b05890},
        {-115724547, 46461360,  -115047507, 46952400,  0x0b06090},
        {-115047507, 46461360,  -114370467, 46952400,  0x0b06890},
        {-114912099, 46461360,  -114235059, 46952400,  0x0b07090},
        {-117073419, 45970320,  -116406795, 46461360,  0x0b17890},
        {-116406795, 45970320,  -115740171, 46461360,  0x0b18090},
        {-115740171, 45970320,  -115073547, 46461360,  0x0b18890},
        {-115073547, 45970320,  -114406923, 46461360,  0x0b19090},
        {-114940222, 45970320,  -114273598, 46461360,  0x0b19890},
        {-116934886, 45479280,  -116273470, 45970320,  0x0b1a090},
        {-116273470, 45479280,  -115612054, 45970320,  0x0b1a890},
        {-115612054, 45479280,  -114950638, 45970320,  0x0b1b090},
        {-114950638, 45479280,  -114289222, 45970320,  0x0b1b890},
        {-114289222, 45479280,  -113627806, 45970320,  0x0b1c090},
        {-116934886, 44988240,  -116278678, 45479280,  0x0b0c890},
        {-116278678, 44988240,  -115622470, 45479280,  0x0b0d090},
        {-115622470, 44988240,  -114966262, 45479280,  0x0b0d890},
        {-114966262, 44988240,  -114310054, 45479280,  0x0b0e090},
        {-114310054, 44988240,  -113653846, 45479280,  0x0b0e890},
        {-114047571, 44988240,  -113391363, 45479280,  0x0b0f090},
        {-124800000, 40994700,  -104018000, 49002500,  0x29e0216},
        {-117244000, 41987500,  -111043000, 49002500,  0x0020217},
        {-111949999, 40700455,  -111836601, 40786945,  0x001000a}, // 1UT
        {-112132000, 40330000,  -111736000, 41050000,  0x02e000c},
        {-111791024, 40162510,  -111492976, 40391289,  0x9ee004b},
        {-111815044, 39960860,  -111539156, 40172629,  0x931004b},
        {-112180203, 41045360,  -111900197, 41257129,  0x931004b},
        {-112175903, 41253160,  -111895897, 41464929,  0x931004b},
        {-113710862, 37002660,  -113446739, 37214429,  0x931004b},
        {-114053000, 38660000,  -111540000, 42001700,  0x0db0011},
        {-111540000, 38660000,  -109041000, 42001700,  0x028000d},
        {-114053000, 36997500,  -109041000, 38660000,  0x26a0015},
        {-125000000, 31332000,  -102041524, 42010000,  0x2b30216},
        {-114053000, 36997500,  -109041000, 42001700,  0x0020217},
        {-93317243,  44939055,  -93196157,  45025545,  0x001000a}, // 1MN
        {-93597104,  44734180,  -92940896,  45225220,  0x001000c},
        {-92686316,  43888590,  -92349285,  44133209,  0xa9e004b},
        {-92345170,  46644390,  -91991831,  46889009,  0xa9e004b},
        {-94373172,  45456990,  -94026628,  45701609,  0xa9e004b},
        {-93429192,  44526810,  -93110808,  44755589,  0x9ee004b},
        {-94867251,  43490005,  -91202958,  46171195,  0x0a80011},
        {-94876486,  46171195,  -91003656,  48852385,  0x001000d},
        {-97030000,  43490000,  -94867251,  48000000,  0x6560015},
        {-104060000, 35995500,  -89100000,  49384500,  0x0010016},
        {-97239500,  43490000,  -89480000,  49384500,  0x0020217},
        {-83104860,  42321555,  -82988579,  42408045,  0x001000a}, // 1MI
        {-83518480,  42210500,  -82867100,  42679920,  0x01d000c},
        {-85829362,  42842210,  -85519239,  43070989,  0x9ee004b},
        {-84688433,  42625660,  -84401368,  42837429,  0x931004b},
        {-83846000,  42159260,  -83514582,  42341100,  0x931044b},
        {-83814400,  42882000,  -83580405,  43141700,  0x931044b},
        {-83406000,  41987000,  -83136897,  42211000,  0x931044b},
        {-86548000,  41695000,  -82416000,  43990000,  0x0910011},
        {-86517500,  43990000,  -83185600,  46774250,  0x021000d},
        {-89276718,  47664572,  -88589262,  48155612,  0x0b10890},
        {-88589262,  47762780,  -87896598,  48253820,  0x0b11090},
        {-83134937,  43983196,  -82489145,  44474236,  0x0b01890},
        {-87062480,  41734480,  -86437520,  42225520,  0x0b02090},
        {-88929306,  47048580,  -88247058,  47539620,  0x0b05090},
        {-88247058,  47048580,  -87564810,  47539620,  0x0b05890},
        {-90430252,  46557540,  -89753212,  47048580,  0x0b06090},
        {-89753212,  46557540,  -89076172,  47048580,  0x0b06890},
        {-89076172,  46557540,  -88399132,  47048580,  0x0b07090},
        {-88399132,  46557540,  -87722092,  47048580,  0x0b07890},
        {-87722092,  46557540,  -87045052,  47048580,  0x0b08090},
        {-90425044,  46066500,  -89758420,  46557540,  0x0b18890},
        {-89758420,  46066500,  -89091796,  46557540,  0x0b19090},
        {-89091796,  46066500,  -88425172,  46557540,  0x0b19890},
        {-88425172,  46066500,  -87758548,  46557540,  0x0b1a090},
        {-87758548,  46066500,  -87091924,  46557540,  0x0b1a890},
        {-87091924,  46066500,  -86425300,  46557540,  0x0b1b090},
        {-89086588,  45575460,  -88425172,  46066500,  0x0b1b890},
        {-88425172,  45575460,  -87763756,  46066500,  0x0b1c090},
        {-87763756,  45575460,  -87102340,  46066500,  0x0b1c890},
        {-87102340,  45575460,  -86440924,  46066500,  0x0b1d090},
        {-88094464,  45084420,  -87438256,  45575460,  0x0b0d890},
        {-87438256,  45084420,  -86782048,  45575460,  0x0b0e090},
        {-86782048,  45084420,  -86125840,  45575460,  0x0b0e890},
        {-92890000,  36490000,  -66900000,  48295000,  0x2c00216},
        {-90440000,  41695000,  -82122500,  48295000,  0x0020217},
        {-104861899, 41093855,  -104747540, 41180345,  0x001000a}, // 1WY
        {-104981518, 41011720,  -104524083, 41357679,  0xf040047},
        {-109554399, 41392400,  -109111601, 41727289,  0xe890047},
        {-106444028, 42770340,  -106181973, 42963659,  0x864004b},
        {-105718806, 41214340,  -105463195, 41407659,  0x864004b},
        {-105636518, 44179340,  -105367482, 44372659,  0x864004b},
        {-107077326, 44710510,  -106834675, 44883489,  0x782004b},
        {-111056959, 41181510,  -110828242, 41354489,  0x782004b},
        {-108513842, 42938510,  -108279359, 43111489,  0x782004b},
        {-110930303, 43393510,  -110693898, 43566489,  0x782004b},
        {-111057000, 40994700,  -108740000, 45006000,  0x02e000d},
        {-108740000, 40994700,  -106400000, 45006000,  0x5a70015},
        {-106400000, 40994700,  -104052000, 45006000,  0x0fd0011},
        {-124800000, 40994700,  -104018000, 49002500,  0x29e0216},
        {-111057000, 40994700,  -104018000, 45006000,  0x0020217},
        {-122717643, 45479755,  -122595596, 45566245,  0x001000a}, // 1OR
        {-123152000, 45265000,  -122350000, 45657000,  0x019000c},
        {-123244604, 43957000,  -122869133, 44149000,  0x9ee044b},
        {-123249000, 44837160,  -122933376, 45036400,  0x931044b},
        {-123390000, 44525800,  -122980935, 44678300,  0x931044b},
        {-122977000, 42217000,  -122760169, 42495000,  0x931044b},
        {-121460886, 43952160,  -121169115, 44163929,  0x931004b},
        {-124566400, 41991750,  -120730000, 44520000,  0x09e0011},
        {-120730000, 41991750,  -116886000, 44520000,  0x01d000d},
        {-124100000, 44520000,  -117280000, 46010000,  0x2120015},
        {-124800000, 40994700,  -104018000, 49002500,  0x29e0016},
        {-124800000, 41991750,  -116463200, 46299100,  0x0020217},
        {-105040738, 39695755,  -104929262, 39782245,  0x001000a}, // 1CO
        {-105241764, 39516880,  -104637636, 40007920,  0x001000c},
        {-104877300, 38807310,  -104664781, 38987900,  0x782044b},
        {-104857672, 38664000,  -104659271, 38808000,  0x680044b},
        {-105152984, 40470920,  -104956217, 40620679,  0x680044b},
        {-105152152, 40321161,  -104957049, 40470920,  0x680044b},
        {-104682040, 38205720,  -104492761, 38355479,  0x680044b},
        {-105297652, 39962120,  -105102549, 40111879,  0x680004b},
        {-104822952, 40337000,  -104587398, 40461000,  0x680044b},
        {-105201252, 40082520,  -105006149, 40232279,  0x680004b},
        {-108673896, 39021620,  -108429268, 39139200,  0x680044b},
        {-104920000, 39327700,  -104745161, 39493300,  0x680044b},
        {-105437698, 38322205,  -102041524, 41003395,  0x0a90011},
        {-109060257, 38322205,  -105437698, 41003395,  0x01e000d},
        {-109060257, 36992427,  -102041524, 38322205,  0x1d30015},
        {-125000000, 31332000,  -102041524, 42010000,  0x2b30216},
        {-109060257, 36992427,  -102041524, 41003445,  0x0020217},
        {-115212855, 36086155,  -115107145, 36172645,  0x001000a}, // 1NV
        {-115412000, 35913000,  -114765200, 36338000,  0x01b000c},
        {-120000000, 39016641,  -119553136, 39702979,  0x0f20010},
        {-117286219, 34950000,  -114039000, 37631190,  0x0a80011},
        {-120000000, 38480000,  -117000000, 41310000,  0x021000d},
        {-117000000, 38480000,  -114039000, 41310000,  0x4250015},
        {-125000000, 31332000,  -102041524, 42010000,  0x2b30016},
        {-120008000, 34950000,  -114039000, 42010000,  0x0020217},
        {-112124933, 33404755,  -112022106, 33491245,  0x001000a}, // 1AZ
        {-111252000, 32029300,  -110679700, 32482000,  0x01d000c},
        {-112453072, 33611384,  -112349284, 33697874,  0x001008b},
        {-112349284, 33611384,  -112245496, 33697874,  0x001088b},
        {-112245496, 33611384,  -112141708, 33697874,  0x001108b},
        {-112141708, 33611384,  -112037920, 33697874,  0x001188b},
        {-112037920, 33611384,  -111934132, 33697874,  0x001208b},
        {-111934132, 33611384,  -111830344, 33697874,  0x001288b},
        {-112327566, 33524894,  -112224739, 33611384,  0x001308b},
        {-112224739, 33524894,  -112121912, 33611384,  0x001388b},
        {-112121912, 33524894,  -112019085, 33611384,  0x001408b},
        {-112019085, 33524894,  -111916258, 33611384,  0x001488b},
        {-111916258, 33524894,  -111813431, 33611384,  0x001508b},
        {-112404686, 33438404,  -112301859, 33524894,  0x001588b},
        {-112301859, 33438404,  -112199032, 33524894,  0x001608b},
        {-112199032, 33438404,  -112096205, 33524894,  0x001688b},
        {-112096205, 33438404,  -111993378, 33524894,  0x001708b},
        {-111993378, 33438404,  -111890551, 33524894,  0x001788b},
        {-111890551, 33395159,  -111787724, 33481649,  0x001808b},
        {-111787724, 33395159,  -111684897, 33481649,  0x001888b},
        {-111684897, 33395159,  -111582070, 33481649,  0x001908b},
        {-112199032, 33351914,  -112096205, 33438404,  0x001988b},
        {-112096205, 33351914,  -111993378, 33438404,  0x001a08b},
        {-111993378, 33351914,  -111890551, 33438404,  0x001a88b},
        {-111890551, 33308669,  -111787724, 33395159,  0x001b08b},
        {-111787724, 33308669,  -111684897, 33395159,  0x001b88b},
        {-111684897, 33308669,  -111582070, 33395159,  0x001c08b},
        {-111582070, 33377861,  -111479243, 33464351,  0x001c88b},
        {-112096205, 33265424,  -111993378, 33351914,  0x001d08b},
        {-111993378, 33265424,  -111890551, 33351914,  0x001d88b},
        {-111890551, 33222179,  -111787724, 33308669,  0x001e08b},
        {-111787724, 33222179,  -111684897, 33308669,  0x001e88b},
        {-111684897, 33222179,  -111582070, 33308669,  0x001f08b},
        {-113142760, 31534379,  -110014705, 34215569,  0x0a90011},
        {-113142760, 34215569,  -110000000, 37004261,  0x020000d},
        {-114818269, 31967000,  -113142760, 37004261,  0x70c0015},
        {-125000000, 31332000,  -102041524, 42010000,  0x2b30016},
        {-114818269, 31332000,  -109045152, 37004261,  0x0020217},
        {-106701894, 35040755,  -106597145, 35127245,  0x001000a}, // 1NM
        {-106802610, 34603010,  -106473000, 35388000,  0x033000c},
        {-106137715, 35517260,  -105878886, 35729029,  0x931004b},
        {-106867644, 32216840,  -106639957, 32410159,  0x864004b},
        {-104638186, 33297340,  -104407814, 33490659,  0x864004b},
        {-108250451, 36677240,  -107963228, 36838416,  0x864044b},
        {-103356197, 34305940,  -103122603, 34499259,  0x864004b},
        {-103267649, 32621340,  -103038351, 32814659,  0x864004b},
        {-108530456, 34319104,  -105313028, 37000294,  0x0a90011},
        {-109050173, 31772000,  -106020000, 34330000,  0x001000d},
        {-106020000, 31990000,  -103050000, 34522000,  0x0010015},
        {-125000000, 31332000,  -102041524, 42010000,  0x2b30016},
        {-109050173, 31332000,  -103002065, 37000294,  0x0020217},
        {-108620453, 45738390,  -108470421, 45805350,  0x018000a}, // 1MT
        {-108823000, 45639630,  -108327314, 45877000,  0xc730447},
        {-114341868, 46778000,  -113922132, 47037709,  0xbde0447},
        {-111568067, 47378190,  -111165533, 47651609,  0xbde0047},
        {-111265603, 45604360,  -110965597, 45816129,  0x931004b},
        {-112655077, 45901240,  -112378523, 46094559,  0x864004b},
        {-112133620, 46529640,  -111854381, 46722959,  0x864004b},
        {-114424447, 48057340,  -114137153, 48250659,  0x864004b},
        {-109828990, 48453340,  -109539011, 48646659,  0x864004b},
        {-105980620, 46311340,  -105701381, 46504659,  0x864004b},
        {-115540320, 46090062,  -111727072, 48771252,  0x0a90011},
        {-111735414, 45285705,  -107951957, 47966895,  0x001000d},
        {-107951957, 45285705,  -104168500, 47966895,  0x0010015},
        {-124800000, 40994700,  -104018000, 49002500,  0x29e0016},
        {-116050004, 44358210,  -104018000, 49002500,  0x0020217},
        {-118307394, 34003755,  -118203606, 34090245,  0x001000a}, // 1CA
        {-118439191, 33698979,  -117804152, 34126659,  0x01b000c},
        {-119847764, 36686890,  -119696237, 36809199,  0x54f004b},
        {-121544372, 38520890,  -121388428, 38643199,  0x54f004b},
        {-122311000, 37744600,  -122183650, 37892000,  0x54f044b},
        {-117189693, 32679200,  -117087108, 32765689,  0x3c1004b},
        {-117087108, 32679200,  -116984523, 32765689,  0x3c1004b},
        {-117117883, 32592711,  -117015298, 32679200,  0x3c1004b},
        {-122514600, 37747370,  -122368492, 37811540,  0x3c1044b},
        {-122508300, 37683200,  -122362192, 37747370,  0x3c1044b},
        {-122057896, 37295800,  -121949304, 37382289,  0x3c1004b},
        {-121949304, 37295800,  -121840712, 37382289,  0x3c1004b},
        {-119071855, 35329800,  -118966146, 35416289,  0x3c1004b},
        {-117451894, 33896800,  -117348107, 33983289,  0x3c1004b},
        {-121351056, 37923300,  -121241744, 38009789,  0x3c1004b},
        {-121044296, 37614400,  -120935704, 37700889,  0x3c1004b},
        {-122054496, 37494600,  -121945904, 37581089,  0x3c1004b},
        {-118338500, 34126659,  -118215288, 34200000,  0x3c1044b},
        {-118033000, 33633300,  -117896381, 33698979,  0x3c1044b},
        {-117845994, 33635600,  -117742207, 33722089,  0x3c1004b},
        {-117808794, 34017900,  -117705007, 34104389,  0x3c1004b},
        {-117705994, 34023100,  -117602207, 34109589,  0x3c1004b},
        {-117609194, 34065500,  -117505407, 34151989,  0x3c1004b},
        {-117508294, 34056800,  -117404507, 34143289,  0x3c1004b},
        {-117344754, 34082100,  -117240247, 34168589,  0x3c1004b},
        {-122774737, 38406800,  -122664464, 38493289,  0x3c1004b},
        {-121690875, 36642100,  -121583725, 36728589,  0x3c1004b},
        {-117621894, 33825300,  -117518107, 33911789,  0x3c1004b},
        {-118174154, 34126659,  -118019513, 34185000,  0x3c1044b},
        {-122156696, 37623800,  -122048104, 37710289,  0x3c1004b},
        {-124249085, 41354968,  -123629333, 41846008,  0x0b00090},
        {-123629333, 41354968,  -123009581, 41846008,  0x0b00890},
        {-123009581, 41354968,  -122389829, 41846008,  0x0b01090},
        {-122389829, 41354968,  -121770077, 41846008,  0x0b01890},
        {-124187110, 40863928,  -123572566, 41354968,  0x0b02090},
        {-123572566, 40863928,  -122958022, 41354968,  0x0b02890},
        {-122958022, 40863928,  -122343478, 41354968,  0x0b03090},
        {-122343478, 40863928,  -121728934, 41354968,  0x0b03890},
        {-124408345, 40372888,  -123793801, 40863928,  0x0b04090},
        {-123793801, 40372888,  -123179257, 40863928,  0x0b04890},
        {-123179257, 40372888,  -122564713, 40863928,  0x0b05090},
        {-122564713, 40372888,  -121950169, 40863928,  0x0b05890},
        {-124366265, 39881848,  -123756929, 40372888,  0x0b06090},
        {-123756929, 39881848,  -123147593, 40372888,  0x0b06890},
        {-123147593, 39881848,  -122538257, 40372888,  0x0b07090},
        {-122538257, 39881848,  -121928921, 40372888,  0x0b07890},
        {-123921449, 39390808,  -123317321, 39881848,  0x0b08090},
        {-123317321, 39390808,  -122713193, 39881848,  0x0b08890},
        {-122713193, 39390808,  -122109065, 39881848,  0x0b09090},
        {-122109065, 39390808,  -121504937, 39881848,  0x0b09890},
        {-121504937, 39390808,  -120900809, 39881848,  0x0b0a090},
        {-123831664, 38899768,  -123232744, 39390808,  0x0b1a890},
        {-123232744, 38899768,  -122633824, 39390808,  0x0b1b090},
        {-122633824, 38899768,  -122034904, 39390808,  0x0b1b890},
        {-122034904, 38899768,  -121435984, 39390808,  0x0b1c090},
        {-121435984, 38899768,  -120837064, 39390808,  0x0b1c890},
        {-123707476, 38409480,  -123113764, 38900520,  0x0010088},
        {-123113764, 38409480,  -122520052, 38900520,  0x0010888},
        {-122520052, 38409480,  -121926340, 38900520,  0x0011088},
        {-121926340, 38409480,  -121332628, 38900520,  0x0011888},
        {-121332628, 38409480,  -120738916, 38900520,  0x0012088},
        {-123108556, 37918440,  -122520052, 38409480,  0x0012888},
        {-122520052, 37918440,  -121931548, 38409480,  0x0013088},
        {-121931548, 37918440,  -121343044, 38409480,  0x0013888},
        {-121343044, 37918440,  -120754540, 38409480,  0x0014088},
        {-122737799, 37427400,  -122149295, 37918440,  0x0014888},
        {-122149295, 37427400,  -121560791, 37918440,  0x0015088},
        {-121560791, 37427400,  -120972287, 37918440,  0x0015888},
        {-120972287, 37427400,  -120383783, 37918440,  0x0016088},
        {-122443547, 36936360,  -121860251, 37427400,  0x0016888},
        {-121860251, 36936360,  -121276955, 37427400,  0x0017088},
        {-121276955, 36936360,  -120693659, 37427400,  0x0017888},
        {-120693659, 36936360,  -120110363, 37427400,  0x0018088},
        {-120110363, 36936360,  -119527067, 37427400,  0x0018888},
        {-121983368, 36445320,  -121405280, 36936360,  0x0019088},
        {-121405280, 36445320,  -120827192, 36936360,  0x0019888},
        {-120827192, 36445320,  -120249104, 36936360,  0x001a088},
        {-120249104, 36445320,  -119671016, 36936360,  0x001a888},
        {-119671016, 36445320,  -119092928, 36936360,  0x001b088},
        {-121434184, 35954280,  -120861304, 36445320,  0x001b888},
        {-120861304, 35954280,  -120288424, 36445320,  0x001c088},
        {-120288424, 35954280,  -119715544, 36445320,  0x001c888},
        {-119715544, 35954280,  -119142664, 36445320,  0x001d088},
        {-119142664, 35954280,  -118569784, 36445320,  0x001d888},
        {-120918592, 35463240,  -120345712, 35954280,  0x001e088},
        {-120345712, 35463240,  -119772832, 35954280,  0x001e888},
        {-119772832, 35463240,  -119199952, 35954280,  0x001f088},
        {-119199952, 35463240,  -118627072, 35954280,  0x001008c},
        {-118627072, 35463240,  -118054192, 35954280,  0x001088c},
        {-120930571, 34972200,  -120362899, 35463240,  0x001108c},
        {-120362899, 34972200,  -119795227, 35463240,  0x001188c},
        {-119795227, 34972200,  -119227555, 35463240,  0x001208c},
        {-119227555, 34972200,  -118659883, 35463240,  0x001288c},
        {-118659883, 34972200,  -118092211, 35463240,  0x001308c},
        {-118092211, 34972200,  -117524539, 35463240,  0x001388c},
        {-120686472, 34481160,  -120124008, 34972200,  0x001408c},
        {-120124008, 34481160,  -119561544, 34972200,  0x001488c},
        {-119561544, 34481160,  -118999080, 34972200,  0x001508c},
        {-118999080, 34481160,  -118436616, 34972200,  0x001588c},
        {-118436616, 34481160,  -117874152, 34972200,  0x001608c},
        {-117874152, 34481160,  -117311688, 34972200,  0x001688c},
        {-117311688, 34481160,  -116749224, 34972200,  0x001708c},
        {-120510000, 34246850,  -119352500, 34481200,  0x00e788c},
        {-119360520, 33990180,  -118798056, 34481220,  0x001808c},
        {-118798056, 33990180,  -118235592, 34481220,  0x001888c},
        {-118235592, 33990180,  -117673128, 34481220,  0x001908c},
        {-117673128, 33990180,  -117110664, 34481220,  0x001988c},
        {-117110664, 33990180,  -116548200, 34481220,  0x001a08c},
        {-118494742, 33499140,  -117937486, 33990180,  0x001a88c},
        {-117937486, 33499140,  -117380230, 33990180,  0x001b08c},
        {-117380230, 33499140,  -116822974, 33990180,  0x001b88c},
        {-116822974, 33499140,  -116265718, 33990180,  0x001c08c},
        {-116265718, 33302724,  -115708462, 33793764,  0x001c88c},
        {-117770309, 33008099,  -117218261, 33499139,  0x001d08c},
        {-117218261, 33008099,  -116666213, 33499139,  0x001d88c},
        {-117301068, 32528000,  -116749020, 33019040,  0x001e08c},
        {-116749020, 32528000,  -116196972, 33019040,  0x001e88c},
        {-115730660, 32650000,  -115280478, 33250000,  0x026f08c},
        {-125000000, 31332000,  -102041524, 42010000,  0x2b30016},
        {-125000000, 32528000,  -114131000, 42010000,  0x0020217},
        {-95412011,  29719755,  -95313028,  29806245,  0x001000a}, // 1TX
        {-97083024,  32635688,  -96530976,  33126728,  0x001000c},
        {-97813498,  30205890,  -97672503,  30328199,  0x54f004b},
        {-97402436,  32676990,  -97257364,  32799299,  0x54f004b},
        {-106532087, 31729990,  -106388714, 31852299,  0x54f004b},
        {-97190000,  32633750,  -97081543,  32797199,  0x54f044b},
        {-97469150,  27718900,  -97371850,  27805389,  0x3c1004b},
        {-99528000,  27462400,  -99441939,  27560050,  0x3c1044b},
        {-95511811,  29763000,  -95412589,  29849489,  0x3c1004b},
        {-95412589,  29806244,  -95313367,  29892733,  0x3c1004b},
        {-95313367,  29763000,  -95214145,  29849489,  0x3c1004b},
        {-95511811,  29676511,  -95412589,  29763000,  0x3c1004b},
        {-95412589,  29633266,  -95313367,  29719755,  0x3c1004b},
        {-95313367,  29676511,  -95214145,  29763000,  0x3c1004b},
        {-95214145,  29633266,  -95114923,  29719755,  0x3c1004b},
        {-98683711,  29396300,  -98584489,  29482789,  0x3c1004b},
        {-98584489,  29396300,  -98485267,  29482789,  0x3c1004b},
        {-98485267,  29396300,  -98386045,  29482789,  0x3c1004b},
        {-98683471,  29309811,  -98584730,  29396300,  0x3c1004b},
        {-98584730,  29309811,  -98485989,  29396300,  0x3c1004b},
        {-98485989,  29309811,  -98387248,  29396300,  0x3c1004b},
        {-101923333, 33524300,  -101820267, 33610789,  0x3c1004b},
        {-101891855, 35160300,  -101786146, 35246789,  0x3c1004b},
        {-97527929,  25886800,  -97432071,  25973289,  0x3c1004b},
        {-94189851,  30046800,  -94090149,  30133289,  0x3c1004b},
        {-98287929,  26176800,  -98192071,  26263289,  0x3c1004b},
        {-97212692,  31500000,  -97111308,  31586489,  0x3c1004b},
        {-99790933,  32406800,  -99689068,  32493289,  0x3c1004b},
        {-98571894,  33856800,  -98468107,  33943289,  0x3c1004b},
        {-96700020,  28824583,  -93661338,  31505773,  0x0a80011},
        {-99738702,  28824583,  -96700020,  31505773,  0x001000d},
        {-98704954,  31505773,  -95576899,  34186963,  0x0010015},
        {-103070000, 34590000,  -99990000,  36501000,  0x0925091},
        {-103070000, 32020000,  -100150000, 34590000,  0x0ab5891},
        {-100150000, 32020000,  -97240000,  34590000,  0x0ab6091},
        {-97260000,  32020000,  -94010000,  34000000,  0x08e6891},
        {-106646000, 30710000,  -101417000, 32020000,  0x05a7091},
        {-105240000, 28940000,  -101417000, 30710000,  0x07a7891},
        {-101417000, 29880000,  -98790000,  32020000,  0x0a38091},
        {-98780000,  29880000,  -96144000,  32020000,  0x0a28891},
        {-96144000,  29880000,  -93508000,  32020000,  0x0a29091},
        {-101417000, 27750000,  -98790000,  29880000,  0x0a19891},
        {-98780000,  27750000,  -96144000,  29880000,  0x0a0a091},
        {-96144000,  27750000,  -93800000,  29880000,  0x0aaa891},
        {-99860000,  25837000,  -96800000,  27750000,  0x08cb091},
        {-99738702,  29880000,  -96700020,  32020000,  0x097e091},
        {-99738702,  27750000,  -96700020,  29880000,  0x095f091},
        {-106646000, 25837000,  -93508000,  36501000,  0x0020217},
        {-149913412, 61137755,  -149736588, 61224245,  0x001000a}, // 1AK
        {-150072300, 61050725,  -149420094, 61426800,  0xf040447},
        {-147997341, 64703800,  -147061649, 64982000,  0xe890447},
        {-134675987, 58221060,  -134274214, 58432829,  0x931044b},
        {-149884000, 61425000,  -149338963, 61568000,  0x864044b},
        {-149884000, 61568000,  -149335208, 61710000,  0x864044b},
        {-149342000, 61506000,  -148953359, 61706435,  0x864044b},
        {-135505599, 56956340,  -135154402, 57149659,  0x864044b},
        {-131809018, 55256140,  -131471783, 55449459,  0x864044b},
        {-152491399, 59859405,  -147188601, 62540595,  0x0a80011},
        {-134593907, 54612705,  -129976302, 57293895,  0x001000d},
        {-137000562, 56136486,  -132204211, 58817676,  0x0010015},
        {-141000000, 58350000,  -134100000, 60360000,  0x07d0091},
        {-161020000, 70332000,  -147280000, 71425000,  0x0510891},
        {-147955732, 67622347,  -140954847, 70333328,  0x0a81091},
        {-154956617, 67622347,  -147955732, 70333328,  0x0a81891},
        {-160923000, 67100000,  -154956617, 70333329,  0x0c42091},
        {-166890000, 67100000,  -160923000, 70333329,  0x0c42891},
        {-147300032, 64911366,  -140954549, 67622347,  0x0a73091},
        {-153645515, 64911366,  -147300032, 67622347,  0x0a73891},
        {-159990998, 64911366,  -153645515, 67622347,  0x0a74091},
        {-168130000, 64911366,  -159990998, 67100000,  0x0854891},
        {-146756645, 62200385,  -140977191, 64911366,  0x0a85091},
        {-152536099, 62200385,  -146756645, 64911366,  0x0a85891},
        {-158315553, 62200385,  -152536099, 64911366,  0x0a86091},
        {-164095007, 62200385,  -158315553, 64911366,  0x0a86891},
        {-169874461, 62200385,  -164095007, 64911366,  0x0a87091},
        {-173500000, 60100000,  -169850000, 63850000,  0x0f07891},
        {-146333970, 59489405,  -141001381, 62200386,  0x0a88091},
        {-151666559, 59489405,  -146333970, 62200386,  0x0a88891},
        {-156999148, 59489405,  -151666559, 62200386,  0x0a89091},
        {-162331737, 59489405,  -156999148, 62200386,  0x0a89891},
        {-167664326, 59489405,  -162331737, 62200386,  0x0a8a091},
        {-152396081, 57330000,  -146240000, 59489405,  0x087a891},
        {-157341387, 56820000,  -152396081, 59489405,  0x0a6b091},
        {-162286693, 56820000,  -157341387, 59489405,  0x0a6b891},
        {-172028350, 55437829,  -167351163, 58119019,  0x0a8c091},
        {-162750000, 55440000,  -153600000, 56820000,  0x056c891},
        {-167250000, 53954000,  -159110000, 55440000,  0x05dd091},
        {-172000000, 52100000,  -165900000, 54032000,  0x078d891},
        {-177330000, 51000000,  -172000000, 53200000,  0x088e091},
        {177340000,  51000000,  182670000,  53200000,  0x088e891},
        {172300000,  51000000,  177340000,  53200000,  0x08cf091},
        {172300000,  51000000,  230082000,  71425000,  0x0020217},
        {-123186748, 49208255,  -123056052, 49294745,  0x001000a}, // 3BC
        {-123294400, 49000000,  -122427000, 49381200,  0x018000c},
        {-123561600, 48398700,  -123440371, 48491200,  0x3c1044b},
        {-123443700, 48403000,  -123357301, 48532600,  0x3c1044b},
        {-123357400, 48393000,  -123261686, 48510000,  0x3c1044b},
        {-122393000, 49022000,  -122213504, 49085100,  0x3c1044b},
        {-119505029, 49847000,  -119370971, 49933489,  0x3c1004b},
        {-124035088, 49105200,  -123903913, 49191689,  0x3c1004b},
        {-124103288, 49191000,  -123933210, 49257600,  0x3c1044b},
        {-122836075, 53829400,  -122724303, 53941789,  0x3c1044b},
        {-122002088, 49094000,  -121900943, 49206089,  0x3c1044b},
        {-125291900, 49949000,  -125202761, 50078989,  0x3c1044b},
        {-130354400, 54212000,  -130251432, 54335400,  0x3c1044b},
        {-124476560, 49303900,  -124274391, 49360589,  0x3c1044b},
        {-128672716, 54488900,  -128480243, 54554889,  0x3c1044b},
        {-117818988, 49065000,  -117614376, 49120400,  0x3c1044b},
        {-120431650, 50634300,  -120296150, 50720789,  0x3c1004b},
        {-119342429, 50216500,  -119208371, 50302989,  0x3c1004b},
        {-119651209, 49437400,  -119518592, 49523889,  0x3c1004b},
        {-125033309, 49636600,  -124900692, 49723089,  0x3c1004b},
        {-115830109, 49457600,  -115697492, 49544089,  0x3c1004b},
        {-120908880, 56201300,  -120753920, 56287789,  0x3c1004b},
        {-124863388, 49202300,  -124732213, 49288789,  0x3c1004b},
        {-119321650, 50671700,  -119186150, 50758189,  0x3c1004b},
        {-124571109, 49792200,  -124438492, 49878689,  0x3c1004b},
        {-120312119, 55717400,  -120159081, 55803889,  0x3c1004b},
        {-122207532, 52095000,  -122067468, 52181489,  0x3c1004b},
        {-117356809, 49444300,  -117224192, 49530789,  0x3c1004b},
        {-122535973, 52938400,  -122394227, 53024889,  0x3c1004b},
        {-117745088, 49273300,  -117613913, 49359789,  0x3c1004b},
        {-118282671, 50966800,  -118145730, 51053289,  0x3c1004b},
        {-120834827, 50080850,  -120738573, 50142949,  0x2b2004b},
        {-116023592, 49639640,  -115931409, 49699759,  0x29c004b},
        {-123754375, 48747550,  -123661226, 48809649,  0x2b2004b},
        {-123450090, 48611550,  -123388936, 48700000,  0x29c044b},
        {-126432497, 48289405,  -122410712, 50970595,  0x0a80011},
        {-122440503, 48986514,  -118388927, 51667704,  0x001000d},
        {-118388926, 48986514,  -114337350, 51667704,  0x0010015},
        {-139100000, 48260000,  -114050000, 60000000,  0x3130016},
        {-139100000, 48260000,  -114050000, 60000000,  0x0020217},
        {-114104678, 51007190,  -114007922, 51068299,  0x2a7004a}, // 3AB
        {-113578649, 53499690,  -113475952, 53560799,  0x2a7004a},
        {-114333802, 50848520,  -113791799, 51194479,  0xf040047},
        {-113802544, 53353100,  -113246256, 53687989,  0xe890047},
        {-113951264, 52195120,  -113708737, 52344879,  0x680004b},
        {-112942671, 49629690,  -112755130, 49751999,  0x54f004b},
        {-110804890, 49973390,  -110615311, 50095699,  0x54f004b},
        {-118911881, 55128590,  -118698519, 55250899,  0x54f004b},
        {-111505098, 56652190,  -111282903, 56774499,  0x54f004b},
        {-114111128, 51230590,  -113917472, 51352899,  0x54f004b},
        {-114043185, 53467890,  -113840016, 53590199,  0x54f004b},
        {-113590985, 53240890,  -113387816, 53363199,  0x54f004b},
        {-113275274, 53680390,  -113069727, 53802699,  0x54f004b},
        {-110206085, 53239590,  -110002916, 53361899,  0x54f004b},
        {-112899326, 52941990,  -112698875, 53064299,  0x54f004b},
        {-111994609, 50502890,  -111802991, 50625199,  0x54f004b},
        {-110317563, 54378090,  -110109637, 54500399,  0x54f004b},
        {-113835937, 52407190,  -113637864, 52529499,  0x54f004b},
        {-113477126, 52908390,  -113276675, 53030699,  0x54f004b},
        {-115375788, 48998005,  -111324212, 51679195,  0x0a80011},
        {-115494952, 51679195,  -111205048, 54360385,  0x001000d},
        {-115614116, 54360385,  -111056093, 57041575,  0x0010015},
        {-120000000, 48998000,  -110000000, 60000000,  0x0010016},
        {-120000000, 48998000,  -110000000, 60000000,  0x0020217},
        {-79439582,  43622755,  -79320418,  43709245,  0x001000a}, // 3ON
        {-79846600,  43439000,  -79120680,  43912800,  0x01c000c},
        {-75754500,  45404300,  -75582886,  45466000,  0x3c1044b},
        {-75582886,  45424000,  -75435625,  45495900,  0x3c1044b},
        {-75820373,  45317811,  -75697847,  45404300,  0x3c1044b},
        {-75697847,  45317811,  -75575321,  45404300,  0x3c1044b},
        {-79934701,  43185600,  -79816499,  43272089,  0x3c1004b},
        {-79816499,  43185600,  -79698297,  43272089,  0x3c1004b},
        {-80551601,  43408600,  -80433399,  43495089,  0x3c1004b},
        {-81364621,  42937200,  -81247380,  43023689,  0x3c1004b},
        {-81247380,  42937200,  -81130139,  43023689,  0x3c1004b},
        {-79283200,  43106000,  -79199561,  43228189,  0x3c1044b},
        {-83072940,  42240400,  -82956660,  42326889,  0x3c1004b},
        {-78987082,  43847400,  -78867919,  43933889,  0x3c1004b},
        {-78897709,  43856049,  -78778546,  43942538,  0x3c1004b},
        {-79850501,  43320000,  -79732299,  43406489,  0x3c1004b},
        {-80375201,  43336000,  -80269545,  43432700,  0x3c1044b},
        {-79744482,  44337900,  -79624118,  44424389,  0x3c1004b},
        {-80324001,  43500500,  -80205799,  43586989,  0x3c1004b},
        {-76605182,  44207800,  -76472168,  44285989,  0x3c1044b},
        {-81032500,  46457500,  -80897951,  46537700,  0x3c1044b},
        {-89306180,  48362700,  -89195346,  48463800,  0x3c1044b},
        {-80326101,  43107200,  -80207899,  43193689,  0x3c1004b},
        {-79121582,  43809800,  -79002419,  43896289,  0x3c1004b},
        {-79157001,  43061700,  -79038799,  43148189,  0x3c1004b},
        {-82443021,  42935200,  -82325780,  43021689,  0x3c1004b},
        {-75942663,  45271900,  -75820137,  45358389,  0x3c1004b},
        {-78400182,  44256800,  -78279818,  44343289,  0x3c1004b},
        {-84404465,  46494600,  -84238066,  46559400,  0x3c1044b},
        {-77445382,  44131200,  -77325018,  44217689,  0x3c1004b},
        {-79295990,  42961150,  -79211811,  43023249,  0x2b2004b},
        {-79489320,  46277340,  -79402481,  46337459,  0x29c004b},
        {-74778600,  45009674,  -74676844,  45062749,  0x2b2044b},
        {-82231714,  42376640,  -82150887,  42436759,  0x29c004b},
        {-81378975,  48446350,  -81285826,  48508449,  0x2b2004b},
        {-77614833,  44080840,  -77531167,  44140959,  0x29c004b},
        {-81799295,  42590583,  -78164793,  45271773,  0x0a80011},
        {-81858877,  45195673,  -78166000,  47876863,  0x0010015},
        {-78166000,  43837500,  -74318000,  46150000,  0x01c000d},
        {-95157000,  41676000,  -79499000,  57000000,  0x4300016},
        {-95157000,  41676000,  -74318000,  57000000,  0x0020217},
        {-73658143,  45470755,  -73536096,  45557245,  0x001000a}, // 3QC
        {-73894304,  45323580,  -73232888,  45814620,  0x001000c},
        {-71397165,  46822400,  -71271035,  46908889,  0x3c1004b},
        {-71271035,  46822400,  -71144905,  46908889,  0x3c1004b},
        {-71397165,  46735911,  -71271035,  46822400,  0x3c1004b},
        {-71271035,  46735911,  -71144905,  46822400,  0x3c1004b},
        {-71308274,  46649422,  -71183345,  46735911,  0x3c1004b},
        {-75814063,  45417400,  -75691537,  45503889,  0x3c1044b},
        {-75691537,  45454200,  -75564421,  45537520,  0x3c1044b},
        {-71995500,  45360000,  -71841864,  45428860,  0x3c1044b},
        {-71283750,  48381600,  -71119996,  48450000,  0x3c1044b},
        {-71138133,  48381600,  -71008399,  48468089,  0x3c1044b},
        {-72622465,  46313700,  -72497536,  46400189,  0x3c1004b},
        {-73328263,  45244300,  -73205737,  45330789,  0x3c1004b},
        {-72551864,  45839500,  -72409983,  45914850,  0x3c1044b},
        {-74070064,  45750000,  -73946337,  45836489,  0x3c1004b},
        {-72791263,  45366800,  -72668737,  45453289,  0x3c1004b},
        {-72779565,  46536200,  -72654636,  46622689,  0x3c1004b},
        {-73008263,  45586600,  -72885737,  45673089,  0x3c1004b},
        {-73246263,  45511700,  -73123737,  45598189,  0x3c1004b},
        {-68593467,  48416600,  -68463733,  48503089,  0x3c1004b},
        {-74004063,  45499700,  -73881537,  45586189,  0x3c1004b},
        {-72025064,  46015200,  -71901337,  46101689,  0x3c1004b},
        {-79057000,  48187900,  -78953880,  48295600,  0x3c1044b},
        {-74191220,  45234430,  -74058366,  45314100,  0x3c1044b},
        {-73174264,  45972800,  -73050537,  46059289,  0x3c1004b},
        {-77870166,  48054600,  -77741634,  48141089,  0x3c1004b},
        {-70717664,  46076900,  -70593937,  46163389,  0x3c1004b},
        {-71702167,  48520000,  -71572433,  48606489,  0x3c1004b},
        {-66433229,  50189500,  -66299171,  50275989,  0x3c1004b},
        {-74061363,  45353600,  -73915377,  45426100,  0x3c1044b},
        {-71377464,  46036400,  -71253737,  46122889,  0x3c1004b},
        {-72203463,  45225800,  -72080937,  45312289,  0x3c1004b},
        {-76000000,  44999000,  -71072386,  47000000,  0x07f0011},
        {-79517700,  45460000,  -76000000,  48280000,  0x021000d},
        {-71875000,  45200000,  -69240000,  48850000,  0x5420015},
        {-80200000,  44999000,  -57103500,  57950000,  0x3400016},
        {-80850000,  57950000,  -63000000,  62610000,  0x0780012},
        {-80850000,  44999000,  -57103500,  62610000,  0x0020217},
        {-106728692, 52106755,  -106589347, 52193245,  0x001000a}, // 3SK
        {-106940131, 51977020,  -106379869, 52322979,  0xf040047},
        {-104835839, 50286400,  -104316761, 50621289,  0xe890047},
        {-105879884, 53141020,  -105631117, 53290779,  0x680004b},
        {-105681464, 50313620,  -105449337, 50463379,  0x680004b},
        {-102613660, 51161320,  -102376541, 51311079,  0x680004b},
        {-107909864, 50223220,  -107677737, 50372979,  0x680004b},
        {-108402320, 52695120,  -108156881, 52844879,  0x680004b},
        {-103106968, 49064620,  -102879833, 49214379,  0x680004b},
        {-103967816, 49588120,  -103738185, 49737879,  0x680004b},
        {-110006985, 53223190,  -109803816, 53345499,  0x54f004b},
        {-105163237, 52155690,  -104965164, 52277999,  0x54f004b},
        {-108548263, 54065990,  -108340337, 54188299,  0x54f004b},
        {-104714426, 52799690,  -104513975, 52921999,  0x54f004b},
        {-102879128, 50874390,  -102685472, 50996699,  0x54f004b},
        {-109992100, 50809405,  -105791569, 53490595,  0x0a80011},
        {-105791569, 50809405,  -101591038, 53490595,  0x001000d},
        {-108100000, 48998000,  -102150000, 50809405,  0x28d0015},
        {-110007000, 48998000,  -101357000, 60000000,  0x0010016},
        {-110007000, 48998000,  -101357000, 60000000,  0x0020217},
        {-97195309,  49852955,  -97061730,  49939445,  0x001000a}, // 3MB
        {-97464752,  49692480,  -96746048,  50183520,  0x001000c},
        {-100083018, 49756810,  -99817783,  49929789,  0x782004b},
        {-98395059,  49877310,  -98126941,  50050289,  0x782004b},
        {-96765718,  49457510,  -96500483,  49630489,  0x782004b},
        {-98003139,  55659810,  -97697062,  55832789,  0x782004b},
        {-98013268,  49100420,  -97786133,  49250179,  0x680004b},
        {-102006160, 54693620,  -101748241, 54843379,  0x680004b},
        {-100168260, 51075220,  -99931141,  51224979,  0x680004b},
        {-98241168,  49119220,  -98014033,  49268979,  0x680004b},
        {-97377864,  50275820,  -97145737,  50425579,  0x680004b},
        {-100404447, 48998000,  -96352871,  51679190,  0x0a80011},
        {-100523611, 51679190,  -96233707,  54360380,  0x001000d},
        {-100642775, 54360380,  -96084752,  57041570,  0x0010015},
        {-102010000, 48998000,  -88926000,  60000000,  0x0010016},
        {-102010000, 48998000,  -88926000,  60000000,  0x0020217},
        {-52792626,  47536455,  -52665774,  47622945,  0x001000a}, // 3NL
        {-53321028,  47322580,  -52633572,  47813620,  0x001000c},
        {-58073176,  48856910,  -57810824,  49029889,  0x782004b},
        {-54673100,  48880000,  -54382629,  48997000,  0x680044b},
        {-55769800,  48922000,  -55447115,  49027300,  0x680044b},
        {-67014320,  52864420,  -66768881,  53014179,  0x680004b},
        {-60548384,  53268200,  -60141446,  53359660,  0x680044b},
        {-58656000,  48491600,  -58364941,  48607079,  0x680044b},
        {-54054280,  48091920,  -53831721,  48241679,  0x680004b},
        {-57516868,  49132120,  -57289733,  49281879,  0x680004b},
        {-55337000,  47108420,  -55118601,  47258179,  0x680004b},
        {-55284300,  46985020,  -55065901,  47134779,  0x680004b},
        {-56472835,  46600005,  -52600005,  49281195,  0x0a80011},
        {-59484705,  47484797,  -55552293,  50165987,  0x001000d},
        {-57625000,  49281000,  -53559900,  51800000,  0x0010015},
        {-68006000,  51550000,  -52600000,  60777500,  0x0a90012},
        {-69053000,  43330000,  -52600000,  60777500,  0x46a0216},
        {-68006000,  46600000,  -52600000,  60777500,  0x0020217},
        {-66120043,  45237255,  -65997996,  45323745,  0x001000a}, // 3NB
        {-66382904,  45127980,  -65721488,  45619020,  0x001000c},
        {-64931474,  45984160,  -64628527,  46195929,  0x931004b},
        {-66720677,  45812940,  -66444123,  46006259,  0x864004b},
        {-65839305,  47537740,  -65554696,  47731059,  0x864004b},
        {-66819147,  47846640,  -66531853,  48039959,  0x864004b},
        {-68404805,  47300840,  -68120196,  47494159,  0x864004b},
        {-65693262,  46935940,  -65411338,  47129259,  0x864004b},
        {-67850000,  44562000,  -63745000,  46778000,  0x0920011},
        {-69053000,  46242000,  -64440000,  48075000,  0x017000d},
        {-69053000,  43330000,  -52600000,  60777500,  0x46a0216},
        {-69053000,  44562000,  -63745000,  48075000,  0x0020217},
        {-63646343,  44615755,  -63525257,  44702245,  0x001000a}, // 3NS
        {-63906096,  44428180,  -63255096,  44919220,  0x001000c},
        {-62800035,  45517740,  -62526166,  45711059,  0x864004b},
        {-60290077,  46072240,  -60013523,  46265559,  0x864004b},
        {-66179076,  43717440,  -65912725,  43910759,  0x864004b},
        {-63425027,  45284210,  -63179973,  45457189,  0x782004b},
        {-61467827,  45512810,  -61222773,  45685789,  0x782004b},
        {-64402628,  45768510,  -64155172,  45941489,  0x782004b},
        {-64202526,  44916410,  -63959875,  45089389,  0x782004b},
        {-65900000,  44200000,  -60935000,  46024000,  0x0780011},
        {-66447101,  43330000,  -61660000,  45020000,  0x015000d},
        {-61660000,  43330000,  -59633507,  47253845,  0x61b0015},
        {-69053000,  43330000,  -52600000,  60777500,  0x46a0216},
        {-66462000,  43330000,  -59633500,  47254000,  0x0020217},
        {-63196865,  46195655,  -63071935,  46282145,  0x001000a}, // 3PE
        {-63841000,  46127400,  -62959336,  46491720,  0x017000c},
        {-62914763,  45954130,  -62504438,  46240959,  0xc73004b},
        {-64253000,  46675600,  -63973045,  47064800,  0xbde044b},
        {-62429000,  46250400,  -61970751,  46486000,  0xbde044b},
        {-64437000,  45944000,  -61900000,  47150000,  0x08b0011},
        {-69053000,  43330000,  -52600000,  60777500,  0x46a0216},
        {-64437000,  45944000,  -61900000,  47150000,  0x0020217},
        {-135173160, 60687500,  -135012300, 60790600,  0x023000a}, // 3YT
        {-135557020, 60498880,  -134614372, 60989920,  0x001000c},
        {-139525398, 63875090,  -138978402, 64119709,  0xa9e004b},
        {-129038322, 59999000,  -128552481, 60243619,  0xa9e004b},
        {-137754258, 60644690,  -137260942, 60889309,  0xa9e004b},
        {-136506543, 61991910,  -136021658, 62220689,  0x9ee004b},
        {-138931399, 59999405,  -133628601, 62680595,  0x0a80011},
        {-133628601, 59999405,  -128325803, 62680595,  0x001000d},
        {-139965146, 62680594,  -134185692, 65361784,  0x0010015},
        {-141026000, 59999000,  -123802000, 69669000,  0x0010016},
        {-141026000, 59999000,  -123802000, 69669000,  0x0020217},
        {-114486217, 62405255,  -114299783, 62491745,  0x001000a}, // 3NT
        {-114906360, 62202980,  -113916840, 62694020,  0x001000c},
        {-116030221, 60701810,  -115681379, 60874789,  0x782004b},
        {-133818262, 68274710,  -133353139, 68447689,  0x782004b},
        {-116198674, 62737010,  -115825327, 62909989,  0x782004b},
        {-121557327, 61736710,  -121196473, 61909689,  0x782004b},
        {-112168000, 59999000,  -111777433, 60113000,  0x680044b},
        {-126953516, 65215720,  -126599085, 65365479,  0x680004b},
        {-133213712, 69354520,  -132791889, 69504279,  0x680004b},
        {-135242844, 68159520,  -134840157, 68309279,  0x680004b},
        {-123543720, 60182320,  -123246281, 60332079,  0x680004b},
        {-119171773, 60427524,  -113779602, 63108714,  0x0a80011},
        {-124534153, 59999000,  -119231355, 62680190,  0x001000d},
        {-136494983, 67020605,  -129762217, 69701795,  0x0010015},
        {-136495000, 59999000,  -101987000, 72050000,  0x30d0016},
        {-136495000, 72000000,  -109800000, 79050000,  0x09e0012},
        {-136495000, 59999000,  -101987000, 78836000,  0x0020217},
        {-68597300,  63706755,  -68404139,  63793245,  0x001000a}, // 3NU
        {-69039200,  63504480,  -67992392,  63995520,  0x001000c},
        {-94287199,  61014810,  -93818201,  61243589,  0x9ee004b},
        {-105351583, 69026460,  -104769217, 69238229,  0x931004b},
        {-83433682,  64059460,  -82951318,  64271229,  0x931004b},
        {-115357642, 67722760,  -114801159, 67934529,  0x931004b},
        {-92353935,  62736260,  -91896866,  62948029,  0x931004b},
        {-71410727,  62409405,  -65631273,  65090595,  0x0a80011},
        {-121070000, 66480000,  -115780000, 69910000,  0x027000d},
        {-102010000, 59995000,  -93340000,  61700000,  0x2580015},
        {-115780000, 61283000,  -61200000,  69920000,  0x2160016},
        {-109910000, 69920000,  -61200000,  83200000,  0x0990012},
        {-121223000, 59995000,  -60732000,  83140000,  0x0020217},
        {72500000,   33864760,  75000000,   37100000,  0x0d20091}, // IND
        {75000000,   33864760,  77500000,   37100000,  0x0d20891},
        {77495479,   33864760,  80500000,   36545950,  0x0ae1091},
        {73426660,   31183570,  76554715,   33864760,  0x0a81891},
        {76554715,   31183570,  79682770,   33864760,  0x0a82091},
        {82608667,   23188563,  85498394,   25869753,  0x0a92891},
        {85498394,   23188563,  88388000,   25869753,  0x0a93091},
        {82669712,   20507373,  85529648,   23188563,  0x0a83891},
        {85529648,   20507373,  88388000,   23188563,  0x0a84091},
        {88388000,   20507373,  89100000,   25869753,  0x1dd4891},
        {68370032,   20507373,  71229968,   23188563,  0x0a85091},
        {71229968,   20507373,  74089904,   23188563,  0x0a85891},
        {74089904,   20507373,  76949840,   23188563,  0x0a86091},
        {76949840,   20507373,  79809776,   23188563,  0x0a86891},
        {79809776,   20507373,  82669712,   23188563,  0x0a87091},
        {72600000,   18094000,  75500000,   20507373,  0x09d7891},
        {75500000,   18094000,  78400000,   20507373,  0x09d8091},
        {78400000,   18094000,  81300000,   20507373,  0x09d8891},
        {81300000,   18094000,  84200000,   20507373,  0x09d9091},
        {84200000,   18094000,  87100000,   20507373,  0x09d9891},
        {72800000,   15547171,  75600000,   18094000,  0x0a3a091},
        {75600000,   15547171,  78400000,   18094000,  0x0a3a891},
        {78400000,   15547171,  81200000,   18094000,  0x0a3b091},
        {81200000,   15547171,  84000000,   18094000,  0x0a3b891},
        {73454123,   12865982,  76194895,   15547172,  0x0a8c091},
        {76194895,   12865982,  78935667,   15547172,  0x0a8c891},
        {78935667,   12865982,  81676439,   15547172,  0x0a8d091},
        {74371790,   10640595,  77520000,   12865982,  0x08ed891},
        {77520000,   10640595,  80668000,   12865982,  0x08ee091},
        {74839405,   7959405,   77520000,   10640595,  0x0a9e891},
        {77520000,   7959405,   79915000,   10640595,  0x0b3f091},
        {72077876,   28502380,  75124004,   31183570,  0x001508d},
        {75127726,   28502380,  78166408,   31183570,  0x001588d},
        {78166408,   28502380,  81205090,   31183570,  0x001608d},
        {69450000,   25869753,  72100717,   28310000,  0x001688d},
        {72115613,   25869753,  75064922,   28550943,  0x001708d},
        {75064922,   25869753,  78014231,   28550943,  0x001788d},
        {78014231,   25869753,  80963540,   28550943,  0x001808d},
        {80963540,   25869753,  83912849,   28550943,  0x001888d},
        {83912849,   25869753,  86862158,   28550943,  0x001908d},
        {86862158,   25869753,  89811467,   28550943,  0x001988d},
        {68160032,   23188563,  71049759,   25869753,  0x001a88d},
        {71049759,   23188563,  73939486,   25869753,  0x001b08d},
        {73939486,   23188563,  76829213,   25869753,  0x001b88d},
        {76829213,   23188563,  79718940,   25869753,  0x001c08d},
        {79718940,   23188563,  82608667,   25869753,  0x001c88d},
        {94436900,   26808169,  97416000,   29489359,  0x001d88d},
        {91457800,   26808169,  94436900,   29489359,  0x001d08d},
        {89781676,   24245000,  92701194,   26919000,  0x001e08d},
        {92701194,   24245000,  95620712,   26919000,  0x001e88d},
        {91126000,   21930000,  94324762,   24245000,  0x01bf08d},
        {71660809,   9770405,   74371790,   12451595,  0x001288d},
        {92200000,   11130000,  94320000,   14333000,  0x026308d},
        {92190000,   6730000,   93970000,   11000000,  0x030388d},
        {74450000,   28502380,  75450000,   31183570,  0x001408d},
        {67050143,   5900143,   97416000,   37299857,  0x0010217},
        {112700000,  -54780000, 159267000,  -9182000,  0x0010017}, // AUS
        {-74010000,  -33750000, -32378000,  5280000,   0x0010017}, // BRA
        {172300000,  17821000,  295454000,  71425000,  0x2880017}, // USA
        {-92550386,  16069405,  -89779823,  18750595,  0x001188d}, // MEX
        {-92580177,  18750595,  -89779823,  21431785,  0x001108d},
        {-89779823,  17570871,  -86979469,  20252061,  0x001208d},
        {-89779823,  20252061,  -86600000,  21800000,  0x016088d},
        {-118403860, 28309343,  -116586609, 29918057,  0x001288d},
        {-112669677, 17783805,  -109869323, 20464995,  0x001308d},
        {-116119377, 17034705,  -113319023, 19715895,  0x001388d},
        {-91632058,  21827524,  -89338151,  23972476,  0x001408d},
        {-93436600,  16069405,  -90958000,  18790000,  0x021488d},
        {-117320000, 31785945,  -112189000, 32719000,  0x04d0091},
        {-116774659, 29104755,  -113735977, 31785945,  0x0a90891},
        {-113735977, 29104755,  -110697295, 31785945,  0x0a91091},
        {-110697295, 29104755,  -107658613, 31785945,  0x0a91891},
        {-107658613, 29104755,  -104619931, 31785945,  0x0a92091},
        {-104619931, 28960000,  -100400000, 30000000,  0x0592891},
        {-116440999, 26423566,  -113461899, 29104756,  0x0a83091},
        {-113461899, 26423566,  -110482799, 29104756,  0x0a83891},
        {-110482799, 26423566,  -107503699, 29104756,  0x0a84091},
        {-107503699, 26423566,  -104524599, 29104756,  0x0a84891},
        {-104524599, 26423566,  -101545499, 29104756,  0x0a85091},
        {-101545499, 26423566,  -98566399,  29104756,  0x0a85891},
        {-113610855, 23742376,  -110691337, 26423566,  0x0a86091},
        {-110730000, 22800001,  -108748963, 26423566,  0x0ed6891},
        {-108748963, 23742376,  -105829445, 26423566,  0x0a87091},
        {-105829445, 23742376,  -102909927, 26423566,  0x0a87891},
        {-102909927, 23742376,  -99990409,  26423566,  0x0a88091},
        {-99990409,  23742376,  -97070891,  26423566,  0x0a88891},
        {-106879876, 21061186,  -104019940, 23742376,  0x0a99091},
        {-104019940, 21061186,  -101160004, 23742376,  0x0a99891},
        {-101160004, 21061186,  -98300068,  23742376,  0x0a9a091},
        {-98300068,  21061186,  -95440132,  23742376,  0x0a9a891},
        {-105763309, 18379996,  -102962955, 21061186,  0x0a9b091},
        {-102962955, 18379996,  -100162601, 21061186,  0x0a9b891},
        {-100162601, 18379996,  -97362247,  21061186,  0x0a9c091},
        {-97362247,  18379996,  -94561893,  21061186,  0x0a9c891},
        {-103633253, 15698806,  -100862690, 18379996,  0x0a8d091},
        {-100862690, 15698806,  -98092127,  18379996,  0x0a8d891},
        {-98092127,  15653001,  -95321564,  18379996,  0x0aae091},
        {-95321564,  16074172,  -92551001,  18755362,  0x0a9e891},
        {-94351867,  14531918,  -91611095,  17213108,  0x0a9f091},
        {-118403860, 14531918,  -86600000,  32719000,  0x0010217},
        {37538581,   55705755,  37691380,   55792245,  0x001000a}, // MOW
        {37174200,   55508961,  37975000,   56000000,  0x001000c},
        {37159175,   55614980,  37987247,   56106020,  0x001688c},
        {37166258,   55123940,  37983914,   55614980,  0x001b08c},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {37160000,   55488191,  37975000,   56020920,  0x0020217},
        {30203400,   59906311,  30400600,   59978850,  0x01a000a}, // SPE
        {29990732,   59630300,  30759500,   60186000,  0x024000c},
        {29424750,   59789000,  30423508,   60244000,  0x0a40010},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {29424750,   59630300,  30759500,   60245000,  0x0020217},
        {20440003,   54666155,  20588958,   54752645,  0x001000a}, // KGD
        {19957692,   54473980,  20754516,   54965020,  0x001000c},
        {20754515,   54424876,  21551339,   54915916,  0x0b00010},
        {19637000,   54316000,  22888000,   55296000,  0x0780011},
        {19637000,   54316000,  22888000,   55296000,  0x0020217},
        {44725548,   43190290,  44843751,   43276780,  0x001000a}, // 7IN
        {44479000,   43173000,  45180000,   43616660,  0x01c000c},
        {44640000,   42613700,  45196000,   43173000,  0x0c90010},
        {36598000,   41183000,  49615000,   51246000,  0x0010216},
        {44479000,   42613700,  45196000,   43616660,  0x0020217},
        {38914000,   44938348,  39015558,   45036000,  0x024000a}, // 7AD
        {38684000,   44805000,  39666000,   45104000,  0x013000c},
        {39907000,   44244994,  40388000,   44907500,  0x0ee0010},
        {37200000,   43383000,  41743000,   45505561,  0x0860011},
        {36598000,   41183000,  49615000,   51246000,  0x0010216},
        {38666000,   43756000,  40774000,   45217500,  0x0020217},
        {44615000,   43000000,  44717951,   43097650,  0x023000a}, // 7SE
        {44343820,   42810000,  44960000,   43301040,  0x001000c},
        {43874853,   42946020,  44343820,   43291979,  0xf04004b},
        {44250000,   43585000,  44858095,   43839000,  0xe89044b},
        {43398000,   42553000,  44960000,   43839000,  0x0b20011},
        {36598000,   41183000,  49615000,   51246000,  0x0010216},
        {43398000,   42553000,  44960000,   43839000,  0x0020217},
        {43535500,   43462000,  43682003,   43526245,  0x017000a}, // 7KB
        {43279312,   43237480,  43919896,   43728520,  0x001000c},
        {43919896,   43237480,  44473900,   43806642,  0x0cc0010},
        {42404370,   42890800,  44473900,   44020070,  0x0910011},
        {36598000,   41183000,  49615000,   51246000,  0x0010216},
        {42404370,   42890800,  44473900,   44020070,  0x0020217},
        {42010000,   44179500,  42088000,   44308800,  0x02f000a}, // 7KC
        {41713104,   44007980,  42358896,   44499000,  0x001000c},
        {41017684,   43824090,  41354715,   44068709,  0xa9e004b},
        {41420184,   43735690,  41757215,   43980309,  0xa9e004b},
        {41743684,   43672090,  42080715,   43916709,  0xa9e004b},
        {42363296,   43835210,  42678503,   44063989,  0x9ee004b},
        {40684800,   43192200,  42682570,   44497110,  0x09f0011},
        {36598000,   41183000,  49615000,   51246000,  0x0010216},
        {40683000,   43191000,  42684000,   44499000,  0x0020217},
        {45644000,   43255000,  45746952,   43352650,  0x023000a}, // 7CE
        {45359312,   43047480,  45999896,   43538520,  0x001000c},
        {45359312,   42556440,  45994688,   43047480,  0x0b00010},
        {44832000,   42473000,  46660000,   44014000,  0x0b40011},
        {36598000,   41183000,  49615000,   51246000,  0x0010216},
        {44832000,   42473000,  46660000,   44014000,  0x0020217},
        {47205000,   56072300,  47362728,   56156000,  0x01e000a}, // 7CU
        {46898080,   55740000,  47833000,   56162000,  0x01b000c},
        {46155608,   54711730,  46649592,   54998559,  0xc73004b},
        {47267117,   55373690,  47744082,   55647109,  0xbde004b},
        {46179817,   55358690,  46656782,   55632109,  0xbde004b},
        {45910000,   54624000,  48423000,   56329000,  0x0b60011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {45910000,   54624000,  48423000,   56329000,  0x0020217},
        {40898859,   56951755,  41055502,   57038245,  0x001000a}, // IVA
        {40715552,   56652280,  41564456,   57143320,  0x001000c},
        {41712748,   57165220,  42350851,   57511179,  0xf04004b},
        {40111109,   56754900,  40719491,   57089789,  0xe89004b},
        {39378000,   56351000,  43306500,   57743500,  0x0860011},
        {39378000,   56351000,  43306500,   57743500,  0x0020217},
        {39503947,   52563555,  39645214,   52650045,  0x001000a}, // LIP
        {39304424,   52344180,  40059584,   52835220,  0x001000c},
        {38102105,   52493620,  38669094,   52839579,  0xf04004b},
        {38721077,   52804400,  39269923,   53139289,  0xe89004b},
        {37724000,   51887000,  40772600,   53589600,  0x09f0011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {37724000,   51887000,  40772600,   53589600,  0x0020217},
        {36020447,   52924355,  36161714,   53010845,  0x001000a}, // ORL
        {35679716,   52625780,  36445292,   53116820,  0x001000c},
        {36397830,   53159290,  36804170,   53403909,  0xa9e004b},
        {37375126,   52323690,  37771273,   52568309,  0xa9e004b},
        {35815830,   53316090,  36222170,   53560709,  0xa9e004b},
        {37154328,   52720310,  37529272,   52949089,  0x9ee004b},
        {34791000,   51935000,  38064000,   53644000,  0x09b0011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {34791000,   51935000,  38064000,   53644000,  0x0020217},
        {37512964,   54142755,  37659997,   54229245,  0x001000a}, // TUL
        {37197200,   53884380,  37983608,   54375420,  0x001000c},
        {38115484,   53810630,  38597516,   54097459,  0xc73004b},
        {36961493,   54391490,  37426306,   54664909,  0xbde004b},
        {37865552,   53526190,  38325048,   53799609,  0xbde004b},
        {35895000,   52955000,  38958000,   54863000,  0x0ab0011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {35895000,   52955000,  38958000,   54863000,  0x0020217},
        {36516930,   50550755,  36652431,   50637245,  0x001000a}, // 7BE
        {36211240,   50350480,  36945568,   50841520,  0x001000c},
        {37463000,   51131000,  37819106,   51397000,  0xa9e044b},
        {37819106,   51106000,  38144575,   51397000,  0xa9e044b},
        {36988881,   50680190,  37372118,   50924809,  0xa9e044b},
        {38332000,   50541000,  38752320,   50736000,  0x9ee044b},
        {35325000,   49794000,  39277700,   51437700,  0x0860011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {35325000,   49794000,  39277700,   51437700,  0x0020217},
        {40335281,   56096755,  40488080,   56183245,  0x001000a}, // VLA
        {39882360,   55963956,  40710432,   56454996,  0x001000c},
        {40920000,   56300000,  41477601,   56420000,  0x864044b},
        {41896971,   55436141,  42234206,   55629460,  0x864004b},
        {40539000,   55422000,  40791612,   55680000,  0x864044b},
        {38510039,   56264510,  38819960,   56437489,  0x782004b},
        {39360000,   55880000,  39746658,   56016845,  0x782044b},
        {41962158,   56136060,  42272079,   56309039,  0x782004b},
        {38711440,   56058868,  39017517,   56231847,  0x782004b},
        {38272000,   55111000,  42967000,   56811000,  0x0860011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {38272000,   55111000,  42980000,   56820000,  0x0020217},
        {36097808,   51694377,  36236192,   51780867,  0x001000a}, // KRS
        {35792024,   51470480,  36541976,   51961520,  0x001000c},
        {35029767,   52146966,  35425914,   52391585,  0xa9e004b},
        {34562457,   51377104,  34949771,   51621723,  0xa9e004b},
        {35168000,   51573000,  35811498,   51722000,  0xa9e044b},
        {36718359,   51755710,  37085041,   51984489,  0x9ee004b},
        {34080500,   50910000,  38518000,   52442000,  0x07c0011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {34080500,   50900000,  38555000,   52442000,  0x0020217},
        {36210564,   54495000,  36365069,   54574500,  0x01c000a}, // KLU
        {35816292,   54361380,  36613116,   54852420,  0x001000c},
        {36363208,   54954130,  36857192,   55240959,  0xc73004b},
        {34200000,   53805000,  34573737,   54141000,  0xbde044b},
        {35300000,   53921000,  35873387,   54140000,  0xbde044b},
        {33431500,   53276500,  37274000,   55351500,  0x09f0011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {33431500,   53276500,  37274000,   55351500,  0x0020217},
        {41364500,   52672755,  41482983,   52772000,  0x024000a}, // 7TT
        {41244000,   52435000,  42072441,   52867000,  0x01c000c},
        {40302467,   52780160,  40649533,   52991929,  0x931004b},
        {42226897,   51796572,  42536745,   51989891,  0x864044b},
        {41200000,   53117803,  41604994,   53271000,  0x864044b},
        {41421000,   51684000,  41714547,   51888000,  0x864044b},
        {42672472,   52786560,  42989301,   52979879,  0x864044b},
        {41718000,   53308000,  41956302,   53568359,  0x864044b},
        {39923000,   51590000,  43252000,   53823000,  0x0ae0011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {39910000,   51590000,  43252000,   53823000,  0x0020217},
        {34309000,   53217656,  34400941,   53285000,  0x2a7044a}, // BRY
        {34244098,   53285000,  34342169,   53348143,  0x2a7044a},
        {33963708,   53014180,  34739700,   53505220,  0x001000c},
        {32027028,   52629910,  32401972,   52858689,  0x9ee004b},
        {31667000,   52406000,  32045074,   52598000,  0x931044b},
        {32520467,   52731660,  32867533,   52943429,  0x931044b},
        {33900355,   53689860,  34256245,   53901629,  0x931044b},
        {34072755,   53488360,  34428645,   53700129,  0x931044b},
        {31243000,   51842000,  35331000,   54043000,  0x09c0011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {31243000,   51842000,  35331000,   54043000,  0x0020217},
        {39763237,   57561755,  39906800,   57653825,  0x021000a}, // YAR
        {39464548,   57503120,  40102651,   57849079,  0xf040047},
        {38595000,   57925000,  39346403,   58203989,  0xe890447},
        {38158279,   57307930,  38687320,   57594759,  0xc73004b},
        {39120044,   57061390,  39616756,   57334809,  0xbde004b},
        {38598144,   56633890,  39094856,   56907309,  0xbde004b},
        {37077000,   56531000,  41207500,   59160000,  0x0b40011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {37077000,   56531000,  41207500,   59160000,  0x0020217},
        {39633330,   54582200,  39798000,   54657529,  0x01b000a}, // RYA
        {39141603,   54460000,  40116016,   54850520,  0x019000c},
        {39854962,   53594910,  40239438,   53823689,  0x9ee004b},
        {41753000,   54147500,  42035896,   54416845,  0x931044b},
        {41105300,   54847000,  41554024,   55019000,  0x931044b},
        {38791935,   54170000,  39188816,   54362000,  0x931044b},
        {39344855,   53721960,  39700745,   53933729,  0x931004b},
        {38669670,   53311800,  42705000,   55352700,  0x09a0011},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {38660000,   53311800,  42705000,   55370000,  0x0020217},
        {47962535,   46306700,  48099087,   46383800,  0x01b000a}, // AST
        {47691688,   46038376,  48358312,   46529416,  0x001000c},
        {45697227,   47986471,  46389891,   48477511,  0x0b10010},
        {44969730,   46443380,  49040000,   48865100,  0x01c000d},
        {45838527,   45189350,  49615000,   47850000,  0x0a80011},
        {36598000,   41183000,  49615000,   51246000,  0x0010216},
        {44969730,   45000000,  49615000,   48867000,  0x0020217},
        {37538581,   55705755,  37691380,   55792245,  0x001000a}, // MOS
        {37174200,   55508961,  37975000,   56000000,  0x001000c},
        {37468000,   55340000,  37621388,   55510000,  0x54f044b},
        {38067000,   55540000,  38317728,   55644000,  0x54f044b},
        {38687178,   55023090,  38897822,   55145399,  0x54f044b},
        {38390000,   55725000,  38541127,   55900000,  0x54f044b},
        {37276178,   54873000,  37516737,   54980099,  0x54f044b},
        {38824490,   55772000,  39125153,   55860000,  0x54f044b},
        {37974000,   55860890,  38190419,   55983199,  0x54f044b},
        {37949000,   56235000,  38192486,   56345000,  0x54f044b},
        {36649220,   56296600,  36958980,   56383089,  0x54f044b},
        {37397562,   55097800,  37699158,   55184289,  0x54f044b},
        {38637000,   55255000,  38759145,   55361789,  0x3c1044b},
        {36653462,   55349200,  36804338,   55435689,  0x3c1044b},
        {37787000,   56000000,  37939082,   56087000,  0x3c1044b},
        {38964000,   55351800,  39114876,   55438289,  0x3c1044b},
        {37365081,   55993400,  37518119,   56079889,  0x3c1044b},
        {38021523,   54835600,  38170477,   54922089,  0x3c1044b},
        {37446000,   56271900,  37579675,   56372000,  0x3c1044b},
        {38573681,   55740500,  38726719,   55826989,  0x3c1044b},
        {36915620,   56143600,  37070580,   56230089,  0x3c1044b},
        {37975000,   55712000,  38173424,   55778600,  0x3c1044b},
        {38234800,   55692200,  38391978,   55776333,  0x3c1044b},
        {36883360,   56597060,  37721848,   57088100,  0x001088c},
        {37721847,   56597060,  38560335,   57088100,  0x001108c},
        {35231538,   56106020,  36070026,   56597060,  0x001188c},
        {36070026,   56106020,  36908514,   56597060,  0x001208c},
        {36908514,   56106020,  37747002,   56597060,  0x001288c},
        {37747002,   56106020,  38585490,   56597060,  0x001308c},
        {34674959,   55614980,  35503031,   56106020,  0x001508c},
        {35503031,   55614980,  36331103,   56106020,  0x001588c},
        {36331103,   55614980,  37159175,   56106020,  0x001608c},
        {37159175,   55614980,  37987247,   56106020,  0x001688c},
        {37987247,   55614980,  38815319,   56106020,  0x001708c},
        {38815319,   55614980,  39643391,   56106020,  0x001788c},
        {39643391,   55614980,  40471463,   56106020,  0x001888c},
        {34713290,   55123940,  35530946,   55614980,  0x001908c},
        {35530946,   55123940,  36348602,   55614980,  0x001988c},
        {36348602,   55123940,  37166258,   55614980,  0x001a88c},
        {37166258,   55123940,  37983914,   55614980,  0x001b08c},
        {37983914,   55123940,  38801570,   55614980,  0x001b88c},
        {38801570,   55123940,  39619226,   55614980,  0x001c08c},
        {39619226,   55123940,  40436882,   55614980,  0x001c88c},
        {37007935,   54632900,  37815175,   55123940,  0x001d08c},
        {37815175,   54632900,  38622415,   55123940,  0x001d88c},
        {38622415,   54632900,  39429655,   55123940,  0x001e08c},
        {39429655,   54632900,  40236895,   55123940,  0x001e88c},
        {38304727,   54141860,  39101551,   54632900,  0x001f08c},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {35130000,   54254500,  40210000,   56978000,  0x0020217},
        {31971102,   54735455,  32120057,   54821945,  0x001000a}, // SMO
        {31619792,   54518480,  32416616,   55009520,  0x001000c},
        {32640762,   53819610,  33025238,   54048389,  0x9ee004b},
        {34077290,   55088160,  34446710,   55299929,  0x931004b},
        {32507443,   54967860,  32872157,   55179629,  0x931004b},
        {33054043,   55022060,  33418757,   55233829,  0x931004b},
        {30980756,   55496562,  31350176,   55708331,  0x931004b},
        {33495000,   55781206,  34445000,   56071000,  0x016088c},
        {34445000,   55781206,  35400000,   56071000,  0x016108c},
        {30747000,   55290166,  31564656,   55781206,  0x001188c},
        {31557187,   55290166,  32374843,   55781206,  0x001208c},
        {32374843,   55290166,  33192499,   55781206,  0x001288c},
        {33192499,   55290166,  34010155,   55781206,  0x001308c},
        {34010155,   55290166,  34827811,   55781206,  0x001388c},
        {34582344,   55290166,  35400000,   55781206,  0x001408c},
        {30747000,   54799126,  31554240,   55290166,  0x001488c},
        {31551979,   54799126,  32359219,   55290166,  0x001508c},
        {32359219,   54799126,  33166459,   55290166,  0x001588c},
        {33166459,   54799126,  33973699,   55290166,  0x001608c},
        {33973699,   54799126,  34780939,   55290166,  0x001688c},
        {34592760,   54799126,  35400000,   55290166,  0x001708c},
        {30749947,   54308086,  31546771,   54799126,  0x001788c},
        {31546771,   54308086,  32343595,   54799126,  0x001808c},
        {32343595,   54308086,  33140419,   54799126,  0x001888c},
        {33140419,   54308086,  33937243,   54799126,  0x001908c},
        {33937243,   54455398,  34734067,   54946438,  0x001988c},
        {34592760,   54602710,  35400000,   55093750,  0x001a08c},
        {31302360,   53850000,  32088768,   54308086,  0x001a88c},
        {32088768,   53850000,  32875176,   54308086,  0x001b08c},
        {32875176,   53850000,  33700000,   54308086,  0x01db88c},
        {31754000,   53412000,  32532000,   53850000,  0x001c08c},
        {32532000,   53412000,  33310000,   53850000,  0x001c88c},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {30747000,   53412000,  35400000,   56071000,  0x0020217},
        {47437379,   42922655,  47554621,   43009145,  0x001000a}, // 7DA
        {47083212,   42691280,  47718588,   43182320,  0x001000c},
        {46530700,   43083830,  46922700,   43370659,  0xc73004b},
        {48018101,   41954190,  48385698,   42227609,  0xbde004b},
        {46748482,   42662290,  47119117,   42935709,  0xbde004b},
        {45600000,   41184000,  48596880,   44320322,  0x0c60011},
        {45080000,   42314009,  48596880,   44995200,  0x001000d},
        {36598000,   41183000,  49615000,   51246000,  0x0010216},
        {45080000,   41183000,  48598000,   44997000,  0x0020217},
        {39110708,   51629275,  39235000,   51721345,  0x021000a}, // VOR
        {38859024,   51458480,  39608976,   51949520,  0x001000c},
        {41861649,   51293260,  42196950,   51505029,  0x931004b},
        {39090155,   51192840,  39396244,   51386159,  0x864004b},
        {39442455,   50899440,  39748544,   51092759,  0x864004b},
        {39408477,   50089140,  39708122,   50282459,  0x864004b},
        {39670388,   49610040,  39966811,   49803359,  0x864004b},
        {40233177,   50100440,  40532822,   50293759,  0x864004b},
        {38139000,   49825039,  42944000,   52106000,  0x0900011},
        {38139000,   49555000,  42315716,   52106000,  0x01d000d},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {38139000,   49555000,  42944000,   52106000,  0x0020217},
        {31190115,   58506255,  31353485,   58592745,  0x001000a}, // NGR
        {30894820,   58258480,  31780180,   58749520,  0x001000c},
        {33660677,   58277210,  34094722,   58505989,  0x9ee004b},
        {31367772,   59086760,  31775428,   59298529,  0x931004b},
        {33039413,   58329060,  33441186,   58540829,  0x931004b},
        {35556013,   58450460,  35957786,   58662229,  0x931004b},
        {31253165,   57886000,  31795602,   58040500,  0x931044b},
        {29622000,   56917000,  34705456,   59436000,  0x09f0011},
        {29622000,   57533219,  36241000,   59436000,  0x016000d},
        {26672000,   49555000,  48440000,   61615000,  0x0010216},
        {29622000,   56917000,  36241000,   59436000,  0x0020217},
        {28268176,   57763755,  28429624,   57850245,  0x001000a}, // PSK
        {28004336,   57557980,  28868864,   58049020,  0x001000c},
        {30365539,   56227110,  30675460,   56400089,  0x782004b},
        {28175874,   57247710,  28494925,   57420689,  0x782004b},
        {29412612,   57696410,  29735987,   57869389,  0x782004b},
        {29703761,   55920810,  30009838,   56093789,  0x782004b},
        {29749174,   57438410,  30068225,   57611389,  0x782004b},
        {29212839,   56239210,  29522760,   56412189,  0x782004b},
        {28759577,   56933110,  29073823,   57106089,  0x782004b},
        {28937336,   58199220,  29221463,   58348979,  0x680004b},
        {27323000,   58479356,  28020000,   59019500,  0x024008c},
        {28020000,   58479356,  28739576,   59019500,  0x024088c},
        {28739576,   58479356,  29624936,   58970396,  0x001108c},
        {27416743,   57988316,  28291687,   58479356,  0x001188c},
        {28291687,   57988316,  29166631,   58479356,  0x001208c},
        {29166631,   57988316,  30041575,   58479356,  0x001288c},
        {27334457,   57497276,  28198985,   57988316,  0x001308c},
        {28198985,   57497276,  29063513,   57988316,  0x001388c},
        {29063513,   57497276,  29928041,   57988316,  0x001408c},
        {29928041,   57497276,  30792569,   57988316,  0x00