/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#ifndef _SML_XML_ASSM_H_
#define _SML_XML_ASSM_H_

typedef struct SmlXmlAssembler SmlXmlAssembler;

SmlXmlAssembler *smlXmlAssemblerNew(SmlAssembler *assembler, SmlAssemblerFunctions *functions, SmlError **error);

SmlBool smlXmlAssemblerAddHeader(SmlXmlAssembler *assembler, SmlSession *session, SmlError **error);
// FIXME: not yet implemented
// SmlBool smlXmlAssemblerAddCommand(SmlXmlAssembler *assembler, SmlCommand *cmd, SmlError **error);
SmlBool smlXmlAssemblerAddStatus(SmlXmlAssembler *assembler, SmlStatus *status, SmlError **error);
void smlXmlAssemblerFree(SmlXmlAssembler *assm);
// FIXME: not yet implemented
// void smlXmlAssemblerClean(SmlXmlAssembler *assm);
SmlBool smlXmlAssemblerStart(SmlXmlAssembler *assm, SmlSession *session, SmlError **error);
SmlBool smlXmlAssemblerEnd(SmlXmlAssembler *assm, SmlError **error);
SmlBool smlXmlAssemblerRun(SmlXmlAssembler *assm, char **data, unsigned int *size, SmlBool *end, SmlBool final, unsigned int maxsize, SmlError **error);
SmlBool smlXmlAssemblerRunFull(SmlXmlAssembler *assm, char **data, unsigned int *size, SmlBool *end, SmlBool final, SmlBool check, unsigned int maxsize, SmlError **error);

SmlBool smlXmlDevInfAssemble(SmlDevInf *devinf, SmlDevInfVersion version, char **data, unsigned int *size, SmlError **error);

#endif //_SML_XML_ASSM_H_
