/* MenuConfiguration.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.menus;

import java.util.ArrayList;
import java.util.List;

/**
 * Object which describes what a menu looks like.
 */
class MenuConfiguration extends ItemConfiguration {
    
    //
    private String name;

    /**
     * The name of the menu component.
     */
    public String getName() {
        return name;
    }

    /**
     * Set the name of the menu component.
     */
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visitMenu(this);
    }
    
    //
    private final List<EntryConfiguration> entries;
    
    public MenuConfiguration () {
        this.entries = new ArrayList<EntryConfiguration> ();
    }
    
    /**
     * Add an entry to this menu.
     */
    public void add (EntryConfiguration entry) {
        entries.add(entry);
    }
    
    /**
     * Return all entries for this menu.
     */
    public Iterable<EntryConfiguration> getEntries () {
        return this.entries;
    }
}
