/* MenuButtonSupport.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;

/**
 * Provides some common methods for {@link MenuButton}, {@link MenuRadioButton}
 * and {@link MenuCheckboxButton}.
 */
final class MenuButtonSupport {
    
    // Clients should not instantiate this class
    private MenuButtonSupport() {
    }
    
    /**
     * Configure those properties which have not been configured
     * by the standard implementation of {@link configurePropertiesFromAction}.
     */
    static void configureMorePropertiesFromAction(AbstractButton b, Action a) {
        Icon disabledIcon = (Icon) a.getValue (SimpleAction.SMALL_DISABLED_ICON);
        if (disabledIcon != null)
            b.setDisabledIcon(disabledIcon);
        
        ButtonModel buttonModel = (ButtonModel) a.getValue(SimpleAction.TOGGLE_BUTTON_MODEL);
        if (buttonModel != null)
            b.setModel(buttonModel);
    }
    
    /**
     * Create an action property change listener for the given button.
     */
    static PropertyChangeListener createActionPropertyChangeListener(
            AbstractButton b, PropertyChangeListener p) {
        return new ActionPropertyChangeListener (b, p);
    }
    
    /**
     * Property change listener which keeps appearance of button in sync with
     * the action.
     */
    private static class ActionPropertyChangeListener 
        implements PropertyChangeListener {
        
        //
        private final AbstractButton b;
        
        //
        private final PropertyChangeListener parent;
        
        //
        ActionPropertyChangeListener (AbstractButton b, PropertyChangeListener parent) {
            this.b = b;
            this.parent = parent;
        }
        
        //
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (SimpleAction.SMALL_DISABLED_ICON.equals(propertyName)) {
                b.setDisabledIcon((Icon)evt.getNewValue());
                b.invalidate();
                b.repaint();
            } else if (SimpleAction.TOGGLE_BUTTON_MODEL.equals(propertyName)) {
                b.setModel((ButtonModel)evt.getNewValue());
                b.invalidate();
                b.repaint();
            } else {
                // delegate
                parent.propertyChange(evt);
            }
        }
    }
}
