/* Copyright 2004, 2005, 2006 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.security.taglibs.velocity;

import org.springframework.security.Authentication;

import org.springframework.security.acl.AclManager;

import org.springframework.security.taglibs.authz.AclTag;
import org.springframework.security.taglibs.authz.AuthenticationTag;
import org.springframework.security.taglibs.authz.AuthorizeTag;

import org.springframework.security.userdetails.UserDetails;

import org.springframework.context.ApplicationContext;


/**
 * Wrapper the implementation of Spring Security JSP tag includes:
 * {@link AuthenticationTag}, {@link AclTag}, {@link AuthorizeTag}
 *
 * @author Wang Qi
 * @version $Id: Authz.java 2217 2007-10-27 00:45:30Z luke_t $
 */
public interface Authz {
    //~ Methods ========================================================================================================

    /**
     * all the listed roles must be granted to return true, otherwise fasle;
     *
     * @param roles - comma separate GrantedAuthoritys
     *
     * @return granted (true|false)
     */
    boolean allGranted(String roles);

    /**
     * any the listed roles must be granted to return true, otherwise fasle;
     *
     * @param roles - comma separate GrantedAuthoritys
     *
     * @return granted (true|false)
     */
    boolean anyGranted(String roles);

    /**
     * set Spring application context which contains acegi related bean
     *
     * @return DOCUMENT ME!
     */
    ApplicationContext getAppCtx();

    /**
     * return the principal's name, supports the various type of principals that can exist in the {@link
     * Authentication} object, such as a String or {@link UserDetails} instance
     *
     * @return string representation of principal's name
     */
    String getPrincipal();

    /**
     * return true if the principal holds either permission specified for the provided domain object<P>Only
     * works with permissions that are subclasses of {@link org.springframework.security.acl.basic.AbstractBasicAclEntry}.</p>
     *  <p>For this class to operate it must be able to access the application context via the
     * <code>WebApplicationContextUtils</code> and locate an {@link AclManager}.</p>
     *
     * @param domainObject - domain object need acl control
     * @param permissions - comma separate integer permissions
     *
     * @return got acl permission (true|false)
     */
    boolean hasPermission(Object domainObject, String permissions);

    /**
     * none the listed roles must be granted to return true, otherwise fasle;
     *
     * @param roles - comma separate GrantedAuthoritys
     *
     * @return granted (true|false)
     */
    boolean noneGranted(String roles);

    /**
     * get Spring application context which contains acegi related bean
     *
     * @param appCtx DOCUMENT ME!
     */
    void setAppCtx(ApplicationContext appCtx);
}
