#!/usr/bin/ruby -w

require "edtdate"

edt = EDTDate.new
date = "*#{edt.year}-#{edt.day}"
version = ARGV[0]
version =~ /(\d+)\.(\d+).(\d+)/
major = $1
minor = $2
release = $3
files = [
	["README", /^Version: (.*)/, version,
						 /^Date: (.*)/, date],
	["documentation.xml", /^\s*<version>(.*?)<\/version>/, version,
												/^\s*<date>(.*?)<\/date>/, date],
	["rexml/rexml.rb", /^\s*VERSION_MAJOR = (.*)/, major,
										/^\s*VERSION_MINOR = (.*)/, minor,
										/^\s*RELEASE = (.*)/, release,
										/^\s*Date = "(.*)"/, date]
]

for farry in files
	filename = farry.shift
	#`cp #{filename} #{filename}_BAK`
	lines = IO.readlines filename
	while not farry.empty?
		match, replace = farry[0,2]
		farry.shift;farry.shift
		line = lines.find { |l| l =~ match }
		old_ver = Regexp.quote($1)
		line.sub!( /#{old_ver}/, replace )
	end
	fout = File.new( filename, "w+" )
	lines.each { |line| fout << line }
end
