/* -*- C -*-
 * $Id: misc.c,v 1.5 2001/07/02 02:03:09 ttate Exp $
 */

#include "ruby.h"
#include "rbldap.h"

VALUE rb_sLDAP_APIInfo;
VALUE rb_sLDAP_Control;

#ifdef LDAP_OPT_API_INFO
VALUE
rb_ldap_apiinfo_new(LDAPAPIInfo *info)
{
  VALUE info_version, api_version, protocol_version;
  VALUE extensions, vendor_name, vendor_version;
  int i;

  info_version     = INT2NUM(info->ldapai_info_version);
  api_version      = INT2NUM(info->ldapai_api_version);
  protocol_version = INT2NUM(info->ldapai_protocol_version);
  vendor_version   = INT2NUM(info->ldapai_vendor_version);
  vendor_name      = rb_tainted_str_new2(info->ldapai_vendor_name);
  extensions       = rb_ary_new();

  for( i=0; info->ldapai_extensions[i]; i++ ){
    rb_ary_push(extensions, rb_tainted_str_new2(info->ldapai_extensions[i]));
  };

  return rb_struct_new(rb_sLDAP_APIInfo,
		       info_version, api_version, protocol_version,
		       extensions, vendor_name, vendor_version, 0);
};
#endif /* LDAP_OPT_API_INFO */

#ifdef LDAP_OPT_API_INFO
LDAPAPIInfo *
rb_ldap_get_apiinfo(VALUE data)
{
  LDAPAPIInfo *info;
  VALUE r_extensions;
  int len, i;
  char **c_extensions;
  
  info = ALLOC_N(LDAPAPIInfo, 1);
  info->ldapai_info_version =
    FIX2INT(rb_struct_getmember(data, rb_intern("info_version")));
  info->ldapai_api_version =
    FIX2INT(rb_struct_getmember(data, rb_intern("api_version")));
  info->ldapai_protocol_version =
    FIX2INT(rb_struct_getmember(data, rb_intern("protocol_version")));
  r_extensions = rb_struct_getmember(data, rb_intern("extensions"));
  len = RARRAY(r_extensions)->len;
  c_extensions = ALLOCA_N(char*, len);
  for( i=0; i<=len-1; i++ ){
    c_extensions[i] = STR2CSTR(RARRAY(r_extensions)->ptr[i]);
  };
  info->ldapai_extensions = c_extensions;
  info->ldapai_vendor_name =
    STR2CSTR(rb_struct_getmember(data, rb_intern("vendor_name")));
  info->ldapai_vendor_version =
    FIX2INT(rb_struct_getmember(data, rb_intern("vendor_version")));

  return info;
};
#endif /* LDAP_OPT_API_INFO */

#ifdef LDAP_OPT_API_INFO
VALUE
rb_ldap_control_new(LDAPControl *ctl)
{
  int len;
  VALUE val, oid, critical;

  len = ctl->ldctl_value.bv_len;
  if( len > 0 ){
    val = rb_tainted_str_new(ctl->ldctl_value.bv_val, len);
  }
  else{
    val = Qnil;
  };
  oid = rb_tainted_str_new2(ctl->ldctl_oid);
  critical = INT2NUM(ctl->ldctl_iscritical);

  return rb_struct_new(rb_sLDAP_Control,
		       oid, val, critical, 0);
};
#endif /* LDAP_OPT_API_INFO */

#ifdef LDAP_OPT_API_INFO
LDAPControl *
rb_ldap_get_control(VALUE data)
{
  LDAPControl *ctl;

  ctl = ALLOC_N(LDAPControl, 1);

  ctl->ldctl_oid = STR2CSTR(rb_struct_getmember(data, rb_intern("oid")));
  ctl->ldctl_value.bv_len = RSTRING(rb_struct_getmember(data, rb_intern("value")))->len;
  ctl->ldctl_value.bv_val = STR2CSTR(rb_struct_getmember(data, rb_intern("value")));
  ctl->ldctl_iscritical = NUM2INT(rb_struct_getmember(data, rb_intern("iscritical")));

  return ctl;
};
#endif /* LDAP_OPT_API_INFO */

#ifdef LDAP_OPT_API_INFO
LDAPControl **
rb_ldap_get_controls(VALUE data)
{
  LDAPControl **ctls;
  int len, i;

  len = RARRAY(data)->len;
  ctls = ALLOC_N(LDAPControl*, len+1);
  for( i=0; i < len; i++ ){
    ctls[i] = rb_ldap_get_control(rb_ary_entry(data, i));
  };
  ctls[len] = NULL;

  return ctls;
};
#endif /* LDAP_OPT_API_INFO */

void
Init_ldap_misc()
{
  rb_sLDAP_APIInfo = rb_struct_define("APIInfo",
				      "info_version", /* ldapai_xxxx */
				      "api_version",
				      "protocol_version",
				      "extensions",
				      "vendor_name",
				      "vendor_version",
				      0);
  rb_define_const(rb_mLDAP, "APIInfo", rb_sLDAP_APIInfo);

  rb_sLDAP_Control = rb_struct_define("Control",
				      "oid",        /* ldctl_xxx */
				      "value",
				      "iscritical",
				      0);
  rb_define_const(rb_mLDAP, "Control", rb_sLDAP_Control);
};
