/** Copyright  2003 by Jean-Hugues de Raigniac <jhraigniac@workingfrog.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.workingfrog.i18n.swing;

import java.awt.event.ActionEvent;
import java.util.HashMap;

import javax.swing.AbstractAction;
import javax.swing.Icon;

import org.workingfrog.i18n.util.LocaleEvent;
import org.workingfrog.i18n.util.LocaleListener;
import org.workingfrog.i18n.util.Translator;

/**
 * i18n version of javax.swing.AbstractAction
 *
 * @author Jean-Hugues de Raigniac
 */
public class I18NAction extends AbstractAction implements LocaleListener {

    /** bundle */
//    private String bundle = "action";

    /** will probably be removed later */
//    public static final String ACTION = "action";

    /** i18n key */
    private String i18nKey = "action.error";

    private HashMap map = new HashMap();

    /**
     * Default constructor for children.
     */
    public I18NAction () {
        super();
    }

    /**
     * Basic I18NAction. Use default bundle
     *
     * @param i18nKey when I18NAction receive a LocaleEvent
     * Action.NAME value is updated with it
     */
    public I18NAction (String i18nKey) {
        super(i18nKey);
        map.put(NAME, i18nKey);
        putValue(NAME, Translator.checkValue(i18nKey, this));
        Translator.checkKey(i18nKey, this);
//        this.i18nKey = i18nKey;
    }

    /**
     * Basic I18NAction.
     *
     * @param bundle where to find the i18nKey
     * @param i18nKey when I18NAction receive a LocaleEvent
     * Action.NAME value is updated with it
     */
//    public I18NAction (String bundle, String i18nKey) {
//        super(i18nKey);
//        this.bundle = bundle;
//        putValue(NAME, Translator.checkValue(bundle, i18nKey, this));
//Translator.localize(i18nKey, this);
//        Translator.checkKey(i18nKey, this);
//        this.i18nKey = i18nKey;
//    }

    public I18NAction (String i18nKey, Icon icon) {
        this(i18nKey);
        putValue(SMALL_ICON, icon);
    }
    /**
     * I18NAction with an icon.
     *
     * @param bundle where to find the i18nKey
     * @param i18nKey when I18NAction receive a LocaleEvent
     * Action.NAME value is updated with it
     * @param icon Action.SMALL_ICON value
     */
//    public I18NAction (String bundle, String i18nKey, Icon icon) {
//        this(bundle, i18nKey);
//        putValue(SMALL_ICON, icon);
//    }

    /**
     * Allow the use of a customized i18n resource bundle.
     *
     * @param bundle bundle binding
     */
//    public void setBundle (String bundle) {
//        this.bundle = bundle;
//    }

    public void putValue (String key, Object newValue) {
        if (newValue instanceof String) {
            map.put(key, newValue);
            super.putValue(key, Translator.checkValue((String) newValue, this));
        } else {
            super.putValue(key, newValue);
        }
    }

    public Object getValue (String key) {
        if (map.containsKey(key)) {
//            if (key.equals(Action.SHORT_DESCRIPTION)) {
//                return Translator.checkValue((String) map.get(key), this);
//            } else {
                return map.get(key);
//            }
        } else {
            return super.getValue(key);
        }
    }

    /**
     * Used when Action.NAME needs an update.
     *
     * @return a String containing the i18nKey of this I18NAction
     */
    public String getKey () {
        return (String) map.get(NAME);
//        return i18nKey;
    }

    /**
     * Must be implemented by children.
     *
     * @param event The event fired
     */
    public void actionPerformed (ActionEvent event) { /* empty */ }

    /**
     * Updates Action.NAME when a LocaleEvent is fired.
     *
     * @param event contains the new Locale
     */
    public void localeChanged (LocaleEvent event) {
        putValue(NAME, Translator.checkValue((String) map.get(NAME), this));
    }
}
