package org.pietschy.command.demo;

import org.pietschy.command.ActionCommand;
import org.pietschy.command.CommandManager;

import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.*;
import java.net.URL;
import java.net.MalformedURLException;

/**
 * Created by IntelliJ IDEA.
 * User: andrew
 * Date: Mar 28, 2007
 * Time: 4:29:36 PM
 * To change this template use File | Settings | File Templates.
 */
public class OpenUrlCommand extends ActionCommand
{
   protected URL url;

   public OpenUrlCommand(CommandManager commandManager, String commandId, String url)
   {
      super(commandManager, commandId);
      try
      {
         this.url = new URL(url);
      }
      catch (MalformedURLException e)
      {
         throw new RuntimeException("Invalid URL: " + url, e);
      }
      getDefaultFace().setDescription(url);
      export();
   }


   protected void handleExecute()
   {
      try
      {
         BasicService basicService = (BasicService) ServiceManager.lookup(BasicService.class.getName());
         basicService.showDocument(url);
      }
      catch (UnavailableServiceException e)
      {
         JOptionPane.showMessageDialog(getInvokerWindow(), "Oops, I was unable to open the link:\n" + url);
      }
   }
}
