/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: CommandGroupBuilder.java,v 1.3 2006/02/26 00:59:04 pietschy Exp $
 */

package org.pietschy.command;

import org.pietschy.command.log.Logger;
import org.w3c.dom.Element;

import java.util.List;

class
CommandGroupBuilder
extends AbstractCommandBuilder
{
   static final String _ID_ = "$Id: CommandGroupBuilder.java,v 1.3 2006/02/26 00:59:04 pietschy Exp $";

   private static final Logger log = CommandManager.getLogger(CommandGroupBuilder.class);

   public void
   configure(Command command, Element groupElement)
   {
      log.enter("configureMenu");
      log.param("command", String.valueOf(command));

      CommandGroup group = (CommandGroup) command;

      populateProperties(group, groupElement);

      MemberList memberList = group.getMemberList();
      GroupMemberFactory factory = group.getMemberFactory();

      Element membersElement = (Element) Util.getFirstElement(groupElement, Names.GROUP_MEMBERS);


      if (command instanceof ToggleCommandGroup)
      {
         String allowEmptySelection = getAttribute(groupElement, Names.ALOW_EMPTY_SELECTION_ATTRIBUTE);
         ((ToggleCommandGroup) command).setEmptySelectionAllowed("true".equalsIgnoreCase(allowEmptySelection));

         String exclusive = getAttribute(groupElement, Names.EXCLUSIVE_ATTRIBUTE);
         ((ToggleCommandGroup) command).setExclusive("true".equalsIgnoreCase(exclusive));
      }


      if (membersElement != null)
      {
         List children = Util.getElements(membersElement);

         for (int i = 0; i < children.size(); i++)
         {
            Element e = (Element) children.get(i);

            if (e.getTagName().equals(Names.GROUP_MEMBER))
            {
               if (isIncluded(e))
               {
                  String id = getAttribute(e, Names.COMMAND_ID_ATTRIBUTE);
                  String inline = getAttribute(e, Names.INLINE_ATTRIBUTE);
                  if (id != null)
                     memberList.add(factory.createLazyMember(group, id, "true".equals(inline)));
               }
            }
            else if (e.getTagName().equals(Names.SEPARATOR_ELEMENT))
            {
               if (isIncluded(e))
                  memberList.add(factory.createSeparatorMember());
            }
            else if (e.getTagName().equals(Names.GLUE_ELEMENT))
            {
               memberList.add(factory.createGlueMember());
            }
            else if (e.getTagName().equals(Names.EXPANSION_ELEMENT))
            {
               String name = getAttribute(e, Names.NAME_ATTRIBUTE);
               String separator = getAttribute(e, Names.SEPARATOR_ATTRIBUTE);

               boolean includeBefore = "before".equals(separator) || "both".equals(separator);
               boolean includeAfter = "after".equals(separator) || "both".equals(separator);

               ExpansionGroupMember expansionMember = memberList.insertOrGetExpansionPoint();
               expansionMember.setSeparatorBefore(includeBefore);
               expansionMember.setSeparatorAfter(includeAfter);
            }
         }
      }

      memberList.insertOrGetExpansionPoint();
      log.exit("configureMenu");
   }

//
//   private GroupMember
//   buildExclusiveMember(GroupCommand parent, Element exclusiveElement)
//   {
//      CommandManager commandManager = parent.getCommandManager();
//
//      GroupFactory groupFactory = commandManager.getGroupFactory();
//      ToggleGroupCommand eg = groupFactory.createToggleGroup(commandManager);
//
////      eg.copyProperties(parent);
//
//      String allowEmptySelection = getAttribute(exclusiveElement, Names.ALOW_EMPTY_SELECTION_ATTRIBUTE);
//      eg.setEmptySelectionAllowed("true".equalsIgnoreCase(allowEmptySelection));
//
//      MemberList memberList = eg.getMemberList();
//      GroupMemberFactory memberFactory = parent.getMemberFactory();
//
//      List members = Util.getElements(exclusiveElement);
//      for (int i = 0; i < members.size(); i++)
//      {
//         Element e = (Element) members.get(i);
//         String commandId = getAttribute(e, Names.COMMAND_ID_ATTRIBUTE);
//         if (commandId != null)
//         {
//            if (isIncluded(e))
//               memberList.installFace(memberFactory.createLazyMember(eg, commandId, false));
//         }
//      }
//
//      return memberFactory.createInlineMember(parent, eg);
//   }

}
