/*
 * @(#)WriterOutputStream.java    1.0.0 14-May-2001
 *
 * Copyright (C) 2001,,2003 2002 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.io.v1;


import java.io.File;
import java.io.Writer;
import java.io.OutputStream;
import java.io.IOException;


/**
 * Converts from a Writer to an OutputStream.
 *
 * @author   Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since    May 14, 2001
 * @version  $Date: 2003/02/10 22:52:45 $
 */
public class WriterOutputStream extends OutputStream
{
    private Writer w;
    public WriterOutputStream( Writer w )
    {
        this.w = w;
    }
    public void write( int b )
        throws IOException
    {
        this.w.write( b );
    }
    public void write( byte b[], int off, int len )
        throws IOException
    {
        this.w.write( new String( b, off, len ) );
    }
    public void write( byte b[] )
        throws IOException
    {
        this.w.write( new String( b ) );
    }
    public void close()
        throws IOException
    {
        this.w.close();
    }
    public void flush()
        throws IOException
    {
        this.w.flush();
    }
}

