/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.SingleNodeExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xpath.XPathException;

public class AttributeReference
extends SingleNodeExpression {
    private int fingerprint;
    private NameTest test;

    public AttributeReference(int n) {
        this.fingerprint = n;
        this.test = new NameTest(2, n);
    }

    public ItemType getItemType() {
        return NodeKindTest.ATTRIBUTE;
    }

    public NameTest getNameTest() {
        return this.test;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x200000;
    }

    public boolean equals(Object object) {
        return object instanceof AttributeReference && this.fingerprint == ((AttributeReference)object).fingerprint;
    }

    public int hashCode() {
        return ("AttributeReference " + this.fingerprint).hashCode();
    }

    private NodeInfo getElementNode(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is not set");
        }
        if (item instanceof NodeInfo) {
            return (NodeInfo)item;
        }
        return null;
    }

    public NodeInfo getNode(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo = this.getElementNode(xPathContext);
        return this.getAttributeNode(nodeInfo);
    }

    private NodeInfo getAttributeNode(NodeInfo nodeInfo) throws XPathException {
        if (nodeInfo == null) {
            return null;
        }
        if (nodeInfo.getNodeKind() == 1) {
            AxisIterator axisIterator = nodeInfo.iterateAxis((byte)2, this.test);
            return (NodeInfo)axisIterator.next();
        }
        return null;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo = this.getElementNode(xPathContext);
        if (nodeInfo == null) {
            return false;
        }
        if (nodeInfo.getNodeKind() == 1) {
            return nodeInfo.getAttributeValue(this.fingerprint) != null;
        }
        return false;
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo = this.getElementNode(xPathContext);
        if (nodeInfo == null) {
            return "";
        }
        if (nodeInfo.getNodeKind() == 1) {
            String string = nodeInfo.getAttributeValue(this.fingerprint);
            if (string == null) {
                return "";
            }
            return string;
        }
        return "";
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "@" + this.fingerprint);
    }
}

