#include "xmlrpc.h"
#include "mod_xmlrpc_server.h"

void *mod_xmlrpc_server_new(void)
{
	xmlrpc_registry *registry;
	xmlrpc_env env;
	int failed = 0;
                                                                                
	xmlrpc_env_init(&env);
	registry = xmlrpc_registry_new(&env);
	if (env.fault_occurred)
		failed = 1;
	xmlrpc_env_clean(&env);

	if (failed)
		return NULL;

	return (void *) registry;
}

int mod_xmlrpc_server_register(void *registry, char *name, void *method,
		void *user_data, char *sig, char *help)
{
	xmlrpc_env env;
	int failed = 0;

	xmlrpc_env_init(&env);
	xmlrpc_registry_add_method_w_doc(&env, (xmlrpc_registry *) registry,
			NULL, name, (xmlrpc_method) method, user_data, sig,
			help);
	if (env.fault_occurred)
		failed = 1;
	xmlrpc_env_clean(&env);

	return !failed;
}

int mod_xmlrpc_server_parse(void *registry, char *data,
		size_t len, struct mod_xmlrpc_result *r)
{
	xmlrpc_mem_block *output;
	xmlrpc_env env;
	int failed = 0;

	xmlrpc_env_init(&env);
	output = xmlrpc_registry_process_call(&env, (xmlrpc_registry *) registry, NULL, data, len);
	if (env.fault_occurred)
		failed = 1;
	else
		r->result = (void *) output;
	xmlrpc_env_clean(&env);

	return !failed;
}

void mod_xmlrpc_result_free(struct mod_xmlrpc_result *r)
{
	xmlrpc_mem_block_free((xmlrpc_mem_block *) r->result);
}

size_t mod_xmlrpc_result_size(struct mod_xmlrpc_result *r)
{
	return xmlrpc_mem_block_size((xmlrpc_mem_block *) r->result);
}

const char *mod_xmlrpc_result_contents(struct mod_xmlrpc_result *r)
{
	return (const char *) xmlrpc_mem_block_contents((xmlrpc_mem_block *) r->result);
}
