/*-------------------------------------------------------------------------------

Copyright (c) 2001 CerebraSoft

Module Name:

	NTStats.cpp

Abstract:

	Functions to get NT perfomance stats for mod backhand server.

License:

   All rights reserved.

   This product includes software developed at The Center for
   Networking and Distributed Systems at The Johns Hopkins University
   for use in the Backhand project (http://www.cnds.jhu.edu/backhand).
     Creator: Theo Schlossnagle 
     Guidance: Yair Amir

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer. 
 
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
 
  3. All advertising materials mentioning features or use of this
     software must display the following acknowledgment:
     "This product includes software developed by Cerebrasoft
     (http://www.cerebrasoft.com).
        Creator: Rob Butler"

  4. The names "Backhand Broadcaster" and "NT Backhand Broadcaster" must
     not be used to endorse or promote products derived from this
     software without prior written permission. For written permission,
     please contact www.cerebrasoft.com.
 
  5. Products derived from this software may not be called "Backhand Broadcaster"
     or "NT Backhand Broadcaster" nor may "Backhand Broadcaster" or
     "NT Backhand Broadcaster" appear in their names without prior written
     permission. For written permission, please contact www.cerebrasoft.com.
 
  6. Redistributions of any form whatsoever must retain the following
     acknowledgment:
     "This product includes software developed by Cerebrasoft
     (http://www.cerebrasoft.com).
        Creator: Rob Butler"

  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
  ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
  OF THE POSSIBILITY OF SUCH DAMAGE.
---------------------------------------------------------------------------------*/

#include <pdh.h>		// needed to access NT performance data
#include <windows.h>		// needed for many things.
#include "registry.h"		// needed for registry functions
#include "NTServerStats.h"	// needed for server stats structure

/*-------------------------------------------------------------------------------
	Global Variables
---------------------------------------------------------------------------------*/

MEMORYSTATUS GMSts;			// global memory status
HQUERY perfQuery;			// handle to the performance query
HCOUNTER availMemCntr;			// handle to available memory counter
HCOUNTER procQueueCntr;			// handle to the processor queue length counter
HCOUNTER cpuIdleCntr;			// handle to the cpu idle counter
DWORD TotalPhysicalMemory = 0;		// the total physical memory installed

/*-------------------------------------------------------------------------------
bool initStats()

	initializes NT performance counters. 

		Returns true if successful.
---------------------------------------------------------------------------------*/

bool initStats(){

		// Get total physical memory (only need to get once);
	GlobalMemoryStatus(&GMSts);
	TotalPhysicalMemory = GMSts.dwTotalPhys;

		// open NT stats query
	if(PdhOpenQuery(NULL, NULL, &perfQuery) != ERROR_SUCCESS)
		return false;

		// get total available mem (physical only)
	if(PdhAddCounter(perfQuery, "\\Memory\\Available Bytes", NULL, &availMemCntr) != ERROR_SUCCESS){
		PdhCloseQuery(perfQuery);
		return false;
	}

		// get processor queue length counter
	if(PdhAddCounter(perfQuery, "\\System\\Processor Queue Length", NULL, &procQueueCntr) != ERROR_SUCCESS){
		PdhCloseQuery(perfQuery);
		return false;
	}

		// get processor idle % counter
	if(PdhAddCounter(perfQuery, "\\Processor(_Total)\\% Processor Time", NULL, &cpuIdleCntr) != ERROR_SUCCESS){
		PdhCloseQuery(perfQuery);
		return false;
	}

	return true;
}

/*-------------------------------------------------------------------------------
bool closeStats()

	closes NT performance counters. 
	
		Returns true if successful.
---------------------------------------------------------------------------------*/

bool closeStats(){
	if(perfQuery != NULL)
		if(ERROR_SUCCESS != PdhCloseQuery(perfQuery))
			return false;
	return true;
}


/*-------------------------------------------------------------------------------
bool getStats(serverstats &ss)

	Queries NT performance counters.
		
		Returns true if successful. 
---------------------------------------------------------------------------------*/

bool getStats(serverstat *ss){

	PDH_FMT_COUNTERVALUE fv;

	if(ERROR_SUCCESS != PdhCollectQueryData(perfQuery))
		return false;
		
	if(ERROR_SUCCESS != PdhGetFormattedCounterValue(procQueueCntr, PDH_FMT_LONG, NULL, &fv))
		return false;

	ss->load = fv.longValue;

	if(ERROR_SUCCESS != PdhGetFormattedCounterValue(availMemCntr, PDH_FMT_LONG, NULL, &fv))
		return false;

	ss->amem = fv.longValue;

	ss->tmem = TotalPhysicalMemory;

	if(ERROR_SUCCESS != PdhGetFormattedCounterValue(cpuIdleCntr, PDH_FMT_LONG, NULL, &fv))
		return false;

	ss->cpu = (100 - fv.longValue) * 10;	// idle percentage 100% - used percentage
		// we calculate percentage as an int and multiply by 10
		// mod_backhand calculates percentage as a decimal and multiplies by 1000
		// thus we need to multiply by 10 to get our cpu # to match what backhand expects
	return true;
}