//LabPlot : RInterface.h

#ifndef RINTERFACE_H
#define RINTERFACE_H

#include "tests.h"

class RInterface
{
public:
	RInterface();
	double evalCommand(char *cmd, double *data, int size);
	void evalCommandList(char *cmd, double *data, int size);
	double evalCommandValue(char *cmd, double *data, int size,int n);
	void evalTest(RTESTS test, double *data, int size, char *buf);
	void evalTest(RTESTS test, double *data1, double *data2, int size, char *buf);
	void getVal(void* val, char *buf);

	void setMu(double v) { mu=v; }
	double Mu() { return mu; }
	void setAlternative(int v) { alt=v; }
	int Alternative() { return alt; }
	void setPaired(bool v) { paired=v; }
	bool Paired() { return paired; }
	void setEqual(bool v) { equal=v; }
	bool Equal() { return equal; }
	void setConfLevel(double v) { conf_level=v; }
	double ConfLevel() { return conf_level; }
	void setCorrect(bool v) { correct=v; }
	bool Correct() { return correct; }
	void setConfInt(bool v) { conf_int=v; }
	bool ConfInt() { return conf_int; }
	void setRatio(double v) { ratio=v; }
	double Ratio() { return ratio; }
	private:
	double mu;
	int alt;	// 0:"two.sided", 1:"less", 2:"greater"
	bool paired;
	bool equal;
	double conf_level;
	bool correct;
	bool conf_int;
	double ratio;
};

#endif //RINTERFACE_H
