#
# spec file for LabPlot 
# OpenSUSE Build Service edition
#
# Copyright (c) 2007 Stefan Gerlach.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments to stefan.gerlach@uni-konstanz.de
#
# supports :
#	* SUSE 10.X, Factory
#	* Fedora Core 4, 5, 6
#	* Mandriva 2006.0

%define version 1.5.1.5

################################################################################

%if 0%{?suse_version} >= 930
BuildRequires: gcc-c++ qt3-devel kdelibs3-devel ImageMagick-Magick++-devel ImageMagick-devel gsl-devel audiofile-devel libjpeg-devel libjasper ImageMagick-Magick++-devel
Requires: qt3 kdelibs3 ImageMagick-Magick++ gsl audiofile libjasper fftw3 fftw3-threads
%endif

#%if 0%{?sles_version} == 9
#BuildRequires: gcc-c++ qt3-devel kdelibs3-devel ImageMagick-devel gsl-devel audiofile-devel libjpeg-devel libjasper
#Requires: qt3 kdelibs3 ImageMagick-Magick++ gsl audiofile libjasper fftw3 fftw3-threads
#%endif

%if 0%{?mandriva_version} >= 2006
BuildRequires: gcc-c++ qt3-devel kdelibs3-devel libMagick8.4.2-devel gsl-devel audiofile-devel libjpeg-devel libqt3-devel libkdecore4-devel libaudiofile0-devel ImageMagick libjasper1.701_1-devel netcdf-devel libtiff3-devel libgsl0-devel
Requires: qt3 kdelibs3 ImageMagick-Magick++ gsl audiofile libart_lgpl libselinux
%endif

# TODO : test this
%if 0%{?fedora_version} >= 5
BuildRequires: qt-qsa-devel
Requires: qt-qsa
%endif

%if 0%{?fedora_version} == 5
BuildRequires: mesa-libGLU-devel
%endif

%if 0%{?fedora_version} >= 1
BuildRequires: gcc-c++ qt3-devel kdelibs3-devel ImageMagick-devel gsl-devel audiofile-devel libjpeg-devel libexif-devel libart_lgpl-devel libselinux-devel ImageMagick-Magick++-devel
Requires: qt3 kdelibs3 ImageMagick-Magick++ gsl audiofile jasper libjasper1.701_1 libtiff3
%endif

################################################################################
# misc stuff

%define numprocs %(egrep -c ^cpu[0-9]+ /proc/stat)
%define gsl_version	%(gsl-config --version)

################################################################################
################################################################################

Name: 		LabPlot
URL:		http://labplot.sourceforge.net/
Version:	%{version}
Release:	1
Summary:	Function and Data Plotter
Source:		%{name}-%{version}.tar.bz2
Group:		Applications/Engineering	
License:	GPL
Packager:	Stefan Gerlach <stefan.gerlach@uni-konstanz.de>
Vendor:		http://labplot.sourceforge.net/
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

%description
LabPlot is a scientific 2D and 3D data and function plotting program. The
various display and analysis functions are explained in the handbook
(KDE help center).

Authors:
--------
	%{packager}

%prep
%setup

%build
export CFLAGS="-O2 -Wall"
export CXXFLAGS="-O2 -Wall"
%ifarch x86_64 sparc64 ppc64 amd64
export CFLAGS="$CFLAGS -fPIC"
export CXXFLAGS="$CXXFLAGS -fPIC"
%endif

%configure \
--disable-static \
%ifarch x86_64 sparc64 ppc64 amd64
--enable-libsuffix=64 \
%if 0%{?fedora_version} >= 5
--with-qt-libraries=$QTDIR/lib \
%else
--with-qt-libraries=$QTDIR/lib64 \
%endif
%endif
%if "%gsl_version" != "1.6"
--enable-final
%endif

%{__make} -j%{numprocs}

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/%{name}-%{version}
rm -f ../file.list.%{name}

%install
%{__make} DESTDIR="$RPM_BUILD_ROOT" install
cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(755\,root\,root) \%dir ,' > $RPM_BUILD_DIR/file.list.%{name}
find . -type f -o -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.%{name}
# fix manpage names
sed 's/\/labplot.1$/\/labplot.1\*/' $RPM_BUILD_DIR/file.list.%{name} > $RPM_BUILD_DIR/file.list.%{name}.tmp
sed 's/\/LabPlot.1$/\/LabPlot.1\*/' $RPM_BUILD_DIR/file.list.%{name}.tmp > $RPM_BUILD_DIR/file.list.%{name}

%post
/sbin/ldconfig -n %(kde-config --prefix)/%_lib

%postun
/sbin/ldconfig -n %(kde-config --prefix)/%_lib

%files -f ../file.list.%{name}
%doc README TODO BUGS WISHLIST INSTALL ChangeLog CHANGES FEATURES AUTHORS CREDITS LabPlot.lsm

%changelog
* Wed Feb 21 2007 - stefan.gerlach@uni-konstanz.de
- fixed qt-lib path for x86_64
- clean up Requires/BuildRequires
* Wed Jan 10 2007 - stefan.gerlach@uni-konstanz.de
- update to 1.5.1.5
* Wed Apr 12 2006 - gerlach@mbi-berlin.de
- created from LabPlot.spec
