//LabPlot : fit.h
// sync with labplot.qs

#ifndef FIT_H
#define FIT_H

#include "weight.h"

static const char *fit_modelnames[] = {"linear (a*x+b)","exponentiell (a*exp(-b*x)+c)",
	"a*x^b","a+b*ln(x)","1/(a*x+b)","a*x*exp(-b*x)",
	"gaussian (a/(sqrt(2 PI) c)) exp(-(x-b)/(2 c))","maxwell (a v exp(-b v))",
	"planck (a v/(exp(b v)-1))","lorentz (a/((w-b)+c/4))","a exp(b x)+c exp(d x)",
	"a exp(b x)+c exp(d x)+e exp(f x)","user defined",0};

static const char *fit_modelitems[] = {"a*x+b","a*exp(-b*x)+c",
	"a*x^b","a+b*ln(x)","1/(a*x+b)","a*x*exp(-b*x)",
	"a/(c*sqrt(2*pi))*exp(-(x-b)^2/(2*c^2))","a*v^2*exp(-b*v^2))",
	"a*v^3/(exp(b*v)-1)","a/((w-b)^2+c^2/4))","a*exp(b*x)+c*exp(d*x)",
	"a*exp(b*x)+c*exp(d*x)+e*exp(f*x)","a*x+b",0};

enum FModel {MFLINEAR,MEXP,MPOT,MLN,M1L,MEXP2,MGAUSSIAN,MMAXWELL,MPLANCK,MLORENTZ,MMULTIEXP2,MMULTIEXP3,MUSER};

#endif // FIT_H
