/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gnomevfs;

import org.gnu.glib.Flags;

/**
 */
public class VFSFileInfoFields extends Flags {
	
    static final private int _NONE = 0;

    static final public VFSFileInfoFields NONE = new VFSFileInfoFields(_NONE);

    static final private int _TYPE = 1 << 0;

    static final public VFSFileInfoFields TYPE = new VFSFileInfoFields(_TYPE);

    static final private int _PERMISSIONS = 1 << 1;

    static final public VFSFileInfoFields PERMISSIONS = new VFSFileInfoFields(_PERMISSIONS);

    static final private int _FLAGS = 1 << 2;

    static final public VFSFileInfoFields FLAGS = new VFSFileInfoFields(_FLAGS);

    static final private int _DEVICE = 1 << 3;

    static final public VFSFileInfoFields DEVICE = new VFSFileInfoFields(_DEVICE);

    static final private int _INODE = 1 << 4;

    static final public VFSFileInfoFields INODE = new VFSFileInfoFields(_INODE);

    static final private int _LINK_COUNT = 1 << 5;

    static final public VFSFileInfoFields LINK_COUNT = new VFSFileInfoFields(_LINK_COUNT);

    static final private int _SIZE = 1 << 6;

    static final public VFSFileInfoFields SIZE = new VFSFileInfoFields(_SIZE);

    static final private int _BLOCK_COUNT = 1 << 7;

    static final public VFSFileInfoFields BLOCK_COUNT = new VFSFileInfoFields(_BLOCK_COUNT);

    static final private int _IO_BLOCK_SIZE = 1 << 8;

    static final public VFSFileInfoFields IO_BLOCK_SIZE = new VFSFileInfoFields(_IO_BLOCK_SIZE);

    static final private int _ATIME = 1 << 9;

    static final public VFSFileInfoFields ATIME = new VFSFileInfoFields(_ATIME);

    static final private int _MTIME = 1 << 10;

    static final public VFSFileInfoFields MTIME = new VFSFileInfoFields(_MTIME);

    static final private int _CTIME = 1 << 11;

    static final public VFSFileInfoFields CTIME = new VFSFileInfoFields(_CTIME);

    static final private int _SYMLINK_NAME = 1 << 12;

    static final public VFSFileInfoFields SYMLINK_NAME = new VFSFileInfoFields(_SYMLINK_NAME);

    static final private int _MIME_TYPE = 1 << 13;

    static final public VFSFileInfoFields MIME_TYPE = new VFSFileInfoFields(_MIME_TYPE);

    static final private int _ACCESS = 1 << 14;

    static final public VFSFileInfoFields ACCESS = new VFSFileInfoFields(_ACCESS);

    static final private VFSFileInfoFields[] theInterned = new VFSFileInfoFields[] { 
    		NONE, FLAGS, DEVICE, INODE, LINK_COUNT, SIZE, BLOCK_COUNT, IO_BLOCK_SIZE, 
			ATIME, MTIME, CTIME, SYMLINK_NAME, MIME_TYPE, ACCESS };

    static private java.util.Hashtable theInternedExtras;

    static final private VFSFileInfoFields theSacrificialOne = new VFSFileInfoFields(0);

    static public VFSFileInfoFields intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        VFSFileInfoFields already = (VFSFileInfoFields) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new VFSFileInfoFields(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private VFSFileInfoFields(int value) {
        value_ = value;
    }

    public VFSFileInfoFields or(VFSFileInfoFields other) {
        return intern(value_ | other.value_);
    }

    public VFSFileInfoFields and(VFSFileInfoFields other) {
        return intern(value_ & other.value_);
    }

    public VFSFileInfoFields xor(VFSFileInfoFields other) {
        return intern(value_ ^ other.value_);
    }

    public boolean test(VFSFileInfoFields other) {
        return (value_ & other.value_) == other.value_;
    }
}
