/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * eigen.h
 */

#ifndef EIGEN_h
#define EIGEN_h

void balanc(int nm, int n, double **a, int *low, int *igh, double *scale);
void balbak(int nm, int n, int *low, int *igh, double *scale,
	   int m, double **z);
void cdiv(double ar, double ai, double br, double bi, double *cr, double *ci);
void elmhes(int nm, int n, int *low, int *igh, double **a, int *intch);
void eltran(int nm, int n, int *low, int *igh, double **a, int *intch,
	   double **z);

int hqr(int nm, int n, int *low, int *igh, double **h, double *wr, double *wi);
int hqr2(int nm, int n, int *low, int *igh, double **h, double *wr,
	 double *wi, double **z);
/*  8/19/97  BAM 
int lubksb(double **a, int n, int *indx, double *b);
int ludcmp(double **a, int n, int *indx, double *d);
 */
int rg(int nm, int n, double **a, double *wr, double *wi,
       int matz, double **z, int *iv1, double *fv1);




#endif
/* !EIGEN_h */
