/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

#ifndef CONSTANTS_h
#define CONSTANTS_h

/*
 * constants.h
 */


#define		TRUE		1
#define		FALSE		0

/* general error conditions */
#define MINOR_ERROR 1
#define NO_ERROR 0
#define MAJOR_ERROR -1
#define NO_KEY -1


/* tolerance for differentiating between hopf, degen hopf, and resonant sn's */
#define TINY 1.e-6


#include <math.h>
#define		PI		M_PI
#define		TWOPI		(2*M_PI)
#define         HALFPI          (M_PI/2)

#define		MAX_LEN_DS_TITLE	80
#define		MAX_LEN_VARB_NAME	20
#define 	MAX_INT_STR 		12
#define 	MAX_DOUBLE_STR 		30
#define 	MAX_SHORT_STR 		31
#define 	MAX_LONG_STR 		255

#define MAX_PRECISION 17  /* for displaying double data in printf */



#define		MAX_COLORS		256
#define		SYS_COLORS		3
	/* Note: see symbol.h for definition of N_SYS_COLORS */

#define		PHASE_SPACE_VARB	100
#define		PARAMETER_VARB		101
#define		FUNCTION_VARB		102
#define		CBAR_CELL_WIDTH		7


/* default directory labels */
#define DSTOOL_DIR              101
#define DSTOOL_TCL_DIR          102
#define DSTOOL_OOGL_DIR          103
#define DSTOOL_HELP_DIR         105
#define DSTOOL_DATA_DIR         106
#define DSTOOL_COLOR_DIR        107
#define MY_DSTOOL_TCL_DIR       108
#define MY_DSTOOL_OOGL_DIR       109

#define LPDEST          	110
#define PRINTER         	111
#define DSTOOL_PS_PROLOG 	112


/* constants for the Memory object */
#define         COLOR_DIM               3

/* constants for the Memory object types */
#define		TRAJ_MEMORY		1
#define		PARAM_MEMORY		2
#define		FIXPT_MEMORY		3
#define		CONT_MEMORY		4
#define		SEL_PT_MEMORY		5
#define         MULT_MEMORY             6

/* old constants for stopping conditions -- patched in
 * for compatibility with DsTool 2 saved files.  8/19/97 BAM 
 */
#define         OLD_PROP_NSTEP      11
#define         OLD_PROP_FSTOP      12
#define         OLD_PROP_TF         13
#define         OLD_PROP_POINCARE   16


/* constants for the complib subsection */
#define		FORWARD		1
#define		BACKWARD	2
#define		CONTINUE        0  
#define         WORKSPACE       20
#define		PROP_NSTEP	0
#define		PROP_FSTOP	1
#define		PROP_TF   	2
#define		PROP_POINCARE	3
#define		FIXED_STEP	14
#define		VARB_STEP	15
#define		FIXED_STEP_INIT	17
#define		VARB_STEP_INIT	18
#define		DEFAULT_INTEGRATOR	0
#define 	ANALYTIC        101
#define 	FORW_DIFF       102
#define 	CEN_DIFF        103
#define 	MONTE_CARLO     150
#define 	APPROX_INV      151
#define 	EXPLICIT_INV    152
#define		PM		153
#define		MP		154
#define		PM_and_MP	155
#define		PRE_STEP	156
#define		SOLVE_STEP	157
#define		POST_STEP	158
#define TARGET_TOLS 1.0e-3


/* constants for propagation panel fields */
#define		FINITE_DIFFERENCE_STEP_STRING		"Finite diff step: "
#define		STOPPING_ERROR_STRING			"Stopping error: "

/* keys for the windowing system */
#define         MODEL_MENU_ITEM_KEY     123
#define         TWOD_WINDOW_ITEM_KEY    124
#define         INT_MENU_ITEM_KEY       125
#define		VARB_ITEM_KEY		126

/* labels for the data structure objects */
#define		TWOD_DS			223

/* labels for twoD window handles */
#define		CANVAS_HANDLE		301
#define		CANVAS_PW_HANDLE	302
#define		CBAR_CANVAS_HANDLE	303
#define		CBAR_PW_HANDLE		304
#define		CBAR_LT_HANDLE		305
#define		CBAR_RT_HANDLE		306
#define		CBAR_LT_PAN_HANDLE	307
#define		CBAR_RT_PAN_HANDLE	308
#define		PANEL_HANDLE		309
#define		WINDOW_HANDLE		310

/* constants for the configuration of windows */
#define		DEFAULT_WIN_CONFIG	401
#define		SET_WIN_CONFIG		402
#define         NO_LOCATION             403
/* for I/O */
#define         SIZE_OF_DIR_PLUS_FNAME  240
#define         SIZE_OF_DIR             160
#define         SIZE_OF_FNAME           80
#define         SIZE_OF_GEN_INPUT       80

/* for FIXED point stuff */
#define         NEWTON                  0
#define         SECANT                  1
#define         SADDLE                  0
#define         SOURCE                  1
#define         SINK                   -1
#define         SPIRAL_SOURCE           2
#define         SPIRAL_SINK            -2
#define         STAB_MAN                10
#define         UNSTAB_MAN             -10
#define         STAB_MAN2D              20
#define         UNSTAB_MAN2D           -20
#define         INDETERMINATE           5

#endif
/* CONSTANTS_h */
