# $Id: Makefile.PL,v 1.7 2000/08/08 15:47:46 arensb Exp $
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

# NOTE:
# The default prefix may be wrong. Under FreeBSD, for instance, Perl
# is part of the base system, so the prefix is "/usr". This is wrong,
# since this Makefile.PL distinguishes between run-time prefix and
# install-time prefix:
#	perl Makefile.PL PREFIX=/foo	<- run-time prefix
#	make
#	make install PREFIX=/bar	<- install-time prefix
# The above will install this package in /bar (/bar/bin/coldsync,
# etc.), but when it runs, it will think it's in /foo. This is
# important for various package-management utilities (e.g., 'stow',
# the Debian package manager, etc.)

# NOTE:
# The paths in the .packlist generated by "make install" will be based
# on the install-time prefix (see above). Whether this is correct or
# not depends on why, exactly, you're specifying different build-time
# and install-time prefixes.

# XXX - In what version did AUTHOR and ABSTRACT appear?
if ($ExtUtils::MakeMaker::VERSION < 5.4302)
{
	print <<EOT;
This script may print a warning about `AUTHOR' and `ABSTRACT' being
unrecognized. This is harmless.

EOT
}
#'

WriteMakefile(
    'NAME'		=> 'ColdSync',
    'VERSION_FROM'	=> 'ColdSync.pm', # finds $VERSION
    'INSTALLDIRS'	=> 'site',

    'AUTHOR'		=> 'Andrew Arensburger <arensb@ooblick.com>',
    'ABSTRACT'		=> 'Module for writing ColdSync conduits',
#    'NOECHO'		=> '',		# Print commands as they're running

    # Don't build
    'dist'		=> {
		'DIST_DEFAULT'	=> 'distdir',
	},
);

package MY;

# Additional rules to make things work properly with the rest of the
# ColdSync distribution.
sub postamble {
	my $self = shift;

	"RUNPREFIX =	$self->{PREFIX}\n" . <<'EOT';
TOP =		../..
SUBDIR =	perl/ColdSync

include ${TOP}/Make.rules

DISTVNAME =	${DISTDIR}

distfiles-core::	distdir
spotless::		realclean
EOT
}

# post_initialize
# Tweak the installation directories.

# By default, the Makefile is created with hard-coded installation
# paths. This means that you can't specify different paths at
# build-time and install-time. That is,
#	perl Makefile.PL PREFIX=/foo
#	make
#	make install PREFIX=/bar
# won't work: it'll still try to install scripts in /foo/bin.
#	This function corrects this: it runs after the install
# variables have beeen initialized, and fixes them to use "${PREFIX}".
sub post_initialize
{
	my $self = shift;
	my $var;

	foreach $var (qw(INSTALLSITELIB INSTALLSITEARCH SITELIBEXP
		SITEARCHEXP INSTALLSCRIPT INSTALLMAN1DIR INSTALLMAN3DIR))
	{
		$self->{$var} =~ s/^\Q$self->{PREFIX}\E/\${PREFIX}/;
	}
}

# libscan
# Takes a path to a file that is found by init_dirscan and returns
# false if we don't want to include this file in the library. Mainly
# used to exclude RCS, CVS, and SCCS directories from installation.
sub libscan {
	my($self,$path) = @_;
	return '' if $path =~ m:\b(RCS|CVS|SCCS)\b: ;
	return '' if $path =~ /(\.bak|~)$/;
	$path;
}

1;
