/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.lang.reflect.Method;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.ExtensionsTable;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xpath.DOM2Helper;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.SourceTreeManager;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.XMLReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XPathContext
implements ExpressionContext {
    SourceLocator m_saxLocation;
    private Object m_owner;
    private Method m_ownerGetErrorListener;
    private ExtensionsTable m_extensionsTable = new ExtensionsTable();
    private VariableStack m_variableStacks = new VariableStack();
    private DOMHelper m_domHelper = new DOM2Helper();
    private SourceTreeManager m_sourceTreeManager = new SourceTreeManager();
    private ErrorListener m_errorListener;
    private ErrorListener m_defaultErrorListener;
    private URIResolver m_uriResolver;
    public XMLReader m_primaryReader;
    private static XSLMessages m_XSLMessages = new XSLMessages();
    private Stack m_contextNodeLists = new Stack();
    PrefixResolver m_currentPrefixResolver = null;
    private NodeVector m_currentNodes = new NodeVector();
    private NodeVector m_currentExpressionNodes = new NodeVector();
    private Stack m_axesIteratorStack = new Stack();

    public XPathContext() {
    }

    public XPathContext(Object object) {
        this.m_owner = object;
        try {
            this.m_ownerGetErrorListener = this.m_owner.getClass().getMethod("getErrorListener", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    private void assert(boolean bl, String string) throws TransformerException {
        ErrorListener errorListener = this.getErrorListener();
        if (errorListener != null) {
            errorListener.fatalError(new TransformerException(XSLMessages.createMessage(30, new Object[]{string}), (SAXSourceLocator)this.getSAXLocator()));
        }
    }

    public final Node getContextNode() {
        return this.getCurrentNode();
    }

    public final ContextNodeList getContextNodeList() {
        if (this.m_contextNodeLists.size() > 0) {
            return (ContextNodeList)this.m_contextNodeLists.peek();
        }
        return null;
    }

    public final NodeIterator getContextNodes() {
        try {
            ContextNodeList contextNodeList = this.getContextNodeList();
            if (contextNodeList != null) {
                return contextNodeList.cloneWithReset();
            }
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final Node getCurrentExpressionNode() {
        return this.m_currentExpressionNodes.peepOrNull();
    }

    public final Node getCurrentNode() {
        return this.m_currentNodes.peepOrNull();
    }

    public final DOMHelper getDOMHelper() {
        return this.m_domHelper;
    }

    public final ErrorListener getErrorListener() {
        if (this.m_errorListener != null) {
            return this.m_errorListener;
        }
        ErrorListener errorListener = null;
        try {
            if (this.m_ownerGetErrorListener != null) {
                errorListener = (ErrorListener)this.m_ownerGetErrorListener.invoke(this.m_owner, new Object[0]);
            }
        }
        catch (Exception exception) {}
        if (errorListener == null) {
            if (this.m_defaultErrorListener == null) {
                this.m_defaultErrorListener = new DefaultErrorHandler();
            }
            errorListener = this.m_defaultErrorListener;
        }
        return errorListener;
    }

    public ExtensionsTable getExtensionsTable() {
        return this.m_extensionsTable;
    }

    public final PrefixResolver getNamespaceContext() {
        return this.m_currentPrefixResolver;
    }

    public Object getOwnerObject() {
        return this.m_owner;
    }

    public final XMLReader getPrimaryReader() {
        return this.m_primaryReader;
    }

    public SourceLocator getSAXLocator() {
        return this.m_saxLocation;
    }

    public final SourceTreeManager getSourceTreeManager() {
        return this.m_sourceTreeManager;
    }

    public SubContextList getSubContextList() {
        return this.m_axesIteratorStack.isEmpty() ? null : (SubContextList)this.m_axesIteratorStack.peek();
    }

    public final URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public VariableStack getVarStack() {
        return this.m_variableStacks;
    }

    public XObject getVariable(QName qName) throws TransformerException {
        return this.getVarStack().getVariable(this, qName);
    }

    public final void popContextNodeList() {
        this.m_contextNodeLists.pop();
    }

    public final void popCurrentExpressionNode() {
        this.m_currentExpressionNodes.popQuick();
    }

    public final void popCurrentNode() {
        this.m_currentNodes.popQuick();
    }

    public final void popCurrentNodeAndExpression() {
        this.m_currentNodes.popQuick();
        this.m_currentExpressionNodes.popQuick();
    }

    public final void popSubContextList() {
        this.m_axesIteratorStack.pop();
    }

    public final void pushContextNodeList(ContextNodeList contextNodeList) {
        this.m_contextNodeLists.push(contextNodeList);
    }

    public final void pushCurrentExpressionNode(Node node) {
        this.m_currentExpressionNodes.push(node);
    }

    public final void pushCurrentNode(Node node) {
        this.m_currentNodes.push(node);
    }

    public final void pushCurrentNodeAndExpression(Node node, Node node2) {
        this.m_currentNodes.push(node);
        this.m_currentExpressionNodes.push(node2);
    }

    public final void pushSubContextList(SubContextList subContextList) {
        this.m_axesIteratorStack.push(subContextList);
    }

    public void reset() {
    }

    public void setDOMHelper(DOMHelper dOMHelper) {
        this.m_domHelper = dOMHelper;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            throw new IllegalArgumentException("Null error handler");
        }
        this.m_errorListener = errorListener;
    }

    void setExtensionsTable(ExtensionsTable extensionsTable) {
        this.m_extensionsTable = extensionsTable;
    }

    public final void setNamespaceContext(PrefixResolver prefixResolver) {
        this.m_currentPrefixResolver = prefixResolver;
    }

    public void setPrimaryReader(XMLReader xMLReader) {
        this.m_primaryReader = xMLReader;
    }

    public void setSAXLocator(SourceLocator sourceLocator) {
        this.m_saxLocation = sourceLocator;
    }

    public void setSourceTreeManager(SourceTreeManager sourceTreeManager) {
        this.m_sourceTreeManager = sourceTreeManager;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public void setVarStack(VariableStack variableStack) {
        this.m_variableStacks = variableStack;
    }

    public final double toNumber(Node node) {
        return XNodeSet.getNumberFromNode(node);
    }

    public final String toString(Node node) {
        return XNodeSet.getStringFromNode(node);
    }
}

