/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/


package com.sap.dbtech.jdbc;

/**
 *
 */
public class DbsCache
    extends com.sap.dbtech.util.cache.LruCache
{
    private boolean keepStats;
    private int hits;
    private int misses;
    /**
     * creates a new DbsCache
     */
    public
    DbsCache (
        java.util.Properties info)
    {
        super (ParseinfoCache.getSizeProperty (info));
        this.hits = 0;
        this.misses = 0;
        this.setOptions (info);
    }
    /**
     *
     */
    private void
    setOptions (
        java.util.Properties info)
    {
        String kindDecl = info.getProperty (DriverSapDB.cacheName_C);

        if (kindDecl.indexOf('?') >= 0) {
            this.keepStats = true;
        }
        else {
            this.keepStats = false;
        }
    }
    /**
     *
     */
    public void
    use (
        String sqlCmd)
    {
        Object cachedItem;

        cachedItem = this.get (sqlCmd);
        if (cachedItem != null) {
            ++this.hits;
        }
        else {
            ++this.misses;
            this.put (sqlCmd, sqlCmd);
        }
    }
    /**
     *
     */
    protected void
    dumpStats ()
    {
        if (!this.keepStats) {
            //System.out.println ("no stats available");
            return;
        }
        System.out.println ("Dbs cache statistics:");
        System.out.println (this.hits + " hits");
        System.out.println (this.misses + " misses");
        System.out.println ("---------------------------------------------");
    }
}
