/* ===================================================
 * JCommon : a free general purpose Java class library
 * ===================================================
 *
 * Project Info:  http://www.jfree.org/jcommon/index.html
 * Project Lead:  David Gilbert (david.gilbert@object-refinery.com);
 *
 * (C) Copyright 2000-2003, by Object Refinery Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ----------------
 * ObjectUtils.java
 * ----------------
 * (C) Copyright 2003, by Object Refinery Limited.
 *
 * Original Author:  David Gilbert (for Object Refinery Limited);
 * Contributor(s):   -;
 *
 * $Id: ObjectUtils.java,v 1.3 2003/06/03 22:35:18 mungady Exp $
 *
 * Changes
 * -------
 * 25-Mar-2003 : Version 1 (DG);
 *
 */

package org.jfree.util;

/**
 * Useful static utility methods.
 *
 * @author David Gilbert
 */
public class ObjectUtils {

    /**
     * Returns <code>true</code> if the two objects are equal OR both <code>null</code>.
     *
     * @param o1  object 1.
     * @param o2  object 2.
     *
     * @return <code>true</code> or <code>false</code>.
     */
    public static boolean equalOrBothNull(Object o1, Object o2) {

        if (o1 != null) {
            return o1.equals(o2);
        }
        else {
            return (o2 == null);
        }

    }

}
